/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.helpers.TorrentFolderWatcher;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableLifecycleHandler;
import com.aelitis.azureus.core.tag.impl.TagDownloadWithState;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import com.aelitis.azureus.core.tag.impl.TagTypeWithState;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerEvent;
import org.gudy.azureus2.core3.global.GlobalManagerEventListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.GlobalMangerProgressListener;
import org.gudy.azureus2.core3.global.impl.GlobalManagerFileMerger;
import org.gudy.azureus2.core3.global.impl.GlobalManagerHostSupport;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsImpl;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsWriter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtilsListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcherWithException;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTProvider;

public class GlobalManagerImpl
extends DownloadManagerAdapter
implements GlobalManager,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final int LDT_MANAGER_ADDED = 1;
    private static final int LDT_MANAGER_REMOVED = 2;
    private static final int LDT_DESTROY_INITIATED = 3;
    private static final int LDT_DESTROYED = 4;
    private static final int LDT_SEEDING_ONLY = 5;
    private static final int LDT_EVENT = 6;
    private final ListenerManager listeners_and_event_listeners = ListenerManager.createAsyncManager("GM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            if (type == 6) {
                if (_listener instanceof GlobalManagerEventListener) {
                    ((GlobalManagerEventListener)_listener).eventOccurred((GlobalManagerEvent)value);
                }
            } else if (_listener instanceof GlobalManagerListener) {
                GlobalManagerListener target = (GlobalManagerListener)_listener;
                if (type == 1) {
                    target.downloadManagerAdded((DownloadManager)value);
                } else if (type == 2) {
                    target.downloadManagerRemoved((DownloadManager)value);
                } else if (type == 3) {
                    target.destroyInitiated();
                } else if (type == 4) {
                    target.destroyed();
                } else if (type == 5) {
                    boolean[] temp = (boolean[])value;
                    target.seedingStatusChanged(temp[0], temp[1]);
                }
            }
        }
    });
    private static final int LDT_MANAGER_WBR = 1;
    private final ListenerManager removal_listeners = ListenerManager.createManager("GM:DLWBRMListenDispatcher", new ListenerManagerDispatcherWithException(){

        @Override
        public void dispatchWithException(Object _listener, int type, Object value) throws GlobalManagerDownloadRemovalVetoException {
            GlobalManagerDownloadWillBeRemovedListener target = (GlobalManagerDownloadWillBeRemovedListener)_listener;
            DownloadManager dm = (DownloadManager)((Object[])value)[0];
            boolean remove_torrent = (Boolean)((Object[])value)[1];
            boolean remove_data = (Boolean)((Object[])value)[2];
            target.downloadWillBeRemoved(dm, remove_torrent, remove_data);
        }
    });
    private static boolean enable_stopped_scrapes;
    private static boolean enable_no_space_dl_restarts;
    private static int no_space_dl_restart_check_period_millis;
    private volatile List<DownloadManager> managers_cow = new ArrayList<DownloadManager>();
    private final AEMonitor managers_mon = new AEMonitor("GM:Managers");
    final Map manager_map = new HashMap();
    private final GlobalMangerProgressListener progress_listener;
    private long lastListenerUpdate;
    private final Checker checker;
    private final GlobalManagerStatsImpl stats;
    private long last_swarm_stats_calc_time = 0L;
    private long last_swarm_stats = 0L;
    private final boolean cripple_downloads_config;
    private final TRTrackerScraper trackerScraper;
    private GlobalManagerStatsWriter stats_writer;
    private GlobalManagerHostSupport host_support;
    private Object download_history_manager;
    private final Map<HashWrapper, Map> saved_download_manager_state = new HashMap<HashWrapper, Map>();
    private int next_seed_piece_recheck_index;
    private final TorrentFolderWatcher torrent_folder_watcher;
    private final ArrayList<Object[]> paused_list = new ArrayList();
    private final AEMonitor paused_list_mon = new AEMonitor("GlobalManager:PL");
    private final GlobalManagerFileMerger file_merger;
    private volatile boolean isStopping;
    private volatile boolean destroyed;
    private volatile boolean needsSaving = false;
    private volatile long needsSavingCozStateChanged;
    private boolean seeding_only_mode = false;
    private boolean potentially_seeding_only_mode = false;
    private final FrequencyLimitedDispatcher check_seeding_only_state_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        @Override
        public void runSupport() {
            GlobalManagerImpl.this.checkSeedingOnlyStateSupport();
        }
    }, 5000);
    private boolean force_start_non_seed_exists;
    private int nat_status = 0;
    private long nat_status_last_good = -1L;
    private boolean nat_status_probably_ok;
    private final CopyOnWriteList dm_adapters = new CopyOnWriteList();
    DelayedEvent loadTorrentsDelay = null;
    boolean loadingComplete = false;
    final AESemaphore loadingSem = new AESemaphore("Loading Torrents");
    final AEMonitor addingDM_monitor = new AEMonitor("addingDM");
    final List addingDMs = new ArrayList();
    private MainlineDHTProvider provider = null;
    private TimerEvent auto_resume_timer;
    private boolean auto_resume_disabled = COConfigurationManager.getBooleanParameter("Pause Downloads On Exit") && !COConfigurationManager.getBooleanParameter("Resume Downloads On Start");
    private final TaggableLifecycleHandler taggable_life_manager = TagManagerFactory.getTagManager().registerTaggableResolver(this);

    public GlobalManagerImpl(AzureusCore core, GlobalMangerProgressListener listener, long existingTorrentLoadDelay) {
        this.progress_listener = listener;
        this.cripple_downloads_config = "1".equals(System.getProperty("azureus.disabledownloads"));
        AEDiagnostics.addEvidenceGenerator(this);
        this.stats = new GlobalManagerStatsImpl(this);
        try {
            this.stats_writer = new GlobalManagerStatsWriter(core, this.stats);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Stats unavailable", e));
        }
        try {
            try {
                Class<?> impl_class = GlobalManagerImpl.class.getClassLoader().loadClass("org.gudy.azureus2.core3.history.impl.DownloadHistoryManagerImpl");
                this.download_history_manager = impl_class.newInstance();
            }
            catch (ClassNotFoundException e) {}
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Download History unavailable", e));
        }
        if (existingTorrentLoadDelay > 0L) {
            this.loadTorrentsDelay = new DelayedEvent("GM:tld", existingTorrentLoadDelay, new AERunnable(){

                @Override
                public void runSupport() {
                    GlobalManagerImpl.this.loadExistingTorrentsNow(false);
                }
            });
        } else {
            this.loadDownloads();
        }
        if (this.progress_listener != null) {
            this.progress_listener.reportCurrentTask(MessageText.getString("splash.initializeGM"));
        }
        this.trackerScraper = TRTrackerScraperFactory.getSingleton();
        this.trackerScraper.setClientResolver(new TRTrackerScraperClientResolver(){

            @Override
            public boolean isScrapable(HashWrapper torrent_hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(torrent_hash);
                if (dm == null) {
                    return false;
                }
                int dm_state = dm.getState();
                if (dm_state == 75) {
                    return true;
                }
                if (dm_state == 50 || dm_state == 60) {
                    return true;
                }
                if (!enable_stopped_scrapes) {
                    return false;
                }
                DownloadManagerStats stats2 = dm.getStats();
                return stats2.getTotalDataBytesReceived() != 0L || stats2.getPercentDoneExcludingDND() != 0;
            }

            @Override
            public boolean isNetworkEnabled(HashWrapper hash, URL url) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return false;
                }
                String nw = AENetworkClassifier.categoriseAddress(url.getHost());
                String[] networks = dm.getDownloadState().getNetworks();
                for (int i = 0; i < networks.length; ++i) {
                    if (networks[i] != nw) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String[] getEnabledNetworks(HashWrapper hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return null;
                }
                return dm.getDownloadState().getNetworks();
            }

            @Override
            public int[] getCachedScrape(HashWrapper hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return null;
                }
                long cache = dm.getDownloadState().getLongAttribute("scrapecache");
                if (cache == -1L) {
                    return null;
                }
                int cache_src = dm.getDownloadState().getIntAttribute("scsrc");
                if (cache_src == 0) {
                    int seeds = (int)(cache >> 32 & 0xFFFFFFL);
                    int leechers = (int)(cache & 0xFFFFFFL);
                    return new int[]{seeds, leechers};
                }
                return null;
            }

            @Override
            public Object[] getExtensions(HashWrapper hash) {
                Character state;
                String ext;
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    ext = "";
                    state = TRTrackerScraperClientResolver.FL_NONE;
                } else {
                    ext = dm.getDownloadState().getTrackerClientExtensions();
                    if (ext == null) {
                        ext = "";
                    }
                    boolean comp2 = dm.isDownloadComplete(false);
                    int dm_state = dm.getState();
                    state = dm_state == 100 || dm_state == 70 || dm_state == 65 && dm.getSubState() != 75 ? (comp2 ? TRTrackerScraperClientResolver.FL_COMPLETE_STOPPED : TRTrackerScraperClientResolver.FL_INCOMPLETE_STOPPED) : (dm_state == 50 || dm_state == 60 ? (comp2 ? TRTrackerScraperClientResolver.FL_COMPLETE_RUNNING : TRTrackerScraperClientResolver.FL_INCOMPLETE_RUNNING) : (comp2 ? TRTrackerScraperClientResolver.FL_COMPLETE_QUEUED : TRTrackerScraperClientResolver.FL_INCOMPLETE_QUEUED));
                }
                return new Object[]{ext, state};
            }

            @Override
            public boolean redirectTrackerUrl(HashWrapper hash, URL old_url, URL new_url) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null || dm.getTorrent() == null) {
                    return false;
                }
                return TorrentUtils.replaceAnnounceURL(dm.getTorrent(), old_url, new_url);
            }
        });
        this.trackerScraper.addListener(new TRTrackerScraperListener(){

            @Override
            public void scrapeReceived(TRTrackerScraperResponse response) {
                HashWrapper hash = response.getHash();
                DownloadManager manager = (DownloadManager)GlobalManagerImpl.this.manager_map.get(hash);
                if (manager != null) {
                    manager.setTrackerScrapeResponse(response);
                }
            }
        });
        try {
            this.host_support = new GlobalManagerHostSupport(this);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Hosting unavailable", e));
        }
        this.checker = new Checker();
        this.checker.start();
        this.torrent_folder_watcher = new TorrentFolderWatcher(this);
        this.torrent_folder_watcher.start();
        TRTrackerUtils.addListener(new TRTrackerUtilsListener(){

            @Override
            public void announceDetailsChanged() {
                Logger.log(new LogEvent(LOGID, "Announce details have changed, updating trackers"));
                List managers = GlobalManagerImpl.this.managers_cow;
                for (int i = 0; i < managers.size(); ++i) {
                    DownloadManager manager = (DownloadManager)managers.get(i);
                    manager.requestTrackerAnnounce(true);
                }
            }
        });
        TorrentUtils.addTorrentURLChangeListener(new TorrentUtils.TorrentAnnounceURLChangeListener(){

            @Override
            public void changed() {
                Logger.log(new LogEvent(LOGID, "Announce URL details have changed, updating trackers"));
                List managers = GlobalManagerImpl.this.managers_cow;
                for (int i = 0; i < managers.size(); ++i) {
                    DownloadManager manager = (DownloadManager)managers.get(i);
                    TRTrackerAnnouncer client = manager.getTrackerClient();
                    if (client == null) continue;
                    client.resetTrackerUrl(false);
                }
            }
        });
        if (TagManagerFactory.getTagManager().isEnabled()) {
            new DownloadStateTagger(this);
        }
        this.file_merger = new GlobalManagerFileMerger(this);
    }

    @Override
    public void loadExistingTorrentsNow(boolean async) {
        if (this.loadTorrentsDelay == null) {
            return;
        }
        this.loadTorrentsDelay = null;
        if (async) {
            AEThread thread = new AEThread("load torrents", true){

                @Override
                public void runSupport() {
                    GlobalManagerImpl.this.loadDownloads();
                }
            };
            thread.setPriority(3);
            thread.start();
        } else {
            this.loadDownloads();
        }
    }

    @Override
    public DownloadManager addDownloadManager(String fileName, String savePath) {
        return this.addDownloadManager(fileName, null, savePath, 0, true);
    }

    @Override
    public DownloadManager addDownloadManager(String fileName, byte[] optionalHash, String savePath, int initialState, boolean persistent) {
        return this.addDownloadManager(fileName, optionalHash, savePath, initialState, persistent, false, null);
    }

    @Override
    public DownloadManager addDownloadManager(String torrent_file_name, byte[] optionalHash, String savePath, int initialState, boolean persistent, boolean for_seeding, DownloadManagerInitialisationAdapter _adapter) {
        return this.addDownloadManager(torrent_file_name, optionalHash, savePath, null, initialState, persistent, for_seeding, _adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public DownloadManager addDownloadManager(String torrent_file_name, byte[] optionalHash, String savePath, String saveFile, int initialState, boolean persistent, boolean for_seeding, DownloadManagerInitialisationAdapter _adapter) {
        block81: {
            block79: {
                block77: {
                    block74: {
                        block75: {
                            block71: {
                                block72: {
                                    needsFixup = false;
                                    this.loadingSem.reserve(60000L);
                                    adapter = this.getDMAdapter(_adapter);
                                    file_priorities = null;
                                    if (!persistent && (save_download_state = this.saved_download_manager_state.get(new HashWrapper(optionalHash))) != null) {
                                        if (save_download_state.containsKey("state") && (saved_state = ((Long)save_download_state.get("state")).intValue()) == 70) {
                                            initialState = saved_state;
                                        }
                                        file_priorities = (List)save_download_state.get("file_priorities");
                                        lPosition = (Long)save_download_state.get("position");
                                        if (lPosition != null && lPosition != -1L) {
                                            needsFixup = true;
                                        }
                                    }
                                    torrentDir = null;
                                    fDest = null;
                                    hash = null;
                                    deleteDest = false;
                                    removeFromAddingDM = false;
                                    f = new File(torrent_file_name);
                                    if (!f.exists()) {
                                        throw new IOException("Torrent file '" + torrent_file_name + "' doesn't exist");
                                    }
                                    if (!f.isFile()) {
                                        throw new IOException("Torrent '" + torrent_file_name + "' is not a file");
                                    }
                                    fDest = TorrentUtils.copyTorrentFileToSaveDir(f, persistent);
                                    fName = fDest.getCanonicalPath();
                                    if (optionalHash != null) {
                                        hash = new HashWrapper(optionalHash);
                                    } else {
                                        torrent = TorrentUtils.readFromFile(fDest, false);
                                        hash = torrent.getHashWrapper();
                                    }
                                    if (hash == null) ** GOTO lbl107
                                    removeFromAddingDM = true;
                                    existingDM = this.getDownloadManager(hash);
                                    if (existingDM == null) break block71;
                                    deleteDest = true;
                                    var21_29 = existingDM;
                                    if (!deleteDest) break block72;
                                    fDest.delete();
                                    try {
                                        backupFile = new File(fDest.getCanonicalPath() + ".bak");
                                        if (backupFile.exists()) {
                                            backupFile.delete();
                                        }
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                }
                                if (removeFromAddingDM && hash != null) {
                                    try {
                                        this.addingDM_monitor.enter();
                                        this.addingDMs.remove(hash);
                                    }
                                    finally {
                                        this.addingDM_monitor.exit();
                                    }
                                }
                                return var21_29;
                            }
                            this.addingDM_monitor.enter();
                            if (!this.addingDMs.contains(hash)) break block74;
                            removeFromAddingDM = false;
                            deleteDest = true;
                            var21_30 = null;
                            this.addingDM_monitor.exit();
                            if (!deleteDest) break block75;
                            fDest.delete();
                            try {
                                backupFile = new File(fDest.getCanonicalPath() + ".bak");
                                if (backupFile.exists()) {
                                    backupFile.delete();
                                }
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        if (removeFromAddingDM && hash != null) {
                            try {
                                this.addingDM_monitor.enter();
                                this.addingDMs.remove(hash);
                            }
                            finally {
                                this.addingDM_monitor.exit();
                            }
                        }
                        return var21_30;
                    }
                    this.addingDMs.add(hash);
                    break block77;
                    {
                        catch (Throwable var26_37) {
                            throw var26_37;
                        }
                    }
                    finally {
                        this.addingDM_monitor.exit();
                    }
                    {
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if ((manager = this.addDownloadManager(new_manager = DownloadManagerFactory.create((GlobalManager)this, optionalHash, fName, savePath, saveFile, initialState, persistent, for_seeding, file_priorities, adapter), true, true)) == null || manager != new_manager) {
                    deleteDest = true;
                } else {
                    if (initialState == 70 && COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped Auto Pause")) {
                        try {
                            this.paused_list_mon.enter();
                            this.paused_list.add(new Object[]{manager.getTorrent().getHashWrapper(), false});
                        }
                        finally {
                            this.paused_list_mon.exit();
                        }
                    }
                    if (TorrentUtils.shouldDeleteTorrentFileAfterAdd(fDest, persistent)) {
                        deleteDest = true;
                    }
                }
                if (!deleteDest) break block79;
                fDest.delete();
                try {
                    backupFile = new File(fDest.getCanonicalPath() + ".bak");
                    if (backupFile.exists()) {
                        backupFile.delete();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (removeFromAddingDM && hash != null) {
                try {
                    this.addingDM_monitor.enter();
                    this.addingDMs.remove(hash);
                }
                finally {
                    this.addingDM_monitor.exit();
                }
            }
            break block81;
            catch (IOException e) {
                block80: {
                    System.out.println("DownloadManager::addDownloadManager: fails - td = " + torrentDir + ", fd = " + fDest);
                    Debug.printStackTrace(e);
                    manager = DownloadManagerFactory.create((GlobalManager)this, optionalHash, torrent_file_name, savePath, saveFile, initialState, persistent, for_seeding, file_priorities, adapter);
                    manager = this.addDownloadManager(manager, true, true);
                    if (!deleteDest) break block80;
                    fDest.delete();
                    try {
                        backupFile = new File(fDest.getCanonicalPath() + ".bak");
                        if (backupFile.exists()) {
                            backupFile.delete();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (!removeFromAddingDM || hash == null) break block81;
                try {
                    this.addingDM_monitor.enter();
                    this.addingDMs.remove(hash);
                    break block81;
                }
                finally {
                    this.addingDM_monitor.exit();
                }
            }
            catch (Exception e) {
                block82: {
                    manager = DownloadManagerFactory.create((GlobalManager)this, optionalHash, torrent_file_name, savePath, saveFile, initialState, persistent, for_seeding, file_priorities, adapter);
                    manager = this.addDownloadManager(manager, true, true);
                    if (!deleteDest) break block82;
                    fDest.delete();
                    {
                        catch (Throwable var31_43) {
                            if (deleteDest) {
                                fDest.delete();
                                try {
                                    backupFile = new File(fDest.getCanonicalPath() + ".bak");
                                    if (backupFile.exists()) {
                                        backupFile.delete();
                                    }
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                            }
                            if (removeFromAddingDM && hash != null) {
                                try {
                                    this.addingDM_monitor.enter();
                                    this.addingDMs.remove(hash);
                                }
                                finally {
                                    this.addingDM_monitor.exit();
                                }
                            }
                            throw var31_43;
                        }
                    }
                    try {
                        backupFile = new File(fDest.getCanonicalPath() + ".bak");
                        if (backupFile.exists()) {
                            backupFile.delete();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (!removeFromAddingDM || hash == null) break block81;
                try {
                    this.addingDM_monitor.enter();
                    this.addingDMs.remove(hash);
                }
                finally {
                    this.addingDM_monitor.exit();
                }
            }
        }
        if (needsFixup && manager != null && manager.getPosition() <= this.downloadManagerCount(manager.isDownloadComplete(false))) {
            this.fixUpDownloadManagerPositions();
        }
        return manager;
    }

    @Override
    public void clearNonPersistentDownloadState(byte[] hash) {
        this.saved_download_manager_state.remove(new HashWrapper(hash));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadManager addDownloadManager(DownloadManager download_manager, boolean save, boolean notifyListeners) {
        if (!this.isStopping) {
            this.loadExistingTorrentsNow(false);
            try {
                this.managers_mon.enter();
                int existing_index = this.managers_cow.indexOf(download_manager);
                if (existing_index != -1) {
                    DownloadManager existing = this.managers_cow.get(existing_index);
                    download_manager.destroy(true);
                    DownloadManager downloadManager = existing;
                    return downloadManager;
                }
                DownloadManagerStats dm_stats = download_manager.getStats();
                HashWrapper hashwrapper = null;
                try {
                    TOTorrent torrent = download_manager.getTorrent();
                    if (torrent != null) {
                        hashwrapper = torrent.getHashWrapper();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                Map save_download_state = this.saved_download_manager_state.remove(hashwrapper);
                long saved_data_bytes_downloaded = 0L;
                long saved_data_bytes_uploaded = 0L;
                long saved_discarded = 0L;
                long saved_hashfails = 0L;
                long saved_SecondsDownloading = 0L;
                long saved_SecondsOnlySeeding = 0L;
                if (save_download_state != null) {
                    long ct;
                    Long creation_time;
                    Long already_allocated;
                    Long lSecondsOnlySeeding;
                    Long lSecondsDLing;
                    Category cat;
                    TOTorrent torrent;
                    int maxUploads;
                    int maxDL = save_download_state.get("maxdl") == null ? 0 : ((Long)save_download_state.get("maxdl")).intValue();
                    int maxUL = save_download_state.get("maxul") == null ? 0 : ((Long)save_download_state.get("maxul")).intValue();
                    Long lDownloaded = (Long)save_download_state.get("downloaded");
                    Long lUploaded = (Long)save_download_state.get("uploaded");
                    Long lCompletedBytes = (Long)save_download_state.get("completedbytes");
                    Long lDiscarded = (Long)save_download_state.get("discarded");
                    Long lHashFailsCount = (Long)save_download_state.get("hashfails");
                    Long lHashFailsBytes = (Long)save_download_state.get("hashfailbytes");
                    Long nbUploads = (Long)save_download_state.get("uploads");
                    if (nbUploads != null && (maxUploads = nbUploads.intValue()) != 4 && download_manager.getMaxUploads() == 4) {
                        download_manager.setMaxUploads(maxUploads);
                    }
                    dm_stats.setDownloadRateLimitBytesPerSecond(maxDL);
                    dm_stats.setUploadRateLimitBytesPerSecond(maxUL);
                    if (lCompletedBytes != null) {
                        dm_stats.setDownloadCompletedBytes(lCompletedBytes);
                    }
                    if (lDiscarded != null) {
                        saved_discarded = lDiscarded;
                    }
                    if (lHashFailsBytes != null) {
                        saved_hashfails = lHashFailsBytes;
                    } else if (lHashFailsCount != null && (torrent = download_manager.getTorrent()) != null) {
                        saved_hashfails = lHashFailsCount * torrent.getPieceLength();
                    }
                    Long lPosition = (Long)save_download_state.get("position");
                    String sCategory = null;
                    if (save_download_state.containsKey("category")) {
                        try {
                            sCategory = new String((byte[])save_download_state.get("category"), "UTF8");
                        }
                        catch (UnsupportedEncodingException e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (sCategory != null && (cat = CategoryManager.getCategory(sCategory)) != null) {
                        download_manager.getDownloadState().setCategory(cat);
                    }
                    download_manager.requestAssumedCompleteMode();
                    if (lDownloaded != null && lUploaded != null) {
                        boolean bCompleted = download_manager.isDownloadComplete(false);
                        long lUploadedValue = lUploaded;
                        long lDownloadedValue = lDownloaded;
                        if (bCompleted && lDownloadedValue == 0L) {
                            int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                            lDownloadedValue = download_manager.getSize() * (long)dl_copies;
                            download_manager.getDownloadState().setFlag(1L, true);
                        }
                        saved_data_bytes_downloaded = lDownloadedValue;
                        saved_data_bytes_uploaded = lUploadedValue;
                    }
                    if (lPosition != null) {
                        download_manager.setPosition(lPosition.intValue());
                    }
                    if ((lSecondsDLing = (Long)save_download_state.get("secondsDownloading")) != null) {
                        saved_SecondsDownloading = lSecondsDLing;
                    }
                    if ((lSecondsOnlySeeding = (Long)save_download_state.get("secondsOnlySeeding")) != null) {
                        saved_SecondsOnlySeeding = lSecondsOnlySeeding;
                    }
                    if ((already_allocated = (Long)save_download_state.get("allocated")) != null && already_allocated.intValue() == 1) {
                        download_manager.setDataAlreadyAllocated(true);
                    }
                    if ((creation_time = (Long)save_download_state.get("creationTime")) != null && (ct = creation_time.longValue()) < SystemTime.getCurrentTime()) {
                        download_manager.setCreationTime(ct);
                    }
                } else if (dm_stats.getDownloadCompleted(false) == 1000) {
                    int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                    saved_data_bytes_downloaded = download_manager.getSize() * (long)dl_copies;
                }
                dm_stats.restoreSessionTotals(saved_data_bytes_downloaded, saved_data_bytes_uploaded, saved_discarded, saved_hashfails, saved_SecondsDownloading, saved_SecondsOnlySeeding);
                boolean isCompleted = download_manager.isDownloadComplete(false);
                if (download_manager.getPosition() == -1) {
                    int endPosition = 0;
                    for (int i = 0; i < this.managers_cow.size(); ++i) {
                        DownloadManager dm = this.managers_cow.get(i);
                        boolean dmIsCompleted = dm.isDownloadComplete(false);
                        if (dmIsCompleted != isCompleted) continue;
                        ++endPosition;
                    }
                    download_manager.setPosition(endPosition + 1);
                }
                download_manager.requestAssumedCompleteMode();
                ArrayList<DownloadManager> new_download_managers = new ArrayList<DownloadManager>(this.managers_cow);
                new_download_managers.add(download_manager);
                this.managers_cow = new_download_managers;
                TOTorrent torrent = download_manager.getTorrent();
                if (torrent != null) {
                    try {
                        this.manager_map.put(new HashWrapper(torrent.getHash()), download_manager);
                    }
                    catch (TOTorrentException e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (COConfigurationManager.getBooleanParameter("Set Completion Flag For Completed Downloads On Start") && download_manager.isDownloadComplete(true)) {
                    download_manager.getDownloadState().setFlag(8L, true);
                }
                if (notifyListeners) {
                    this.listeners_and_event_listeners.dispatch(1, download_manager);
                    this.taggable_life_manager.taggableCreated(download_manager);
                    if (this.host_support != null) {
                        this.host_support.torrentAdded(download_manager.getTorrentFileName(), download_manager.getTorrent());
                    }
                }
                download_manager.addListener(this);
                if (save_download_state != null) {
                    Long lStartStopLocked;
                    Long lForceStart = (Long)save_download_state.get("forceStart");
                    if (lForceStart == null && (lStartStopLocked = (Long)save_download_state.get("startStopLocked")) != null) {
                        lForceStart = lStartStopLocked;
                    }
                    if (lForceStart != null && lForceStart.intValue() == 1) {
                        download_manager.setForceStart(true);
                    }
                }
            }
            finally {
                this.managers_mon.exit();
            }
            if (save) {
                this.saveDownloads(false);
            }
            return download_manager;
        }
        Logger.log(new LogEvent(LOGID, 3, "Tried to add a DownloadManager after shutdown of GlobalManager."));
        return null;
    }

    @Override
    public List<DownloadManager> getDownloadManagers() {
        return this.managers_cow;
    }

    @Override
    public DownloadManager getDownloadManager(TOTorrent torrent) {
        if (torrent == null) {
            return null;
        }
        try {
            return this.getDownloadManager(torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            return null;
        }
    }

    @Override
    public DownloadManager getDownloadManager(HashWrapper hw) {
        return (DownloadManager)this.manager_map.get(hw);
    }

    @Override
    public void canDownloadManagerBeRemoved(DownloadManager manager, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
        try {
            this.removal_listeners.dispatchWithException(1, new Object[]{manager, new Boolean(remove_torrent), remove_data});
        }
        catch (Throwable e) {
            if (e instanceof GlobalManagerDownloadRemovalVetoException) {
                throw (GlobalManagerDownloadRemovalVetoException)e;
            }
            GlobalManagerDownloadRemovalVetoException gmv = new GlobalManagerDownloadRemovalVetoException("Error running veto check");
            gmv.initCause(e);
            Debug.out(e);
            throw gmv;
        }
    }

    @Override
    public void removeDownloadManager(DownloadManager manager) throws GlobalManagerDownloadRemovalVetoException {
        this.removeDownloadManager(manager, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDownloadManager(DownloadManager manager, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
        TOTorrent torrent;
        if (!this.managers_cow.contains(manager)) {
            return;
        }
        this.canDownloadManagerBeRemoved(manager, remove_torrent, remove_data);
        manager.stopIt(70, remove_torrent, remove_data, true);
        try {
            this.managers_mon.enter();
            ArrayList<DownloadManager> new_download_managers = new ArrayList<DownloadManager>(this.managers_cow);
            new_download_managers.remove(manager);
            this.managers_cow = new_download_managers;
            TOTorrent torrent2 = manager.getTorrent();
            if (torrent2 != null) {
                try {
                    this.manager_map.remove(new HashWrapper(torrent2.getHash()));
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            this.managers_mon.exit();
        }
        if ((torrent = manager.getTorrent()) != null) {
            TorrentUtils.removeCreatedTorrent(torrent);
        }
        manager.destroy(false);
        this.fixUpDownloadManagerPositions();
        this.listeners_and_event_listeners.dispatch(2, manager);
        TorrentUtils.setTorrentDeleted();
        this.taggable_life_manager.taggableDestroyed(manager);
        manager.removeListener(this);
        this.saveDownloads(false);
        DownloadManagerState dms = manager.getDownloadState();
        if (dms.getCategory() != null) {
            dms.setCategory(null);
        }
        if (manager.getTorrent() != null) {
            this.trackerScraper.remove(manager.getTorrent());
        }
        if (this.host_support != null) {
            this.host_support.torrentRemoved(manager.getTorrentFileName(), manager.getTorrent());
        }
        dms.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGlobalManager() {
        try {
            this.managers_mon.enter();
            if (this.isStopping) {
                return;
            }
            this.isStopping = true;
        }
        finally {
            this.managers_mon.exit();
        }
        this.stats.save();
        this.informDestroyInitiated();
        if (this.host_support != null) {
            this.host_support.destroy();
        }
        this.torrent_folder_watcher.destroy();
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                @Override
                public Object run() {
                    return null;
                }

                @Override
                public String getName() {
                    return "Stopping global manager";
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.checker.stopIt();
        if (COConfigurationManager.getBooleanParameter("Pause Downloads On Exit")) {
            this.pauseDownloads(true);
            this.stopAllDownloads(true);
            this.saveDownloads(true);
        } else {
            this.saveDownloads(true);
            this.stopAllDownloads(true);
        }
        if (this.stats_writer != null) {
            this.stats_writer.destroy();
        }
        DownloadManagerStateFactory.saveGlobalStateCache();
        try {
            this.managers_mon.enter();
            this.managers_cow = new ArrayList<DownloadManager>();
            this.manager_map.clear();
        }
        finally {
            this.managers_mon.exit();
        }
        this.informDestroyed();
    }

    @Override
    public void stopAllDownloads() {
        this.stopAllDownloads(false);
    }

    protected void stopAllDownloads(boolean for_close) {
        if (for_close && this.progress_listener != null) {
            this.progress_listener.reportCurrentTask(MessageText.getString("splash.unloadingTorrents"));
        }
        long lastListenerUpdate = 0L;
        List<DownloadManager> managers = this.sortForStop();
        int nbDownloads = managers.size();
        for (int i = 0; i < nbDownloads; ++i) {
            int state;
            DownloadManager manager = managers.get(i);
            long now = SystemTime.getCurrentTime();
            if (this.progress_listener != null && now - lastListenerUpdate > 100L) {
                lastListenerUpdate = now;
                int currentDownload = i + 1;
                this.progress_listener.reportPercent(100 * currentDownload / nbDownloads);
                this.progress_listener.reportCurrentTask(MessageText.getString("splash.unloadingTorrent") + " " + currentDownload + " " + MessageText.getString("splash.of") + " " + nbDownloads + " : " + manager.getTorrentFileName());
            }
            if ((state = manager.getState()) == 70 || state == 65) continue;
            manager.stopIt(for_close ? 71 : 70, false, false);
        }
    }

    @Override
    public void startAllDownloads() {
        for (DownloadManager manager : this.managers_cow) {
            if (manager.getState() != 70) continue;
            manager.stopIt(75, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pauseDownload(DownloadManager manager) {
        if (manager.getTorrent() == null) {
            return false;
        }
        int state = manager.getState();
        if (state != 70 && state != 100 && state != 65) {
            try {
                HashWrapper wrapper2 = manager.getTorrent().getHashWrapper();
                boolean forced = manager.isForceStart();
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.add(new Object[]{wrapper2, forced});
                }
                finally {
                    this.paused_list_mon.exit();
                }
                manager.stopIt(70, false, false);
                return true;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseDownloadsForPeriod(int seconds) {
        try {
            this.paused_list_mon.enter();
            if (this.auto_resume_timer != null) {
                this.auto_resume_timer.cancel();
            }
            this.auto_resume_timer = SimpleTimer.addEvent("GM:auto-resume", SystemTime.getOffsetTime(seconds * 1000), new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    GlobalManagerImpl.this.resumeDownloads();
                }
            });
        }
        finally {
            this.paused_list_mon.exit();
        }
        this.pauseDownloads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPauseDownloadPeriodRemaining() {
        try {
            this.paused_list_mon.enter();
            if (this.auto_resume_timer != null) {
                long rem = this.auto_resume_timer.getWhen() - SystemTime.getCurrentTime();
                int n = Math.max(0, (int)(rem / 1000L));
                return n;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        return 0;
    }

    @Override
    public void pauseDownloads() {
        this.pauseDownloads(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pauseDownloads(boolean tag_only) {
        List<DownloadManager> managers = this.sortForStop();
        for (DownloadManager manager : managers) {
            int state;
            if (manager.getTorrent() == null || (state = manager.getState()) == 70 || state == 100 || state == 65) continue;
            try {
                boolean forced = manager.isForceStart();
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.add(new Object[]{manager.getTorrent().getHashWrapper(), forced});
                }
                finally {
                    this.paused_list_mon.exit();
                }
                if (tag_only) continue;
                manager.stopIt(70, false, false);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean canPauseDownload(DownloadManager manager) {
        if (manager.getTorrent() == null) {
            return false;
        }
        int state = manager.getState();
        return state != 70 && state != 100 && state != 65;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPaused(DownloadManager manager) {
        if (this.paused_list.size() == 0) {
            return false;
        }
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                DownloadManager this_manager = this.getDownloadManager(hash);
                if (this_manager != manager) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.paused_list_mon.exit();
        }
    }

    @Override
    public boolean canPauseDownloads() {
        for (DownloadManager manager : this.managers_cow) {
            if (!this.canPauseDownload(manager)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeDownload(DownloadManager manager) {
        boolean resume_ok = false;
        boolean force = false;
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                force = (Boolean)data[1];
                DownloadManager this_manager = this.getDownloadManager(hash);
                if (this_manager != manager) continue;
                resume_ok = true;
                this.paused_list.remove(i);
                break;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        if (resume_ok && manager.getState() == 70) {
            if (force) {
                manager.setForceStart(true);
            } else {
                manager.stopIt(75, false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resumingDownload(DownloadManager manager) {
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                DownloadManager this_manager = this.getDownloadManager(hash);
                if (this_manager != manager) continue;
                this.paused_list.remove(i);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeDownloads() {
        this.auto_resume_disabled = false;
        try {
            this.paused_list_mon.enter();
            if (this.auto_resume_timer != null) {
                this.auto_resume_timer.cancel();
                this.auto_resume_timer = null;
            }
            ArrayList<Object[]> copy = new ArrayList<Object[]>(this.paused_list);
            for (Object[] data : copy) {
                HashWrapper hash = (HashWrapper)data[0];
                boolean force = (Boolean)data[1];
                DownloadManager manager = this.getDownloadManager(hash);
                if (manager == null || manager.getState() != 70) continue;
                if (force) {
                    manager.setForceStart(true);
                    continue;
                }
                manager.stopIt(75, false, false);
            }
            this.paused_list.clear();
        }
        finally {
            this.paused_list_mon.exit();
        }
    }

    @Override
    public boolean resumeDownloads(boolean is_auto_resume) {
        if (is_auto_resume && this.auto_resume_disabled) {
            return false;
        }
        this.resumeDownloads();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canResumeDownloads() {
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                DownloadManager manager = this.getDownloadManager(hash);
                if (manager == null || manager.getState() != 70) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        return false;
    }

    @Override
    public String isSwarmMerging(DownloadManager dm) {
        return this.file_merger.isSwarmMerging(dm);
    }

    private List<DownloadManager> sortForStop() {
        ArrayList<DownloadManager> managers = new ArrayList<DownloadManager>(this.managers_cow);
        Collections.sort(managers, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager o1, DownloadManager o2) {
                int s1 = o1.getState();
                int s2 = o2.getState();
                if (s2 == 75) {
                    return 1;
                }
                if (s1 == 75) {
                    return -1;
                }
                return 0;
            }
        });
        return managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDownloads() {
        try {
            if (this.cripple_downloads_config) {
                this.loadingComplete = true;
                this.loadingSem.releaseForever();
                return;
            }
            try {
                DownloadManagerStateFactory.loadGlobalStateCache();
                int triggerOnCount = 2;
                ArrayList<DownloadManager> downloadsAdded = new ArrayList<DownloadManager>();
                this.lastListenerUpdate = 0L;
                try {
                    int nbDownloads;
                    if (this.progress_listener != null) {
                        this.progress_listener.reportCurrentTask(MessageText.getString("splash.loadingTorrents"));
                    }
                    Map map = FileUtil.readResilientConfigFile("downloads.config");
                    boolean debug = Boolean.getBoolean("debug");
                    Iterator<Object> iter = null;
                    List downloads = (List)map.get("downloads");
                    if (downloads == null) {
                        iter = map.values().iterator();
                        nbDownloads = map.size();
                    } else {
                        iter = downloads.iterator();
                        nbDownloads = downloads.size();
                    }
                    int currentDownload = 0;
                    while (iter.hasNext()) {
                        Map mDownload = (Map)iter.next();
                        DownloadManager dm = this.loadDownload(mDownload, ++currentDownload, nbDownloads, this.progress_listener, debug);
                        if (dm == null) continue;
                        downloadsAdded.add(dm);
                        if (downloadsAdded.size() < triggerOnCount) continue;
                        triggerOnCount *= 2;
                        this.triggerAddListener(downloadsAdded);
                        downloadsAdded.clear();
                    }
                    COConfigurationManager.setParameter("Set Completion Flag For Completed Downloads On Start", false);
                    ArrayList pause_data = (ArrayList)map.get("pause_data");
                    if (pause_data != null) {
                        try {
                            this.paused_list_mon.enter();
                            for (int i = 0; i < pause_data.size(); ++i) {
                                boolean force;
                                byte[] key;
                                Object pd = pause_data.get(i);
                                if (pd instanceof byte[]) {
                                    key = (byte[])pause_data.get(i);
                                    force = false;
                                } else {
                                    Map m = (Map)pd;
                                    key = (byte[])m.get("hash");
                                    force = ((Long)m.get("force")).intValue() == 1;
                                }
                                this.paused_list.add(new Object[]{new HashWrapper(key), force});
                            }
                        }
                        finally {
                            this.paused_list_mon.exit();
                        }
                    }
                    this.fixUpDownloadManagerPositions();
                    Logger.log(new LogEvent(LOGID, "Loaded " + this.managers_cow.size() + " torrents"));
                    this.loadingComplete = true;
                    this.triggerAddListener(downloadsAdded);
                    this.loadingSem.releaseForever();
                }
                catch (Throwable e) {
                    try {
                        Debug.printStackTrace(e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.loadingComplete = true;
                        this.triggerAddListener(downloadsAdded);
                        this.loadingSem.releaseForever();
                    }
                }
            }
            finally {
                DownloadManagerStateFactory.discardGlobalStateCache();
            }
        }
        finally {
            this.taggable_life_manager.initialized(this.getResolvedTaggables());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerAddListener(List downloadsToAdd) {
        try {
            this.managers_mon.enter();
            List listenersCopy = this.listeners_and_event_listeners.getListenersCopy();
            for (int j = 0; j < listenersCopy.size(); ++j) {
                Object listener = listenersCopy.get(j);
                if (!(listener instanceof GlobalManagerListener)) continue;
                GlobalManagerListener gmListener = (GlobalManagerListener)listener;
                for (int i = 0; i < downloadsToAdd.size(); ++i) {
                    DownloadManager dm = (DownloadManager)downloadsToAdd.get(i);
                    gmListener.downloadManagerAdded(dm);
                }
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    @Override
    public void saveState() {
        this.saveDownloads(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDownloads(boolean immediate) {
        if (!immediate) {
            this.needsSaving = true;
            return;
        }
        if (!this.loadingComplete) {
            this.needsSaving = true;
            return;
        }
        this.needsSaving = false;
        this.needsSavingCozStateChanged = 0L;
        if (this.cripple_downloads_config) {
            return;
        }
        try {
            this.managers_mon.enter();
            ArrayList<DownloadManager> managers_temp = new ArrayList<DownloadManager>(this.managers_cow);
            Collections.sort(managers_temp, new Comparator(){

                public final int compare(Object a, Object b) {
                    return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
                }
            });
            this.managers_cow = managers_temp;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Saving Download List (" + this.managers_cow.size() + " items)"));
            }
            HashMap map = new HashMap();
            ArrayList<Map> list = new ArrayList<Map>(this.managers_cow.size());
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager dm = this.managers_cow.get(i);
                Map dmMap = this.exportDownloadStateToMapSupport(dm, true);
                list.add(dmMap);
            }
            map.put("downloads", list);
            try {
                this.paused_list_mon.enter();
                if (!this.paused_list.isEmpty()) {
                    ArrayList pause_data = new ArrayList();
                    for (int i = 0; i < this.paused_list.size(); ++i) {
                        Object[] data = this.paused_list.get(i);
                        HashWrapper hash = (HashWrapper)data[0];
                        Boolean force = (Boolean)data[1];
                        HashMap<String, Object> m = new HashMap<String, Object>();
                        m.put("hash", hash.getHash());
                        m.put("force", new Long(force != false ? 1L : 0L));
                        pause_data.add(m);
                    }
                    map.put("pause_data", pause_data);
                }
            }
            finally {
                this.paused_list_mon.exit();
            }
            FileUtil.writeResilientConfigFile("downloads.config", map);
        }
        finally {
            this.managers_mon.exit();
        }
    }

    public DownloadManager loadDownload(Map mDownload, int currentDownload, int nbDownloads, GlobalMangerProgressListener progress_listener, boolean debug) {
        try {
            boolean has_ever_been_started;
            String torrent_save_file;
            String torrent_save_dir;
            byte[] torrent_save_dir_bytes;
            byte[] torrent_hash = (byte[])mDownload.get("torrent_hash");
            Long lPersistent = (Long)mDownload.get("persistent");
            boolean persistent = lPersistent == null || lPersistent == 1L;
            String fileName = new String((byte[])mDownload.get("torrent"), "UTF8");
            if (progress_listener != null && SystemTime.getCurrentTime() - this.lastListenerUpdate > 100L) {
                this.lastListenerUpdate = SystemTime.getCurrentTime();
                String shortFileName = fileName;
                try {
                    File f = new File(fileName);
                    shortFileName = f.getName();
                }
                catch (Exception e) {
                    // empty catch block
                }
                progress_listener.reportPercent(100 * currentDownload / nbDownloads);
                progress_listener.reportCurrentTask(MessageText.getString("splash.loadingTorrent") + " " + currentDownload + " " + MessageText.getString("splash.of") + " " + nbDownloads + " : " + shortFileName);
            }
            if ((torrent_save_dir_bytes = (byte[])mDownload.get("save_dir")) != null) {
                byte[] torrent_save_file_bytes = (byte[])mDownload.get("save_file");
                torrent_save_dir = new String(torrent_save_dir_bytes, "UTF8");
                torrent_save_file = torrent_save_file_bytes != null ? new String(torrent_save_file_bytes, "UTF8") : null;
            } else {
                byte[] savePathBytes = (byte[])mDownload.get("path");
                torrent_save_dir = new String(savePathBytes, "UTF8");
                torrent_save_file = null;
            }
            int state = 0;
            if (debug) {
                state = 70;
            } else if (mDownload.containsKey("state")) {
                state = ((Long)mDownload.get("state")).intValue();
                if (state != 70 && state != 75 && state != 0) {
                    state = 75;
                }
            } else {
                int stopped = ((Long)mDownload.get("stopped")).intValue();
                if (stopped == 1) {
                    state = 70;
                }
            }
            Long seconds_downloading = (Long)mDownload.get("secondsDownloading");
            boolean bl = has_ever_been_started = seconds_downloading != null && seconds_downloading > 0L;
            if (torrent_hash != null) {
                this.saved_download_manager_state.put(new HashWrapper(torrent_hash), mDownload);
            }
            if (persistent) {
                List<Long> file_priorities;
                Map map_file_priorities = (Map)mDownload.get("file_priorities_c");
                if (map_file_priorities != null) {
                    Object[] array_file_priorities = new Long[]{};
                    for (Object key : map_file_priorities.keySet()) {
                        long priority = Long.parseLong(key.toString());
                        String indexRanges = new String((byte[])map_file_priorities.get(key), "utf-8");
                        String[] rangesStrings = indexRanges.split(",");
                        if (array_file_priorities.length == 0 && rangesStrings.length > 1) {
                            array_file_priorities = new Long[rangesStrings.length];
                        }
                        for (String rangeString : rangesStrings) {
                            int end;
                            String[] ranges = rangeString.split("-");
                            int start = Integer.parseInt(ranges[0]);
                            int n = end = ranges.length == 1 ? start : Integer.parseInt(ranges[1]);
                            if (end >= array_file_priorities.length) {
                                array_file_priorities = GlobalManagerImpl.enlargeLongArray((Long[])array_file_priorities, end + 1);
                            }
                            Arrays.fill(array_file_priorities, start, end + 1, (Object)priority);
                        }
                    }
                    file_priorities = Arrays.asList(array_file_priorities);
                } else {
                    file_priorities = (List<Long>)mDownload.get("file_priorities");
                }
                DownloadManager dm = DownloadManagerFactory.create((GlobalManager)this, torrent_hash, fileName, torrent_save_dir, torrent_save_file, state, true, true, has_ever_been_started, file_priorities);
                if (this.addDownloadManager(dm, false, false) == dm) {
                    return dm;
                }
            }
        }
        catch (UnsupportedEncodingException e1) {
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Error while loading downloads.  One download may not have been added to the list.", e));
        }
        return null;
    }

    public static Long[] enlargeLongArray(Long[] array, int expandTo) {
        Long[] new_array = new Long[expandTo];
        if (array.length > 0) {
            System.arraycopy(array, 0, new_array, 0, array.length);
        }
        return new_array;
    }

    @Override
    public Map exportDownloadStateToMap(DownloadManager dm) {
        return this.exportDownloadStateToMapSupport(dm, false);
    }

    @Override
    public DownloadManager importDownloadStateFromMap(Map map) {
        DownloadManager dm = this.loadDownload(map, 1, 1, null, false);
        if (dm != null) {
            ArrayList<DownloadManager> dms = new ArrayList<DownloadManager>(1);
            dms.add(dm);
            this.triggerAddListener(dms);
            this.taggable_life_manager.taggableCreated(dm);
            if (this.host_support != null) {
                this.host_support.torrentAdded(dm.getTorrentFileName(), dm.getTorrent());
            }
        }
        return dm;
    }

    private Map exportDownloadStateToMapSupport(DownloadManager dm, boolean internal_export) {
        DownloadManagerStats dm_stats = dm.getStats();
        HashMap<String, Object> dmMap = new HashMap<String, Object>();
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                dmMap.put("torrent_hash", torrent.getHash());
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        File save_loc = dm.getAbsoluteSaveLocation();
        dmMap.put("persistent", new Long(dm.isPersistent() ? 1L : 0L));
        dmMap.put("torrent", dm.getTorrentFileName());
        dmMap.put("save_dir", save_loc.getParent());
        dmMap.put("save_file", save_loc.getName());
        dmMap.put("maxdl", new Long(dm_stats.getDownloadRateLimitBytesPerSecond()));
        dmMap.put("maxul", new Long(dm_stats.getUploadRateLimitBytesPerSecond()));
        int state = dm.getState();
        if (state == 100) {
            state = 70;
        } else if (dm.getAssumedComplete() && !dm.isForceStart() && state != 70) {
            state = 75;
        } else if (state != 70 && state != 75 && state != 0) {
            state = 0;
        }
        dmMap.put("state", new Long(state));
        if (internal_export) {
            dmMap.put("position", new Long(dm.getPosition()));
        }
        dmMap.put("downloaded", new Long(dm_stats.getTotalDataBytesReceived()));
        dmMap.put("uploaded", new Long(dm_stats.getTotalDataBytesSent()));
        dmMap.put("completedbytes", new Long(dm_stats.getDownloadCompletedBytes()));
        dmMap.put("discarded", new Long(dm_stats.getDiscarded()));
        dmMap.put("hashfailbytes", new Long(dm_stats.getHashFailBytes()));
        dmMap.put("forceStart", new Long(dm.isForceStart() && dm.getState() != 30 ? 1L : 0L));
        dmMap.put("secondsDownloading", new Long(dm_stats.getSecondsDownloading()));
        dmMap.put("secondsOnlySeeding", new Long(dm_stats.getSecondsOnlySeeding()));
        dmMap.put("uploads", new Long(dm.getMaxUploads()));
        dmMap.put("creationTime", new Long(dm.getCreationTime()));
        dm.saveDownload();
        List file_priorities = (List)dm.getData("file_priorities");
        if (file_priorities != null) {
            int count = file_priorities.size();
            HashMap<String, String> map_file_priorities = new HashMap<String, String>();
            Long priority = (Long)file_priorities.get(0);
            int posStart = 0;
            int posEnd = 0;
            while (posStart < count) {
                priority = (Long)file_priorities.get(posStart);
                while (posEnd + 1 < count && (Long)file_priorities.get(posEnd + 1) == priority) {
                    ++posEnd;
                }
                String key = priority.toString();
                String val = (String)map_file_priorities.get(key);
                val = val == null ? "" + posStart : val + "," + posStart;
                if (posStart != posEnd) {
                    val = val + "-" + posEnd;
                }
                map_file_priorities.put(key, val);
                posStart = posEnd + 1;
            }
            dmMap.put("file_priorities_c", map_file_priorities);
        }
        dmMap.put("allocated", new Long(dm.isDataAlreadyAllocated() ? 1L : 0L));
        return dmMap;
    }

    @Override
    public TRTrackerScraper getTrackerScraper() {
        return this.trackerScraper;
    }

    @Override
    public GlobalManagerStats getStats() {
        return this.stats;
    }

    @Override
    public boolean contains(DownloadManager manager) {
        if (this.managers_cow != null && manager != null) {
            return this.managers_cow.contains(manager);
        }
        return false;
    }

    @Override
    public int getIndexOf(DownloadManager manager) {
        if (this.managers_cow != null && manager != null) {
            return this.managers_cow.indexOf(manager);
        }
        return -1;
    }

    @Override
    public boolean isMoveableUp(DownloadManager manager) {
        if (manager.isDownloadComplete(false) && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return manager.getPosition() > 1;
    }

    @Override
    public int downloadManagerCount(boolean bCompleted) {
        int numInGroup = 0;
        for (DownloadManager dm : this.managers_cow) {
            if (dm.isDownloadComplete(false) != bCompleted) continue;
            ++numInGroup;
        }
        return numInGroup;
    }

    @Override
    public boolean isMoveableDown(DownloadManager manager) {
        boolean isCompleted = manager.isDownloadComplete(false);
        if (isCompleted && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return manager.getPosition() < this.downloadManagerCount(isCompleted);
    }

    @Override
    public void moveUp(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() - 1);
    }

    @Override
    public void moveDown(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTop(DownloadManager[] manager) {
        try {
            this.managers_mon.enter();
            int newPosition = 1;
            for (int i = 0; i < manager.length; ++i) {
                this.moveTo(manager[i], newPosition++);
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveEnd(DownloadManager[] manager) {
        try {
            this.managers_mon.enter();
            int endPosComplete = 0;
            int endPosIncomplete = 0;
            for (int j = 0; j < this.managers_cow.size(); ++j) {
                DownloadManager dm = this.managers_cow.get(j);
                if (dm.isDownloadComplete(false)) {
                    ++endPosComplete;
                    continue;
                }
                ++endPosIncomplete;
            }
            for (int i = manager.length - 1; i >= 0; --i) {
                if (manager[i].isDownloadComplete(false) && endPosComplete > 0) {
                    this.moveTo(manager[i], endPosComplete--);
                    continue;
                }
                if (endPosIncomplete <= 0) continue;
                this.moveTo(manager[i], endPosIncomplete--);
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTo(DownloadManager manager, int newPosition) {
        boolean curCompleted = manager.isDownloadComplete(false);
        if (newPosition < 1 || newPosition > this.downloadManagerCount(curCompleted)) {
            return;
        }
        try {
            this.managers_mon.enter();
            int curPosition = manager.getPosition();
            if (newPosition > curPosition) {
                int numToMove = newPosition - curPosition;
                for (int i = 0; i < this.managers_cow.size(); ++i) {
                    int dmPosition;
                    DownloadManager dm = this.managers_cow.get(i);
                    boolean dmCompleted = dm.isDownloadComplete(false);
                    if (dmCompleted != curCompleted || (dmPosition = dm.getPosition()) <= curPosition || dmPosition > newPosition) continue;
                    dm.setPosition(dmPosition - 1);
                    if (--numToMove <= 0) break;
                }
                manager.setPosition(newPosition);
            } else if (newPosition < curPosition && curPosition > 1) {
                int numToMove = curPosition - newPosition;
                for (int i = 0; i < this.managers_cow.size(); ++i) {
                    DownloadManager dm = this.managers_cow.get(i);
                    boolean dmCompleted = dm.isDownloadComplete(false);
                    int dmPosition = dm.getPosition();
                    if (dmCompleted != curCompleted || dmPosition < newPosition || dmPosition >= curPosition) continue;
                    dm.setPosition(dmPosition + 1);
                    if (--numToMove <= 0) break;
                }
                manager.setPosition(newPosition);
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fixUpDownloadManagerPositions() {
        try {
            this.managers_mon.enter();
            int posComplete = 1;
            int posIncomplete = 1;
            ArrayList<DownloadManager> managers_temp = new ArrayList<DownloadManager>(this.managers_cow);
            Collections.sort(managers_temp, new Comparator(){

                public final int compare(Object a, Object b) {
                    int i = ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
                    if (i != 0) {
                        return i;
                    }
                    if (((DownloadManager)a).isPersistent()) {
                        return 1;
                    }
                    if (((DownloadManager)b).isPersistent()) {
                        return -1;
                    }
                    return 0;
                }
            });
            this.managers_cow = managers_temp;
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager dm = this.managers_cow.get(i);
                if (dm.isDownloadComplete(false)) {
                    dm.setPosition(posComplete++);
                    continue;
                }
                dm.setPosition(posIncomplete++);
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    @Override
    public long getResolverTaggableType() {
        return 2L;
    }

    @Override
    public Taggable resolveTaggable(String id) {
        if (id == null) {
            return null;
        }
        return this.getDownloadManager(new HashWrapper(Base32.decode(id)));
    }

    @Override
    public List<Taggable> getResolvedTaggables() {
        return new ArrayList<Taggable>(this.getDownloadManagers());
    }

    @Override
    public String getDisplayName(Taggable taggable) {
        return ((DownloadManager)taggable).getDisplayName();
    }

    @Override
    public void requestAttention(String id) {
        DownloadManager dm = this.getDownloadManager(new HashWrapper(Base32.decode(id)));
        if (dm != null) {
            dm.requestAttention();
        }
    }

    protected void informDestroyed() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.listeners_and_event_listeners.dispatch(4, null, true);
    }

    public void informDestroyInitiated() {
        this.listeners_and_event_listeners.dispatch(3, null, true);
    }

    @Override
    public void addListener(GlobalManagerListener listener) {
        this.addListener(listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(GlobalManagerListener listener, boolean trigger) {
        if (this.isStopping) {
            listener.destroyed();
        } else {
            this.listeners_and_event_listeners.addListener(listener);
            if (!trigger) {
                return;
            }
            try {
                this.managers_mon.enter();
                List<DownloadManager> managers = this.managers_cow;
                for (int i = 0; i < managers.size(); ++i) {
                    listener.downloadManagerAdded(managers.get(i));
                }
            }
            finally {
                this.managers_mon.exit();
            }
        }
    }

    @Override
    public void removeListener(GlobalManagerListener listener) {
        this.listeners_and_event_listeners.removeListener(listener);
    }

    @Override
    public void addEventListener(GlobalManagerEventListener listener) {
        this.listeners_and_event_listeners.addListener(listener);
    }

    @Override
    public void removeEventListener(GlobalManagerEventListener listener) {
        this.listeners_and_event_listeners.removeListener(listener);
    }

    @Override
    public void fireGlobalManagerEvent(final int type, final DownloadManager param) {
        this.listeners_and_event_listeners.dispatch(6, new GlobalManagerEvent(){

            @Override
            public int getEventType() {
                return type;
            }

            @Override
            public DownloadManager getDownload() {
                return param;
            }
        });
    }

    @Override
    public void addDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.addListener(l);
    }

    @Override
    public void removeDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.removeListener(l);
    }

    @Override
    public void stateChanged(DownloadManager manager, int new_state) {
        if (this.needsSavingCozStateChanged == 0L) {
            this.needsSavingCozStateChanged = SystemTime.getMonotonousTime();
        }
        PEPeerManager pm_manager = manager.getPeerManager();
        if (new_state == 50 && pm_manager != null && pm_manager.hasDownloadablePiece()) {
            this.setSeedingOnlyState(false, false);
        } else {
            this.checkSeedingOnlyState();
        }
        this.checkForceStart(manager.isForceStart() && new_state == 50);
    }

    protected void checkForceStart(boolean known_to_exist) {
        boolean exists;
        if (known_to_exist) {
            exists = true;
        } else {
            exists = false;
            if (this.force_start_non_seed_exists) {
                List<DownloadManager> managers = this.managers_cow;
                for (int i = 0; i < managers.size(); ++i) {
                    DownloadManager dm = managers.get(i);
                    if (!dm.isForceStart() || dm.getState() != 50) continue;
                    exists = true;
                    break;
                }
            }
        }
        if (exists != this.force_start_non_seed_exists) {
            this.force_start_non_seed_exists = exists;
            Logger.log(new LogEvent(LOGID, "Force start download " + (this.force_start_non_seed_exists ? "exists" : "doesn't exist") + ", modifying download weighting"));
            PeerControlSchedulerFactory.overrideWeightedPriorities(this.force_start_non_seed_exists);
        }
    }

    protected void checkSeedingOnlyState() {
        this.check_seeding_only_state_dispatcher.dispatch();
    }

    protected void checkSeedingOnlyStateSupport() {
        boolean seeding = false;
        boolean seeding_set = false;
        boolean potentially_seeding = false;
        List<DownloadManager> managers = this.managers_cow;
        for (int i = 0; i < managers.size(); ++i) {
            DownloadManager dm = managers.get(i);
            PEPeerManager pm = dm.getPeerManager();
            int state = dm.getState();
            if (dm.getDiskManager() == null || pm == null) {
                if (state != 75) continue;
                if (dm.isDownloadComplete(false)) {
                    potentially_seeding = true;
                    continue;
                }
                seeding = false;
                seeding_set = true;
                continue;
            }
            if (state == 50) {
                if (!pm.hasDownloadablePiece()) {
                    if (seeding_set) continue;
                    seeding = true;
                    continue;
                }
                seeding = false;
                potentially_seeding = false;
                break;
            }
            if (state != 60 || seeding_set) continue;
            seeding = true;
        }
        if (seeding) {
            potentially_seeding = true;
        }
        this.setSeedingOnlyState(seeding, potentially_seeding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSeedingOnlyState(boolean seeding, boolean potentially_seeding) {
        GlobalManagerImpl globalManagerImpl = this;
        synchronized (globalManagerImpl) {
            if (seeding != this.seeding_only_mode || potentially_seeding != this.potentially_seeding_only_mode) {
                this.seeding_only_mode = seeding;
                this.potentially_seeding_only_mode = potentially_seeding;
                this.listeners_and_event_listeners.dispatch(5, new boolean[]{this.seeding_only_mode, this.potentially_seeding_only_mode});
            }
        }
    }

    @Override
    public boolean isSeedingOnly() {
        return this.seeding_only_mode;
    }

    @Override
    public boolean isPotentiallySeedingOnly() {
        return this.potentially_seeding_only_mode;
    }

    public long getTotalSwarmsPeerRate(boolean downloading, boolean seeding) {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_swarm_stats_calc_time || now - this.last_swarm_stats_calc_time >= 1000L) {
            long total = 0L;
            List<DownloadManager> managers = this.managers_cow;
            for (int i = 0; i < managers.size(); ++i) {
                boolean is_seeding;
                DownloadManager manager = managers.get(i);
                boolean bl = is_seeding = manager.getState() == 60;
                if ((!downloading || is_seeding) && (!seeding || !is_seeding)) continue;
                total += manager.getStats().getTotalAveragePerPeer();
            }
            this.last_swarm_stats = total;
            this.last_swarm_stats_calc_time = now;
        }
        return this.last_swarm_stats;
    }

    protected void computeNATStatus() {
        int num_ok = 0;
        int num_probably_ok = 0;
        int num_bad = 0;
        for (DownloadManager manager : this.managers_cow) {
            int status = manager.getNATStatus();
            if (status == 1) {
                ++num_ok;
                continue;
            }
            if (status == 2) {
                ++num_probably_ok;
                continue;
            }
            if (status != 3) continue;
            ++num_bad;
        }
        long now = SystemTime.getMonotonousTime();
        if (num_ok > 0) {
            this.nat_status = 1;
            this.nat_status_last_good = now;
        } else if (this.nat_status_last_good != -1L && now - this.nat_status_last_good < 1800000L) {
            this.nat_status = 1;
        } else if (this.nat_status_last_good != -1L && SystemTime.getCurrentTime() - TCPNetworkManager.getSingleton().getLastIncomingNonLocalConnectionTime() < 1800000L) {
            this.nat_status = 1;
        } else if (num_probably_ok > 0 || this.nat_status_probably_ok) {
            this.nat_status = 2;
            this.nat_status_probably_ok = true;
        } else {
            this.nat_status = num_bad > 0 ? 3 : 0;
        }
    }

    @Override
    public int getNATStatus() {
        return this.nat_status;
    }

    protected void seedPieceRecheck() {
        DownloadManager manager;
        int i;
        List<DownloadManager> managers = this.managers_cow;
        if (this.next_seed_piece_recheck_index >= managers.size()) {
            this.next_seed_piece_recheck_index = 0;
        }
        for (i = this.next_seed_piece_recheck_index; i < managers.size(); ++i) {
            manager = managers.get(i);
            if (!this.seedPieceRecheck(manager)) continue;
            this.next_seed_piece_recheck_index = i + 1;
            if (this.next_seed_piece_recheck_index >= managers.size()) {
                this.next_seed_piece_recheck_index = 0;
            }
            return;
        }
        for (i = 0; i < this.next_seed_piece_recheck_index; ++i) {
            manager = managers.get(i);
            if (!this.seedPieceRecheck(manager)) continue;
            this.next_seed_piece_recheck_index = i + 1;
            if (this.next_seed_piece_recheck_index >= managers.size()) {
                this.next_seed_piece_recheck_index = 0;
            }
            return;
        }
    }

    protected boolean seedPieceRecheck(DownloadManager manager) {
        if (manager.getState() != 60) {
            return false;
        }
        return manager.seedPieceRecheck();
    }

    protected DownloadManagerInitialisationAdapter getDMAdapter(DownloadManagerInitialisationAdapter adapter) {
        List adapters = this.dm_adapters.getList();
        adapters = new ArrayList(adapters);
        if (adapter != null) {
            adapters.add(adapter);
        }
        ArrayList<DownloadManagerInitialisationAdapter> tag_assigners = new ArrayList<DownloadManagerInitialisationAdapter>();
        ArrayList<DownloadManagerInitialisationAdapter> tag_processors = new ArrayList<DownloadManagerInitialisationAdapter>();
        for (DownloadManagerInitialisationAdapter a : adapters) {
            int actions = a.getActions();
            if ((actions & 1) != 0) {
                tag_assigners.add(a);
            }
            if ((actions & 2) == 0) continue;
            tag_processors.add(a);
        }
        if (tag_assigners.size() > 0 && tag_processors.size() > 0) {
            for (DownloadManagerInitialisationAdapter a : tag_processors) {
                adapters.remove(a);
            }
            int pos = adapters.indexOf(tag_assigners.get(tag_assigners.size() - 1));
            for (DownloadManagerInitialisationAdapter a : tag_processors) {
                adapters.add(++pos, a);
            }
        }
        final List f_adapters = adapters;
        return new DownloadManagerInitialisationAdapter(){

            @Override
            public int getActions() {
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initialised(DownloadManager manager, boolean for_seeding) {
                for (int i = 0; i < f_adapters.size(); ++i) {
                    try {
                        ((DownloadManagerInitialisationAdapter)f_adapters.get(i)).initialised(manager, for_seeding);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (Constants.isOSX) {
                    GlobalManagerImpl.this.fixLongFileName(manager);
                }
                if (COConfigurationManager.getBooleanParameter("Rename Incomplete Files")) {
                    DiskManagerFileInfo[] fileInfos;
                    String ext = COConfigurationManager.getStringParameter("Rename Incomplete Files Extension").trim();
                    boolean use_prefix = COConfigurationManager.getBooleanParameter("Use Incomplete File Prefix");
                    DownloadManagerState state = manager.getDownloadState();
                    String existing_ext = state.getAttribute("incompfilesuffix");
                    if (ext.length() > 0 && existing_ext == null && (fileInfos = manager.getDiskManagerFileInfo()).length <= DownloadManagerStateFactory.MAX_FILES_FOR_INCOMPLETE_AND_DND_LINKAGE) {
                        ext = FileUtil.convertOSSpecificChars(ext, false);
                        String prefix = "";
                        if (use_prefix) {
                            try {
                                prefix = Base32.encode(manager.getTorrent().getHash()).substring(0, 12).toLowerCase(Locale.US) + "_";
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                        try {
                            state.suppressStateSave(true);
                            ArrayList<Integer> from_indexes = new ArrayList<Integer>();
                            ArrayList<File> from_links = new ArrayList<File>();
                            ArrayList<File> to_links = new ArrayList<File>();
                            for (int i = 0; i < fileInfos.length; ++i) {
                                File new_link;
                                DiskManagerFileInfo fileInfo2 = fileInfos[i];
                                File base_file = fileInfo2.getFile(false);
                                File existing_link = state.getFileLink(i, base_file);
                                if (existing_link == null && base_file.exists() || existing_link != null && existing_link.exists()) continue;
                                if (existing_link == null) {
                                    new_link = new File(base_file.getParentFile(), prefix + base_file.getName() + ext);
                                } else {
                                    String link_name = existing_link.getName();
                                    if (!link_name.startsWith(prefix)) {
                                        link_name = prefix + link_name;
                                    }
                                    new_link = new File(existing_link.getParentFile(), link_name + ext);
                                }
                                from_indexes.add(i);
                                from_links.add(base_file);
                                to_links.add(new_link);
                            }
                            if (from_links.size() > 0) {
                                state.setFileLinks(from_indexes, from_links, to_links);
                            }
                        }
                        finally {
                            state.setAttribute("incompfilesuffix", ext);
                            if (use_prefix) {
                                state.setAttribute("dnd_pfx", prefix);
                            }
                            state.suppressStateSave(false);
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixLongFileName(DownloadManager manager) {
        DiskManagerFileInfo[] fileInfos = manager.getDiskManagerFileInfo();
        DownloadManagerState state = manager.getDownloadState();
        try {
            state.suppressStateSave(true);
            block6: for (int i = 0; i < fileInfos.length; ++i) {
                DiskManagerFileInfo fileInfo2 = fileInfos[i];
                File base_file = fileInfo2.getFile(false);
                File existing_link = state.getFileLink(i, base_file);
                if (existing_link != null || base_file.exists()) continue;
                String name = base_file.getName();
                String ext = FileUtil.getExtension(name);
                int extLength = ext.length();
                int origLength = (name = name.substring(0, name.length() - extLength)).length();
                if (origLength <= 50) continue;
                File parentFile = base_file.getParentFile();
                parentFile.mkdirs();
                File newFile = null;
                boolean first = true;
                while (name.length() > 50) {
                    try {
                        boolean redo;
                        newFile = new File(parentFile, name + ext);
                        newFile.getCanonicalPath();
                        if (first) continue block6;
                        int fixNameID = 255;
                        block8: do {
                            redo = false;
                            for (int j = 0; j < i; ++j) {
                                DiskManagerFileInfo convertedFileInfo = fileInfos[j];
                                if (!newFile.equals(convertedFileInfo.getFile(true))) continue;
                                while (++fixNameID < 4095 && (newFile = new File(parentFile, (name = name.substring(0, name.length() - 3) + Integer.toHexString(fixNameID)) + ext)).equals(convertedFileInfo.getFile(true))) {
                                }
                                redo = fixNameID <= 4095;
                                continue block8;
                            }
                        } while (redo);
                        if (fixNameID > 4095) continue block6;
                        state.setFileLink(i, base_file, newFile);
                        continue block6;
                    }
                    catch (IOException e) {
                        first = false;
                        name = name.substring(0, name.length() - 1);
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
            }
        }
        finally {
            state.suppressStateSave(false);
        }
    }

    @Override
    public void addDownloadManagerInitialisationAdapter(DownloadManagerInitialisationAdapter adapter) {
        this.dm_adapters.add(adapter);
    }

    @Override
    public void removeDownloadManagerInitialisationAdapter(DownloadManagerInitialisationAdapter adapter) {
        this.dm_adapters.remove(adapter);
    }

    @Override
    public Object getDownloadHistoryManager() {
        return this.download_history_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Global Manager");
        try {
            writer.indent();
            this.managers_mon.enter();
            writer.println("  managers: " + this.managers_cow.size());
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager manager = this.managers_cow.get(i);
                try {
                    writer.indent();
                    manager.generateEvidence(writer);
                    continue;
                }
                finally {
                    writer.exdent();
                }
            }
        }
        finally {
            this.managers_mon.exit();
            writer.exdent();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"C:\\temp\\downloads.config", "C:\\temp\\downloads-9-3-05.config", "C:\\temp\\merged.config"};
        } else if (args.length != 3) {
            System.out.println("Usage: newer_config_file older_config_file save_config_file");
            return;
        }
        try {
            Map map1 = FileUtil.readResilientFile(new File(args[0]));
            Map map2 = FileUtil.readResilientFile(new File(args[1]));
            List downloads1 = (List)map1.get("downloads");
            List downloads2 = (List)map2.get("downloads");
            HashSet<HashWrapper> torrents = new HashSet<HashWrapper>();
            for (Map m : downloads1) {
                byte[] hash = (byte[])m.get("torrent_hash");
                System.out.println("1:" + ByteFormatter.nicePrint(hash));
                torrents.add(new HashWrapper(hash));
            }
            ArrayList<Map> to_add = new ArrayList<Map>();
            for (Map m : downloads2) {
                byte[] hash = (byte[])m.get("torrent_hash");
                HashWrapper wrapper2 = new HashWrapper(hash);
                if (torrents.contains(wrapper2)) {
                    System.out.println("-:" + ByteFormatter.nicePrint(hash));
                    continue;
                }
                System.out.println("2:" + ByteFormatter.nicePrint(hash));
                to_add.add(m);
            }
            downloads1.addAll(to_add);
            System.out.println(to_add.size() + " copied from " + args[1] + " to " + args[2]);
            FileUtil.writeResilientFile(new File(args[2]), map1);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setMainlineDHTProvider(MainlineDHTProvider provider2) {
        this.provider = provider2;
    }

    @Override
    public MainlineDHTProvider getMainlineDHTProvider() {
        return this.provider;
    }

    @Override
    public void statsRequest(Map request2, Map reply) {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        HashMap<String, Long> glob = new HashMap<String, Long>();
        reply.put("gm", glob);
        try {
            boolean bias_up;
            glob.put("u_rate", new Long(this.stats.getDataAndProtocolSendRate()));
            glob.put("d_rate", new Long(this.stats.getDataAndProtocolReceiveRate()));
            glob.put("d_lim", new Long(TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond()));
            boolean auto_up = TransferSpeedValidator.isAutoSpeedActive(this) && TransferSpeedValidator.isAutoUploadAvailable(core);
            glob.put("auto_up", new Long(auto_up ? COConfigurationManager.getLongParameter("Auto Upload Speed Version") : 0L));
            long up_lim = NetworkManager.getMaxUploadRateBPSNormal();
            boolean seeding_only = NetworkManager.isSeedingOnlyUploadRate();
            glob.put("so", new Long(seeding_only ? 1L : 0L));
            if (seeding_only) {
                up_lim = NetworkManager.getMaxUploadRateBPSSeedingOnly();
            }
            glob.put("u_lim", new Long(up_lim));
            SpeedManager sm = core.getSpeedManager();
            if (sm != null) {
                glob.put("u_cap", new Long(sm.getEstimatedUploadCapacityBytesPerSec().getBytesPerSec()));
                glob.put("d_cap", new Long(sm.getEstimatedDownloadCapacityBytesPerSec().getBytesPerSec()));
            }
            List<DownloadManager> dms = this.getDownloadManagers();
            int comp2 = 0;
            int incomp = 0;
            long comp_up = 0L;
            long incomp_up = 0L;
            long incomp_down = 0L;
            for (DownloadManager dm : dms) {
                int state = dm.getState();
                if (state != 60 && state != 50) continue;
                DownloadManagerStats stats2 = dm.getStats();
                if (dm.isDownloadComplete(false)) {
                    ++comp2;
                    comp_up += stats2.getProtocolSendRate() + stats2.getDataSendRate();
                    continue;
                }
                ++incomp;
                incomp_up += stats2.getProtocolSendRate() + stats2.getDataSendRate();
                incomp_down += stats2.getProtocolReceiveRate() + stats2.getDataReceiveRate();
            }
            glob.put("dm_i", new Long(incomp));
            glob.put("dm_c", new Long(comp2));
            glob.put("dm_i_u", new Long(incomp_up));
            glob.put("dm_i_d", new Long(incomp_down));
            glob.put("dm_c_u", new Long(comp_up));
            glob.put("nat", new Long(this.nat_status));
            boolean request_limiting = COConfigurationManager.getBooleanParameter("Use Request Limiting");
            glob.put("req_lim", new Long(request_limiting ? 1L : 0L));
            if (request_limiting) {
                glob.put("req_focus", new Long(COConfigurationManager.getBooleanParameter("Use Request Limiting Priorities") ? 1L : 0L));
            }
            glob.put("bias_up", new Long((bias_up = COConfigurationManager.getBooleanParameter("Bias Upload Enable")) ? 1L : 0L));
            if (bias_up) {
                glob.put("bias_slack", new Long(COConfigurationManager.getLongParameter("Bias Upload Slack KBs")));
                glob.put("bias_ulim", new Long(COConfigurationManager.getBooleanParameter("Bias Upload Handle No Limit") ? 1L : 0L));
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Tracker Client Scrape Stopped Enable", "Insufficient Space Download Restart Enable", "Insufficient Space Download Restart Period"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                enable_stopped_scrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Stopped Enable");
                enable_no_space_dl_restarts = COConfigurationManager.getBooleanParameter("Insufficient Space Download Restart Enable");
                if (enable_no_space_dl_restarts) {
                    int mins = COConfigurationManager.getIntParameter("Insufficient Space Download Restart Period");
                    no_space_dl_restart_check_period_millis = Math.max(1, mins) * 60 * 1000;
                } else {
                    no_space_dl_restart_check_period_millis = 0;
                }
            }
        });
    }

    public class Checker
    extends AEThread {
        int loopFactor;
        private static final int waitTime = 10000;
        private int saveResumeLoopCount;
        private static final int initSaveResumeLoopCount = 6;
        private static final int natCheckLoopCount = 3;
        private static final int seedPieceCheckCount = 3;
        private static final int oneMinuteThingCount = 6;
        private final AESemaphore run_sem;

        public Checker() {
            super("Global Status Checker");
            this.saveResumeLoopCount = 30;
            this.run_sem = new AESemaphore("GM:Checker:run");
            this.loopFactor = 0;
            this.setPriority(1);
        }

        private void determineSaveResumeDataInterval() {
            int saveResumeInterval = COConfigurationManager.getIntParameter("Save Resume Interval", 5);
            if (saveResumeInterval >= 1 && saveResumeInterval <= 90) {
                this.saveResumeLoopCount = saveResumeInterval * 60000 / 10000;
            }
        }

        @Override
        public void runSupport() {
            while (true) {
                block22: {
                    try {
                        int lc;
                        ++this.loopFactor;
                        this.determineSaveResumeDataInterval();
                        if (this.loopFactor % this.saveResumeLoopCount == 0) {
                            GlobalManagerImpl.this.saveDownloads(true);
                        } else if (GlobalManagerImpl.this.loadingComplete && this.loopFactor > 6 && GlobalManagerImpl.this.needsSavingCozStateChanged > 0L) {
                            int num_downloads = GlobalManagerImpl.this.managers_cow.size();
                            boolean do_save = false;
                            if (num_downloads < 10) {
                                do_save = true;
                            } else {
                                long now = SystemTime.getMonotonousTime();
                                long elapsed_secs = (now - GlobalManagerImpl.this.needsSavingCozStateChanged) / 1000L;
                                boolean bl = do_save = elapsed_secs > (long)num_downloads;
                            }
                            if (do_save) {
                                GlobalManagerImpl.this.saveDownloads(true);
                            }
                        }
                        if (this.loopFactor % 3 == 0) {
                            GlobalManagerImpl.this.computeNATStatus();
                            GlobalManagerImpl.this.checkSeedingOnlyState();
                            GlobalManagerImpl.this.checkForceStart(false);
                        }
                        if (this.loopFactor % 3 == 0) {
                            GlobalManagerImpl.this.seedPieceRecheck();
                        }
                        if (this.loopFactor % this.saveResumeLoopCount == 0) {
                            for (DownloadManager manager : GlobalManagerImpl.this.managers_cow) {
                                manager.saveResumeData();
                            }
                        }
                        if (no_space_dl_restart_check_period_millis > 0 && this.loopFactor % (lc = no_space_dl_restart_check_period_millis / 10000) == 0) {
                            ArrayList<DownloadManager> eligible = new ArrayList<DownloadManager>();
                            for (DownloadManager manager : GlobalManagerImpl.this.managers_cow) {
                                if (manager.getState() != 100 || manager.isDownloadComplete(false) || manager.isPaused() || manager.getErrorType() != 2) continue;
                                eligible.add(manager);
                            }
                            if (!eligible.isEmpty()) {
                                if (eligible.size() > 1) {
                                    Collections.sort(eligible, new Comparator<DownloadManager>(){

                                        @Override
                                        public int compare(DownloadManager o1, DownloadManager o2) {
                                            return o1.getPosition() - o2.getPosition();
                                        }
                                    });
                                }
                                DownloadManager manager = (DownloadManager)eligible.get(0);
                                Logger.log(new LogEvent(LOGID, "Restarting download '" + manager.getDisplayName() + "' to check if disk space now available"));
                                manager.setStateQueued();
                            }
                        }
                        if (this.loopFactor % 6 != 0) break block22;
                        try {
                            if (!HttpURLConnection.getFollowRedirects()) {
                                Debug.outNoStack("Something has set global 'follow redirects' to false!!!!");
                                HttpURLConnection.setFollowRedirects(true);
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                try {
                    this.run_sem.reserve(10000L);
                    if (!this.run_sem.isReleasedForever()) continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    continue;
                }
                break;
            }
        }

        public void stopIt() {
            this.run_sem.releaseForever();
        }
    }

    private static class DownloadStateTagger
    extends TagTypeWithState
    implements DownloadManagerListener {
        private static final int[] color_default = new int[]{41, 140, 165};
        private final Object main_tag_key = new Object();
        private final Object comp_tag_key = new Object();
        private final TagDownloadWithState tag_initialising;
        private final TagDownloadWithState tag_downloading;
        private final TagDownloadWithState tag_seeding;
        private final TagDownloadWithState tag_queued_downloading;
        private final TagDownloadWithState tag_queued_seeding;
        private final TagDownloadWithState tag_stopped;
        private final TagDownloadWithState tag_error;
        private final TagDownloadWithState tag_active;
        private final TagDownloadWithState tag_inactive;
        private final TagDownloadWithState tag_complete;
        private final TagDownloadWithState tag_incomplete;
        private final TagDownloadWithState tag_paused;
        private int user_mode = -1;

        private DownloadStateTagger(GlobalManagerImpl _gm) {
            super(2, 255, "tag.type.ds");
            COConfigurationManager.addAndFireParameterListener("User Mode", new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    int old_mode = DownloadStateTagger.this.user_mode;
                    DownloadStateTagger.this.user_mode = COConfigurationManager.getIntParameter("User Mode");
                    if (old_mode != -1) {
                        DownloadStateTagger.this.fireChanged();
                    }
                }
            });
            this.addTagType();
            this.tag_initialising = new MyTag(0, "tag.type.ds.init", false, false, false, false, 0);
            this.tag_downloading = new MyTag(1, "tag.type.ds.down", true, true, true, true, 3);
            this.tag_seeding = new MyTag(2, "tag.type.ds.seed", true, true, false, true, 3);
            this.tag_queued_downloading = new MyTag(3, "tag.type.ds.qford", false, false, false, false, 3);
            this.tag_queued_seeding = new MyTag(4, "tag.type.ds.qfors", false, false, false, false, 3);
            this.tag_stopped = new MyTag(5, "tag.type.ds.stop", false, false, false, false, 8);
            this.tag_error = new MyTag(6, "tag.type.ds.err", false, false, false, false, 0);
            this.tag_active = new MyTag(7, "tag.type.ds.act", true, false, false, false, 3);
            this.tag_paused = new MyTag(8, "tag.type.ds.pau", false, false, false, false, 4);
            this.tag_inactive = new MyTag(9, "tag.type.ds.inact", false, false, false, false, 11);
            this.tag_complete = new MyTag(10, "tag.type.ds.comp", true, true, false, true, 11);
            this.tag_incomplete = new MyTag(11, "tag.type.ds.incomp", true, true, true, true, 11);
            if (this.tag_active.isColorDefault()) {
                this.tag_active.setColor(new int[]{96, 160, 96});
            }
            if (this.tag_error.isColorDefault()) {
                this.tag_error.setColor(new int[]{132, 16, 58});
            }
            _gm.addListener(new GlobalManagerAdapter(){

                @Override
                public void downloadManagerAdded(DownloadManager dm) {
                    dm.addListener(DownloadStateTagger.this, true);
                }

                @Override
                public void downloadManagerRemoved(DownloadManager dm) {
                    dm.removeListener(DownloadStateTagger.this);
                    DownloadStateTagger.this.remove(dm);
                }
            });
            SimpleTimer.addPeriodicEvent("gm:ds", 10000L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    DownloadStateTagger.this.updateActive();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(DownloadManager manager, int state) {
            Boolean was_complete;
            Tag new_tag;
            if (manager.isDestroyed()) {
                this.remove(manager);
                return;
            }
            Tag old_tag = (Tag)manager.getUserData(this.main_tag_key);
            boolean complete = manager.isDownloadComplete(false);
            switch (state) {
                case 0: 
                case 5: 
                case 10: 
                case 20: 
                case 30: 
                case 40: {
                    if (old_tag == null) {
                        new_tag = this.tag_initialising;
                        break;
                    }
                    new_tag = old_tag;
                    break;
                }
                case 50: 
                case 55: {
                    new_tag = this.tag_downloading;
                    break;
                }
                case 60: {
                    new_tag = this.tag_seeding;
                    break;
                }
                case 65: 
                case 70: 
                case 71: {
                    new_tag = this.tag_stopped;
                    break;
                }
                case 75: {
                    if (complete) {
                        new_tag = this.tag_queued_seeding;
                        break;
                    }
                    new_tag = this.tag_queued_downloading;
                    break;
                }
                default: {
                    new_tag = this.tag_error;
                }
            }
            if (old_tag != new_tag) {
                if (old_tag != null) {
                    old_tag.removeTaggable(manager);
                }
                new_tag.addTaggable(manager);
                manager.setUserData(this.main_tag_key, new_tag);
                DownloadStateTagger downloadStateTagger = this;
                synchronized (downloadStateTagger) {
                    boolean was_inactive = this.tag_inactive.hasTaggable(manager);
                    if (new_tag != this.tag_seeding && new_tag != this.tag_downloading) {
                        this.tag_active.removeTaggable(manager);
                        if (!was_inactive) {
                            this.tag_inactive.addTaggable(manager);
                        }
                    } else {
                        boolean was_active = this.tag_active.hasTaggable(manager);
                        if (!was_active && !was_inactive) {
                            this.tag_inactive.addTaggable(manager);
                        }
                    }
                }
                if (new_tag == this.tag_stopped && manager.isPaused()) {
                    this.tag_paused.addTaggable(manager);
                } else if (old_tag == this.tag_stopped) {
                    this.tag_paused.removeTaggable(manager);
                }
            }
            if ((was_complete = (Boolean)manager.getUserData(this.comp_tag_key)) == null || was_complete != complete) {
                DownloadStateTagger downloadStateTagger = this;
                synchronized (downloadStateTagger) {
                    if (complete) {
                        if (!this.tag_complete.hasTaggable(manager)) {
                            this.tag_complete.addTaggable(manager);
                            this.tag_incomplete.removeTaggable(manager);
                        }
                    } else if (!this.tag_incomplete.hasTaggable(manager)) {
                        this.tag_incomplete.addTaggable(manager);
                        this.tag_complete.removeTaggable(manager);
                    }
                    manager.setUserData(this.comp_tag_key, complete);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateActive() {
            DownloadStateTagger downloadStateTagger = this;
            synchronized (downloadStateTagger) {
                HashSet<DownloadManager> active = new HashSet<DownloadManager>(this.tag_active.getTaggedDownloads());
                for (TagDownloadWithState tag : new TagDownloadWithState[]{this.tag_downloading, this.tag_seeding}) {
                    for (DownloadManager dm : tag.getTaggedDownloads()) {
                        DownloadManagerStats stats2 = dm.getStats();
                        boolean is_active = stats2.getDataReceiveRate() + stats2.getDataSendRate() > 0L && !dm.isDestroyed();
                        if (!is_active) continue;
                        if (!active.remove(dm)) {
                            this.tag_active.addTaggable(dm);
                            this.tag_inactive.removeTaggable(dm);
                        }
                        dm.getDownloadState().setLongAttribute("last.act.tag", SystemTime.getCurrentTime());
                    }
                }
                for (DownloadManager dm : active) {
                    this.tag_active.removeTaggable(dm);
                    if (dm.isDestroyed()) continue;
                    this.tag_inactive.addTaggable(dm);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(DownloadManager manager) {
            Tag old_tag = (Tag)manager.getUserData(this.main_tag_key);
            if (old_tag != null) {
                old_tag.removeTaggable(manager);
            }
            DownloadStateTagger downloadStateTagger = this;
            synchronized (downloadStateTagger) {
                if (this.tag_active.hasTaggable(manager)) {
                    this.tag_active.removeTaggable(manager);
                } else {
                    this.tag_inactive.removeTaggable(manager);
                }
                if (this.tag_complete.hasTaggable(manager)) {
                    this.tag_complete.removeTaggable(manager);
                } else {
                    this.tag_incomplete.removeTaggable(manager);
                }
                if (this.tag_paused.hasTaggable(manager)) {
                    this.tag_paused.removeTaggable(manager);
                }
            }
        }

        @Override
        public void downloadComplete(DownloadManager manager) {
        }

        @Override
        public void completionChanged(DownloadManager manager, boolean bCompleted) {
            this.stateChanged(manager, manager.getState());
        }

        @Override
        public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        }

        @Override
        public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
        }

        @Override
        public int[] getColorDefault() {
            return color_default;
        }

        private class MyTag
        extends TagDownloadWithState {
            private MyTag(int tag_id, String name, boolean do_rates, boolean do_up, boolean do_down, boolean do_bytes, int run_states) {
                super((TagTypeBase)DownloadStateTagger.this, tag_id, name, do_rates, do_up, do_down, do_bytes, run_states);
                this.addTag();
            }

            @Override
            protected boolean getVisibleDefault() {
                int id = this.getTagID();
                if (id >= 7 && id <= 9) {
                    return DownloadStateTagger.this.user_mode > 0;
                }
                return id == 7;
            }

            @Override
            protected boolean getCanBePublicDefault() {
                return false;
            }

            @Override
            public void removeTag() {
                throw new RuntimeException("Not Supported");
            }
        }
    }
}

