/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.util.IdentityHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.impl.GlobalManagerImpl;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerListenerAdapter;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginAdapter;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class GlobalManagerFileMerger {
    private static final boolean TRACE = false;
    private static final int MIN_PIECES = 5;
    private static final int HASH_FAILS_BEFORE_QUIT = 3;
    private static final int TIMER_PERIOD = 5000;
    private static final int FORCE_PIECE_TIMER_PERIOD = 15000;
    private static final int FORCE_PIECE_TIMER_TICKS = 3;
    private static final int SYNC_TIMER_PERIOD = 60000;
    private static final int SYNC_TIMER_TICKS = 12;
    private static final Object merged_data_lock = new Object();
    private final GlobalManagerImpl gm;
    private boolean initialised;
    private boolean enabled;
    private boolean enabled_extended;
    final Map<HashWrapper, DownloadManager> dm_map = new HashMap<HashWrapper, DownloadManager>();
    final List<SameSizeFiles> sames = new ArrayList<SameSizeFiles>();
    final AsyncDispatcher read_write_dispatcher = new AsyncDispatcher("GMFM");
    private TimerEventPeriodic timer_event;

    protected GlobalManagerFileMerger(GlobalManagerImpl _gm) {
        this.gm = _gm;
        PluginInitializer.getDefaultInterface().addListener(new PluginAdapter(){

            @Override
            public void initializationComplete() {
                new DelayedEvent("GMFM:delay", 30000L, new AERunnable(){

                    @Override
                    public void runSupport() {
                        GlobalManagerFileMerger.this.initialise();
                    }
                });
            }
        });
    }

    private void initialise() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Merge Same Size Files", "Merge Same Size Files Extended"}, new ParameterListener(){

            @Override
            public void parameterChanged(String _name) {
                GlobalManagerFileMerger.this.enabled = COConfigurationManager.getBooleanParameter("Merge Same Size Files");
                GlobalManagerFileMerger.this.enabled_extended = COConfigurationManager.getBooleanParameter("Merge Same Size Files Extended");
                if (GlobalManagerFileMerger.this.initialised) {
                    GlobalManagerFileMerger.this.syncFileSets();
                }
            }
        });
        this.gm.addListener(new GlobalManagerAdapter(){

            @Override
            public void downloadManagerAdded(DownloadManager dm) {
                GlobalManagerFileMerger.this.syncFileSets();
            }

            @Override
            public void downloadManagerRemoved(DownloadManager dm) {
                GlobalManagerFileMerger.this.syncFileSets();
            }
        }, false);
        this.syncFileSets();
        this.initialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String isSwarmMerging(DownloadManager dm) {
        Map<HashWrapper, DownloadManager> map = this.dm_map;
        synchronized (map) {
            if (this.sames.size() > 0) {
                StringBuffer result = null;
                for (SameSizeFiles s : this.sames) {
                    if (!s.hasDownloadManager(dm)) continue;
                    String info = s.getInfo();
                    if (result == null) {
                        result = new StringBuffer(1024);
                    } else {
                        result.append("\n");
                    }
                    result.append(info);
                }
                return result == null ? null : result.toString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFileSets() {
        List<DownloadManager> dms = this.gm.getDownloadManagers();
        Map<HashWrapper, DownloadManager> map = this.dm_map;
        synchronized (map) {
            boolean changed = false;
            HashSet<HashWrapper> existing_dm_hashes = new HashSet<HashWrapper>(this.dm_map.keySet());
            if (this.enabled) {
                for (DownloadManager dm : dms) {
                    TOTorrent torrent;
                    DownloadManagerState state;
                    if (!dm.isPersistent() || (state = dm.getDownloadState()).getFlag(16L) || state.getFlag(512L) || !this.enabled_extended && dm.isDownloadComplete(false) || (torrent = dm.getTorrent()) == null) continue;
                    try {
                        HashWrapper hw = torrent.getHashWrapper();
                        if (this.dm_map.containsKey(hw)) {
                            existing_dm_hashes.remove(hw);
                            continue;
                        }
                        this.dm_map.put(hw, dm);
                        changed = true;
                    }
                    catch (Throwable e) {}
                }
            }
            if (existing_dm_hashes.size() > 0) {
                changed = true;
                for (HashWrapper hw : existing_dm_hashes) {
                    this.dm_map.remove(hw);
                }
            }
            if (changed) {
                LinkedList interesting = new LinkedList();
                HashMap size_map = new HashMap();
                for (DownloadManager dm : this.dm_map.values()) {
                    DiskManagerFileInfo[] diskManagerFileInfoArray;
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent == null) continue;
                    for (DiskManagerFileInfo file : diskManagerFileInfoArray = dm.getDiskManagerFileInfoSet().getFiles()) {
                        if (file.getNbPieces() < 5) continue;
                        long len = file.getLength();
                        HashSet<DiskManagerFileInfo> set = (HashSet<DiskManagerFileInfo>)size_map.get(len);
                        if (set == null) {
                            set = new HashSet<DiskManagerFileInfo>();
                            size_map.put(len, set);
                        }
                        boolean same_dm = false;
                        for (DiskManagerFileInfo existing : set) {
                            if (existing.getDownloadManager() != dm) continue;
                            same_dm = true;
                            break;
                        }
                        if (same_dm) continue;
                        set.add(file);
                        if (set.size() != 2) continue;
                        interesting.add(set);
                    }
                }
                Iterator interesting_it = interesting.iterator();
                while (interesting_it.hasNext()) {
                    Set set = (Set)interesting_it.next();
                    boolean all_done = true;
                    for (DiskManagerFileInfo file : set) {
                        if (file.getDownloaded() == file.getLength()) continue;
                        all_done = false;
                        break;
                    }
                    if (!all_done) continue;
                    interesting_it.remove();
                }
                LinkedList<SameSizeFiles> sames_copy = new LinkedList<SameSizeFiles>(this.sames);
                for (Set set : interesting) {
                    boolean found = false;
                    Iterator sames_it = sames_copy.iterator();
                    while (sames_it.hasNext()) {
                        SameSizeFiles same = (SameSizeFiles)sames_it.next();
                        if (!same.sameAs(set)) continue;
                        found = true;
                        sames_it.remove();
                        break;
                    }
                    if (found) continue;
                    this.sames.add(new SameSizeFiles(set));
                }
                for (SameSizeFiles sameSizeFiles : sames_copy) {
                    sameSizeFiles.destroy();
                    this.sames.remove(sameSizeFiles);
                }
                if (this.sames.size() > 0) {
                    if (this.timer_event == null) {
                        this.timer_event = SimpleTimer.addPeriodicEvent("GMFM:sync", 5000L, new TimerEventPerformer(){
                            private int tick_count = 0;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void perform(TimerEvent event2) {
                                ++this.tick_count;
                                Map<HashWrapper, DownloadManager> map = GlobalManagerFileMerger.this.dm_map;
                                synchronized (map) {
                                    for (SameSizeFiles s : GlobalManagerFileMerger.this.sames) {
                                        s.sync(this.tick_count);
                                    }
                                }
                            }
                        });
                    }
                } else if (this.timer_event != null) {
                    this.timer_event.cancel();
                    this.timer_event = null;
                }
            }
        }
    }

    private static interface DownloadManagerPeerListenerEx
    extends DownloadManagerPeerListener {
        public void sync();
    }

    private class SameSizeFiles {
        private final Set<DiskManagerFileInfo> files;
        private final Set<SameSizeFileWrapper> file_wrappers;
        private final Set<DownloadManager> dm_set = new IdentityHashSet<DownloadManager>();
        private boolean completion_logged;
        private volatile boolean dl_has_restarted;
        private volatile boolean destroyed;

        private SameSizeFiles(Set<DiskManagerFileInfo> _files) {
            this.files = _files;
            this.file_wrappers = new HashSet<SameSizeFileWrapper>();
            for (final DiskManagerFileInfo file : this.files) {
                final SameSizeFileWrapper file_wrapper = new SameSizeFileWrapper(file);
                DownloadManager dm = file_wrapper.getDownloadManager();
                this.dm_set.add(dm);
                this.file_wrappers.add(file_wrapper);
                DownloadManagerPeerListenerEx dmpl = new DownloadManagerPeerListenerEx(){
                    final AsyncDispatcher dispatcher = new AsyncDispatcher("GMFM:serial");
                    final Object lock = this;
                    private DiskManager current_disk_manager;
                    private boolean pm_removed;
                    final DiskManagerFileInfoListener file_listener = new DiskManagerFileInfoListener(){

                        @Override
                        public void dataWritten(long offset, long length) {
                            if (SameSizeFiles.this.destroyed) {
                                file.removeListener(this);
                                return;
                            }
                            file_wrapper.dataWritten(offset, length);
                        }

                        @Override
                        public void dataChecked(long offset, long length) {
                            if (SameSizeFiles.this.destroyed) {
                                file.removeListener(this);
                                return;
                            }
                        }
                    };

                    @Override
                    public void sync() {
                        if (SameSizeFiles.this.destroyed) {
                            return;
                        }
                        this.dispatcher.dispatch(new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                if (SameSizeFiles.this.destroyed) {
                                    return;
                                }
                                Object object = lock;
                                synchronized (object) {
                                    if (current_disk_manager == null) {
                                        return;
                                    }
                                    file.removeListener(file_listener);
                                }
                                file.addListener(file_listener);
                            }
                        });
                    }

                    @Override
                    public void peerManagerAdded(final PEPeerManager manager) {
                        if (SameSizeFiles.this.destroyed) {
                            return;
                        }
                        this.dispatcher.dispatch(new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                if (SameSizeFiles.this.destroyed) {
                                    return;
                                }
                                if (pm_removed) {
                                    SameSizeFiles.this.dl_has_restarted = true;
                                }
                                manager.addListener(new PEPeerManagerListenerAdapter(){

                                    @Override
                                    public void pieceCorrupted(PEPeerManager manager, int piece_number) {
                                        if (SameSizeFiles.this.destroyed) {
                                            manager.removeListener(this);
                                            return;
                                        }
                                        file_wrapper.pieceCorrupt(piece_number);
                                    }
                                });
                                Object object = lock;
                                synchronized (object) {
                                    if (current_disk_manager != null) {
                                        file.removeListener(file_listener);
                                    }
                                    current_disk_manager = manager.getDiskManager();
                                    if (current_disk_manager == null) {
                                        return;
                                    }
                                }
                                file.addListener(file_listener);
                            }
                        });
                    }

                    @Override
                    public void peerManagerRemoved(PEPeerManager manager) {
                        this.dispatcher.dispatch(new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                Object object = lock;
                                synchronized (object) {
                                    pm_removed = true;
                                    if (current_disk_manager != null) {
                                        file.removeListener(file_listener);
                                        current_disk_manager = null;
                                    }
                                }
                            }
                        });
                    }

                    @Override
                    public void peerAdded(PEPeer peer) {
                    }

                    @Override
                    public void peerRemoved(PEPeer peer) {
                    }

                    @Override
                    public void peerManagerWillBeAdded(PEPeerManager manager) {
                    }
                };
                dm.setUserData(this, dmpl);
                dm.addPeerListener(dmpl);
            }
            this.dl_has_restarted = true;
        }

        private boolean hasDownloadManager(DownloadManager dm) {
            return this.dm_set.contains(dm);
        }

        private void sync(int tick_count) {
            boolean do_force;
            if (GlobalManagerFileMerger.this.read_write_dispatcher.getQueueSize() > 0) {
                return;
            }
            boolean do_sync = tick_count % 12 == 0;
            boolean bl = do_force = tick_count % 3 == 0;
            if (this.dl_has_restarted) {
                this.dl_has_restarted = false;
                do_sync = true;
            }
            if (!do_sync && !do_force) {
                return;
            }
            HashSet<DiskManagerFileInfo> active = new HashSet<DiskManagerFileInfo>();
            int num_incomplete = 0;
            for (DiskManagerFileInfo file : this.files) {
                int dl_state;
                if (file.isSkipped() || (dl_state = file.getDownloadManager().getState()) != 50 && dl_state != 60) continue;
                active.add(file);
                if (file.getLength() == file.getDownloaded()) continue;
                ++num_incomplete;
            }
            if (num_incomplete > 0 && active.size() > 1) {
                boolean rta_active = false;
                for (DiskManagerFileInfo file : active) {
                    PEPeerManager pm;
                    DownloadManagerPeerListenerEx dmpl;
                    DownloadManager dm = file.getDownloadManager();
                    if (do_sync && (dmpl = (DownloadManagerPeerListenerEx)dm.getUserData(this)) != null) {
                        dmpl.sync();
                    }
                    if ((pm = dm.getPeerManager()) == null || pm.getPiecePicker().getRTAProviders().size() <= 0) continue;
                    rta_active = true;
                }
                if (rta_active) {
                    do_force = false;
                }
                if (do_force) {
                    try {
                        for (SameSizeFileWrapper ss_file : this.file_wrappers) {
                            DiskManagerFileInfo file = ss_file.getFile();
                            if (!active.contains(file)) continue;
                            DiskManager dm = ss_file.getDiskManager();
                            PEPeerManager pm = ss_file.getPeerManager();
                            if (dm == null) continue;
                            DiskManagerPiece[] pieces = dm.getPieces();
                            int first_piece = file.getFirstPieceNumber();
                            int last_piece = file.getLastPieceNumber();
                            long file_length = file.getLength();
                            long piece_size = dm.getPieceLength();
                            long file_start_offset = ss_file.getFileByteOffset();
                            boolean force_done = false;
                            int[] availability = pm.getAvailability();
                            block5: for (int i = first_piece; i <= last_piece && !force_done; ++i) {
                                DiskManagerPiece piece = pieces[i];
                                if (!piece.isInteresting() || availability[i] != 0) continue;
                                long start_in_file = piece_size * (long)i - file_start_offset;
                                long end_in_file_exclusive = start_in_file + (long)piece.getLength();
                                if (start_in_file < 0L) {
                                    start_in_file = 0L;
                                }
                                if (end_in_file_exclusive > file_length) {
                                    end_in_file_exclusive = file_length;
                                }
                                for (SameSizeFileWrapper o_ss_file : this.file_wrappers) {
                                    if (ss_file == o_ss_file || !active.contains(o_ss_file.getFile()) || !o_ss_file.forceRange(i, start_in_file, end_in_file_exclusive)) continue;
                                    force_done = true;
                                    continue block5;
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            if (!do_sync) {
                return;
            }
            if (!this.completion_logged) {
                boolean all_done = true;
                long total_merged = 0L;
                for (SameSizeFileWrapper ssf : this.file_wrappers) {
                    if (ssf.isSkipped()) continue;
                    total_merged += ssf.getMergedByteCount();
                    if (ssf.isComplete()) continue;
                    all_done = false;
                }
                if (all_done) {
                    this.completion_logged = true;
                    if (total_merged > 0L) {
                        String msg = "Successfully merged files:\n";
                        for (SameSizeFileWrapper file : this.file_wrappers) {
                            long merged = file.getMergedByteCount();
                            if (merged <= 0L) continue;
                            DownloadManager dm = file.getDownloadManager();
                            msg = msg + dm.getDisplayName();
                            if (!dm.getTorrent().isSimpleTorrent()) {
                                msg = msg + " - " + file.getFile().getTorrentFile().getRelativePath();
                            }
                            msg = msg + ": " + DisplayFormatters.formatByteCountToKiBEtc(merged) + "\n";
                        }
                        msg = msg + "\nTotal: " + DisplayFormatters.formatByteCountToKiBEtc(total_merged);
                        Logger.log(new LogAlert(true, 0, msg));
                    }
                }
            }
        }

        private boolean sameAs(Set<DiskManagerFileInfo> _others) {
            return ((Object)this.files).equals(_others);
        }

        private void abandon(SameSizeFileWrapper failed) {
            this.destroy();
            String msg = "Abandoned attempt to merge files:\n";
            for (SameSizeFileWrapper file : this.file_wrappers) {
                msg = msg + file.getDownloadManager().getDisplayName() + " - " + file.getFile().getTorrentFile().getRelativePath() + "\n";
            }
            msg = msg + "\nToo many hash fails in " + failed.getDownloadManager().getDisplayName();
            Logger.log(new LogEvent(LogIDs.CORE, msg));
        }

        private String getInfo() {
            StringBuilder msg = new StringBuilder(1024);
            long size = -1L;
            for (SameSizeFileWrapper file : this.file_wrappers) {
                DiskManagerFileInfo f = file.getFile();
                if (size == -1L) {
                    size = f.getLength();
                }
                msg.append("    ");
                msg.append(file.getDownloadManager().getDisplayName());
                msg.append(": ");
                msg.append(f.getTorrentFile().getRelativePath());
                msg.append("\n");
            }
            return "Size: " + DisplayFormatters.formatByteCountToKiBEtc(size) + "\n" + msg.toString();
        }

        private void destroy() {
            this.destroyed = true;
            for (DiskManagerFileInfo file : this.files) {
                DownloadManager dm = file.getDownloadManager();
                DownloadManagerPeerListenerEx dmpl = (DownloadManagerPeerListenerEx)dm.getUserData(this);
                if (dmpl == null) continue;
                dm.removePeerListener(dmpl);
            }
        }

        private String getString() {
            String str = "";
            long size = -1L;
            for (DiskManagerFileInfo file : this.files) {
                size = file.getLength();
                str = str + (str.length() == 0 ? "" : ", ") + file.getTorrentFile().getRelativePath();
            }
            str = str + " - length " + size;
            return str;
        }

        private class SameSizeFileWrapper {
            private final DiskManagerFileInfo file;
            private final DownloadManager download_manager;
            private final long file_byte_offset;
            private final String id;
            private long merged_byte_counnt;
            private final boolean[] modified_pieces;
            private int pieces_completed;
            private int pieces_corrupted;
            private int forced_start_piece = 0;
            private int forced_end_piece = -1;

            private SameSizeFileWrapper(DiskManagerFileInfo _file) {
                String _id;
                this.file = _file;
                this.modified_pieces = new boolean[this.file.getNbPieces()];
                this.download_manager = this.file.getDownloadManager();
                int file_index = this.file.getIndex();
                long fbo = 0L;
                if (file_index > 0) {
                    DiskManagerFileInfo[] f = this.download_manager.getDiskManagerFileInfoSet().getFiles();
                    for (int i = 0; i < file_index; ++i) {
                        fbo += f[i].getLength();
                    }
                }
                try {
                    _id = Base32.encode(this.download_manager.getTorrent().getHash()) + "/" + this.file.getIndex();
                }
                catch (Throwable e) {
                    _id = this.download_manager.getDisplayName() + "/" + this.file.getIndex();
                }
                this.id = _id;
                this.file_byte_offset = fbo;
            }

            private DiskManagerFileInfo getFile() {
                return this.file;
            }

            private boolean isSkipped() {
                return this.file.isSkipped();
            }

            private boolean isComplete() {
                return this.file.getLength() == this.file.getDownloaded();
            }

            private DownloadManager getDownloadManager() {
                return this.download_manager;
            }

            private DiskManager getDiskManager() {
                return this.file.getDiskManager();
            }

            private PEPeerManager getPeerManager() {
                return this.download_manager.getPeerManager();
            }

            private long getFileByteOffset() {
                return this.file_byte_offset;
            }

            private String getID() {
                return this.id;
            }

            private void dataWritten(long offset, long length) {
                boolean[] written;
                boolean[] written2;
                final DiskManager disk_manager = this.getDiskManager();
                PEPeerManager peer_manager = this.getPeerManager();
                if (disk_manager == null || peer_manager == null) {
                    return;
                }
                final DiskManagerPiece[] pieces = disk_manager.getPieces();
                final long piece_length = disk_manager.getPieceLength();
                long written_start = this.file_byte_offset + offset;
                long written_end_inclusive = written_start + length - 1L;
                int first_piece_num = (int)(written_start / piece_length);
                int last_piece_num = (int)(written_end_inclusive / piece_length);
                DiskManagerPiece first_piece = pieces[first_piece_num];
                DiskManagerPiece last_piece = pieces[last_piece_num];
                int first_block = (int)(written_start % piece_length) / 16384;
                int last_block = (int)(written_end_inclusive % piece_length) / 16384;
                if (first_block > 0) {
                    written2 = first_piece.getWritten();
                    if (first_piece.isDone() || written2 != null && written2[first_block - 1]) {
                        --first_block;
                    }
                } else if (first_piece_num > 0) {
                    DiskManagerPiece prev_piece = pieces[first_piece_num - 1];
                    written = prev_piece.getWritten();
                    int nb = prev_piece.getNbBlocks();
                    if (prev_piece.isDone() || written != null && written[nb - 1]) {
                        --first_piece_num;
                        first_block = nb - 1;
                    }
                }
                if (last_block < last_piece.getNbBlocks() - 1) {
                    written2 = last_piece.getWritten();
                    if (last_piece.isDone() || written2 != null && written2[last_block + 1]) {
                        ++last_block;
                    }
                } else if (last_piece_num < pieces.length - 1) {
                    DiskManagerPiece next_piece = pieces[last_piece_num + 1];
                    written = next_piece.getWritten();
                    if (next_piece.isDone() || written != null && written[0]) {
                        ++last_piece_num;
                        last_block = 0;
                    }
                }
                final long avail_start = (long)first_piece_num * piece_length + (long)(first_block * 16384);
                final long avail_end_inclusive = (long)last_piece_num * piece_length + (long)(last_block * 16384) + (long)pieces[last_piece_num].getBlockSize(last_block) - 1L;
                for (final SameSizeFileWrapper other_file : SameSizeFiles.this.file_wrappers) {
                    if (other_file == this || other_file.isSkipped() || other_file.isComplete()) continue;
                    final DiskManager other_disk_manager = other_file.getDiskManager();
                    PEPeerManager other_peer_manager = other_file.getPeerManager();
                    if (other_disk_manager == null || other_peer_manager == null) continue;
                    GlobalManagerFileMerger.this.read_write_dispatcher.dispatch(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        @Override
                        public void runSupport() {
                            block29: {
                                block30: {
                                    if (SameSizeFileWrapper.access$2600(other_file)) {
                                        return;
                                    }
                                    other_pieces = other_disk_manager.getPieces();
                                    other_piece_length = other_disk_manager.getPieceLength();
                                    skew = SameSizeFileWrapper.access$2800(SameSizeFileWrapper.this) - SameSizeFileWrapper.access$2200(other_file);
                                    if (skew % 16384L != 0L) break block30;
                                    for (block_start = avail_start; block_start <= avail_end_inclusive && !SameSizeFiles.access$1300(SameSizeFiles.this); block_start += 16384L) {
                                        origin_piece_num = (int)(block_start / piece_length);
                                        origin_block_num = (int)(block_start % piece_length / 16384L);
                                        target_offset = block_start - skew;
                                        target_piece_num = (int)(target_offset / other_piece_length);
                                        target_block_num = (int)(target_offset % other_piece_length / 16384L);
                                        origin_piece = pieces[origin_piece_num];
                                        target_piece = other_pieces[target_piece_num];
                                        written = target_piece.getWritten();
                                        if (target_piece.isDone() || written != null && written[target_block_num] || origin_piece.getBlockSize(origin_block_num) != target_piece.getBlockSize(target_block_num) || (buffer = disk_manager.readBlock(origin_piece_num, origin_block_num * 16384, origin_piece.getBlockSize(origin_block_num))) == null) continue;
                                        written = target_piece.getWritten();
                                        if (target_piece.isDone() || written != null && written[target_block_num]) continue;
                                        try {
                                            v0 = completed_piece = target_piece.getNbWritten() == target_piece.getNbBlocks() - 1;
                                            if (SameSizeFileWrapper.access$2900(other_file, target_piece_num, target_block_num, buffer)) {
                                                buffer = null;
                                                if (!completed_piece) continue;
                                                SameSizeFileWrapper.access$3008(SameSizeFileWrapper.this);
                                                if (SameSizeFileWrapper.access$3000(SameSizeFileWrapper.this) >= 5) continue;
                                                try {
                                                    Thread.sleep(500L);
                                                }
                                                catch (Throwable e) {}
                                                continue;
                                            }
                                            break block29;
                                        }
                                        finally {
                                            if (buffer != null) {
                                                buffer.returnToPool();
                                            }
                                        }
                                    }
                                    break block29;
                                }
                                prev_block = null;
                                prev_block_pn = 0;
                                prev_block_bn = 0;
lbl42:
                                // 3 sources

                                try {
                                    for (block_start = avail_start; block_start <= avail_end_inclusive; block_start += 16384L) {
                                        if (SameSizeFiles.access$1300(SameSizeFiles.this)) {
                                        }
                                        origin_start = block_start;
                                        target_offset = origin_start - skew;
                                        target_offset = (target_offset + 16384L - 1L) / 16384L * 16384L;
                                        origin_offset = target_offset + skew;
                                        target_piece_num = (int)(target_offset / other_piece_length);
                                        target_block_num = (int)(target_offset % other_piece_length / 16384L);
                                        target_piece = other_pieces[target_piece_num];
                                        target_written = target_piece.getWritten();
                                        if (target_piece.isDone() || target_written != null && (target_block_num >= target_written.length || target_written[target_block_num])) continue;
                                        target_block_size = target_piece.getBlockSize(target_block_num);
                                        if (origin_offset < SameSizeFileWrapper.access$2800(SameSizeFileWrapper.this) || origin_offset + (long)target_block_size > avail_end_inclusive + 1L || !(origin1_piece = pieces[origin1_piece_number = (int)(origin_start / piece_length)]).isWritten(origin1_block_num = (int)(origin_start % piece_length / 16384L))) continue;
                                        read_block1 = null;
                                        read_block2 = null;
                                        write_block = null;
                                        try {
                                            block33: {
                                                block32: {
                                                    block31: {
                                                        if (prev_block == null || prev_block_pn != origin1_piece_number || prev_block_bn != origin1_block_num) break block31;
                                                        read_block1 = prev_block;
                                                        prev_block = null;
                                                        break block32;
                                                    }
                                                    read_block1 = disk_manager.readBlock(origin1_piece_number, origin1_block_num * 16384, origin1_piece.getBlockSize(origin1_block_num));
                                                    if (read_block1 == null) ** GOTO lbl42
                                                }
                                                write_block = DirectByteBufferPool.getBuffer((byte)1, target_block_size);
                                                SS = true;
                                                delta = (int)(origin_offset - origin_start);
                                                read_block1.position((byte)1, delta);
                                                rb1_rem = read_block1.remaining((byte)1);
                                                if (rb1_rem > target_block_size) {
                                                    read_block1.limit((byte)1, delta + target_block_size);
                                                }
                                                write_block.limit((byte)1, read_block1.remaining((byte)1));
                                                write_block.put((byte)1, read_block1);
                                                write_block.limit((byte)1, target_block_size);
                                                read_block1.returnToPool();
                                                read_block1 = null;
                                                if (!write_block.hasRemaining((byte)1)) break block33;
                                                origin2_piece_number = origin1_piece_number;
                                                origin2_block_num = origin1_block_num + 1;
                                                if (origin2_block_num >= origin1_piece.getNbBlocks()) {
                                                    ++origin2_piece_number;
                                                    origin2_block_num = 0;
                                                }
                                                if (origin2_piece_number >= pieces.length) break;
                                                origin2_piece = pieces[origin2_piece_number];
                                                if (!origin2_piece.isWritten(origin2_block_num) || (read_block2 = disk_manager.readBlock(origin2_piece_number, origin2_block_num * 16384, origin2_piece.getBlockSize(origin2_block_num))) == null) ** GOTO lbl42
                                                read_block2.limit((byte)1, write_block.remaining((byte)1));
                                                write_block.put((byte)1, read_block2);
                                                read_block2.position((byte)1, 0);
                                                read_block2.limit((byte)1, read_block2.capacity((byte)1));
                                                prev_block = read_block2;
                                                prev_block_pn = origin2_piece_number;
                                                prev_block_bn = origin2_block_num;
                                                read_block2 = null;
                                            }
                                        }
                                        finally {
                                            if (read_block1 != null) {
                                                read_block1.returnToPool();
                                            }
                                            if (read_block2 != null) {
                                                read_block2.returnToPool();
                                            }
                                            if (write_block != null) {
                                                write_block.returnToPool();
                                            }
                                        }
                                    }
                                }
                                finally {
                                    if (prev_block != null) {
                                        prev_block.returnToPool();
                                    }
                                }
                            }
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean writeBlock(int piece_number, int block_number, DirectByteBuffer buffer) {
                PEPeerManager pm = this.getPeerManager();
                if (pm == null) {
                    return false;
                }
                this.modified_pieces[piece_number - this.file.getFirstPieceNumber()] = true;
                int length = buffer.remaining((byte)1);
                Object object = merged_data_lock;
                synchronized (object) {
                    DownloadManagerState dms = this.download_manager.getDownloadState();
                    long merged = dms.getLongAttribute("mergedata");
                    dms.setLongAttribute("mergedata", merged += (long)length);
                }
                this.merged_byte_counnt += (long)length;
                pm.writeBlock(piece_number, block_number * 16384, buffer, "block-xfer from " + this.getID(), true);
                return true;
            }

            private void pieceCorrupt(int piece_number) {
                int first_piece = this.file.getFirstPieceNumber();
                if (piece_number >= first_piece && piece_number <= this.file.getLastPieceNumber() && this.modified_pieces[piece_number - first_piece]) {
                    ++this.pieces_corrupted;
                    if (this.pieces_corrupted >= 3) {
                        SameSizeFiles.this.abandon(this);
                    }
                }
            }

            private long getMergedByteCount() {
                return this.merged_byte_counnt;
            }

            private boolean forceRange(int for_piece, long start_in_file, long end_in_file_exclusive) {
                DiskManager dm = this.getDiskManager();
                PEPeerManager pm = this.getPeerManager();
                if (dm == null || pm == null) {
                    return false;
                }
                int[] availability = pm.getAvailability();
                long start_in_torrent = start_in_file + this.file_byte_offset;
                long end_in_torrent_inclusive = end_in_file_exclusive + this.file_byte_offset - 1L;
                int piece_size = dm.getPieceLength();
                int first_piece = (int)(start_in_torrent / (long)piece_size);
                int last_piece = (int)(end_in_torrent_inclusive / (long)piece_size);
                DiskManagerPiece[] pieces = dm.getPieces();
                boolean forceable = false;
                for (int i = first_piece; i <= last_piece; ++i) {
                    DiskManagerPiece piece = pieces[i];
                    if (piece.isDone() || availability[piece.getPieceNumber()] <= 0 || !piece.isInteresting()) continue;
                    forceable = true;
                    break;
                }
                if (forceable) {
                    if (this.forced_start_piece != first_piece || this.forced_end_piece != last_piece) {
                        DiskManagerPiece piece;
                        PiecePicker pp = pm.getPiecePicker();
                        if (this.forced_start_piece != first_piece || this.forced_end_piece != last_piece) {
                            for (int i = this.forced_start_piece; i <= this.forced_end_piece; ++i) {
                                piece = pieces[i];
                                pp.setForcePiece(piece.getPieceNumber(), false);
                            }
                        }
                        this.forced_start_piece = first_piece;
                        this.forced_end_piece = last_piece;
                        for (int i = first_piece; i <= last_piece; ++i) {
                            piece = pieces[i];
                            if (piece.isDone()) continue;
                            pp.setForcePiece(i, true);
                        }
                    }
                    return true;
                }
                return false;
            }

            static /* synthetic */ long access$2800(SameSizeFileWrapper x0) {
                return x0.file_byte_offset;
            }

            static /* synthetic */ boolean access$2900(SameSizeFileWrapper x0, int x1, int x2, DirectByteBuffer x3) {
                return x0.writeBlock(x1, x2, x3);
            }

            static /* synthetic */ int access$3008(SameSizeFileWrapper x0) {
                return x0.pieces_completed++;
            }

            static /* synthetic */ int access$3000(SameSizeFileWrapper x0) {
                return x0.pieces_completed;
            }
        }
    }
}

