/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.CopyOnWriteMap;
import com.aelitis.azureus.core.util.LinkFileMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.DownloadManagerStateEvent;
import org.gudy.azureus2.core3.download.DownloadManagerStateListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerDefaultPaths;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class DownloadManagerStateImpl
implements DownloadManagerState,
ParameterListener {
    private static final int VER_INCOMING_PEER_SOURCE = 1;
    private static final int VER_CURRENT = 1;
    private static final LogIDs LOGID;
    private static final String RESUME_KEY = "resume";
    private static final String TRACKER_CACHE_KEY = "tracker_cache";
    private static final String ATTRIBUTE_KEY = "attributes";
    private static final String AZUREUS_PROPERTIES_KEY = "azureus_properties";
    private static final File ACTIVE_DIR;
    public static boolean SUPPRESS_FIXUP_ERRORS;
    private static final Random random;
    private static final Map default_parameters;
    private static final Map default_attributes;
    private static final AEMonitor class_mon;
    static final Map<HashWrapper, DownloadManagerStateImpl> state_map;
    private static final Map global_state_cache;
    private static final ArrayList global_state_cache_wrappers;
    private static final CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> global_listeners_read_map_cow;
    private static final CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> global_listeners_write_map_cow;
    private DownloadManagerImpl download_manager;
    private final TorrentUtils.ExtendedTorrent torrent;
    private boolean write_required;
    private Category category;
    private final CopyOnWriteList<DownloadManagerStateListener> listeners_cow = new CopyOnWriteList();
    private final CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> listeners_read_map_cow = new CopyOnWriteMap();
    private final CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> listeners_write_map_cow = new CopyOnWriteMap();
    private Map parameters;
    private Map attributes;
    private final AEMonitor this_mon = new AEMonitor("DownloadManagerState");
    private int supressWrites = 0;
    private static final ThreadLocal tls_wbr;
    private volatile WeakReference<LinkFileMap> file_link_cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DownloadManagerState getDownloadState(DownloadManagerImpl download_manager, TOTorrent original_torrent, TorrentUtils.ExtendedTorrent target_torrent) throws TOTorrentException {
        byte[] hash = target_torrent.getHash();
        DownloadManagerStateImpl res = null;
        try {
            class_mon.enter();
            HashWrapper hash_wrapper = new HashWrapper(hash);
            res = state_map.get(hash_wrapper);
            if (res == null) {
                res = new DownloadManagerStateImpl(download_manager, target_torrent);
                state_map.put(hash_wrapper, res);
            } else {
                if (res.getDownloadManager() == null && download_manager != null) {
                    res.setDownloadManager(download_manager);
                }
                if (original_torrent != null) {
                    res.mergeTorrentDetails(original_torrent);
                }
            }
        }
        finally {
            class_mon.exit();
        }
        return res;
    }

    public static DownloadManagerState getDownloadState(TOTorrent original_torrent) throws TOTorrentException {
        byte[] torrent_hash = original_torrent.getHash();
        TorrentUtils.ExtendedTorrent saved_state = null;
        File saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash);
        if (saved_file.exists()) {
            try {
                saved_state = TorrentUtils.readDelegateFromFile(saved_file, false);
            }
            catch (Throwable e) {
                Debug.out("Failed to load download state for " + saved_file, e);
            }
        }
        if (saved_state == null) {
            TorrentUtils.copyToFile(original_torrent, saved_file);
            saved_state = TorrentUtils.readDelegateFromFile(saved_file, false);
        }
        return DownloadManagerStateImpl.getDownloadState(null, original_torrent, saved_state);
    }

    protected static DownloadManagerState getDownloadState(DownloadManagerImpl download_manager, String torrent_file, byte[] torrent_hash, boolean inactive) throws TOTorrentException {
        File saved_file;
        boolean discard_pieces = state_map.size() > 32;
        TorrentUtils.ExtendedTorrent original_torrent = null;
        TorrentUtils.ExtendedTorrent saved_state = null;
        if (torrent_hash != null && (saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash)).exists()) {
            try {
                Map cached_state = (Map)global_state_cache.remove(new HashWrapper(torrent_hash));
                if (cached_state != null) {
                    CachedStateWrapper wrapper2 = new CachedStateWrapper(download_manager, torrent_file, torrent_hash, cached_state, inactive);
                    global_state_cache_wrappers.add(wrapper2);
                    saved_state = wrapper2;
                } else {
                    saved_state = TorrentUtils.readDelegateFromFile(saved_file, discard_pieces);
                }
            }
            catch (Throwable e) {
                Debug.out("Failed to load download state for " + saved_file);
            }
        }
        if (saved_state == null) {
            original_torrent = TorrentUtils.readDelegateFromFile(new File(torrent_file), discard_pieces);
            torrent_hash = original_torrent.getHash();
            saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash);
            if (saved_file.exists()) {
                try {
                    saved_state = TorrentUtils.readDelegateFromFile(saved_file, discard_pieces);
                }
                catch (Throwable e) {
                    Debug.out("Failed to load download state for " + saved_file);
                }
            }
            if (saved_state == null) {
                TorrentUtils.copyToFile(original_torrent, saved_file);
                saved_state = TorrentUtils.readDelegateFromFile(saved_file, discard_pieces);
            }
        }
        DownloadManagerState res = DownloadManagerStateImpl.getDownloadState(download_manager, original_torrent, saved_state);
        if (inactive) {
            res.setActive(false);
        }
        return res;
    }

    protected static File getStateFile(byte[] torrent_hash) {
        return new File(ACTIVE_DIR, ByteFormatter.encodeString(torrent_hash) + ".dat");
    }

    protected static File getGlobalStateFile() {
        return new File(ACTIVE_DIR, "cache.dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadGlobalStateCache() {
        File file = DownloadManagerStateImpl.getGlobalStateFile();
        if (!file.canRead()) {
            return;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));
            try {
                Map<String, Object> map = BDecoder.decode(is);
                List cache = (List)map.get("state");
                if (cache != null) {
                    for (int i = 0; i < cache.size(); ++i) {
                        Map entry = (Map)cache.get(i);
                        byte[] hash = (byte[])entry.get("hash");
                        if (hash == null) continue;
                        global_state_cache.put(new HashWrapper(hash), entry);
                    }
                }
                is.close();
            }
            catch (IOException e) {
                Debug.printStackTrace(e);
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGlobalStateCache() {
        try {
            class_mon.enter();
            HashMap map = new HashMap();
            ArrayList<Map> cache = new ArrayList<Map>();
            map.put("state", cache);
            for (DownloadManagerState downloadManagerState : state_map.values()) {
                DownloadManager dm = downloadManagerState.getDownloadManager();
                if (dm == null || !dm.isPersistent()) continue;
                try {
                    Map state = CachedStateWrapper.export(downloadManagerState);
                    cache.add(state);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(DownloadManagerStateImpl.getGlobalStateFile()));
            try {
                gZIPOutputStream.write(BEncoder.encode(map));
                gZIPOutputStream.close();
            }
            catch (IOException e) {
                Debug.printStackTrace(e);
                try {
                    gZIPOutputStream.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            class_mon.exit();
        }
    }

    public static void discardGlobalStateCache() {
        DownloadManagerStateImpl.getGlobalStateFile().delete();
        for (int i = 0; i < global_state_cache_wrappers.size(); ++i) {
            ((CachedStateWrapper)global_state_cache_wrappers.get(i)).clearCache();
        }
        global_state_cache_wrappers.clear();
        global_state_cache_wrappers.trimToSize();
    }

    public static void importDownloadState(File source_dir, byte[] download_hash) throws DownloadManagerException {
        String hash_str = ByteFormatter.encodeString(download_hash);
        String state_file = hash_str + ".dat";
        File target_state_file = new File(ACTIVE_DIR, state_file);
        File source_state_file = new File(source_dir, state_file);
        if (!source_state_file.exists()) {
            throw new DownloadManagerException("Source state file missing: " + source_state_file);
        }
        if (target_state_file.exists()) {
            target_state_file.delete();
        }
        if (!FileUtil.copyFile(source_state_file, target_state_file)) {
            throw new DownloadManagerException("Failed to copy state file: " + source_state_file + " -> " + target_state_file);
        }
        File source_state_dir = new File(source_dir, hash_str);
        if (source_state_dir.exists()) {
            try {
                FileUtil.copyFileOrDirectory(source_state_dir, ACTIVE_DIR);
            }
            catch (Throwable e) {
                target_state_file.delete();
                throw new DownloadManagerException("Failed to copy state dir: " + source_dir + " -> " + ACTIVE_DIR, e);
            }
        }
    }

    public static void deleteDownloadState(byte[] download_hash) throws DownloadManagerException {
        DownloadManagerStateImpl.deleteDownloadState(ACTIVE_DIR, download_hash);
    }

    public static void deleteDownloadState(File source_dir, byte[] download_hash) throws DownloadManagerException {
        String hash_str = ByteFormatter.encodeString(download_hash);
        String state_file = hash_str + ".dat";
        File target_state_file = new File(source_dir, state_file);
        if (target_state_file.exists() && !target_state_file.delete()) {
            throw new DownloadManagerException("Failed to delete state file: " + target_state_file);
        }
        File target_state_dir = new File(source_dir, hash_str);
        if (target_state_dir.exists() && !FileUtil.recursiveDelete(target_state_dir)) {
            throw new DownloadManagerException("Failed to delete state dir: " + target_state_dir);
        }
    }

    protected DownloadManagerStateImpl(DownloadManagerImpl _download_manager, TorrentUtils.ExtendedTorrent _torrent) {
        long flags;
        int version;
        Category cat;
        String cat_string;
        this.download_manager = _download_manager;
        this.torrent = _torrent;
        this.attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if ((cat_string = this.getStringAttribute("category")) != null && (cat = CategoryManager.getCategory(cat_string)) != null) {
            this.setCategory(cat);
        }
        this.parameters = this.getMapAttribute("parameters");
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        if ((version = this.getIntAttribute("version")) < 1) {
            if (this.getPeerSources().length > 0) {
                if (PEPeerSource.isPeerSourceEnabledByDefault("Incoming")) {
                    this.setPeerSourceEnabled("Incoming", true);
                }
            } else {
                this.setPeerSources(PEPeerSource.getDefaultEnabledPeerSources());
            }
        }
        if (((flags = this.getFlags()) & 0x100L) != 0L) {
            try {
                IpFilterManagerFactory.getSingleton().getIPFilter().addExcludedHash(this.torrent.getHash());
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (version < 1) {
            this.setIntAttribute("version", 1);
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.informWritten("parameters");
    }

    @Override
    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    protected void setDownloadManager(DownloadManagerImpl dm) {
        this.download_manager = dm;
    }

    @Override
    public File getStateFile() {
        try {
            File parent = new File(ACTIVE_DIR, ByteFormatter.encodeString(this.torrent.getHash()) + File.separatorChar);
            return StringInterner.internFile(parent);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    @Override
    public void clearTrackerResponseCache() {
        this.setTrackerResponseCache(new HashMap());
    }

    @Override
    public Map getTrackerResponseCache() {
        HashMap tracker_response_cache = null;
        tracker_response_cache = this.torrent.getAdditionalMapProperty(TRACKER_CACHE_KEY);
        if (tracker_response_cache == null) {
            tracker_response_cache = new HashMap();
        }
        return tracker_response_cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrackerResponseCache(Map value) {
        try {
            boolean changed;
            this.this_mon.enter();
            boolean bl = changed = !BEncoder.mapsAreIdentical(value, this.getTrackerResponseCache());
            if (changed) {
                this.write_required = true;
                this.torrent.setAdditionalMapProperty(TRACKER_CACHE_KEY, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getResumeData() {
        try {
            this.this_mon.enter();
            Map map = this.torrent.getAdditionalMapProperty(RESUME_KEY);
            return map;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void clearResumeData() {
        this.setResumeData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResumeData(Map data) {
        try {
            this.this_mon.enter();
            if (data == null) {
                this.setLongAttribute("resumecomplete", 1L);
                this.torrent.removeAdditionalProperty(RESUME_KEY);
            } else {
                this.torrent.setAdditionalMapProperty(RESUME_KEY, data);
                boolean complete = DiskManagerFactory.isTorrentResumeDataComplete(this);
                this.setLongAttribute("resumecomplete", complete ? 2L : 1L);
            }
            this.write_required = true;
        }
        finally {
            this.this_mon.exit();
        }
        this.save();
    }

    @Override
    public boolean isResumeDataComplete() {
        long state = this.getLongAttribute("resumecomplete");
        if (state == 0L) {
            boolean complete = DiskManagerFactory.isTorrentResumeDataComplete(this);
            this.setLongAttribute("resumecomplete", complete ? 2L : 1L);
            return complete;
        }
        return state == 2L;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public void setActive(boolean active) {
        this.torrent.setDiscardFluff(!active);
    }

    @Override
    public void discardFluff() {
        this.torrent.setDiscardFluff(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportState(File target_dir) {
        try {
            this.this_mon.enter();
            this.save(true);
            byte[] hash = this.torrent.getHash();
            String hash_str = ByteFormatter.encodeString(hash);
            String state_file = hash_str + ".dat";
            File existing_state_file = new File(ACTIVE_DIR, state_file);
            File target_state_file = new File(target_dir, state_file);
            if (!FileUtil.copyFile(existing_state_file, target_state_file)) {
                throw new IOException("Failed to copy state file");
            }
            File existing_state_dir = new File(ACTIVE_DIR, hash_str);
            if (existing_state_dir.exists()) {
                FileUtil.copyFileOrDirectory(existing_state_dir, target_dir);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            Debug.out(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void suppressStateSave(boolean suppress) {
        if (suppress) {
            ++this.supressWrites;
        } else if (this.supressWrites > 0) {
            --this.supressWrites;
        }
    }

    @Override
    public void save() {
        this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(boolean force) {
        boolean do_write;
        if (this.supressWrites > 0 && !force) {
            return;
        }
        try {
            this.this_mon.enter();
            do_write = this.write_required;
            this.write_required = false;
        }
        finally {
            this.this_mon.exit();
        }
        if (do_write) {
            try {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Saving state for download '" + TorrentUtils.getLocalisedName(this.torrent) + "'"));
                }
                this.torrent.setAdditionalMapProperty(ATTRIBUTE_KEY, this.attributes);
                TorrentUtils.writeToFile((TOTorrent)this.torrent, true);
            }
            catch (Throwable e) {
                Logger.log(new LogEvent((Object)this.torrent, LOGID, "Saving state", e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        try {
            class_mon.enter();
            HashWrapper wrapper2 = this.torrent.getHashWrapper();
            state_map.remove(wrapper2);
            TorrentUtils.delete(this.torrent);
            File dir = new File(ACTIVE_DIR, ByteFormatter.encodeString(wrapper2.getBytes()));
            if (dir.exists() && dir.isDirectory()) {
                FileUtil.recursiveDelete(dir);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            class_mon.exit();
        }
    }

    protected void mergeTorrentDetails(TOTorrent other_torrent) {
        try {
            boolean write = TorrentUtils.mergeAnnounceURLs(other_torrent, this.torrent);
            if (write) {
                TRTrackerAnnouncer client;
                this.save();
                if (this.download_manager != null && (client = this.download_manager.getTrackerClient()) != null) {
                    client.resetTrackerUrl(false);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void setFlag(long flag, boolean set) {
        long new_value;
        long old_value = this.getLongAttribute("flags");
        if (old_value != (new_value = set ? old_value | flag : old_value & (flag ^ 0xFFFFFFFFFFFFFFFFL))) {
            this.setLongAttribute("flags", new_value);
            if ((old_value & 0x100L) != (new_value & 0x100L)) {
                try {
                    if ((new_value & 0x100L) != 0L) {
                        IpFilterManagerFactory.getSingleton().getIPFilter().addExcludedHash(this.torrent.getHash());
                    } else {
                        IpFilterManagerFactory.getSingleton().getIPFilter().removeExcludedHash(this.torrent.getHash());
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    @Override
    public boolean getFlag(long flag) {
        long value = this.getLongAttribute("flags");
        return (value & flag) != 0L;
    }

    @Override
    public long getFlags() {
        return this.getLongAttribute("flags");
    }

    @Override
    public boolean parameterExists(String name) {
        return this.parameters.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameterDefault(String name) {
        try {
            this.this_mon.enter();
            Object value = this.parameters.get(name);
            if (value == null) {
                return;
            }
            this.parameters = new LightHashMap(this.parameters);
            this.parameters.remove(name);
        }
        finally {
            this.this_mon.exit();
        }
        this.setMapAttribute("parameters", this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLongParameter(String name) {
        try {
            this.this_mon.enter();
            Object value = this.parameters.get(name);
            if (value == null) {
                value = default_parameters.get(name);
                if (value == null) {
                    Debug.out("Unknown parameter '" + name + "' - must be defined in DownloadManagerState");
                    long l = 0L;
                    return l;
                }
                if (name == "max.uploads.when.seeding.enabled") {
                    if (COConfigurationManager.getBooleanParameter("enable.seedingonly.maxuploads")) {
                        value = Boolean.TRUE;
                    }
                } else if (name == "max.uploads.when.seeding") {
                    int def = COConfigurationManager.getIntParameter("Max Uploads Seeding");
                    value = new Integer(def);
                } else if (name == "max.uploads") {
                    int def = COConfigurationManager.getIntParameter("Max Uploads");
                    value = new Integer(def);
                } else if (name == "max.peers") {
                    int def = COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent");
                    value = new Integer(def);
                } else if (name == "max.peers.when.seeding.enabled") {
                    if (COConfigurationManager.getBooleanParameter("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable")) {
                        value = Boolean.TRUE;
                    }
                } else if (name == "max.peers.when.seeding") {
                    int def = COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent.When.Seeding");
                    value = new Integer(def);
                } else if (name == "max.seeds") {
                    value = new Integer(COConfigurationManager.getIntParameter("Max Seeds Per Torrent"));
                } else if (name == "rand") {
                    long rand = random.nextLong();
                    this.setLongParameter(name, rand);
                    value = new Long(rand);
                }
            }
            if (value instanceof Boolean) {
                long l = (Boolean)value != false ? 1 : 0;
                return l;
            }
            if (value instanceof Integer) {
                long l = ((Integer)value).longValue();
                return l;
            }
            if (value instanceof Long) {
                long l = (Long)value;
                return l;
            }
            Debug.out("Invalid parameter value for '" + name + "' - " + value);
            long l = 0L;
            return l;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLongParameter(String name, long value) {
        Object default_value = default_parameters.get(name);
        if (default_value == null) {
            Debug.out("Unknown parameter '" + name + "' - must be defined in DownloadManagerState");
        }
        try {
            this.this_mon.enter();
            this.parameters = new LightHashMap(this.parameters);
            this.parameters.put(name, new Long(value));
            this.setMapAttribute("parameters", this.parameters);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getIntParameter(String name) {
        return (int)this.getLongParameter(name);
    }

    @Override
    public void setIntParameter(String name, int value) {
        this.setLongParameter(name, value);
    }

    @Override
    public boolean getBooleanParameter(String name) {
        return this.getLongParameter(name) != 0L;
    }

    @Override
    public void setBooleanParameter(String name, boolean value) {
        this.setLongParameter(name, value ? 1L : 0L);
    }

    @Override
    public void setAttribute(String name, String value) {
        if (name.equals("category")) {
            if (value == null) {
                this.setCategory(null);
            } else {
                Category cat = CategoryManager.getCategory(value);
                if (cat == null) {
                    cat = CategoryManager.createCategory(value);
                }
                this.setCategory(cat);
            }
            return;
        }
        if (name.equals("relativepath") && value.length() > 0) {
            File relative_path_file = new File(value);
            value = (relative_path_file = DownloadManagerDefaultPaths.normaliseRelativePath(relative_path_file)) == null ? "" : relative_path_file.getPath();
        }
        this.setStringAttribute(name, value);
    }

    @Override
    public String getAttribute(String name) {
        if (name.equals("category")) {
            Category cat = this.getCategory();
            if (cat == null) {
                return null;
            }
            if (cat == CategoryManager.getCategory(2)) {
                return null;
            }
            return cat.getName();
        }
        return this.getStringAttribute(name);
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category cat) {
        DownloadManager dm;
        if (cat == this.category) {
            return;
        }
        if (cat != null && cat.getType() != 0 && (cat = null) == this.category) {
            return;
        }
        Category oldCategory = this.category == null ? CategoryManager.getCategory(2) : this.category;
        this.category = cat;
        if (oldCategory != null) {
            oldCategory.removeManager(this);
        }
        if ((dm = this.getDownloadManager()) != null && !dm.isDestroyed()) {
            if (this.category != null) {
                this.category.addManager(this);
            } else {
                CategoryManager.getCategory(2).addManager(this);
            }
        }
        if (this.category != null) {
            this.setStringAttribute("category", this.category.getName());
        } else {
            this.setStringAttribute("category", null);
        }
    }

    @Override
    public String getTrackerClientExtensions() {
        return this.getStringAttribute("trackerclientextensions");
    }

    @Override
    public void setTrackerClientExtensions(String value) {
        this.setStringAttribute("trackerclientextensions", value);
    }

    @Override
    public String getDisplayName() {
        return this.getStringAttribute("displayname");
    }

    @Override
    public void setDisplayName(String value) {
        this.setStringAttribute("displayname", value);
    }

    @Override
    public String getUserComment() {
        return this.getStringAttribute("comment");
    }

    @Override
    public void setUserComment(String value) {
        this.setStringAttribute("comment", value);
    }

    @Override
    public String getRelativeSavePath() {
        return this.getStringAttribute("relativepath");
    }

    @Override
    public DiskManagerFileInfo getPrimaryFile() {
        int primaryIndex = -1;
        DiskManagerFileInfo[] fileInfo2 = this.download_manager.getDiskManagerFileInfoSet().getFiles();
        if (this.hasAttribute("primaryfileidx")) {
            primaryIndex = this.getIntAttribute("primaryfileidx");
        }
        if (primaryIndex < 0 || primaryIndex >= fileInfo2.length) {
            primaryIndex = -1;
            if (fileInfo2.length > 0) {
                int idxBiggest = -1;
                long lBiggest = -1L;
                int numChecked = 0;
                for (int i = 0; i < fileInfo2.length && numChecked < 10; ++i) {
                    if (fileInfo2[i].isSkipped()) continue;
                    ++numChecked;
                    if (fileInfo2[i].getLength() <= lBiggest) continue;
                    lBiggest = fileInfo2[i].getLength();
                    idxBiggest = i;
                }
                if (idxBiggest >= 0) {
                    primaryIndex = idxBiggest;
                }
            }
            if (primaryIndex >= 0) {
                this.setPrimaryFile(fileInfo2[primaryIndex]);
            }
        }
        if (primaryIndex >= 0) {
            return fileInfo2[primaryIndex];
        }
        return null;
    }

    @Override
    public void setPrimaryFile(DiskManagerFileInfo dmfi) {
        this.setIntAttribute("primaryfileidx", dmfi.getIndex());
    }

    @Override
    public String[] getNetworks() {
        List values = this.getListAttributeSupport("networks");
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < values.size(); ++i) {
            String nw = (String)values.get(i);
            for (int j = 0; j < AENetworkClassifier.AT_NETWORKS.length; ++j) {
                String nn = AENetworkClassifier.AT_NETWORKS[j];
                if (!nn.equals(nw)) continue;
                res.add(nn);
            }
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    @Override
    public boolean isNetworkEnabled(String network) {
        List values = this.getListAttributeSupport("networks");
        return values.contains(network);
    }

    @Override
    public void setNetworks(String[] networks) {
        if (networks == null) {
            networks = new String[]{};
        }
        ArrayList l = new ArrayList();
        Collections.addAll(l, networks);
        this.setListAttribute("networks", l);
    }

    @Override
    public void setNetworkEnabled(String network, boolean enabled) {
        int i;
        List values = this.getListAttributeSupport("networks");
        boolean alreadyEnabled = values.contains(network);
        ArrayList l = new ArrayList();
        if (enabled && !alreadyEnabled) {
            for (i = 0; i < values.size(); ++i) {
                l.add(values.get(i));
            }
            l.add(network);
            this.setListAttribute("networks", l);
        }
        if (!enabled && alreadyEnabled) {
            for (i = 0; i < values.size(); ++i) {
                l.add(values.get(i));
            }
            l.remove(network);
            this.setListAttribute("networks", l);
        }
    }

    @Override
    public String[] getPeerSources() {
        List values = this.getListAttributeSupport("peersources");
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < values.size(); ++i) {
            String ps = (String)values.get(i);
            for (int j = 0; j < PEPeerSource.PS_SOURCES.length; ++j) {
                String x = PEPeerSource.PS_SOURCES[j];
                if (!x.equals(ps)) continue;
                res.add(x);
            }
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    @Override
    public boolean isPeerSourceEnabled(String peerSource) {
        List values = this.getListAttributeSupport("peersources");
        return values.contains(peerSource);
    }

    @Override
    public boolean isPeerSourcePermitted(String peerSource) {
        if (peerSource.equals("DHT") && (TorrentUtils.getPrivate(this.torrent) || !TorrentUtils.getDHTBackupEnabled(this.torrent))) {
            return false;
        }
        if (peerSource.equals("PeerExchange") && TorrentUtils.getPrivate(this.torrent)) {
            return false;
        }
        List values = this.getListAttributeSupport("peersourcesdenied");
        return values == null || !values.contains(peerSource);
    }

    @Override
    public void setPeerSourcePermitted(String peerSource, boolean enabled) {
        ArrayList<String> values;
        if (!this.getFlag(32L)) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Attempt to modify permitted peer sources denied as disabled '" + TorrentUtils.getLocalisedName(this.torrent) + "'"));
            return;
        }
        if (!enabled) {
            this.setPeerSourceEnabled(peerSource, false);
        }
        if ((values = this.getListAttributeSupport("peersourcesdenied")) == null) {
            if (!enabled) {
                values = new ArrayList<String>();
                values.add(peerSource);
                this.setListAttribute("peersourcesdenied", values);
            }
        } else {
            if (enabled) {
                values.remove(peerSource);
            } else if (!values.contains(peerSource)) {
                values.add(peerSource);
            }
            this.setListAttribute("peersourcesdenied", values);
        }
    }

    @Override
    public void setPeerSources(String[] ps) {
        if (ps == null) {
            ps = new String[]{};
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < ps.length; ++i) {
            String p = ps[i];
            if (!this.isPeerSourcePermitted(p)) continue;
            l.add(ps[i]);
        }
        this.setListAttribute("peersources", l);
    }

    @Override
    public void setPeerSourceEnabled(String source, boolean enabled) {
        int i;
        if (enabled && !this.isPeerSourcePermitted(source)) {
            return;
        }
        List values = this.getListAttributeSupport("peersources");
        boolean alreadyEnabled = values.contains(source);
        ArrayList l = new ArrayList();
        if (enabled && !alreadyEnabled) {
            for (i = 0; i < values.size(); ++i) {
                l.add(values.get(i));
            }
            l.add(source);
            this.setListAttribute("peersources", l);
        }
        if (!enabled && alreadyEnabled) {
            for (i = 0; i < values.size(); ++i) {
                l.add(values.get(i));
            }
            l.remove(source);
            this.setListAttribute("peersources", l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFileLink(int source_index, File link_source, File link_destination) {
        LinkFileMap links = this.getFileLinks();
        File existing = links.get(source_index, link_source);
        if (link_destination == null ? existing == null : existing != null && existing.equals(link_destination)) {
            return;
        }
        links.put(source_index, link_source, link_destination);
        ArrayList<String> list = new ArrayList<String>();
        Iterator<LinkFileMap.Entry> it = links.entryIterator();
        while (it.hasNext()) {
            LinkFileMap.Entry entry = it.next();
            int index = entry.getIndex();
            File source = entry.getFromFile();
            File target = entry.getToFile();
            String str = index + "\n" + source + "\n" + (target == null ? "" : target.toString());
            list.add(str);
        }
        DownloadManagerStateImpl downloadManagerStateImpl = this;
        synchronized (downloadManagerStateImpl) {
            this.file_link_cache = new WeakReference<LinkFileMap>(links);
        }
        this.setListAttribute("filelinks2", list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFileLinks(List<Integer> source_indexes, List<File> link_sources, List<File> link_destinations) {
        LinkFileMap links = this.getFileLinks();
        boolean changed = false;
        for (int i = 0; i < link_sources.size(); ++i) {
            int source_index = source_indexes.get(i);
            File link_source = link_sources.get(i);
            File link_destination = link_destinations.get(i);
            File existing = links.get(source_index, link_source);
            if (link_destination == null ? existing == null : existing != null && existing.equals(link_destination)) continue;
            links.put(source_index, link_source, link_destination);
            changed = true;
        }
        if (!changed) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator<LinkFileMap.Entry> it = links.entryIterator();
        while (it.hasNext()) {
            LinkFileMap.Entry entry = it.next();
            int index = entry.getIndex();
            File source = entry.getFromFile();
            File target = entry.getToFile();
            String str = index + "\n" + source + "\n" + (target == null ? "" : target.toString());
            list.add(str);
        }
        DownloadManagerStateImpl downloadManagerStateImpl = this;
        synchronized (downloadManagerStateImpl) {
            this.file_link_cache = new WeakReference<LinkFileMap>(links);
        }
        this.setListAttribute("filelinks2", list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFileLinks() {
        LinkFileMap links = this.getFileLinks();
        ArrayList<String> list = new ArrayList<String>();
        Iterator<LinkFileMap.Entry> it = links.entryIterator();
        boolean changed = false;
        while (it.hasNext()) {
            LinkFileMap.Entry entry = it.next();
            int index = entry.getIndex();
            File source = entry.getFromFile();
            File target = entry.getToFile();
            if (target != null) {
                changed = true;
            }
            String str = index + "\n" + source + "\n";
            list.add(str);
        }
        if (changed) {
            DownloadManagerStateImpl downloadManagerStateImpl = this;
            synchronized (downloadManagerStateImpl) {
                this.file_link_cache = null;
            }
            this.setListAttribute("filelinks2", list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFileLink(int source_index, File link_source) {
        LinkFileMap map = null;
        WeakReference<LinkFileMap> ref = this.file_link_cache;
        if (ref != null) {
            map = (LinkFileMap)ref.get();
        }
        if (map == null) {
            map = this.getFileLinks();
            DownloadManagerStateImpl downloadManagerStateImpl = this;
            synchronized (downloadManagerStateImpl) {
                this.file_link_cache = new WeakReference<LinkFileMap>(map);
            }
        }
        File res = map.get(source_index, link_source);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkFileMap getFileLinks() {
        LinkFileMap map = null;
        WeakReference<LinkFileMap> ref = this.file_link_cache;
        if (ref != null) {
            map = (LinkFileMap)ref.get();
        }
        if (map == null) {
            map = this.getFileLinksSupport();
            DownloadManagerStateImpl downloadManagerStateImpl = this;
            synchronized (downloadManagerStateImpl) {
                this.file_link_cache = new WeakReference<LinkFileMap>(map);
            }
        }
        return map;
    }

    private LinkFileMap getFileLinksSupport() {
        LinkFileMap res = new LinkFileMap();
        List new_values = this.getListAttributeSupport("filelinks2");
        if (new_values.size() > 0) {
            for (int i = 0; i < new_values.size(); ++i) {
                String entry = (String)new_values.get(i);
                String[] bits = entry.split("\n");
                if (bits.length < 2) continue;
                try {
                    File target;
                    int index = Integer.parseInt(bits[0].trim());
                    File source = new File(bits[1].trim());
                    File file = target = bits.length < 3 ? null : new File(bits[2].trim());
                    if (index >= 0) {
                        res.put(index, source, target);
                        continue;
                    }
                    res.putMigration(source, target);
                    continue;
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        } else {
            List old_values = this.getListAttributeSupport("filelinks");
            for (int i = 0; i < old_values.size(); ++i) {
                String entry = (String)old_values.get(i);
                int sep = entry.indexOf("\n");
                if (sep == -1) continue;
                File target = sep == entry.length() - 1 ? null : new File(entry.substring(sep + 1));
                res.putMigration(new File(entry.substring(0, sep)), target);
            }
        }
        return res;
    }

    @Override
    public boolean isOurContent() {
        Map mapAttr = this.getMapAttribute("Plugin.azdirector.ContentMap");
        return mapAttr != null && mapAttr.containsKey("DIRECTOR PUBLISH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringAttribute(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            this.this_mon.enter();
            if (!(this.attributes.get(attribute_name) instanceof byte[])) {
                String string = null;
                return string;
            }
            byte[] bytes = (byte[])this.attributes.get(attribute_name);
            if (bytes == null) {
                String string = null;
                return string;
            }
            String string = new String(bytes, "UTF8");
            return string;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStringAttribute(String attribute_name, String attribute_value) {
        boolean changed;
        block9: {
            changed = false;
            try {
                this.this_mon.enter();
                if (attribute_value == null) {
                    if (this.attributes.containsKey(attribute_name)) {
                        this.attributes.remove(attribute_name);
                        changed = true;
                        this.write_required = true;
                    }
                    break block9;
                }
                try {
                    byte[] existing_bytes = (byte[])this.attributes.get(attribute_name);
                    byte[] new_bytes = attribute_value.getBytes("UTF8");
                    if (existing_bytes == null || !Arrays.equals(existing_bytes, new_bytes)) {
                        this.attributes.put(attribute_name, new_bytes);
                        changed = true;
                        this.write_required = true;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    Debug.printStackTrace(e);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        if (changed) {
            this.informWritten(attribute_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLongAttribute(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            this.this_mon.enter();
            Long l = (Long)this.attributes.get(attribute_name);
            if (l == null) {
                Object def = default_attributes.get(attribute_name);
                if (def != null) {
                    if (def instanceof Long) {
                        long l2 = (Long)def;
                        return l2;
                    }
                    if (def instanceof Integer) {
                        long l3 = ((Integer)def).longValue();
                        return l3;
                    }
                    Debug.out("unknown default type " + def);
                } else if (attribute_name == "file.expand") {
                    boolean featured = TorrentUtils.isFeaturedContent(this.torrent);
                    long res = featured ? 1L : 0L;
                    this.attributes.put(attribute_name, new Long(res));
                    this.write_required = true;
                    long l4 = res;
                    return l4;
                }
                long l5 = 0L;
                return l5;
            }
            long l6 = l;
            return l6;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLongAttribute(String attribute_name, long attribute_value) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            Long existing_value = (Long)this.attributes.get(attribute_name);
            if (existing_value == null || existing_value != attribute_value) {
                this.attributes.put(attribute_name, new Long(attribute_value));
                changed = true;
                this.write_required = true;
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed) {
            this.informWritten(attribute_name);
        }
    }

    @Override
    public void setListAttribute(String name, String[] values) {
        List<Object> list = values == null ? null : Arrays.asList((Object[])values.clone());
        this.setListAttribute(name, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getListAttribute(String name, int idx) {
        if (name.equals("networks") || name.equals("peersources")) {
            throw new UnsupportedOperationException("not supported right now, implement it yourself :P");
        }
        this.informWillRead(name);
        try {
            this.this_mon.enter();
            List values = (List)this.attributes.get(name);
            if (values == null || idx >= values.size() || idx < 0) {
                String string = null;
                return string;
            }
            Object o = values.get(idx);
            if (o instanceof byte[]) {
                byte[] bytes = (byte[])o;
                String s = null;
                try {
                    s = StringInterner.intern(new String(bytes, "UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    Debug.printStackTrace(e);
                }
                if (s != null) {
                    values.set(idx, s);
                }
                String string = s;
                return string;
            }
            if (o instanceof String) {
                String string = (String)o;
                return string;
            }
        }
        finally {
            this.this_mon.exit();
        }
        return null;
    }

    @Override
    public String[] getListAttribute(String attribute_name) {
        if (attribute_name == "networks") {
            return this.getNetworks();
        }
        if (attribute_name == "peersources") {
            return this.getPeerSources();
        }
        List l = this.getListAttributeSupport(attribute_name);
        if (l == null) {
            return null;
        }
        String[] res = new String[l.size()];
        try {
            res = l.toArray(res);
        }
        catch (ArrayStoreException e) {
            Debug.out("getListAttribute( " + attribute_name + ") - object isnt String - " + e);
            return null;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getListAttributeSupport(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            this.this_mon.enter();
            List values = (List)this.attributes.get(attribute_name);
            ArrayList<String> res = new ArrayList<String>(values != null ? values.size() : 0);
            if (values != null) {
                for (int i = 0; i < values.size(); ++i) {
                    Object o = values.get(i);
                    if (o instanceof byte[]) {
                        byte[] bytes = (byte[])o;
                        String s = null;
                        try {
                            s = StringInterner.intern(new String(bytes, "UTF8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            Debug.printStackTrace(e);
                        }
                        if (s == null) continue;
                        res.add(s);
                        values.set(i, s);
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    res.add((String)o);
                }
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setListAttribute(String attribute_name, List attribute_value) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            if (attribute_value == null) {
                if (this.attributes.containsKey(attribute_name)) {
                    this.attributes.remove(attribute_name);
                    changed = true;
                    this.write_required = true;
                }
            } else {
                List old_value = this.getListAttributeSupport(attribute_name);
                if (old_value == null || old_value.size() != attribute_value.size()) {
                    this.attributes.put(attribute_name, attribute_value);
                    changed = true;
                    this.write_required = true;
                } else {
                    if (old_value == attribute_value) {
                        Debug.out("setListAttribute: should clone?");
                    }
                    boolean bl = changed = !BEncoder.listsAreIdentical(old_value, attribute_value);
                    if (changed) {
                        this.write_required = true;
                        this.attributes.put(attribute_name, attribute_value);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed) {
            this.informWritten(attribute_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getMapAttribute(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            Map value;
            this.this_mon.enter();
            Map map = value = (Map)this.attributes.get(attribute_name);
            return map;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setMapAttribute(String attribute_name, Map attribute_value) {
        this.setMapAttribute(attribute_name, attribute_value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMapAttribute(String attribute_name, Map attribute_value, boolean disable_change_notification) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            if (attribute_value == null) {
                if (this.attributes.containsKey(attribute_name)) {
                    this.attributes.remove(attribute_name);
                    changed = true;
                    this.write_required = true;
                }
            } else {
                Map old_value = this.getMapAttribute(attribute_name);
                if (old_value == null || old_value.size() != attribute_value.size()) {
                    this.attributes.put(attribute_name, attribute_value);
                    changed = true;
                    this.write_required = true;
                } else {
                    if (old_value == attribute_value) {
                        Debug.out("setMapAttribute: should clone?");
                    }
                    boolean bl = changed = !BEncoder.mapsAreIdentical(old_value, attribute_value);
                    if (changed) {
                        this.write_required = true;
                        this.attributes.put(attribute_name, attribute_value);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed && !disable_change_notification) {
            this.informWritten(attribute_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute(String name) {
        try {
            this.this_mon.enter();
            if (this.attributes == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.attributes.containsKey(name);
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setIntAttribute(String name, int value) {
        this.setLongAttribute(name, value);
    }

    @Override
    public int getIntAttribute(String name) {
        return (int)this.getLongAttribute(name);
    }

    @Override
    public void setBooleanAttribute(String name, boolean value) {
        this.setLongAttribute(name, value ? 1 : 0);
    }

    @Override
    public boolean getBooleanAttribute(String name) {
        return this.getLongAttribute(name) != 0L;
    }

    public static DownloadManagerState getDownloadState(DownloadManager dm) {
        return new nullState(dm);
    }

    protected void informWritten(final String attribute_name) {
        for (DownloadManagerStateListener l : this.listeners_cow.getList()) {
            try {
                l.stateChanged(this, new DownloadManagerStateEvent(){

                    @Override
                    public int getType() {
                        return 1;
                    }

                    @Override
                    public Object getData() {
                        return attribute_name;
                    }
                });
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        CopyOnWriteList<DownloadManagerStateAttributeListener> write_listeners = global_listeners_write_map_cow.get(attribute_name);
        if (write_listeners != null) {
            for (DownloadManagerStateAttributeListener l : write_listeners.getList()) {
                try {
                    l.attributeEventOccurred(this.download_manager, attribute_name, 1);
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                }
            }
        }
        if ((write_listeners = this.listeners_write_map_cow.get(attribute_name)) != null) {
            for (DownloadManagerStateAttributeListener l : write_listeners.getList()) {
                try {
                    l.attributeEventOccurred(this.download_manager, attribute_name, 1);
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informWillRead(final String attribute_name) {
        List will_be_read_list = (List)tls_wbr.get();
        if (!will_be_read_list.contains(attribute_name)) {
            will_be_read_list.add(attribute_name);
            try {
                for (DownloadManagerStateListener l : this.listeners_cow.getList()) {
                    try {
                        l.stateChanged(this, new DownloadManagerStateEvent(){

                            @Override
                            public int getType() {
                                return 2;
                            }

                            @Override
                            public Object getData() {
                                return attribute_name;
                            }
                        });
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                CopyOnWriteList<DownloadManagerStateAttributeListener> read_listeners = global_listeners_read_map_cow.get(attribute_name);
                if (read_listeners != null) {
                    for (DownloadManagerStateAttributeListener l : read_listeners.getList()) {
                        try {
                            l.attributeEventOccurred(this.download_manager, attribute_name, 2);
                        }
                        catch (Throwable t) {
                            Debug.printStackTrace(t);
                        }
                    }
                }
                if ((read_listeners = this.listeners_read_map_cow.get(attribute_name)) != null) {
                    for (DownloadManagerStateAttributeListener l : read_listeners.getList()) {
                        try {
                            l.attributeEventOccurred(this.download_manager, attribute_name, 2);
                        }
                        catch (Throwable t) {
                            Debug.printStackTrace(t);
                        }
                    }
                }
            }
            finally {
                will_be_read_list.remove(attribute_name);
            }
        }
    }

    @Override
    public void addListener(DownloadManagerStateListener l) {
        this.listeners_cow.add(l);
    }

    @Override
    public void removeListener(DownloadManagerStateListener l) {
        this.listeners_cow.remove(l);
    }

    @Override
    public void addListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> map_to_use = event_type == 2 ? this.listeners_read_map_cow : this.listeners_write_map_cow;
        CopyOnWriteList<DownloadManagerStateAttributeListener> lst = map_to_use.get(attribute);
        if (lst == null) {
            lst = new CopyOnWriteList();
            map_to_use.put(attribute, lst);
        }
        lst.add(l);
    }

    @Override
    public void removeListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> map_to_use = event_type == 2 ? this.listeners_read_map_cow : this.listeners_write_map_cow;
        CopyOnWriteList<DownloadManagerStateAttributeListener> lst = map_to_use.get(attribute);
        if (lst != null) {
            lst.remove(l);
        }
    }

    public static void addGlobalListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> map_to_use = event_type == 2 ? global_listeners_read_map_cow : global_listeners_write_map_cow;
        CopyOnWriteList<DownloadManagerStateAttributeListener> lst = map_to_use.get(attribute);
        if (lst == null) {
            lst = new CopyOnWriteList();
            map_to_use.put(attribute, lst);
        }
        lst.add(l);
    }

    public static void removeGlobalListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        CopyOnWriteMap<String, CopyOnWriteList<DownloadManagerStateAttributeListener>> map_to_use = event_type == 2 ? global_listeners_read_map_cow : global_listeners_write_map_cow;
        CopyOnWriteList<DownloadManagerStateAttributeListener> lst = map_to_use.get(attribute);
        if (lst != null) {
            lst.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("DownloadManagerState");
        try {
            writer.indent();
            writer.println("parameters=" + this.parameters);
            writer.println("flags=" + this.getFlags());
            DiskManagerFileInfo primaryFile = this.getPrimaryFile();
            if (primaryFile != null) {
                writer.println("primary file=" + Debug.secretFileName(primaryFile.getFile(true).getAbsolutePath()));
            }
        }
        finally {
            writer.exdent();
        }
    }

    @Override
    public void dump(IndentWriter writer) {
        writer.println("attributes: " + this.parameters);
    }

    static {
        int i;
        LOGID = LogIDs.DISK;
        SUPPRESS_FIXUP_ERRORS = false;
        ACTIVE_DIR = FileUtil.getUserFile("active");
        if (!ACTIVE_DIR.exists()) {
            FileUtil.mkdirs(ACTIVE_DIR);
        }
        random = RandomUtils.SECURE_RANDOM;
        default_parameters = new HashMap();
        for (i = 0; i < PARAMETERS.length; ++i) {
            default_parameters.put(PARAMETERS[i][0], PARAMETERS[i][1]);
        }
        default_attributes = new HashMap();
        for (i = 0; i < ATTRIBUTE_DEFAULTS.length; ++i) {
            default_attributes.put(ATTRIBUTE_DEFAULTS[i][0], ATTRIBUTE_DEFAULTS[i][1]);
        }
        TorrentUtils.registerMapFluff(new String[]{TRACKER_CACHE_KEY, RESUME_KEY});
        class_mon = new AEMonitor("DownloadManagerState:class");
        state_map = new HashMap<HashWrapper, DownloadManagerStateImpl>();
        ParameterListener listener = new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String parameterName) {
                ArrayList<DownloadManagerStateImpl> states;
                Map<HashWrapper, DownloadManagerStateImpl> map = state_map;
                synchronized (map) {
                    states = new ArrayList<DownloadManagerStateImpl>(state_map.values());
                }
                for (DownloadManagerStateImpl state : states) {
                    try {
                        state.parameterChanged(parameterName);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        COConfigurationManager.addParameterListener("Max.Peer.Connections.Per.Torrent.When.Seeding", listener);
        COConfigurationManager.addParameterListener("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable", listener);
        COConfigurationManager.addParameterListener("Max.Peer.Connections.Per.Torrent", listener);
        COConfigurationManager.addParameterListener("Max Uploads", listener);
        COConfigurationManager.addParameterListener("Max Uploads Seeding", listener);
        COConfigurationManager.addParameterListener("Max Seeds Per Torrent", listener);
        COConfigurationManager.addParameterListener("enable.seedingonly.maxuploads", listener);
        global_state_cache = new HashMap();
        global_state_cache_wrappers = new ArrayList();
        global_listeners_read_map_cow = new CopyOnWriteMap();
        global_listeners_write_map_cow = new CopyOnWriteMap();
        tls_wbr = new ThreadLocal(){

            public Object initialValue() {
                return new ArrayList(1);
            }
        };
    }

    protected static class CachedStateWrapper
    extends LogRelation
    implements TorrentUtils.ExtendedTorrent {
        private final DownloadManagerImpl download_manager;
        private final String torrent_file;
        private HashWrapper torrent_hash_wrapper;
        private Map cache;
        private Map cache_attributes;
        private Map cache_azp;
        private volatile TorrentUtils.ExtendedTorrent delegate;
        private TOTorrentException fixup_failure;
        private boolean discard_pieces;
        private boolean logged_failure;
        private Boolean simple_torrent;
        private long size;
        private int file_count;
        private URL announce_url;
        private cacheGroup announce_group;
        private volatile boolean discard_fluff;

        protected CachedStateWrapper(DownloadManagerImpl _download_manager, String _torrent_file, byte[] _torrent_hash, Map _cache, boolean _force_piece_discard) {
            List ag;
            byte[] au;
            Long l_size;
            Long fc;
            this.download_manager = _download_manager;
            this.torrent_file = _torrent_file;
            this.torrent_hash_wrapper = new HashWrapper(_torrent_hash);
            this.cache = _cache;
            this.cache_attributes = (Map)this.cache.get(DownloadManagerStateImpl.ATTRIBUTE_KEY);
            this.cache_azp = (Map)this.cache.get("azp");
            if (_force_piece_discard) {
                this.discard_pieces = true;
            } else {
                Long l_fp = (Long)this.cache.get("dp");
                if (l_fp != null) {
                    this.discard_pieces = l_fp == 1L;
                }
            }
            Long st = (Long)this.cache.get("simple");
            if (st != null) {
                this.simple_torrent = st == 1L;
            }
            if ((fc = (Long)this.cache.get("fc")) != null) {
                this.file_count = fc.intValue();
            }
            if ((l_size = (Long)this.cache.get("size")) != null) {
                this.size = l_size;
            }
            if ((au = (byte[])this.cache.get("au")) != null) {
                try {
                    this.announce_url = StringInterner.internURL(new URL(new String(au, "UTF-8")));
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if ((ag = (List)this.cache.get("ag")) != null) {
                try {
                    this.announce_group = this.importGroup(ag);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }

        protected static Map export(DownloadManagerState dms) throws TOTorrentException {
            HashMap<String, Object> cache = new HashMap<String, Object>();
            TOTorrent state = dms.getTorrent();
            cache.put("hash", state.getHash());
            cache.put("name", state.getName());
            cache.put("utf8name", state.getUTF8Name() == null ? "" : state.getUTF8Name());
            cache.put("comment", state.getComment());
            cache.put("createdby", state.getCreatedBy());
            cache.put("size", new Long(state.getSize()));
            cache.put("encoding", state.getAdditionalStringProperty("encoding"));
            cache.put("torrent filename", state.getAdditionalStringProperty("torrent filename"));
            cache.put(DownloadManagerStateImpl.ATTRIBUTE_KEY, state.getAdditionalMapProperty(DownloadManagerStateImpl.ATTRIBUTE_KEY));
            cache.put("azp", state.getAdditionalMapProperty(DownloadManagerStateImpl.AZUREUS_PROPERTIES_KEY));
            try {
                cache.put("au", state.getAnnounceURL().toExternalForm());
                cache.put("ag", CachedStateWrapper.exportGroup(state.getAnnounceURLGroup()));
            }
            catch (Throwable e) {
                // empty catch block
            }
            boolean discard_pieces = dms.isResumeDataComplete();
            TOTorrent t = dms.getTorrent();
            if (t instanceof CachedStateWrapper) {
                Boolean simple_torrent;
                CachedStateWrapper csw = (CachedStateWrapper)t;
                if (!discard_pieces) {
                    boolean bl = discard_pieces = csw.peekPieces() == null;
                }
                if ((simple_torrent = csw.simple_torrent) != null) {
                    cache.put("simple", new Long(simple_torrent != false ? 1L : 0L));
                } else {
                    Debug.out("Failed to cache simple state");
                }
                int fc = csw.file_count;
                if (fc > 0) {
                    cache.put("fc", new Long(fc));
                }
            } else if (t instanceof TorrentUtils.torrentDelegate) {
                cache.put("simple", new Long(t.isSimpleTorrent() ? 1L : 0L));
                cache.put("fc", t.getFileCount());
            } else {
                Debug.out("Hmm, torrent isn't cache-state-wrapper, it is " + t);
            }
            cache.put("dp", new Long(discard_pieces ? 1L : 0L));
            return cache;
        }

        protected static List exportGroup(TOTorrentAnnounceURLGroup group) {
            TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
            ArrayList result = new ArrayList();
            for (int i = 0; i < sets.length; ++i) {
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                if (urls.length <= 0) continue;
                ArrayList<String> s = new ArrayList<String>(urls.length);
                for (int j = 0; j < urls.length; ++j) {
                    s.add(urls[j].toExternalForm());
                }
                result.add(s);
            }
            return result;
        }

        protected cacheGroup importGroup(List l) throws Exception {
            return new cacheGroup(l);
        }

        protected void clearCache() {
            this.cache = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean fixup() {
            try {
                if (this.delegate == null) {
                    CachedStateWrapper cachedStateWrapper = this;
                    synchronized (cachedStateWrapper) {
                        if (this.delegate == null) {
                            if (this.fixup_failure != null) {
                                throw this.fixup_failure;
                            }
                            this.delegate = this.loadRealState();
                            if (this.discard_fluff) {
                                this.delegate.setDiscardFluff(this.discard_fluff);
                            }
                            if (this.cache != null) {
                                Debug.out("Cache miss forced fixup");
                            }
                            this.cache = null;
                            if (this.cache_attributes != null) {
                                this.delegate.setAdditionalMapProperty(DownloadManagerStateImpl.ATTRIBUTE_KEY, this.cache_attributes);
                                this.cache_attributes = null;
                            }
                            if (this.cache_azp != null) {
                                this.delegate.setAdditionalMapProperty(DownloadManagerStateImpl.AZUREUS_PROPERTIES_KEY, this.cache_azp);
                                this.cache_azp = null;
                            }
                            this.announce_url = null;
                            if (this.announce_group != null) {
                                this.announce_group.fixGroup();
                                this.announce_group = null;
                            }
                        }
                    }
                }
                return true;
            }
            catch (TOTorrentException e) {
                this.fixup_failure = e;
                if (this.download_manager != null) {
                    this.download_manager.setTorrentInvalid(Debug.getNestedExceptionMessage(e));
                } else if (!this.logged_failure) {
                    this.logged_failure = true;
                    Debug.out("Torrent can't be loaded: " + Debug.getNestedExceptionMessage(e));
                }
                return false;
            }
        }

        protected TorrentUtils.ExtendedTorrent loadRealState() throws TOTorrentException {
            File saved_file;
            if (!SUPPRESS_FIXUP_ERRORS && Constants.isCVSVersion() && !Thread.currentThread().isDaemon()) {
                Debug.outNoStack(Debug.getCompressedStackTrace(new Exception(){

                    @Override
                    public String toString() {
                        return "Premature fixup?";
                    }
                }, 2, 10, true), true);
            }
            if ((saved_file = DownloadManagerStateImpl.getStateFile(this.torrent_hash_wrapper.getBytes())).exists()) {
                try {
                    return TorrentUtils.readDelegateFromFile(saved_file, this.discard_pieces);
                }
                catch (Throwable e) {
                    Debug.out("Failed to load download state for " + saved_file);
                }
            }
            TOTorrent original_torrent = TorrentUtils.readFromFile(new File(this.torrent_file), true);
            this.torrent_hash_wrapper = original_torrent.getHashWrapper();
            saved_file = DownloadManagerStateImpl.getStateFile(this.torrent_hash_wrapper.getBytes());
            if (saved_file.exists()) {
                try {
                    return TorrentUtils.readDelegateFromFile(saved_file, this.discard_pieces);
                }
                catch (Throwable e) {
                    Debug.out("Failed to load download state for " + saved_file);
                }
            }
            TorrentUtils.copyToFile(original_torrent, saved_file);
            return TorrentUtils.readDelegateFromFile(saved_file, this.discard_pieces);
        }

        @Override
        public byte[] getName() {
            byte[] name;
            Map c = this.cache;
            if (c != null && (name = (byte[])c.get("name")) != null) {
                return name;
            }
            if (this.fixup()) {
                return this.delegate.getName();
            }
            return ("Error - " + Debug.getNestedExceptionMessage(this.fixup_failure)).getBytes();
        }

        @Override
        public String getUTF8Name() {
            byte[] name;
            Map c = this.cache;
            if (c != null && (name = (byte[])c.get("utf8name")) != null) {
                String utf8name;
                try {
                    utf8name = new String(name, "utf8");
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
                if (utf8name.length() == 0) {
                    return null;
                }
                return utf8name;
            }
            if (this.fixup()) {
                return this.delegate.getUTF8Name();
            }
            return null;
        }

        @Override
        public boolean isSimpleTorrent() {
            if (this.simple_torrent != null) {
                return this.simple_torrent;
            }
            if (this.fixup()) {
                boolean st = this.delegate.isSimpleTorrent();
                this.simple_torrent = st;
                return st;
            }
            return false;
        }

        @Override
        public byte[] getComment() {
            Map c = this.cache;
            if (c != null) {
                return (byte[])c.get("comment");
            }
            if (this.fixup()) {
                return this.delegate.getComment();
            }
            return null;
        }

        @Override
        public void setComment(String comment) {
            if (this.fixup()) {
                this.delegate.setComment(comment);
            }
        }

        @Override
        public long getCreationDate() {
            if (this.fixup()) {
                return this.delegate.getCreationDate();
            }
            return 0L;
        }

        @Override
        public void setCreationDate(long date) {
            if (this.fixup()) {
                this.delegate.setCreationDate(date);
            }
        }

        @Override
        public byte[] getCreatedBy() {
            Map c = this.cache;
            if (c != null) {
                return (byte[])c.get("createdby");
            }
            if (this.fixup()) {
                return this.delegate.getCreatedBy();
            }
            return null;
        }

        @Override
        public void setCreatedBy(byte[] cb) {
            if (this.fixup()) {
                this.delegate.setCreatedBy(cb);
            }
        }

        @Override
        public boolean isCreated() {
            if (this.fixup()) {
                return this.delegate.isCreated();
            }
            return false;
        }

        @Override
        public boolean isDecentralised() {
            return TorrentUtils.isDecentralised(this.getAnnounceURL());
        }

        @Override
        public URL getAnnounceURL() {
            if (this.announce_url != null) {
                return this.announce_url;
            }
            if (this.fixup()) {
                return this.delegate.getAnnounceURL();
            }
            return null;
        }

        @Override
        public boolean setAnnounceURL(URL url) {
            if (this.announce_url != null && this.announce_url.toExternalForm().equals(url.toExternalForm())) {
                return false;
            }
            if (this.fixup()) {
                return this.delegate.setAnnounceURL(url);
            }
            this.announce_url = url;
            return false;
        }

        @Override
        public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
            if (this.announce_group != null) {
                return this.announce_group;
            }
            if (this.fixup()) {
                return this.delegate.getAnnounceURLGroup();
            }
            return null;
        }

        @Override
        public byte[][] getPieces() throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.getPieces();
            }
            throw this.fixup_failure;
        }

        @Override
        public void setPieces(byte[][] pieces) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.setPieces(pieces);
                return;
            }
            throw this.fixup_failure;
        }

        @Override
        public byte[][] peekPieces() throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.peekPieces();
            }
            throw this.fixup_failure;
        }

        @Override
        public void setDiscardFluff(boolean discard) {
            this.discard_fluff = discard;
            if (this.delegate != null) {
                this.delegate.setDiscardFluff(this.discard_fluff);
            }
        }

        @Override
        public long getPieceLength() {
            if (this.fixup()) {
                return this.delegate.getPieceLength();
            }
            return 0L;
        }

        @Override
        public int getNumberOfPieces() {
            if (this.fixup()) {
                return this.delegate.getNumberOfPieces();
            }
            return 0;
        }

        @Override
        public long getSize() {
            if (this.size > 0L) {
                return this.size;
            }
            if (this.fixup()) {
                this.size = this.delegate.getSize();
                return this.size;
            }
            return 0L;
        }

        @Override
        public int getFileCount() {
            if (this.file_count == 0 && this.fixup()) {
                this.file_count = this.delegate.getFileCount();
            }
            return this.file_count;
        }

        @Override
        public TOTorrentFile[] getFiles() {
            if (this.fixup()) {
                return this.delegate.getFiles();
            }
            return new TOTorrentFile[0];
        }

        @Override
        public byte[] getHash() throws TOTorrentException {
            return this.torrent_hash_wrapper.getBytes();
        }

        @Override
        public HashWrapper getHashWrapper() throws TOTorrentException {
            return this.torrent_hash_wrapper;
        }

        @Override
        public void setHashOverride(byte[] hash) throws TOTorrentException {
            throw new TOTorrentException("Not supported", 8);
        }

        @Override
        public boolean hasSameHashAs(TOTorrent other) {
            try {
                byte[] other_hash = other.getHash();
                return Arrays.equals(this.getHash(), other_hash);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
                return false;
            }
        }

        @Override
        public boolean getPrivate() {
            if (this.fixup()) {
                return this.delegate.getPrivate();
            }
            return false;
        }

        @Override
        public void setPrivate(boolean _private) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.setPrivate(_private);
            }
        }

        @Override
        public void setAdditionalStringProperty(String name, String value) {
            if (this.fixup()) {
                this.delegate.setAdditionalStringProperty(name, value);
            }
        }

        @Override
        public String getAdditionalStringProperty(String name) {
            Map c = this.cache;
            if (c != null && (name.equals("encoding") || name.equals("torrent filename"))) {
                byte[] res = (byte[])c.get(name);
                if (res == null) {
                    return null;
                }
                try {
                    return new String(res, "UTF8");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }
            if (this.fixup()) {
                return this.delegate.getAdditionalStringProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalByteArrayProperty(String name, byte[] value) {
            if (this.fixup()) {
                this.delegate.setAdditionalByteArrayProperty(name, value);
            }
        }

        @Override
        public byte[] getAdditionalByteArrayProperty(String name) {
            if (this.fixup()) {
                return this.delegate.getAdditionalByteArrayProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalLongProperty(String name, Long value) {
            if (this.fixup()) {
                this.delegate.setAdditionalLongProperty(name, value);
            }
        }

        @Override
        public Long getAdditionalLongProperty(String name) {
            if (this.fixup()) {
                return this.delegate.getAdditionalLongProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalListProperty(String name, List value) {
            if (this.fixup()) {
                this.delegate.setAdditionalListProperty(name, value);
            }
        }

        @Override
        public List getAdditionalListProperty(String name) {
            if (this.fixup()) {
                return this.delegate.getAdditionalListProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalMapProperty(String name, Map value) {
            if (this.fixup()) {
                this.delegate.setAdditionalMapProperty(name, value);
            }
        }

        @Override
        public Map getAdditionalMapProperty(String name) {
            Map c = this.cache_attributes;
            if (c != null && name.equals(DownloadManagerStateImpl.ATTRIBUTE_KEY)) {
                return c;
            }
            c = this.cache_azp;
            if (c != null && name.equals(DownloadManagerStateImpl.AZUREUS_PROPERTIES_KEY)) {
                return c;
            }
            if (this.fixup()) {
                return this.delegate.getAdditionalMapProperty(name);
            }
            return null;
        }

        @Override
        public Object getAdditionalProperty(String name) {
            if (this.fixup()) {
                return this.delegate.getAdditionalProperty(name);
            }
            return null;
        }

        @Override
        public void setAdditionalProperty(String name, Object value) {
            if (this.fixup()) {
                this.delegate.setAdditionalProperty(name, value);
            }
        }

        @Override
        public void removeAdditionalProperty(String name) {
            if (this.fixup()) {
                this.delegate.removeAdditionalProperty(name);
            }
        }

        @Override
        public void removeAdditionalProperties() {
            if (this.fixup()) {
                this.delegate.removeAdditionalProperties();
            }
        }

        @Override
        public void serialiseToBEncodedFile(File file) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.serialiseToBEncodedFile(file);
                return;
            }
            throw this.fixup_failure;
        }

        @Override
        public Map serialiseToMap() throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.serialiseToMap();
            }
            throw this.fixup_failure;
        }

        @Override
        public void serialiseToXMLFile(File file) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.serialiseToXMLFile(file);
                return;
            }
            throw this.fixup_failure;
        }

        @Override
        public void addListener(TOTorrentListener l) {
            if (this.fixup()) {
                this.delegate.addListener(l);
            }
        }

        @Override
        public void removeListener(TOTorrentListener l) {
            if (this.fixup()) {
                this.delegate.removeListener(l);
            }
        }

        @Override
        public AEMonitor getMonitor() {
            if (this.fixup()) {
                return this.delegate.getMonitor();
            }
            return null;
        }

        @Override
        public void print() {
            if (this.fixup()) {
                this.delegate.print();
            }
        }

        @Override
        public String getRelationText() {
            return "Torrent: '" + new String(this.getName()) + "'";
        }

        @Override
        public Object[] getQueryableInterfaces() {
            try {
                return new Object[]{AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManager(this)};
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected class cacheGroup
        implements TOTorrentAnnounceURLGroup {
            private TOTorrentAnnounceURLSet[] sets;

            protected cacheGroup(List group) throws Exception {
                this.sets = new TOTorrentAnnounceURLSet[group.size()];
                for (int i = 0; i < this.sets.length; ++i) {
                    List set = (List)group.get(i);
                    URL[] urls = new URL[set.size()];
                    for (int j = 0; j < urls.length; ++j) {
                        urls[j] = StringInterner.internURL(new URL(new String((byte[])set.get(j), "UTF-8")));
                    }
                    this.sets[i] = new cacheSet(urls);
                }
            }

            @Override
            public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
                if (CachedStateWrapper.this.announce_group == null && CachedStateWrapper.this.fixup()) {
                    return CachedStateWrapper.this.delegate.getAnnounceURLGroup().getAnnounceURLSets();
                }
                return this.sets;
            }

            void fixGroup() {
                TOTorrentAnnounceURLSet[] realSets = CachedStateWrapper.this.delegate.getAnnounceURLGroup().getAnnounceURLSets();
                if (realSets.length == this.sets.length) {
                    for (int i = 0; i < realSets.length; ++i) {
                        if (!(this.sets[i] instanceof cacheSet)) continue;
                        ((cacheSet)this.sets[i]).delegateSet = realSets[i];
                    }
                    this.sets = null;
                }
            }

            @Override
            public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] toSet) {
                if (CachedStateWrapper.this.fixup()) {
                    TOTorrentAnnounceURLSet[] modToSet = new TOTorrentAnnounceURLSet[toSet.length];
                    for (int i = 0; i < toSet.length; ++i) {
                        TOTorrentAnnounceURLSet set = toSet[i];
                        if (set instanceof cacheSet) {
                            modToSet[i] = ((cacheSet)set).delegateSet;
                        }
                        if (modToSet[i] != null) continue;
                        modToSet[i] = set;
                    }
                    CachedStateWrapper.this.delegate.getAnnounceURLGroup().setAnnounceURLSets(modToSet);
                }
            }

            @Override
            public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] urls) {
                if (CachedStateWrapper.this.fixup()) {
                    return CachedStateWrapper.this.delegate.getAnnounceURLGroup().createAnnounceURLSet(urls);
                }
                return null;
            }

            protected class cacheSet
            implements TOTorrentAnnounceURLSet {
                private URL[] urls;
                private TOTorrentAnnounceURLSet delegateSet;

                public cacheSet(URL[] urls) {
                    this.urls = urls;
                }

                @Override
                public URL[] getAnnounceURLs() {
                    if (CachedStateWrapper.this.announce_group == null && CachedStateWrapper.this.fixup() && this.delegateSet != null) {
                        return this.delegateSet.getAnnounceURLs();
                    }
                    return this.urls;
                }

                @Override
                public void setAnnounceURLs(URL[] toSet) {
                    if (CachedStateWrapper.this.fixup() && this.delegateSet != null) {
                        this.delegateSet.setAnnounceURLs(toSet);
                    } else {
                        this.urls = toSet;
                    }
                }
            }
        }
    }

    protected static class nullState
    implements DownloadManagerState {
        protected final DownloadManager download_manager;

        protected nullState(DownloadManager _dm) {
            this.download_manager = _dm;
        }

        @Override
        public TOTorrent getTorrent() {
            return null;
        }

        @Override
        public File getStateFile() {
            return null;
        }

        @Override
        public DownloadManager getDownloadManager() {
            return this.download_manager;
        }

        @Override
        public void clearResumeData() {
        }

        @Override
        public Map getResumeData() {
            return new HashMap();
        }

        @Override
        public void setResumeData(Map data) {
        }

        @Override
        public boolean isResumeDataComplete() {
            return false;
        }

        @Override
        public void clearTrackerResponseCache() {
        }

        @Override
        public Map getTrackerResponseCache() {
            return new HashMap();
        }

        @Override
        public void setTrackerResponseCache(Map value) {
        }

        @Override
        public void setFlag(long flag, boolean set) {
        }

        @Override
        public boolean getFlag(long flag) {
            return false;
        }

        @Override
        public long getFlags() {
            return 0L;
        }

        @Override
        public void setParameterDefault(String name) {
        }

        @Override
        public long getLongParameter(String name) {
            return 0L;
        }

        @Override
        public void setLongParameter(String name, long value) {
        }

        @Override
        public int getIntParameter(String name) {
            return 0;
        }

        @Override
        public void setIntParameter(String name, int value) {
        }

        @Override
        public boolean getBooleanParameter(String name) {
            return false;
        }

        @Override
        public void setBooleanParameter(String name, boolean value) {
        }

        @Override
        public void setAttribute(String name, String value) {
        }

        @Override
        public String getAttribute(String name) {
            return null;
        }

        @Override
        public String getTrackerClientExtensions() {
            return null;
        }

        @Override
        public void setTrackerClientExtensions(String value) {
        }

        @Override
        public void setListAttribute(String name, String[] values) {
        }

        @Override
        public String getListAttribute(String name, int idx) {
            return null;
        }

        @Override
        public String[] getListAttribute(String name) {
            return null;
        }

        @Override
        public void setMapAttribute(String name, Map value) {
        }

        @Override
        public Map getMapAttribute(String name) {
            return null;
        }

        @Override
        public boolean hasAttribute(String name) {
            return false;
        }

        @Override
        public int getIntAttribute(String name) {
            return 0;
        }

        @Override
        public long getLongAttribute(String name) {
            return 0L;
        }

        @Override
        public boolean getBooleanAttribute(String name) {
            return false;
        }

        @Override
        public void setIntAttribute(String name, int value) {
        }

        @Override
        public void setLongAttribute(String name, long value) {
        }

        @Override
        public void setBooleanAttribute(String name, boolean value) {
        }

        @Override
        public Category getCategory() {
            return null;
        }

        @Override
        public void setCategory(Category cat) {
        }

        @Override
        public String[] getNetworks() {
            return new String[0];
        }

        @Override
        public boolean isNetworkEnabled(String network) {
            return false;
        }

        @Override
        public void setNetworks(String[] networks) {
        }

        @Override
        public void setNetworkEnabled(String network, boolean enabled) {
        }

        @Override
        public String[] getPeerSources() {
            return new String[0];
        }

        @Override
        public boolean isPeerSourcePermitted(String peerSource) {
            return false;
        }

        @Override
        public void setPeerSourcePermitted(String peerSource, boolean permitted) {
        }

        @Override
        public boolean isPeerSourceEnabled(String peerSource) {
            return false;
        }

        @Override
        public void suppressStateSave(boolean suppress) {
        }

        @Override
        public void setPeerSources(String[] networks) {
        }

        @Override
        public void setPeerSourceEnabled(String source, boolean enabled) {
        }

        @Override
        public void setFileLink(int source_index, File link_source, File link_destination) {
        }

        @Override
        public void setFileLinks(List<Integer> source_indexes, List<File> link_sources, List<File> link_destinations) {
        }

        @Override
        public void clearFileLinks() {
        }

        @Override
        public File getFileLink(int source_index, File link_source) {
            return null;
        }

        @Override
        public LinkFileMap getFileLinks() {
            return new LinkFileMap();
        }

        @Override
        public void setActive(boolean active) {
        }

        @Override
        public void discardFluff() {
        }

        @Override
        public boolean exportState(File target_dir) {
            return false;
        }

        @Override
        public void save() {
        }

        @Override
        public void delete() {
        }

        @Override
        public void addListener(DownloadManagerStateListener l) {
        }

        @Override
        public void removeListener(DownloadManagerStateListener l) {
        }

        @Override
        public void addListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        }

        @Override
        public void removeListener(DownloadManagerStateAttributeListener l, String attribute, int event_type) {
        }

        @Override
        public void setDisplayName(String name) {
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public void setUserComment(String name) {
        }

        @Override
        public String getUserComment() {
            return null;
        }

        public void setRelativeSavePath(String name) {
        }

        @Override
        public String getRelativeSavePath() {
            return null;
        }

        @Override
        public boolean parameterExists(String name) {
            return false;
        }

        @Override
        public void generateEvidence(IndentWriter writer) {
            writer.println("DownloadManagerState: broken torrent");
        }

        @Override
        public void dump(IndentWriter writer) {
        }

        @Override
        public boolean isOurContent() {
            return false;
        }

        @Override
        public DiskManagerFileInfo getPrimaryFile() {
            return null;
        }

        @Override
        public void setPrimaryFile(DiskManagerFileInfo dmfi) {
        }
    }
}

