/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerCheckRequestImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ConcurrentHasher;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequest;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;

public class DMCheckerImpl
implements DMChecker {
    protected static final LogIDs LOGID = LogIDs.DISK;
    private static boolean flush_pieces;
    private static boolean checking_read_priority;
    static final AEMonitor class_mon;
    static final List async_check_queue;
    static final AESemaphore async_check_queue_sem;
    private static final boolean fully_async;
    protected final DiskManagerHelper disk_manager;
    protected int async_checks;
    protected final AESemaphore async_check_sem = new AESemaphore("DMChecker::asyncCheck");
    protected int async_reads;
    protected final AESemaphore async_read_sem = new AESemaphore("DMChecker::asyncRead");
    private boolean started;
    protected volatile boolean stopped;
    private volatile boolean complete_recheck_in_progress;
    private volatile int complete_recheck_progress;
    private boolean checking_enabled = true;
    protected final AEMonitor this_mon = new AEMonitor("DMChecker");

    public DMCheckerImpl(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("DMChecker: start while started");
            }
            if (this.stopped) {
                throw new RuntimeException("DMChecker: start after stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        long now;
        int i;
        int check_wait;
        int read_wait;
        try {
            this.this_mon.enter();
            if (this.stopped || !this.started) {
                return;
            }
            this.stopped = true;
            read_wait = this.async_reads;
            check_wait = this.async_checks;
        }
        finally {
            this.this_mon.exit();
        }
        long log_time = SystemTime.getCurrentTime();
        for (i = 0; i < read_wait; ++i) {
            now = SystemTime.getCurrentTime();
            if (now < log_time) {
                log_time = now;
            } else if (now - log_time > 1000L) {
                log_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for check-reads to complete - " + (read_wait - i) + " remaining"));
                }
            }
            this.async_read_sem.reserve();
        }
        log_time = SystemTime.getCurrentTime();
        for (i = 0; i < check_wait; ++i) {
            now = SystemTime.getCurrentTime();
            if (now < log_time) {
                log_time = now;
            } else if (now - log_time > 1000L) {
                log_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for checks to complete - " + (read_wait - i) + " remaining"));
                }
            }
            this.async_check_sem.reserve();
        }
    }

    @Override
    public int getCompleteRecheckStatus() {
        if (this.complete_recheck_in_progress) {
            return this.complete_recheck_progress;
        }
        return -1;
    }

    @Override
    public void setCheckingEnabled(boolean enabled) {
        this.checking_enabled = enabled;
    }

    @Override
    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        return new DiskManagerCheckRequestImpl(pieceNumber, user_data);
    }

    @Override
    public void enqueueCompleteRecheckRequest(final DiskManagerCheckRequest request2, final DiskManagerCheckRequestListener listener) {
        if (!this.checking_enabled) {
            listener.checkCompleted(request2, true);
            return;
        }
        this.complete_recheck_progress = 0;
        this.complete_recheck_in_progress = true;
        new AEThread2("DMChecker::completeRecheck", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DiskManagerRecheckInstance recheck_inst = DMCheckerImpl.this.disk_manager.getRecheckScheduler().register(DMCheckerImpl.this.disk_manager, true);
                try {
                    int i;
                    final AESemaphore sem = new AESemaphore("DMChecker::completeRecheck");
                    int checks_submitted = 0;
                    final AESemaphore run_sem = new AESemaphore("DMChecker::completeRecheck:runsem", 2);
                    int nbPieces = DMCheckerImpl.this.disk_manager.getNbPieces();
                    for (i = 0; i < nbPieces; ++i) {
                        DMCheckerImpl.this.complete_recheck_progress = 1000 * i / nbPieces;
                        DiskManagerPiece dm_piece = DMCheckerImpl.this.disk_manager.getPiece(i);
                        if (!dm_piece.isDone() && dm_piece.isSkipped()) continue;
                        run_sem.reserve();
                        while (!DMCheckerImpl.this.stopped && !recheck_inst.getPermission()) {
                        }
                        if (DMCheckerImpl.this.stopped) break;
                        DiskManagerCheckRequest this_request = DMCheckerImpl.this.createCheckRequest(i, request2.getUserData());
                        DMCheckerImpl.this.enqueueCheckRequest(this_request, new DiskManagerCheckRequestListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                                try {
                                    listener.checkCompleted(request2, passed);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                finally {
                                    this.complete();
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void checkCancelled(DiskManagerCheckRequest request2) {
                                try {
                                    listener.checkCancelled(request2);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                finally {
                                    this.complete();
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                                try {
                                    listener.checkFailed(request2, cause);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                finally {
                                    this.complete();
                                }
                            }

                            protected void complete() {
                                run_sem.release();
                                sem.release();
                            }
                        }, false);
                        ++checks_submitted;
                    }
                    for (i = 0; i < checks_submitted; ++i) {
                        sem.reserve();
                    }
                }
                finally {
                    DMCheckerImpl.this.complete_recheck_in_progress = false;
                    recheck_inst.unregister();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        if (fully_async) {
            try {
                class_mon.enter();
                async_check_queue.add(new Object[]{this, request2, listener});
                if (async_check_queue.size() % 100 == 0) {
                    System.out.println("async check queue size=" + async_check_queue.size());
                }
            }
            finally {
                class_mon.exit();
            }
            async_check_queue_sem.release();
        } else {
            this.enqueueCheckRequest(request2, listener, flush_pieces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
        if (fully_async) {
            try {
                class_mon.enter();
                for (int i = 0; i < async_check_queue.size(); ++i) {
                    DiskManagerCheckRequest request2;
                    Object[] entry = (Object[])async_check_queue.get(i);
                    if (entry[0] != this || (request2 = (DiskManagerCheckRequest)entry[1]).getPieceNumber() != piece_number) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                class_mon.exit();
            }
        }
        return false;
    }

    protected void enqueueCheckRequest(DiskManagerCheckRequest request2, final DiskManagerCheckRequestListener listener, boolean read_flush) {
        request2.requestStarts();
        this.enqueueCheckRequestSupport(request2, new DiskManagerCheckRequestListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                request2.requestEnds(true);
                try {
                    int piece_number = request2.getPieceNumber();
                    DiskManagerPiece piece = DMCheckerImpl.this.disk_manager.getPiece(request2.getPieceNumber());
                    piece.setDone(passed);
                    if (passed) {
                        DMPieceList piece_list = DMCheckerImpl.this.disk_manager.getPieceList(piece_number);
                        for (int i = 0; i < piece_list.size(); ++i) {
                            DMPieceMapEntry piece_entry = piece_list.get(i);
                            piece_entry.getFile().dataChecked(piece_entry.getOffset(), piece_entry.getLength());
                        }
                    }
                }
                finally {
                    listener.checkCompleted(request2, passed);
                    if (Logger.isEnabled()) {
                        if (passed) {
                            Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 0, "Piece " + request2.getPieceNumber() + " passed hash check."));
                        } else {
                            Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + request2.getPieceNumber() + " failed hash check."));
                        }
                    }
                }
            }

            @Override
            public void checkCancelled(DiskManagerCheckRequest request2) {
                request2.requestEnds(false);
                listener.checkCancelled(request2);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + request2.getPieceNumber() + " hash check cancelled."));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                request2.requestEnds(false);
                try {
                    DMCheckerImpl.this.disk_manager.getPiece(request2.getPieceNumber()).setDone(false);
                }
                finally {
                    listener.checkFailed(request2, cause);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + request2.getPieceNumber() + " failed hash check - " + Debug.getNestedExceptionMessage(cause)));
                    }
                }
            }
        }, read_flush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueCheckRequestSupport(final DiskManagerCheckRequest request2, final DiskManagerCheckRequestListener listener, boolean read_flush) {
        if (!this.checking_enabled) {
            listener.checkCompleted(request2, true);
            return;
        }
        final int pieceNumber = request2.getPieceNumber();
        try {
            final byte[] required_hash = this.disk_manager.getPieceHash(pieceNumber);
            final DMPieceList pieceList2 = this.disk_manager.getPieceList(pieceNumber);
            try {
                boolean all_compact = pieceList2.size() > 0;
                for (int i = 0; i < pieceList2.size(); ++i) {
                    int st;
                    DMPieceMapEntry piece_entry = pieceList2.get(i);
                    DiskManagerFileInfoImpl file_info = piece_entry.getFile();
                    CacheFile cache_file = file_info.getCacheFile();
                    if (cache_file.compareLength(piece_entry.getOffset()) < 0L) {
                        listener.checkCompleted(request2, false);
                        return;
                    }
                    if (!all_compact || ((st = cache_file.getStorageType()) == 2 || st == 4) && file_info.getNbPieces() > 2) continue;
                    all_compact = false;
                }
                if (all_compact) {
                    listener.checkCompleted(request2, false);
                    return;
                }
            }
            catch (Throwable e) {
                listener.checkCancelled(request2);
                return;
            }
            int this_piece_length = this.disk_manager.getPieceLength(pieceNumber);
            DiskManagerReadRequest read_request = this.disk_manager.createReadRequest(pieceNumber, 0, this_piece_length);
            try {
                this.this_mon.enter();
                if (this.stopped) {
                    listener.checkCancelled(request2);
                    return;
                }
                ++this.async_reads;
            }
            finally {
                this.this_mon.exit();
            }
            read_request.setFlush(read_flush);
            read_request.setUseCache(!request2.isAdHoc());
            this.disk_manager.enqueueReadRequest(read_request, new DiskManagerReadRequestListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void readCompleted(DiskManagerReadRequest read_request, DirectByteBuffer buffer) {
                    this.complete();
                    try {
                        DMCheckerImpl.this.this_mon.enter();
                        if (DMCheckerImpl.this.stopped) {
                            buffer.returnToPool();
                            listener.checkCancelled(request2);
                            return;
                        }
                        ++DMCheckerImpl.this.async_checks;
                    }
                    finally {
                        DMCheckerImpl.this.this_mon.exit();
                    }
                    if (buffer.getFlag((byte)1)) {
                        try {
                            buffer.returnToPool();
                            listener.checkCompleted(request2, false);
                        }
                        finally {
                            try {
                                DMCheckerImpl.this.this_mon.enter();
                                --DMCheckerImpl.this.async_checks;
                                if (DMCheckerImpl.this.stopped) {
                                    DMCheckerImpl.this.async_check_sem.release();
                                }
                            }
                            finally {
                                DMCheckerImpl.this.this_mon.exit();
                            }
                        }
                    }
                    try {
                        final DirectByteBuffer f_buffer = buffer;
                        ConcurrentHasher.getSingleton().addRequest(buffer.getBuffer((byte)8), new ConcurrentHasherRequestListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void complete(ConcurrentHasherRequest hash_request) {
                                block37: {
                                    int async_result = 3;
                                    try {
                                        byte[] actual_hash = hash_request.getResult();
                                        if (actual_hash == null) break block37;
                                        request2.setHash(actual_hash);
                                        async_result = 1;
                                        for (int i = 0; i < actual_hash.length; ++i) {
                                            if (actual_hash[i] == required_hash[i]) continue;
                                            async_result = 2;
                                            break;
                                        }
                                    }
                                    finally {
                                        try {
                                            if (async_result == 1) {
                                                try {
                                                    for (int i = 0; i < pieceList2.size(); ++i) {
                                                        DMPieceMapEntry piece_entry = pieceList2.get(i);
                                                        DiskManagerFileInfoImpl file_info = piece_entry.getFile();
                                                        if (file_info.getLength() <= 0L && file_info.isSkipped()) continue;
                                                        CacheFile cache_file = file_info.getCacheFile();
                                                        cache_file.setPieceComplete(pieceNumber, f_buffer);
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    f_buffer.returnToPool();
                                                    Debug.out(e);
                                                    listener.checkFailed(request2, e);
                                                    try {
                                                        DMCheckerImpl.this.this_mon.enter();
                                                        --DMCheckerImpl.this.async_checks;
                                                        if (DMCheckerImpl.this.stopped) {
                                                            DMCheckerImpl.this.async_check_sem.release();
                                                        }
                                                    }
                                                    finally {
                                                        DMCheckerImpl.this.this_mon.exit();
                                                    }
                                                    return;
                                                }
                                            }
                                            f_buffer.returnToPool();
                                            if (async_result == 1) {
                                                listener.checkCompleted(request2, true);
                                            } else if (async_result == 2) {
                                                listener.checkCompleted(request2, false);
                                            } else {
                                                listener.checkCancelled(request2);
                                            }
                                        }
                                        finally {
                                            try {
                                                DMCheckerImpl.this.this_mon.enter();
                                                --DMCheckerImpl.this.async_checks;
                                                if (DMCheckerImpl.this.stopped) {
                                                    DMCheckerImpl.this.async_check_sem.release();
                                                }
                                            }
                                            finally {
                                                DMCheckerImpl.this.this_mon.exit();
                                            }
                                        }
                                    }
                                }
                            }
                        }, request2.isLowPriority());
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        buffer.returnToPool();
                        listener.checkFailed(request2, e);
                    }
                }

                @Override
                public void readFailed(DiskManagerReadRequest read_request, Throwable cause) {
                    this.complete();
                    listener.checkFailed(request2, cause);
                }

                @Override
                public int getPriority() {
                    return checking_read_priority ? 0 : -1;
                }

                @Override
                public void requestExecuted(long bytes) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void complete() {
                    try {
                        DMCheckerImpl.this.this_mon.enter();
                        --DMCheckerImpl.this.async_reads;
                        if (DMCheckerImpl.this.stopped) {
                            DMCheckerImpl.this.async_read_sem.release();
                        }
                    }
                    finally {
                        DMCheckerImpl.this.this_mon.exit();
                    }
                }
            });
        }
        catch (Throwable e) {
            this.disk_manager.setFailed("Piece check error - " + Debug.getNestedExceptionMessage(e));
            Debug.printStackTrace(e);
            listener.checkFailed(request2, e);
        }
    }

    static {
        class_mon = new AEMonitor("DMChecker:class");
        async_check_queue = new ArrayList();
        async_check_queue_sem = new AESemaphore("DMChecker::asyncCheck");
        fully_async = COConfigurationManager.getBooleanParameter("diskmanager.perf.checking.fully.async");
        if (fully_async) {
            new AEThread2("DMCheckerImpl:asyncCheckScheduler", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Object[] entry;
                        async_check_queue_sem.reserve();
                        try {
                            class_mon.enter();
                            entry = (Object[])async_check_queue.remove(0);
                            int queue_size = async_check_queue.size();
                            if (queue_size % 100 == 0 && queue_size > 0) {
                                System.out.println("async check queue size=" + async_check_queue.size());
                            }
                        }
                        finally {
                            class_mon.exit();
                        }
                        ((DMCheckerImpl)entry[0]).enqueueCheckRequest((DiskManagerCheckRequest)entry[1], (DiskManagerCheckRequestListener)entry[2], flush_pieces);
                    }
                }
            }.start();
        }
        ParameterListener param_listener = new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                flush_pieces = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.flushpieces");
                checking_read_priority = COConfigurationManager.getBooleanParameter("diskmanager.perf.checking.read.priority");
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"diskmanager.perf.cache.flushpieces", "diskmanager.perf.checking.read.priority"}, param_listener);
    }
}

