/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;

public class DiskManagerPieceImpl
implements DiskManagerPiece {
    private static final byte PIECE_STATUS_NEEDED = 1;
    private static final byte PIECE_STATUS_WRITTEN = 32;
    private static final byte PIECE_STATUS_CHECKING = 64;
    private static final byte PIECE_STATUS_MASK_DOWNLOADABLE = 97;
    private static final byte PIECE_STATUS_MASK_NEEDS_CHECK = 96;
    private final DiskManagerHelper diskManager;
    private final int pieceNumber;
    private final short nbBlocks;
    protected volatile boolean[] written;
    private byte statusFlags;
    private short read_count;
    private boolean done;

    public DiskManagerPieceImpl(DiskManagerHelper _disk_manager, int pieceIndex, int length) {
        this.diskManager = _disk_manager;
        this.pieceNumber = pieceIndex;
        this.nbBlocks = (short)((length + 16384 - 1) / 16384);
        this.statusFlags = 1;
    }

    @Override
    public DiskManager getManager() {
        return this.diskManager;
    }

    @Override
    public int getPieceNumber() {
        return this.pieceNumber;
    }

    @Override
    public int getLength() {
        return this.diskManager.getPieceLength(this.pieceNumber);
    }

    @Override
    public int getNbBlocks() {
        return this.nbBlocks;
    }

    @Override
    public short getReadCount() {
        return this.read_count;
    }

    @Override
    public void setReadCount(short c) {
        this.read_count = c;
    }

    @Override
    public int getBlockSize(int blockNumber) {
        int len;
        if (blockNumber == this.nbBlocks - 1 && (len = this.getLength() % 16384) != 0) {
            return len;
        }
        return 16384;
    }

    @Override
    public boolean isSkipped() {
        DMPieceList pieceList2 = this.diskManager.getPieceList(this.pieceNumber);
        for (int i = 0; i < pieceList2.size(); ++i) {
            DiskManagerFileInfoImpl file = pieceList2.get(i).getFile();
            if (file == null) {
                return false;
            }
            if (file.isSkipped()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNeeded() {
        return (this.statusFlags & 1) != 0;
    }

    @Override
    public boolean calcNeeded() {
        boolean filesNeeded = false;
        DMPieceList pieceList2 = this.diskManager.getPieceList(this.pieceNumber);
        for (int i = 0; i < pieceList2.size(); ++i) {
            DiskManagerFileInfoImpl file = pieceList2.get(i).getFile();
            long fileLength = file.getLength();
            filesNeeded |= fileLength > 0L && file.getDownloaded() < fileLength && !file.isSkipped();
        }
        if (filesNeeded) {
            this.statusFlags = (byte)(this.statusFlags | 1);
            return true;
        }
        this.statusFlags = (byte)(this.statusFlags & 0xFFFFFFFE);
        return false;
    }

    @Override
    public boolean spansFiles() {
        DMPieceList pieceList2 = this.diskManager.getPieceList(this.pieceNumber);
        return pieceList2.size() > 1;
    }

    @Override
    public void clearNeeded() {
        this.statusFlags = (byte)(this.statusFlags & 0xFFFFFFFE);
    }

    @Override
    public void setNeeded() {
        this.statusFlags = (byte)(this.statusFlags | 1);
    }

    @Override
    public void setNeeded(boolean b) {
        this.statusFlags = b ? (byte)(this.statusFlags | 1) : (byte)(this.statusFlags & 0xFFFFFFFE);
    }

    @Override
    public boolean isWritten() {
        return (this.statusFlags & 0x20) != 0;
    }

    @Override
    public boolean[] getWritten() {
        return this.written;
    }

    @Override
    public boolean isWritten(int blockNumber) {
        if (this.done) {
            return true;
        }
        boolean[] writtenRef = this.written;
        if (writtenRef == null) {
            return false;
        }
        return writtenRef[blockNumber];
    }

    @Override
    public int getNbWritten() {
        if (this.done) {
            return this.nbBlocks;
        }
        boolean[] writtenRef = this.written;
        if (writtenRef == null) {
            return 0;
        }
        int res = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (!writtenRef[i]) continue;
            ++res;
        }
        return res;
    }

    @Override
    public void setWritten(int blockNumber) {
        if (this.written == null) {
            this.written = new boolean[this.nbBlocks];
        }
        boolean[] written_ref = this.written;
        written_ref[blockNumber] = true;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (written_ref[i]) continue;
            return;
        }
        this.statusFlags = (byte)(this.statusFlags | 0x20);
    }

    @Override
    public boolean isChecking() {
        return (this.statusFlags & 0x40) != 0;
    }

    @Override
    public void setChecking() {
        this.statusFlags = (byte)(this.statusFlags | 0x40);
    }

    @Override
    public boolean isNeedsCheck() {
        return !this.done && (this.statusFlags & 0x60) == 32;
    }

    @Override
    public boolean calcDone() {
        return this.done;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void setDone(boolean b) {
        if (b != this.done) {
            this.diskManager.setPieceDone(this, b);
        }
    }

    public void setDoneSupport(boolean b) {
        this.done = b;
        if (this.done) {
            this.written = null;
        }
    }

    @Override
    public void setDownloadable() {
        this.setDone(false);
        this.statusFlags = (byte)(this.statusFlags & 0xFFFFFF9E);
        this.calcNeeded();
    }

    @Override
    public boolean isDownloadable() {
        return !this.done && (this.statusFlags & 0x61) == 1;
    }

    @Override
    public boolean isInteresting() {
        return !this.done && (this.statusFlags & 1) != 0;
    }

    @Override
    public void reset() {
        this.setDownloadable();
        this.written = null;
    }

    @Override
    public void reDownloadBlock(int blockNumber) {
        boolean[] written_ref = this.written;
        if (written_ref != null) {
            written_ref[blockNumber] = false;
            this.setDownloadable();
        }
    }

    @Override
    public String getString() {
        String text = "";
        text = text + (this.isNeeded() ? "needed," : "");
        text = text + (this.isDone() ? "done," : "");
        if (!this.isDone()) {
            text = text + (this.isDownloadable() ? "downable," : "");
            text = text + (this.isWritten() ? "written" : "written " + this.getNbWritten()) + ",";
            text = text + (this.isChecking() ? "checking" : "");
        }
        if (text.endsWith(",")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

