/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessControllerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import com.aelitis.azureus.core.util.LinkFileMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerAllocationScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoSetImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class DiskManagerImpl
extends LogRelation
implements DiskManagerHelper {
    private static final int DM_FREE_PIECELIST_TIMEOUT = 120000;
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final DiskAccessController disk_access_controller;
    private static boolean reorder_storage_mode;
    private static int reorder_storage_mode_min_mb;
    private static final DiskManagerRecheckScheduler recheck_scheduler;
    private static final DiskManagerAllocationScheduler allocation_scheduler;
    private static final ThreadPool start_pool;
    private boolean used = false;
    private boolean started = false;
    final AESemaphore started_sem = new AESemaphore("DiskManager::started");
    private boolean starting;
    private boolean stopping;
    private int state_set_via_method;
    private String errorMessage = "";
    private int errorType = 0;
    private int pieceLength;
    private int lastPieceLength;
    private int nbPieces;
    private long totalLength;
    private int percentDone;
    private long allocated;
    private long remaining;
    private final TOTorrent torrent;
    private DMReader reader;
    private DMChecker checker;
    private DMWriter writer;
    private RDResumeHandler resume_handler;
    private DMPieceMapper piece_mapper;
    private DiskManagerPieceImpl[] pieces;
    private DMPieceMap piece_map_use_accessor;
    private long piece_map_use_accessor_time;
    private DiskManagerFileInfoImpl[] files;
    private DiskManagerFileInfoSet fileset;
    protected final DownloadManager download_manager;
    private boolean alreadyMoved = false;
    private boolean skipped_file_set_changed = true;
    private long skipped_file_set_size;
    private long skipped_but_downloaded;
    private final AtomicLong priority_change_marker = new AtomicLong(RandomUtils.nextLong());
    private boolean checking_enabled;
    private volatile boolean move_in_progress;
    private volatile int move_progress;
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_PRIOCHANGED = 2;
    private static final int LDT_PIECE_DONE_CHANGED = 3;
    private static final int LDT_ACCESS_MODE_CHANGED = 4;
    protected static final ListenerManager<DiskManagerListener> listeners_aggregator;
    private final ListenerManager<DiskManagerListener> listeners;
    final AEMonitor start_stop_mon;
    private final AEMonitor file_piece_mon;

    public static DiskAccessController getDefaultDiskAccessController() {
        return disk_access_controller;
    }

    public DiskManagerImpl(TOTorrent _torrent, DownloadManager _dmanager) {
        if (this.priority_change_marker.get() == 0L) {
            this.priority_change_marker.incrementAndGet();
        }
        this.checking_enabled = true;
        this.listeners = ListenerManager.createManager("DiskM:ListenDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

            @Override
            public void dispatch(DiskManagerListener listener, int type, Object value) {
                listeners_aggregator.dispatch(listener, type, value);
            }
        });
        this.start_stop_mon = new AEMonitor("DiskManager:startStop");
        this.file_piece_mon = new AEMonitor("DiskManager:filePiece");
        this.torrent = _torrent;
        this.download_manager = _dmanager;
        this.pieces = new DiskManagerPieceImpl[0];
        this.setState(1);
        this.percentDone = 0;
        this.errorType = 0;
        if (this.torrent == null) {
            this.errorMessage = "Torrent not available";
            this.setState(10);
            return;
        }
        LocaleUtilDecoder locale_decoder = null;
        try {
            locale_decoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this.errorMessage = TorrentUtils.exceptionToText(e);
            this.setState(10);
            return;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Initialisation failed - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.piece_mapper = DMPieceMapperFactory.create(this.torrent);
        try {
            this.piece_mapper.construct(locale_decoder, this.download_manager.getAbsoluteSaveLocation().getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Failed to build piece map - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.remaining = this.totalLength = this.piece_mapper.getTotalLength();
        this.nbPieces = this.torrent.getNumberOfPieces();
        this.pieceLength = (int)this.torrent.getPieceLength();
        this.lastPieceLength = this.piece_mapper.getLastPieceLength();
        this.pieces = new DiskManagerPieceImpl[this.nbPieces];
        for (int i = 0; i < this.nbPieces; ++i) {
            this.pieces[i] = new DiskManagerPieceImpl(this, i, i == this.nbPieces - 1 ? this.lastPieceLength : this.pieceLength);
        }
        this.reader = DMAccessFactory.createReader(this);
        this.checker = DMAccessFactory.createChecker(this);
        this.writer = DMAccessFactory.createWriter(this);
        this.resume_handler = new RDResumeHandler(this, this.checker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            if (this.move_in_progress) {
                Debug.out("start called while move in progress!");
            }
            this.start_stop_mon.enter();
            if (this.used) {
                Debug.out("DiskManager reuse not supported!!!!");
            }
            this.used = true;
            if (this.getState() == 10) {
                Debug.out("starting a faulty disk manager");
                return;
            }
            this.started = true;
            this.starting = true;
            start_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    boolean stop_required;
                    try {
                        try {
                            DiskManagerImpl.this.start_stop_mon.enter();
                            if (DiskManagerImpl.this.stopping) {
                                throw new Exception("Stopped during startup");
                            }
                        }
                        finally {
                            DiskManagerImpl.this.start_stop_mon.exit();
                        }
                        DiskManagerImpl.this.startSupport();
                    }
                    catch (Throwable e) {
                        DiskManagerImpl.this.errorMessage = Debug.getNestedExceptionMessage(e) + " (start)";
                        Debug.printStackTrace(e);
                        DiskManagerImpl.this.setState(10);
                    }
                    finally {
                        DiskManagerImpl.this.started_sem.release();
                    }
                    try {
                        DiskManagerImpl.this.start_stop_mon.enter();
                        stop_required = DiskManagerImpl.this.getState() == 10 || DiskManagerImpl.this.stopping;
                        DiskManagerImpl.this.starting = false;
                    }
                    finally {
                        DiskManagerImpl.this.start_stop_mon.exit();
                    }
                    if (stop_required) {
                        DiskManagerImpl.this.stop(false);
                    }
                }
            });
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private void startSupport() {
        boolean files_exist = false;
        if (this.download_manager.isPersistent()) {
            File[] move_to_dirs = DownloadManagerMoveHandler.getRelatedDirs(this.download_manager);
            for (int i = 0; i < move_to_dirs.length; ++i) {
                String move_to_dir = move_to_dirs[i].getAbsolutePath();
                if (!this.filesExist(move_to_dir)) continue;
                files_exist = true;
                this.alreadyMoved = true;
                this.download_manager.setTorrentSaveDir(move_to_dir);
                break;
            }
        }
        this.reader.start();
        this.checker.start();
        this.writer.start();
        if (!this.alreadyMoved && !this.download_manager.isDataAlreadyAllocated()) {
            SaveLocationChange transfer;
            if (!files_exist) {
                files_exist = this.filesExist();
            }
            if (!files_exist && (transfer = DownloadManagerMoveHandler.onInitialisation(this.download_manager)) != null) {
                if (transfer.download_location != null || transfer.download_name != null) {
                    File dl_location = transfer.download_location;
                    if (dl_location == null) {
                        dl_location = this.download_manager.getAbsoluteSaveLocation().getParentFile();
                    }
                    if (transfer.download_name == null) {
                        this.download_manager.setTorrentSaveDir(dl_location.getAbsolutePath());
                    } else {
                        this.download_manager.setTorrentSaveDir(dl_location.getAbsolutePath(), transfer.download_name);
                    }
                }
                if (transfer.torrent_location != null || transfer.torrent_name != null) {
                    try {
                        this.download_manager.setTorrentFile(transfer.torrent_location, transfer.torrent_name);
                    }
                    catch (DownloadManagerException e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        int[] alloc_result = this.allocateFiles();
        int newFiles = alloc_result[0];
        int notNeededFiles = alloc_result[1];
        if (this.getState() == 10) {
            return;
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(3);
        this.resume_handler.start();
        if (this.checking_enabled) {
            if (newFiles == 0) {
                this.resume_handler.checkAllPieces(false);
                if (this.getRemainingExcludingDND() == 0L) {
                    this.checkFreePieceList(true);
                }
            } else if (newFiles + notNeededFiles != this.files.length) {
                this.resume_handler.checkAllPieces(true);
            }
        }
        if (this.getState() == 10) {
            return;
        }
        this.skipped_file_set_changed = true;
        this.setState(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop(boolean closing) {
        try {
            if (this.move_in_progress) {
                Debug.out("stop called while move in progress!");
            }
            this.start_stop_mon.enter();
            if (!this.started) {
                boolean bl = false;
                return bl;
            }
            if (this.starting) {
                this.stopping = true;
                this.checker.stop();
                this.writer.stop();
                this.reader.stop();
                this.resume_handler.stop(closing);
                this.saveState(false);
                boolean bl = true;
                return bl;
            }
            this.started = false;
            this.stopping = false;
        }
        finally {
            this.start_stop_mon.exit();
        }
        this.started_sem.reserve();
        this.checker.stop();
        this.writer.stop();
        this.reader.stop();
        this.resume_handler.stop(closing);
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    if (this.files[i] == null) continue;
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable e) {
                    this.setFailed("File close fails: " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
        if (this.getState() == 4) {
            try {
                this.saveResumeData(false);
            }
            catch (Exception e) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
            }
        }
        this.saveState();
        this.listeners.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStopped() {
        if (this.move_in_progress) {
            Debug.out("isStopped called while move in progress!");
        }
        try {
            this.start_stop_mon.enter();
            boolean bl = !this.started && !this.starting && !this.stopping;
            return bl;
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    @Override
    public boolean filesExist() {
        return this.filesExist(this.download_manager.getAbsoluteSaveLocation().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean filesExist(String root_dir) {
        if (!this.torrent.isSimpleTorrent()) {
            root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
        }
        if (!root_dir.endsWith(File.separator)) {
            root_dir = root_dir + File.separator;
        }
        DMPieceMapperFile[] pm_files = this.piece_mapper.getFiles();
        String[] storage_types = this.getStorageTypes();
        DownloadManagerState state = this.download_manager.getDownloadState();
        for (int i = 0; i < pm_files.length; ++i) {
            DMPieceMapperFile pm_info = pm_files[i];
            File relative_file = pm_info.getDataFile();
            long target_length = pm_info.getLength();
            DiskManagerFileInfoImpl file_info = pm_info.getFileInfo();
            boolean close_it = false;
            try {
                if (file_info == null) {
                    int storage_type = DiskManagerUtil.convertDMStorageTypeFromString(storage_types[i]);
                    file_info = this.createFileInfo(state, pm_info, i, root_dir, relative_file, storage_type);
                    close_it = true;
                }
                try {
                    CacheFile cache_file = file_info.getCacheFile();
                    File data_file = file_info.getFile(true);
                    if (!cache_file.exists()) {
                        File parent;
                        File current = data_file;
                        while (!current.exists() && (parent = current.getParentFile()) != null) {
                            if (parent.exists()) {
                                this.errorMessage = parent.isDirectory() ? current.toString() + " not found." : parent.toString() + " is not a directory.";
                                boolean bl = false;
                                return bl;
                            }
                            current = parent;
                        }
                        this.errorMessage = data_file.toString() + " not found.";
                        boolean bl = false;
                        return bl;
                    }
                    long existing_length = file_info.getCacheFile().getLength();
                    if (existing_length <= target_length) continue;
                    if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                        file_info.setAccessMode(2);
                        file_info.getCacheFile().setLength(target_length);
                        Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                        continue;
                    }
                    this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (close_it) {
                        file_info.getCacheFile().close();
                    }
                }
            }
            catch (Throwable e) {
                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (filesExist:" + relative_file.toString() + ")";
                return false;
            }
        }
        return true;
    }

    private DiskManagerFileInfoImpl createFileInfo(DownloadManagerState state, DMPieceMapperFile pm_info, int file_index, String root_dir, File relative_file, int storage_type) throws Exception {
        try {
            return new DiskManagerFileInfoImpl(this, root_dir, relative_file, file_index, pm_info.getTorrentFile(), storage_type);
        }
        catch (CacheFileManagerException e) {
            if (Debug.getNestedExceptionMessage(e).contains("volume label syntax is incorrect")) {
                File temp;
                File target_file = new File(root_dir + relative_file.toString());
                File actual_file = state.getFileLink(file_index, target_file);
                if (actual_file == null) {
                    actual_file = target_file;
                }
                Stack<String> comps = new Stack<String>();
                boolean fixed = false;
                for (temp = actual_file; temp != null && !temp.exists(); temp = temp.getParentFile()) {
                    char[] chars;
                    String old_name = temp.getName();
                    String new_name = "";
                    for (char c : chars = old_name.toCharArray()) {
                        char i_c = c;
                        new_name = i_c >= '\u0000' && i_c < ' ' ? new_name + "_" : new_name + c;
                    }
                    comps.push(new_name);
                    if (old_name.equals(new_name)) continue;
                    fixed = true;
                }
                if (fixed) {
                    while (!comps.isEmpty()) {
                        String comp2 = (String)comps.pop();
                        if (comps.isEmpty()) {
                            String prefix = Base32.encode(new SHA1Simple().calculateHash(relative_file.toString().getBytes("UTF-8"))).substring(0, 4);
                            comp2 = prefix + "_" + comp2;
                        }
                        temp = new File(temp, comp2);
                    }
                    Debug.outNoStack("Fixing unsupported file path: " + actual_file.getAbsolutePath() + " -> " + temp.getAbsolutePath());
                    state.setFileLink(file_index, target_file, temp);
                    return new DiskManagerFileInfoImpl(this, root_dir, relative_file, file_index, pm_info.getTorrentFile(), storage_type);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] allocateFiles() {
        int[] fail_result = new int[]{-1, -1};
        HashSet<String> file_set = new HashSet<String>();
        DMPieceMapperFile[] pm_files = this.piece_mapper.getFiles();
        DiskManagerFileInfoImpl[] allocated_files = new DiskManagerFileInfoImpl[pm_files.length];
        DownloadManagerState state = this.download_manager.getDownloadState();
        try {
            allocation_scheduler.register(this);
            this.setState(2);
            this.allocated = 0L;
            int numNewFiles = 0;
            int notRequiredFiles = 0;
            String root_dir = this.download_manager.getAbsoluteSaveLocation().getParent();
            if (!this.torrent.isSimpleTorrent()) {
                root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
            }
            root_dir = root_dir + File.separator;
            String[] storage_types = this.getStorageTypes();
            String incomplete_suffix = state.getAttribute("incompfilesuffix");
            for (int i = 0; i < pm_files.length; ++i) {
                boolean mustExistOrAllocate;
                File data_file;
                DiskManagerFileInfoImpl fileInfo2;
                long target_length;
                block61: {
                    block60: {
                        long existing_length;
                        boolean compact;
                        block59: {
                            int separator;
                            if (this.stopping) {
                                this.errorMessage = "File allocation interrupted - download is stopping";
                                this.setState(10);
                                int[] nArray = fail_result;
                                return nArray;
                            }
                            DMPieceMapperFile pm_info = pm_files[i];
                            target_length = pm_info.getLength();
                            File relative_data_file = pm_info.getDataFile();
                            try {
                                int storage_type = DiskManagerUtil.convertDMStorageTypeFromString(storage_types[i]);
                                allocated_files[i] = fileInfo2 = this.createFileInfo(state, pm_info, i, root_dir, relative_data_file, storage_type);
                                pm_info.setFileInfo(fileInfo2);
                            }
                            catch (Exception e) {
                                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles:" + relative_data_file.toString() + ")";
                                this.setState(10);
                                int[] nArray = fail_result;
                                allocation_scheduler.unregister(this);
                                if (this.files == null) {
                                    for (int i2 = 0; i2 < allocated_files.length; ++i2) {
                                        if (allocated_files[i2] == null) continue;
                                        try {
                                            allocated_files[i2].getCacheFile().close();
                                            continue;
                                        }
                                        catch (Throwable e2) {
                                            // empty catch block
                                        }
                                    }
                                }
                                return nArray;
                            }
                            CacheFile cache_file = fileInfo2.getCacheFile();
                            data_file = fileInfo2.getFile(true);
                            String file_key = data_file.getAbsolutePath();
                            if (Constants.isWindows) {
                                file_key = file_key.toLowerCase();
                            }
                            if (file_set.contains(file_key)) {
                                this.errorMessage = "File occurs more than once in download: " + data_file.toString() + ".\nRename one of the files in Files view via the right-click menu.";
                                this.setState(10);
                                int[] e2 = fail_result;
                                return e2;
                            }
                            file_set.add(file_key);
                            String ext = data_file.getName();
                            if (incomplete_suffix != null && ext.endsWith(incomplete_suffix)) {
                                ext = ext.substring(0, ext.length() - incomplete_suffix.length());
                            }
                            if ((separator = ext.lastIndexOf(".")) == -1) {
                                separator = 0;
                            }
                            fileInfo2.setExtension(ext.substring(separator));
                            String extensions = COConfigurationManager.getStringParameter("priorityExtensions", "");
                            if (!extensions.equals("")) {
                                boolean bIgnoreCase = COConfigurationManager.getBooleanParameter("priorityExtensionsIgnoreCase");
                                StringTokenizer st = new StringTokenizer(extensions, ";");
                                while (st.hasMoreTokens()) {
                                    boolean bHighPriority;
                                    String extension = st.nextToken();
                                    if (!(extension = extension.trim()).startsWith(".")) {
                                        extension = "." + extension;
                                    }
                                    if (!(bHighPriority = bIgnoreCase ? fileInfo2.getExtension().equalsIgnoreCase(extension) : fileInfo2.getExtension().equals(extension))) continue;
                                    fileInfo2.setPriority(1);
                                }
                            }
                            fileInfo2.setDownloaded(0L);
                            int st = cache_file.getStorageType();
                            compact = st == 2 || st == 4;
                            boolean bl = mustExistOrAllocate = !compact || RDResumeHandler.fileMustExist(this.download_manager, fileInfo2);
                            if (!mustExistOrAllocate && cache_file.exists()) {
                                data_file.delete();
                            }
                            if (!cache_file.exists()) break block61;
                            try {
                                existing_length = fileInfo2.getCacheFile().getLength();
                                if (existing_length <= target_length) break block59;
                                if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                                    fileInfo2.setAccessMode(2);
                                    cache_file.setLength(target_length);
                                    fileInfo2.setAccessMode(1);
                                    Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                                    break block60;
                                }
                                this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                                this.setState(10);
                                int[] nArray = fail_result;
                                return nArray;
                            }
                            catch (Throwable e) {
                                this.fileAllocFailed(data_file, target_length, false, e);
                                this.setState(10);
                                int[] nArray = fail_result;
                                return nArray;
                            }
                        }
                        if (existing_length < target_length && !compact && !this.allocateFile(fileInfo2, data_file, existing_length, target_length)) {
                            int[] nArray = fail_result;
                            return nArray;
                        }
                    }
                    this.allocated += target_length;
                    continue;
                }
                if (mustExistOrAllocate) {
                    if (this.download_manager.isDataAlreadyAllocated()) {
                        this.errorMessage = "Data file missing: " + data_file.getAbsolutePath();
                        this.setState(10);
                        int[] e = fail_result;
                        return e;
                    }
                    if (!this.allocateFile(fileInfo2, data_file, -1L, target_length)) {
                        int[] e = fail_result;
                        return e;
                    }
                    ++numNewFiles;
                    continue;
                }
                ++notRequiredFiles;
            }
            this.files = allocated_files;
            this.fileset = new DiskManagerFileInfoSetImpl(this.files, this);
            this.loadFilePriorities();
            this.download_manager.setDataAlreadyAllocated(true);
            int[] nArray = new int[]{numNewFiles, notRequiredFiles};
            return nArray;
        }
        finally {
            allocation_scheduler.unregister(this);
            if (this.files == null) {
                for (int i = 0; i < allocated_files.length; ++i) {
                    if (allocated_files[i] == null) continue;
                    try {
                        allocated_files[i].getCacheFile().close();
                        continue;
                    }
                    catch (Throwable e) {}
                }
            }
        }
    }

    private boolean allocateFile(DiskManagerFileInfoImpl fileInfo2, File data_file, long existing_length, long target_length) throws Throwable {
        while (this.started && !allocation_scheduler.getPermission(this)) {
        }
        if (!this.started) {
            return false;
        }
        fileInfo2.setAccessMode(2);
        if (COConfigurationManager.getBooleanParameter("Enable incremental file creation")) {
            if (existing_length < 0L) {
                fileInfo2.getCacheFile().setLength(0L);
            }
        } else if (target_length > 0L && !Constants.isWindows && COConfigurationManager.getBooleanParameter("XFS Allocation")) {
            long resvp_len;
            long resvp_start;
            fileInfo2.getCacheFile().setLength(target_length);
            if (existing_length > 0L) {
                resvp_start = existing_length;
                resvp_len = target_length - existing_length;
            } else {
                resvp_start = 0L;
                resvp_len = target_length;
            }
            String[] cmd = new String[]{"/usr/sbin/xfs_io", "-c", "resvsp " + resvp_start + " " + resvp_len, data_file.getAbsolutePath()};
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                int count = p.getErrorStream().read(buffer);
                while (count > 0) {
                    os.write(buffer, 0, count);
                    count = p.getErrorStream().read(buffer);
                }
                os.close();
                p.waitFor();
            }
            catch (IOException e) {
                String message = MessageText.getString("xfs.allocation.xfs_io.not.found", new String[]{e.getMessage()});
                Logger.log(new LogAlert((Object)this, false, 3, message));
            }
            if (os.size() > 0) {
                String message = os.toString().trim();
                if (message.endsWith("is not on an XFS filesystem")) {
                    Logger.log(new LogEvent(this, LogIDs.DISK, "XFS file allocation impossible because \"" + data_file.getAbsolutePath() + "\" is not on an XFS filesystem. Original error reported by xfs_io : \"" + message + "\""));
                } else {
                    throw new Exception(message);
                }
            }
            this.allocated += target_length;
        } else {
            if (COConfigurationManager.getBooleanParameter("Zero New")) {
                boolean successfulAlloc = false;
                try {
                    successfulAlloc = this.writer.zeroFile(fileInfo2, target_length);
                }
                catch (Throwable e) {
                    this.fileAllocFailed(data_file, target_length, existing_length == -1L, e);
                    throw e;
                }
                finally {
                    if (!successfulAlloc) {
                        try {
                            fileInfo2.getCacheFile().close();
                            fileInfo2.getCacheFile().delete();
                        }
                        catch (Throwable e) {}
                        this.setState(10);
                    }
                }
            }
            fileInfo2.getCacheFile().setLength(target_length);
            this.allocated += target_length;
        }
        fileInfo2.setAccessMode(1);
        return true;
    }

    private void fileAllocFailed(File file, long length, boolean is_new, Throwable e) {
        this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles " + (is_new ? "new" : "existing") + ":" + file.toString() + ")";
        if (this.errorMessage.contains("not enough space")) {
            this.errorType = 2;
            this.errorMessage = length >= 0x100000000L ? MessageText.getString("DiskManager.error.nospace_fat32") : MessageText.getString("DiskManager.error.nospace");
        }
    }

    @Override
    public DiskAccessController getDiskAccessController() {
        return disk_access_controller;
    }

    @Override
    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.reader.readBlock(request2, listener);
    }

    @Override
    public boolean hasOutstandingReadRequestForPiece(int piece_number) {
        return this.reader.hasOutstandingReadRequestForPiece(piece_number);
    }

    @Override
    public int getNbPieces() {
        return this.nbPieces;
    }

    @Override
    public int getPercentDone() {
        return this.percentDone;
    }

    @Override
    public void setPercentDone(int num) {
        this.percentDone = num;
    }

    @Override
    public long getRemaining() {
        return this.remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixupSkippedCalculation() {
        DiskManagerFileInfoImpl[] current_files;
        if (this.skipped_file_set_changed && (current_files = this.files) != null) {
            this.skipped_file_set_changed = false;
            try {
                this.file_piece_mon.enter();
                long skipped = 0L;
                long downloaded = 0L;
                for (int i = 0; i < current_files.length; ++i) {
                    DiskManagerFileInfoImpl file = current_files[i];
                    if (!file.isSkipped()) continue;
                    skipped += file.getLength();
                    downloaded += file.getDownloaded();
                }
                this.skipped_file_set_size = skipped;
                this.skipped_but_downloaded = downloaded;
            }
            finally {
                this.file_piece_mon.exit();
            }
            DownloadManagerStats stats2 = this.download_manager.getStats();
            if (stats2 instanceof DownloadManagerStatsImpl) {
                ((DownloadManagerStatsImpl)stats2).setSkippedFileStats(this.skipped_file_set_size, this.skipped_but_downloaded);
            }
        }
    }

    @Override
    public long getRemainingExcludingDND() {
        this.fixupSkippedCalculation();
        long rem = this.remaining - (this.skipped_file_set_size - this.skipped_but_downloaded);
        if (rem < 0L) {
            rem = 0L;
        }
        return rem;
    }

    @Override
    public long getSizeExcludingDND() {
        this.fixupSkippedCalculation();
        return this.totalLength - this.skipped_file_set_size;
    }

    @Override
    public int getPercentDoneExcludingDND() {
        long sizeExcludingDND = this.getSizeExcludingDND();
        if (sizeExcludingDND <= 0L) {
            return 0;
        }
        float pct = (float)(sizeExcludingDND - this.getRemainingExcludingDND()) / (float)sizeExcludingDND;
        return (int)(1000.0f * pct);
    }

    @Override
    public long getAllocated() {
        return this.allocated;
    }

    @Override
    public void setAllocated(long num) {
        this.allocated = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPieceDone(DiskManagerPieceImpl dmPiece, boolean done) {
        block22: {
            int piece_number = dmPiece.getPieceNumber();
            int piece_length = dmPiece.getLength();
            try {
                this.file_piece_mon.enter();
                if (dmPiece.isDone() == done) break block22;
                dmPiece.setDoneSupport(done);
                this.remaining = done ? (this.remaining -= (long)piece_length) : (this.remaining += (long)piece_length);
                DMPieceList piece_list = this.getPieceList(piece_number);
                for (int i = 0; i < piece_list.size(); ++i) {
                    long file_done;
                    DMPieceMapEntry piece_map_entry = piece_list.get(i);
                    DiskManagerFileInfoImpl this_file = piece_map_entry.getFile();
                    long file_length = this_file.getLength();
                    long file_done_before = file_done = this_file.getDownloaded();
                    file_done = done ? (file_done += (long)piece_map_entry.getLength()) : (file_done -= (long)piece_map_entry.getLength());
                    if (file_done < 0L) {
                        Debug.out("piece map entry length negative");
                        file_done = 0L;
                    } else if (file_done > file_length) {
                        Debug.out("piece map entry length too large");
                        file_done = file_length;
                    }
                    if (this_file.isSkipped()) {
                        this.skipped_but_downloaded += file_done - file_done_before;
                    }
                    this_file.setDownloaded(file_done);
                    if (file_done != file_length) continue;
                    try {
                        DownloadManagerState state = this.download_manager.getDownloadState();
                        try {
                            File new_file;
                            File save_location;
                            String name;
                            String suffix = state.getAttribute("incompfilesuffix");
                            if (suffix == null || suffix.length() <= 0) continue;
                            String prefix = state.getAttribute("dnd_pfx");
                            if (prefix == null) {
                                prefix = "";
                            }
                            File base_file = this_file.getFile(false);
                            int file_index = this_file.getIndex();
                            File link = state.getFileLink(file_index, base_file);
                            if (link != null) {
                                File new_file2;
                                String name2 = link.getName();
                                if (!name2.endsWith(suffix) || name2.length() <= suffix.length()) continue;
                                String new_name = name2.substring(0, name2.length() - suffix.length());
                                if (!this_file.isSkipped() && prefix.length() > 0 && new_name.startsWith(prefix)) {
                                    new_name = new_name.substring(prefix.length());
                                }
                                if ((new_file2 = new File(link.getParentFile(), new_name)).exists()) continue;
                                this_file.renameFile(new_name);
                                if (base_file.equals(new_file2)) {
                                    state.setFileLink(file_index, base_file, null);
                                    continue;
                                }
                                state.setFileLink(file_index, base_file, new_file2);
                                continue;
                            }
                            if (!this_file.getTorrentFile().getTorrent().isSimpleTorrent() || !(name = (save_location = this.download_manager.getSaveLocation()).getName()).endsWith(suffix) || name.length() <= suffix.length()) continue;
                            String new_name = name.substring(0, name.length() - suffix.length());
                            if (!this_file.isSkipped() && prefix.length() > 0 && new_name.startsWith(prefix)) {
                                new_name = new_name.substring(prefix.length());
                            }
                            if ((new_file = new File(save_location.getParentFile(), new_name)).exists()) continue;
                            this_file.renameFile(new_name);
                            if (save_location.equals(new_file)) {
                                state.setFileLink(0, save_location, null);
                                continue;
                            }
                            state.setFileLink(0, save_location, new_file);
                            continue;
                        }
                        finally {
                            if (this_file.getAccessMode() == 2) {
                                this_file.setAccessMode(1);
                            }
                            if (this.getState() == 4) {
                                state.setLongParameter("stats.download.file.completed.time", SystemTime.getCurrentTime());
                            }
                        }
                    }
                    catch (Throwable e) {
                        this.setFailed("Disk access error - " + Debug.getNestedExceptionMessage(e));
                        Debug.printStackTrace(e);
                    }
                }
                if (this.getState() == 4) {
                    this.listeners.dispatch(3, dmPiece);
                }
            }
            finally {
                this.file_piece_mon.exit();
            }
        }
    }

    @Override
    public void accessModeChanged(DiskManagerFileInfoImpl file, int old_mode, int new_mode) {
        this.listeners.dispatch(4, new Object[]{file, new Integer(old_mode), new Integer(new_mode)});
    }

    @Override
    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    @Override
    public DiskManagerPiece getPiece(int PieceNumber) {
        return this.pieces[PieceNumber];
    }

    @Override
    public int getPieceLength() {
        return this.pieceLength;
    }

    @Override
    public int getPieceLength(int piece_number) {
        if (piece_number == this.nbPieces - 1) {
            return this.lastPieceLength;
        }
        return this.pieceLength;
    }

    @Override
    public long getTotalLength() {
        return this.totalLength;
    }

    public int getLastPieceLength() {
        return this.lastPieceLength;
    }

    @Override
    public int getState() {
        return this.state_set_via_method;
    }

    protected void setState(int _state) {
        if (this.state_set_via_method == 10) {
            if (_state != 10) {
                Debug.out("DiskManager: attempt to move from faulty state to " + _state);
            }
            return;
        }
        if (this.state_set_via_method != _state) {
            int[] params = new int[]{this.state_set_via_method, _state};
            this.state_set_via_method = _state;
            if (_state == 10 && this.errorType == 0) {
                this.errorType = 1;
            }
            this.listeners.dispatch(1, params);
        }
    }

    @Override
    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    @Override
    public DiskManagerFileInfoSet getFileSet() {
        return this.fileset;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int getErrorType() {
        return this.errorType;
    }

    @Override
    public void setFailed(final String reason) {
        new AEThread("DiskManager:setFailed"){

            @Override
            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
            }
        }.start();
    }

    @Override
    public void setFailed(final DiskManagerFileInfo file, final String reason) {
        new AEThread("DiskManager:setFailed"){

            @Override
            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert((Object)DiskManagerImpl.this, false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
                RDResumeHandler.recheckFile(DiskManagerImpl.this.download_manager, file);
            }
        }.start();
    }

    @Override
    public int getCacheMode() {
        return 1;
    }

    @Override
    public long[] getReadStats() {
        if (this.reader == null) {
            return new long[]{0L, 0L};
        }
        return this.reader.getStats();
    }

    @Override
    public DMPieceMap getPieceMap() {
        DMPieceMap map = this.piece_map_use_accessor;
        if (map == null) {
            this.piece_map_use_accessor = map = this.piece_mapper.getPieceMap();
        }
        this.piece_map_use_accessor_time = SystemTime.getCurrentTime();
        return map;
    }

    @Override
    public DMPieceList getPieceList(int piece_number) {
        DMPieceMap map = this.getPieceMap();
        return map.getPieceList(piece_number);
    }

    public void checkFreePieceList(boolean force_discard) {
        if (this.piece_map_use_accessor == null) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (!force_discard) {
            if (now < this.piece_map_use_accessor_time) {
                this.piece_map_use_accessor_time = now;
                return;
            }
            if (now - this.piece_map_use_accessor_time < 120000L) {
                return;
            }
        }
        this.piece_map_use_accessor = null;
    }

    @Override
    public byte[] getPieceHash(int piece_number) throws TOTorrentException {
        return this.torrent.getPieces()[piece_number];
    }

    @Override
    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return this.reader.createReadRequest(pieceNumber, offset, length);
    }

    @Override
    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        return this.checker.createCheckRequest(pieceNumber, user_data);
    }

    @Override
    public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
        return this.checker.hasOutstandingCheckRequestForPiece(piece_number);
    }

    @Override
    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCompleteRecheckRequest(request2, listener);
    }

    @Override
    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCheckRequest(request2, listener);
    }

    @Override
    public int getCompleteRecheckStatus() {
        return this.checker.getCompleteRecheckStatus();
    }

    @Override
    public int getMoveProgress() {
        if (this.move_in_progress) {
            return this.move_progress;
        }
        return -1;
    }

    @Override
    public void setPieceCheckingEnabled(boolean enabled) {
        this.checking_enabled = enabled;
        this.checker.setCheckingEnabled(enabled);
    }

    @Override
    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        return this.reader.readBlock(pieceNumber, offset, length);
    }

    @Override
    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
        return this.writer.createWriteRequest(pieceNumber, offset, data, user_data);
    }

    @Override
    public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
        this.writer.writeBlock(request2, listener);
    }

    @Override
    public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
        return this.writer.hasOutstandingWriteRequestForPiece(piece_number);
    }

    @Override
    public boolean checkBlockConsistencyForWrite(String originator, int pieceNumber, int offset, DirectByteBuffer data) {
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " pieceNumber=" + pieceNumber + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int length = this.pieceLength;
        if (pieceNumber == this.nbPieces - 1) {
            length = this.lastPieceLength;
        }
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " > length=" + length));
            }
            return false;
        }
        int size = data.remaining((byte)8);
        if (size <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " size=" + size + " <= 0"));
            }
            return false;
        }
        if (offset + size > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "Write invalid: " + originator + " offset=" + offset + " + size=" + size + " > length=" + length));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkBlockConsistencyForRead(String originator, boolean peer_request, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, originator, peer_request, pieceNumber, offset, length);
    }

    @Override
    public boolean checkBlockConsistencyForHint(String originator, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, originator, pieceNumber, offset, length);
    }

    @Override
    public void saveResumeData(boolean interim_save) throws Exception {
        this.resume_handler.saveResumeData(interim_save);
    }

    @Override
    public void downloadEnded(DiskManager.OperationStatus op_status) {
        this.moveDownloadFilesWhenEndedOrRemoved(false, true, op_status);
    }

    @Override
    public void downloadRemoved() {
        this.moveDownloadFilesWhenEndedOrRemoved(true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveDownloadFilesWhenEndedOrRemoved(boolean removing, boolean torrent_file_exists, final DiskManager.OperationStatus op_status) {
        try {
            SaveLocationChange move_details;
            boolean ending;
            this.start_stop_mon.enter();
            boolean bl = ending = !removing;
            if (ending) {
                if (this.alreadyMoved) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.alreadyMoved = true;
            }
            if (removing) {
                move_details = DownloadManagerMoveHandler.onRemoval(this.download_manager);
            } else {
                DownloadManagerMoveHandler.onCompletion(this.download_manager, new DownloadManagerMoveHandler.MoveCallback(){

                    @Override
                    public void perform(SaveLocationChange move_details) {
                        DiskManagerImpl.this.moveFiles(move_details, true, op_status);
                    }
                });
                move_details = null;
            }
            if (move_details != null) {
                this.moveFiles(move_details, true, op_status);
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.start_stop_mon.exit();
            if (!removing) {
                try {
                    this.saveResumeData(false);
                }
                catch (Throwable e) {
                    this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
    }

    @Override
    public void moveDataFiles(File new_parent_dir, String new_name, DiskManager.OperationStatus op_status) {
        SaveLocationChange loc_change = new SaveLocationChange();
        loc_change.download_location = new_parent_dir;
        loc_change.download_name = new_name;
        this.moveFiles(loc_change, false, op_status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveFiles(SaveLocationChange loc_change, boolean change_to_read_only, DiskManager.OperationStatus op_status) {
        boolean move_files = false;
        if (loc_change.hasDownloadChange()) {
            move_files = !this.isFileDestinationIsItself(loc_change);
        }
        try {
            this.start_stop_mon.enter();
            boolean files_moved = true;
            if (move_files) {
                try {
                    this.move_progress = 0;
                    this.move_in_progress = true;
                    files_moved = this.moveDataFiles0(loc_change, change_to_read_only, op_status);
                }
                finally {
                    this.move_in_progress = false;
                }
            }
            if (loc_change.hasTorrentChange() && files_moved) {
                this.moveTorrentFile(loc_change);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private void logMoveFileError(String destination_path, String message) {
        Logger.log(new LogEvent((Object)this, LOGID, 3, message));
        Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{destination_path, message});
    }

    private boolean isFileDestinationIsItself(SaveLocationChange loc_change) {
        File old_location = this.download_manager.getAbsoluteSaveLocation();
        File new_location = loc_change.normaliseDownloadLocation(old_location);
        try {
            old_location = old_location.getCanonicalFile();
            new_location = new_location.getCanonicalFile();
            if (old_location.equals(new_location)) {
                return true;
            }
            if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(new_location, old_location)) {
                String msg = "Target is sub-directory of files";
                this.logMoveFileError(new_location.toString(), msg);
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean moveDataFiles0(SaveLocationChange loc_change, boolean change_to_read_only, DiskManager.OperationStatus op_status) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void moveTorrentFile(SaveLocationChange loc_change) {
        if (!loc_change.hasTorrentChange()) {
            return;
        }
        File old_torrent_file = new File(this.download_manager.getTorrentFileName());
        File new_torrent_file = loc_change.normaliseTorrentLocation(old_torrent_file);
        if (!old_torrent_file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 1, "Torrent file '" + old_torrent_file.getPath() + "' has been deleted, move operation ignored"));
            }
            return;
        }
        try {
            this.download_manager.setTorrentFile(loc_change.torrent_location, loc_change.torrent_name);
        }
        catch (DownloadManagerException e) {
            String msg = "Failed to move " + old_torrent_file.toString() + " to " + new_torrent_file.toString();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
            }
            Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{old_torrent_file.toString(), new_torrent_file.toString()});
            Debug.out(msg);
        }
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public void addListener(DiskManagerListener l) {
        this.listeners.addListener(l);
        int[] params = new int[]{this.getState(), this.getState()};
        this.listeners.dispatch(l, 1, params);
    }

    @Override
    public void removeListener(DiskManagerListener l) {
        this.listeners.removeListener(l);
    }

    @Override
    public boolean hasListener(DiskManagerListener l) {
        return this.listeners.hasListener(l);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file, boolean force_no_recycle) {
        block8: {
            if (torrent == null || torrent_save_file == null) {
                return;
            }
            try {
                if (torrent.isSimpleTorrent()) {
                    File target = new File(torrent_save_dir, torrent_save_file);
                    target = FMFileManagerFactory.getSingleton().getFileLink(torrent, 0, target.getCanonicalFile());
                    FileUtil.deleteWithRecycle(target, force_no_recycle);
                    break block8;
                }
                PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
                if (Constants.isOSX && torrent_save_file.length() > 0 && COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && !force_no_recycle && mgr.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    try {
                        String dir = torrent_save_dir + File.separatorChar + torrent_save_file + File.separatorChar;
                        int numDataFiles = DiskManagerImpl.countDataFiles(torrent, torrent_save_dir, torrent_save_file);
                        if (DiskManagerImpl.countFiles(new File(dir), numDataFiles) == numDataFiles) {
                            mgr.performRecoverableFileDelete(dir);
                            break block8;
                        }
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file, force_no_recycle);
                    }
                    catch (PlatformManagerException ex) {
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file, force_no_recycle);
                    }
                    break block8;
                }
                DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file, force_no_recycle);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private static int countFiles(File f, int stopAfterCount) {
        if (f.isFile()) {
            return 1;
        }
        int res = 0;
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length && (res += DiskManagerImpl.countFiles(files[i], stopAfterCount)) <= stopAfterCount; ++i) {
            }
        }
        return res;
    }

    private static int countDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        try {
            int res = 0;
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] files = torrent.getFiles();
            for (int i = 0; i < files.length; ++i) {
                byte[][] path_comps = files[i].getPathComponents();
                String path_str = torrent_save_dir + File.separator + torrent_save_file + File.separator;
                for (int j = 0; j < path_comps.length; ++j) {
                    String comp2 = locale_decoder.decodeString(path_comps[j]);
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp2;
                }
                File file = new File(path_str).getCanonicalFile();
                File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, i, file);
                boolean skip = false;
                if (linked_file != file && !linked_file.getCanonicalPath().startsWith(new File(torrent_save_dir).getCanonicalPath())) {
                    skip = true;
                }
                if (skip || !file.exists() || file.isDirectory()) continue;
                ++res;
            }
            return res;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return -1;
        }
    }

    private static void deleteDataFileContents(TOTorrent torrent, String torrent_save_dir, String torrent_save_file, boolean force_no_recycle) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
        TOTorrentFile[] files = torrent.getFiles();
        String root_path = torrent_save_dir + File.separator + torrent_save_file + File.separator;
        boolean delete_if_not_in_dir = COConfigurationManager.getBooleanParameter("File.delete.include_files_outside_save_dir");
        for (int i = 0; i < files.length; ++i) {
            boolean delete;
            byte[][] path_comps = files[i].getPathComponents();
            String path_str = root_path;
            for (int j = 0; j < path_comps.length; ++j) {
                try {
                    String comp2 = locale_decoder.decodeString(path_comps[j]);
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp2;
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    Debug.out("file - unsupported encoding!!!!");
                }
            }
            File file = new File(path_str);
            File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, i, file);
            if (linked_file == file) {
                delete = true;
            } else {
                try {
                    if (delete_if_not_in_dir || linked_file.getCanonicalPath().startsWith(new File(root_path).getCanonicalPath())) {
                        file = linked_file;
                        delete = true;
                    } else {
                        delete = false;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    delete = false;
                }
            }
            if (!delete || !file.exists() || file.isDirectory()) continue;
            try {
                FileUtil.deleteWithRecycle(file, force_no_recycle);
                continue;
            }
            catch (Exception e) {
                Debug.out(e.toString());
            }
        }
        TorrentUtils.recursiveEmptyDirDelete(new File(torrent_save_dir, torrent_save_file));
    }

    @Override
    public void skippedFileSetChanged(DiskManagerFileInfo file) {
        this.skipped_file_set_changed = true;
        if (this.priority_change_marker.incrementAndGet() == 0L) {
            this.priority_change_marker.incrementAndGet();
        }
        this.listeners.dispatch(2, file);
    }

    @Override
    public void priorityChanged(DiskManagerFileInfo file) {
        if (this.priority_change_marker.incrementAndGet() == 0L) {
            this.priority_change_marker.incrementAndGet();
        }
        this.listeners.dispatch(2, file);
    }

    private void loadFilePriorities() {
        DiskManagerUtil.loadFilePriorities(this.download_manager, this.fileset);
    }

    protected void storeFilePriorities() {
        DiskManagerImpl.storeFilePriorities(this.download_manager, this.files);
    }

    protected static void storeFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        DiskManagerUtil.storeFilePriorities(download_manager, files);
    }

    protected static void storeFileDownloaded(DownloadManager download_manager, DiskManagerFileInfo[] files, boolean persist) {
        DownloadManagerState state = download_manager.getDownloadState();
        HashMap details = new HashMap();
        ArrayList<Long> downloaded = new ArrayList<Long>();
        details.put("downloaded", downloaded);
        for (int i = 0; i < files.length; ++i) {
            downloaded.add(new Long(files[i].getDownloaded()));
        }
        state.setMapAttribute("filedownloaded", details);
        if (persist) {
            state.save();
        }
    }

    @Override
    public void saveState() {
        this.saveState(true);
    }

    protected void saveState(boolean persist) {
        if (this.files != null) {
            DiskManagerImpl.storeFileDownloaded(this.download_manager, this.files, persist);
            this.storeFilePriorities();
        }
        this.checkFreePieceList(false);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    @Override
    public String getInternalName() {
        return this.download_manager.getInternalName();
    }

    @Override
    public DownloadManagerState getDownloadState() {
        return this.download_manager.getDownloadState();
    }

    @Override
    public File getSaveLocation() {
        return this.download_manager.getSaveLocation();
    }

    @Override
    public String[] getStorageTypes() {
        return DiskManagerImpl.getStorageTypes(this.download_manager);
    }

    @Override
    public String getStorageType(int fileIndex) {
        return DiskManagerImpl.getStorageType(this.download_manager, fileIndex);
    }

    public static String[] getStorageTypes(DownloadManager download_manager) {
        DownloadManagerState state = download_manager.getDownloadState();
        String[] types = state.getListAttribute("storetypes");
        if (types == null || types.length == 0) {
            TOTorrentFile[] files = download_manager.getTorrent().getFiles();
            types = new String[download_manager.getTorrent().getFiles().length];
            if (reorder_storage_mode) {
                int existing = state.getIntAttribute("reordermb");
                if (existing < 0) {
                    existing = reorder_storage_mode_min_mb;
                    state.setIntAttribute("reordermb", existing);
                }
                for (int i = 0; i < types.length; ++i) {
                    types[i] = files[i].getLength() / 0x100000L >= (long)existing ? "R" : "L";
                }
            } else {
                for (int i = 0; i < types.length; ++i) {
                    types[i] = "L";
                }
            }
            state.setListAttribute("storetypes", types);
        }
        return types;
    }

    public static String getStorageType(DownloadManager download_manager, int fileIndex) {
        DownloadManagerState state = download_manager.getDownloadState();
        String type = state.getListAttribute("storetypes", fileIndex);
        if (type != null) {
            return type;
        }
        return DiskManagerImpl.getStorageTypes(download_manager)[fileIndex];
    }

    public static void setFileLinks(DownloadManager download_manager, LinkFileMap links) {
        try {
            CacheFileManagerFactory.getSingleton().setFileLinks(download_manager.getTorrent(), links);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public String getRelationText() {
        return "TorrentDM: '" + this.download_manager.getDisplayName() + "'";
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager, this.torrent};
    }

    @Override
    public DiskManagerRecheckScheduler getRecheckScheduler() {
        return recheck_scheduler;
    }

    @Override
    public boolean isInteresting(int pieceNumber) {
        return this.pieces[pieceNumber].isInteresting();
    }

    @Override
    public boolean isDone(int pieceNumber) {
        return this.pieces[pieceNumber].isDone();
    }

    @Override
    public long getPriorityChangeMarker() {
        return this.priority_change_marker.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("Disk Manager");
        try {
            writer.indent();
            writer.println("percent_done=" + this.percentDone + ",allocated=" + this.allocated + ",remaining=" + this.remaining);
            writer.println("skipped_file_set_size=" + this.skipped_file_set_size + ",skipped_but_downloaded=" + this.skipped_but_downloaded);
            writer.println("already_moved=" + this.alreadyMoved);
        }
        finally {
            writer.exdent();
        }
    }

    static {
        int max_read_threads = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxthreads");
        int max_read_mb = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxmb");
        int max_write_threads = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxthreads");
        int max_write_mb = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxmb");
        disk_access_controller = DiskAccessControllerFactory.create("core", max_read_threads, max_read_mb, max_write_threads, max_write_mb);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Disk access controller params: " + max_read_threads + "/" + max_read_mb + "/" + max_write_threads + "/" + max_write_mb));
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable reorder storage mode", "Reorder storage mode min MB"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                reorder_storage_mode = COConfigurationManager.getBooleanParameter("Enable reorder storage mode");
                reorder_storage_mode_min_mb = COConfigurationManager.getIntParameter("Reorder storage mode min MB");
            }
        });
        recheck_scheduler = new DiskManagerRecheckScheduler();
        allocation_scheduler = new DiskManagerAllocationScheduler();
        start_pool = new ThreadPool("DiskManager:start", 64, true);
        start_pool.setThreadPriority(1);
        listeners_aggregator = ListenerManager.createAsyncManager("DiskM:ListenAggregatorDispatcher", new ListenerManagerDispatcher<DiskManagerListener>(){

            @Override
            public void dispatch(DiskManagerListener listener, int type, Object value) {
                if (type == 1) {
                    int[] params = (int[])value;
                    listener.stateChanged(params[0], params[1]);
                } else if (type == 2) {
                    listener.filePriorityChanged((DiskManagerFileInfo)value);
                } else if (type == 3) {
                    listener.pieceDoneChanged((DiskManagerPiece)value);
                } else if (type == 4) {
                    Object[] o = (Object[])value;
                    listener.fileAccessModeChanged((DiskManagerFileInfo)o[0], (Integer)o[1], (Integer)o[2]);
                }
            }
        });
    }
}

