/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.util.Arrays;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.Debug;

public class DiskManagerFileInfoSetImpl
implements DiskManagerFileInfoSet {
    final DiskManagerFileInfoImpl[] files;
    final DiskManagerHelper diskManager;

    public DiskManagerFileInfoSetImpl(DiskManagerFileInfoImpl[] files, DiskManagerHelper dm) {
        this.files = files;
        this.diskManager = dm;
    }

    @Override
    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    @Override
    public int nbFiles() {
        return this.files.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPriority(int[] toChange) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState dmState = this.diskManager.getDownloadState();
        try {
            dmState.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                if (toChange[i] == 0) continue;
                this.files[i].setPriority(toChange[i]);
            }
        }
        finally {
            dmState.suppressStateSave(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSkipped(boolean[] toChange, boolean setSkipped) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState dmState = this.diskManager.getDownloadState();
        try {
            dmState.suppressStateSave(true);
            if (!setSkipped) {
                String[] types = this.diskManager.getStorageTypes();
                boolean[] toLinear = new boolean[toChange.length];
                boolean[] toReorder = new boolean[toChange.length];
                int num_linear = 0;
                int num_reorder = 0;
                for (int i = 0; i < toChange.length; ++i) {
                    if (!toChange[i]) continue;
                    int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                    if (old_type == 2) {
                        toLinear[i] = true;
                        ++num_linear;
                        continue;
                    }
                    if (old_type != 4) continue;
                    toReorder[i] = true;
                    ++num_reorder;
                }
                if (num_linear > 0 && !Arrays.equals(toLinear, this.setStorageTypes(toLinear, 1))) {
                    return;
                }
                if (num_reorder > 0 && !Arrays.equals(toReorder, this.setStorageTypes(toReorder, 3))) {
                    return;
                }
            }
            for (int i = 0; i < this.files.length; ++i) {
                if (!toChange[i]) continue;
                this.files[i].setSkippedInternal(setSkipped);
                this.diskManager.skippedFileSetChanged(this.files[i]);
            }
            if (!setSkipped) {
                DiskManagerUtil.doFileExistenceChecks(this, toChange, this.diskManager.getDownloadState().getDownloadManager(), true);
            }
        }
        finally {
            dmState.suppressStateSave(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] setStorageTypes(boolean[] toChange, int newStroageType) {
        if (toChange.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        if (this.files.length == 0) {
            return new boolean[0];
        }
        String[] types = this.diskManager.getStorageTypes();
        boolean[] modified = new boolean[this.files.length];
        DownloadManagerState dm_state = this.diskManager.getDownloadState();
        if (newStroageType == 2 || newStroageType == 4) {
            Debug.out("Download must be stopped for linear -> compact conversion");
            return modified;
        }
        try {
            dm_state.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                if (!toChange[i]) continue;
                int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                if (newStroageType == old_type) {
                    modified[i] = true;
                    continue;
                }
                DiskManagerFileInfoImpl file = this.files[i];
                try {
                    file.getCacheFile().setStorageType(DiskManagerUtil.convertDMStorageTypeToCache(newStroageType));
                    modified[i] = true;
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    this.diskManager.setFailed(file, "Failed to change storage type for '" + file.getFile(true) + "': " + Debug.getNestedExceptionMessage(e));
                    break;
                }
                finally {
                    types[i] = DiskManagerUtil.convertCacheStorageTypeToString(file.getCacheFile().getStorageType());
                }
            }
            dm_state.setListAttribute("storetypes", types);
            DiskManagerUtil.doFileExistenceChecks(this, toChange, dm_state.getDownloadManager(), true);
        }
        finally {
            dm_state.suppressStateSave(false);
            dm_state.save();
        }
        return modified;
    }
}

