/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.io.File;
import java.io.IOException;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.StringInterner;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo,
CacheFileOwner {
    private String root_dir;
    private final File relative_file;
    final int file_index;
    private CacheFile cache_file;
    private String extension;
    private long downloaded;
    final DiskManagerHelper diskManager;
    final TOTorrentFile torrent_file;
    private int priority = 0;
    protected boolean skipped_internal = false;
    private volatile CopyOnWriteList<DiskManagerFileInfoListener> listeners;
    private volatile AverageFactory.LazyMovingImmediateAverageState read_average_state;
    private volatile AverageFactory.LazyMovingImmediateAverageState write_average_state;
    private volatile AverageFactory.LazyMovingImmediateAverageState eta_average_state;
    private static final AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl> read_adapter = new AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl>(){

        @Override
        public AverageFactory.LazyMovingImmediateAverageState getCurrent(DiskManagerFileInfoImpl instance) {
            return instance.read_average_state;
        }

        @Override
        public void setCurrent(DiskManagerFileInfoImpl instance, AverageFactory.LazyMovingImmediateAverageState average) {
            instance.read_average_state = average;
        }

        @Override
        public long getValue(DiskManagerFileInfoImpl instance) {
            return instance.cache_file.getSessionBytesRead();
        }
    };
    private static final AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl> write_adapter = new AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl>(){

        @Override
        public AverageFactory.LazyMovingImmediateAverageState getCurrent(DiskManagerFileInfoImpl instance) {
            return instance.write_average_state;
        }

        @Override
        public void setCurrent(DiskManagerFileInfoImpl instance, AverageFactory.LazyMovingImmediateAverageState average) {
            instance.write_average_state = average;
        }

        @Override
        public long getValue(DiskManagerFileInfoImpl instance) {
            return instance.cache_file.getSessionBytesWritten();
        }
    };
    private static final AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl> eta_adapter = new AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl>(){

        @Override
        public AverageFactory.LazyMovingImmediateAverageState getCurrent(DiskManagerFileInfoImpl instance) {
            return instance.eta_average_state;
        }

        @Override
        public void setCurrent(DiskManagerFileInfoImpl instance, AverageFactory.LazyMovingImmediateAverageState average) {
            instance.eta_average_state = average;
        }

        @Override
        public long getValue(DiskManagerFileInfoImpl instance) {
            return instance.cache_file.getSessionBytesWritten();
        }
    };

    public DiskManagerFileInfoImpl(DiskManagerHelper _disk_manager, String _root_dir, File _relative_file, int _file_index, TOTorrentFile _torrent_file, int _storage_type) throws CacheFileManagerException {
        this.diskManager = _disk_manager;
        this.torrent_file = _torrent_file;
        this.root_dir = _root_dir.endsWith(File.separator) ? _root_dir : _root_dir + File.separator;
        this.relative_file = _relative_file;
        this.file_index = _file_index;
        int cache_st = DiskManagerUtil.convertDMStorageTypeToCache(_storage_type);
        this.cache_file = CacheFileManagerFactory.getSingleton().createFile(this, new File(this.root_dir + this.relative_file.toString()), cache_st);
        if (cache_st == 2 || cache_st == 4) {
            this.skipped_internal = true;
        }
    }

    @Override
    public String getCacheFileOwnerName() {
        return this.diskManager.getInternalName();
    }

    @Override
    public TOTorrentFile getCacheFileTorrentFile() {
        return this.torrent_file;
    }

    @Override
    public File getCacheFileControlFileDir() {
        return this.diskManager.getDownloadState().getStateFile();
    }

    @Override
    public int getCacheMode() {
        return this.diskManager.getCacheMode();
    }

    @Override
    public void flushCache() throws Exception {
        this.cache_file.flushCache();
    }

    public void moveFile(String new_root_dir, File new_absolute_file, boolean link_only) throws CacheFileManagerException {
        if (!link_only) {
            this.cache_file.moveFile(new_absolute_file);
        }
        this.root_dir = new_root_dir.endsWith(File.separator) ? new_root_dir : new_root_dir + File.separator;
    }

    public void renameFile(String new_name) throws CacheFileManagerException {
        this.cache_file.renameFile(new_name);
    }

    public CacheFile getCacheFile() {
        return this.cache_file;
    }

    public void setAccessMode(int mode) throws CacheFileManagerException {
        int old_mode = this.cache_file.getAccessMode();
        this.cache_file.setAccessMode(mode == 1 ? 1 : 2);
        if (old_mode != mode) {
            this.diskManager.accessModeChanged(this, old_mode, mode);
        }
    }

    @Override
    public int getAccessMode() {
        int mode = this.cache_file.getAccessMode();
        return mode == 1 ? 1 : 2;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public File getFile(boolean follow_link) {
        File res;
        if (follow_link && (res = this.getLink()) != null) {
            return res;
        }
        return new File(this.root_dir + this.relative_file.toString());
    }

    @Override
    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    @Override
    public boolean setLink(File link_destination) {
        Debug.out("setLink: download must be stopped");
        return false;
    }

    @Override
    public boolean setLinkAtomic(File link_destination) {
        Debug.out("setLink: download must be stopped");
        return false;
    }

    @Override
    public File getLink() {
        return this.diskManager.getDownloadState().getFileLink(this.file_index, this.getFile(false));
    }

    @Override
    public boolean setStorageType(int type) {
        DiskManagerFileInfoSet set = this.diskManager.getFileSet();
        boolean[] toSet = new boolean[set.nbFiles()];
        toSet[this.file_index] = true;
        return set.setStorageTypes(toSet, type)[this.file_index];
    }

    @Override
    public int getStorageType() {
        return DiskManagerUtil.convertDMStorageTypeFromString(this.diskManager.getStorageType(this.file_index));
    }

    protected boolean isLinked() {
        return this.getLink() != null;
    }

    @Override
    public int getFirstPieceNumber() {
        return this.torrent_file.getFirstPieceNumber();
    }

    @Override
    public int getLastPieceNumber() {
        return this.torrent_file.getLastPieceNumber();
    }

    @Override
    public long getLength() {
        return this.torrent_file.getLength();
    }

    @Override
    public int getIndex() {
        return this.file_index;
    }

    @Override
    public int getNbPieces() {
        return this.torrent_file.getNumberOfPieces();
    }

    public void setDownloaded(long l) {
        this.downloaded = l;
    }

    public void setExtension(String string) {
        this.extension = StringInterner.intern(string);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int b) {
        this.priority = b;
        this.diskManager.priorityChanged(this);
    }

    @Override
    public boolean isSkipped() {
        return this.skipped_internal;
    }

    @Override
    public void setSkipped(boolean _skipped) {
        int existing_st = this.getStorageType();
        if (!_skipped && existing_st == 2 && !this.setStorageType(1)) {
            return;
        }
        if (!_skipped && existing_st == 4 && !this.setStorageType(3)) {
            return;
        }
        this.setSkippedInternal(_skipped);
        this.diskManager.skippedFileSetChanged(this);
        if (!_skipped) {
            boolean[] toCheck = new boolean[this.diskManager.getFileSet().nbFiles()];
            toCheck[this.file_index] = true;
            DiskManagerUtil.doFileExistenceChecks(this.diskManager.getFileSet(), toCheck, this.diskManager.getDownloadState().getDownloadManager(), true);
        }
    }

    protected void setSkippedInternal(boolean _skipped) {
        DownloadManagerState dm_state;
        String dnd_sf;
        this.skipped_internal = _skipped;
        DownloadManager dm = this.getDownloadManager();
        if (dm != null && !dm.isDestroyed() && (dnd_sf = (dm_state = this.diskManager.getDownloadState()).getAttribute("dnd_sf")) != null) {
            File new_parent;
            File new_file;
            File parent;
            File link = this.getLink();
            File file = this.getFile(false);
            if (_skipped) {
                File parent2;
                if ((link == null || link.equals(file)) && (parent2 = file.getParentFile()) != null) {
                    File new_file2;
                    File new_parent2 = new File(parent2, dnd_sf);
                    String prefix = dm_state.getAttribute("dnd_pfx");
                    String file_name = file.getName();
                    if (prefix != null && !file_name.startsWith(prefix)) {
                        file_name = prefix + file_name;
                    }
                    if (!(new_file2 = new File(new_parent2, file_name)).exists()) {
                        if (!new_parent2.exists()) {
                            new_parent2.mkdirs();
                        }
                        if (new_parent2.canWrite()) {
                            boolean ok;
                            try {
                                dm_state.setFileLink(this.file_index, file, new_file2);
                                this.cache_file.moveFile(new_file2);
                                ok = true;
                            }
                            catch (Throwable e) {
                                ok = false;
                                Debug.out(e);
                            }
                            if (!ok) {
                                dm_state.setFileLink(this.file_index, file, link);
                            }
                        }
                    }
                }
            } else if (link != null && !file.exists() && (parent = file.getParentFile()) != null && parent.canWrite() && (new_file = new File(new_parent = parent.getName().equals(dnd_sf) ? parent : new File(parent, dnd_sf), link.getName())).equals(link)) {
                boolean ok;
                try {
                    File new_link;
                    String incomp_ext;
                    String file_name = file.getName();
                    String prefix = dm_state.getAttribute("dnd_pfx");
                    boolean prefix_removed = false;
                    if (prefix != null && file_name.startsWith(prefix)) {
                        file_name = file_name.substring(prefix.length());
                        prefix_removed = true;
                    }
                    if ((incomp_ext = dm_state.getAttribute("incompfilesuffix")) != null && incomp_ext.length() > 0 && this.getDownloaded() != this.getLength()) {
                        if (prefix == null) {
                            prefix = "";
                        }
                        new_link = new File(file.getParentFile(), prefix + file_name + incomp_ext);
                        dm_state.setFileLink(this.file_index, file, new_link);
                        this.cache_file.moveFile(new_link);
                    } else if (prefix_removed) {
                        new_link = new File(file.getParentFile(), file_name);
                        dm_state.setFileLink(this.file_index, file, new_link);
                        this.cache_file.moveFile(new_link);
                    } else {
                        dm_state.setFileLink(this.file_index, file, null);
                        this.cache_file.moveFile(file);
                    }
                    File[] files = new_parent.listFiles();
                    if (files != null && files.length == 0) {
                        new_parent.delete();
                    }
                    ok = true;
                }
                catch (Throwable e) {
                    ok = false;
                    Debug.out(e);
                }
                if (!ok) {
                    dm_state.setFileLink(this.file_index, file, link);
                }
            }
        }
    }

    @Override
    public DiskManager getDiskManager() {
        return this.diskManager;
    }

    @Override
    public DownloadManager getDownloadManager() {
        DownloadManagerState state = this.diskManager.getDownloadState();
        if (state == null) {
            return null;
        }
        return state.getDownloadManager();
    }

    public void dataWritten(long offset, long size) {
        CopyOnWriteList<DiskManagerFileInfoListener> l_ref = this.listeners;
        if (l_ref != null) {
            for (DiskManagerFileInfoListener listener : l_ref) {
                try {
                    listener.dataWritten(offset, size);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void dataChecked(long offset, long size) {
        CopyOnWriteList<DiskManagerFileInfoListener> l_ref = this.listeners;
        if (l_ref != null) {
            for (DiskManagerFileInfoListener listener : l_ref) {
                try {
                    listener.dataChecked(offset, size);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public DirectByteBuffer read(long offset, int length) throws IOException {
        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)6, length);
        try {
            this.cache_file.read(buffer, offset, (short)1);
        }
        catch (Throwable e) {
            buffer.returnToPool();
            Debug.printStackTrace(e);
            throw new IOException(e.getMessage());
        }
        return buffer;
    }

    @Override
    public int getReadBytesPerSecond() {
        return (int)AverageFactory.LazyMovingImmediateAverage(10, 1, read_adapter, this);
    }

    @Override
    public int getWriteBytesPerSecond() {
        return (int)AverageFactory.LazyMovingImmediateAverage(10, 1, write_adapter, this);
    }

    @Override
    public long getETA() {
        if (this.isSkipped()) {
            return -1L;
        }
        long rem = this.getLength() - this.getDownloaded();
        if (rem == 0L) {
            return -1L;
        }
        long speed = AverageFactory.LazySmoothMovingImmediateAverage(eta_adapter, this);
        if (speed == 0L) {
            return 1827387392L;
        }
        long eta = rem / speed;
        if (eta == 0L) {
            return 1L;
        }
        return eta;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(final DiskManagerFileInfoListener listener) {
        DiskManagerFileInfoImpl diskManagerFileInfoImpl = this;
        synchronized (diskManagerFileInfoImpl) {
            if (this.listeners == null) {
                this.listeners = new CopyOnWriteList();
            }
        }
        if (!this.listeners.addIfNotPresent(listener)) {
            return;
        }
        new Runnable(){
            private long file_start;
            private long file_end;
            private long current_write_start = -1L;
            private long current_write_end = -1L;
            private long current_check_start = -1L;
            private long current_check_end = -1L;

            @Override
            public void run() {
                TOTorrentFile[] tfs = DiskManagerFileInfoImpl.this.torrent_file.getTorrent().getFiles();
                long torrent_offset = 0L;
                for (int i = 0; i < DiskManagerFileInfoImpl.this.file_index; ++i) {
                    torrent_offset += tfs[i].getLength();
                }
                this.file_start = torrent_offset;
                this.file_end = this.file_start + DiskManagerFileInfoImpl.this.torrent_file.getLength();
                DiskManagerPiece[] pieces = DiskManagerFileInfoImpl.this.diskManager.getPieces();
                int first_piece = DiskManagerFileInfoImpl.this.getFirstPieceNumber();
                int last_piece = DiskManagerFileInfoImpl.this.getLastPieceNumber();
                long piece_size = DiskManagerFileInfoImpl.this.torrent_file.getTorrent().getPieceLength();
                for (int i = first_piece; i <= last_piece; ++i) {
                    long piece_offset = piece_size * (long)i;
                    DiskManagerPiece piece = pieces[i];
                    if (piece.isDone()) {
                        long bit_start = piece_offset;
                        long bit_end = bit_start + (long)piece.getLength();
                        this.bitWritten(bit_start, bit_end, true);
                        continue;
                    }
                    int block_offset = 0;
                    for (int j = 0; j < piece.getNbBlocks(); ++j) {
                        int block_size = piece.getBlockSize(j);
                        if (piece.isWritten(j)) {
                            long bit_start = piece_offset + (long)block_offset;
                            long bit_end = bit_start + (long)block_size;
                            this.bitWritten(bit_start, bit_end, false);
                        }
                        block_offset += block_size;
                    }
                }
                this.bitWritten(-1L, -1L, false);
            }

            protected void bitWritten(long bit_start, long bit_end, boolean checked) {
                if (this.current_write_start == -1L) {
                    this.current_write_start = bit_start;
                    this.current_write_end = bit_end;
                } else if (this.current_write_end == bit_start) {
                    this.current_write_end = bit_end;
                } else {
                    if (this.current_write_start < this.file_start) {
                        this.current_write_start = this.file_start;
                    }
                    if (this.current_write_end > this.file_end) {
                        this.current_write_end = this.file_end;
                    }
                    if (this.current_write_start < this.current_write_end) {
                        try {
                            listener.dataWritten(this.current_write_start - this.file_start, this.current_write_end - this.current_write_start);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    this.current_write_start = bit_start;
                    this.current_write_end = bit_end;
                }
                if (checked && this.current_check_start == -1L) {
                    this.current_check_start = bit_start;
                    this.current_check_end = bit_end;
                } else if (checked && this.current_check_end == bit_start) {
                    this.current_check_end = bit_end;
                } else {
                    if (this.current_check_start < this.file_start) {
                        this.current_check_start = this.file_start;
                    }
                    if (this.current_check_end > this.file_end) {
                        this.current_check_end = this.file_end;
                    }
                    if (this.current_check_start < this.current_check_end) {
                        try {
                            listener.dataChecked(this.current_check_start - this.file_start, this.current_check_end - this.current_check_start);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (checked) {
                        this.current_check_start = bit_start;
                        this.current_check_end = bit_end;
                    } else {
                        this.current_check_start = -1L;
                        this.current_check_end = -1L;
                    }
                }
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DiskManagerFileInfoListener listener) {
        DiskManagerFileInfoImpl diskManagerFileInfoImpl = this;
        synchronized (diskManagerFileInfoImpl) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }
}

