/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReplyDecoder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public abstract class PRUDPPacketReply
extends PRUDPPacket {
    public static final int PR_HEADER_SIZE = 8;
    private static AEMonitor class_mon = new AEMonitor("PRUDPPacketReply:class");
    private static Map packet_decoders = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDecoders(Map _decoders) {
        try {
            class_mon.enter();
            HashMap new_decoders = new HashMap(packet_decoders);
            for (Integer action : _decoders.keySet()) {
                if (!packet_decoders.containsKey(action)) continue;
                Debug.out("Duplicate codec! " + action);
            }
            new_decoders.putAll(_decoders);
            packet_decoders = new_decoders;
        }
        finally {
            class_mon.exit();
        }
    }

    public PRUDPPacketReply(int _action, int _tran_id) {
        super(_action, _tran_id);
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        os.writeInt(this.getAction());
        os.writeInt(this.getTransactionId());
    }

    public static PRUDPPacketReply deserialiseReply(PRUDPPacketHandler handler, InetSocketAddress originator, DataInputStream is) throws IOException {
        int action = is.readInt();
        PRUDPPacketReplyDecoder decoder = (PRUDPPacketReplyDecoder)packet_decoders.get(new Integer(action));
        if (decoder == null) {
            throw new IOException("No decoder registered for action '" + action + "'");
        }
        int transaction_id = is.readInt();
        return decoder.decode(handler, originator, is, action, transaction_id);
    }

    @Override
    public String getString() {
        return super.getString() + ":reply[trans=" + this.getTransactionId() + "]";
    }
}

