/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class FeatureUtils {
    private static FeatureManager featman;

    public static String getPlusMode() {
        boolean isTrial;
        boolean isFull = FeatureUtils.hasPlusLicence();
        boolean bl = isTrial = FeatureUtils.hasFullBurn() && !isFull;
        return isFull ? "plus" : (isTrial ? "trial" : "free");
    }

    public static String getNoAdsMode() {
        boolean isNoAds = FeatureUtils.hasNoAdLicence();
        return isNoAds ? "no_ads" : "free";
    }

    public static boolean hasPlusLicence() {
        if (featman == null) {
            Set<String> featuresInstalled = UtilitiesImpl.getFeaturesInstalled();
            return featuresInstalled.contains("dvdburn");
        }
        licenceDetails fullFeatureDetails = FeatureUtils.getPlusFeatureDetails();
        long now = SystemTime.getCurrentTime();
        return fullFeatureDetails != null && fullFeatureDetails.expiry > now && fullFeatureDetails.displayedExpiry > now;
    }

    public static boolean hasFullLicence() {
        return FeatureUtils.hasPlusLicence();
    }

    public static boolean hasTrialLicence() {
        boolean isFull = FeatureUtils.hasPlusLicence();
        boolean isTrial = FeatureUtils.hasFullBurn() && !isFull;
        return isTrial;
    }

    public static boolean hasNoAdLicence() {
        if (featman == null) {
            Set<String> featuresInstalled = UtilitiesImpl.getFeaturesInstalled();
            return featuresInstalled.contains("no_ads");
        }
        licenceDetails details = FeatureUtils.getNoAdFeatureDetails();
        long now = SystemTime.getCurrentTime();
        return details != null && details.expiry > now && details.displayedExpiry > now;
    }

    public static licenceDetails getPlusFeatureDetails() {
        return FeatureUtils.getFeatureDetails("dvdburn");
    }

    private static licenceDetails getNoAdFeatureDetails() {
        return FeatureUtils.getFeatureDetails("no_ads");
    }

    public static licenceDetails getPlusOrNoAdFeatureDetails() {
        licenceDetails plusDetails = FeatureUtils.getPlusFeatureDetails();
        long now = System.currentTimeMillis();
        if (plusDetails != null && plusDetails.licence.getState() == 2 && plusDetails.expiry >= now) {
            return plusDetails;
        }
        licenceDetails noAdDetails = FeatureUtils.getNoAdFeatureDetails();
        if (noAdDetails == null) {
            return plusDetails;
        }
        if (plusDetails == null) {
            return noAdDetails;
        }
        if (noAdDetails.licence.getState() == 2 && noAdDetails.expiry >= now) {
            return noAdDetails;
        }
        return plusDetails;
    }

    private static licenceDetails getFeatureDetails(String feature) {
        FeatureManager.FeatureDetails[] featureDetails;
        if (featman == null) {
            Debug.out("featman null");
            return null;
        }
        TreeMap mapOrder = new TreeMap(Collections.reverseOrder());
        for (FeatureManager.FeatureDetails fd : featureDetails = featman.getFeatureDetails(feature)) {
            FeatureManager.Licence licence = fd.getLicence();
            int state = licence.getState();
            if (state == 6) {
                mapOrder.put(-1L, new Object[]{licence, 0L});
                continue;
            }
            if (state == 4) {
                mapOrder.put(-2L, new Object[]{licence, 0L});
                continue;
            }
            if (state == 3) {
                mapOrder.put(-3L, new Object[]{licence, 0L});
                continue;
            }
            if (state == 5) {
                mapOrder.put(-4L, new Object[]{licence, 0L});
                continue;
            }
            if (state == 1) {
                mapOrder.put(-6L, new Object[]{licence, 0L});
                continue;
            }
            long now = SystemTime.getCurrentTime();
            Long lValidUntil = (Long)fd.getProperty("ValidUntil");
            Long lValidOfflineUntil = (Long)fd.getProperty("OfflineValidUntil");
            if (lValidUntil == null && lValidOfflineUntil == null) continue;
            long minValidUntil = -1L;
            long maxValidUntil = -1L;
            if (lValidUntil != null && (minValidUntil = (maxValidUntil = lValidUntil.longValue())) < now) {
                mapOrder.put(minValidUntil, new Object[]{licence, minValidUntil});
                continue;
            }
            if (lValidOfflineUntil != null) {
                long validOfflineUntil = lValidOfflineUntil;
                if (validOfflineUntil < now) {
                    mapOrder.put(validOfflineUntil, new Object[]{licence, maxValidUntil});
                    continue;
                }
                if (maxValidUntil == -1L || validOfflineUntil > maxValidUntil) {
                    maxValidUntil = validOfflineUntil;
                }
            }
            mapOrder.put(maxValidUntil, new Object[]{licence, minValidUntil});
        }
        if (mapOrder.size() == 0) {
            return null;
        }
        Long firstKey = (Long)mapOrder.firstKey();
        Object[] objects = (Object[])mapOrder.get(firstKey);
        FeatureManager.Licence licence = (FeatureManager.Licence)objects[0];
        return new licenceDetails(firstKey, (Long)objects[1], licence, feature);
    }

    public static boolean isTrialLicence(FeatureManager.Licence licence) {
        FeatureManager.FeatureDetails fd;
        FeatureManager.FeatureDetails[] featureDetails;
        if (featman == null) {
            return false;
        }
        boolean trial = false;
        FeatureManager.FeatureDetails[] arr$ = featureDetails = licence.getFeatures();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(trial = FeatureUtils.isTrial(fd = arr$[i$])); ++i$) {
        }
        return trial;
    }

    public static boolean isTrial(FeatureManager.FeatureDetails fd) {
        Long lIsTrial = (Long)fd.getProperty("IsTrial");
        return lIsTrial == null ? false : lIsTrial != 0L;
    }

    public static long getRemaining() {
        FeatureManager.FeatureDetails[] featureDetails = featman.getFeatureDetails("dvdburn_trial");
        if (featureDetails == null) {
            return 0L;
        }
        for (FeatureManager.FeatureDetails fd : featureDetails) {
            long remainingUses = FeatureUtils.getRemainingUses(fd);
            if (remainingUses < 0L) continue;
            return remainingUses;
        }
        return 0L;
    }

    private static long getRemainingUses(FeatureManager.FeatureDetails fd) {
        if (fd == null) {
            return 0L;
        }
        Long lRemainingUses = (Long)fd.getProperty("TrialUsesRemaining");
        long remainingUses = lRemainingUses == null ? -1L : lRemainingUses;
        return remainingUses;
    }

    public static boolean hasFullBurn() {
        PluginInterface pi;
        PluginInterface pluginInterface = pi = PluginInitializer.getDefaultInterface().getPluginState().isInitialisationComplete() ? AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azburn_v") : null;
        if (pi == null) {
            Set<String> featuresInstalled = UtilitiesImpl.getFeaturesInstalled();
            return featuresInstalled.contains("dvdburn_trial") && !featuresInstalled.contains("dvdburn");
        }
        return pi.getPluginState().isOperational();
    }

    static {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                PluginInterface pi = core.getPluginManager().getDefaultPluginInterface();
                featman = pi.getUtilities().getFeatureManager();
            }
        });
    }

    public static class licenceDetails {
        private final FeatureManager.Licence licence;
        private final long expiry;
        private final long displayedExpiry;
        private final String feature;

        public licenceDetails(long expiry, long displayedExpiry, FeatureManager.Licence licence, String feature) {
            this.expiry = expiry;
            this.displayedExpiry = displayedExpiry;
            this.licence = licence;
            this.feature = feature;
        }

        public FeatureManager.Licence getLicence() {
            return this.licence;
        }

        public String getRenewalKey() {
            FeatureManager.FeatureDetails[] features = this.licence.getFeatures();
            if (features == null) {
                return null;
            }
            for (FeatureManager.FeatureDetails fd : features) {
                Object property = fd.getProperty("RenewalKey");
                if (!(property instanceof String)) continue;
                return (String)property;
            }
            return null;
        }

        public boolean isPlus() {
            return this.feature.equals("dvdburn");
        }

        public boolean isNoAds() {
            return !this.isPlus();
        }

        public long getExpiryTimeStamp() {
            return this.expiry;
        }

        public long getExpiryDisplayTimeStamp() {
            if (this.expiry == 0L) {
                return 0L;
            }
            return this.displayedExpiry;
        }

        public String getRenewalCode() {
            if (this.expiry == 0L) {
                return null;
            }
            return this.getRenewalKey();
        }
    }
}

