/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class DownloadUtils {
    private static TorrentAttribute ta_tracker_extensions;

    public static synchronized void initialise() {
        if (ta_tracker_extensions == null) {
            TorrentManager tm = PluginInitializer.getDefaultInterface().getTorrentManager();
            ta_tracker_extensions = tm.getAttribute("TrackerClientExtensions");
        }
    }

    public static synchronized void addTrackerExtension(Download download, String extension_prefix, String extension_value) {
        String extension = "&" + extension_prefix + "=" + extension_value;
        String value = download.getAttribute(ta_tracker_extensions);
        if (value != null) {
            if (value.contains(extension)) {
                return;
            }
            if (value.contains(extension_prefix)) {
                String[] bits = value.split("&");
                value = "";
                for (int i = 0; i < bits.length; ++i) {
                    String bit = bits[i].trim();
                    if (bit.length() == 0 || bit.startsWith(extension_prefix + "=")) continue;
                    value = value + "&" + bit;
                }
            }
            value = value + extension;
        } else {
            value = extension;
        }
        download.setAttribute(ta_tracker_extensions, value);
    }

    public static synchronized String getTrackerExtensions(Download download) {
        return download.getAttribute(ta_tracker_extensions);
    }

    public static synchronized void removeTrackerExtension(Download download, String extension_prefix) {
        String value = download.getAttribute(ta_tracker_extensions);
        if (value != null) {
            int pos = value.indexOf(extension_prefix);
            if (pos == -1) {
                return;
            }
            String[] bits = value.split("&");
            value = "";
            for (int i = 0; i < bits.length; ++i) {
                String bit = bits[i].trim();
                if (bit.length() == 0 || bit.startsWith(extension_prefix + "=")) continue;
                value = value + "&" + bit;
            }
            if (value.length() == 0) {
                value = null;
            }
            download.setAttribute(ta_tracker_extensions, value);
        }
    }
}

