/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin.sidebar;

import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImageListener;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.ui.swt.Utils;

public class SideBarVitalityImageSWT
implements MdiEntryVitalityImage {
    private String imageID;
    private final MdiEntry mdiEntry;
    private List<MdiEntryVitalityImageListener> listeners = Collections.EMPTY_LIST;
    private String tooltip;
    private Rectangle hitArea;
    private boolean visible = true;
    private int currentAnimationIndex;
    private String suffix = "";
    private TimerEventPerformer performer;
    private TimerEventPeriodic timerEvent;
    private Image[] images;
    private int delayTime = -1;
    private String fullImageID;
    private int alignment = 131072;

    public SideBarVitalityImageSWT(MdiEntry mdiEntry, String imageID) {
        this.mdiEntry = mdiEntry;
        mdiEntry.addListener(new MdiCloseListener(){

            @Override
            public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                if (SideBarVitalityImageSWT.this.fullImageID != null) {
                    imageLoader.releaseImage(SideBarVitalityImageSWT.this.fullImageID);
                }
            }
        });
        this.setImageID(imageID);
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public MdiEntry getMdiEntry() {
        return this.mdiEntry;
    }

    @Override
    public void addListener(MdiEntryVitalityImageListener l) {
        if (this.listeners == Collections.EMPTY_LIST) {
            this.listeners = new ArrayList<MdiEntryVitalityImageListener>(1);
        }
        this.listeners.add(l);
    }

    @Override
    public void triggerClickedListeners(int x, int y) {
        Object[] list = this.listeners.toArray();
        for (int i = 0; i < list.length; ++i) {
            MdiEntryVitalityImageListener l = (MdiEntryVitalityImageListener)list[i];
            try {
                l.mdiEntryVitalityImage_clicked(x, y);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void setToolTip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public void setHitArea(Rectangle hitArea) {
        this.hitArea = hitArea;
    }

    public Rectangle getHitArea() {
        return this.hitArea;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        if (visible) {
            this.createTimerEvent();
        } else if (this.timerEvent != null) {
            this.timerEvent.cancel();
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SideBarVitalityImageSWT.this.mdiEntry != null) {
                    SideBarVitalityImageSWT.this.mdiEntry.redraw();
                }
            }
        });
    }

    private synchronized void createTimerEvent() {
        if (this.timerEvent != null) {
            this.timerEvent.cancel();
        }
        if (this.images != null && this.images.length > 1) {
            int delay;
            ImageLoader imageLoader = ImageLoader.getInstance();
            int n = delay = this.delayTime == -1 ? imageLoader.getAnimationDelay(this.imageID) : this.delayTime;
            if (this.performer == null) {
                this.performer = new TimerEventPerformer(){
                    private boolean exec_pending = false;
                    private Object lock = this;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        Object object = this.lock;
                        synchronized (object) {
                            if (this.exec_pending) {
                                return;
                            }
                            this.exec_pending = true;
                        }
                        Utils.execSWTThread(new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                Object object = lock;
                                synchronized (object) {
                                    exec_pending = false;
                                }
                                if (SideBarVitalityImageSWT.this.images == null || SideBarVitalityImageSWT.this.images.length == 0 || !SideBarVitalityImageSWT.this.visible || SideBarVitalityImageSWT.this.hitArea == null) {
                                    return;
                                }
                                SideBarVitalityImageSWT.this.currentAnimationIndex++;
                                if (SideBarVitalityImageSWT.this.currentAnimationIndex >= SideBarVitalityImageSWT.this.images.length) {
                                    SideBarVitalityImageSWT.this.currentAnimationIndex = 0;
                                }
                                if (SideBarVitalityImageSWT.this.mdiEntry instanceof SideBarEntrySWT) {
                                    SideBarEntrySWT sbEntry = (SideBarEntrySWT)SideBarVitalityImageSWT.this.mdiEntry;
                                    TreeItem treeItem = sbEntry.getTreeItem();
                                    if (treeItem == null || treeItem.isDisposed() || !sbEntry.swt_isVisible()) {
                                        return;
                                    }
                                    Tree parent = treeItem.getParent();
                                    parent.redraw(((SideBarVitalityImageSWT)SideBarVitalityImageSWT.this).hitArea.x, ((SideBarVitalityImageSWT)SideBarVitalityImageSWT.this).hitArea.y + treeItem.getBounds().y, ((SideBarVitalityImageSWT)SideBarVitalityImageSWT.this).hitArea.width, ((SideBarVitalityImageSWT)SideBarVitalityImageSWT.this).hitArea.height, true);
                                    parent.update();
                                }
                            }
                        });
                    }
                };
            }
            this.timerEvent = SimpleTimer.addPeriodicEvent("Animate " + this.mdiEntry.getId() + "::" + this.imageID + this.suffix, delay, this.performer);
        }
    }

    public int getCurrentAnimationIndex(Image[] images) {
        if (this.currentAnimationIndex >= images.length) {
            this.currentAnimationIndex = 0;
        } else if (this.currentAnimationIndex < 0) {
            this.currentAnimationIndex = 0;
        }
        return this.currentAnimationIndex;
    }

    public void switchSuffix(String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        if (suffix.equals(this.suffix)) {
            return;
        }
        this.suffix = suffix;
        this.setImageID(this.imageID);
    }

    @Override
    public void setImageID(final String id) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                ImageLoader imageLoader = ImageLoader.getInstance();
                String newFullImageID = id + SideBarVitalityImageSWT.this.suffix;
                if (newFullImageID.equals(SideBarVitalityImageSWT.this.fullImageID)) {
                    return;
                }
                if (SideBarVitalityImageSWT.this.fullImageID != null) {
                    imageLoader.releaseImage(SideBarVitalityImageSWT.this.fullImageID);
                }
                SideBarVitalityImageSWT.this.imageID = id;
                SideBarVitalityImageSWT.access$402(SideBarVitalityImageSWT.this, imageLoader.getImages(newFullImageID));
                if (SideBarVitalityImageSWT.this.images == null || SideBarVitalityImageSWT.this.images.length == 0) {
                    imageLoader.releaseImage(newFullImageID);
                    newFullImageID = id;
                    SideBarVitalityImageSWT.access$402(SideBarVitalityImageSWT.this, imageLoader.getImages(id));
                }
                SideBarVitalityImageSWT.this.fullImageID = newFullImageID;
                SideBarVitalityImageSWT.this.currentAnimationIndex = 0;
                if (SideBarVitalityImageSWT.this.isVisible()) {
                    SideBarVitalityImageSWT.this.createTimerEvent();
                }
            }
        });
    }

    public Image getImage() {
        if (this.images == null || this.images.length == 0 || this.currentAnimationIndex >= this.images.length) {
            return null;
        }
        return this.images[this.currentAnimationIndex];
    }

    public void setDelayTime(int delayTime) {
        if (this.delayTime == delayTime) {
            return;
        }
        this.delayTime = delayTime;
        if (this.isVisible()) {
            this.createTimerEvent();
        }
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    @Override
    public int getAlignment() {
        return this.alignment;
    }

    @Override
    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    static /* synthetic */ Image[] access$402(SideBarVitalityImageSWT x0, Image[] x1) {
        x0.images = x1;
        return x1;
    }
}

