/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin.sidebar;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.views.skin.InfoBarUtil;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarVitalityImageSWT;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.ObfusticateTab;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListenerEx;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class SideBarEntrySWT
extends BaseMdiEntry
implements DisposeListener {
    private static final boolean DO_OUR_OWN_TREE_INDENT = true;
    private static final int SIDEBAR_SPACING = 2;
    private int IMAGELEFT_SIZE = 20;
    private int IMAGELEFT_GAP = 5;
    private static final boolean ALWAYS_IMAGE_GAP = true;
    private static final String SO_ID_ENTRY_WRAPPER = "mdi.content.item";
    private static final String SO_ID_TOOLBAR = "mdientry.toolbar.full";
    private static long uniqueNumber = 0L;
    private TreeItem swtItem;
    private List<SideBarVitalityImageSWT> listVitalityImages = Collections.EMPTY_LIST;
    private final SideBar sidebar;
    private int maxIndicatorWidth;
    private Image imgClose;
    private Image imgCloseSelected;
    private Color bg;
    private Color fg;
    private Color bgSel;
    private Color fgSel;
    private boolean showonSWTItemSet;
    private final SWTSkin skin;
    private SWTSkinObjectContainer soParent;
    private boolean buildonSWTItemSet;
    private boolean selectable = true;
    private boolean neverPainted = true;
    private long attention_start = -1L;
    private boolean attention_flash_on;
    boolean isRedrawQueued = false;
    private InfoBarUtil toolBarInfoBar;

    public SideBarEntrySWT(SideBar sidebar, SWTSkin _skin, String id, String parentViewID) {
        super(sidebar, id, parentViewID);
        int i;
        this.skin = _skin;
        this.logID = id == null ? "null" : ((i = id.indexOf(95)) > 0 ? id.substring(0, i) : id);
        this.sidebar = sidebar;
        this.IMAGELEFT_GAP = Utils.adjustPXForDPI(this.IMAGELEFT_GAP);
        this.IMAGELEFT_SIZE = Utils.adjustPXForDPI(this.IMAGELEFT_SIZE);
        this.updateColors();
    }

    protected void updateColors() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinProperties skinProperties = SideBarEntrySWT.this.skin.getSkinProperties();
                SideBarEntrySWT.this.bg = skinProperties.getColor("color.sidebar.bg");
                SideBarEntrySWT.this.fg = skinProperties.getColor("color.sidebar." + (SideBarEntrySWT.this.isSelectable() ? "text" : "header"));
                SideBarEntrySWT.this.bgSel = skinProperties.getColor("color.sidebar.selected.bg");
                SideBarEntrySWT.this.fgSel = skinProperties.getColor("color.sidebar.selected.fg");
            }
        });
    }

    public TreeItem getTreeItem() {
        return this.swtItem;
    }

    public void setTreeItem(TreeItem treeItem) {
        if (this.swtItem != null && treeItem != null) {
            Debug.out("Warning: Sidebar " + this.id + " already has a treeitem");
            return;
        }
        this.swtItem = treeItem;
        this.setDisposed(false);
        if (treeItem != null) {
            MdiEntry parentEntry;
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.imgClose = imageLoader.getImage("image.sidebar.closeitem");
            this.imgCloseSelected = imageLoader.getImage("image.sidebar.closeitem-selected");
            treeItem.addDisposeListener(this);
            treeItem.getParent().addTreeListener(new TreeListener(){

                @Override
                public void treeExpanded(TreeEvent e) {
                    if (e.item == SideBarEntrySWT.this.swtItem) {
                        SideBarEntrySWT.super.setExpanded(true);
                    }
                }

                @Override
                public void treeCollapsed(TreeEvent e) {
                    if (e.item == SideBarEntrySWT.this.swtItem) {
                        SideBarEntrySWT.super.setExpanded(false);
                    }
                }
            });
            TreeItem parentItem = treeItem.getParentItem();
            if (parentItem != null && (parentEntry = (MdiEntry)parentItem.getData("MdiEntry")).isExpanded()) {
                parentItem.setExpanded(true);
            }
            this.setExpanded(this.isExpanded());
        }
        if (this.buildonSWTItemSet) {
            this.build();
        }
        if (this.showonSWTItemSet) {
            this.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MdiEntryVitalityImage addVitalityImage(String imageID) {
        SideBarEntrySWT sideBarEntrySWT = this;
        synchronized (sideBarEntrySWT) {
            SideBarVitalityImageSWT vitalityImage = new SideBarVitalityImageSWT(this, imageID);
            if (this.listVitalityImages == Collections.EMPTY_LIST) {
                this.listVitalityImages = new ArrayList<SideBarVitalityImageSWT>(1);
            }
            this.listVitalityImages.add(vitalityImage);
            return vitalityImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MdiEntryVitalityImage[] getVitalityImages() {
        SideBarEntrySWT sideBarEntrySWT = this;
        synchronized (sideBarEntrySWT) {
            return this.listVitalityImages.toArray(new MdiEntryVitalityImage[0]);
        }
    }

    public MdiEntryVitalityImage getVitalityImage(int hitX, int hitY) {
        MdiEntryVitalityImage[] vitalityImages = this.getVitalityImages();
        for (int i = 0; i < vitalityImages.length; ++i) {
            Rectangle hitArea;
            SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
            if (!vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null || !hitArea.contains(hitX, hitY)) continue;
            return vitalityImage;
        }
        return null;
    }

    @Override
    public void requestAttention() {
        this.attention_start = SystemTime.getMonotonousTime();
        this.sidebar.requestAttention(this);
    }

    protected boolean attentionUpdate(int ticks) {
        if (this.attention_start == -1L || SystemTime.getMonotonousTime() - this.attention_start > 5000L) {
            this.attention_start = -1L;
            return false;
        }
        this.attention_flash_on = ticks % 2 == 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redraw() {
        if (this.neverPainted) {
            return;
        }
        SideBarEntrySWT sideBarEntrySWT = this;
        synchronized (sideBarEntrySWT) {
            if (this.isRedrawQueued) {
                return;
            }
            this.isRedrawQueued = true;
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                try {
                    if (SideBarEntrySWT.this.swtItem == null || SideBarEntrySWT.this.swtItem.isDisposed()) {
                        return;
                    }
                    Tree tree = SideBarEntrySWT.this.swtItem.getParent();
                    if (!tree.isVisible()) {
                        return;
                    }
                    try {
                        Rectangle bounds = SideBarEntrySWT.this.swtItem.getBounds();
                        Rectangle treeBounds = tree.getBounds();
                        tree.redraw(0, bounds.y, treeBounds.width, bounds.height, true);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                finally {
                    SideBarEntrySWT sideBarEntrySWT = SideBarEntrySWT.this;
                    synchronized (sideBarEntrySWT) {
                        SideBarEntrySWT.this.isRedrawQueued = false;
                    }
                }
            }
        });
    }

    protected Rectangle swt_getBounds() {
        if (this.swtItem == null || this.swtItem.isDisposed()) {
            return null;
        }
        try {
            Tree tree = this.swtItem.getParent();
            Rectangle bounds = this.swtItem.getBounds();
            Rectangle treeBounds = tree.getClientArea();
            return new Rectangle(0, bounds.y, treeBounds.width, bounds.height);
        }
        catch (NullPointerException e) {
            Debug.outNoStack("NPE @ " + Debug.getCompressedStackTrace(), true);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    @Override
    public void setExpanded(final boolean expanded) {
        super.setExpanded(expanded);
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SideBarEntrySWT.this.swtItem != null && !SideBarEntrySWT.this.isDisposed()) {
                    SideBarEntrySWT.this.swtItem.setExpanded(expanded);
                }
            }
        });
    }

    @Override
    public void expandTo() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SideBarEntrySWT.this.swtItem == null || SideBarEntrySWT.this.isDisposed()) {
                    return;
                }
                for (TreeItem item = SideBarEntrySWT.this.swtItem.getParentItem(); item != null; item = item.getParentItem()) {
                    item.setExpanded(true);
                }
            }
        });
    }

    @Override
    public boolean close(boolean force) {
        if (!super.close(force)) {
            return false;
        }
        this.mdi.removeItem(this);
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                if (SideBarEntrySWT.this.swtItem != null && !SideBarEntrySWT.this.swtItem.isDisposed()) {
                    try {
                        SideBarEntrySWT.this.swtItem.setFont(null);
                        SideBarEntrySWT.this.swtItem.dispose();
                    }
                    catch (Exception e) {
                        Debug.outNoStack("Warning on SidebarEntry dispose: " + e.toString(), false);
                    }
                    finally {
                        SideBarEntrySWT.this.swtItem = null;
                    }
                }
            }
        });
        return true;
    }

    public boolean canBuildStandAlone() {
        String skinRef = this.getSkinRef();
        if (skinRef != null) {
            return true;
        }
        UISWTViewEventListener event_listener = this.getEventListener();
        return event_listener instanceof UISWTViewCoreEventListenerEx && ((UISWTViewCoreEventListenerEx)event_listener).isCloneable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWTSkinObjectContainer buildStandAlone(SWTSkinObjectContainer soParent) {
        Control control = null;
        Composite parent = soParent.getComposite();
        String skinRef = this.getSkinRef();
        if (skinRef != null) {
            Shell shell = parent.getShell();
            Cursor cursor = shell.getCursor();
            try {
                shell.setCursor(shell.getDisplay().getSystemCursor(1));
                SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiContents." + uniqueNumber++, SO_ID_ENTRY_WRAPPER, soParent, null);
                SWTSkinObject skinObject = this.skin.createSkinObject(this.id, skinRef, soContents, this.getDatasourceCore());
                control = skinObject.getControl();
                control.setLayoutData(Utils.getFilledFormData());
                control.getParent().layout(true, true);
                soContents.setVisible(true);
                SWTSkinObjectContainer sWTSkinObjectContainer = soContents;
                return sWTSkinObjectContainer;
            }
            finally {
                shell.setCursor(cursor);
            }
        }
        UISWTViewEventListener event_listener = this.getEventListener();
        if (event_listener instanceof UISWTViewCoreEventListenerEx && ((UISWTViewCoreEventListenerEx)event_listener).isCloneable()) {
            final UISWTViewImpl view = new UISWTViewImpl(this.getParentID(), this.id, true);
            try {
                view.setEventListener(((UISWTViewCoreEventListenerEx)event_listener).getClone(), false);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            view.setDatasource(this.datasource);
            try {
                SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiIView." + uniqueNumber++, SO_ID_ENTRY_WRAPPER, soParent);
                parent.setBackgroundMode(0);
                final Composite viewComposite = soContents.getComposite();
                boolean doGridLayout = true;
                if (this.getControlType() == 257) {
                    doGridLayout = false;
                }
                if (doGridLayout) {
                    GridLayout gridLayout = new GridLayout();
                    gridLayout.marginWidth = 0;
                    gridLayout.marginHeight = 0;
                    gridLayout.verticalSpacing = 0;
                    gridLayout.horizontalSpacing = 0;
                    viewComposite.setLayout(gridLayout);
                    viewComposite.setLayoutData(Utils.getFilledFormData());
                }
                view.setPluginSkinObject(soContents);
                view.initialize(viewComposite);
                Composite iviewComposite = view.getComposite();
                control = iviewComposite;
                if (doGridLayout) {
                    Object existingLayoutData = iviewComposite.getLayoutData();
                    Object existingParentLayoutData = iviewComposite.getParent().getLayoutData();
                    if (existingLayoutData == null || !(existingLayoutData instanceof GridData) && existingParentLayoutData instanceof GridLayout) {
                        GridData gridData = new GridData(1808);
                        iviewComposite.setLayoutData(gridData);
                    }
                }
                parent.layout(true, true);
                final UIUpdater updater = UIFunctionsManager.getUIFunctions().getUIUpdater();
                updater.addUpdater(new UIUpdatable(){

                    @Override
                    public void updateUI() {
                        if (viewComposite.isDisposed()) {
                            updater.removeUpdater(this);
                        } else {
                            view.triggerEvent(5, null);
                        }
                    }

                    @Override
                    public String getUpdateUIName() {
                        return "popout";
                    }
                });
                soContents.setVisible(true);
                view.triggerEvent(3, null);
                return soContents;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return null;
    }

    @Override
    public void build() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SideBarEntrySWT.this.swt_build();
                SideBarEntrySWT.super.build();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swt_build() {
        if (this.swtItem == null) {
            this.buildonSWTItemSet = true;
            return true;
        }
        this.buildonSWTItemSet = false;
        if (this.getSkinObject() == null) {
            Widget control = null;
            Shell parent = this.soParent == null ? Utils.findAnyShell() : this.soParent.getComposite();
            String skinRef = this.getSkinRef();
            if (skinRef != null) {
                Shell shell = ((Control)parent).getShell();
                Cursor cursor = shell.getCursor();
                try {
                    shell.setCursor(shell.getDisplay().getSystemCursor(1));
                    SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiContents." + uniqueNumber++, SO_ID_ENTRY_WRAPPER, this.getParentSkinObject(), null);
                    SWTSkinObject skinObject = this.skin.createSkinObject(this.id, skinRef, soContents, this.getDatasourceCore());
                    control = skinObject.getControl();
                    ((Control)control).setLayoutData(Utils.getFilledFormData());
                    ((Control)control).getParent().layout(true, true);
                    this.setPluginSkinObject(skinObject);
                    this.initialize((Composite)control);
                    this.setSkinObjectMaster(soContents);
                }
                finally {
                    shell.setCursor(cursor);
                }
            }
            try {
                SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiIView." + uniqueNumber++, SO_ID_ENTRY_WRAPPER, this.getParentSkinObject());
                parent.setBackgroundMode(0);
                Composite viewComposite = soContents.getComposite();
                boolean doGridLayout = true;
                if (this.getControlType() == 257) {
                    doGridLayout = false;
                }
                if (doGridLayout) {
                    GridLayout gridLayout = new GridLayout();
                    gridLayout.marginWidth = 0;
                    gridLayout.marginHeight = 0;
                    gridLayout.verticalSpacing = 0;
                    gridLayout.horizontalSpacing = 0;
                    viewComposite.setLayout(gridLayout);
                    viewComposite.setLayoutData(Utils.getFilledFormData());
                }
                this.setPluginSkinObject(soContents);
                this.initialize(viewComposite);
                String fullTitle = this.getFullTitle();
                if (fullTitle != null) {
                    this.swtItem.setText(this.getFullTitle());
                }
                Composite iviewComposite = this.getComposite();
                control = iviewComposite;
                if (doGridLayout) {
                    Object existingLayoutData = iviewComposite.getLayoutData();
                    Object existingParentLayoutData = iviewComposite.getParent().getLayoutData();
                    if (existingLayoutData == null || !(existingLayoutData instanceof GridData) && existingParentLayoutData instanceof GridLayout) {
                        GridData gridData = new GridData(1808);
                        iviewComposite.setLayoutData(gridData);
                    }
                }
                parent.layout(true, true);
                this.setSkinObjectMaster(soContents);
            }
            catch (Exception e) {
                Debug.out("Error creating sidebar content area for " + this.id, e);
                this.close(true);
            }
            if (control != null && !control.isDisposed()) {
                control.setData("BaseMDIEntry", this);
                control.addDisposeListener(new DisposeListener(){

                    @Override
                    public void widgetDisposed(DisposeEvent e) {
                        SideBarEntrySWT.this.close(true);
                    }
                });
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void show() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                SideBarEntrySWT.this.swt_show();
            }
        });
    }

    private void swt_show() {
        if (this.swtItem == null) {
            this.showonSWTItemSet = true;
            return;
        }
        this.showonSWTItemSet = false;
        if (!this.swt_build()) {
            return;
        }
        this.triggerOpenListeners();
        this.swtItem.getParent().select(this.swtItem);
        this.swtItem.getParent().showItem(this.swtItem);
        super.show();
    }

    @Override
    public void hide() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                SideBarEntrySWT.super.hide();
            }
        });
    }

    protected void swt_paintSideBar(Event event2) {
        String suffix;
        Image imageLeft;
        Object active_state;
        String text;
        this.neverPainted = false;
        TreeItem treeItem = (TreeItem)event2.item;
        if (treeItem.isDisposed() || this.isDisposed()) {
            return;
        }
        Rectangle itemBounds = treeItem.getBounds();
        Rectangle drawBounds = event2.gc.getClipping();
        if (drawBounds.isEmpty()) {
            drawBounds = event2.getBounds();
        }
        Rectangle treeArea = treeItem.getParent().getClientArea();
        if (SideBar.isGTK3) {
            if (treeArea.width > itemBounds.width) {
                itemBounds.width = treeArea.width;
            }
            if (treeArea.x < itemBounds.x) {
                itemBounds.x = treeArea.x;
            }
            drawBounds = itemBounds;
        }
        if ((text = this.getTitle()) == null) {
            text = "";
        }
        GC gc = event2.gc;
        gc.setAntialias(1);
        gc.setAdvanced(true);
        Utils.setClipping(gc, null);
        boolean selected = (event2.detail & 2) > 0;
        Color fgText = this.swt_paintEntryBG(event2.detail, gc, drawBounds);
        Tree tree = (Tree)event2.widget;
        Font font = tree.getFont();
        if (font != null && !font.isDisposed()) {
            gc.setFont(font);
        }
        if (SideBar.USE_NATIVE_EXPANDER && Utils.isGTK3) {
            itemBounds.x = treeItem.getBounds().x;
        } else {
            TreeItem tempItem;
            int indent = !this.isCollapseDisabled() && tempItem == null && !Utils.isGTK ? 22 : 10;
            for (tempItem = treeItem.getParentItem(); tempItem != null; tempItem = tempItem.getParentItem()) {
                indent += 10;
            }
            if (SideBar.USE_NATIVE_EXPANDER && Utils.isGTK) {
                indent += 5;
            }
            itemBounds.x = indent;
        }
        int x1IndicatorOfs = 2;
        int x0IndicatorOfs = itemBounds.x;
        if (this.viewTitleInfo != null) {
            String textIndicator = null;
            try {
                textIndicator = (String)this.viewTitleInfo.getTitleInfoProperty(0);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            if (textIndicator != null) {
                Point textSize = gc.textExtent(textIndicator);
                int width = textSize.x + Utils.adjustPXForDPI(10);
                int startX = treeArea.width - (x1IndicatorOfs += width + 2);
                int textOffsetY = 0;
                int height = textSize.y + 1;
                int startY = itemBounds.y + (itemBounds.height - height) / 2;
                Color default_color = ColorCache.getSchemedColor(gc.getDevice(), "#5b6e87");
                Object color = this.viewTitleInfo.getTitleInfoProperty(8);
                if (color instanceof int[]) {
                    gc.setBackground(ColorCache.getColor(gc.getDevice(), (int[])color));
                } else {
                    gc.setBackground(default_color);
                }
                Color text_color = Colors.white;
                gc.fillRoundRectangle(startX, startY, width, height, textSize.y * 2 / 3, height * 2 / 3);
                if (color != null) {
                    int blue;
                    int green;
                    Color bg = gc.getBackground();
                    int red = bg.getRed();
                    double brightness = Math.sqrt((double)(red * red) * 0.299 + (double)((green = bg.getGreen()) * green) * 0.587 + (double)((blue = bg.getBlue()) * blue) * 0.114);
                    if (brightness >= 130.0) {
                        text_color = Colors.black;
                    }
                    gc.setBackground(default_color);
                    gc.drawRoundRectangle(startX, startY, width, height, textSize.y * 2 / 3, height * 2 / 3);
                }
                if (this.maxIndicatorWidth > width) {
                    this.maxIndicatorWidth = width;
                }
                gc.setForeground(text_color);
                GCStringPrinter.printString(gc, textIndicator, new Rectangle(startX, startY + textOffsetY, width, height), true, false, 0x1000000);
            }
        }
        if (this.isCloseable()) {
            Image img = selected ? this.imgCloseSelected : this.imgClose;
            Rectangle closeArea = img.getBounds();
            closeArea.x = treeArea.width - closeArea.width - 2 - x1IndicatorOfs;
            closeArea.y = itemBounds.y + (itemBounds.height - closeArea.height) / 2;
            x1IndicatorOfs += closeArea.width + 2;
            gc.drawImage(img, closeArea.x, closeArea.y);
            treeItem.setData("closeArea", closeArea);
        }
        MdiEntryVitalityImage[] vitalityImages = this.getVitalityImages();
        for (int i = 0; i < vitalityImages.length; ++i) {
            SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
            if (vitalityImage == null || !vitalityImage.isVisible() || vitalityImage.getAlignment() != 131072) continue;
            vitalityImage.switchSuffix(selected ? "-selected" : "");
            Image image = vitalityImage.getImage();
            if (image == null || image.isDisposed()) continue;
            Rectangle bounds = image.getBounds();
            bounds.x = treeArea.width - bounds.width - 2 - x1IndicatorOfs;
            bounds.y = itemBounds.y + (itemBounds.height - bounds.height) / 2;
            x1IndicatorOfs += bounds.width + 2;
            gc.drawImage(image, bounds.x, bounds.y);
            bounds.y -= itemBounds.y;
            vitalityImage.setHitArea(bounds);
        }
        boolean greyScale = false;
        if (this.viewTitleInfo != null && (active_state = this.viewTitleInfo.getTitleInfoProperty(9)) instanceof Long) {
            greyScale = (Long)active_state == 2L;
        }
        if ((imageLeft = this.getImageLeft(suffix = selected ? "-selected" : null)) == null && selected) {
            this.releaseImageLeft(suffix);
            suffix = null;
            imageLeft = this.getImageLeft(null);
        }
        if (imageLeft != null) {
            Rectangle clipping = gc.getClipping();
            Utils.setClipping(gc, new Rectangle(x0IndicatorOfs, itemBounds.y, this.IMAGELEFT_SIZE, itemBounds.height));
            if (greyScale) {
                Image grey;
                greyScale = false;
                String imageLeftID = this.getImageLeftID();
                if (imageLeftID != null && (grey = ImageLoader.getInstance().getImage(imageLeftID + "-gray")) != null) {
                    imageLeft = grey;
                    gc.setAlpha(160);
                    greyScale = true;
                }
            }
            Rectangle bounds = imageLeft.getBounds();
            int w = bounds.width;
            int h = bounds.height;
            if (w > this.IMAGELEFT_SIZE) {
                float pct = (float)this.IMAGELEFT_SIZE / (float)w;
                w = this.IMAGELEFT_SIZE;
                h = (int)((float)h * pct);
            }
            int x = x0IndicatorOfs + (this.IMAGELEFT_SIZE - w) / 2;
            int y = itemBounds.y + (itemBounds.height - h) / 2;
            gc.setAdvanced(true);
            gc.setInterpolation(2);
            gc.drawImage(imageLeft, 0, 0, bounds.width, bounds.height, x, y, w, h);
            if (greyScale) {
                String imageLeftID = this.getImageLeftID();
                gc.setAlpha(255);
                ImageLoader.getInstance().releaseImage(imageLeftID + "-gray");
            }
            this.releaseImageLeft(suffix);
            Utils.setClipping(gc, clipping);
            x0IndicatorOfs += this.IMAGELEFT_SIZE + this.IMAGELEFT_GAP;
            this.releaseImageLeft(suffix);
        } else if (this.isSelectable()) {
            x0IndicatorOfs += this.IMAGELEFT_SIZE + this.IMAGELEFT_GAP;
        }
        Rectangle clipping = new Rectangle(x0IndicatorOfs, itemBounds.y, treeArea.width - x1IndicatorOfs - 2 - x0IndicatorOfs, itemBounds.height);
        if (drawBounds.intersects(clipping)) {
            int style = 0;
            if (!this.isSelectable()) {
                Font headerFont = this.sidebar.getHeaderFont();
                if (headerFont != null && !headerFont.isDisposed()) {
                    gc.setFont(headerFont);
                }
                text = text.toUpperCase();
                gc.setForeground(ColorCache.getColor(gc.getDevice(), 255, 255, 255));
                gc.setAlpha(100);
                ++clipping.x;
                ++clipping.y;
                GCStringPrinter sp = new GCStringPrinter(gc, text, clipping, true, false, style);
                sp.printString();
                gc.setAlpha(255);
                --clipping.x;
                --clipping.y;
                gc.setForeground(fgText);
            } else {
                Font headerFont;
                if (treeItem.getItemCount() > 0 && (headerFont = this.sidebar.getHeaderFont()) != null && !headerFont.isDisposed()) {
                    gc.setFont(headerFont);
                }
                gc.setForeground(fgText);
            }
            GCStringPrinter sp = new GCStringPrinter(gc, text, clipping, true, false, style);
            sp.printString();
            clipping.x += sp.getCalculatedSize().x + 5;
        }
        for (int i = 0; i < vitalityImages.length; ++i) {
            SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
            if (!vitalityImage.isVisible() || vitalityImage.getAlignment() != 16384) continue;
            vitalityImage.switchSuffix(selected ? "-selected" : "");
            Image image = vitalityImage.getImage();
            if (image == null || image.isDisposed()) continue;
            Rectangle bounds = image.getBounds();
            bounds.x = clipping.x;
            bounds.y = itemBounds.y + (itemBounds.height - bounds.height) / 2;
            clipping.x += bounds.width + 2;
            if (clipping.x > treeArea.width - x1IndicatorOfs) {
                vitalityImage.setHitArea(null);
                continue;
            }
            gc.drawImage(image, bounds.x, bounds.y);
            vitalityImage.setHitArea(bounds);
        }
        if (treeItem.getItemCount() > 0 && !this.isCollapseDisabled() && !SideBar.USE_NATIVE_EXPANDER) {
            int xStart;
            gc.setAntialias(1);
            Color oldBG = gc.getBackground();
            gc.setBackground(event2.display.getSystemColor(24));
            int baseX = 22;
            if (treeItem.getExpanded()) {
                xStart = 12;
                int arrowSize = 8;
                int yStart = itemBounds.height - (itemBounds.height + arrowSize) / 2;
                gc.fillPolygon(new int[]{baseX - xStart, itemBounds.y + yStart, baseX - xStart + arrowSize, itemBounds.y + yStart, baseX - xStart + arrowSize / 2, itemBounds.y + yStart + arrowSize});
            } else {
                xStart = 12;
                int arrowSize = 8;
                int yStart = itemBounds.height - (itemBounds.height + arrowSize) / 2;
                gc.fillPolygon(new int[]{baseX - xStart, itemBounds.y + yStart, baseX - xStart + arrowSize, itemBounds.y + yStart + 4, baseX - xStart, itemBounds.y + yStart + 8});
            }
            gc.setBackground(oldBG);
            Font headerFont = this.sidebar.getHeaderFont();
            if (headerFont != null && !headerFont.isDisposed()) {
                gc.setFont(headerFont);
            }
        }
    }

    protected Color swt_paintEntryBG(int detail, GC gc, Rectangle drawBounds) {
        boolean hot;
        this.neverPainted = false;
        Color fgText = Colors.black;
        boolean selected = (detail & 2) > 0;
        boolean bl = hot = (detail & 0x20) > 0;
        if (selected) {
            this.attention_start = -1L;
        } else if (this.attention_start != -1L && this.attention_flash_on) {
            selected = true;
        }
        if (selected) {
            if (Constants.isLinux) {
                gc.fillRectangle(drawBounds.x, drawBounds.y, drawBounds.width, drawBounds.height);
                fgText = gc.getForeground();
            } else {
                Color color2;
                Color color1;
                Utils.setClipping(gc, null);
                if (this.fgSel != null) {
                    fgText = this.fgSel;
                }
                if (this.bgSel != null) {
                    gc.setBackground(this.bgSel);
                }
                if (this.sidebar.getTree().isFocusControl()) {
                    color1 = ColorCache.getSchemedColor(gc.getDevice(), "#166688");
                    color2 = ColorCache.getSchemedColor(gc.getDevice(), "#1c2458");
                } else {
                    color1 = ColorCache.getSchemedColor(gc.getDevice(), "#447281");
                    color2 = ColorCache.getSchemedColor(gc.getDevice(), "#393e58");
                }
                gc.setBackground(color1);
                gc.fillRectangle(drawBounds.x, drawBounds.y, drawBounds.width, 4);
                gc.setForeground(color1);
                gc.setBackground(color2);
                Rectangle itemBounds = this.swt_getBounds();
                if (itemBounds == null) {
                    return fgText;
                }
                gc.fillGradientRectangle(drawBounds.x, itemBounds.y + 3, drawBounds.width, itemBounds.height - 3, true);
            }
        } else {
            Color c;
            if (this.fg != null) {
                fgText = this.fg;
            }
            if (this.bg != null) {
                gc.setBackground(this.bg);
            }
            if (this == this.sidebar.draggingOver || hot) {
                c = this.skin.getSkinProperties().getColor("color.sidebar.drag.bg");
                gc.setBackground(c);
            }
            gc.fillRectangle(drawBounds);
            if (this == this.sidebar.draggingOver) {
                c = this.skin.getSkinProperties().getColor("color.sidebar.drag.fg");
                gc.setForeground(c);
                gc.setLineWidth(5);
                gc.drawRectangle(drawBounds);
            }
        }
        return fgText;
    }

    @Override
    public void widgetDisposed(DisposeEvent e) {
        MdiEntry entry;
        String parentID;
        boolean user;
        Tree tree;
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("image.sidebar.closeitem");
        imageLoader.releaseImage("image.sidebar.closeitem-selected");
        this.setDisposed(true);
        TreeItem treeItem = (TreeItem)e.widget;
        if (treeItem != this.swtItem) {
            Debug.out("Warning: TreeItem changed for sidebar " + this.id);
            return;
        }
        if (this.swtItem == null) {
            return;
        }
        if (this.swtItem != null && !Constants.isOSX) {
            TreeItem[] children;
            for (TreeItem child : children = this.swtItem.getItems()) {
                MdiEntry entry2;
                if (child.isDisposed() || (entry2 = (MdiEntry)child.getData("MdiEntry")) == null) continue;
                entry2.close(true);
            }
        }
        if ((tree = this.sidebar.getTree()).isDisposed() || this.swtItem != null && this.swtItem.isDisposed() || tree.getShell().isDisposed()) {
            return;
        }
        this.setTreeItem(null);
        this.mdi.removeItem(this);
        boolean bl = user = !SWTThread.getInstance().isTerminated();
        if (user && (parentID = this.getParentID()) != null && (entry = this.mdi.getEntry(parentID)) != null && entry.isDisposed()) {
            user = false;
        }
        this.triggerCloseListeners(user);
        SWTSkinObject so = this.getSkinObject();
        if (so != null) {
            this.setSkinObjectMaster(null);
            so.getSkin().removeSkinObject(so);
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                MdiEntry entry;
                if (tree.isDisposed()) {
                    return;
                }
                try {
                    COConfigurationManager.removeParameter("SideBar.AutoOpen." + SideBarEntrySWT.this.id);
                    if (Constants.isOSX && !tree.isDisposed() && tree.getSelectionCount() == 0) {
                        String parentid = SideBarEntrySWT.this.getParentID();
                        if (parentid != null && SideBarEntrySWT.this.mdi.getEntry(parentid) != null) {
                            SideBarEntrySWT.this.mdi.showEntryByID(parentid);
                        } else {
                            SideBarEntrySWT.this.mdi.showEntryByID("Library");
                        }
                    }
                }
                catch (Exception e2) {
                    Debug.out(e2);
                }
                boolean replaced = false;
                String my_id = SideBarEntrySWT.this.getId();
                if (my_id != null && (entry = SideBarEntrySWT.this.mdi.getEntry(my_id)) != null && entry != SideBarEntrySWT.this) {
                    replaced = true;
                }
                if (!replaced) {
                    SideBarEntrySWT.this.mdi.removeEntryAutoOpen(SideBarEntrySWT.this.id);
                }
            }
        });
    }

    public void setParentSkinObject(SWTSkinObjectContainer soParent) {
        this.soParent = soParent;
    }

    public SWTSkinObjectContainer getParentSkinObject() {
        return this.soParent;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
        this.updateColors();
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean swt_isVisible() {
        MdiEntry parentEntry;
        TreeItem parentItem = this.swtItem.getParentItem();
        return parentItem == null || (parentEntry = (MdiEntry)parentItem.getData("MdiEntry")).isExpanded();
    }

    @Override
    public Image obfusticatedImage(Image image) {
        Rectangle bounds = this.swt_getBounds();
        if (bounds != null) {
            String header;
            TreeItem treeItem = this.getTreeItem();
            Point location = Utils.getLocationRelativeToShell(treeItem.getParent());
            bounds.x += location.x;
            bounds.y += location.y;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("image", image);
            map.put("obfuscateTitle", false);
            this.triggerEvent(9, map);
            if (this.viewTitleInfo instanceof ObfusticateImage) {
                ((ObfusticateImage)((Object)this.viewTitleInfo)).obfusticatedImage(image);
            }
            int ofs = this.IMAGELEFT_GAP + this.IMAGELEFT_SIZE;
            if (treeItem.getParentItem() != null) {
                ofs += 12;
            }
            bounds.x += ofs;
            bounds.width -= ofs + 2 + 1;
            --bounds.height;
            if (this.viewTitleInfo instanceof ObfusticateTab && (header = ((ObfusticateTab)((Object)this.viewTitleInfo)).getObfusticatedHeader()) != null) {
                UIDebugGenerator.obfusticateArea(image, bounds, header);
            }
            if (MapUtils.getMapBoolean(map, "obfuscateTitle", false)) {
                UIDebugGenerator.obfusticateArea(image, bounds);
            }
        }
        return image;
    }

    @Override
    protected void setToolbarVisibility(boolean visible) {
        if (this.toolBarInfoBar != null) {
            if (visible) {
                this.toolBarInfoBar.show();
            } else {
                this.toolBarInfoBar.hide(false);
            }
            return;
        }
        SWTSkinObject soMaster = this.getSkinObjectMaster();
        if (soMaster == null) {
            return;
        }
        SWTSkinObject so = this.getSkinObject();
        if (so == null) {
            return;
        }
        SWTSkinObject soToolbar = this.skin.getSkinObject("view-toolbar", soMaster);
        if (soToolbar == null && visible) {
            this.toolBarInfoBar = new InfoBarUtil(so, SO_ID_TOOLBAR, true, "", ""){

                @Override
                public boolean allowShow() {
                    return true;
                }
            };
        } else if (soToolbar != null) {
            soToolbar.setVisible(visible);
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.refreshTitle();
    }

    @Override
    protected void refreshTitle() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SideBarEntrySWT.this.swtItem == null || SideBarEntrySWT.this.swtItem.isDisposed()) {
                    return;
                }
                String title = SideBarEntrySWT.this.getTitle();
                if (!SideBarEntrySWT.this.swtItem.getText().equals(title)) {
                    SideBarEntrySWT.this.swtItem.setText(title);
                    SideBarEntrySWT.this.redraw();
                }
            }
        });
    }
}

