/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectAdapter;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;

public abstract class SkinView
extends SWTSkinObjectAdapter {
    private boolean shownOnce = false;
    private boolean visible;
    protected SWTSkinObject soMain;
    protected SWTSkin skin;
    private boolean disposed = false;

    public SkinView() {
        if (this instanceof UIUpdatable) {
            UIUpdatable updateable = (UIUpdatable)((Object)this);
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(updateable);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        this.setMainSkinObject(skinObject);
        this.visible = true;
        if (this.shownOnce) {
            return null;
        }
        this.shownOnce = true;
        try {
            return this.skinObjectInitialShow(skinObject, params);
        }
        catch (Exception e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        this.visible = false;
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        this.disposed = true;
        SkinViewManager.remove(this);
        if (this instanceof UIUpdatable) {
            UIUpdatable updateable = (UIUpdatable)((Object)this);
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(updateable);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        return null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public abstract Object skinObjectInitialShow(SWTSkinObject var1, Object var2);

    public SWTSkinObject getMainSkinObject() {
        return this.soMain;
    }

    @Override
    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        MdiEntrySWT entry;
        SkinViewManager.add(this);
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getEntryFromSkinObject(skinObject)) != null && this instanceof UIPluginViewToolBarListener) {
            entry.addToolbarEnabler((UIPluginViewToolBarListener)((Object)this));
        }
        return super.skinObjectCreated(skinObject, params);
    }

    public final void setMainSkinObject(SWTSkinObject main) {
        if (this.soMain != null) {
            return;
        }
        this.soMain = main;
        if (this.soMain != null) {
            this.skin = this.soMain.getSkin();
            this.soMain.setSkinView(this);
        }
    }

    public final SWTSkin getSkin() {
        return this.skin;
    }

    public final SWTSkinObject getSkinObject(String viewID) {
        return this.skin.getSkinObject(viewID, this.soMain);
    }
}

