/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagManagerListener;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.torrent.HasBeenOpenedListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiEntryLoadedListener;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiSWTMenuHackListener;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.views.PeersGeneralView;
import org.gudy.azureus2.ui.swt.views.utils.CategoryUIUtils;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

public class SB_Transfers {
    private static final Object AUTO_CLOSE_KEY = new Object();
    private static final Object TAG_DATA_KEY = new Object();
    private static final String ID_VITALITY_ACTIVE = "image.sidebar.vitality.dl";
    private static final String ID_VITALITY_ALERT = "image.sidebar.vitality.alert";
    private static Object statsLock = new Object();
    private static stats statsWithLowNoise = new stats();
    private static stats statsNoLowNoise = new stats();
    private static CopyOnWriteList<countRefreshListener> listeners = new CopyOnWriteList();
    private static boolean first = true;
    private static AzureusCore core;
    private static long coreCreateTime;
    private static Object tag_setup_lock;
    private static FrequencyLimitedDispatcher refresh_limiter;

    public static void setup(final MultipleDocumentInterface mdi) {
        MdiEntryCreationListener libraryCreator = new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "Library", "library", "{sidebar.Library}", null, null, false, "");
                entry.setImageLeftID("image.sidebar.library");
                return entry;
            }
        };
        mdi.registerEntry("Library", libraryCreator);
        mdi.registerEntry("library", libraryCreator);
        mdi.registerEntry("minilibrary", libraryCreator);
        mdi.registerEntry("LibraryDL", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                return SB_Transfers.createDownloadingEntry(mdi);
            }
        });
        mdi.registerEntry("LibraryCD", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                return SB_Transfers.createSeedingEntry(mdi);
            }
        });
        mdi.registerEntry("LibraryUnopened", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                return SB_Transfers.createUnopenedEntry(mdi);
            }
        });
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                SB_Transfers.setupViewTitleWithCore(core);
            }
        });
        PlatformTorrentUtils.addHasBeenOpenedListener(new HasBeenOpenedListener(){

            @Override
            public void hasBeenOpenedChanged(DownloadManager dm, boolean opened) {
                SB_Transfers.recountUnopened();
                SB_Transfers.refreshAllLibraries();
            }
        });
        SB_Transfers.addMenuUnwatched("Library");
        mdi.addListener(new MdiEntryLoadedListener(){

            @Override
            public void mdiEntryLoaded(MdiEntry entry) {
                if ("header.transfers".equals(entry.getId())) {
                    SB_Transfers.addHeaderMenu();
                }
            }
        });
    }

    protected static void addHeaderMenu() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        MenuItem menuItem = menuManager.addMenuItem("sidebar.header.transfers", "MyTorrentsView.menu.setCategory.add");
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                new CategoryAdderWindow(null);
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setVisible(COConfigurationManager.getBooleanParameter("Library.CatInSideBar"));
            }
        });
        menuItem = menuManager.addMenuItem("sidebar.header.transfers", "ConfigView.section.style.CatInSidebar");
        menuItem.setStyle(2);
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                boolean b = COConfigurationManager.getBooleanParameter("Library.CatInSideBar");
                COConfigurationManager.setParameter("Library.CatInSideBar", !b);
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setVisible(CategoryManager.getCategories().length > 0);
                menu.setData(COConfigurationManager.getBooleanParameter("Library.CatInSideBar"));
            }
        });
        TagUIUtils.setupSideBarMenus(menuManager);
    }

    protected static MdiEntry createUnopenedEntry(MultipleDocumentInterface mdi) {
        MdiEntry infoLibraryUn = mdi.createEntryFromSkinRef("header.transfers", "LibraryUnopened", "library", "{sidebar.LibraryUnopened}", null, null, false, "Library");
        infoLibraryUn.setImageLeftID("image.sidebar.unopened");
        SB_Transfers.addMenuUnwatched("LibraryUnopened");
        infoLibraryUn.setViewTitleInfo(new ViewTitleInfo(){

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0 && statsNoLowNoise.numUnOpened > 0) {
                    return "" + statsNoLowNoise.numUnOpened;
                }
                return null;
            }
        });
        return infoLibraryUn;
    }

    private static void addMenuUnwatched(String id) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        MenuItem menuItem = menuManager.addMenuItem("sidebar." + id, "v3.activity.button.watchall");
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new AzureusCoreRunningListener(){

                    @Override
                    public void azureusCoreRunning(AzureusCore core) {
                        GlobalManager gm = core.getGlobalManager();
                        List<DownloadManager> downloadManagers = gm.getDownloadManagers();
                        for (DownloadManager dm : downloadManagers) {
                            if (PlatformTorrentUtils.getHasBeenOpened(dm) || !dm.getAssumedComplete()) continue;
                            PlatformTorrentUtils.setHasBeenOpened(dm, true);
                        }
                    }
                });
            }
        });
    }

    protected static MdiEntry createSeedingEntry(MultipleDocumentInterface mdi) {
        ViewTitleInfo titleInfoSeeding = new ViewTitleInfo(){

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    return null;
                }
                if (propertyID == 1) {
                    return MessageText.getString("sidebar.LibraryCD.tooltip", new String[]{"" + statsNoLowNoise.numComplete, "" + statsNoLowNoise.numSeeding});
                }
                return null;
            }
        };
        MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "LibraryDL", "library", "{sidebar.LibraryDL}", titleInfoSeeding, null, false, null);
        entry.setImageLeftID("image.sidebar.downloading");
        MdiEntryVitalityImage vitalityImage = entry.addVitalityImage(ID_VITALITY_ALERT);
        vitalityImage.setVisible(false);
        entry.setViewTitleInfo(titleInfoSeeding);
        return entry;
    }

    protected static MdiEntry createDownloadingEntry(MultipleDocumentInterface mdi) {
        MdiEntry entry;
        final MdiEntry[] entry_holder = new MdiEntry[]{null};
        ViewTitleInfo titleInfoDownloading = new ViewTitleInfo(){
            private long max_incomp_dl_time;

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    int current;
                    if (COConfigurationManager.getBooleanParameter("Request Attention On New Download") && coreCreateTime > 0L) {
                        MdiEntry entry;
                        if (this.max_incomp_dl_time == 0L) {
                            this.max_incomp_dl_time = coreCreateTime;
                        }
                        if (statsNoLowNoise.newestIncompleteDownloadTime > this.max_incomp_dl_time && (entry = entry_holder[0]) != null) {
                            this.max_incomp_dl_time = statsNoLowNoise.newestIncompleteDownloadTime;
                            entry.requestAttention();
                        }
                    }
                    if ((current = statsNoLowNoise.numIncomplete) > 0) {
                        return current + "";
                    }
                }
                if (propertyID == 1) {
                    return MessageText.getString("sidebar.LibraryDL.tooltip", new String[]{"" + statsNoLowNoise.numIncomplete, "" + statsNoLowNoise.numDownloading});
                }
                return null;
            }
        };
        entry_holder[0] = entry = mdi.createEntryFromSkinRef("header.transfers", "LibraryDL", "library", "{sidebar.LibraryDL}", titleInfoDownloading, null, false, null);
        entry.setImageLeftID("image.sidebar.downloading");
        MdiEntryVitalityImage vitalityImage = entry.addVitalityImage(ID_VITALITY_ACTIVE);
        vitalityImage.setVisible(false);
        vitalityImage = entry.addVitalityImage(ID_VITALITY_ALERT);
        vitalityImage.setVisible(false);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setupViewTitleWithCore(AzureusCore _core) {
        Class<SB_Transfers> clazz = SB_Transfers.class;
        synchronized (SB_Transfers.class) {
            if (!first) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            first = false;
            core = _core;
            coreCreateTime = core.getCreateTime();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            final CategoryListener categoryListener = new CategoryListener(){

                @Override
                public void downloadManagerRemoved(Category cat, DownloadManager removed) {
                    SB_Transfers.RefreshCategorySideBar(cat);
                }

                @Override
                public void downloadManagerAdded(Category cat, DownloadManager manager) {
                    SB_Transfers.RefreshCategorySideBar(cat);
                }
            };
            COConfigurationManager.addAndFireParameterListener("Library.CatInSideBar", new ParameterListener(){
                private CategoryManagerListener categoryManagerListener;

                @Override
                public void parameterChanged(String parameterName) {
                    block7: {
                        Category[] categories;
                        block6: {
                            if (Utils.isAZ2UI()) {
                                return;
                            }
                            categories = CategoryManager.getCategories();
                            if (categories.length == 0) {
                                return;
                            }
                            boolean catInSidebar = COConfigurationManager.getBooleanParameter("Library.CatInSideBar");
                            if (!catInSidebar) break block6;
                            if (this.categoryManagerListener != null) {
                                return;
                            }
                            this.categoryManagerListener = new CategoryManagerListener(){

                                @Override
                                public void categoryRemoved(Category category) {
                                    SB_Transfers.removeCategory(category);
                                }

                                @Override
                                public void categoryChanged(Category category) {
                                    SB_Transfers.RefreshCategorySideBar(category);
                                }

                                @Override
                                public void categoryAdded(Category category) {
                                    Category[] categories = CategoryManager.getCategories();
                                    if (categories.length == 3) {
                                        for (Category cat : categories) {
                                            SB_Transfers.setupCategory(cat);
                                        }
                                    } else {
                                        SB_Transfers.setupCategory(category);
                                    }
                                }
                            };
                            CategoryManager.addCategoryManagerListener(this.categoryManagerListener);
                            if (categories.length <= 2) break block7;
                            for (Category category : categories) {
                                category.addCategoryListener(categoryListener);
                                SB_Transfers.setupCategory(category);
                            }
                            break block7;
                        }
                        if (this.categoryManagerListener != null) {
                            CategoryManager.removeCategoryManagerListener(this.categoryManagerListener);
                            this.categoryManagerListener = null;
                        }
                        for (Category category : categories) {
                            category.removeCategoryListener(categoryListener);
                            SB_Transfers.removeCategory(category);
                        }
                    }
                }
            });
            final TagListener tagListener = new TagListener(){

                @Override
                public void taggableAdded(Tag tag, Taggable tagged) {
                    SB_Transfers.RefreshTagSideBar(tag);
                }

                @Override
                public void taggableSync(Tag tag) {
                    SB_Transfers.RefreshTagSideBar(tag);
                }

                @Override
                public void taggableRemoved(Tag tag, Taggable tagged) {
                    SB_Transfers.RefreshTagSideBar(tag);
                }
            };
            COConfigurationManager.addAndFireParameterListener("Library.TagInSideBar", new ParameterListener(){
                private TagManagerListener tagManagerListener;
                private TagTypeListener tagTypeListenerListener;

                @Override
                public void parameterChanged(String parameterName) {
                    boolean tagInSidebar = COConfigurationManager.getBooleanParameter("Library.TagInSideBar");
                    if (tagInSidebar) {
                        if (this.tagManagerListener != null) {
                            return;
                        }
                        this.tagTypeListenerListener = new TagTypeListener(){

                            @Override
                            public void tagTypeChanged(TagType tag_type) {
                                for (Tag tag : tag_type.getTags()) {
                                    if (tag.isVisible()) {
                                        SB_Transfers.setupTag(tag);
                                        continue;
                                    }
                                    SB_Transfers.RefreshTagSideBar(tag);
                                }
                            }

                            @Override
                            public void tagEventOccurred(TagTypeListener.TagEvent event2) {
                                int type = event2.getEventType();
                                Tag tag = event2.getTag();
                                if (type == 0) {
                                    this.tagAdded(tag);
                                } else if (type == 1) {
                                    this.tagChanged(tag);
                                } else if (type == 2) {
                                    this.tagRemoved(tag);
                                } else if (type == 3) {
                                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                                    if (mdi == null) {
                                        return;
                                    }
                                    MdiEntry entry = mdi.getEntry("Tag." + tag.getTagType().getTagType() + "." + tag.getTagID());
                                    if (entry != null) {
                                        mdi.showEntry(entry);
                                    }
                                }
                            }

                            public void tagAdded(Tag tag) {
                                if (tag.isVisible()) {
                                    SB_Transfers.setupTag(tag);
                                    tag.addTagListener(tagListener, false);
                                }
                            }

                            public void tagChanged(Tag tag) {
                                SB_Transfers.RefreshTagSideBar(tag);
                            }

                            public void tagRemoved(Tag tag) {
                                SB_Transfers.removeTag(tag);
                            }
                        };
                        this.tagManagerListener = new TagManagerListener(){

                            @Override
                            public void tagTypeAdded(TagManager manager, TagType tag_type) {
                                if (tag_type.getTagType() != 1) {
                                    tag_type.addTagTypeListener(tagTypeListenerListener, true);
                                }
                            }

                            @Override
                            public void tagTypeRemoved(TagManager manager, TagType tag_type) {
                                for (Tag t : tag_type.getTags()) {
                                    SB_Transfers.removeTag(t);
                                }
                            }
                        };
                        TagManagerFactory.getTagManager().addTagManagerListener(this.tagManagerListener, true);
                    } else if (this.tagManagerListener != null) {
                        TagManagerFactory.getTagManager().removeTagManagerListener(this.tagManagerListener);
                        List<TagType> tag_types = TagManagerFactory.getTagManager().getTagTypes();
                        for (TagType tt : tag_types) {
                            if (tt.getTagType() != 1) {
                                tt.removeTagTypeListener(this.tagTypeListenerListener);
                            }
                            for (Tag t : tt.getTags()) {
                                t.removeTagListener(tagListener);
                                SB_Transfers.removeTag(t);
                            }
                        }
                        this.tagManagerListener = null;
                        this.tagTypeListenerListener = null;
                    }
                }
            });
            final GlobalManager gm = core.getGlobalManager();
            final DownloadManagerAdapter dmListener = new DownloadManagerAdapter(){

                @Override
                public void stateChanged(DownloadManager dm, int state) {
                    this.stateChanged(dm, state, statsNoLowNoise);
                    this.stateChanged(dm, state, statsWithLowNoise);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(DownloadManager dm, int state, stats stats2) {
                    if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                        return;
                    }
                    Object object = statsLock;
                    synchronized (object) {
                        boolean isErrorState;
                        SB_Transfers.updateDMCounts(dm);
                        boolean complete = dm.getAssumedComplete();
                        Boolean wasErrorStateB = (Boolean)dm.getUserData("wasErrorState");
                        boolean wasErrorState = wasErrorStateB == null ? false : wasErrorStateB;
                        boolean bl = isErrorState = state == 100;
                        if (isErrorState != wasErrorState) {
                            int rel;
                            int n = rel = isErrorState ? 1 : -1;
                            if (complete) {
                                stats2.numErrorComplete += rel;
                            } else {
                                stats2.numErrorInComplete += rel;
                            }
                            SB_Transfers.updateErrorTooltip(gm, stats2);
                            dm.setUserData("wasErrorState", isErrorState);
                        }
                        SB_Transfers.refreshAllLibraries();
                    }
                }

                @Override
                public void completionChanged(DownloadManager dm, boolean completed) {
                    this.completionChanged(dm, completed, statsNoLowNoise);
                    this.completionChanged(dm, completed, statsWithLowNoise);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completionChanged(DownloadManager dm, boolean completed, stats stats2) {
                    if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                        return;
                    }
                    Object object = statsLock;
                    synchronized (object) {
                        int dm_state = SB_Transfers.updateDMCounts(dm);
                        if (completed) {
                            ++stats2.numComplete;
                            --stats2.numIncomplete;
                            if (dm_state == 100) {
                                ++stats2.numErrorComplete;
                                --stats2.numErrorInComplete;
                            }
                            if (dm_state == 70) {
                                --statsNoLowNoise.numStoppedIncomplete;
                            }
                        } else {
                            --stats2.numComplete;
                            ++stats2.numIncomplete;
                            if (dm_state == 100) {
                                --stats2.numErrorComplete;
                                ++stats2.numErrorInComplete;
                            }
                            if (dm_state == 70) {
                                ++statsNoLowNoise.numStoppedIncomplete;
                            }
                        }
                        SB_Transfers.recountUnopened();
                        SB_Transfers.updateErrorTooltip(gm, stats2);
                        SB_Transfers.refreshAllLibraries();
                    }
                }
            };
            gm.addListener(new GlobalManagerAdapter(){

                @Override
                public void downloadManagerRemoved(DownloadManager dm) {
                    this.downloadManagerRemoved(dm, statsNoLowNoise);
                    this.downloadManagerRemoved(dm, statsWithLowNoise);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloadManagerRemoved(DownloadManager dm, stats stats2) {
                    if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                        return;
                    }
                    Object object = statsLock;
                    synchronized (object) {
                        Boolean wasQueuedB;
                        boolean wasQueued;
                        boolean wasStopped;
                        SB_Transfers.recountUnopened();
                        if (dm.getAssumedComplete()) {
                            --stats2.numComplete;
                            Boolean wasDownloadingB = (Boolean)dm.getUserData("wasDownloading");
                            if (wasDownloadingB != null && wasDownloadingB.booleanValue()) {
                                --stats2.numDownloading;
                            }
                        } else {
                            --stats2.numIncomplete;
                            Boolean wasSeedingB = (Boolean)dm.getUserData("wasSeeding");
                            if (wasSeedingB != null && wasSeedingB.booleanValue()) {
                                --stats2.numSeeding;
                            }
                        }
                        Boolean wasStoppedB = (Boolean)dm.getUserData("wasStopped");
                        boolean bl = wasStopped = wasStoppedB == null ? false : wasStoppedB;
                        if (wasStopped && !dm.getAssumedComplete()) {
                            --stats2.numStoppedIncomplete;
                        }
                        boolean bl2 = wasQueued = (wasQueuedB = (Boolean)dm.getUserData("wasQueued")) == null ? false : wasQueuedB;
                        if (wasQueued) {
                            --stats2.numQueued;
                        }
                        SB_Transfers.refreshAllLibraries();
                    }
                    dm.removeListener(dmListener);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void downloadManagerAdded(DownloadManager dm) {
                    dm.addListener(dmListener, false);
                    Object object = statsLock;
                    synchronized (object) {
                        SB_Transfers.recountUnopened();
                        this.downloadManagerAdded(dm, statsNoLowNoise);
                        this.downloadManagerAdded(dm, statsWithLowNoise);
                        SB_Transfers.refreshAllLibraries();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloadManagerAdded(DownloadManager dm, stats stats2) {
                    if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                        return;
                    }
                    boolean assumed_complete = dm.getAssumedComplete();
                    Object object = statsLock;
                    synchronized (object) {
                        if (dm.isPersistent() && dm.getTorrent() != null && !assumed_complete) {
                            stats2.newestIncompleteDownloadTime = Math.max(stats2.newestIncompleteDownloadTime, dm.getCreationTime());
                        }
                        int dm_state = dm.getState();
                        if (assumed_complete) {
                            ++stats2.numComplete;
                            if (dm_state == 60) {
                                ++stats2.numSeeding;
                            }
                        } else {
                            ++stats2.numIncomplete;
                            if (dm_state == 50) {
                                dm.setUserData("wasDownloading", Boolean.TRUE);
                                ++stats2.numDownloading;
                            } else {
                                dm.setUserData("wasDownloading", Boolean.FALSE);
                            }
                        }
                    }
                }
            }, false);
            SB_Transfers.resetStats(gm, dmListener, statsWithLowNoise, statsNoLowNoise);
            SB_Transfers.refreshAllLibraries();
            SimpleTimer.addPeriodicEvent("header:refresh", 60000L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    stats withNoise = new stats();
                    stats noNoise = new stats();
                    noNoise.includeLowNoise = false;
                    withNoise.includeLowNoise = true;
                    Object object = statsLock;
                    synchronized (object) {
                        SB_Transfers.resetStats(gm, null, withNoise, noNoise);
                        boolean fixed = false;
                        if (!withNoise.sameAs(statsWithLowNoise)) {
                            statsWithLowNoise.copyFrom(withNoise);
                            fixed = true;
                        }
                        if (!noNoise.sameAs(statsNoLowNoise)) {
                            statsNoLowNoise.copyFrom(noNoise);
                            fixed = true;
                        }
                        if (fixed) {
                            SB_Transfers.updateErrorTooltip(gm, statsWithLowNoise);
                            SB_Transfers.updateErrorTooltip(gm, statsNoLowNoise);
                            SB_Transfers.refreshAllLibraries();
                        }
                    }
                }
            });
            return;
        }
    }

    private static void resetStats(GlobalManager gm, DownloadManagerListener listener, stats statsWithLowNoise, stats statsNoLowNoise) {
        List<DownloadManager> downloadManagers = gm.getDownloadManagers();
        for (DownloadManager dm : downloadManagers) {
            int dm_state;
            boolean lowNoise = PlatformTorrentUtils.isAdvancedViewOnly(dm);
            boolean assumed_complete = dm.getAssumedComplete();
            if (dm.isPersistent() && dm.getTorrent() != null && !assumed_complete) {
                long createTime = dm.getCreationTime();
                statsWithLowNoise.newestIncompleteDownloadTime = Math.max(statsWithLowNoise.newestIncompleteDownloadTime, createTime);
                if (!lowNoise) {
                    statsNoLowNoise.newestIncompleteDownloadTime = Math.max(statsNoLowNoise.newestIncompleteDownloadTime, createTime);
                }
            }
            if (listener != null) {
                dm.addListener(listener, false);
            }
            if ((dm_state = dm.getState()) == 70) {
                dm.setUserData("wasStopped", Boolean.TRUE);
                if (!dm.getAssumedComplete()) {
                    ++statsWithLowNoise.numStoppedIncomplete;
                }
                if (!lowNoise && !dm.getAssumedComplete()) {
                    ++statsNoLowNoise.numStoppedIncomplete;
                }
            } else {
                dm.setUserData("wasStopped", Boolean.FALSE);
            }
            if (dm_state == 75) {
                dm.setUserData("wasQueued", Boolean.TRUE);
                ++statsWithLowNoise.numQueued;
                if (!lowNoise) {
                    ++statsNoLowNoise.numQueued;
                }
            } else {
                dm.setUserData("wasQueued", Boolean.FALSE);
            }
            if (dm.getAssumedComplete()) {
                ++statsWithLowNoise.numComplete;
                if (!lowNoise) {
                    ++statsNoLowNoise.numComplete;
                }
                if (dm_state == 60) {
                    dm.setUserData("wasSeeding", Boolean.TRUE);
                    ++statsWithLowNoise.numSeeding;
                    if (!lowNoise) {
                        ++statsNoLowNoise.numSeeding;
                    }
                } else {
                    dm.setUserData("wasSeeding", Boolean.FALSE);
                }
            } else {
                ++statsWithLowNoise.numIncomplete;
                if (!lowNoise) {
                    ++statsNoLowNoise.numIncomplete;
                }
                if (dm_state == 50) {
                    ++statsWithLowNoise.numDownloading;
                    if (!lowNoise) {
                        ++statsNoLowNoise.numDownloading;
                    }
                }
            }
            if (PlatformTorrentUtils.getHasBeenOpened(dm) || !dm.getAssumedComplete()) continue;
            ++statsNoLowNoise.numUnOpened;
        }
        statsWithLowNoise.numUnOpened = statsNoLowNoise.numUnOpened;
    }

    private static void updateErrorTooltip(GlobalManager gm, stats stats2) {
        if (stats2.numErrorComplete < 0) {
            stats2.numErrorComplete = 0;
        }
        if (stats2.numErrorInComplete < 0) {
            stats2.numErrorInComplete = 0;
        }
        if (stats2.numErrorComplete > 0 || stats2.numErrorInComplete > 0) {
            String comp_error = null;
            String incomp_error = null;
            List<DownloadManager> downloads = gm.getDownloadManagers();
            for (int i = 0; i < downloads.size(); ++i) {
                DownloadManager download = downloads.get(i);
                if (download.getState() != 100) continue;
                if (download.getAssumedComplete()) {
                    if (comp_error == null) {
                        comp_error = download.getDisplayName() + ": " + download.getErrorDetails();
                        continue;
                    }
                    comp_error = comp_error + "...";
                    continue;
                }
                incomp_error = incomp_error == null ? download.getDisplayName() + ": " + download.getErrorDetails() : incomp_error + "...";
            }
            stats2.errorCompleteTooltip = comp_error;
            stats2.errorInCompleteTooltip = incomp_error;
        }
    }

    private static void RefreshCategorySideBar(Category category) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry entry = mdi.getEntry("Cat." + Base32.encode(category.getName().getBytes()));
        if (entry == null) {
            return;
        }
        ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
    }

    private static void setupCategory(final Category category) {
        ViewTitleInfo viewTitleInfo;
        MdiEntry entry;
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        String name = category.getName();
        String id = "Cat." + Base32.encode(name.getBytes());
        if (category.getType() != 0) {
            name = "{" + name + "}";
        }
        if ((entry = mdi.createEntryFromSkinRef("header.transfers", id, "library", name, viewTitleInfo = new ViewTitleInfo(){

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                List<DownloadManager> dms;
                if (propertyID == 0 && statsNoLowNoise.numIncomplete > 0 && (dms = category.getDownloadManagers(null)) != null) {
                    return "" + dms.size();
                }
                return null;
            }
        }, category, false, null)) != null) {
            entry.setImageLeftID("image.sidebar.library");
            entry.addListener(new MdiEntryDropListener(){

                @Override
                public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                    String type;
                    if (!(payload instanceof String)) {
                        return false;
                    }
                    String dropped = (String)payload;
                    String[] split = Constants.PAT_SPLIT_SLASH_N.split(dropped);
                    if (split.length > 1 && (type = split[0]).startsWith("DownloadManager")) {
                        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                        for (int i = 1; i < split.length; ++i) {
                            String hash = split[i];
                            try {
                                DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                                if (dm == null) continue;
                                TorrentUtil.assignToCategory(new Object[]{dm}, category);
                                continue;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                    }
                    return true;
                }
            });
        }
        if (entry instanceof SideBarEntrySWT) {
            SideBarEntrySWT entrySWT = (SideBarEntrySWT)entry;
            entrySWT.addListener(new MdiSWTMenuHackListener(){

                @Override
                public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
                    CategoryUIUtils.createMenuItems(menuTree, category);
                }
            });
        }
    }

    private static void removeCategory(Category category) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry entry = mdi.getEntry("Cat." + Base32.encode(category.getName().getBytes()));
        if (entry != null) {
            entry.close(true);
        }
    }

    private static void RefreshTagSideBar(Tag tag) {
        boolean[] old_auto_tag;
        boolean[] auto_tag;
        String tag_title;
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry entry = mdi.getEntry("Tag." + tag.getTagType().getTagType() + "." + tag.getTagID());
        if (entry == null) {
            if (tag.isVisible()) {
                SB_Transfers.setupTag(tag);
            }
            return;
        }
        if (!tag.isVisible()) {
            SB_Transfers.removeTag(tag);
            return;
        }
        String old_title = entry.getTitle();
        if (!old_title.equals(tag_title = tag.getTagName(true))) {
            entry.setTitle(tag_title);
        }
        ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
        Object[] tag_data = (Object[])entry.getUserData(TAG_DATA_KEY);
        if (tag_data != null && !Arrays.equals(auto_tag = tag.isTagAuto(), old_auto_tag = (boolean[])tag_data[1])) {
            tag_data[1] = auto_tag;
            if (auto_tag[0] && auto_tag[1]) {
                entry.removeListener((MdiEntryDropListener)tag_data[0]);
            } else {
                entry.addListener((MdiEntryDropListener)tag_data[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MdiEntry setupTag(final Tag tag) {
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return null;
        }
        Object object = tag_setup_lock;
        synchronized (object) {
            MdiEntry entry;
            String this_id;
            String id = "Tag." + tag.getTagType().getTagType() + "." + tag.getTagID();
            if (mdi.getEntry(id) != null) {
                return null;
            }
            TreeMap<Tag, String> name_map = new TreeMap<Tag, String>(TagUIUtils.getTagComparator());
            name_map.put(tag, id);
            for (Tag t : tag.getTagType().getTags()) {
                String tid;
                if (!t.isVisible() || mdi.getEntry(tid = "Tag." + tag.getTagType().getTagType() + "." + t.getTagID()) == null) continue;
                name_map.put(t, tid);
            }
            String prev_id = null;
            Iterator i$ = name_map.values().iterator();
            while (i$.hasNext() && (this_id = (String)i$.next()) != id) {
                prev_id = this_id;
            }
            if (prev_id == null && name_map.size() > 1) {
                Iterator it = name_map.values().iterator();
                it.next();
                prev_id = "~" + (String)it.next();
            }
            boolean auto = tag.getTagType().isTagTypeAuto();
            ViewTitleInfo viewTitleInfo = new ViewTitleInfo(){

                @Override
                public Object getTitleInfoProperty(int pid) {
                    if (pid == 0) {
                        return String.valueOf(tag.getTaggedCount());
                    }
                    if (pid == 8) {
                        TagType tag_type = tag.getTagType();
                        int[] def_color = tag_type.getColorDefault();
                        int[] tag_color = tag.getColor();
                        if (tag_color != def_color) {
                            return tag_color;
                        }
                    } else if (pid == 1) {
                        return TagUIUtils.getTagTooltip(tag);
                    }
                    return null;
                }
            };
            boolean closable = auto;
            if (tag.getTaggableTypes() == 2) {
                closable = true;
                String name = tag.getTagName(true);
                entry = mdi.createEntryFromSkinRef("header.transfers", id, "library", name, viewTitleInfo, tag, closable, prev_id);
            } else {
                entry = mdi.createEntryFromEventListener("header.transfers", new PeersGeneralView(tag), id, closable, null, prev_id);
                entry.setViewTitleInfo(viewTitleInfo);
            }
            if (closable) {
                entry.addListener(new MdiCloseListener(){

                    @Override
                    public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                        if (userClosed && entry.getUserData(AUTO_CLOSE_KEY) == null && COConfigurationManager.getBooleanParameter("Library.TagInSideBar")) {
                            tag.setVisible(false);
                        }
                    }
                });
            }
            if (entry != null) {
                String image_id = tag.getImageID();
                if (image_id != null) {
                    entry.setImageLeftID(image_id);
                } else if (tag.getTagType().getTagType() == 4) {
                    entry.setImageLeftID("image.sidebar.tag-red");
                } else if (tag.getTagType().isTagTypePersistent()) {
                    entry.setImageLeftID("image.sidebar.tag-green");
                } else {
                    entry.setImageLeftID("image.sidebar.tag-blue");
                }
            }
            if (entry instanceof SideBarEntrySWT) {
                SideBarEntrySWT entrySWT = (SideBarEntrySWT)entry;
                entrySWT.addListener(new MdiSWTMenuHackListener(){

                    @Override
                    public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
                        TagUIUtils.createSideBarMenuItems(menuTree, tag);
                    }
                });
            }
            if (!auto && entry != null) {
                MdiEntryDropListener dl = new MdiEntryDropListener(){

                    @Override
                    public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                        if (!(payload instanceof String)) {
                            return false;
                        }
                        boolean[] auto = tag.isTagAuto();
                        if (auto[0] && auto[1]) {
                            return false;
                        }
                        final String dropped = (String)payload;
                        new AEThread2("Tagger"){

                            @Override
                            public void run() {
                                this.dropTorrentOnTag(tag, dropped);
                            }
                        }.start();
                        return true;
                    }

                    private void dropTorrentOnTag(Tag tag2, String dropped) {
                        String[] split = Constants.PAT_SPLIT_SLASH_N.split(dropped);
                        if (split.length <= 1) {
                            return;
                        }
                        String type = split[0];
                        if (!type.startsWith("DownloadManager") && !type.startsWith("DiskManagerFileInfo")) {
                            return;
                        }
                        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                        ArrayList<DownloadManager> listDMs = new ArrayList<DownloadManager>();
                        boolean doAdd = false;
                        for (int i = 1; i < split.length; ++i) {
                            String hash = split[i];
                            int sep = hash.indexOf(";");
                            if (sep != -1) {
                                hash = hash.substring(0, sep);
                            }
                            try {
                                DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                                if (dm != null) {
                                    listDMs.add(dm);
                                    if (!doAdd && !tag2.hasTaggable(dm)) {
                                        doAdd = true;
                                    }
                                }
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            boolean[] auto = tag2.isTagAuto();
                            for (DownloadManager dm : listDMs) {
                                if (doAdd) {
                                    if (auto[0]) continue;
                                    tag2.addTaggable(dm);
                                    continue;
                                }
                                if (auto[0] && auto[1]) continue;
                                tag2.removeTaggable(dm);
                            }
                        }
                    }
                };
                boolean[] tag_auto = tag.isTagAuto();
                entry.setUserData(TAG_DATA_KEY, new Object[]{dl, tag_auto});
                if (!tag_auto[0] || !tag_auto[1]) {
                    entry.addListener(dl);
                }
            }
            return entry;
        }
    }

    private static void removeTag(Tag tag) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry entry = mdi.getEntry("Tag." + tag.getTagType().getTagType() + "." + tag.getTagID());
        if (entry != null) {
            entry.setUserData(AUTO_CLOSE_KEY, "");
            entry.close(true);
        }
    }

    private static int updateDMCounts(DownloadManager dm) {
        boolean isDownloading;
        boolean isSeeding;
        Boolean wasSeedingB = (Boolean)dm.getUserData("wasSeeding");
        boolean wasSeeding = wasSeedingB == null ? false : wasSeedingB;
        Boolean wasDownloadingB = (Boolean)dm.getUserData("wasDownloading");
        boolean wasDownloading = wasDownloadingB == null ? false : wasDownloadingB;
        Boolean wasStoppedB = (Boolean)dm.getUserData("wasStopped");
        boolean wasStopped = wasStoppedB == null ? false : wasStoppedB;
        Boolean wasQueuedB = (Boolean)dm.getUserData("wasQueued");
        boolean wasQueued = wasQueuedB == null ? false : wasQueuedB;
        int dm_state = dm.getState();
        if (dm.getAssumedComplete()) {
            isSeeding = dm_state == 60;
            isDownloading = false;
        } else {
            isDownloading = dm_state == 50;
            isSeeding = false;
        }
        boolean isStopped = dm_state == 70;
        boolean isQueued = dm_state == 75;
        boolean lowNoise = PlatformTorrentUtils.isAdvancedViewOnly(dm);
        if (isDownloading != wasDownloading) {
            if (isDownloading) {
                ++SB_Transfers.statsWithLowNoise.numDownloading;
                if (!lowNoise) {
                    ++SB_Transfers.statsNoLowNoise.numDownloading;
                }
            } else {
                --SB_Transfers.statsWithLowNoise.numDownloading;
                if (!lowNoise) {
                    --SB_Transfers.statsNoLowNoise.numDownloading;
                }
            }
            dm.setUserData("wasDownloading", isDownloading);
        }
        if (isSeeding != wasSeeding) {
            if (isSeeding) {
                ++SB_Transfers.statsWithLowNoise.numSeeding;
                if (!lowNoise) {
                    ++SB_Transfers.statsNoLowNoise.numSeeding;
                }
            } else {
                --SB_Transfers.statsWithLowNoise.numSeeding;
                if (!lowNoise) {
                    --SB_Transfers.statsNoLowNoise.numSeeding;
                }
            }
            dm.setUserData("wasSeeding", isSeeding);
        }
        if (isStopped != wasStopped) {
            if (isStopped) {
                if (!dm.getAssumedComplete()) {
                    ++SB_Transfers.statsWithLowNoise.numStoppedIncomplete;
                }
                if (!lowNoise && !dm.getAssumedComplete()) {
                    ++SB_Transfers.statsNoLowNoise.numStoppedIncomplete;
                }
            } else {
                if (!dm.getAssumedComplete()) {
                    --SB_Transfers.statsWithLowNoise.numStoppedIncomplete;
                }
                if (!lowNoise && !dm.getAssumedComplete()) {
                    --SB_Transfers.statsNoLowNoise.numStoppedIncomplete;
                }
            }
            dm.setUserData("wasStopped", isStopped);
        }
        if (isQueued != wasQueued) {
            if (isQueued) {
                ++SB_Transfers.statsWithLowNoise.numQueued;
                if (!lowNoise) {
                    ++SB_Transfers.statsNoLowNoise.numQueued;
                }
            } else {
                --SB_Transfers.statsWithLowNoise.numQueued;
                if (!lowNoise) {
                    --SB_Transfers.statsNoLowNoise.numQueued;
                }
            }
            dm.setUserData("wasQueued", isQueued);
        }
        return dm_state;
    }

    private static void recountUnopened() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        List<DownloadManager> dms = gm.getDownloadManagers();
        SB_Transfers.statsNoLowNoise.numUnOpened = 0;
        for (DownloadManager dm : dms) {
            if (PlatformTorrentUtils.getHasBeenOpened(dm) || !dm.getAssumedComplete()) continue;
            ++SB_Transfers.statsNoLowNoise.numUnOpened;
        }
        SB_Transfers.statsWithLowNoise.numUnOpened = SB_Transfers.statsNoLowNoise.numUnOpened;
    }

    protected static void addCountRefreshListener(countRefreshListener l) {
        l.countRefreshed(statsWithLowNoise, statsNoLowNoise);
        listeners.add(l);
    }

    public static void triggerCountRefreshListeners() {
        for (countRefreshListener l : listeners) {
            l.countRefreshed(statsWithLowNoise, statsNoLowNoise);
        }
    }

    private static void refreshAllLibraries() {
        refresh_limiter.dispatch();
    }

    private static void refreshAllLibrariesSupport() {
        String imageID;
        MdiEntryVitalityImage vitalityImage;
        int i;
        MdiEntryVitalityImage[] vitalityImages;
        MdiEntry entry;
        for (countRefreshListener l : listeners) {
            l.countRefreshed(statsWithLowNoise, statsNoLowNoise);
        }
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        if (SB_Transfers.statsNoLowNoise.numIncomplete > 0) {
            entry = mdi.getEntry("LibraryDL");
            if (entry == null) {
                mdi.loadEntryByID("LibraryDL", false);
            }
        } else {
            entry = mdi.getEntry("LibraryDL");
            if (entry != null) {
                entry.close(true);
            }
        }
        entry = mdi.getEntry("LibraryDL");
        if (entry != null) {
            vitalityImages = entry.getVitalityImages();
            for (i = 0; i < vitalityImages.length; ++i) {
                vitalityImage = vitalityImages[i];
                imageID = vitalityImage.getImageID();
                if (imageID == null) continue;
                if (imageID.equals(ID_VITALITY_ACTIVE)) {
                    vitalityImage.setVisible(SB_Transfers.statsNoLowNoise.numDownloading > 0);
                    continue;
                }
                if (!imageID.equals(ID_VITALITY_ALERT)) continue;
                vitalityImage.setVisible(SB_Transfers.statsNoLowNoise.numErrorInComplete > 0);
                if (SB_Transfers.statsNoLowNoise.numErrorInComplete <= 0) continue;
                vitalityImage.setToolTip(SB_Transfers.statsNoLowNoise.errorInCompleteTooltip);
            }
            ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
        }
        if ((entry = mdi.getEntry("LibraryCD")) != null) {
            vitalityImages = entry.getVitalityImages();
            for (i = 0; i < vitalityImages.length; ++i) {
                vitalityImage = vitalityImages[i];
                imageID = vitalityImage.getImageID();
                if (imageID == null || !imageID.equals(ID_VITALITY_ALERT)) continue;
                vitalityImage.setVisible(SB_Transfers.statsNoLowNoise.numErrorComplete > 0);
                if (SB_Transfers.statsNoLowNoise.numErrorComplete <= 0) continue;
                vitalityImage.setToolTip(SB_Transfers.statsNoLowNoise.errorCompleteTooltip);
            }
        }
        if ((entry = mdi.getEntry("LibraryUnopened")) != null) {
            ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
        }
    }

    public static String getTableIdFromFilterMode(int torrentFilterMode, boolean big) {
        if (torrentFilterMode == 1) {
            return big ? "MySeeders.big" : "MySeeders";
        }
        if (torrentFilterMode == 2) {
            return big ? "MyTorrents.big" : "MyTorrents";
        }
        if (torrentFilterMode == 0) {
            return "MyLibrary.big";
        }
        if (torrentFilterMode == 3) {
            return big ? "Unopened.big" : "Unopened";
        }
        return null;
    }

    static {
        SB_Transfers.statsNoLowNoise.includeLowNoise = false;
        SB_Transfers.statsWithLowNoise.includeLowNoise = true;
        tag_setup_lock = new Object();
        refresh_limiter = new FrequencyLimitedDispatcher(new AERunnable(){

            @Override
            public void runSupport() {
                SB_Transfers.refreshAllLibrariesSupport();
            }
        }, 250);
        refresh_limiter.setSingleThreaded();
    }

    protected static interface countRefreshListener {
        public void countRefreshed(stats var1, stats var2);
    }

    public static class stats {
        int numSeeding = 0;
        int numDownloading = 0;
        int numQueued = 0;
        int numComplete = 0;
        int numIncomplete = 0;
        int numErrorComplete = 0;
        String errorInCompleteTooltip;
        int numErrorInComplete = 0;
        String errorCompleteTooltip;
        int numUnOpened = 0;
        int numStoppedIncomplete = 0;
        boolean includeLowNoise;
        long newestIncompleteDownloadTime = 0L;

        private boolean sameAs(stats other) {
            return this.numSeeding == other.numSeeding && this.numDownloading == other.numDownloading && this.numQueued == other.numQueued && this.numComplete == other.numComplete && this.numIncomplete == other.numIncomplete && this.numErrorComplete == other.numErrorComplete && this.numErrorInComplete == other.numErrorInComplete && this.numUnOpened == other.numUnOpened && this.numStoppedIncomplete == other.numStoppedIncomplete && this.newestIncompleteDownloadTime == other.newestIncompleteDownloadTime;
        }

        private void copyFrom(stats other) {
            this.numSeeding = other.numSeeding;
            this.numDownloading = other.numDownloading;
            this.numQueued = other.numQueued;
            this.numComplete = other.numComplete;
            this.numIncomplete = other.numIncomplete;
            this.numErrorComplete = other.numErrorComplete;
            this.errorInCompleteTooltip = other.errorInCompleteTooltip;
            this.numErrorInComplete = other.numErrorInComplete;
            this.errorCompleteTooltip = other.errorCompleteTooltip;
            this.numUnOpened = other.numUnOpened;
            this.numStoppedIncomplete = other.numStoppedIncomplete;
            this.includeLowNoise = other.includeLowNoise;
            this.newestIncompleteDownloadTime = other.newestIncompleteDownloadTime;
        }
    }
}

