/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManager;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiChildCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryLoadedListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class SB_Discovery {
    private ArrayList<MdiEntry> children = new ArrayList();
    private ViewTitleInfo titleInfo;

    public SB_Discovery(MultipleDocumentInterface mdi) {
        this.setup(mdi);
    }

    private void setup(final MultipleDocumentInterface mdi) {
        MdiEntry entry = mdi.createEntryFromSkinRef("header.discovery", ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork()), "main.area.browsetab", "{sidebar.VuzeHDNetwork}", null, null, false, null);
        entry.setImageLeftID("image.sidebar.vuze");
        if (Constants.isWindows && FeatureAvailability.isGamesEnabled()) {
            mdi.registerEntry("Games", new MdiEntryCreationListener(){

                @Override
                public MdiEntry createMDiEntry(String id) {
                    MdiEntry entry = mdi.createEntryFromSkinRef("header.discovery", "Games", "main.generic.browse", "{mdi.entry.games}", null, null, true, null);
                    ((BaseMdiEntry)entry).setPreferredAfterID(ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork()));
                    String url = ConstantsVuze.getDefaultContentNetwork().getSiteRelativeURL("starts/games.start", false);
                    entry.setDatasource(url);
                    entry.setImageLeftID("image.sidebar.games");
                    return entry;
                }
            });
            mdi.loadEntryByID("Games", false, true, null);
        }
        mdi.registerEntry("ContentNetwork\\..*", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                long networkID = Long.parseLong(id.substring(15));
                return SB_Discovery.this.handleContentNetworkSwitch(mdi, id, networkID);
            }
        });
        mdi.addListener(new MdiEntryLoadedListener(){

            @Override
            public void mdiEntryLoaded(MdiEntry entry) {
                if ("header.discovery".equals(entry.getParentID())) {
                    SB_Discovery.this.children.add(entry);
                    entry.addListener(new MdiChildCloseListener(){

                        @Override
                        public void mdiChildEntryClosed(MdiEntry parent, MdiEntry child, boolean user) {
                            SB_Discovery.this.children.remove(child);
                        }
                    });
                }
                if (!entry.getId().equals("header.discovery")) {
                    return;
                }
                SB_Discovery.this.setupHeader(entry);
            }
        });
    }

    private void setupHeader(final MdiEntry entry) {
        this.titleInfo = new ViewTitleInfo(){

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    MdiEntry[] entries;
                    if (entry.isExpanded()) {
                        return null;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (MdiEntry subEntry : entries = entry.getMDI().getEntries()) {
                        Object text;
                        ViewTitleInfo titleInfo;
                        if (subEntry.getId().startsWith("Subscription_") || !entry.getId().equals(subEntry.getParentID()) || (titleInfo = subEntry.getViewTitleInfo()) == null || !((text = titleInfo.getTitleInfoProperty(0)) instanceof String)) continue;
                        if (sb.length() > 0) {
                            sb.append(" | ");
                        }
                        sb.append(text);
                    }
                    if (sb.length() > 0) {
                        return sb.toString();
                    }
                } else if (propertyID == 1) {
                    MdiEntry[] entries;
                    if (entry.isExpanded()) {
                        return null;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (MdiEntry subEntry : entries = entry.getMDI().getEntries()) {
                        Object text;
                        ViewTitleInfo titleInfo;
                        if (!entry.getId().equals(subEntry.getParentID()) || (titleInfo = subEntry.getViewTitleInfo()) == null || !((text = titleInfo.getTitleInfoProperty(0)) instanceof String)) continue;
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(subEntry.getTitle()).append(": ").append(text);
                    }
                    if (sb.length() > 0) {
                        return sb.toString();
                    }
                }
                return null;
            }
        };
        entry.setViewTitleInfo(this.titleInfo);
    }

    protected BaseMdiEntry handleContentNetworkSwitch(MultipleDocumentInterface mdi, String tabID, long networkID) {
        String defaultID = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        try {
            ContentNetworkManager cnManager = ContentNetworkManagerFactory.getSingleton();
            if (cnManager == null) {
                mdi.showEntryByID(defaultID);
                return null;
            }
            ContentNetwork cn = cnManager.getContentNetwork(networkID);
            if (cn == null) {
                mdi.showEntryByID(defaultID);
                return null;
            }
            if (networkID == 1L) {
                mdi.showEntryByID(defaultID);
                cn.setPersistentProperty("active", Boolean.TRUE);
                return null;
            }
            return this.createContentNetworkSideBarEntry(mdi, cn);
        }
        catch (Exception e) {
            Debug.out(e);
            mdi.showEntryByID(defaultID);
            return null;
        }
    }

    private BaseMdiEntry createContentNetworkSideBarEntry(MultipleDocumentInterface mdi, ContentNetwork cn) {
        String entryID = ContentNetworkUtils.getTarget(cn);
        if (mdi.entryExists(entryID)) {
            return null;
        }
        String name = cn.getName();
        Object prop = cn.getProperty(2);
        boolean closeable = prop instanceof Boolean ? (Boolean)prop : false;
        BaseMdiEntry entry = (BaseMdiEntry)mdi.createEntryFromSkinRef("header.discovery", entryID, "main.area.browsetab", name, null, cn, closeable, null);
        Image image = ImageLoader.getInstance().getImage("image.sidebar.vuze");
        entry.setImageLeft(image);
        cn.setPersistentProperty("active", Boolean.TRUE);
        cn.setPersistentProperty("in_menu", Boolean.TRUE);
        return entry;
    }
}

