/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagManagerListener;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.util.RegExUtil;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.table.impl.TableViewImpl;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagAggregateSR;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagAggregateSRMax;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagColor;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagCopyOnComp;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagCount;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagDownLimit;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagDownRate;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagDownSession;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagDownTotal;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagGroup;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagInitialSaveLocation;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagLimits;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagMaxSR;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagMinSR;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagMoveOnComp;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagName;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagProperties;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagPublic;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagRSSFeed;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagType;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagUpLimit;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagUpRate;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagUpSession;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagUpTotal;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagUploadPriority;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagVisible;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagXCode;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.utils.TagUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.InfoBarUtil;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSubView;
import org.gudy.azureus2.ui.swt.views.TagSettingsView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

public class SBC_TagsOverview
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<Tag>,
TagManagerListener,
TagTypeListener,
TableViewSWTMenuFillListener,
TableSelectionListener {
    private static final String TABLE_TAGS = "TagsView";
    TableViewSWT<Tag> tv;
    private Text txtFilter;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private boolean tm_listener_added;
    private boolean registeredCoreSubViews;
    private Object datasource;

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        Object[] datasources;
        boolean isTableSelected = false;
        if (this.tv instanceof TableViewImpl) {
            isTableSelected = ((TableViewImpl)((Object)this.tv)).isTableSelected();
        }
        if (!isTableSelected) {
            UIPluginViewToolBarListener l;
            MdiEntrySWT active_view = this.getActiveView();
            return active_view != null && (l = active_view.getToolBarListener()) != null && l.toolBarItemActivated(item, activationType, datasource);
        }
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        if (item.getID().equals("remove") && (datasources = this.tv.getSelectedDataSources().toArray()).length > 0) {
            for (Object object : datasources) {
                Tag tag;
                if (!(object instanceof Tag) || (tag = (Tag)object).getTagType().getTagType() != 3) continue;
                MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{tag.getTagName(true)}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        if (result == 0) {
                            tag.removeTag();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private MdiEntrySWT getActiveView() {
        TableViewSWT_TabsCommon tabsCommon = this.tv.getTabsCommon();
        if (tabsCommon != null) {
            return tabsCommon.getActiveSubView();
        }
        return null;
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible()) {
            return;
        }
        boolean canEnable = false;
        Object[] datasources = this.tv.getSelectedDataSources().toArray();
        if (datasources.length > 0) {
            for (Object object : datasources) {
                Tag tag;
                if (!(object instanceof Tag) || (tag = (Tag)object).getTagType().getTagType() != 3) continue;
                canEnable = true;
                break;
            }
        }
        list.put("remove", canEnable ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return TABLE_TAGS;
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.initColumns();
        SWTSkinObjectButton soAddTagButton = (SWTSkinObjectButton)this.getSkinObject("add-tag");
        if (soAddTagButton != null) {
            soAddTagButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    TagUIUtilsV3.showCreateTagDialog(null);
                }
            });
        }
        new InfoBarUtil(skinObject, "tagsview.infobar", false, "tags.infobar", "tags.view.infobar"){

            @Override
            public boolean allowShow() {
                return true;
            }
        };
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_TagsOverview> clazz = SBC_TagsOverview.class;
        synchronized (SBC_TagsOverview.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(Tag.class, ColumnTagCount.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagCount(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagColor.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagColor(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagName.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagName(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagType.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagType(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagPublic.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagPublic(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUpRate.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUpRate(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagDownRate.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDownRate(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUpLimit.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUpLimit(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagDownLimit.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDownLimit(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUpSession.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUpSession(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagDownSession.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDownSession(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUpTotal.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUpTotal(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagDownTotal.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDownTotal(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagRSSFeed.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagRSSFeed(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagUploadPriority.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagUploadPriority(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagMinSR.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagMinSR(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagMaxSR.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagMaxSR(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagAggregateSR.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagAggregateSR(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagAggregateSRMax.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagAggregateSRMax(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagXCode.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagXCode(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagInitialSaveLocation.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagInitialSaveLocation(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagMoveOnComp.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagMoveOnComp(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagCopyOnComp.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagCopyOnComp(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagProperties.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagProperties(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagVisible.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagVisible(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagGroup.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagGroup(column);
                }
            });
            tableManager.registerColumn(Tag.class, ColumnTagLimits.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagLimits(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_TAGS, new String[]{ColumnTagColor.COLUMN_ID, ColumnTagName.COLUMN_ID, ColumnTagCount.COLUMN_ID, ColumnTagType.COLUMN_ID, ColumnTagPublic.COLUMN_ID, ColumnTagUpRate.COLUMN_ID, ColumnTagDownRate.COLUMN_ID, ColumnTagUpLimit.COLUMN_ID, ColumnTagDownLimit.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_TAGS, ColumnTagName.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(new Object[]{this.table_parent});
        TagManager tagManager = TagManagerFactory.getTagManager();
        if (tagManager != null) {
            List<TagType> tagTypes = tagManager.getTagTypes();
            for (TagType tagType : tagTypes) {
                tagType.removeTagTypeListener(this);
            }
            tagManager.removeTagManagerListener(this);
            this.tm_listener_added = false;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        SWTSkinObject so_list;
        super.skinObjectShown(skinObject, params);
        SWTSkinObjectTextbox soFilter = (SWTSkinObjectTextbox)this.getSkinObject("filterbox");
        if (soFilter != null) {
            this.txtFilter = soFilter.getTextControl();
        }
        if ((so_list = this.getSkinObject("tags-list")) == null) {
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        TagManager tagManager = TagManagerFactory.getTagManager();
        if (tagManager != null && !this.tm_listener_added) {
            this.tm_listener_added = true;
            tagManager.addTagManagerListener(this, true);
        }
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.tm_listener_added) {
            this.tm_listener_added = false;
            TagManager tagManager = TagManagerFactory.getTagManager();
            tagManager.removeTagManagerListener(this);
            for (TagType tt : tagManager.getTagTypes()) {
                tt.removeTagTypeListener(this);
            }
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            UISWTInstance pluginUI = uiFunctions.getUISWTInstance();
            this.registerPluginViews(pluginUI);
        }
        if (this.tv == null) {
            this.tv = TableViewFactory.createTableViewSWT(Tag.class, TABLE_TAGS, TABLE_TAGS, new TableColumnCore[0], ColumnTagName.COLUMN_ID, 0x10010002);
            if (this.txtFilter != null) {
                this.tv.enableFilterCheck(this.txtFilter, this);
            }
            this.tv.setRowDefaultHeightEM(1.0f);
            this.tv.setEnableTabViews(true, true, null);
            this.table_parent = new Composite(control, 2048);
            this.table_parent.setLayoutData(Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout(layout);
            this.table_parent.addListener(26, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    SBC_TagsOverview.this.updateSelectedContent();
                }
            });
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.initialize(this.table_parent);
            this.tv.addCountChangeListener(new TableCountChangeListener(){

                @Override
                public void rowRemoved(TableRowCore row) {
                }

                @Override
                public void rowAdded(TableRowCore row) {
                    if (SBC_TagsOverview.this.datasource == row.getDataSource()) {
                        SBC_TagsOverview.this.tv.setSelectedRows(new TableRowCore[]{row});
                    }
                }
            });
        }
        control.layout(true);
    }

    private void registerPluginViews(UISWTInstance pluginUI) {
        if (this.registeredCoreSubViews) {
            return;
        }
        pluginUI.addView(TABLE_TAGS, "TagSettingsView", TagSettingsView.class, null);
        pluginUI.addView(TABLE_TAGS, "MyTorrentsSubView", MyTorrentsSubView.class, null);
        this.registeredCoreSubViews = true;
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        final ArrayList<TagFeatureRateLimit> tags_su = new ArrayList<TagFeatureRateLimit>();
        final ArrayList<TagFeatureRateLimit> tags_sd = new ArrayList<TagFeatureRateLimit>();
        for (Object obj : ds) {
            long[] down;
            TagFeatureRateLimit rl;
            if (!(obj instanceof Tag)) continue;
            Tag tag = (Tag)obj;
            tags.add(tag);
            if (!(tag instanceof TagFeatureRateLimit) || !(rl = (TagFeatureRateLimit)((Object)tag)).supportsTagRates()) continue;
            long[] up = rl.getTagSessionUploadTotal();
            if (up != null) {
                tags_su.add(rl);
            }
            if ((down = rl.getTagSessionDownloadTotal()) == null) continue;
            tags_sd.add(rl);
        }
        if (sColumnName.equals(ColumnTagUpSession.COLUMN_ID) && tags_su.size() > 0 || sColumnName.equals(ColumnTagDownSession.COLUMN_ID) && tags_sd.size() > 0) {
            final boolean is_up = sColumnName.equals(ColumnTagUpSession.COLUMN_ID);
            MenuItem mi = new MenuItem(menu, 8);
            Messages.setLanguageText(mi, "menu.reset.session.stats");
            mi.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    for (TagFeatureRateLimit rl : is_up ? tags_su : tags_sd) {
                        if (is_up) {
                            rl.resetTagSessionUploadTotal();
                            continue;
                        }
                        rl.resetTagSessionDownloadTotal();
                    }
                }
            });
            MenuFactory.addSeparatorMenuItem(menu);
        }
        if (tags.size() == 1) {
            TagUIUtils.createSideBarMenuItems(menu, (Tag)tags.get(0));
        } else {
            TagUIUtils.createSideBarMenuItems(menu, tags);
        }
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    @Override
    public void selected(TableRowCore[] row) {
        this.updateSelectedContent();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        this.updateSelectedContent();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        Object obj;
        if (rows.length == 1 && (obj = rows[0].getDataSource()) instanceof Tag) {
            Tag tag = (Tag)obj;
            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
            if (uiFunctions != null) {
                if (!COConfigurationManager.getBooleanParameter("Library.TagInSideBar")) {
                    COConfigurationManager.setParameter("Library.TagInSideBar", true);
                }
                if (!tag.isVisible()) {
                    tag.setVisible(true);
                }
                String id = "Tag." + tag.getTagType().getTagType() + "." + tag.getTagID();
                uiFunctions.getMDI().showEntryByID(id, tag);
            }
        }
    }

    public void updateSelectedContent() {
        this.updateSelectedContent(false);
    }

    public void updateSelectedContent(boolean force) {
        if (this.table_parent == null || this.table_parent.isDisposed()) {
            return;
        }
        if (!this.isVisible() && !force) {
            return;
        }
        SelectedContentManager.clearCurrentlySelectedContent();
        SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), null, this.tv);
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public boolean filterCheck(Tag ds, String filter2, boolean regex) {
        Pattern pattern;
        String name = ds.getTagName(true);
        String s = regex ? filter2 : "\\Q" + filter2.replaceAll("\\s*[|;]\\s*", "\\\\E|\\\\Q") + "\\E";
        boolean match_result = true;
        if (regex && s.startsWith("!")) {
            s = s.substring(1);
            match_result = false;
        }
        return (pattern = RegExUtil.getCachedPattern("tagsoverview:search", s, 2)).matcher(name).find() == match_result;
    }

    @Override
    public void tagTypeAdded(TagManager manager, TagType tag_type) {
        tag_type.addTagTypeListener(this, true);
    }

    @Override
    public void tagTypeRemoved(TagManager manager, TagType tag_type) {
        tag_type.removeTagTypeListener(this);
    }

    @Override
    public void tagTypeChanged(TagType tag_type) {
        this.tv.tableInvalidate();
    }

    @Override
    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
        int type = event2.getEventType();
        Tag tag = event2.getTag();
        if (type == 0) {
            this.tagAdded(tag);
        } else if (type == 1) {
            this.tagChanged(tag);
        } else if (type == 2) {
            this.tagRemoved(tag);
        }
    }

    public void tagAdded(Tag tag) {
        this.tv.addDataSource(tag);
        this.handleProps(tag);
    }

    public void tagChanged(Tag tag) {
        if (this.tv == null || this.tv.isDisposed()) {
            return;
        }
        TableRowCore row = this.tv.getRow(tag);
        if (row != null) {
            row.invalidate(true);
        }
        this.handleProps(tag);
    }

    private void handleProps(Tag tag) {
        Boolean b = (Boolean)tag.getTransientProperty("Settings Requested");
        if (b != null && b.booleanValue()) {
            tag.setTransientProperty("Settings Requested", null);
            this.tv.processDataSourceQueueSync();
            TableRowCore row = this.tv.getRow(tag);
            if (row == null) {
                Debug.out("Can't select settings view for " + tag.getTagName(true) + " as row not found");
            } else {
                this.tv.setSelectedRows(new TableRowCore[]{row});
            }
        }
    }

    public void tagRemoved(Tag tag) {
        this.tv.removeDataSource(tag);
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        TableRowCore row;
        if (params instanceof Tag && this.tv != null && (row = this.tv.getRow((Tag)params)) != null) {
            this.tv.setSelectedRows(new TableRowCore[]{row});
        }
        this.datasource = params;
        return null;
    }

    @Override
    public Object skinObjectSelected(SWTSkinObject skinObject, Object params) {
        this.updateSelectedContent();
        return super.skinObjectSelected(skinObject, params);
    }
}

