/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.RegExUtil;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableColumnCoreCreationListener;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.columns.dlhistory.ColumnDLHistoryAddDate;
import com.aelitis.azureus.ui.swt.columns.dlhistory.ColumnDLHistoryCompleteDate;
import com.aelitis.azureus.ui.swt.columns.dlhistory.ColumnDLHistoryHash;
import com.aelitis.azureus.ui.swt.columns.dlhistory.ColumnDLHistoryName;
import com.aelitis.azureus.ui.swt.columns.dlhistory.ColumnDLHistoryRemoveDate;
import com.aelitis.azureus.ui.swt.columns.dlhistory.ColumnDLHistorySaveLocation;
import com.aelitis.azureus.ui.swt.columns.dlhistory.ColumnDLHistorySize;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.history.DownloadHistory;
import org.gudy.azureus2.core3.history.DownloadHistoryEvent;
import org.gudy.azureus2.core3.history.DownloadHistoryListener;
import org.gudy.azureus2.core3.history.DownloadHistoryManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class SBC_DownloadHistoryView
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<DownloadHistory>,
TableViewSWTMenuFillListener,
TableSelectionListener,
DownloadHistoryListener {
    private static final String TABLE_NAME = "DownloadHistory";
    private static final DownloadHistoryManager dh_manager = (DownloadHistoryManager)AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadHistoryManager();
    private TableViewSWT<DownloadHistory> tv;
    private Text txtFilter;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private boolean dh_listener_added;
    private Object datasource;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.initColumns();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_DownloadHistoryView> clazz = SBC_DownloadHistoryView.class;
        synchronized (SBC_DownloadHistoryView.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryName.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryName(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryAddDate.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(DownloadHistory.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryAddDate(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryCompleteDate.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(DownloadHistory.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryCompleteDate(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryRemoveDate.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(DownloadHistory.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryRemoveDate(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryHash.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryHash(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistorySize.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistorySize(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistorySaveLocation.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistorySaveLocation(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_NAME, new String[]{ColumnDLHistoryName.COLUMN_ID, ColumnDLHistoryAddDate.COLUMN_ID, ColumnDLHistoryCompleteDate.COLUMN_ID, ColumnDLHistoryRemoveDate.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_NAME, ColumnDLHistoryName.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(new Object[]{this.table_parent});
        if (this.dh_listener_added) {
            dh_manager.removeListener(this);
            this.dh_listener_added = false;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        SWTSkinObject so_list;
        super.skinObjectShown(skinObject, params);
        SWTSkinObjectTextbox soFilter = (SWTSkinObjectTextbox)this.getSkinObject("filterbox");
        if (soFilter != null) {
            this.txtFilter = soFilter.getTextControl();
        }
        if ((so_list = this.getSkinObject("dl-history-list")) == null) {
            System.out.println("NO dl-history-list");
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        if (dh_manager != null) {
            dh_manager.addListener(this, true);
            this.dh_listener_added = true;
        }
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.dh_listener_added) {
            dh_manager.removeListener(this);
            this.dh_listener_added = false;
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        if (this.tv == null) {
            this.tv = TableViewFactory.createTableViewSWT(DownloadHistory.class, TABLE_NAME, TABLE_NAME, new TableColumnCore[0], ColumnDLHistoryName.COLUMN_ID, 0x10010002);
            if (this.txtFilter != null) {
                this.tv.enableFilterCheck(this.txtFilter, this);
            }
            this.tv.setRowDefaultHeightEM(1.0f);
            this.tv.setEnableTabViews(true, true, null);
            this.table_parent = new Composite(control, 2048);
            this.table_parent.setLayoutData(Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout(layout);
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.initialize(this.table_parent);
            this.tv.addCountChangeListener(new TableCountChangeListener(){

                @Override
                public void rowRemoved(TableRowCore row) {
                }

                @Override
                public void rowAdded(TableRowCore row) {
                    if (SBC_DownloadHistoryView.this.datasource == row.getDataSource()) {
                        SBC_DownloadHistoryView.this.tv.setSelectedRows(new TableRowCore[]{row});
                    }
                }
            });
            if (dh_manager == null) {
                control.setEnabled(false);
            }
        }
        control.layout(true);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (this.tv == null || !this.tv.isVisible() || dh_manager == null) {
            return false;
        }
        List<Object> datasources = this.tv.getSelectedDataSources();
        if (datasources.size() > 0) {
            ArrayList<DownloadHistory> dms = new ArrayList<DownloadHistory>(datasources.size());
            for (Object o : datasources) {
                dms.add((DownloadHistory)o);
            }
            String id = item.getID();
            if (id.equals("remove")) {
                dh_manager.removeHistory(dms);
            } else if (id.equals("startstop")) {
                for (DownloadHistory download : dms) {
                    download.setRedownloading();
                    String magnet = UrlUtils.getMagnetURI(download.getTorrentHash(), download.getName(), null);
                    TorrentOpener.openTorrent(magnet);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible() || dh_manager == null) {
            return;
        }
        boolean canEnable = false;
        boolean canStart = false;
        Object[] datasources = this.tv.getSelectedDataSources().toArray();
        if (datasources.length > 0) {
            canEnable = true;
            canStart = true;
        }
        list.put("remove", canEnable ? 1L : 0L);
        list.put("start", canStart ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return TABLE_NAME;
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menu) {
        if (dh_manager != null) {
            new MenuItem(menu, 2);
            if (dh_manager.isEnabled()) {
                MenuItem itemReset = new MenuItem(menu, 8);
                Messages.setLanguageText(itemReset, "label.reset.history");
                itemReset.addListener(13, new Listener(){

                    @Override
                    public void handleEvent(Event event2) {
                        SBC_DownloadHistoryView.this.resetHistory();
                    }
                });
                MenuItem itemDisable = new MenuItem(menu, 8);
                Messages.setLanguageText(itemDisable, "label.disable.history");
                itemDisable.addListener(13, new Listener(){

                    @Override
                    public void handleEvent(Event event2) {
                        dh_manager.setEnabled(false);
                    }
                });
            } else {
                MenuItem itemEnable = new MenuItem(menu, 8);
                Messages.setLanguageText(itemEnable, "label.enable.history");
                itemEnable.addListener(13, new Listener(){

                    @Override
                    public void handleEvent(Event event2) {
                        dh_manager.setEnabled(true);
                    }
                });
            }
            new MenuItem(menu, 2);
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        if (dh_manager != null && dh_manager.isEnabled()) {
            List<Object> ds = this.tv.getSelectedDataSources();
            final ArrayList<DownloadHistory> dms = new ArrayList<DownloadHistory>(ds.size());
            for (Object o : ds) {
                dms.add((DownloadHistory)o);
            }
            boolean hasSelection = dms.size() > 0;
            final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
            MenuItem itemExplore = new MenuItem(menu, 8);
            Messages.setLanguageText(itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
            itemExplore.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    for (DownloadHistory download : dms) {
                        ManagerUtils.open(new File(download.getSaveLocation()), use_open_containing_folder);
                    }
                }
            });
            itemExplore.setEnabled(hasSelection);
            MenuItem itemRedownload = new MenuItem(menu, 8);
            Messages.setLanguageText(itemRedownload, "label.redownload");
            itemRedownload.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    for (DownloadHistory download : dms) {
                        download.setRedownloading();
                        String magnet = UrlUtils.getMagnetURI(download.getTorrentHash(), download.getName(), null);
                        TorrentOpener.openTorrent(magnet);
                    }
                }
            });
            itemExplore.setEnabled(hasSelection);
            MenuItem itemRemove = new MenuItem(menu, 8);
            Utils.setMenuItemImage(itemRemove, "delete");
            Messages.setLanguageText(itemRemove, "MySharesView.menu.remove");
            itemRemove.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    dh_manager.removeHistory(dms);
                }
            });
            itemRemove.setEnabled(hasSelection);
            new MenuItem(menu, 2);
            MenuItem itemReset = new MenuItem(menu, 8);
            Messages.setLanguageText(itemReset, "label.reset.history");
            itemReset.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    SBC_DownloadHistoryView.this.resetHistory();
                }
            });
            MenuItem itemDisable = new MenuItem(menu, 8);
            Messages.setLanguageText(itemDisable, "label.disable.history");
            itemDisable.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    dh_manager.setEnabled(false);
                }
            });
            new MenuItem(menu, 2);
        }
    }

    private void resetHistory() {
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("downloadhistoryview.reset.title"), MessageText.getString("downloadhistoryview.reset.text"));
        mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
        mb.open(new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                if (result == 0) {
                    dh_manager.resetHistory();
                }
            }
        });
    }

    @Override
    public void selected(TableRowCore[] row) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
    }

    @Override
    public void downloadHistoryEventOccurred(DownloadHistoryEvent event2) {
        int type = event2.getEventType();
        List<DownloadHistory> dls = event2.getHistory();
        if (type == 1) {
            this.tv.addDataSources((DownloadHistory[])dls.toArray(new DownloadHistory[dls.size()]));
        } else if (type == 2) {
            this.tv.removeDataSources((DownloadHistory[])dls.toArray(new DownloadHistory[dls.size()]));
        } else {
            for (DownloadHistory d : dls) {
                TableRowCore row = this.tv.getRow(d);
                if (row == null) continue;
                row.invalidate(true);
            }
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public boolean filterCheck(DownloadHistory ds, String filter2, boolean regex) {
        boolean bOurs;
        Object o_name;
        if (filter2.startsWith("t:")) {
            filter2 = filter2.substring(2);
            byte[] hash = ds.getTorrentHash();
            ArrayList<String> names = new ArrayList<String>();
            names.add(ByteFormatter.encodeString(hash));
            names.add(Base32.encode(hash));
            o_name = names;
        } else {
            o_name = ds.getName();
        }
        String s = regex ? filter2 : "\\Q" + filter2.replaceAll("\\s*[|;]\\s*", "\\\\E|\\\\Q") + "\\E";
        boolean match_result = true;
        if (regex && s.startsWith("!")) {
            s = s.substring(1);
            match_result = false;
        }
        Pattern pattern = RegExUtil.getCachedPattern("downloadhistoryview:search", s, 2);
        if (o_name instanceof String) {
            bOurs = pattern.matcher((CharSequence)o_name).find() == match_result;
        } else {
            List names = (List)o_name;
            bOurs = !match_result;
            for (String name : names) {
                if (!pattern.matcher(name).find()) continue;
                bOurs = match_result;
                break;
            }
        }
        return bOurs;
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        TableRowCore row;
        if (params instanceof DownloadHistory && this.tv != null && (row = this.tv.getRow((DownloadHistory)params)) != null) {
            this.tv.setSelectedRows(new TableRowCore[]{row});
        }
        this.datasource = params;
        return null;
    }
}

