/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesListener;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.columns.utils.TableColumnCreatorV3;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUIListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;

public class SBC_ActivityTableView
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
VuzeActivitiesListener {
    private static int[] COLOR_UNVIEWED_ENTRIES = new int[]{132, 16, 58};
    private TableViewSWT<VuzeActivitiesEntry> view;
    private String tableID;
    private Composite viewComposite;
    private int viewMode = 0;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        skinObject.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, SBC_ActivityTableView.this.getCurrentlySelectedContent(), SBC_ActivityTableView.this.view);
                } else if (eventType == 1) {
                    SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, null, SBC_ActivityTableView.this.view);
                }
                return null;
            }
        });
        SWTSkinObject soParent = skinObject.getParent();
        Object data = soParent.getControl().getData("ViewMode");
        if (data instanceof Long) {
            this.viewMode = (int)((Long)data).longValue();
        }
        boolean big = this.viewMode == -1;
        this.tableID = big ? "Activity.big" : "Activity";
        TableColumnCore[] columns = big ? TableColumnCreatorV3.createActivityBig(this.tableID) : TableColumnCreatorV3.createActivitySmall(this.tableID);
        this.view = TableViewFactory.createTableViewSWT(VuzeActivitiesEntry.class, this.tableID, this.tableID, columns, "name", 0x10010002);
        this.view.setRowDefaultHeightEM(big ? 3.0f : 2.0f);
        this.view.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    SBC_ActivityTableView.this.removeSelected();
                } else if (e.keyCode == 0x100000E) {
                    if ((e.stateMask & 0x20000) != 0) {
                        VuzeActivitiesManager.resetRemovedEntries();
                    }
                    if ((e.stateMask & 0x40000) != 0) {
                        System.out.println("pull all vuze news entries");
                        VuzeActivitiesManager.clearLastPullTimes();
                        VuzeActivitiesManager.pullActivitiesNow(0L, "^F5", true);
                    } else {
                        System.out.println("pull latest vuze news entries");
                        VuzeActivitiesManager.pullActivitiesNow(0L, "F5", true);
                    }
                }
            }
        });
        this.view.addSelectionListener(new TableSelectionAdapter(){

            @Override
            public void selected(TableRowCore[] rows) {
                this.selectionChanged();
                for (int i = 0; i < rows.length; ++i) {
                    VuzeActivitiesEntry entry = (VuzeActivitiesEntry)rows[i].getDataSource(true);
                    if (entry == null || entry.isRead() || !entry.canFlipRead()) continue;
                    entry.setRead(true);
                }
            }

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                if (rows.length == 1) {
                    VuzeActivitiesEntry ds = (VuzeActivitiesEntry)rows[0].getDataSource();
                    if (ds.getTypeID().equals("LOCAL_NEWS_ITEM")) {
                        String[] actions = ds.getActions();
                        if (actions.length == 1) {
                            ds.invokeCallback(actions[0]);
                        }
                    } else {
                        TorrentListViewsUtils.playOrStreamDataSource(ds, false);
                    }
                }
            }

            @Override
            public void deselected(TableRowCore[] rows) {
                this.selectionChanged();
            }

            public void selectionChanged() {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        ISelectedContent[] contents = SBC_ActivityTableView.this.getCurrentlySelectedContent();
                        if (SBC_ActivityTableView.this.soMain.isVisible()) {
                            SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, contents, SBC_ActivityTableView.this.view);
                        }
                    }
                });
            }
        }, false);
        this.view.addLifeCycleListener(new TableLifeCycleListener(){

            @Override
            public void tableViewInitialized() {
                SBC_ActivityTableView.this.view.addDataSources(VuzeActivitiesManager.getAllEntries().toArray(new VuzeActivitiesEntry[0]));
            }

            @Override
            public void tableViewDestroyed() {
            }
        });
        SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), this.getUpdateUIName(), "", this.soMain);
        this.skin.layout();
        this.viewComposite = soContents.getComposite();
        this.viewComposite.setBackground(this.viewComposite.getDisplay().getSystemColor(22));
        this.viewComposite.setForeground(this.viewComposite.getDisplay().getSystemColor(21));
        this.viewComposite.setLayoutData(Utils.getFilledFormData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.viewComposite.setLayout(gridLayout);
        this.view.initialize(this.viewComposite);
        VuzeActivitiesManager.addListener(this);
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.view != null) {
            this.view.delete();
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public String getUpdateUIName() {
        return this.tableID;
    }

    @Override
    public void updateUI() {
        if (this.view != null) {
            this.view.refreshTable(false);
        }
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        list.put("remove", this.isVisible() && this.view != null && this.view.getSelectedRowsSize() > 0 ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (item.getID().equals("remove")) {
            this.removeSelected();
            return true;
        }
        return false;
    }

    public ISelectedContent[] getCurrentlySelectedContent() {
        if (this.view == null) {
            return null;
        }
        ArrayList<SelectedContentV3> listContent = new ArrayList<SelectedContentV3>();
        Object[] selectedDataSources = this.view.getSelectedDataSources(true);
        for (int i = 0; i < selectedDataSources.length; ++i) {
            VuzeActivitiesEntry ds = (VuzeActivitiesEntry)selectedDataSources[i];
            if (ds == null) continue;
            try {
                SelectedContentV3 currentContent = ds.createSelectedContentObject();
                if (currentContent == null) continue;
                listContent.add(currentContent);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listContent.toArray(new ISelectedContent[listContent.size()]);
    }

    @Override
    public void vuzeNewsEntriesAdded(VuzeActivitiesEntry[] entries) {
        if (this.view != null) {
            this.view.addDataSources((VuzeActivitiesEntry[])entries);
        }
    }

    @Override
    public void vuzeNewsEntriesRemoved(VuzeActivitiesEntry[] entries) {
        if (this.view != null) {
            this.view.removeDataSources((VuzeActivitiesEntry[])entries);
            this.view.processDataSourceQueue();
        }
    }

    @Override
    public void vuzeNewsEntryChanged(VuzeActivitiesEntry entry) {
        if (this.view == null) {
            return;
        }
        TableRowCore row = this.view.getRow(entry);
        if (row != null) {
            row.invalidate();
        }
    }

    private void removeEntries(final VuzeActivitiesEntry[] toRemove, final int startIndex) {
        final VuzeActivitiesEntry entry = toRemove[startIndex];
        if (entry == null || "Header".equals(entry.getTypeID())) {
            int nextIndex = startIndex + 1;
            if (nextIndex < toRemove.length) {
                this.removeEntries(toRemove, nextIndex);
            }
            return;
        }
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("v3.activity.remove.title"), MessageText.getString("v3.activity.remove.text", new String[]{entry.getText()}));
        mb.setRemember(this.tableID + "-Remove", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
        if (startIndex == toRemove.length - 1) {
            mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
            mb.setRememberOnlyIfButton(0);
        } else {
            mb.setButtons(1, new String[]{MessageText.getString("Button.removeAll"), MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{2, 0, 1});
            mb.setRememberOnlyIfButton(1);
        }
        mb.setHandleHTML(false);
        mb.open(new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                int nextIndex;
                if (result == 2) {
                    int numToRemove = toRemove.length - startIndex;
                    VuzeActivitiesEntry[] toGroupRemove = new VuzeActivitiesEntry[numToRemove];
                    System.arraycopy(toRemove, startIndex, toGroupRemove, 0, numToRemove);
                    VuzeActivitiesManager.removeEntries(toGroupRemove);
                    return;
                }
                if (result == 0) {
                    VuzeActivitiesManager.removeEntries(new VuzeActivitiesEntry[]{entry});
                }
                if ((nextIndex = startIndex + 1) < toRemove.length) {
                    SBC_ActivityTableView.this.removeEntries(toRemove, nextIndex);
                }
            }
        });
    }

    protected void removeSelected() {
        if (this.view == null) {
            return;
        }
        VuzeActivitiesEntry[] selectedEntries = this.view.getSelectedDataSources().toArray(new VuzeActivitiesEntry[0]);
        if (selectedEntries.length > 0) {
            this.removeEntries(selectedEntries, 0);
        }
    }

    public TableViewSWT getView() {
        return this.view;
    }

    public static void setupSidebarEntry(final MultipleDocumentInterface mdi) {
        final ViewTitleInfo titleInfoActivityView = new ViewTitleInfo(){
            boolean had_unviewed = false;

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    boolean has_unviewed;
                    int num_unread = 0;
                    int num_unviewed = 0;
                    List<VuzeActivitiesEntry> allEntries = VuzeActivitiesManager.getAllEntries();
                    for (VuzeActivitiesEntry entry : allEntries) {
                        if (!entry.isRead()) {
                            ++num_unread;
                        }
                        if (entry.getViewed()) continue;
                        ++num_unviewed;
                    }
                    if (num_unread == 0) {
                        num_unviewed = 0;
                    }
                    boolean bl = has_unviewed = num_unviewed > 0;
                    if (has_unviewed != this.had_unviewed) {
                        MdiEntry parent;
                        if (has_unviewed && (parent = mdi.getEntry("header.vuze")) != null && !parent.isExpanded()) {
                            parent.setExpanded(true);
                        }
                        this.had_unviewed = has_unviewed;
                    }
                    if (num_unviewed > 0) {
                        return String.valueOf(num_unviewed) + (num_unread == 0 ? "" : ":" + num_unread);
                    }
                    if (num_unread > 0) {
                        return String.valueOf(num_unread);
                    }
                    return null;
                }
                if (propertyID == 2) {
                    return "image.sidebar.activity";
                }
                if (propertyID == 8) {
                    boolean has_unread = false;
                    boolean has_unviewed = false;
                    List<VuzeActivitiesEntry> allEntries = VuzeActivitiesManager.getAllEntries();
                    for (VuzeActivitiesEntry entry : allEntries) {
                        if (!entry.isRead()) {
                            has_unread = true;
                        }
                        if (entry.getViewed()) continue;
                        has_unviewed = true;
                    }
                    if (has_unread && has_unviewed) {
                        return COLOR_UNVIEWED_ENTRIES;
                    }
                }
                return null;
            }
        };
        VuzeActivitiesManager.addListener(new VuzeActivitiesListener(){

            @Override
            public void vuzeNewsEntryChanged(VuzeActivitiesEntry entry) {
                ViewTitleInfoManager.refreshTitleInfo(titleInfoActivityView);
            }

            @Override
            public void vuzeNewsEntriesRemoved(VuzeActivitiesEntry[] entries) {
                ViewTitleInfoManager.refreshTitleInfo(titleInfoActivityView);
            }

            @Override
            public void vuzeNewsEntriesAdded(VuzeActivitiesEntry[] entries) {
                ViewTitleInfoManager.refreshTitleInfo(titleInfoActivityView);
            }
        });
        MdiEntryCreationListener creationListener = new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                return mdi.createEntryFromSkinRef("header.vuze", "Activity", "activity", "{sidebar.Activity}", titleInfoActivityView, null, false, null);
            }
        };
        mdi.registerEntry("Activity", creationListener);
        mdi.registerEntry("activities", creationListener);
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        MenuItem menuItem = menuManager.addMenuItem("sidebar.Activity", "v3.activity.button.readall");
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                List<VuzeActivitiesEntry> allEntries = VuzeActivitiesManager.getAllEntries();
                for (VuzeActivitiesEntry entry : allEntries) {
                    entry.setRead(true);
                }
            }
        });
        if (Constants.isCVSVersion()) {
            menuItem = menuManager.addMenuItem("sidebar.Activity", "!test update expiry!");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    FeatureManagerUIListener.buildNotifications();
                }
            });
        }
    }
}

