/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Utils;

public abstract class InfoBarUtil {
    private final SWTSkinObject forSO;
    private final boolean top;
    private SWTSkin skin;
    private SWTSkinObject soInfoBar;
    private final String stateConfigID;
    private final String textPrefix;
    private final String skintemplateid;
    private static int uniqueNo = 0;

    public InfoBarUtil(SWTSkinObject forSO, boolean top, String stateConfigID, String textPrefix) {
        this(forSO, "library.top.info", top, stateConfigID, textPrefix);
    }

    public InfoBarUtil(final SWTSkinObject forSO, String skintemplateid, boolean top, final String stateConfigID, String textPrefix) {
        this.forSO = forSO;
        this.skintemplateid = skintemplateid;
        this.stateConfigID = stateConfigID;
        this.textPrefix = textPrefix;
        this.skin = forSO.getSkin();
        this.top = top;
        if (COConfigurationManager.hasParameter(stateConfigID, true)) {
            RememberedDecisionsManager.setRemembered(stateConfigID, COConfigurationManager.getBooleanParameter(stateConfigID) ? 1 : 0);
            COConfigurationManager.removeParameter(stateConfigID);
        }
        forSO.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    boolean show;
                    forSO.removeListener(this);
                    boolean bl = show = RememberedDecisionsManager.getRememberedDecision(stateConfigID) != 0;
                    if (show && InfoBarUtil.this.allowShow() && InfoBarUtil.this.soInfoBar == null) {
                        InfoBarUtil.this.createInfoBar();
                    }
                }
                return null;
            }
        });
    }

    protected void createInfoBar() {
        SWTSkinObject soText2;
        Control control = this.forSO.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        Object ldForSO = control.getLayoutData();
        if (!(ldForSO instanceof FormData)) {
            return;
        }
        FormData fdForSO = (FormData)ldForSO;
        SWTSkinObject parent = this.forSO.getParent();
        this.soInfoBar = this.skin.createSkinObject(this.skintemplateid + uniqueNo++, this.skintemplateid, parent);
        FormData fdInfoBar = (FormData)this.soInfoBar.getControl().getLayoutData();
        if (fdInfoBar == null) {
            fdInfoBar = Utils.getFilledFormData();
        }
        if (this.top) {
            fdInfoBar.top = fdForSO.top.control == null ? new FormAttachment(fdForSO.top.numerator, fdForSO.top.denominator, fdForSO.top.offset) : new FormAttachment(fdForSO.top.control, fdForSO.top.offset, fdForSO.top.alignment);
            fdInfoBar.bottom = null;
            this.soInfoBar.getControl().setLayoutData(fdInfoBar);
            fdForSO.top = new FormAttachment(this.soInfoBar.getControl(), 0, 1024);
            this.forSO.getControl().setLayoutData(fdForSO);
        } else {
            fdInfoBar.bottom = fdForSO.bottom.control == null ? new FormAttachment(fdForSO.bottom.numerator, fdForSO.bottom.denominator, fdForSO.bottom.offset) : new FormAttachment(fdForSO.bottom.control, fdForSO.bottom.offset, fdForSO.bottom.alignment);
            fdInfoBar.top = null;
            this.soInfoBar.getControl().setLayoutData(fdInfoBar);
            fdForSO.bottom = new FormAttachment(this.soInfoBar.getControl(), 0, 128);
            this.forSO.getControl().setLayoutData(fdForSO);
        }
        ((SWTSkinObjectContainer)parent).getComposite().layout(true);
        SWTSkinObject soClose = this.skin.getSkinObject("close", parent);
        if (soClose != null) {
            SWTSkinButtonUtility btnClose = new SWTSkinButtonUtility(soClose);
            btnClose.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    InfoBarUtil.this.soInfoBar.setVisible(false);
                    RememberedDecisionsManager.setRemembered(InfoBarUtil.this.stateConfigID, 0);
                }
            });
        }
        this.soInfoBar.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    RememberedDecisionsManager.setRemembered(InfoBarUtil.this.stateConfigID, 1);
                }
                return null;
            }
        });
        SWTSkinObject soText1 = this.skin.getSkinObject("infobar-title-1", parent);
        if (soText1 instanceof SWTSkinObjectText) {
            SWTSkinObjectText soText = (SWTSkinObjectText)soText1;
            String id = this.textPrefix + ".text1";
            if (MessageText.keyExists(id)) {
                soText.setTextID(id);
            }
        }
        if ((soText2 = this.skin.getSkinObject("infobar-title-2", parent)) instanceof SWTSkinObjectText) {
            SWTSkinObjectText soText = (SWTSkinObjectText)soText2;
            String id = this.textPrefix + ".text2";
            if (MessageText.keyExists(id)) {
                soText.setTextID(id);
            }
        }
        this.created(parent);
        this.soInfoBar.setVisible(true);
    }

    protected void created(SWTSkinObject parent) {
    }

    public void hide(boolean permanently) {
        if (this.soInfoBar != null && !this.soInfoBar.isDisposed()) {
            this.soInfoBar.setVisible(false);
        }
        if (permanently) {
            RememberedDecisionsManager.setRemembered(this.stateConfigID, 0);
        }
    }

    public void show() {
        RememberedDecisionsManager.setRemembered(this.stateConfigID, 1);
        if (this.soInfoBar == null) {
            this.createInfoBar();
        } else {
            this.soInfoBar.setVisible(true);
        }
    }

    public abstract boolean allowShow();
}

