/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class ViewQuickNotifications
implements UISWTViewCoreEventListener {
    private UISWTView swtView;
    private Composite composite;
    private Label notification_icon;
    private Label notification_text;
    private BufferedLabel more_text;

    private void initialize(Composite parent) {
        Control[] controls;
        parent.setLayout(new GridLayout());
        this.composite = new Composite(parent, 2048);
        GridData gridData = new GridData(1808);
        Utils.setLayoutData((Control)this.composite, gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        this.composite.setLayout(layout);
        this.notification_icon = new Label(this.composite, 0);
        gridData = new GridData();
        gridData.widthHint = 20;
        Utils.setLayoutData((Control)this.notification_icon, gridData);
        this.notification_text = new Label(this.composite, 0x20000000);
        gridData = new GridData(768);
        Utils.setLayoutData((Control)this.notification_text, gridData);
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.getMDI().showEntryByID("Activity");
                }
            }
        };
        this.more_text = new BufferedLabel(this.composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        Utils.setLayoutData(this.more_text, gridData);
        this.notification_text.setData("");
        for (Control c : controls = new Control[]{this.composite, this.notification_icon, this.notification_text, this.more_text.getControl()}) {
            c.addMouseListener(listener);
            Messages.setLanguageTooltip(c, "label.click.to.view");
        }
        this.notification_text.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                String text = (String)ViewQuickNotifications.this.notification_text.getData();
                int style = 16384;
                Rectangle bounds = ViewQuickNotifications.this.notification_text.getBounds();
                bounds.x = 4;
                bounds.y = 0;
                bounds.width -= 8;
                GCStringPrinter sp = new GCStringPrinter(e.gc, text, bounds, true, true, style);
                sp.calculateMetrics();
                sp.printString();
            }
        });
    }

    private void delete() {
        Utils.disposeComposite(this.composite);
    }

    private String getFullTitle() {
        return MessageText.getString("label.quick.notifications");
    }

    private Composite getComposite() {
        return this.composite;
    }

    private void refresh() {
        Object[] temp = VuzeActivitiesManager.getMostRecentUnseen();
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)temp[0];
        String old_text = (String)this.notification_text.getData();
        if (entry == null) {
            this.notification_icon.setImage(null);
            if (old_text.length() > 0) {
                this.notification_text.setData("");
                this.notification_text.redraw();
            }
            this.more_text.setText("");
        } else {
            String icon_id;
            String cur_text = entry.getText();
            if (!old_text.equals(cur_text)) {
                this.notification_text.setData(cur_text);
                this.notification_text.redraw();
            }
            if ((icon_id = entry.getIconID()) != null) {
                String existing = (String)this.notification_icon.getData();
                if (existing == null || this.notification_icon.getImage() == null || !existing.equals(icon_id)) {
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    if (existing != null) {
                        imageLoader.releaseImage(existing);
                    }
                    Image image = imageLoader.getImage(icon_id);
                    this.notification_icon.setImage(image);
                    this.notification_icon.setData(icon_id);
                }
            } else {
                this.notification_icon.setImage(null);
            }
            int num = (Integer)temp[1];
            if (num <= 1) {
                this.more_text.setText("");
            } else {
                this.more_text.setText(MessageText.getString("popup.more.waiting", new String[]{String.valueOf(num - 1)}));
            }
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 3: {
                this.composite.traverse(16);
            }
        }
        return true;
    }
}

