/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionStartShutdown;

public class ViewQuickConfig
implements UISWTViewCoreEventListener {
    private UISWTView swtView;
    Composite composite;

    public ViewQuickConfig() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
            }
        });
    }

    private void initialize(Composite ooparent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        ooparent.setLayout(layout);
        Composite oparent = new Composite(ooparent, 2048);
        GridData gridData = new GridData(1808);
        Utils.setLayoutData((Control)oparent, gridData);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        oparent.setLayout(layout);
        final Composite parent = new Composite(oparent, 0);
        gridData = new GridData(1808);
        Utils.setLayoutData((Control)parent, gridData);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout(layout);
        final ScrolledComposite sc = new ScrolledComposite(parent, 512);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                int width = sc.getClientArea().width;
                Point size = parent.computeSize(width, -1);
                sc.setMinSize(size);
            }
        });
        gridData = new GridData(1808);
        Utils.setLayoutData((Control)sc, gridData);
        this.composite = new Composite(sc, 0);
        sc.setContent(this.composite);
        gridData = new GridData(1808);
        Utils.setLayoutData((Control)this.composite, gridData);
        layout = new GridLayout(4, false);
        this.composite.setLayout(layout);
        ConfigSectionStartShutdown.addDoneDownloadingOption(this.composite, false);
        Label label = new Label(this.composite, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 8;
        Utils.setLayoutData((Control)label, gridData);
        Messages.setLanguageText(label, "ConfigView.label.maxdownloads.short");
        IntParameter maxDLs = new IntParameter(this.composite, "max downloads");
        Group temp_rates = new Group(this.composite, 0);
        Messages.setLanguageText(temp_rates, "label.temporary.rates");
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        Utils.setLayoutData((Control)temp_rates, gridData);
        layout = new GridLayout(10, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        temp_rates.setLayout(layout);
        label = new Label(temp_rates, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 4;
        Utils.setLayoutData((Control)label, gridData);
        Messages.setLanguageText((Widget)label, "label.upload.kbps", new String[]{DisplayFormatters.getRateUnit(1)});
        final IntParameter tempULRate = new IntParameter(temp_rates, "global.download.rate.temp.kbps", 0, Integer.MAX_VALUE);
        label = new Label(temp_rates, 0);
        Messages.setLanguageText((Widget)label, "label.download.kbps", new String[]{DisplayFormatters.getRateUnit(1)});
        final IntParameter tempDLRate = new IntParameter(temp_rates, "global.upload.rate.temp.kbps", 0, Integer.MAX_VALUE);
        label = new Label(temp_rates, 0);
        Messages.setLanguageText(label, "label.duration.mins");
        final IntParameter tempMins = new IntParameter(temp_rates, "global.rate.temp.min", 0, Integer.MAX_VALUE);
        final Button activate = new Button(temp_rates, 2);
        Messages.setLanguageText(activate, "label.activate");
        final BufferedLabel remLabel = new BufferedLabel(temp_rates, 0x20000000);
        gridData = new GridData();
        gridData.widthHint = 150;
        Utils.setLayoutData(remLabel, gridData);
        activate.addSelectionListener(new SelectionAdapter(){
            private AzureusCoreLifecycleAdapter listener;
            private TimerEventPeriodic event;
            private boolean auto_up_enabled;
            private boolean auto_up_seeding_enabled;
            private boolean seeding_limits_enabled;
            private int up_limit;
            private int down_limit;
            private long end_time;

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (activate.getSelection()) {
                    this.listener = new AzureusCoreLifecycleAdapter(){

                        @Override
                        public void stopping(AzureusCore core) {
                            this.deactivate(true);
                        }
                    };
                    AzureusCoreFactory.getSingleton().addLifecycleListener(this.listener);
                    Messages.setLanguageText(activate, "FileView.BlockView.Active");
                    tempDLRate.setEnabled(false);
                    tempULRate.setEnabled(false);
                    tempMins.setEnabled(false);
                    this.auto_up_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
                    this.auto_up_seeding_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
                    this.seeding_limits_enabled = COConfigurationManager.getBooleanParameter("enable.seedingonly.upload.rate");
                    this.up_limit = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
                    this.down_limit = COConfigurationManager.getIntParameter("Max Download Speed KBs");
                    COConfigurationManager.setParameter("Auto Upload Speed Enabled", false);
                    COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", false);
                    COConfigurationManager.setParameter("enable.seedingonly.upload.rate", false);
                    COConfigurationManager.setParameter("Max Upload Speed KBs", tempULRate.getValue());
                    COConfigurationManager.setParameter("Max Download Speed KBs", tempDLRate.getValue());
                    this.end_time = SystemTime.getCurrentTime() + (long)(tempMins.getValue() * 60 * 1000);
                    this.event = SimpleTimer.addPeriodicEvent("TempRates", 1000L, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent e) {
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (event == null) {
                                        return;
                                    }
                                    long now = SystemTime.getCurrentTime();
                                    long rem = end_time - now;
                                    if (rem < 1000L || ViewQuickConfig.this.composite.isDisposed()) {
                                        this.deactivate(false);
                                    } else {
                                        remLabel.setText(MessageText.getString("TableColumn.header.remaining") + ": " + DisplayFormatters.formatTime(rem));
                                    }
                                }
                            });
                        }
                    });
                } else {
                    this.deactivate(false);
                }
            }

            private void deactivate(boolean closing) {
                COConfigurationManager.setParameter("Auto Upload Speed Enabled", this.auto_up_enabled);
                COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", this.auto_up_seeding_enabled);
                COConfigurationManager.setParameter("enable.seedingonly.upload.rate", this.seeding_limits_enabled);
                COConfigurationManager.setParameter("Max Upload Speed KBs", this.up_limit);
                COConfigurationManager.setParameter("Max Download Speed KBs", this.down_limit);
                if (!closing) {
                    if (this.listener != null) {
                        AzureusCoreFactory.getSingleton().removeLifecycleListener(this.listener);
                        this.listener = null;
                    }
                    if (!ViewQuickConfig.this.composite.isDisposed()) {
                        Messages.setLanguageText(activate, "label.activate");
                        activate.setSelection(false);
                        tempDLRate.setEnabled(true);
                        tempULRate.setEnabled(true);
                        tempMins.setEnabled(true);
                        remLabel.setText("");
                    }
                }
                if (this.event != null) {
                    this.event.cancel();
                    this.event = null;
                }
            }
        });
        activate.setEnabled(tempMins.getValue() > 0);
        tempMins.addChangeListener(new ParameterChangeAdapter(){

            @Override
            public void parameterChanged(Parameter p, boolean caused_internally) {
                activate.setEnabled(tempMins.getValue() > 0);
            }
        });
        Utils.execSWTThreadLater(100, new Runnable(){

            @Override
            public void run() {
                ViewQuickConfig.this.composite.traverse(16);
            }
        });
    }

    private void delete() {
        Utils.disposeComposite(this.composite);
    }

    private String getFullTitle() {
        return MessageText.getString("label.quick.config");
    }

    private Composite getComposite() {
        return this.composite;
    }

    private void refresh() {
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 3: {
                this.composite.traverse(16);
            }
        }
        return true;
    }
}

