/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class ViewDownSpeedGraph
implements UISWTViewCoreEventListener {
    GlobalManager manager = null;
    GlobalManagerStats stats = null;
    Canvas downSpeedCanvas;
    SpeedGraphic downSpeedGraphic;
    TimerEventPeriodic timerEvent;
    private boolean everRefreshed = false;
    private UISWTView swtView;

    public ViewDownSpeedGraph() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                ViewDownSpeedGraph.this.manager = core.getGlobalManager();
                ViewDownSpeedGraph.this.stats = ViewDownSpeedGraph.this.manager.getStats();
            }
        });
    }

    private void periodicUpdate() {
        if (this.manager == null || this.stats == null) {
            return;
        }
        int swarms_peer_speed = (int)this.stats.getTotalSwarmsPeerRate(true, false);
        this.downSpeedGraphic.addIntsValue(new int[]{this.stats.getDataReceiveRate() + this.stats.getProtocolReceiveRate(), this.stats.getProtocolReceiveRate(), COConfigurationManager.getIntParameter("Max Download Speed KBs") * 1024, swarms_peer_speed});
    }

    private void initialize(Composite composite) {
        composite.setLayout(new GridLayout());
        this.downSpeedCanvas = new Canvas(composite, 0x20000000);
        GridData gridData = new GridData(1808);
        this.downSpeedCanvas.setLayoutData(gridData);
        this.downSpeedGraphic = SpeedGraphic.getInstance();
        this.downSpeedGraphic.initialize(this.downSpeedCanvas);
    }

    private void delete() {
        Utils.disposeComposite(this.downSpeedCanvas);
        this.downSpeedGraphic.dispose();
    }

    private String getFullTitle() {
        return MessageText.getString("TableColumn.header.downspeed");
    }

    private Composite getComposite() {
        return this.downSpeedCanvas;
    }

    private void refresh() {
        if (!this.everRefreshed) {
            this.everRefreshed = true;
            this.timerEvent = SimpleTimer.addPeriodicEvent("TopBarSpeedGraphicView", 1000L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    if (ViewDownSpeedGraph.this.downSpeedCanvas.isDisposed()) {
                        ViewDownSpeedGraph.this.timerEvent.cancel();
                    } else {
                        ViewDownSpeedGraph.this.periodicUpdate();
                    }
                }
            });
        }
        this.downSpeedGraphic.refresh(false);
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

