/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.views.ViewDownSpeedGraph;
import com.aelitis.azureus.ui.swt.views.ViewQuickConfig;
import com.aelitis.azureus.ui.swt.views.ViewQuickNetInfo;
import com.aelitis.azureus.ui.swt.views.ViewQuickNotifications;
import com.aelitis.azureus.ui.swt.views.ViewUpSpeedGraph;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;

public class TopBarView
extends SkinView {
    private static final Object view_name_key = new Object();
    private List<UISWTViewCore> topbarViews = new ArrayList<UISWTViewCore>();
    private UISWTViewCore activeTopBar;
    private SWTSkin skin;
    private org.eclipse.swt.widgets.List listPlugins;
    private Composite cPluginArea;
    private static boolean registeredCoreSubViews = false;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.skin = skinObject.getSkin();
        this.skin.addListener("topbar-plugins", new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    TopBarView.this.skin.removeListener("topbar-plugins", this);
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        @Override
                        public void azureusCoreRunning(AzureusCore core) {
                            Utils.execSWTThreadLater(0, new AERunnable(){

                                @Override
                                public void runSupport() {
                                    TopBarView.this.buildTopBarViews();
                                }
                            });
                        }
                    });
                }
                return null;
            }
        });
        this.skin.getSkinObject("topbar-area-plugin").addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    if (TopBarView.this.activeTopBar != null) {
                        TopBarView.this.activeTopBar.triggerEvent(3, null);
                    }
                } else if (eventType == 1 && TopBarView.this.activeTopBar != null) {
                    TopBarView.this.activeTopBar.triggerEvent(4, null);
                }
                return null;
            }
        });
        return null;
    }

    public void buildTopBarViews() {
        SWTSkinObject skinObject = this.skin.getSkinObject("topbar-plugins");
        if (skinObject == null) {
            return;
        }
        try {
            UISWTInstanceImpl uiSWTinstance;
            this.cPluginArea = (Composite)skinObject.getControl();
            final UIUpdatable updatable = new UIUpdatable(){

                @Override
                public void updateUI() {
                    Object[] views = TopBarView.this.topbarViews.toArray();
                    for (int i = 0; i < views.length; ++i) {
                        try {
                            UISWTViewCore view = (UISWTViewCore)views[i];
                            if (!view.getComposite().isVisible()) continue;
                            view.triggerEvent(5, null);
                            continue;
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                    }
                }

                @Override
                public String getUpdateUIName() {
                    return "TopBar";
                }
            };
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(updatable);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            skinObject.getControl().addDisposeListener(new DisposeListener(){

                @Override
                public void widgetDisposed(DisposeEvent e) {
                    try {
                        UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(updatable);
                    }
                    catch (Exception ex) {
                        Debug.out(ex);
                    }
                    Object[] views = TopBarView.this.topbarViews.toArray();
                    TopBarView.this.topbarViews.clear();
                    for (int i = 0; i < views.length; ++i) {
                        UISWTViewCore view = (UISWTViewCore)views[i];
                        if (view == null) continue;
                        view.triggerEvent(7, null);
                    }
                }
            });
            SWTSkinObject soList = this.skin.getSkinObject("topbar-plugin-list");
            if (soList != null) {
                Composite cList = (Composite)soList.getControl();
                this.listPlugins = new org.eclipse.swt.widgets.List(cList, 512);
                this.listPlugins.setLayoutData(Utils.getFilledFormData());
                this.listPlugins.setBackground(cList.getBackground());
                this.listPlugins.setForeground(cList.getForeground());
                this.listPlugins.addSelectionListener(new SelectionListener(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        String[] selection = TopBarView.this.listPlugins.getSelection();
                        if (selection.length > 0) {
                            String name = selection[0];
                            for (UISWTViewCore view : TopBarView.this.topbarViews) {
                                if (!TopBarView.this.getViewName(view).equals(name)) continue;
                                TopBarView.this.activateTopBar(view);
                            }
                        }
                    }

                    @Override
                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Messages.setLanguageTooltip(this.listPlugins, "label.right.click.for.options");
                final Menu menu = new Menu(this.listPlugins);
                this.listPlugins.setMenu(menu);
                menu.addMenuListener(new MenuListener(){

                    @Override
                    public void menuShown(MenuEvent e) {
                        for (final MenuItem mi : menu.getItems()) {
                            mi.dispose();
                        }
                        for (final UISWTViewCore view : TopBarView.this.topbarViews) {
                            MenuItem mi;
                            final String name = TopBarView.this.getViewName(view);
                            mi = new MenuItem(menu, 32);
                            mi.setText(name);
                            boolean enabled = TopBarView.this.isEnabled(view);
                            mi.setSelection(enabled);
                            mi.addSelectionListener(new SelectionAdapter(){

                                @Override
                                public void widgetSelected(SelectionEvent e) {
                                    boolean enabled = mi.getSelection();
                                    TopBarView.this.setEnabled(view, enabled);
                                    if (enabled) {
                                        TopBarView.this.activateTopBar(view);
                                    } else {
                                        TopBarView.this.listPlugins.remove(name);
                                        TopBarView.this.activateTopBar(null);
                                    }
                                    Utils.relayout(TopBarView.this.cPluginArea);
                                }
                            });
                        }
                    }

                    @Override
                    public void menuHidden(MenuEvent e) {
                    }
                });
            }
            if ((skinObject = this.skin.getSkinObject("pluginbar")) != null) {
                Listener l = new Listener(){
                    private int mouseDownAt = 0;

                    @Override
                    public void handleEvent(Event event2) {
                        Composite c = (Composite)event2.widget;
                        if (event2.type == 3) {
                            Rectangle clientArea = c.getClientArea();
                            if (event2.y > clientArea.height - 10) {
                                this.mouseDownAt = event2.y;
                            }
                        } else if (event2.type == 4 && this.mouseDownAt > 0) {
                            int diff = event2.y - this.mouseDownAt;
                            this.mouseDownAt = 0;
                            FormData formData = (FormData)c.getLayoutData();
                            formData.height += diff;
                            if (formData.height < 50) {
                                formData.height = 50;
                            } else {
                                Rectangle clientArea = c.getShell().getClientArea();
                                int max = clientArea.height - 350;
                                if (formData.height > max) {
                                    formData.height = max;
                                }
                            }
                            COConfigurationManager.setParameter("v3.topbar.height", formData.height);
                            Utils.relayout(c);
                        } else if (event2.type == 5) {
                            Rectangle clientArea = c.getClientArea();
                            boolean draggable = event2.y > clientArea.height - 10;
                            c.setCursor(draggable ? c.getDisplay().getSystemCursor(7) : null);
                        } else if (event2.type == 7) {
                            c.setCursor(null);
                        }
                    }
                };
                Control control = skinObject.getControl();
                control.addListener(3, l);
                control.addListener(4, l);
                control.addListener(5, l);
                control.addListener(7, l);
                skinObject.addListener(new SWTSkinObjectListener(){

                    @Override
                    public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                        if (eventType == 0) {
                            int h = COConfigurationManager.getIntParameter("v3.topbar.height");
                            Control control = skinObject.getControl();
                            FormData formData = (FormData)control.getLayoutData();
                            formData.height = h;
                            control.setLayoutData(formData);
                            Utils.relayout(control);
                        }
                        return null;
                    }
                });
            }
            if ((uiSWTinstance = (UISWTInstanceImpl)UIFunctionsManagerSWT.getUIFunctionsSWT().getUISWTInstance()) != null && !registeredCoreSubViews) {
                uiSWTinstance.addView("TopBar", "ViewDownSpeedGraph", new ViewDownSpeedGraph());
                uiSWTinstance.addView("TopBar", "ViewUpSpeedGraph", new ViewUpSpeedGraph());
                uiSWTinstance.addView("TopBar", "ViewQuickConfig", new ViewQuickConfig());
                uiSWTinstance.addView("TopBar", "ViewQuickNetInfo", new ViewQuickNetInfo());
                uiSWTinstance.addView("TopBar", "ViewQuickNotifications", new ViewQuickNotifications());
                registeredCoreSubViews = true;
            }
            if (uiSWTinstance != null) {
                UISWTViewEventListenerHolder[] pluginViews;
                for (UISWTViewEventListenerHolder l : pluginViews = uiSWTinstance.getViewListeners("TopBar")) {
                    if (l == null) continue;
                    try {
                        UISWTViewImpl view = new UISWTViewImpl(l.getViewID(), "TopBar", false);
                        view.setEventListener(l, true);
                        this.addTopBarView(view, this.cPluginArea);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            String active_view_id = COConfigurationManager.getStringParameter("topbar.active.view.id", "");
            boolean activated = false;
            UISWTViewCore first_enabled = null;
            for (UISWTViewCore view : this.topbarViews) {
                if (!this.isEnabled(view)) continue;
                if (first_enabled == null) {
                    first_enabled = view;
                }
                if (!active_view_id.equals(view.getViewID())) continue;
                this.activateTopBar(view);
                activated = true;
                break;
            }
            if (!activated && first_enabled != null) {
                this.activateTopBar(first_enabled);
                activated = true;
            }
            if (!activated && this.topbarViews.size() > 0) {
                UISWTViewCore view = this.topbarViews.get(0);
                this.setEnabled(view, true);
                this.activateTopBar(view);
            }
            if (skinObject != null) {
                skinObject.getControl().getParent().layout(true);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private boolean isEnabled(UISWTViewCore view) {
        return COConfigurationManager.getBooleanParameter("topbar.view." + view.getViewID() + ".enabled", true);
    }

    private boolean setEnabled(UISWTViewCore view, boolean enabled) {
        return COConfigurationManager.setParameter("topbar.view." + view.getViewID() + ".enabled", enabled);
    }

    private String getViewName(UISWTViewCore view) {
        String s = (String)view.getUserData(view_name_key);
        if (s != null) {
            return s;
        }
        s = view.getFullTitle();
        if (MessageText.keyExists(s)) {
            s = MessageText.getString(s);
        }
        view.setUserData(view_name_key, s);
        return s;
    }

    protected void activateTopBar(UISWTViewCore view) {
        Composite c;
        if (view == null) {
            if (this.activeTopBar != null && !this.isEnabled(this.activeTopBar)) {
                c = this.activeTopBar.getComposite();
                while (c.getParent() != this.cPluginArea) {
                    c = c.getParent();
                }
                c.setVisible(false);
                this.activeTopBar = null;
                for (UISWTViewCore v : this.topbarViews) {
                    if (!this.isEnabled(v)) continue;
                    view = v;
                }
            }
            if (view == null) {
                return;
            }
        }
        if (!this.isEnabled(view)) {
            Debug.out("Attempt to activate disabled view");
            return;
        }
        if (view == this.activeTopBar) {
            return;
        }
        if (this.activeTopBar != null) {
            c = this.activeTopBar.getComposite();
            while (c.getParent() != this.cPluginArea) {
                c = c.getParent();
            }
            c.setVisible(false);
        }
        this.activeTopBar = view;
        COConfigurationManager.setParameter("topbar.active.view.id", view.getViewID());
        if (this.listPlugins != null) {
            String name = this.getViewName(view);
            int index = this.listPlugins.indexOf(name);
            if (index == -1) {
                this.listPlugins.add(name);
                index = this.listPlugins.indexOf(name);
            }
            this.listPlugins.setSelection(new String[0]);
        }
        c = this.activeTopBar.getComposite();
        while (c.getParent() != this.cPluginArea) {
            c = c.getParent();
        }
        c.setVisible(true);
        Utils.relayout(this.cPluginArea);
        this.activeTopBar.triggerEvent(3, null);
    }

    private void addTopBarView(UISWTViewCore view, Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayoutData(Utils.getFilledFormData());
        parent.setLayout(new FormLayout());
        view.initialize(parent);
        parent.setVisible(false);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            boolean useGridLayout;
            Control control = children[i];
            Object ld = control.getLayoutData();
            boolean bl = useGridLayout = ld != null && ld instanceof GridData;
            if (useGridLayout) {
                GridLayout gridLayout = new GridLayout();
                gridLayout.horizontalSpacing = 0;
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                gridLayout.verticalSpacing = 0;
                parent.setLayout(gridLayout);
                break;
            }
            if (ld != null) continue;
            control.setLayoutData(Utils.getFilledFormData());
        }
        this.topbarViews.add(view);
        if (this.listPlugins != null && this.isEnabled(view)) {
            this.listPlugins.add(this.getViewName(view));
        }
    }
}

