/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinCheckboxListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCheckbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCombo;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.StandardButtonsArea;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;

public class TagUIUtilsV3 {
    public static void showCreateTagDialog(final UIFunctions.TagReturner tagReturner) {
        SWTSkinObject soButtonArea;
        final SkinnedDialog dialog = new SkinnedDialog("skin3_dlg_addtag", "shell", 2144);
        SWTSkin skin = dialog.getSkin();
        final SWTSkinObjectTextbox tb = (SWTSkinObjectTextbox)skin.getSkinObject("tag-name");
        final SWTSkinObjectCheckbox cb = (SWTSkinObjectCheckbox)skin.getSkinObject("tag-share");
        final SWTSkinObjectCheckbox ss = (SWTSkinObjectCheckbox)skin.getSkinObject("tag-customize");
        if (tb == null || cb == null) {
            return;
        }
        SWTSkinObjectContainer soGroupBox = (SWTSkinObjectContainer)skin.getSkinObject("tag-group-area");
        final SWTSkinObjectCombo soGroup = (SWTSkinObjectCombo)skin.getSkinObject("tag-group");
        if (soGroupBox != null && soGroup != null) {
            ArrayList<String> listGroups = new ArrayList<String>();
            TagManager tagManager = TagManagerFactory.getTagManager();
            TagType tt = tagManager.getTagType(3);
            List<Tag> tags = tt.getTags();
            for (Tag tag : tags) {
                String group = tag.getGroup();
                if (group == null || group.length() <= 0 || listGroups.contains(group)) continue;
                listGroups.add(group);
            }
            soGroupBox.setVisible(listGroups.size() > 0);
            soGroup.setList(listGroups.toArray(new String[0]));
        }
        cb.setChecked(COConfigurationManager.getBooleanParameter("tag.sharing.default.checked"));
        if (ss != null) {
            ss.setChecked(COConfigurationManager.getBooleanParameter("tag.add.customize.default.checked"));
            ss.addSelectionListener(new SWTSkinCheckboxListener(){

                @Override
                public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                    COConfigurationManager.setParameter("tag.add.customize.default.checked", checked);
                }
            });
        }
        if ((soButtonArea = skin.getSkinObject("bottom-area")) instanceof SWTSkinObjectContainer) {
            StandardButtonsArea buttonsArea = new StandardButtonsArea(){

                @Override
                protected void clicked(int buttonValue) {
                    if (buttonValue == 32) {
                        String tag_name = tb.getText().trim();
                        TagType tt = TagManagerFactory.getTagManager().getTagType(3);
                        Tag tag = tt.getTag(tag_name, true);
                        if (tag == null) {
                            try {
                                String group;
                                tag = tt.createTag(tag_name, true);
                                tag.setPublic(cb.isChecked());
                                if (soGroup != null && (group = soGroup.getText()) != null && group.length() > 0) {
                                    tag.setGroup(group);
                                }
                            }
                            catch (TagException e) {
                                Debug.out(e);
                            }
                        }
                        if (tagReturner != null && tag != null) {
                            tagReturner.returnedTags(new Tag[]{tag});
                        }
                        if (ss.isChecked()) {
                            tag.setTransientProperty("Settings Requested", true);
                            UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("TagsOverview");
                        }
                    }
                    dialog.close();
                }
            };
            buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.add"), MessageText.getString("Button.cancel")});
            buttonsArea.setButtonVals(new Integer[]{32, 256});
            buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
        }
        dialog.open();
    }
}

