/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.utils.SearchSubsResultBase;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.history.DownloadHistoryManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;

public class SearchSubsUtils {
    private static final Object HS_KEY = new Object();
    public static final int HS_NONE = 0;
    public static final int HS_LIBRARY = 1;
    public static final int HS_ARCHIVE = 2;
    public static final int HS_HISTORY = 3;
    public static final int HS_UNKNOWN = 4;
    private static GlobalManager gm;
    private static DownloadManager dm;
    private static DownloadHistoryManager hm;

    public static boolean addMenu(final SearchSubsResultBase result, Menu menu) {
        MenuItem item;
        final byte[] hash = result.getHash();
        if (hash != null) {
            item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("searchsubs.menu.google.hash"));
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    String s = ByteFormatter.encodeString(hash);
                    String URL2 = "https://google.com/search?q=" + UrlUtils.encode(s);
                    SearchSubsUtils.launchURL(URL2);
                }
            });
        }
        item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("searchsubs.menu.gis"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String s = result.getName();
                s = s.replaceAll("[-_]", " ");
                String URL2 = "http://images.google.com/images?q=" + UrlUtils.encode(s);
                SearchSubsUtils.launchURL(URL2);
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("searchsubs.menu.google"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String s = result.getName();
                s = s.replaceAll("[-_]", " ");
                String URL2 = "https://google.com/search?q=" + UrlUtils.encode(s);
                SearchSubsUtils.launchURL(URL2);
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("searchsubs.menu.bis"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String s = result.getName();
                s = s.replaceAll("[-_]", " ");
                String URL2 = "http://www.bing.com/images/search?q=" + UrlUtils.encode(s);
                SearchSubsUtils.launchURL(URL2);
            }
        });
        return true;
    }

    public static void addMenu(final SearchSubsResultBase[] results, Menu menu) {
        boolean has_hash = false;
        for (SearchSubsResultBase result : results) {
            byte[] hash = result.getHash();
            if (hash == null) continue;
            has_hash = true;
            break;
        }
        MenuItem item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("MagnetPlugin.contextmenu.exporturi"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                StringBuffer buffer = new StringBuffer(1024);
                for (SearchSubsResultBase result : results) {
                    byte[] hash = result.getHash();
                    if (hash == null) continue;
                    if (buffer.length() > 0) {
                        buffer.append("\r\n");
                    }
                    String torrent_link = result.getTorrentLink();
                    String str = UrlUtils.getMagnetURI(hash, result.getName(), null);
                    if (torrent_link != null) {
                        str = str + "&fl=" + UrlUtils.encode(torrent_link);
                    }
                    buffer.append(str);
                }
                ClipboardCopy.copyToClipBoard(buffer.toString());
            }
        });
        item.setEnabled(has_hash);
    }

    private static void launchURL(String s) {
        Program program = Program.findProgram(".html");
        if (program != null && program.getName().contains("Chrome")) {
            try {
                Field field = Program.class.getDeclaredField("command");
                field.setAccessible(true);
                String command = (String)field.get(program);
                command = command.replaceAll("%[1lL]", s);
                command = command.replace(" --", "");
                PluginInitializer.getDefaultInterface().getUtilities().createProcess(command + " -incognito");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                Utils.launch(s);
            }
        } else {
            Utils.launch(s);
        }
    }

    public static boolean filterCheck(SearchSubsResultBase ds, String filter2, boolean regex) {
        if (filter2 == null || filter2.length() == 0) {
            return true;
        }
        try {
            boolean hash_filter = filter2.startsWith("t:");
            if (hash_filter) {
                filter2 = filter2.substring(2);
            }
            String s = regex ? filter2 : "\\Q" + filter2.replaceAll("[|;]", "\\\\E|\\\\Q") + "\\E";
            boolean match_result = true;
            if (regex && s.startsWith("!")) {
                s = s.substring(1);
                match_result = false;
            }
            Pattern pattern = Pattern.compile(s, 2);
            if (hash_filter) {
                String[] names;
                byte[] hash = ds.getHash();
                if (hash == null) {
                    return false;
                }
                for (String name : names = new String[]{ByteFormatter.encodeString(hash), Base32.encode(hash)}) {
                    if (pattern.matcher(name).find() != match_result) continue;
                    return true;
                }
                return false;
            }
            String name = ds.getName();
            return pattern.matcher(name).find() == match_result;
        }
        catch (Exception e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHashStatus(SearchSubsResultBase result) {
        long time22;
        if (result == null) {
            return 0;
        }
        byte[] hash = result.getHash();
        if (hash == null || hash.length != 20) {
            return 4;
        }
        long now = SystemTime.getMonotonousTime();
        Object[] entry = (Object[])result.getUserData(HS_KEY);
        if (entry != null && now - (time22 = ((Long)entry[0]).longValue()) < 10000L) {
            return (Integer)entry[1];
        }
        Object time22 = HS_KEY;
        synchronized (time22) {
            if (gm == null) {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                gm = core.getGlobalManager();
                dm = core.getPluginManager().getDefaultPluginInterface().getDownloadManager();
                hm = (DownloadHistoryManager)gm.getDownloadHistoryManager();
            }
        }
        int hs_result = gm.getDownloadManager(new HashWrapper(hash)) != null ? 1 : (dm.lookupDownloadStub(hash) != null ? 2 : (hm.getDates(hash) != null ? 3 : 0));
        result.setUserData(HS_KEY, new Object[]{now + (long)RandomUtils.nextInt(2500), hs_result});
        return hs_result;
    }
}

