/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionAutoDownload;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionCategory;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionEnabled;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionError;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionLastChecked;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionMaxResults;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionName;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionNbNewResults;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionNbResults;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionNew;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionParent;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionSubscribers;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionTag;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionSelectedContent;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;

public class SubscriptionsView
implements SubscriptionManagerListener,
UIPluginViewToolBarListener,
UISWTViewCoreEventListener {
    protected static final String TABLE_ID = "subscriptions";
    private TableViewSWT view;
    private Composite viewComposite;
    private Font textFont1;
    private Font textFont2;
    private UISWTView swtView;

    @Override
    public void associationsChanged(byte[] association_hash) {
    }

    @Override
    public void subscriptionSelected(Subscription subscription) {
    }

    @Override
    public void subscriptionRequested(URL url, Map<String, Object> options) {
    }

    @Override
    public void subscriptionAdded(Subscription subscription) {
        if (subscription.isSubscribed()) {
            this.view.addDataSource(subscription);
        }
    }

    @Override
    public void subscriptionRemoved(Subscription subscription) {
        this.view.removeDataSource(subscription);
    }

    @Override
    public void subscriptionChanged(Subscription subscription) {
        if (!subscription.isSubscribed()) {
            this.subscriptionRemoved(subscription);
        } else if (this.view.getRow(subscription) == null) {
            this.subscriptionAdded(subscription);
        } else {
            this.view.refreshTable(true);
        }
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.view == null) {
            return;
        }
        int numRows = this.view.getSelectedRowsSize();
        list.put("remove", numRows > 0 ? 1L : 0L);
        list.put("share", numRows == 1 ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if ("remove".equals(item.getID())) {
            this.removeSelected();
            return true;
        }
        return false;
    }

    private void removeSelected() {
        TableRowCore[] rows = this.view.getSelectedRows();
        Subscription[] subs = new Subscription[rows.length];
        int i = 0;
        for (Subscription subscription : subs) {
            subs[i] = (Subscription)rows[i++].getDataSource();
        }
        this.removeSubs(subs, 0);
    }

    private void removeSubs(final Subscription[] toRemove, final int startIndex) {
        if (toRemove == null || startIndex >= toRemove.length) {
            return;
        }
        if (toRemove[startIndex] == null) {
            int nextIndex = startIndex + 1;
            if (nextIndex < toRemove.length) {
                this.removeSubs(toRemove, nextIndex);
            }
            return;
        }
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{toRemove[startIndex].getName()}));
        if (startIndex == toRemove.length - 1) {
            mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
        } else {
            mb.setButtons(1, new String[]{MessageText.getString("Button.removeAll"), MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{2, 0, 1});
        }
        mb.open(new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                if (result == 0) {
                    toRemove[startIndex].remove();
                } else if (result == 2) {
                    for (int i = startIndex; i < toRemove.length; ++i) {
                        if (toRemove[i] == null) continue;
                        toRemove[i].remove();
                    }
                    return;
                }
                int nextIndex = startIndex + 1;
                if (nextIndex < toRemove.length) {
                    SubscriptionsView.this.removeSubs(toRemove, nextIndex);
                }
            }
        });
    }

    private void delete() {
        if (this.viewComposite != null && !this.viewComposite.isDisposed()) {
            this.viewComposite.dispose();
        }
        if (this.textFont1 != null && !this.textFont1.isDisposed()) {
            this.textFont1.dispose();
        }
        if (this.textFont2 != null && !this.textFont2.isDisposed()) {
            this.textFont2.dispose();
        }
    }

    private Composite getComposite() {
        return this.viewComposite;
    }

    private String getFullTitle() {
        return MessageText.getString("subscriptions.overview");
    }

    private void initialize(Composite parent) {
        int i;
        this.viewComposite = new Composite(parent, 0);
        this.viewComposite.setLayout(new FormLayout());
        TableColumnCore[] columns = new TableColumnCore[]{new ColumnSubscriptionNew(TABLE_ID), new ColumnSubscriptionName(TABLE_ID), new ColumnSubscriptionNbNewResults(TABLE_ID), new ColumnSubscriptionNbResults(TABLE_ID), new ColumnSubscriptionMaxResults(TABLE_ID), new ColumnSubscriptionLastChecked(TABLE_ID), new ColumnSubscriptionSubscribers(TABLE_ID), new ColumnSubscriptionEnabled(TABLE_ID), new ColumnSubscriptionAutoDownload(TABLE_ID), new ColumnSubscriptionCategory(TABLE_ID), new ColumnSubscriptionTag(TABLE_ID), new ColumnSubscriptionParent(TABLE_ID), new ColumnSubscriptionError(TABLE_ID)};
        TableColumnManager tcm = TableColumnManager.getInstance();
        tcm.setDefaultColumnNames(TABLE_ID, new String[]{"new", ColumnSubscriptionName.COLUMN_ID, ColumnSubscriptionNbNewResults.COLUMN_ID, ColumnSubscriptionNbResults.COLUMN_ID, ColumnSubscriptionAutoDownload.COLUMN_ID});
        this.view = TableViewFactory.createTableViewSWT(Subscription.class, TABLE_ID, TABLE_ID, columns, "name", 0x10010002);
        this.view.addLifeCycleListener(new TableLifeCycleListener(){

            @Override
            public void tableViewInitialized() {
                SubscriptionManagerFactory.getSingleton().addListener(SubscriptionsView.this);
                SubscriptionsView.this.view.addDataSources(SubscriptionManagerFactory.getSingleton().getSubscriptions(true));
            }

            @Override
            public void tableViewDestroyed() {
                SubscriptionManagerFactory.getSingleton().removeListener(SubscriptionsView.this);
            }
        });
        this.view.addSelectionListener(new TableSelectionAdapter(){
            PluginInterface pi = PluginInitializer.getDefaultInterface();
            UIManager uim = this.pi.getUIManager();
            MenuManager menu_manager = this.uim.getMenuManager();
            TableManager table_manager = this.uim.getTableManager();
            ArrayList<TableContextMenuItem> menu_items = new ArrayList();
            SubscriptionManagerUI.MenuCreator menu_creator = new SubscriptionManagerUI.MenuCreator(){

                @Override
                public MenuItem createMenu(String resource_id) {
                    TableContextMenuItem menu = table_manager.addContextMenuItem(SubscriptionsView.TABLE_ID, resource_id);
                    menu_items.add(menu);
                    return menu;
                }

                @Override
                public void refreshView() {
                }
            };

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                if (rows.length != 1) return;
                TableRowCore row = rows[0];
                Subscription sub = (Subscription)row.getDataSource();
                if (sub == null) {
                    return;
                }
                if (sub.isSearchTemplate()) {
                    try {
                        VuzeFile vf = sub.getSearchTemplateVuzeFile();
                        if (vf == null) return;
                        sub.setSubscribed(true);
                        VuzeFileHandler.getSingleton().handleFiles(new VuzeFile[]{vf}, 0);
                        for (VuzeFileComponent comp2 : vf.getComponents()) {
                            Engine engine = (Engine)comp2.getData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY);
                            if (engine == null || engine.getSelectionState() != 0 && engine.getSelectionState() != 3) continue;
                            engine.setSelectionState(2);
                        }
                        return;
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        return;
                    }
                } else {
                    String key = "Subscription_" + ByteFormatter.encodeString(sub.getPublicKey());
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    if (mdi == null) return;
                    mdi.showEntryByID(key);
                }
            }

            @Override
            public void selected(TableRowCore[] rows) {
                rows = SubscriptionsView.this.view.getSelectedRows();
                ISelectedContent[] sels = new ISelectedContent[rows.length];
                ArrayList<Subscription> subs = new ArrayList<Subscription>();
                for (int i = 0; i < rows.length; ++i) {
                    Subscription sub = (Subscription)rows[i].getDataSource();
                    sels[i] = new SubscriptionSelectedContent(sub);
                    if (sub == null) continue;
                    subs.add(sub);
                }
                SelectedContentManager.changeCurrentlySelectedContent(SubscriptionsView.this.view.getTableID(), sels, SubscriptionsView.this.view);
                for (TableContextMenuItem mi : this.menu_items) {
                    mi.remove();
                }
                if (subs.size() > 0) {
                    SubscriptionManagerUI.createMenus(this.menu_manager, this.menu_creator, subs.toArray(new Subscription[0]));
                }
            }
        }, false);
        this.view.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event2) {
            }

            @Override
            public void keyReleased(KeyEvent event2) {
                if (event2.keyCode == 127) {
                    SubscriptionsView.this.removeSelected();
                }
            }
        });
        this.view.setRowDefaultHeightEM(1.4f);
        this.view.initialize(this.viewComposite);
        final Composite composite = new Composite(this.viewComposite, 2048);
        composite.setBackgroundMode(1);
        composite.setBackground(ColorCache.getColor((Device)composite.getDisplay(), "#F1F9F8"));
        Font font = composite.getFont();
        FontData[] fDatas = font.getFontData();
        for (i = 0; i < fDatas.length; ++i) {
            fDatas[i].setHeight(150 * fDatas[i].getHeight() / 100);
            if (!Constants.isWindows) continue;
            fDatas[i].setStyle(1);
        }
        this.textFont1 = new Font((Device)composite.getDisplay(), fDatas);
        fDatas = font.getFontData();
        for (i = 0; i < fDatas.length; ++i) {
            fDatas[i].setHeight(120 * fDatas[i].getHeight() / 100);
        }
        this.textFont2 = new Font((Device)composite.getDisplay(), fDatas);
        Label preText = new Label(composite, 0);
        preText.setForeground(ColorCache.getColor((Device)composite.getDisplay(), "#6D6F6E"));
        preText.setFont(this.textFont1);
        preText.setText(MessageText.getString("subscriptions.view.help.1"));
        Label image = new Label(composite, 0);
        ImageLoader.getInstance().setLabelImage(image, "btn_rss_add");
        Link postText = new Link(composite, 0);
        postText.setForeground(ColorCache.getColor((Device)composite.getDisplay(), "#6D6F6E"));
        postText.setFont(this.textFont2);
        postText.setText(MessageText.getString("subscriptions.view.help.2"));
        postText.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                if (event2.text != null && (event2.text.startsWith("http://") || event2.text.startsWith("https://"))) {
                    Utils.launch(event2.text);
                }
            }
        });
        Label close = new Label(composite, 0);
        ImageLoader.getInstance().setLabelImage(close, "image.dismissX");
        close.setCursor(composite.getDisplay().getSystemCursor(21));
        close.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                COConfigurationManager.setParameter("subscriptions.view.showhelp", false);
                composite.setVisible(false);
                FormData data = (FormData)SubscriptionsView.this.view.getComposite().getLayoutData();
                data.bottom = new FormAttachment(100, 0);
                SubscriptionsView.this.viewComposite.layout(true);
            }
        });
        FormLayout layout = new FormLayout();
        composite.setLayout(layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 15);
        data.top = new FormAttachment(0, 20);
        data.bottom = new FormAttachment(postText, -5);
        preText.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(preText, 5);
        data.top = new FormAttachment(preText, 0, 0x1000000);
        image.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(preText, 0, 16384);
        data.bottom = new FormAttachment(100, -20);
        postText.setLayoutData(data);
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(0, 10);
        close.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(composite, 0);
        this.viewComposite.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        composite.setLayoutData(data);
        COConfigurationManager.setBooleanDefault("subscriptions.view.showhelp", true);
        if (!COConfigurationManager.getBooleanParameter("subscriptions.view.showhelp")) {
            composite.setVisible(false);
            data = (FormData)this.viewComposite.getLayoutData();
            data.bottom = new FormAttachment(100, 0);
            this.viewComposite.layout(true);
        }
    }

    private void refresh() {
        if (this.view != null) {
            this.view.refreshTable(false);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

