/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionMDIEntry;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionsViewBase;
import com.aelitis.azureus.util.ConstantsVuze;
import java.util.Locale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.webplugin.WebPlugin;

public class SubscriptionViewExternalBrowser
implements SubscriptionsViewBase {
    private Subscription subs;
    private Composite parent_composite;
    private Composite composite;
    private SubscriptionMDIEntry mdiInfo;
    private UISWTView swtView;

    @Override
    public void refreshView() {
    }

    private void launchView() {
        PluginInterface xmweb_ui = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("xmwebui");
        if (xmweb_ui == null || !xmweb_ui.getPluginState().isOperational()) {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("external.browser.failed"), MessageText.getString("xmwebui.required"));
            mb.setParent(uiFunctions.getMainShell());
            mb.open(null);
        } else {
            WebPlugin wp = (WebPlugin)xmweb_ui.getPlugin();
            String remui = wp.getProtocol().toLowerCase(Locale.US) + "://127.0.0.1:" + wp.getPort() + "/";
            String test_url = ConstantsVuze.getDefaultContentNetwork().getServiceURL(2, new Object[]{"", false});
            int pos = test_url.indexOf(63);
            String mode = xmweb_ui.getUtilities().getFeatureManager().isFeatureInstalled("core") ? "plus" : "trial";
            String query = "Subscription: " + UrlUtils.encode(this.subs.getName()) + " (" + this.subs.getID() + ")";
            String search_url = test_url.substring(0, pos + 1) + "q=" + UrlUtils.encode(query) + "&" + "mode=" + mode + "&" + "search_source=" + UrlUtils.encode(remui);
            Utils.launch(search_url);
        }
    }

    private void initialize(Composite _parent_composite) {
        this.parent_composite = _parent_composite;
        this.composite = new Composite(this.parent_composite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 32;
        layout.marginWidth = 32;
        this.composite.setLayout(layout);
        Label label = new Label(this.composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData(gd);
        Messages.setLanguageText(label, "subs.ext.view.info");
        label = new Label(this.composite, 0);
        Messages.setLanguageText(label, "subs.ext.view.launch.info");
        Button button = new Button(this.composite, 8);
        Messages.setLanguageText(button, "iconBar.run");
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SubscriptionViewExternalBrowser.this.launchView();
            }
        });
    }

    private Composite getComposite() {
        return this.composite;
    }

    private String getFullTitle() {
        if (this.subs == null) {
            return "";
        }
        return this.subs.getName();
    }

    private void viewActivated() {
        if (this.subs != null && this.mdiInfo == null) {
            this.mdiInfo = (SubscriptionMDIEntry)this.subs.getUserData(SubscriptionManagerUI.SUB_ENTRYINFO_KEY);
        }
    }

    private void viewDeactivated() {
        if (this.mdiInfo != null && this.mdiInfo.spinnerImage != null) {
            this.mdiInfo.spinnerImage.setVisible(false);
        }
    }

    private void dataSourceChanged(Object data) {
        if (data instanceof Subscription) {
            this.subs = (Subscription)data;
            this.mdiInfo = (SubscriptionMDIEntry)this.subs.getUserData(SubscriptionManagerUI.SUB_ENTRYINFO_KEY);
        }
        if (this.subs != null && this.swtView != null) {
            this.swtView.setTitle(this.getFullTitle());
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl(this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
                break;
            }
        }
        return true;
    }
}

