/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionView;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;

public class SubscriptionMDIEntry
implements SubscriptionListener,
ViewTitleInfo {
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final String AUTH_IMAGE_ID = "image.sidebar.vitality.auth";
    private final MdiEntry mdiEntry;
    MdiEntryVitalityImage spinnerImage;
    private MdiEntryVitalityImage warningImage;
    private final Subscription subs;
    private String current_parent;

    public SubscriptionMDIEntry(Subscription subs, MdiEntry entry) {
        this.subs = subs;
        this.mdiEntry = entry;
        this.current_parent = subs.getParent();
        if (this.current_parent != null && this.current_parent.length() == 0) {
            this.current_parent = null;
        }
        this.setupMdiEntry();
    }

    private void setupMdiEntry() {
        if (this.mdiEntry == null) {
            return;
        }
        this.mdiEntry.setViewTitleInfo(this);
        this.mdiEntry.setImageLeftID("image.sidebar.subscriptions");
        this.warningImage = this.mdiEntry.addVitalityImage(ALERT_IMAGE_ID);
        this.spinnerImage = this.mdiEntry.addVitalityImage("image.sidebar.vitality.dots");
        if (this.spinnerImage != null) {
            this.spinnerImage.setVisible(false);
        }
        this.setWarning();
        SubscriptionMDIEntry.setupMenus(this.subs, new Runnable(){

            @Override
            public void run() {
                SubscriptionMDIEntry.this.refreshView();
            }
        });
        this.subs.addListener(this);
    }

    protected static String setupMenus(Subscription subs, final Runnable refresher) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        final MenuManager menu_manager = uim.getMenuManager();
        final String key = "sidebar.Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
        SubscriptionManagerUI.MenuCreator menu_creator = new SubscriptionManagerUI.MenuCreator(){

            @Override
            public MenuItem createMenu(String resource_id) {
                return menu_manager.addMenuItem(key, resource_id);
            }

            @Override
            public void refreshView() {
                if (refresher != null) {
                    refresher.run();
                }
            }
        };
        SubscriptionManagerUI.createMenus(menu_manager, menu_creator, new Subscription[]{subs});
        return key;
    }

    protected String getCurrentParent() {
        return this.current_parent;
    }

    protected boolean isDisposed() {
        return this.mdiEntry.isDisposed();
    }

    @Override
    public void subscriptionDownloaded(Subscription subs, boolean auto) {
    }

    @Override
    public void subscriptionChanged(Subscription subs, int reason) {
        this.mdiEntry.redraw();
        ViewTitleInfoManager.refreshTitleInfo(this.mdiEntry.getViewTitleInfo());
    }

    protected void refreshView() {
        if (!(this.mdiEntry instanceof BaseMdiEntry)) {
            return;
        }
        UISWTViewEventListener eventListener = ((BaseMdiEntry)this.mdiEntry).getEventListener();
        if (eventListener instanceof SubscriptionView) {
            SubscriptionView subsView = (SubscriptionView)eventListener;
            subsView.refreshView();
        }
    }

    protected void setWarning() {
        boolean trouble;
        if (this.warningImage == null) {
            return;
        }
        SubscriptionHistory history = this.subs.getHistory();
        String last_error = history.getLastError();
        boolean auth_fail = history.isAuthFail();
        if (history.getConsecFails() < 3 && !auth_fail) {
            last_error = null;
        }
        boolean bl = trouble = last_error != null;
        if (trouble) {
            this.warningImage.setToolTip(last_error);
            this.warningImage.setImageID(auth_fail ? AUTH_IMAGE_ID : ALERT_IMAGE_ID);
            this.warningImage.setVisible(true);
        } else {
            this.warningImage.setVisible(false);
            this.warningImage.setToolTip("");
        }
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        switch (propertyID) {
            case 5: {
                return this.subs.getName();
            }
            case 1: {
                long pop = this.subs.getCachedPopularity();
                String res = this.subs.getName();
                if (pop > 1L) {
                    res = res + " (" + MessageText.getString("subscriptions.listwindow.popularity").toLowerCase() + "=" + pop + ")";
                }
                return res;
            }
            case 0: {
                SubscriptionMDIEntry mdi = (SubscriptionMDIEntry)this.subs.getUserData(SubscriptionManagerUI.SUB_ENTRYINFO_KEY);
                if (mdi != null) {
                    mdi.setWarning();
                }
                if (this.subs.getHistory().getNumUnread() > 0) {
                    return "" + this.subs.getHistory().getNumUnread();
                }
                return null;
            }
        }
        return null;
    }

    protected void removeWithConfirm() {
        SubscriptionManagerUI.removeWithConfirm(this.subs);
    }
}

