/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultActions;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultAge;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultCategory;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultExisting;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultHash;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultName;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultRank;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultRatings;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultSeedsPeers;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultSize;
import com.aelitis.azureus.ui.swt.columns.searchsubs.ColumnSearchSubResultType;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubResultNew;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectToggle;
import com.aelitis.azureus.ui.swt.skin.SWTSkinToggleListener;
import com.aelitis.azureus.ui.swt.subscriptions.SBC_SubscriptionResult;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionMDIEntry;
import com.aelitis.azureus.ui.swt.utils.SearchSubsResultBase;
import com.aelitis.azureus.ui.swt.utils.SearchSubsUtils;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;

public class SBC_SubscriptionResultsView
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<SBC_SubscriptionResult>,
SubscriptionListener {
    public static final String TABLE_SR = "SubscriptionResults";
    private static boolean columnsAdded = false;
    private TableViewSWT<SBC_SubscriptionResult> tv_subs_results;
    private MdiEntry mdi_entry;
    private Composite table_parent;
    private Text txtFilter;
    private final Object filter_lock = new Object();
    private int minSize;
    private int maxSize;
    private String[] with_keywords = new String[0];
    private String[] without_keywords = new String[0];
    private FrequencyLimitedDispatcher refilter_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        @Override
        public void runSupport() {
            SBC_SubscriptionResultsView.this.refilter();
        }
    }, 250);
    private Subscription ds;
    private List<SBC_SubscriptionResult> last_selected_content = new ArrayList<SBC_SubscriptionResult>();

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SWTSkinObject soFilterArea;
        SWTSkinObjectTextbox soFilterBox;
        SWTSkinObjectText title;
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                SBC_SubscriptionResultsView.this.initColumns(core);
            }
        });
        String mdi_key = "Subscription_" + ByteFormatter.encodeString(this.ds.getPublicKey());
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && this.ds != null) {
            this.mdi_entry = mdi.getEntry(mdi_key);
            if (this.mdi_entry != null) {
                this.mdi_entry.addToolbarEnabler(this);
            }
        }
        if (this.ds != null && (title = (SWTSkinObjectText)this.getSkinObject("title")) != null) {
            title.setText(MessageText.getString("subs.results.view.title", new String[]{this.ds.getName()}));
            Control control = title.getControl();
            final Menu menu = new Menu(control);
            control.setMenu(menu);
            final String menu_key = SubscriptionMDIEntry.setupMenus(this.ds, null);
            menu.addMenuListener(new MenuListener(){

                @Override
                public void menuShown(MenuEvent e) {
                    for (MenuItem mi : menu.getItems()) {
                        mi.dispose();
                    }
                    org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray(menu_key);
                    MenuBuildUtils.addPluginMenuItems(menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{SBC_SubscriptionResultsView.this.ds}));
                }

                @Override
                public void menuHidden(MenuEvent e) {
                }
            });
        }
        if ((soFilterBox = (SWTSkinObjectTextbox)this.getSkinObject("filterbox")) != null) {
            this.txtFilter = soFilterBox.getTextControl();
        }
        if ((soFilterArea = this.getSkinObject("filterarea")) != null) {
            GridLayout layout;
            Label label;
            SWTSkinObjectToggle soFilterButton = (SWTSkinObjectToggle)this.getSkinObject("filter-button");
            if (soFilterButton != null) {
                boolean toggled = COConfigurationManager.getBooleanParameter("Subscription View Filter Options Expanded", false);
                if (toggled) {
                    soFilterButton.setToggled(true);
                    soFilterArea.setVisible(true);
                }
                soFilterButton.addSelectionListener(new SWTSkinToggleListener(){

                    @Override
                    public void toggleChanged(SWTSkinObjectToggle so, boolean toggled) {
                        COConfigurationManager.setParameter("Subscription View Filter Options Expanded", toggled);
                        soFilterArea.setVisible(toggled);
                        Utils.relayout(soFilterArea.getControl().getParent());
                    }
                });
            }
            Composite parent = (Composite)soFilterArea.getControl();
            int sepHeight = 20;
            Composite cRow = new Composite(parent, 0);
            FormData fd = Utils.getFilledFormData();
            cRow.setLayoutData(fd);
            RowLayout rowLayout = new RowLayout(256);
            rowLayout.spacing = 5;
            rowLayout.marginRight = 0;
            rowLayout.marginLeft = 0;
            rowLayout.marginTop = 0;
            rowLayout.marginBottom = 0;
            rowLayout.center = true;
            cRow.setLayout(rowLayout);
            ImageLoader imageLoader = ImageLoader.getInstance();
            for (int i = 0; i < 2; ++i) {
                boolean with;
                boolean bl = with = i == 0;
                if (!with) {
                    label = new Label(cRow, 514);
                    label.setLayoutData(new RowData(-1, sepHeight));
                }
                Composite cWithKW = new Composite(cRow, 0);
                layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                layout.marginRight = 0;
                layout.marginLeft = 0;
                layout.marginTop = 0;
                layout.marginBottom = 0;
                cWithKW.setLayout(layout);
                Label lblWithKWImg = new Label(cWithKW, 0);
                lblWithKWImg.setImage(imageLoader.getImage(with ? "icon_filter_plus" : "icon_filter_minus"));
                final Text textWithKW = new Text(cWithKW, 2048);
                textWithKW.setMessage(MessageText.getString(with ? "SubscriptionResults.filter.with.words" : "SubscriptionResults.filter.without.words"));
                GridData gd = new GridData();
                gd.widthHint = Utils.adjustPXForDPI(100);
                textWithKW.setLayoutData(gd);
                textWithKW.addModifyListener(new ModifyListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void modifyText(ModifyEvent e) {
                        String text = textWithKW.getText().toLowerCase(Locale.US);
                        String[] bits = text.split("\\s+");
                        HashSet<String> temp = new HashSet<String>();
                        for (String bit : bits) {
                            if ((bit = bit.trim()).length() <= 0) continue;
                            temp.add(bit);
                        }
                        String[] words = temp.toArray(new String[temp.size()]);
                        Object object = SBC_SubscriptionResultsView.this.filter_lock;
                        synchronized (object) {
                            if (with) {
                                SBC_SubscriptionResultsView.access$302(SBC_SubscriptionResultsView.this, words);
                            } else {
                                SBC_SubscriptionResultsView.access$402(SBC_SubscriptionResultsView.this, words);
                            }
                        }
                        SBC_SubscriptionResultsView.this.refilter_dispatcher.dispatch();
                    }
                });
            }
            label = new Label(cRow, 514);
            label.setLayoutData(new RowData(-1, sepHeight));
            Composite cMinSize = new Composite(cRow, 0);
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            cMinSize.setLayout(layout);
            Label lblMinSize = new Label(cMinSize, 0);
            lblMinSize.setText(MessageText.getString("SubscriptionResults.filter.min_size"));
            Spinner spinMinSize = new Spinner(cMinSize, 2048);
            spinMinSize.setMinimum(0);
            spinMinSize.setMaximum(0x6400000);
            spinMinSize.setSelection(this.minSize);
            spinMinSize.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    SBC_SubscriptionResultsView.this.minSize = ((Spinner)event2.widget).getSelection();
                    SBC_SubscriptionResultsView.this.refilter();
                }
            });
            label = new Label(cRow, 514);
            label.setLayoutData(new RowData(-1, sepHeight));
            Composite cMaxSize = new Composite(cRow, 0);
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            cMaxSize.setLayout(layout);
            Label lblMaxSize = new Label(cMaxSize, 0);
            lblMaxSize.setText(MessageText.getString("SubscriptionResults.filter.max_size"));
            Spinner spinMaxSize = new Spinner(cMaxSize, 2048);
            spinMaxSize.setMinimum(0);
            spinMaxSize.setMaximum(0x6400000);
            spinMaxSize.setSelection(this.maxSize);
            spinMaxSize.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    SBC_SubscriptionResultsView.this.maxSize = ((Spinner)event2.widget).getSelection();
                    SBC_SubscriptionResultsView.this.refilter();
                }
            });
            parent.layout(true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOurContent(SBC_SubscriptionResult result) {
        boolean size_ok;
        long size = result.getSize();
        long kInB = DisplayFormatters.getKinB();
        long mInB = kInB * kInB;
        boolean bl = size_ok = !(size != -1L && size < mInB * (long)this.minSize || size != -1L && this.maxSize != 0 && size > mInB * (long)this.maxSize);
        if (!size_ok) {
            return false;
        }
        if (this.with_keywords.length > 0 || this.without_keywords.length > 0) {
            Object object = this.filter_lock;
            synchronized (object) {
                int i;
                String name = result.getName().toLowerCase(Locale.US);
                for (i = 0; i < this.with_keywords.length; ++i) {
                    if (name.contains(this.with_keywords[i])) continue;
                    return false;
                }
                for (i = 0; i < this.without_keywords.length; ++i) {
                    if (!name.contains(this.without_keywords[i])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void refilter() {
        if (this.tv_subs_results != null) {
            this.tv_subs_results.refilter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(AzureusCore core) {
        Class<SBC_SubscriptionResultsView> clazz = SBC_SubscriptionResultsView.class;
        synchronized (SBC_SubscriptionResultsView.class) {
            if (columnsAdded) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            columnsAdded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(SBC_SubscriptionResult.class, "new", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSubResultNew(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, "type", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultType(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, ColumnSearchSubResultName.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultName(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, "actions", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultActions(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, "size", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultSize(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, ColumnSearchSubResultSeedsPeers.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultSeedsPeers(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, ColumnSearchSubResultRatings.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultRatings(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, "age", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultAge(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, "rank", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultRank(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, ColumnSearchSubResultCategory.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultCategory(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, ColumnSearchSubResultHash.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultHash(column);
                }
            });
            tableManager.registerColumn(SBC_SubscriptionResult.class, ColumnSearchSubResultExisting.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultExisting(column);
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        SBC_SubscriptionResultsView sBC_SubscriptionResultsView = this;
        synchronized (sBC_SubscriptionResultsView) {
            Object[] objs;
            Subscription new_ds = null;
            if (params instanceof Subscription) {
                new_ds = (Subscription)params;
            } else if (params instanceof Object[] && (objs = (Object[])params).length == 1 && objs[0] instanceof Subscription) {
                new_ds = (Subscription)objs[0];
            }
            if (this.ds != null) {
                this.ds.removeListener(this);
            }
            this.ds = new_ds;
            if (new_ds != null) {
                this.ds.addListener(this);
            }
        }
        return super.dataSourceChanged(skinObject, params);
    }

    @Override
    public void subscriptionChanged(Subscription subs, int reason) {
        if (reason == 2) {
            this.reconcileResults(subs);
            this.tv_subs_results.runForAllRows(new TableGroupRowRunner(){

                @Override
                public void run(TableRowCore row) {
                    row.invalidate(true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileResults(Subscription subs) {
        SBC_SubscriptionResultsView sBC_SubscriptionResultsView = this;
        synchronized (sBC_SubscriptionResultsView) {
            if (subs != this.ds || this.ds == null || subs == null || this.tv_subs_results == null) {
                return;
            }
            this.tv_subs_results.processDataSourceQueueSync();
            List existing_results = this.tv_subs_results.getDataSources(true);
            HashMap<String, SBC_SubscriptionResult> existing_map = new HashMap<String, SBC_SubscriptionResult>();
            for (SBC_SubscriptionResult result : existing_results) {
                existing_map.put(result.getID(), result);
            }
            SubscriptionResult[] current_results = this.ds.getResults(false);
            ArrayList<SBC_SubscriptionResult> new_results = new ArrayList<SBC_SubscriptionResult>(current_results.length);
            for (SubscriptionResult result : current_results) {
                SBC_SubscriptionResult existing = (SBC_SubscriptionResult)existing_map.remove(result.getID());
                if (existing == null) {
                    new_results.add(new SBC_SubscriptionResult(this.ds, result));
                    continue;
                }
                existing.updateFrom(result);
            }
            if (new_results.size() > 0) {
                this.tv_subs_results.addDataSources((SBC_SubscriptionResult[])new_results.toArray(new SBC_SubscriptionResult[new_results.size()]));
            }
            if (existing_map.size() > 0) {
                Collection to_remove = existing_map.values();
                this.tv_subs_results.removeDataSources((SBC_SubscriptionResult[])to_remove.toArray(new SBC_SubscriptionResult[to_remove.size()]));
            }
        }
    }

    @Override
    public void subscriptionDownloaded(Subscription subs, boolean auto) {
    }

    private void showView() {
        SWTSkinObject so_list = this.getSkinObject("subs-results-list");
        if (so_list != null) {
            so_list.setVisible(true);
            this.initTable((Composite)so_list.getControl());
        }
    }

    private void hideView() {
        Utils.disposeSWTObjects(new Object[]{this.table_parent});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        this.showView();
        SBC_SubscriptionResultsView sBC_SubscriptionResultsView = this;
        synchronized (sBC_SubscriptionResultsView) {
            if (this.ds != null) {
                this.ds.addListener(this);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        this.hideView();
        SBC_SubscriptionResultsView sBC_SubscriptionResultsView = this;
        synchronized (sBC_SubscriptionResultsView) {
            if (this.ds != null) {
                this.ds.removeListener(this);
            }
        }
        return super.skinObjectHidden(skinObject, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        SBC_SubscriptionResultsView sBC_SubscriptionResultsView = this;
        synchronized (sBC_SubscriptionResultsView) {
            if (this.tv_subs_results != null) {
                this.tv_subs_results.delete();
                this.tv_subs_results = null;
            }
            if (this.ds != null) {
                this.ds.removeListener(this);
            }
        }
        Utils.disposeSWTObjects(new Object[]{this.table_parent});
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        SWTSkinObjectContainer so;
        this.tv_subs_results = TableViewFactory.createTableViewSWT(SBC_SubscriptionResult.class, TABLE_SR, TABLE_SR, new TableColumnCore[0], "age", 0x10010002);
        TableColumnManager tableManager = TableColumnManager.getInstance();
        tableManager.setDefaultColumnNames(TABLE_SR, new String[]{"new", "type", ColumnSearchSubResultName.COLUMN_ID, "actions", "size", ColumnSearchSubResultSeedsPeers.COLUMN_ID, ColumnSearchSubResultRatings.COLUMN_ID, "age", "rank", ColumnSearchSubResultCategory.COLUMN_ID});
        tableManager.setDefaultSortColumnName(TABLE_SR, "age");
        TableColumnCore tcc = tableManager.getTableColumnCore(TABLE_SR, "age");
        if (tcc != null) {
            tcc.setDefaultSortAscending(true);
        }
        if (this.txtFilter != null) {
            this.tv_subs_results.enableFilterCheck(this.txtFilter, this);
        }
        this.tv_subs_results.setRowDefaultHeight(COConfigurationManager.getIntParameter("Search Subs Row Height"));
        SWTSkinObject soSizeSlider = this.getSkinObject("table-size-slider");
        if (soSizeSlider instanceof SWTSkinObjectContainer && !this.tv_subs_results.enableSizeSlider((so = (SWTSkinObjectContainer)soSizeSlider).getComposite(), 16, 100)) {
            so.setVisible(false);
        }
        this.table_parent = new Composite(control, 0);
        this.table_parent.setLayoutData(Utils.getFilledFormData());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.table_parent.setLayout(layout);
        this.tv_subs_results.addSelectionListener(new TableSelectionListener(){

            @Override
            public void selected(TableRowCore[] _rows) {
                this.updateSelectedContent();
            }

            @Override
            public void mouseExit(TableRowCore row) {
            }

            @Override
            public void mouseEnter(TableRowCore row) {
            }

            @Override
            public void focusChanged(TableRowCore focus) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }

            @Override
            public void deselected(TableRowCore[] rows) {
                this.updateSelectedContent();
            }

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
            }

            private void updateSelectedContent() {
                TableRowCore[] rows = SBC_SubscriptionResultsView.this.tv_subs_results.getSelectedRows();
                ArrayList<SelectedContent> valid = new ArrayList<SelectedContent>();
                SBC_SubscriptionResultsView.this.last_selected_content.clear();
                for (int i = 0; i < rows.length; ++i) {
                    SBC_SubscriptionResult rc = (SBC_SubscriptionResult)rows[i].getDataSource();
                    SBC_SubscriptionResultsView.this.last_selected_content.add(rc);
                    byte[] hash = rc.getHash();
                    if (hash == null || hash.length <= 0) continue;
                    SelectedContent sc = new SelectedContent(Base32.encode(hash), rc.getName());
                    sc.setDownloadInfo(new DownloadUrlInfo(SBC_SubscriptionResultsView.this.getDownloadURI(rc)));
                    valid.add(sc);
                }
                ISelectedContent[] sels = valid.toArray(new ISelectedContent[valid.size()]);
                SelectedContentManager.changeCurrentlySelectedContent("IconBarEnabler", sels, SBC_SubscriptionResultsView.this.tv_subs_results);
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        }, false);
        this.tv_subs_results.addLifeCycleListener(new TableLifeCycleListener(){

            @Override
            public void tableViewInitialized() {
                SBC_SubscriptionResultsView.this.reconcileResults(SBC_SubscriptionResultsView.this.ds);
            }

            @Override
            public void tableViewDestroyed() {
            }
        });
        this.tv_subs_results.addMenuFillListener(new TableViewSWTMenuFillListener(){

            @Override
            public void fillMenu(String sColumnName, Menu menu) {
                Object[] _related_content = SBC_SubscriptionResultsView.this.tv_subs_results.getSelectedDataSources().toArray();
                SearchSubsResultBase[] results = new SBC_SubscriptionResult[_related_content.length];
                System.arraycopy(_related_content, 0, results, 0, results.length);
                MenuItem item = new MenuItem(menu, 8);
                item.setText(MessageText.getString("label.copy.url.to.clip"));
                item.addSelectionListener(new SelectionAdapter((SBC_SubscriptionResult[])results){
                    final /* synthetic */ SBC_SubscriptionResult[] val$results;
                    {
                        this.val$results = sBC_SubscriptionResultArray;
                    }

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        StringBuffer buffer = new StringBuffer(1024);
                        for (SBC_SubscriptionResult result : this.val$results) {
                            if (buffer.length() > 0) {
                                buffer.append("\r\n");
                            }
                            buffer.append(SBC_SubscriptionResultsView.this.getDownloadURI(result));
                        }
                        ClipboardCopy.copyToClipBoard(buffer.toString());
                    }
                });
                item.setEnabled(results.length > 0);
                SearchSubsUtils.addMenu(results, menu);
                new MenuItem(menu, 2);
                if (results.length == 1 && SearchSubsUtils.addMenu(results[0], menu)) {
                    new MenuItem(menu, 2);
                }
                MenuItem remove_item = new MenuItem(menu, 8);
                remove_item.setText(MessageText.getString("azbuddy.ui.menu.remove"));
                Utils.setMenuItemImage(remove_item, "delete");
                remove_item.addSelectionListener(new SelectionAdapter((SBC_SubscriptionResult[])results){
                    final /* synthetic */ SBC_SubscriptionResult[] val$results;
                    {
                        this.val$results = sBC_SubscriptionResultArray;
                    }

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        SBC_SubscriptionResultsView.this.userDelete(this.val$results);
                    }
                });
                remove_item.setEnabled(results.length > 0);
                new MenuItem(menu, 2);
            }

            @Override
            public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
            }
        });
        this.tv_subs_results.addKeyListener(new KeyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 127) {
                    Object[] selected;
                    24 var3_2 = this;
                    synchronized (var3_2) {
                        selected = SBC_SubscriptionResultsView.this.tv_subs_results == null ? new Object[]{} : SBC_SubscriptionResultsView.this.tv_subs_results.getSelectedDataSources().toArray();
                    }
                    SBC_SubscriptionResult[] content = new SBC_SubscriptionResult[selected.length];
                    for (int i = 0; i < content.length; ++i) {
                        content[i] = (SBC_SubscriptionResult)selected[i];
                    }
                    SBC_SubscriptionResultsView.this.userDelete(content);
                    e.doit = false;
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.tv_subs_results.initialize(this.table_parent);
        control.layout(true);
    }

    private void userDelete(SBC_SubscriptionResult[] results) {
        TableRowCore focusedRow = this.tv_subs_results.getFocusedRow();
        TableRowCore focusRow = null;
        if (focusedRow != null) {
            int size;
            int i = this.tv_subs_results.indexOf(focusedRow);
            if (i < (size = this.tv_subs_results.size(false)) - 1) {
                focusRow = this.tv_subs_results.getRow(i + 1);
            } else if (i > 0) {
                focusRow = this.tv_subs_results.getRow(i - 1);
            }
        }
        for (SBC_SubscriptionResult result : results) {
            result.delete();
        }
        if (focusRow != null) {
            this.tv_subs_results.setSelectedRows(new TableRowCore[]{focusRow});
        }
    }

    @Override
    public String getUpdateUIName() {
        return "SubscriptionResultsView";
    }

    @Override
    public void updateUI() {
        if (this.tv_subs_results != null) {
            this.tv_subs_results.refreshTable(false);
        }
    }

    @Override
    public boolean filterCheck(SBC_SubscriptionResult ds, String filter2, boolean regex) {
        if (!this.isOurContent(ds)) {
            return false;
        }
        return SearchSubsUtils.filterCheck(ds, filter2, regex);
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        Object[] _related_content;
        if (this.tv_subs_results == null || !this.tv_subs_results.isVisible()) {
            return false;
        }
        if (item.getID().equals("remove") && (_related_content = this.tv_subs_results.getSelectedDataSources().toArray()).length > 0) {
            SBC_SubscriptionResult[] related_content = new SBC_SubscriptionResult[_related_content.length];
            System.arraycopy(_related_content, 0, related_content, 0, related_content.length);
            this.userDelete(related_content);
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        ISelectedContent[] content;
        if (this.tv_subs_results == null || !this.tv_subs_results.isVisible()) {
            return;
        }
        for (ISelectedContent c : content = SelectedContentManager.getCurrentlySelectedContent()) {
            if (c.getDownloadManager() == null) continue;
            return;
        }
        list.put("remove", this.tv_subs_results.getSelectedDataSources().size() > 0 ? 1L : 0L);
    }

    public String getDownloadURI(SBC_SubscriptionResult result) {
        String torrent_url = result.getTorrentLink();
        if (torrent_url != null && torrent_url.length() > 0) {
            return torrent_url;
        }
        String uri = UrlUtils.getMagnetURI(result.getHash(), result.getName(), this.ds.getHistory().getDownloadNetworks());
        return uri;
    }

    static /* synthetic */ String[] access$302(SBC_SubscriptionResultsView x0, String[] x1) {
        x0.with_keywords = x1;
        return x1;
    }

    static /* synthetic */ String[] access$402(SBC_SubscriptionResultsView x0, String[] x1) {
        x0.without_keywords = x1;
        return x1;
    }
}

