/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.core.util.CopyOnWriteMap;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import java.util.Set;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;

public class UISWTViewSkinAdapter {
    private final String skin_folder;
    private final String skin_file;
    private final String wrapper_id;
    private final String target_id;
    private CopyOnWriteMap<UISWTView, ViewHolder> subviews = new CopyOnWriteMap();

    public UISWTViewSkinAdapter(String _skin_folder, String _skin_file, String _wrapper_id, String _target_id) {
        this.skin_folder = _skin_folder;
        this.skin_file = _skin_file;
        this.wrapper_id = _wrapper_id;
        this.target_id = _target_id;
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        UISWTView currentView = event2.getView();
        switch (event2.getType()) {
            case 0: {
                SWTSkin skin = SWTSkinFactory.getNonPersistentInstance(this.getClass().getClassLoader(), this.skin_folder, this.skin_file);
                this.subviews.put(currentView, new ViewHolder(currentView, skin));
                event2.getView().setDestroyOnDeactivate(false);
                break;
            }
            case 2: {
                ViewHolder subview = this.subviews.get(currentView);
                if (subview == null) break;
                subview.initialise((Composite)event2.getData(), currentView.getDataSource());
                break;
            }
            case 1: {
                ViewHolder subview = this.subviews.get(currentView);
                if (subview == null) break;
                subview.setDataSource(event2.getData());
                break;
            }
            case 4: {
                ViewHolder subview = this.subviews.get(currentView);
                if (subview == null) break;
                subview.focusLost();
                break;
            }
            case 3: {
                ViewHolder subview = this.subviews.get(currentView);
                if (subview == null) break;
                subview.focusGained();
                break;
            }
            case 7: {
                ViewHolder subview = this.subviews.remove(currentView);
                if (subview == null) break;
                subview.destroy();
                break;
            }
        }
        return true;
    }

    protected Set<UISWTView> getViews() {
        return this.subviews.keySet();
    }

    private class ViewHolder {
        private final UISWTView view;
        private final SWTSkin skin;
        private SWTSkinObject so;

        private ViewHolder(UISWTView _view, SWTSkin _skin) {
            this.view = _view;
            this.skin = _skin;
        }

        protected void initialise(Composite parent, Object data_source) {
            Composite skin_area = new Composite(parent, 0);
            skin_area.setLayout(new FormLayout());
            skin_area.setLayoutData(new GridData(1808));
            this.skin.initialize(skin_area, UISWTViewSkinAdapter.this.wrapper_id);
            this.so = this.skin.getSkinObjectByID(UISWTViewSkinAdapter.this.target_id);
            this.so.triggerListeners(7, data_source);
            this.so.setVisible(true);
            this.skin.layout();
        }

        protected void setDataSource(Object data_source) {
            if (this.so != null) {
                this.so.triggerListeners(7, data_source);
            }
        }

        public void focusGained() {
            if (this.so != null) {
                this.so.setVisible(true);
            }
        }

        public void focusLost() {
            if (this.so != null) {
                this.so.setVisible(false);
            }
        }

        protected void destroy() {
            if (this.so != null) {
                this.so.dispose();
                this.skin.removeSkinObject(this.so);
                this.so = null;
            }
        }
    }
}

