/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinImageChanger;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinUtils {
    public static final int TILE_NONE = 0;
    public static final int TILE_Y = 1;
    public static final int TILE_X = 2;
    public static final int TILE_CENTER_X = 4;
    public static final int TILE_CENTER_Y = 8;
    public static final int TILE_BOTH = 3;
    private static Listener imageDownListener = new SWTSkinImageChanger("-down", 3, 4);

    public static int getAlignment(String sAlign, int def) {
        int align = sAlign == null ? def : (sAlign.equalsIgnoreCase("center") ? 0x1000000 : (sAlign.equalsIgnoreCase("bottom") ? 1024 : (sAlign.equalsIgnoreCase("top") ? 128 : (sAlign.equalsIgnoreCase("left") ? 16384 : (sAlign.equalsIgnoreCase("right") ? 131072 : def)))));
        return align;
    }

    public static int getTileMode(String sTileMode) {
        int tileMode = 0;
        if (sTileMode == null || sTileMode == "") {
            return tileMode;
        }
        if ((sTileMode = sTileMode.toLowerCase()).equals("tile")) {
            tileMode = 3;
        } else if (sTileMode.equals("tile-x")) {
            tileMode = 2;
        } else if (sTileMode.equals("tile-y")) {
            tileMode = 1;
        } else if (sTileMode.equals("center-x")) {
            tileMode = 4;
        } else if (sTileMode.equals("center-y")) {
            tileMode = 8;
        }
        return tileMode;
    }

    static void addMouseImageChangeListeners(Control widget) {
        if (widget.getData("hasMICL") != null) {
            return;
        }
        widget.addListener(3, imageDownListener);
        widget.addListener(4, imageDownListener);
        widget.setData("hasMICL", "1");
    }

    public static void setVisibility(SWTSkin skin, String configID, String viewID, boolean visible) {
        SWTSkinUtils.setVisibility(skin, configID, viewID, visible, true, false);
    }

    public static void setVisibility(SWTSkin skin, String configID, String viewID, boolean visible, boolean save, boolean fast) {
        SWTSkinObject skinObject = skin.getSkinObject(viewID);
        if (skinObject == null) {
            Debug.out("setVisibility on non existing skin object: " + viewID);
            return;
        }
        if (skinObject.isVisible() == visible && skin.getShell().isVisible()) {
            return;
        }
        Control control = skinObject.getControl();
        if (control != null && !control.isDisposed()) {
            Point size;
            if (visible) {
                FormData fd = (FormData)control.getLayoutData();
                size = (Point)control.getData("v3.oldHeight");
                if (size == null) {
                    size = control.computeSize(-1, -1);
                    if (fd.height > 0) {
                        size.y = fd.height;
                    }
                    if (fd.width > 0) {
                        size.x = fd.width;
                    }
                }
            } else {
                size = new Point(0, 0);
            }
            SWTSkinUtils.setVisibility(skin, configID, skinObject, size, save, fast, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVisibility(SWTSkin skin, String configID, SWTSkinObject skinObject, Point destSize, boolean save, boolean fast, Runnable runAfterSlide) {
        boolean visible = destSize.x != 0 || destSize.y != 0;
        try {
            if (skinObject == null) {
                return;
            }
            Control control = skinObject.getControl();
            if (control != null && !control.isDisposed()) {
                if (visible) {
                    FormData fd = (FormData)control.getLayoutData();
                    fd.width = 0;
                    fd.height = 0;
                    control.setData("oldSize", new Point(0, 0));
                    skinObject.setVisible(visible);
                    fd = (FormData)control.getLayoutData();
                    if (fd.width != 0 || fd.height != 0) {
                        return;
                    }
                    if (fd.width != destSize.x || fd.height != destSize.y) {
                        if (fast) {
                            fd.width = destSize.x;
                            fd.height = destSize.y;
                            control.setLayoutData(fd);
                            Utils.relayout(control);
                        } else {
                            SWTSkinUtils.slide(skinObject, fd, destSize, runAfterSlide);
                            runAfterSlide = null;
                        }
                    }
                    control.setData("v3.oldHeight", null);
                } else {
                    FormData fd = (FormData)control.getLayoutData();
                    if (fd != null) {
                        Point oldSize = new Point(fd.width, fd.height);
                        if (oldSize.y <= 0) {
                            oldSize = null;
                        }
                        control.setData("v3.oldHeight", oldSize);
                        if (fast) {
                            skinObject.setVisible(false);
                        } else {
                            SWTSkinUtils.slide(skinObject, fd, destSize, runAfterSlide);
                            runAfterSlide = null;
                        }
                    }
                }
            }
        }
        finally {
            if (save && COConfigurationManager.getBooleanParameter(configID) != visible) {
                COConfigurationManager.setParameter(configID, visible);
            }
            if (runAfterSlide != null) {
                runAfterSlide.run();
            }
        }
    }

    public static void slide(final SWTSkinObject skinObject, final FormData fd, final Point destSize, final Runnable runOnCompletion) {
        final Control control = skinObject.getControl();
        Boolean exit = Utils.execSWTThreadWithBool("slide", new AERunnableBoolean(){

            @Override
            public boolean runSupport() {
                boolean exit = control.getData("slide.active") != null;
                Runnable oldROC = (Runnable)control.getData("slide.runOnCompletion");
                if (oldROC != null) {
                    oldROC.run();
                }
                control.setData("slide.destSize", destSize);
                control.setData("slide.runOnCompletion", runOnCompletion);
                if (destSize.y > 0) {
                    skinObject.setVisible(true);
                }
                return exit;
            }
        }, 1000L);
        if (exit == null || exit.booleanValue()) {
            return;
        }
        AERunnable runnable = new AERunnable(){
            boolean firstTime = true;
            float pct = 0.4f;

            @Override
            public void runSupport() {
                if (control.isDisposed()) {
                    return;
                }
                Point size = (Point)control.getData("slide.destSize");
                if (size == null) {
                    return;
                }
                if (this.firstTime) {
                    this.firstTime = false;
                    control.setData("slide.active", "1");
                }
                int newWidth = (int)((float)fd.width + (float)(size.x - fd.width) * this.pct);
                int h = fd.height >= 0 ? fd.height : control.getSize().y;
                int newHeight = (int)((float)h + (float)(size.y - h) * this.pct);
                this.pct = (float)((double)this.pct + 0.01);
                if (newWidth == fd.width && newHeight == h) {
                    Runnable oldROC;
                    fd.width = size.x;
                    fd.height = size.y;
                    control.setLayoutData(fd);
                    Utils.relayout(control);
                    control.getParent().layout();
                    control.setData("slide.active", null);
                    control.setData("slide.destSize", null);
                    if (newHeight == 0) {
                        skinObject.setVisible(false);
                        Utils.relayout(control);
                    }
                    if ((oldROC = (Runnable)control.getData("slide.runOnCompletion")) != null) {
                        control.setData("slide.runOnCompletion", null);
                        oldROC.run();
                    }
                } else {
                    fd.width = newWidth;
                    fd.height = newHeight;
                    control.setLayoutData(fd);
                    control.getParent().layout();
                    Utils.execSWTThreadLater(20, this);
                }
            }
        };
        control.getDisplay().asyncExec(runnable);
    }

    public static SWTSkinObjectBrowser findBrowserSO(SWTSkinObject so) {
        if (so instanceof SWTSkinObjectBrowser) {
            return (SWTSkinObjectBrowser)so;
        }
        if (so instanceof SWTSkinObjectContainer) {
            SWTSkinObjectContainer soContainer = (SWTSkinObjectContainer)so;
            SWTSkinObject[] children = soContainer.getChildren();
            for (int i = 0; i < children.length; ++i) {
                SWTSkinObject child = children[i];
                SWTSkinObjectBrowser found = SWTSkinUtils.findBrowserSO(child);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static class MouseEnterExitListener
    implements Listener {
        boolean bOver = false;

        public MouseEnterExitListener(Widget widget) {
            widget.addListener(5, this);
            widget.addListener(7, this);
        }

        @Override
        public void handleEvent(Event event2) {
            Control control = (Control)event2.widget;
            SWTSkinObject skinObject = (SWTSkinObject)control.getData("SkinObject");
            if (event2.type == 5) {
                if (this.bOver) {
                    return;
                }
                System.out.println(System.currentTimeMillis() + ": " + skinObject + "-- OVER");
                this.bOver = true;
                skinObject.switchSuffix("-over", 2, true);
            } else {
                this.bOver = false;
                System.out.println(System.currentTimeMillis() + ": " + skinObject + "-- NOOVER");
                skinObject.switchSuffix("", 2, true);
            }
        }
    }
}

