/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText_UrlClickedListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectText1
extends SWTSkinObjectBasic
implements SWTSkinObjectText {
    String sText;
    String sKey;
    boolean bIsTextDefault = false;
    Label label;
    private int style;

    public SWTSkinObjectText1(SWTSkin skin, SWTSkinProperties skinProperties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parent) {
        super(skin, skinProperties, sID, sConfigID, "text", parent);
        int align;
        String sPrefix = sConfigID + ".text";
        this.style = this.properties.getBooleanValue(sPrefix + ".wrap", true) ? 64 : 0;
        String sAlign = skinProperties.getStringValue(sConfigID + ".align");
        if (sAlign != null && (align = SWTSkinUtils.getAlignment(sAlign, 0)) != 0) {
            this.style |= align;
        }
        if (skinProperties.getIntValue(sConfigID + ".border", 0) == 1) {
            this.style |= 0x800;
        }
        Composite createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
        boolean bKeepMaxSize = this.properties.getStringValue(sConfigID + ".keepMaxSize", "").equals("1");
        this.label = bKeepMaxSize ? new LabelNoShrink(createOn, this.style) : new Label(createOn, this.style);
        this.setControl(this.label);
        if (typeParams.length > 1) {
            this.bIsTextDefault = true;
            this.sText = typeParams[1];
            this.label.setText(this.sText);
        }
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        Font existingFont;
        Color color;
        String text;
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = this.sConfigID + ".text";
        if ((this.sText == null || this.bIsTextDefault) && (text = this.properties.getStringValue(sPrefix + suffix)) != null) {
            this.label.setText(text);
        }
        if ((color = this.properties.getColor(sPrefix + ".color" + suffix)) != null) {
            this.label.setForeground(color);
        }
        if ((existingFont = (Font)this.label.getData("Font" + suffix)) != null && !existingFont.isDisposed()) {
            this.label.setFont(existingFont);
        } else {
            String sStyle;
            boolean bNewFont = false;
            float fontSize = -1.0f;
            int iFontWeight = -1;
            String sFontFace = null;
            String sSize = this.properties.getStringValue(sPrefix + ".size" + suffix);
            if (sSize != null) {
                FontData[] fd = this.label.getFont().getFontData();
                try {
                    char firstChar = sSize.charAt(0);
                    if (firstChar == '+' || firstChar == '-') {
                        sSize = sSize.substring(1);
                    }
                    if (sSize.endsWith("%")) {
                        sSize = sSize.substring(0, sSize.length() - 1);
                        float pctSize = NumberFormat.getInstance(Locale.US).parse(sSize).floatValue();
                        fontSize = FontUtils.getHeight(fd) * pctSize;
                    } else {
                        float dSize = NumberFormat.getInstance(Locale.US).parse(sSize).floatValue();
                        fontSize = firstChar == '+' ? (float)((int)(fd[0].height + dSize)) : (firstChar == '-' ? (float)((int)(fd[0].height - dSize)) : dSize);
                        if (sSize.endsWith("px")) {
                            fontSize = FontUtils.getFontHeightFromPX(this.label.getFont(), null, (int)dSize);
                        } else if (sSize.endsWith("rem")) {
                            fontSize = FontUtils.getHeight(fd) * dSize;
                        }
                    }
                    bNewFont = true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if ((sStyle = this.properties.getStringValue(sPrefix + ".style" + suffix)) != null) {
                String[] sStyles = Constants.PAT_SPLIT_COMMA.split(sStyle.toLowerCase());
                for (int i = 0; i < sStyles.length; ++i) {
                    String s = sStyles[i];
                    if (s.equals("bold")) {
                        iFontWeight = iFontWeight == -1 ? 1 : (iFontWeight |= 1);
                        bNewFont = true;
                    }
                    if (s.equals("italic")) {
                        iFontWeight = iFontWeight == -1 ? 2 : (iFontWeight |= 2);
                        bNewFont = true;
                    }
                    if (s.equals("underline")) {
                        this.label.addPaintListener(new PaintListener(){

                            @Override
                            public void paintControl(PaintEvent e) {
                                Point size = ((Control)e.widget).getSize();
                                e.gc.drawLine(0, size.y - 1, size.x - 1, size.y - 1);
                            }
                        });
                    }
                    if (!s.equals("strike")) continue;
                    this.label.addPaintListener(new PaintListener(){

                        @Override
                        public void paintControl(PaintEvent e) {
                            Point size = ((Control)e.widget).getSize();
                            int y = size.y / 2;
                            e.gc.drawLine(0, y, size.x - 1, y);
                        }
                    });
                }
            }
            if ((sFontFace = this.properties.getStringValue(sPrefix + ".font" + suffix)) != null) {
                bNewFont = true;
            }
            if (bNewFont) {
                FontData[] fd = this.label.getFont().getFontData();
                if (fontSize > 0.0f) {
                    FontUtils.setFontDataHeight(fd, fontSize);
                }
                if (iFontWeight >= 0) {
                    fd[0].setStyle(iFontWeight);
                }
                if (sFontFace != null) {
                    fd[0].setName(sFontFace);
                }
                final Font labelFont = new Font((Device)this.label.getDisplay(), fd);
                this.label.setFont(labelFont);
                this.label.addDisposeListener(new DisposeListener(){

                    @Override
                    public void widgetDisposed(DisposeEvent e) {
                        labelFont.dispose();
                    }
                });
                this.label.setData("Font" + suffix, labelFont);
            }
        }
        this.label.update();
        return suffix;
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (text.equals(this.sText)) {
            return;
        }
        this.sText = text;
        this.sKey = null;
        this.bIsTextDefault = false;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectText1.this.label != null && !SWTSkinObjectText1.this.label.isDisposed()) {
                    SWTSkinObjectText1.this.label.setText(SWTSkinObjectText1.this.sText);
                    Utils.relayout(SWTSkinObjectText1.this.label);
                }
            }
        });
    }

    @Override
    public void setTextID(final String key) {
        if (key == null) {
            this.setText("");
        } else if (key.equals(this.sKey)) {
            return;
        }
        this.sText = MessageText.getString(key);
        this.sKey = key;
        this.bIsTextDefault = false;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectText1.this.label != null && !SWTSkinObjectText1.this.label.isDisposed()) {
                    Messages.setLanguageText(SWTSkinObjectText1.this.label, key);
                    Utils.relayout(SWTSkinObjectText1.this.label);
                }
            }
        });
    }

    @Override
    public void setTextID(final String key, final String[] params) {
        if (key == null) {
            this.setText("");
        } else if (key.equals(this.sKey)) {
            return;
        }
        this.sText = MessageText.getString(key);
        this.sKey = key;
        this.bIsTextDefault = false;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectText1.this.label != null && !SWTSkinObjectText1.this.label.isDisposed()) {
                    Messages.setLanguageText((Widget)SWTSkinObjectText1.this.label, key, params);
                    Utils.relayout(SWTSkinObjectText1.this.label);
                }
            }
        });
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(int style) {
        this.style = style;
    }

    @Override
    public String getText() {
        return this.sText;
    }

    @Override
    public void addUrlClickedListener(SWTSkinObjectText_UrlClickedListener l) {
    }

    @Override
    public void removeUrlClickedListener(SWTSkinObjectText_UrlClickedListener l) {
    }

    @Override
    public void setTextColor(Color color) {
    }

    private static class LabelNoShrink
    extends Label {
        Point ptMax = new Point(0, 0);

        public LabelNoShrink(Composite parent, int style) {
            super(parent, style | 0x1000000);
        }

        @Override
        public void checkSubclass() {
        }

        @Override
        public Point computeSize(int wHint, int hHint, boolean changed) {
            Point pt = super.computeSize(wHint, hHint, changed);
            if (pt.x > this.ptMax.x) {
                this.ptMax.x = pt.x;
            }
            if (pt.y > this.ptMax.y) {
                this.ptMax.y = pt.y;
            }
            return this.ptMax;
        }
    }
}

