/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.util.AECallback;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableWithCallback;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectImage2
extends SWTSkinObjectBasic {
    protected static final Long DRAW_SCALE = new Long(1L);
    protected static final Long DRAW_SCALEDOWN_OR_CENTER = new Long(8L);
    protected static final Long DRAW_STRETCH = new Long(2L);
    protected static final Long DRAW_NORMAL = new Long(0L);
    protected static final Long DRAW_LEFT = new Long(7L);
    protected static final Long DRAW_TILE = new Long(3L);
    protected static final Long DRAW_CENTER = new Long(4L);
    protected static final Long DRAW_HCENTER = new Long(5L);
    protected static final Long DRAW_ANIMATE = new Long(6L);
    private Canvas canvas;
    private boolean customImage = false;
    private String customImageID = null;
    private String currentImageID;
    private static PaintListener paintListener = new PaintListener(){

        @Override
        public void paintControl(PaintEvent e) {
            Image[] images;
            Long drawMode;
            try {
                e.gc.setAdvanced(true);
                e.gc.setInterpolation(2);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Canvas control = (Canvas)e.widget;
            Image imgSrc = (Image)control.getData("image");
            Integer drawAlpha = (Integer)control.getData("drawAlpha");
            if (drawAlpha != null) {
                e.gc.setAlpha(drawAlpha);
            }
            if ((drawMode = (Long)control.getData("drawmode")) == DRAW_ANIMATE && (images = (Image[])control.getData("images")) != null) {
                int idx = ((Number)control.getData("ImageIndex")).intValue();
                imgSrc = images[idx];
            }
            Image imgRight = null;
            Image imgLeft = null;
            String idToRelease = null;
            ImageLoader imageLoader = null;
            if (imgSrc == null || imgSrc.isDisposed()) {
                String imageID;
                SWTSkinObjectImage2 soImage = (SWTSkinObjectImage2)control.getData("SkinObject");
                imageLoader = soImage.getSkin().getImageLoader(soImage.getProperties());
                if (imageLoader.imageExists(imageID = (String)control.getData("ImageID"))) {
                    idToRelease = imageID;
                    Image[] images2 = imageLoader.getImages(imageID);
                    if (images2.length == 3) {
                        imgLeft = images2[0];
                        imgSrc = images2[1];
                        imgRight = images2[2];
                    } else {
                        imgSrc = images2[0];
                    }
                } else {
                    return;
                }
            }
            Rectangle imgSrcBounds = imgSrc.getBounds();
            Rectangle imgSrcBoundsAdj = Utils.adjustPXForDPI(imgSrcBounds);
            Point size = control.getSize();
            if (drawMode == DRAW_SCALEDOWN_OR_CENTER) {
                drawMode = size.x < imgSrcBounds.width || size.y < imgSrcBounds.height ? DRAW_SCALE : DRAW_CENTER;
            }
            if (drawMode == DRAW_STRETCH) {
                e.gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, 0, 0, size.x, size.y);
            } else if (drawMode == DRAW_LEFT) {
                e.gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, 0, 0, imgSrcBoundsAdj.width, imgSrcBoundsAdj.height);
            } else if (drawMode == DRAW_NORMAL || drawMode == DRAW_CENTER || drawMode == DRAW_ANIMATE) {
                int y;
                int x;
                if ((control.getStyle() & 0x20000) != 0) {
                    x = size.x - imgSrcBoundsAdj.width;
                    y = (size.y - imgSrcBoundsAdj.height) / 2;
                } else {
                    x = (size.x - imgSrcBoundsAdj.width) / 2;
                    y = (size.y - imgSrcBoundsAdj.height) / 2;
                }
                e.gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, x, y, imgSrcBoundsAdj.width, imgSrcBoundsAdj.height);
            } else if (drawMode == DRAW_HCENTER) {
                int x = (size.x - imgSrcBounds.width) / 2;
                int y = 0;
                e.gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, x, y, imgSrcBoundsAdj.width, imgSrcBoundsAdj.height);
            } else if (drawMode == DRAW_SCALE) {
                float dx = (float)size.x / (float)imgSrcBounds.width;
                float dy = (float)size.y / (float)imgSrcBounds.height;
                float d = Math.min(dx, dy);
                int newX = (int)((float)imgSrcBounds.width * d);
                int newY = (int)((float)imgSrcBounds.height * d);
                e.gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, (size.x - newX) / 2, (size.y - newY) / 2, newX, newY);
            } else {
                int x0 = 0;
                int y0 = 0;
                int x1 = size.x;
                int y1 = size.y;
                if (imgRight == null) {
                    imgRight = (Image)control.getData("image-right");
                }
                if (imgRight != null) {
                    int width = Utils.adjustPXForDPI(imgRight.getBounds().width);
                    x1 -= width;
                }
                if (imgLeft == null) {
                    imgLeft = (Image)control.getData("image-left");
                }
                if (imgLeft != null) {
                    e.gc.drawImage(imgLeft, 0, 0);
                    x0 += Utils.adjustPXForDPI(imgLeft.getBounds().width);
                }
                for (int y = y0; y < y1; y += imgSrcBoundsAdj.height) {
                    for (int x = x0; x < x1; x += imgSrcBoundsAdj.width) {
                        e.gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, x, y, imgSrcBoundsAdj.width, imgSrcBoundsAdj.height);
                    }
                }
                if (imgRight != null) {
                    Rectangle imgRightBounds = imgRight.getBounds();
                    Rectangle imgRightBoundsAdj = Utils.adjustPXForDPI(imgRightBounds);
                    e.gc.drawImage(imgRight, 0, 0, imgRightBounds.width, imgRightBounds.height, x1, 0, imgRightBoundsAdj.width, imgRightBoundsAdj.height);
                }
            }
            if (idToRelease != null && imageLoader != null) {
                imageLoader.releaseImage(idToRelease);
            }
        }
    };
    private int h_align;
    private int drawAlpha = 255;

    public SWTSkinObjectImage2(SWTSkin skin, SWTSkinProperties skinProperties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, skinProperties, sID, sConfigID, "image", parent);
        this.setControl(this.createImageWidget(sConfigID));
    }

    private Canvas createImageWidget(String sConfigID) {
        String sCursor;
        String sURL;
        String propImageID = this.properties.getStringValue(sConfigID + ".imageid");
        this.currentImageID = propImageID != null ? (this.customImageID = propImageID) : sConfigID;
        int style = 0x20000040;
        String sAlign = this.properties.getStringValue(sConfigID + ".align");
        if (sAlign != null && !Constants.isUnix) {
            this.h_align = SWTSkinUtils.getAlignment(sAlign, 0);
            if (this.h_align != 0) {
                style |= this.h_align;
            }
        }
        if (this.properties.getIntValue(sConfigID + ".border", 0) == 1) {
            style |= 0x800;
        }
        Composite createOn = this.parent == null ? this.skin.getShell() : (Composite)this.parent.getControl();
        this.canvas = new Canvas(createOn, style);
        this.canvas.setData("SkinObject", this);
        Color color = this.properties.getColor(sConfigID + ".color");
        if (color != null) {
            this.canvas.setBackground(color);
        }
        if ((sURL = this.properties.getStringValue(sConfigID + ".url")) != null && sURL.length() > 0) {
            this.canvas.setToolTipText(sURL);
            this.canvas.addListener(4, new Listener(){

                @Override
                public void handleEvent(Event arg0) {
                    Utils.launch(UrlUtils.encode(sURL));
                }
            });
        }
        if ((sCursor = this.properties.getStringValue(sConfigID + ".cursor")) != null && sCursor.length() > 0 && sCursor.equalsIgnoreCase("hand")) {
            this.canvas.addListener(6, this.skin.getHandCursorListener(this.canvas.getDisplay()));
            this.canvas.addListener(7, this.skin.getHandCursorListener(this.canvas.getDisplay()));
        }
        this.canvas.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                String oldImageID = (String)SWTSkinObjectImage2.this.canvas.getData("ImageID");
                if (oldImageID != null && SWTSkinObjectImage2.this.canvas.getData("image") != null) {
                    ImageLoader imageLoader = SWTSkinObjectImage2.this.skin.getImageLoader(SWTSkinObjectImage2.this.properties);
                    imageLoader.releaseImage(oldImageID);
                }
            }
        });
        this.swt_reallySetImage();
        return this.canvas;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    SWTSkinObjectImage2.this.swt_reallySetImage();
                }
            });
        }
    }

    protected void setCanvasImage(String sImageID, AECallback callback) {
        this.setCanvasImage(this.sConfigID, sImageID, callback);
    }

    private void setCanvasImage(final String sConfigID, final String sImageID, AECallback callback) {
        Utils.execSWTThread(new AERunnableWithCallback(callback){

            @Override
            public Object runSupport() {
                if (SWTSkinObjectImage2.this.canvas == null || SWTSkinObjectImage2.this.canvas.isDisposed()) {
                    return null;
                }
                SWTSkinObjectImage2.this.canvas.setData("drawAlpha", SWTSkinObjectImage2.this.drawAlpha);
                String oldImageID = (String)SWTSkinObjectImage2.this.canvas.getData("ImageID");
                if (sImageID != null && sImageID.equals(oldImageID)) {
                    return null;
                }
                ImageLoader imageLoader = SWTSkinObjectImage2.this.skin.getImageLoader(SWTSkinObjectImage2.this.properties);
                if (oldImageID != null && SWTSkinObjectImage2.this.canvas.getData("image") != null) {
                    imageLoader.releaseImage(oldImageID);
                }
                int hpadding = SWTSkinObjectImage2.this.properties.getIntValue(sConfigID + ".h-padding", 0);
                SWTSkinObjectImage2.this.canvas.setData("hpadding", new Long(hpadding));
                Image[] images = sImageID == null || sImageID.length() == 0 ? null : imageLoader.getImages(sImageID);
                String sDrawMode = SWTSkinObjectImage2.this.properties.getStringValue(sConfigID + ".drawmode");
                if (sDrawMode == null) {
                    sDrawMode = SWTSkinObjectImage2.this.properties.getStringValue(SWTSkinObjectImage2.this.sConfigID + ".drawmode", "");
                }
                Long drawMode = sDrawMode.equals("scale") ? DRAW_SCALE : (sDrawMode.equals("scaledown") ? DRAW_SCALEDOWN_OR_CENTER : (sDrawMode.equals("stretch") ? DRAW_STRETCH : (sDrawMode.equals("center") ? DRAW_CENTER : (sDrawMode.equals("h-center") ? DRAW_HCENTER : (sDrawMode.equalsIgnoreCase("tile") ? DRAW_TILE : (sDrawMode.equalsIgnoreCase("animate") || sDrawMode.length() == 0 && images != null && images.length > 3 ? DRAW_ANIMATE : (sDrawMode.equalsIgnoreCase("left") ? DRAW_LEFT : DRAW_NORMAL)))))));
                SWTSkinObjectImage2.this.canvas.setData("drawmode", drawMode);
                Image image = null;
                boolean hasExistingDelay = SWTSkinObjectImage2.this.canvas.getData("delay") != null;
                SWTSkinObjectImage2.this.canvas.setData("delay", null);
                if (images == null) {
                    SWTSkinObjectImage2.this.canvas.setData("images", null);
                    image = null;
                } else if (drawMode == DRAW_ANIMATE) {
                    int animationDelay = ImageLoader.getInstance().getAnimationDelay(sImageID);
                    SWTSkinObjectImage2.this.canvas.setData("images", images);
                    SWTSkinObjectImage2.this.canvas.setData("ImageIndex", 0L);
                    SWTSkinObjectImage2.this.canvas.setData("delay", new Long(animationDelay));
                    image = images[0];
                    if (!hasExistingDelay) {
                        SWTSkinObjectImage2.this.setupAnimationTrigger(animationDelay);
                    }
                } else if (images.length == 3) {
                    Image imageLeft = images[0];
                    if (ImageLoader.isRealImage(imageLeft)) {
                        SWTSkinObjectImage2.this.canvas.setData("image-left", imageLeft);
                    }
                    image = images[1];
                    Image imageRight = images[2];
                    if (ImageLoader.isRealImage(imageRight)) {
                        SWTSkinObjectImage2.this.canvas.setData("image-right", imageRight);
                    }
                } else if (images.length > 0) {
                    image = images[0];
                }
                if (image == null || image.isDisposed()) {
                    image = ImageLoader.noImage;
                }
                Rectangle imgBounds = image.getBounds();
                if (drawMode != DRAW_CENTER && drawMode != DRAW_HCENTER && drawMode != DRAW_STRETCH && drawMode != DRAW_SCALEDOWN_OR_CENTER) {
                    SWTSkinObjectImage2.this.canvas.setSize(imgBounds.width + hpadding, imgBounds.height);
                    SWTSkinObjectImage2.this.canvas.setData("oldSize", SWTSkinObjectImage2.this.canvas.getSize());
                }
                if (drawMode == DRAW_TILE || drawMode == DRAW_NORMAL || drawMode == DRAW_LEFT || drawMode == DRAW_ANIMATE) {
                    FormData fd = (FormData)SWTSkinObjectImage2.this.canvas.getLayoutData();
                    if (fd == null) {
                        fd = new FormData(imgBounds.width + hpadding, imgBounds.height);
                    } else {
                        fd.width = imgBounds.width + hpadding;
                        fd.height = imgBounds.height;
                    }
                    SWTSkinObjectImage2.this.canvas.setData("oldSize", new Point(fd.width, fd.height));
                    SWTSkinObjectImage2.this.canvas.setLayoutData(fd);
                    Utils.relayout(SWTSkinObjectImage2.this.canvas);
                }
                SWTSkinObjectImage2.this.canvas.removePaintListener(paintListener);
                SWTSkinObjectImage2.this.canvas.addPaintListener(paintListener);
                SWTSkinObjectImage2.this.canvas.setData("ImageID", sImageID);
                SWTSkinObjectImage2.this.canvas.redraw();
                SWTSkinUtils.addMouseImageChangeListeners(SWTSkinObjectImage2.this.canvas);
                if (drawMode != DRAW_ANIMATE) {
                    imageLoader.releaseImage(sImageID);
                }
                return null;
            }
        });
    }

    protected void setupAnimationTrigger(int animationDelay) {
        Utils.execSWTThreadLater(animationDelay, new AERunnable(){

            @Override
            public void runSupport() {
                if (!SWTSkinObjectImage2.this.control.isDisposed()) {
                    Object data = SWTSkinObjectImage2.this.control.getData("delay");
                    if (data == null) {
                        return;
                    }
                    Image[] images = (Image[])SWTSkinObjectImage2.this.control.getData("images");
                    int idx = ((Number)SWTSkinObjectImage2.this.control.getData("ImageIndex")).intValue();
                    if (++idx >= images.length) {
                        idx = 0;
                    }
                    SWTSkinObjectImage2.this.control.setData("ImageIndex", new Long(idx));
                    SWTSkinObjectImage2.this.control.redraw();
                    int delay = ((Number)SWTSkinObjectImage2.this.control.getData("delay")).intValue();
                    SWTSkinObjectImage2.this.setupAnimationTrigger(delay);
                }
            }
        });
    }

    @Override
    public void setBackground(String sConfigID, String sSuffix) {
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        suffix = super.switchSuffix(suffix, level, walkUp, walkDown);
        if (this.customImage) {
            return suffix;
        }
        if (suffix == null) {
            return null;
        }
        final String fSuffix = suffix;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinObjectImage2.this.currentImageID = (SWTSkinObjectImage2.this.customImageID == null ? SWTSkinObjectImage2.this.sConfigID + ".image" : SWTSkinObjectImage2.this.customImageID) + fSuffix;
                if (SWTSkinObjectImage2.this.isVisible()) {
                    SWTSkinObjectImage2.this.swt_reallySetImage();
                }
            }
        });
        return suffix;
    }

    protected void swt_reallySetImage() {
        if (this.currentImageID == null || this.customImage) {
            this.drawAlpha = 255;
            return;
        }
        boolean removedDisabled = false;
        ImageLoader imageLoader = this.skin.getImageLoader(this.properties);
        boolean imageExists = imageLoader.imageExists(this.currentImageID);
        if (!imageExists && imageLoader.imageExists(this.currentImageID + ".image")) {
            this.currentImageID = this.sConfigID + ".image";
            imageExists = true;
        }
        if (!imageExists && this.suffixes != null) {
            for (int i = this.suffixes.length - 1; i >= 0; --i) {
                String suffixToRemove = this.suffixes[i];
                if (suffixToRemove == null) continue;
                if (suffixToRemove.equals("-disabled")) {
                    removedDisabled = true;
                }
                this.currentImageID = this.currentImageID.substring(0, this.currentImageID.length() - suffixToRemove.length());
                if (!imageLoader.imageExists(this.currentImageID)) continue;
                imageExists = true;
                break;
            }
        }
        if (imageExists) {
            this.drawAlpha = removedDisabled ? 64 : 255;
            this.setCanvasImage(this.currentImageID, null);
        } else {
            this.drawAlpha = 255;
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    FormData fd = (FormData)SWTSkinObjectImage2.this.canvas.getLayoutData();
                    if (fd == null) {
                        fd = new FormData(0, 0);
                    } else {
                        fd.width = 0;
                        fd.height = 0;
                    }
                    SWTSkinObjectImage2.this.canvas.setLayoutData(fd);
                    if (SWTSkinObjectImage2.this.initialized) {
                        Utils.relayout(SWTSkinObjectImage2.this.canvas);
                    }
                }
            });
        }
    }

    public void setImage(final Image image) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinObjectImage2.this.customImage = true;
                SWTSkinObjectImage2.this.customImageID = null;
                SWTSkinObjectImage2.this.drawAlpha = 255;
                SWTSkinObjectImage2.this.canvas.setData("image", image);
                SWTSkinObjectImage2.this.canvas.setData("ImageID", null);
                SWTSkinObjectImage2.this.canvas.setData("image-left", null);
                SWTSkinObjectImage2.this.canvas.setData("image-right", null);
                SWTSkinObjectImage2.this.canvas.setData("drawAlpha", null);
                SWTSkinObjectImage2.this.canvas.removePaintListener(paintListener);
                SWTSkinObjectImage2.this.canvas.addPaintListener(paintListener);
                Utils.relayout(SWTSkinObjectImage2.this.canvas);
                SWTSkinObjectImage2.this.canvas.redraw();
            }
        });
    }

    public void setImageByID(final String imageID, final AECallback callback) {
        if (!this.customImage && this.customImageID != null && this.customImageID.equals(imageID)) {
            if (callback != null) {
                callback.callbackFailure(null);
            }
            return;
        }
        this.customImage = false;
        this.customImageID = imageID;
        if (imageID == null) {
            this.setCanvasImage(this.sConfigID, null, null);
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                String fullImageID = imageID + SWTSkinObjectImage2.this.getSuffix();
                ImageLoader imageLoader = SWTSkinObjectImage2.this.skin.getImageLoader(SWTSkinObjectImage2.this.properties);
                Image image = imageLoader.getImage(fullImageID);
                if (ImageLoader.isRealImage(image)) {
                    SWTSkinObjectImage2.this.setCanvasImage(SWTSkinObjectImage2.this.sConfigID, fullImageID, callback);
                } else {
                    SWTSkinObjectImage2.this.setCanvasImage(SWTSkinObjectImage2.this.sConfigID, imageID, callback);
                }
                imageLoader.releaseImage(fullImageID);
            }
        });
    }

    public void setImageUrl(final String url) {
        if (!this.customImage && this.customImageID != null && this.customImageID.equals(url)) {
            return;
        }
        this.customImage = false;
        this.customImageID = url;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                final ImageLoader imageLoader = SWTSkinObjectImage2.this.skin.getImageLoader(SWTSkinObjectImage2.this.properties);
                imageLoader.getUrlImage(url, new ImageLoader.ImageDownloaderListener(){

                    @Override
                    public void imageDownloaded(Image image, boolean returnedImmediately) {
                        SWTSkinObjectImage2.this.setCanvasImage(url, null);
                        imageLoader.releaseImage(url);
                    }
                });
            }
        });
    }
}

