/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectCombo
extends SWTSkinObjectBasic {
    private Combo widget;
    private String text = "";

    public SWTSkinObjectCombo(SWTSkin skin, SWTSkinProperties properties, String id, String configID, SWTSkinObject parentSkinObject) {
        super(skin, properties, id, configID, "combo", parentSkinObject);
        Composite createOn = this.parent == null ? skin.getShell() : (Composite)this.parent.getControl();
        int style = 2048;
        String styleString = properties.getStringValue(this.sConfigID + ".style");
        if (styleString != null) {
            Object[] styles = Constants.PAT_SPLIT_COMMA.split(styleString.toLowerCase());
            Arrays.sort(styles);
            if (Arrays.binarySearch(styles, "readonly") >= 0) {
                style |= 8;
            }
        }
        this.widget = new Combo(createOn, style);
        this.widget.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                SWTSkinObjectCombo.this.text = SWTSkinObjectCombo.this.widget.getText();
            }
        });
        this.setControl(this.widget);
        this.updateFont("");
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = this.sConfigID + ".text";
        String text = this.properties.getStringValue(sPrefix + suffix);
        if (text != null) {
            this.setText(text);
        }
        return suffix;
    }

    public void setText(final String val) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectCombo.this.widget != null && !SWTSkinObjectCombo.this.widget.isDisposed()) {
                    SWTSkinObjectCombo.this.widget.setText(val == null ? "" : val);
                    SWTSkinObjectCombo.this.text = val;
                }
            }
        });
    }

    public String getText() {
        return this.text;
    }

    public void setList(final String[] list) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectCombo.this.widget != null && !SWTSkinObjectCombo.this.widget.isDisposed()) {
                    SWTSkinObjectCombo.this.widget.setItems(list);
                }
            }
        });
    }

    public Combo getComboControl() {
        return this.widget;
    }

    private void updateFont(String suffix) {
        String sPrefix = this.sConfigID + ".text";
        Font existingFont = (Font)this.widget.getData("Font" + suffix);
        if (existingFont != null && !existingFont.isDisposed()) {
            this.widget.setFont(existingFont);
        } else {
            FontData[] fd;
            String sSize;
            boolean bNewFont = false;
            float fontSize = -1.0f;
            String sFontFace = null;
            FontData[] tempFontData = this.widget.getFont().getFontData();
            sFontFace = this.properties.getStringValue(sPrefix + ".font" + suffix);
            if (sFontFace != null) {
                tempFontData[0].setName(sFontFace);
                bNewFont = true;
            }
            if ((sSize = this.properties.getStringValue(sPrefix + ".size" + suffix)) != null) {
                fd = this.widget.getFont().getFontData();
                sSize = sSize.trim();
                try {
                    char firstChar = sSize.charAt(0);
                    char lastChar = sSize.charAt(sSize.length() - 1);
                    if (firstChar == '+' || firstChar == '-') {
                        sSize = sSize.substring(1);
                    } else if (lastChar == '%') {
                        sSize = sSize.substring(0, sSize.length() - 1);
                    }
                    float dSize = NumberFormat.getInstance(Locale.US).parse(sSize).floatValue();
                    fontSize = lastChar == '%' ? FontUtils.getHeight(fd) * (dSize / 100.0f) : (firstChar == '+' ? (float)((int)(fd[0].height + dSize)) : (firstChar == '-' ? (float)((int)(fd[0].height - dSize)) : (sSize.endsWith("px") ? FontUtils.getFontHeightFromPX(this.widget.getDisplay(), tempFontData, null, (int)dSize) : (sSize.endsWith("rem") ? FontUtils.getHeight(fd) * dSize : FontUtils.getFontHeightFromPX(this.widget.getDisplay(), tempFontData, null, Utils.adjustPXForDPI((int)dSize))))));
                    bNewFont = true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (bNewFont) {
                fd = this.widget.getFont().getFontData();
                if (fontSize > 0.0f) {
                    FontUtils.setFontDataHeight(fd, fontSize);
                }
                if (sFontFace != null) {
                    fd[0].setName(sFontFace);
                }
                final Font textWidgetFont = new Font((Device)this.widget.getDisplay(), fd);
                this.widget.setFont(textWidgetFont);
                this.widget.addDisposeListener(new DisposeListener(){

                    @Override
                    public void widgetDisposed(DisposeEvent e) {
                        textWidgetFont.dispose();
                    }
                });
                this.widget.setData("Font" + suffix, textWidgetFont);
            }
        }
    }
}

