/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinCheckboxListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectCheckbox
extends SWTSkinObjectBasic {
    private Button button;
    private boolean checked;
    private List<SWTSkinCheckboxListener> buttonListeners = new CopyOnWriteArrayList<SWTSkinCheckboxListener>();

    public SWTSkinObjectCheckbox(SWTSkin skin, SWTSkinProperties properties, String id, String configID, SWTSkinObject parentSkinObject) {
        super(skin, properties, id, configID, "checkbox", parentSkinObject);
        Composite createOn = this.parent == null ? skin.getShell() : (Composite)this.parent.getControl();
        createOn.setBackgroundMode(2);
        int style = 96;
        String[] styles = properties.getStringArray(configID + ".style");
        if (styles != null) {
            for (String s : styles) {
                if (!s.toLowerCase().equals("radio")) continue;
                style = 0x10 | style & 0xFFFFFFDF;
            }
        }
        this.button = new Button(createOn, style);
        this.checked = false;
        this.button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SWTSkinObjectCheckbox.this.checked = SWTSkinObjectCheckbox.this.button.getSelection();
                for (SWTSkinCheckboxListener l : SWTSkinObjectCheckbox.this.buttonListeners) {
                    try {
                        l.checkboxChanged(SWTSkinObjectCheckbox.this, SWTSkinObjectCheckbox.this.checked);
                    }
                    catch (Exception ex) {
                        Debug.out(ex);
                    }
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl(this.button);
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = this.sConfigID + ".text";
        String text = this.properties.getStringValue(sPrefix + suffix);
        if (text != null) {
            this.setText(text);
        }
        return suffix;
    }

    public void addSelectionListener(SWTSkinCheckboxListener listener) {
        if (this.buttonListeners.contains(listener)) {
            return;
        }
        this.buttonListeners.add(listener);
    }

    public void setText(final String text) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectCheckbox.this.button != null && !SWTSkinObjectCheckbox.this.button.isDisposed()) {
                    SWTSkinObjectCheckbox.this.button.setText(text);
                }
            }
        });
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean b) {
        this.checked = b;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectCheckbox.this.button != null && !SWTSkinObjectCheckbox.this.button.isDisposed()) {
                    SWTSkinObjectCheckbox.this.button.setSelection(SWTSkinObjectCheckbox.this.checked);
                }
            }
        });
    }
}

