/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectButton
extends SWTSkinObjectBasic {
    private Button button;
    private ArrayList<SWTSkinButtonUtility.ButtonListenerAdapter> buttonListeners = new ArrayList(1);
    private boolean textOverride;
    private String imageID;

    public SWTSkinObjectButton(SWTSkin skin, SWTSkinProperties properties, String id, String configID, SWTSkinObject parentSkinObject) {
        super(skin, properties, id, configID, "button", parentSkinObject);
        Composite createOn = this.parent == null ? skin.getShell() : (Composite)this.parent.getControl();
        Control c = null;
        if (Constants.isWindows) {
            createOn = new Composite(createOn, 0);
            createOn.setLayout(new FormLayout());
            createOn.setBackgroundMode(2);
            c = createOn;
        }
        this.button = new Button(createOn, 8);
        if (Constants.isWindows) {
            this.button.setLayoutData(Utils.getFilledFormData());
        } else {
            c = this.button;
        }
        this.button.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Object[] listeners = SWTSkinObjectButton.this.buttonListeners.toArray();
                for (int i = 0; i < listeners.length; ++i) {
                    SWTSkinButtonUtility.ButtonListenerAdapter l = (SWTSkinButtonUtility.ButtonListenerAdapter)listeners[i];
                    l.pressed(null, SWTSkinObjectButton.this, e.stateMask);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl(c);
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = this.sConfigID + ".text";
        String text = this.properties.getStringValue(sPrefix + suffix);
        if (text != null) {
            this.setText(text, true);
        }
        String fSuffix = suffix;
        String oldImageID = this.imageID;
        this.imageID = this.sConfigID + ".image" + fSuffix;
        String imageVal = this.properties.getStringValue(this.imageID);
        if (imageVal != null) {
            if (oldImageID != null) {
                ImageLoader imageLoader = this.skin.getImageLoader(this.properties);
                imageLoader.releaseImage(oldImageID);
            }
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (SWTSkinObjectButton.this.button != null && !SWTSkinObjectButton.this.button.isDisposed() && SWTSkinObjectButton.this.imageID != null) {
                        ImageLoader imageLoader = SWTSkinObjectButton.this.skin.getImageLoader(SWTSkinObjectButton.this.properties);
                        Image image = imageLoader.getImage(SWTSkinObjectButton.this.imageID);
                        if (ImageLoader.isRealImage(image)) {
                            SWTSkinObjectButton.this.button.setImage(image);
                        } else {
                            SWTSkinObjectButton.this.button.setImage(null);
                        }
                    }
                }
            });
        }
        return suffix;
    }

    public void addSelectionListener(SWTSkinButtonUtility.ButtonListenerAdapter listener) {
        if (this.buttonListeners.contains(listener)) {
            return;
        }
        this.buttonListeners.add(listener);
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    private void setText(final String text, boolean auto) {
        if (!auto) {
            this.textOverride = true;
        } else if (this.textOverride) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectButton.this.button != null && !SWTSkinObjectButton.this.button.isDisposed()) {
                    int minWidth;
                    SWTSkinObjectButton.this.button.setText(text);
                    int width = SWTSkinObjectButton.this.properties.getIntValue(SWTSkinObjectButton.this.sConfigID + ".width", -1);
                    if (width == -1 && (minWidth = SWTSkinObjectButton.this.properties.getIntValue(SWTSkinObjectButton.this.sConfigID + ".minwidth", -1)) >= 0) {
                        minWidth = Utils.adjustPXForDPI(minWidth);
                        FormData fd = (FormData)SWTSkinObjectButton.this.button.getLayoutData();
                        if (fd == null) {
                            fd = new FormData();
                        }
                        Point size = SWTSkinObjectButton.this.button.computeSize(-1, -1);
                        fd.width = size.x < minWidth ? minWidth : -1;
                        SWTSkinObjectButton.this.button.setLayoutData(fd);
                        Utils.relayout(SWTSkinObjectButton.this.control);
                    }
                }
            }
        });
    }

    public Button getButton() {
        return this.button;
    }
}

