/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.opentorrent;

import com.aelitis.azureus.ui.swt.shells.opentorrent.OpenTorrentOptionsWindow;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class TableColumnOTOT_Size
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "size";

    public TableColumnOTOT_Size(TableColumn column) {
        column.initialize(1, -2, 80, -2);
        column.addListeners(this);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        if (!(ds instanceof OpenTorrentOptionsWindow.OpenTorrentInstance)) {
            return;
        }
        OpenTorrentOptionsWindow.OpenTorrentInstance instance = (OpenTorrentOptionsWindow.OpenTorrentInstance)ds;
        long total_size = instance.getOptions().getTotalSize();
        long selected_size = instance.getSelectedDataSize();
        if (cell.setSortValue(selected_size)) {
            String sel_str;
            String total_str = DisplayFormatters.formatByteCountToKiBEtc(total_size);
            String string = sel_str = total_size == selected_size ? total_str : DisplayFormatters.formatByteCountToKiBEtc(selected_size);
            if (total_str.equals(sel_str)) {
                cell.setText(total_str);
            } else {
                cell.setText(sel_str + " / " + total_str);
            }
        }
    }
}

