/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.opentorrent;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.shells.main.UIFunctionsImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCheckbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.StandardButtonsArea;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.StringIterator;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.UIConfigDefaultsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class OpenTorrentWindow
implements TorrentDownloaderCallBackInterface,
UIUpdatable {
    protected static String CONFIG_REFERRER_DEFAULT = "openUrl.referrer.default";
    private Shell shellForChildren;
    private Shell parent;
    private SkinnedDialog dlg;
    private StandardButtonsArea buttonsArea;
    private Button btnPasteOpen;
    private SWTSkinObjectTextbox soTextArea;
    private SWTSkinObject soReferArea;
    private Combo referrer_combo;
    private String last_referrer;
    private StringList referrers;
    private SWTSkinObjectCheckbox soShowAdvanced;

    public OpenTorrentWindow(Shell parent) {
        this.parent = parent;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                OpenTorrentWindow.this.swt_createWindow();
            }
        });
    }

    private void swt_createWindow() {
        SWTSkinObject soButtonArea;
        this.dlg = new SkinnedDialog("skin3_dlg_opentorrent", "shell", 2160);
        this.shellForChildren = this.dlg.getShell();
        SWTSkin skin = this.dlg.getSkin();
        SWTSkinObject soTopBar = skin.getSkinObject("add-buttons");
        if (soTopBar instanceof SWTSkinObjectContainer) {
            this.swt_addButtons(((SWTSkinObjectContainer)soTopBar).getComposite());
        }
        this.soTextArea = (SWTSkinObjectTextbox)skin.getSkinObject("text-area");
        Text tb = (Text)this.soTextArea.getControl();
        tb.setFocus();
        tb.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                int userMode = COConfigurationManager.getIntParameter("User Mode");
                if (userMode > 0 && OpenTorrentWindow.this.soReferArea != null) {
                    String text = ((Text)e.widget).getText();
                    boolean hasURL = UrlUtils.parseTextForURL(text, false, true) != null;
                    OpenTorrentWindow.this.soReferArea.setVisible(hasURL);
                }
            }
        });
        SWTSkinObject so = skin.getSkinObject("show-advanced");
        if (so instanceof SWTSkinObjectCheckbox) {
            this.soShowAdvanced = (SWTSkinObjectCheckbox)so;
            this.soShowAdvanced.setChecked(COConfigurationManager.getBooleanParameter("ui.addtorrent.openoptions"));
        }
        this.soReferArea = skin.getSkinObject("refer-area");
        this.last_referrer = COConfigurationManager.getStringParameter(CONFIG_REFERRER_DEFAULT, "");
        so = skin.getSkinObject("refer-combo");
        if (so instanceof SWTSkinObjectContainer) {
            this.referrer_combo = new Combo(((SWTSkinObjectContainer)so).getComposite(), 2048);
            this.referrer_combo.setLayoutData(Utils.getFilledFormData());
            this.referrers = COConfigurationManager.getStringListParameter("url_open_referrers");
            StringIterator iter = this.referrers.iterator();
            while (iter.hasNext()) {
                this.referrer_combo.add(iter.next());
            }
            if (this.last_referrer != null) {
                this.referrer_combo.setText(this.last_referrer);
            }
        }
        if ((soButtonArea = skin.getSkinObject("button-area")) instanceof SWTSkinObjectContainer) {
            this.buttonsArea = new StandardButtonsArea(){

                @Override
                protected void clicked(int intValue) {
                    String referrer = null;
                    if (OpenTorrentWindow.this.referrer_combo != null) {
                        referrer = OpenTorrentWindow.this.referrer_combo.getText().trim();
                    }
                    if (OpenTorrentWindow.this.dlg != null) {
                        OpenTorrentWindow.this.dlg.close();
                    }
                    if (intValue == 32 && OpenTorrentWindow.this.soTextArea != null && OpenTorrentWindow.this.soTextArea.getText().length() > 0) {
                        OpenTorrentWindow.this.openTorrent(OpenTorrentWindow.this.soTextArea.getText(), referrer);
                    }
                }
            };
            this.buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")});
            this.buttonsArea.setButtonVals(new Integer[]{32, 256});
            this.buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
        }
        UIUpdaterSWT.getInstance().addUpdater(this);
        this.dlg.open("otw", false);
        this.dlg.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            @Override
            public void skinDialogClosed(SkinnedDialog dialog) {
                OpenTorrentWindow.this.dispose();
            }
        });
    }

    protected void openTorrent(String text, String newReferrer) {
        if (newReferrer != null && newReferrer.length() > 0) {
            if (!this.referrers.contains(newReferrer)) {
                this.referrers.add(newReferrer);
                COConfigurationManager.setParameter("url_open_referrers", this.referrers);
                COConfigurationManager.save();
            }
            COConfigurationManager.setParameter(CONFIG_REFERRER_DEFAULT, newReferrer);
            COConfigurationManager.save();
        }
        String[] splitters = new String[]{"\r\n", "\n", "\r", "\t"};
        String[] lines = null;
        for (int i = 0; i < splitters.length; ++i) {
            if (!text.contains(splitters[i])) continue;
            lines = text.split(splitters[i]);
            break;
        }
        if (lines == null) {
            lines = new String[]{text};
        }
        TorrentOpener.openTorrentsFromStrings(new TorrentOpenOptions(), this.parent, null, lines, newReferrer, this, false);
    }

    protected void dispose() {
        UIUpdaterSWT.getInstance().removeUpdater(this);
    }

    private void swt_addButtons(Composite parent) {
        Composite cButtons = new Composite(parent, 0);
        RowLayout rLayout = new RowLayout(256);
        rLayout.marginBottom = 0;
        rLayout.marginLeft = 0;
        rLayout.marginRight = 0;
        rLayout.marginTop = 0;
        cButtons.setLayout(rLayout);
        cButtons.setLayoutData(Utils.getFilledFormData());
        Button browseTorrent = new Button(cButtons, 8);
        Messages.setLanguageText(browseTorrent, "OpenTorrentWindow.addFiles");
        browseTorrent.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                FileDialog fDialog = new FileDialog(OpenTorrentWindow.this.shellForChildren, 4098);
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String fileName = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (fileName != null) {
                    OpenTorrentWindow.this.addTorrentsToWindow(fDialog.getFilterPath(), fDialog.getFileNames());
                }
            }
        });
        Button browseFolder = new Button(cButtons, 8);
        Messages.setLanguageText(browseFolder, "OpenTorrentWindow.addFiles.Folder");
        browseFolder.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                DirectoryDialog fDialog = new DirectoryDialog(OpenTorrentWindow.this.shellForChildren, 0);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.folder"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path != null) {
                    OpenTorrentWindow.this.addTorrentsToWindow(path, null);
                }
            }
        });
        this.btnPasteOpen = new Button(cButtons, 8);
        Messages.setLanguageText(this.btnPasteOpen, "OpenTorrentWindow.addFiles.Clipboard");
        this.btnPasteOpen.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                Clipboard clipboard = new Clipboard(OpenTorrentWindow.this.shellForChildren.getDisplay());
                String sClipText = (String)clipboard.getContents(TextTransfer.getInstance());
                if (sClipText != null) {
                    OpenTorrentWindow.this.addTorrentsFromTextList(sClipText.trim(), false);
                }
            }
        });
        this.btnPasteOpen.setVisible(false);
    }

    private String ensureTrailingSeparator(String sPath) {
        if (sPath == null || sPath.length() == 0 || sPath.endsWith(File.separator)) {
            return sPath;
        }
        return sPath + File.separator;
    }

    private int addTorrentsToWindow(String sTorrentFilePath, String[] sTorrentFilenames) {
        String text = this.soTextArea.getText();
        if ((sTorrentFilePath = this.ensureTrailingSeparator(sTorrentFilePath)) != null && sTorrentFilenames == null) {
            File dir = new File(sTorrentFilePath);
            if (!dir.isDirectory()) {
                return 0;
            }
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    if (FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".torrent")) {
                        return true;
                    }
                    return FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".tor");
                }
            });
            if (files.length == 0) {
                return 0;
            }
            sTorrentFilenames = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                sTorrentFilenames[i] = files[i].getName();
            }
        }
        int numAdded = 0;
        if (sTorrentFilenames != null) {
            for (int i = 0; i < sTorrentFilenames.length; ++i) {
                if (sTorrentFilenames[i] == null || sTorrentFilenames[i].length() == 0) continue;
                String sFileName = (sTorrentFilePath == null ? "" : sTorrentFilePath) + sTorrentFilenames[i];
                File file = new File(sFileName);
                try {
                    if (!UrlUtils.isURL(sFileName) && (!file.exists() || !TorrentUtils.isTorrentFile(sFileName))) continue;
                    if (text.length() > 0) {
                        text = text + "\n";
                    }
                    text = text + sFileName;
                    ++numAdded;
                    continue;
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (numAdded > 0) {
                this.soTextArea.setText(text);
            }
        }
        return numAdded;
    }

    private int addTorrentsFromTextList(String sClipText, boolean bVerifyOnly) {
        int i;
        String[] lines = null;
        int iNumFound = 0;
        int iNoTorrentLines = 0;
        int MAX_CONSECUTIVE_NONTORRENT_LINES = 100;
        String[] splitters = new String[]{"\r\n", "\n", "\r", "\t"};
        for (i = 0; i < splitters.length; ++i) {
            if (!sClipText.contains(splitters[i])) continue;
            lines = sClipText.split(splitters[i]);
            break;
        }
        if (lines == null) {
            lines = new String[]{sClipText};
        }
        for (i = 0; i < lines.length; ++i) {
            boolean ok;
            String line = lines[i].trim();
            if (line.startsWith("\"") && line.endsWith("\"")) {
                line = line.length() < 3 ? "" : line.substring(1, line.length() - 2);
            }
            if (line.length() == 0) {
                ok = false;
            } else if (UrlUtils.isURL(line)) {
                ok = true;
            } else {
                File file = new File(line);
                if (!file.exists()) {
                    ok = false;
                } else if (file.isDirectory()) {
                    if (bVerifyOnly) {
                        ok = true;
                    } else {
                        iNumFound += this.addTorrentsToWindow(lines[i], null);
                        ok = false;
                    }
                } else {
                    ok = true;
                }
            }
            if (!ok) {
                lines[i] = null;
                if (++iNoTorrentLines <= 100) continue;
                break;
            }
            ++iNumFound;
            iNoTorrentLines = 0;
        }
        if (bVerifyOnly) {
            return iNumFound;
        }
        return this.addTorrentsToWindow(null, lines);
    }

    public static void main(String[] args) {
        AzureusCore core = AzureusCoreFactory.create();
        core.start();
        UIConfigDefaultsSWT.initialize();
        Display display = Display.getDefault();
        Colors.getInstance();
        COConfigurationManager.setParameter("User Mode", 2);
        UIFunctionsImpl uiFunctions = new UIFunctionsImpl(null);
        UIFunctionsManager.setUIFunctions(uiFunctions);
        OpenTorrentWindow window = new OpenTorrentWindow(null);
        while (!window.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        core.stop();
    }

    private boolean isDisposed() {
        if (this.dlg == null) {
            return false;
        }
        return this.dlg.isDisposed();
    }

    @Override
    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        if (!(inf.getDeleteFileOnCancel() || state != 6 && state != 4 && state != 5 && state != 3)) {
            File file = inf.getFile();
            boolean done = false;
            if (RSSUtils.isRSSFeed(file)) {
                try {
                    URL url = new URL(inf.getURL());
                    UIManager ui_manager = StaticUtilities.getUIManager(10000L);
                    if (ui_manager != null) {
                        String details = MessageText.getString("subscription.request.add.message", new String[]{inf.getURL()});
                        long res = ui_manager.showMessageBox("subscription.request.add.title", "!" + details + "!", 12L);
                        if (res == 4L) {
                            SubscriptionManager sm = PluginInitializer.getDefaultInterface().getUtilities().getSubscriptionManager();
                            sm.requestSubscription(url);
                            done = true;
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (!done) {
                TorrentUtil.isFileTorrent(file, inf.getURL(), true);
            }
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        if (state != 0) {
            if (state == 3) {
                File file = inf.getFile();
                TorrentOpenOptions torrentOptions = new TorrentOpenOptions();
                if (!TorrentOpener.mergeFileIntoTorrentInfo(file.getAbsolutePath(), inf.getURL(), torrentOptions)) {
                    if (file.exists()) {
                        file.delete();
                    }
                } else {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    boolean b = uif.addTorrentWithOptions(false, torrentOptions);
                    if (!b && file.exists()) {
                        file.delete();
                    }
                }
            } else if (state != 6 && state != 4 && state != 5) {
                if (state == 2) {
                    byte[] bytes;
                    int count = inf.getLastReadCount();
                    int numRead = inf.getTotalRead();
                    if (!inf.getDeleteFileOnCancel() && numRead >= 16384) {
                        inf.cancel();
                    } else if (numRead == count && count > 0 && (bytes = inf.getLastReadBytes())[0] != 100 && bytes[0] != 60) {
                        inf.setDeleteFileOnCancel(false);
                    }
                } else {
                    return;
                }
            }
        }
    }

    @Override
    public void updateUI() {
        boolean bTorrentInClipboard = false;
        Clipboard clipboard = new Clipboard(Display.getDefault());
        String sClipText = (String)clipboard.getContents(TextTransfer.getInstance());
        if (sClipText != null) {
            boolean bl = bTorrentInClipboard = this.addTorrentsFromTextList(sClipText, true) > 0;
        }
        if (this.btnPasteOpen != null && !this.btnPasteOpen.isDisposed() && this.btnPasteOpen.isVisible() != bTorrentInClipboard) {
            this.btnPasteOpen.setVisible(bTorrentInClipboard);
            if (bTorrentInClipboard) {
                this.btnPasteOpen.setToolTipText(sClipText);
            }
        }
        clipboard.dispose();
    }

    @Override
    public String getUpdateUIName() {
        return null;
    }
}

