/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.opentorrent;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedAttributeLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagFeatureFileLocation;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.RegExUtil;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginUtils;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginViewInterface;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.shells.main.UIFunctionsImpl;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOF_Download;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOF_Ext;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOF_Name;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOF_Path;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOF_Position;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOF_Priority;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOF_Size;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOT_Name;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOT_Position;
import com.aelitis.azureus.ui.swt.shells.opentorrent.TableColumnOTOT_Size;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinCheckboxListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCheckbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectExpandBar;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectExpandItem;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSash;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionListWindow;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.TagUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.StandardButtonsArea;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.StringIterator;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerAvailability;
import org.gudy.azureus2.core3.download.DownloadManagerFactory;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenFileOptions;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.UIConfigDefaultsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.config.generic.GenericIntParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.TrackerAvailView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerNameItem;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

public class OpenTorrentOptionsWindow
implements UIUpdatable {
    private static final Map<HashWrapper, OpenTorrentOptionsWindow> active_windows = new HashMap<HashWrapper, OpenTorrentOptionsWindow>();
    private static TimerEventPeriodic active_window_checker;
    private static final String PARAM_DEFSAVEPATH = "Default save path";
    private static final String[] queueLocations;
    private static final String[] startModes;
    public static final String TABLEID_TORRENTS = "OpenTorrentTorrent";
    public static final String TABLEID_FILES = "OpenTorrentFile";
    private SkinnedDialog dlg;
    private ImageLoader image_loader;
    private SWTSkinObjectSash sash_object;
    private StackLayout expand_stack;
    private Composite expand_stack_area;
    private StandardButtonsArea buttonsArea;
    private boolean window_initialised;
    private Button buttonTorrentUp;
    private Button buttonTorrentDown;
    private Button buttonTorrentRemove;
    private List<String> images_to_dispose = new ArrayList<String>();
    private TableViewSWT<OpenTorrentInstance> tvTorrents;
    private Label torrents_info_label;
    private OpenTorrentInstanceListener optionListener;
    private List<OpenTorrentInstance> open_instances = new ArrayList<OpenTorrentInstance>();
    private List<OpenTorrentInstance> selected_instances = new ArrayList<OpenTorrentInstance>();
    private OpenTorrentInstance multi_selection_instance;
    protected Map<String, DiscoveredTag> listDiscoveredTags = new TreeMap<String, DiscoveredTag>();
    protected List<String> listTagsToCreate = new ArrayList<String>();
    private static Comparator tree_comp;

    public static void main(String[] args) {
        try {
            SWTThread.createInstance(new IUIIntializer(){

                @Override
                public void stopIt(boolean isForRestart, boolean isCloseAreadyInProgress) {
                }

                @Override
                public void runInSWTThread() {
                }

                @Override
                public void run() {
                    AzureusCore core = AzureusCoreFactory.create();
                    core.start();
                    UIConfigDefaultsSWT.initialize();
                    Colors.getInstance();
                    UIFunctionsImpl uiFunctions = new UIFunctionsImpl(null);
                    UIFunctionsManager.setUIFunctions(uiFunctions);
                    File file1 = new File("C:\\temp\\test.torrent");
                    File file2 = new File("C:\\temp\\test1.torrent");
                    TOTorrent torrent1 = null;
                    try {
                        torrent1 = TOTorrentFactory.deserialiseFromBEncodedFile(file1);
                    }
                    catch (TOTorrentException e) {
                        e.printStackTrace();
                    }
                    TOTorrent torrent2 = null;
                    try {
                        torrent2 = TOTorrentFactory.deserialiseFromBEncodedFile(file2);
                    }
                    catch (TOTorrentException e) {
                        e.printStackTrace();
                    }
                    COConfigurationManager.setParameter("ui.addtorrent.openoptions.sep", false);
                    COConfigurationManager.setParameter("User Mode", 2);
                    if (torrent1 != null) {
                        OpenTorrentOptionsWindow.addTorrent(new TorrentOpenOptions(null, torrent1, false));
                    }
                    if (torrent2 != null) {
                        OpenTorrentOptionsWindow.addTorrent(new TorrentOpenOptions(null, torrent2, false));
                    }
                }

                @Override
                public void reportPercent(int percent) {
                }

                @Override
                public void reportCurrentTask(String currentTaskString) {
                }

                @Override
                public void removeListener(InitializerListener listener) {
                }

                @Override
                public void initializationComplete() {
                }

                @Override
                public void increaseProgress() {
                }

                @Override
                public void addListener(InitializerListener listener) {
                }

                @Override
                public void abortProgress() {
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenTorrentOptionsWindow addTorrent(final TorrentOpenOptions torrentOptions) {
        TOTorrent torrent = torrentOptions.getTorrent();
        TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
        try {
            final HashWrapper hw = torrent.getHashWrapper();
            Map<HashWrapper, OpenTorrentOptionsWindow> map = active_windows;
            synchronized (map) {
                final OpenTorrentOptionsWindow existing = active_windows.get(hw);
                if (existing != null) {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            existing.swt_activate();
                        }
                    });
                    return existing;
                }
                boolean separate_dialogs = COConfigurationManager.getBooleanParameter("ui.addtorrent.openoptions.sep");
                if (active_window_checker == null) {
                    active_window_checker = SimpleTimer.addPeriodicEvent("awc", 250L, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            Utils.execSWTThread(new AERunnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void runSupport() {
                                    Map map = active_windows;
                                    synchronized (map) {
                                        if (active_windows.size() == 0) {
                                            if (active_window_checker != null) {
                                                active_window_checker.cancel();
                                                active_window_checker = null;
                                            }
                                        } else {
                                            for (OpenTorrentOptionsWindow w : active_windows.values()) {
                                                List instances = w.getInstances();
                                                int num_reject = 0;
                                                int num_accept = 0;
                                                for (OpenTorrentInstance inst : instances) {
                                                    TorrentOpenOptions opts = inst.getOptions();
                                                    int act = opts.getCompleteAction();
                                                    if (act == 2) {
                                                        w.removeInstance(inst);
                                                        ++num_reject;
                                                    } else if (act == 1) {
                                                        ++num_accept;
                                                    }
                                                    if (!opts.getAndClearDirt()) continue;
                                                    inst.refresh();
                                                }
                                                if (num_reject >= instances.size()) {
                                                    w.cancelPressed();
                                                    continue;
                                                }
                                                if (num_accept + num_reject < instances.size()) continue;
                                                w.okPressed();
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
                if (!separate_dialogs && active_windows.size() > 0) {
                    final OpenTorrentOptionsWindow reuse_window = active_windows.values().iterator().next();
                    active_windows.put(hw, reuse_window);
                    t_man.optionsAdded(torrentOptions);
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            reuse_window.swt_addTorrent(hw, torrentOptions);
                        }
                    });
                    return reuse_window;
                }
                final OpenTorrentOptionsWindow new_window = new OpenTorrentOptionsWindow();
                active_windows.put(hw, new_window);
                t_man.optionsAdded(torrentOptions);
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        new_window.swt_addTorrent(hw, torrentOptions);
                    }
                });
                return new_window;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    private OpenTorrentOptionsWindow() {
        this.image_loader = SWTSkinFactory.getInstance().getImageLoader(SWTSkinFactory.getInstance().getSkinProperties());
        this.optionListener = new OpenTorrentInstanceListener(){

            @Override
            public void instanceChanged(OpenTorrentInstance instance) {
                OpenTorrentOptionsWindow.this.updateInstanceInfo();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swt_addTorrent(HashWrapper hash, TorrentOpenOptions torrentOptions) {
        block14: {
            TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
            try {
                if (this.dlg == null) {
                    SWTSkinObject soButtonArea;
                    SWTSkinObject so;
                    this.dlg = new SkinnedDialog("skin3_dlg_opentorrent_options", "shell", 3184);
                    SWTSkin skin_outter = this.dlg.getSkin();
                    if (COConfigurationManager.hasParameter("ui.addtorrent.openoptions", true) && (so = skin_outter.getSkinObject("showagain-area")) != null) {
                        so.setVisible(false);
                    }
                    if ((soButtonArea = skin_outter.getSkinObject("button-area")) instanceof SWTSkinObjectContainer) {
                        this.buttonsArea = new StandardButtonsArea(){

                            @Override
                            protected void clicked(int intValue) {
                                if (intValue == 32) {
                                    OpenTorrentOptionsWindow.this.okPressed();
                                } else if (OpenTorrentOptionsWindow.this.dlg != null) {
                                    OpenTorrentOptionsWindow.this.dlg.close();
                                }
                            }
                        };
                        this.buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")});
                        this.buttonsArea.setButtonVals(new Integer[]{32, 256});
                        this.buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
                    }
                    this.sash_object = (SWTSkinObjectSash)skin_outter.getSkinObject("multi-sash");
                    SWTSkinObjectContainer select_area = (SWTSkinObjectContainer)skin_outter.getSkinObject("torrents-table");
                    this.setupTVTorrents(select_area.getComposite());
                    SWTSkinObjectContainer torrents_info = (SWTSkinObjectContainer)skin_outter.getSkinObject("torrents-info");
                    Composite info_area = torrents_info.getComposite();
                    info_area.setLayout(new GridLayout());
                    this.torrents_info_label = new Label(info_area, 0);
                    Utils.setLayoutData((Control)this.torrents_info_label, new GridData(768));
                    this.sash_object.setVisible(false);
                    this.sash_object.setAboveVisible(false);
                    so = skin_outter.getSkinObject("expand-area");
                    this.expand_stack_area = ((SWTSkinObjectContainer)so).getComposite();
                    this.expand_stack = new StackLayout();
                    this.expand_stack_area.setLayout(this.expand_stack);
                    Composite expand_area = new Composite(this.expand_stack_area, 0);
                    expand_area.setLayout(new FormLayout());
                    this.expand_stack.topControl = expand_area;
                    OpenTorrentInstance instance = new OpenTorrentInstance(hash, expand_area, torrentOptions, this.optionListener);
                    this.addInstance(instance);
                    this.selected_instances.add(instance);
                    UIUpdaterSWT.getInstance().addUpdater(this);
                    this.setupShowAgainOptions(skin_outter);
                    this.dlg.open("otow", false);
                    Map<HashWrapper, OpenTorrentOptionsWindow> map = active_windows;
                    synchronized (map) {
                        int num_active_windows = active_windows.size();
                        Shell shell = this.dlg.getShell();
                        if (num_active_windows > 1) {
                            int max_x = 0;
                            int max_y = 0;
                            for (OpenTorrentOptionsWindow window : active_windows.values()) {
                                if (window == this || !window.isInitialised()) continue;
                                Rectangle rect = window.getBounds();
                                max_x = Math.max(max_x, rect.x);
                                max_y = Math.max(max_y, rect.y);
                            }
                            Rectangle rect = shell.getBounds();
                            rect.x = max_x + 16;
                            rect.y = max_y + 16;
                            shell.setBounds(rect);
                        }
                        Utils.verifyShellRect(shell, true);
                    }
                    this.dlg.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void skinDialogClosed(SkinnedDialog dialog) {
                            try {
                                OpenTorrentOptionsWindow.this.dispose();
                            }
                            finally {
                                Map map = active_windows;
                                synchronized (map) {
                                    Iterator it = active_windows.values().iterator();
                                    while (it.hasNext()) {
                                        OpenTorrentOptionsWindow window = (OpenTorrentOptionsWindow)it.next();
                                        if (window != OpenTorrentOptionsWindow.this) continue;
                                        it.remove();
                                    }
                                    TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
                                    for (OpenTorrentInstance inst : OpenTorrentOptionsWindow.this.open_instances) {
                                        t_man.optionsRemoved(inst.getOptions());
                                    }
                                }
                            }
                        }
                    });
                    this.window_initialised = true;
                    break block14;
                }
                Composite expand_area = new Composite(this.expand_stack_area, 0);
                expand_area.setLayout(new FormLayout());
                OpenTorrentInstance instance = new OpenTorrentInstance(hash, expand_area, torrentOptions, this.optionListener);
                this.addInstance(instance);
                if (!this.sash_object.isVisible()) {
                    this.sash_object.setVisible(true);
                    this.sash_object.setAboveVisible(true);
                    Utils.execSWTThreadLater(0, new Runnable(){

                        @Override
                        public void run() {
                            OpenTorrentOptionsWindow.this.tvTorrents.processDataSourceQueueSync();
                            ArrayList<TableRowCore> rows = new ArrayList<TableRowCore>();
                            for (OpenTorrentInstance instance : OpenTorrentOptionsWindow.this.selected_instances) {
                                TableRowCore row = OpenTorrentOptionsWindow.this.tvTorrents.getRow(instance);
                                if (row == null) continue;
                                rows.add(row);
                            }
                            if (rows.size() > 0) {
                                OpenTorrentOptionsWindow.this.tvTorrents.setSelectedRows(rows.toArray(new TableRowCore[rows.size()]));
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                Debug.out(e);
                Map<HashWrapper, OpenTorrentOptionsWindow> map = active_windows;
                synchronized (map) {
                    active_windows.remove(hash);
                    t_man.optionsRemoved(torrentOptions);
                }
            }
        }
    }

    private boolean isInitialised() {
        return this.window_initialised;
    }

    private List<OpenTorrentInstance> getInstances() {
        return new ArrayList<OpenTorrentInstance>(this.open_instances);
    }

    private void cancelPressed() {
        if (this.dlg != null) {
            this.dlg.close();
        }
    }

    private void okPressed() {
        TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
        boolean all_ok = true;
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        for (final OpenTorrentInstance instance : new ArrayList<OpenTorrentInstance>(this.open_instances)) {
            String dataDir;
            if (!instance.okPressed(dataDir = instance.cmbDataDir.getText())) {
                all_ok = false;
                continue;
            }
            t_man.optionsAccepted(instance.getOptions());
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    TorrentOpener.addTorrent(instance.getOptions());
                }
            });
            this.removeInstance(instance);
        }
        if (all_ok && this.dlg != null) {
            this.dlg.close();
        }
    }

    private void setupShowAgainOptions(SWTSkin skin) {
        SWTSkinObjectCheckbox soNever = (SWTSkinObjectCheckbox)skin.getSkinObject("showagain-never");
        SWTSkinObjectCheckbox soAlways = (SWTSkinObjectCheckbox)skin.getSkinObject("showagain-always");
        SWTSkinObjectCheckbox soMany = (SWTSkinObjectCheckbox)skin.getSkinObject("showagain-manyfile");
        String showAgainMode = COConfigurationManager.getStringParameter("ui.addtorrent.openoptions");
        boolean hasUserChosen = COConfigurationManager.hasParameter("ui.addtorrent.openoptions", true);
        if (soNever != null) {
            soNever.addSelectionListener(new SWTSkinCheckboxListener(){

                @Override
                public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                    COConfigurationManager.setParameter("ui.addtorrent.openoptions", "never");
                }
            });
            if (hasUserChosen) {
                soNever.setChecked("never".equals(showAgainMode));
            }
        }
        if (soAlways != null) {
            soAlways.addSelectionListener(new SWTSkinCheckboxListener(){

                @Override
                public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                    COConfigurationManager.setParameter("ui.addtorrent.openoptions", "always");
                }
            });
            if (hasUserChosen) {
                soAlways.setChecked("always".equals(showAgainMode));
            }
        }
        if (soMany != null) {
            soMany.addSelectionListener(new SWTSkinCheckboxListener(){

                @Override
                public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                    COConfigurationManager.setParameter("ui.addtorrent.openoptions", "many");
                }
            });
            if (hasUserChosen) {
                soMany.setChecked("many".equals(showAgainMode));
            }
        }
    }

    private void setupTVTorrents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout(layout);
        Composite table_area = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        table_area.setLayout(layout);
        GridData gd = new GridData(1808);
        Utils.setLayoutData((Control)table_area, gd);
        Composite button_area = new Composite(parent, 0);
        layout = new GridLayout(5, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginTop = 5;
        button_area.setLayout(layout);
        gd = new GridData(768);
        Utils.setLayoutData((Control)button_area, gd);
        Label label = new Label(button_area, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)label, gd);
        this.buttonTorrentUp = new Button(button_area, 8);
        this.buttonTorrentUp.setImage(this.loadImage("image.toolbar.up"));
        this.buttonTorrentUp.setToolTipText(MessageText.getString("Button.moveUp"));
        this.buttonTorrentUp.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                List<Object> selected = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedDataSources();
                if (selected.size() > 1) {
                    Collections.sort(selected, new Comparator<OpenTorrentInstance>(){

                        @Override
                        public int compare(OpenTorrentInstance o1, OpenTorrentInstance o2) {
                            return o1.getIndex() - o2.getIndex();
                        }
                    });
                }
                boolean modified = false;
                for (OpenTorrentInstance openTorrentInstance : selected) {
                    int index = openTorrentInstance.getIndex();
                    if (index <= 0) continue;
                    OpenTorrentOptionsWindow.this.open_instances.remove(openTorrentInstance);
                    OpenTorrentOptionsWindow.this.open_instances.add(index - 1, openTorrentInstance);
                    modified = true;
                }
                if (modified) {
                    OpenTorrentOptionsWindow.this.swt_updateTVTorrentButtons();
                    OpenTorrentOptionsWindow.this.refreshTVTorrentIndexes();
                }
            }
        });
        this.buttonTorrentDown = new Button(button_area, 8);
        this.buttonTorrentDown.setImage(this.loadImage("image.toolbar.down"));
        this.buttonTorrentDown.setToolTipText(MessageText.getString("Button.moveDown"));
        this.buttonTorrentDown.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                List<Object> selected = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedDataSources();
                if (selected.size() > 1) {
                    Collections.sort(selected, new Comparator<OpenTorrentInstance>(){

                        @Override
                        public int compare(OpenTorrentInstance o1, OpenTorrentInstance o2) {
                            return o2.getIndex() - o1.getIndex();
                        }
                    });
                }
                boolean modified = false;
                for (OpenTorrentInstance openTorrentInstance : selected) {
                    OpenTorrentInstance instance = openTorrentInstance;
                    int index = instance.getIndex();
                    if (index >= OpenTorrentOptionsWindow.this.open_instances.size() - 1) continue;
                    OpenTorrentOptionsWindow.this.open_instances.remove(instance);
                    OpenTorrentOptionsWindow.this.open_instances.add(index + 1, instance);
                    modified = true;
                }
                if (modified) {
                    OpenTorrentOptionsWindow.this.swt_updateTVTorrentButtons();
                    OpenTorrentOptionsWindow.this.refreshTVTorrentIndexes();
                }
            }
        });
        this.buttonTorrentRemove = new Button(button_area, 8);
        this.buttonTorrentRemove.setToolTipText(MessageText.getString("OpenTorrentWindow.torrent.remove"));
        this.buttonTorrentRemove.setImage(this.loadImage("image.toolbar.remove"));
        this.buttonTorrentRemove.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                List<Object> selected = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedDataSources();
                for (Object obj : selected) {
                    OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                    OpenTorrentOptionsWindow.this.removeInstance(instance);
                }
            }
        });
        this.buttonTorrentUp.setEnabled(false);
        this.buttonTorrentDown.setEnabled(false);
        this.buttonTorrentRemove.setEnabled(false);
        label = new Label(button_area, 0);
        gd = new GridData(768);
        Utils.setLayoutData((Control)label, gd);
        TableColumnManager tcm = TableColumnManager.getInstance();
        if (tcm.getDefaultColumnNames(TABLEID_TORRENTS) == null) {
            tcm.registerColumn(OpenTorrentInstance.class, "#", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOT_Position(column);
                }
            });
            tcm.registerColumn(OpenTorrentInstance.class, "torrentname", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOT_Name(column);
                }
            });
            tcm.registerColumn(OpenTorrentInstance.class, "size", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOT_Size(column);
                }
            });
            tcm.setDefaultColumnNames(TABLEID_TORRENTS, new String[]{"#", "torrentname", "size"});
            tcm.setDefaultSortColumnName(TABLEID_TORRENTS, "#");
        }
        this.tvTorrents = TableViewFactory.createTableViewSWT(OpenTorrentInstance.class, TABLEID_TORRENTS, TABLEID_TORRENTS, null, "#", 67586);
        this.tvTorrents.initialize(table_area);
        this.tvTorrents.setRowDefaultHeightEM(1.4f);
        this.tvTorrents.addMenuFillListener(new TableViewSWTMenuFillListener(){

            @Override
            public void fillMenu(String sColumnName, Menu menu) {
                final List<Object> selected = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedDataSources();
                if (selected.size() > 0) {
                    ArrayList<OpenTorrentInstance> instances = new ArrayList<OpenTorrentInstance>(selected.size());
                    ArrayList<OpenTorrentInstance> non_simple_instances = new ArrayList<OpenTorrentInstance>();
                    boolean can_rtlf = false;
                    for (Object o : selected) {
                        OpenTorrentInstance oti = (OpenTorrentInstance)o;
                        instances.add(oti);
                        if (oti.getOptions().isSimpleTorrent()) continue;
                        non_simple_instances.add(oti);
                        if (!oti.canRemoveTopLevelFolder()) continue;
                        can_rtlf = true;
                    }
                    MenuItem item = new MenuItem(menu, 8);
                    Messages.setLanguageText(item, "OpenTorrentWindow.fileList.changeDestination");
                    item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            for (Object obj : selected) {
                                OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                                instance.setSavePath();
                            }
                        }
                    });
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText(item, "OpenTorrentWindow.tlf.remove");
                    item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            for (Object obj : selected) {
                                OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                                if (!instance.canRemoveTopLevelFolder()) continue;
                                instance.removeTopLevelFolder();
                            }
                        }
                    });
                    item.setEnabled(can_rtlf);
                    item = new MenuItem(menu, 32);
                    item.setData(COConfigurationManager.getBooleanParameter("open.torrent.window.rename.on.tlf.change"));
                    Messages.setLanguageText(item, "OpenTorrentWindow.tlf.rename");
                    item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            COConfigurationManager.setParameter("open.torrent.window.rename.on.tlf.change", ((MenuItem)e.widget).getSelection());
                        }
                    });
                    item.setEnabled(non_simple_instances.size() > 0);
                    new MenuItem(menu, 2);
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText(item, "Button.remove");
                    item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            for (Object obj : selected) {
                                OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                                OpenTorrentOptionsWindow.this.removeInstance(instance);
                            }
                        }
                    });
                    new MenuItem(menu, 2);
                }
            }

            @Override
            public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
            }
        });
        this.tvTorrents.addSelectionListener(new TableSelectionListener(){

            @Override
            public void selected(TableRowCore[] rows_not_used) {
                TableRowCore[] rows = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedRows();
                ArrayList<OpenTorrentInstance> instances = new ArrayList<OpenTorrentInstance>();
                for (TableRowCore row : rows) {
                    instances.add((OpenTorrentInstance)row.getDataSource());
                }
                OpenTorrentOptionsWindow.this.selectInstances(instances);
                this.updateButtons();
            }

            @Override
            public void mouseExit(TableRowCore row) {
            }

            @Override
            public void mouseEnter(TableRowCore row) {
            }

            @Override
            public void focusChanged(TableRowCore focus) {
            }

            @Override
            public void deselected(TableRowCore[] rows) {
                this.selected(rows);
            }

            private void updateButtons() {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        OpenTorrentOptionsWindow.this.swt_updateTVTorrentButtons();
                    }
                });
            }

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
            }
        }, false);
    }

    private void addInstance(OpenTorrentInstance instance) {
        this.open_instances.add(instance);
        this.updateDialogTitle();
        instance.initialize();
        this.tvTorrents.addDataSources((OpenTorrentInstance[])new OpenTorrentInstance[]{instance});
        this.updateInstanceInfo();
        this.swt_updateTVTorrentButtons();
    }

    private void selectInstance(OpenTorrentInstance instance) {
        ArrayList<OpenTorrentInstance> instances = new ArrayList<OpenTorrentInstance>();
        if (instance != null) {
            instances.add(instance);
        }
        this.selectInstances(instances);
    }

    private void selectInstances(List<OpenTorrentInstance> _instances) {
        if (((Object)_instances).equals(this.selected_instances)) {
            return;
        }
        final ArrayList<OpenTorrentInstance> instances = new ArrayList<OpenTorrentInstance>(_instances);
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            if (this.open_instances.contains(it.next())) continue;
            it.remove();
        }
        if (instances.size() == 0) {
            if (this.selected_instances.size() > 0 && this.open_instances.contains(this.selected_instances.get(0))) {
                instances.add(this.selected_instances.get(0));
            } else if (this.open_instances.size() > 0) {
                instances.add(this.open_instances.get(0));
            }
        }
        this.selected_instances.clear();
        this.selected_instances.addAll(instances);
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                if (OpenTorrentOptionsWindow.this.multi_selection_instance != null) {
                    OpenTorrentOptionsWindow.this.multi_selection_instance.getComposite().dispose();
                    OpenTorrentOptionsWindow.this.multi_selection_instance = null;
                }
                if (instances.size() == 1) {
                    OpenTorrentInstance first_instance = (OpenTorrentInstance)instances.get(0);
                    ((OpenTorrentOptionsWindow)OpenTorrentOptionsWindow.this).expand_stack.topControl = first_instance.getComposite();
                    OpenTorrentOptionsWindow.this.expand_stack_area.layout(true);
                    first_instance.layout();
                } else {
                    Composite expand_area = new Composite(OpenTorrentOptionsWindow.this.expand_stack_area, 0);
                    expand_area.setLayout(new FormLayout());
                    ArrayList<TorrentOpenOptions> toos = new ArrayList<TorrentOpenOptions>();
                    for (OpenTorrentInstance oti : instances) {
                        toos.add(oti.getOptions());
                    }
                    OpenTorrentOptionsWindow.this.multi_selection_instance = new OpenTorrentInstance(expand_area, toos, OpenTorrentOptionsWindow.this.optionListener);
                    OpenTorrentOptionsWindow.this.multi_selection_instance.initialize();
                    ((OpenTorrentOptionsWindow)OpenTorrentOptionsWindow.this).expand_stack.topControl = OpenTorrentOptionsWindow.this.multi_selection_instance.getComposite();
                    OpenTorrentOptionsWindow.this.expand_stack_area.layout(true);
                    OpenTorrentOptionsWindow.this.multi_selection_instance.layout();
                }
            }
        });
        ArrayList<TableRowCore> rows = new ArrayList<TableRowCore>();
        for (OpenTorrentInstance instance : instances) {
            TableRowCore row = this.tvTorrents.getRow(instance);
            if (row == null) continue;
            rows.add(row);
        }
        this.tvTorrents.setSelectedRows(rows.toArray(new TableRowCore[rows.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInstance(OpenTorrentInstance instance) {
        TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
        Map<HashWrapper, OpenTorrentOptionsWindow> map = active_windows;
        synchronized (map) {
            active_windows.remove(instance.getHash());
            t_man.optionsRemoved(instance.getOptions());
        }
        int index = this.open_instances.indexOf(instance);
        this.open_instances.remove(instance);
        this.updateDialogTitle();
        this.tvTorrents.removeDataSource(instance);
        instance.getComposite().dispose();
        this.updateInstanceInfo();
        if (this.selected_instances.contains(instance) && this.selected_instances.size() > 1) {
            ArrayList<OpenTorrentInstance> temp = new ArrayList<OpenTorrentInstance>(this.selected_instances);
            temp.remove(instance);
            this.selectInstances(temp);
        } else {
            int num_instances = this.open_instances.size();
            if (num_instances > index) {
                this.selectInstance(this.open_instances.get(index));
            } else if (num_instances > 0) {
                this.selectInstance(this.open_instances.get(num_instances - 1));
            } else {
                this.selectInstance(null);
            }
        }
        this.swt_updateTVTorrentButtons();
        this.refreshTVTorrentIndexes();
        instance.dispose();
    }

    private void updateDialogTitle() {
        String text;
        String hide = COConfigurationManager.getStringParameter("adv.setting.ui.torrent.options.title.hide", "");
        if (hide.equals("1")) {
            text = "rand=" + Math.abs(new Random().nextLong());
        } else {
            int num = this.open_instances.size();
            if (num == 1) {
                String str;
                TorrentOpenOptions options = this.open_instances.get(0).getOptions();
                text = options.getTorrentName();
                TOTorrent t = options.getTorrent();
                if (t != null && (str = PlatformTorrentUtils.getContentTitle(t)) != null && str.length() > 0) {
                    text = str;
                }
            } else {
                text = MessageText.getString("label.num.torrents", new String[]{String.valueOf(this.open_instances.size())});
            }
        }
        this.dlg.setTitle(MessageText.getString("OpenTorrentOptions.title") + " [" + text + "]");
    }

    private void swt_updateTVTorrentButtons() {
        List<Object> selected = this.tvTorrents.getSelectedDataSources();
        this.buttonTorrentRemove.setEnabled(selected.size() > 0);
        if (selected.size() > 0) {
            int min_index = Integer.MAX_VALUE;
            int max_index = -1;
            for (Object obj : selected) {
                OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                int index = instance.getIndex();
                min_index = Math.min(min_index, index);
                max_index = Math.max(max_index, index);
            }
            this.buttonTorrentUp.setEnabled(min_index > 0);
            this.buttonTorrentDown.setEnabled(max_index < this.open_instances.size() - 1);
        } else {
            this.buttonTorrentUp.setEnabled(false);
            this.buttonTorrentDown.setEnabled(false);
        }
    }

    private void refreshTVTorrentIndexes() {
        Utils.execSWTThreadLater(0, new Runnable(){

            @Override
            public void run() {
                OpenTorrentOptionsWindow.this.tvTorrents.columnInvalidate("#");
                OpenTorrentOptionsWindow.this.tvTorrents.refreshTable(true);
            }
        });
    }

    private void updateInstanceInfo() {
        String tot_str;
        if (this.torrents_info_label == null) {
            return;
        }
        long total_size = 0L;
        long selected_size = 0L;
        for (OpenTorrentInstance instance : this.open_instances) {
            total_size += instance.getOptions().getTorrent().getSize();
            selected_size += instance.getSelectedDataSize();
        }
        String sel_str = DisplayFormatters.formatByteCountToKiBEtc(selected_size);
        String text = sel_str.equals(tot_str = DisplayFormatters.formatByteCountToKiBEtc(total_size)) ? MessageText.getString("label.n.will.be.downloaded", new String[]{tot_str}) : MessageText.getString("OpenTorrentWindow.filesInfo", new String[]{sel_str, tot_str});
        this.torrents_info_label.setText(text);
    }

    @Override
    public void updateUI() {
        if (this.tvTorrents != null) {
            this.tvTorrents.refreshTable(false);
        }
        for (OpenTorrentInstance instance : this.open_instances) {
            instance.updateUI();
        }
        if (this.multi_selection_instance != null) {
            this.multi_selection_instance.updateUI();
        }
    }

    @Override
    public String getUpdateUIName() {
        return null;
    }

    private void swt_activate() {
        Shell shell = this.dlg.getShell();
        if (!shell.isDisposed()) {
            Utils.dump(shell);
            if (!shell.isVisible()) {
                shell.setVisible(true);
            }
            shell.forceActive();
            shell.layout(true, true);
            Utils.verifyShellRect(shell, true);
            Utils.centreWindow(shell);
            Utils.dump(shell);
        }
    }

    private Rectangle getBounds() {
        return this.dlg.getShell().getBounds();
    }

    private Image loadImage(String key) {
        Image img = this.image_loader.getImage(key);
        if (img != null) {
            this.images_to_dispose.add(key);
        }
        return img;
    }

    private void unloadImage(String key) {
        this.image_loader.releaseImage(key);
    }

    protected void dispose() {
        UIUpdaterSWT.getInstance().removeUpdater(this);
        for (OpenTorrentInstance instance : this.open_instances) {
            instance.dispose();
        }
        for (String key : this.images_to_dispose) {
            this.unloadImage(key);
        }
        this.images_to_dispose.clear();
        this.tvTorrents.delete();
    }

    public boolean checkAlreadyHaveTag(List<Tag> initialTags, String tagName) {
        boolean alreadyHave = false;
        for (Tag tag : initialTags) {
            if (!tagName.equalsIgnoreCase(tag.getTagName(false)) && !tagName.equalsIgnoreCase(tag.getTagName(true))) continue;
            alreadyHave = true;
            break;
        }
        return alreadyHave;
    }

    static {
        queueLocations = new String[]{"first", "last"};
        startModes = new String[]{"queued", "stopped", "forceStarted", "seeding"};
        tree_comp = new FormattersImpl().getAlphanumericComparator(true);
    }

    private static class DiscoveredTag {
        private final String name;
        private final String[] networks;

        private DiscoveredTag(String _name, String[] _networks) {
            this.name = _name;
            this.networks = _networks;
        }
    }

    private static final class FileStatsCacheItem {
        boolean exists;
        long freeSpace;

        public FileStatsCacheItem(File f) {
            this.exists = f.exists();
            this.freeSpace = this.exists ? FileUtil.getUsableSpace(f) : -1L;
        }
    }

    private static class IntAdapter
    extends GenericParameterAdapter {
        private IntAdapter() {
        }

        @Override
        public int getIntValue(String key) {
            return 0;
        }

        @Override
        public int getIntValue(String key, int def) {
            return def;
        }

        @Override
        public boolean resetIntDefault(String key) {
            return false;
        }
    }

    protected class OpenTorrentInstance
    implements TableViewFilterCheck<TorrentOpenFileOptions> {
        private final HashWrapper hash;
        private final TorrentOpenOptions torrentOptions;
        private final List<TorrentOpenOptions> torrentOptionsMulti;
        private final OpenTorrentInstanceListener changeListener;
        private final Composite parent;
        private final Shell shell;
        private SWTSkin skin;
        protected boolean bSkipDataDirModify;
        private Button btnTreeView;
        private Button btnPrivacy;
        private Button btnCheckComments;
        private Button btnCheckAvailability;
        private Button btnSwarmIt;
        private List<Button> network_buttons;
        private Combo cmbDataDir;
        private Combo cmbQueueLocation;
        private Combo cmbStartMode;
        private StringList dirList;
        private volatile boolean diskFreeInfoRefreshPending;
        private volatile boolean diskFreeInfoRefreshRunning;
        private Composite diskspaceComp;
        private long currentSelectedDataSize;
        private final Map fileStatCache;
        private final Map parentToRootCache;
        private SWTSkinObjectExpandItem soExpandItemFiles;
        private SWTSkinObjectExpandItem soExpandItemSaveTo;
        private SWTSkinObjectExpandItem soExpandItemTorrentInfo;
        private SWTSkinObjectText soFileAreaInfo;
        private TableViewSWT<TorrentOpenFileOptions> tvFiles;
        private SWTSkinObjectExpandItem soStartOptionsExpandItem;
        private AtomicInteger settingToDownload;
        private Button btnSelectAll;
        private Button btnMarkSelected;
        private Button btnUnmarkSelected;
        private Button btnRename;
        private Button btnRetarget;
        private Composite tagButtonsArea;
        private boolean treeViewDisableUpdates;
        private Set<TreeNode> treePendingExpansions;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OpenTorrentInstance(HashWrapper _hash, Composite _parent, TorrentOpenOptions _torrentOptions, OpenTorrentInstanceListener _changeListener) {
            block8: {
                this.bSkipDataDirModify = false;
                this.network_buttons = new ArrayList<Button>();
                this.diskFreeInfoRefreshPending = false;
                this.diskFreeInfoRefreshRunning = false;
                this.fileStatCache = new WeakHashMap(20);
                this.parentToRootCache = new WeakHashMap(20);
                this.settingToDownload = new AtomicInteger(0);
                this.treePendingExpansions = new HashSet<TreeNode>();
                this.hash = _hash;
                this.parent = _parent;
                this.torrentOptions = _torrentOptions;
                this.torrentOptionsMulti = new ArrayList<TorrentOpenOptions>();
                this.changeListener = _changeListener;
                this.torrentOptionsMulti.add(this.torrentOptions);
                this.shell = this.parent.getShell();
                this.torrentOptions.addListener(new TorrentOpenOptions.FileListener(){

                    @Override
                    public void toDownloadChanged(TorrentOpenFileOptions fo, boolean toDownload) {
                        TableRowCore row = OpenTorrentInstance.this.tvFiles.getRow(fo);
                        if (row != null) {
                            row.invalidate(true);
                            row.refresh(true);
                        }
                        if (OpenTorrentInstance.this.settingToDownload.get() == 0) {
                            OpenTorrentInstance.this.updateFileButtons();
                            OpenTorrentInstance.this.updateSize();
                        }
                    }

                    @Override
                    public void priorityChanged(TorrentOpenFileOptions fo, int priority) {
                        TableRowCore row = OpenTorrentInstance.this.tvFiles.getRow(fo);
                        if (row != null) {
                            row.invalidate(true);
                            row.refresh(true);
                        }
                    }

                    @Override
                    public void parentDirChanged() {
                        if (OpenTorrentInstance.this.torrentOptions != null && OpenTorrentInstance.this.cmbDataDir != null) {
                            String toText = OpenTorrentInstance.this.torrentOptions.getParentDir();
                            String text = OpenTorrentInstance.this.cmbDataDir.getText();
                            if (!text.equals(toText)) {
                                OpenTorrentInstance.this.cmbDataDir.setText(toText);
                            }
                        }
                    }
                });
                if (TagManagerFactory.getTagManager().isEnabled()) {
                    try {
                        RelatedContentManager rcm = RelatedContentManager.getSingleton();
                        Map<String, Boolean> enabledNetworks = this.torrentOptions.getEnabledNetworks();
                        ArrayList<String> networks = new ArrayList<String>();
                        for (Map.Entry<String, Boolean> entry : enabledNetworks.entrySet()) {
                            if (!entry.getValue().booleanValue()) continue;
                            networks.add(entry.getKey());
                        }
                        if (networks.size() <= 0) break block8;
                        final String[] nets = networks.toArray(new String[networks.size()]);
                        List<String> tag_cache = TorrentUtils.getTagCache(this.torrentOptions.getTorrent());
                        Map<String, DiscoveredTag> map = OpenTorrentOptionsWindow.this.listDiscoveredTags;
                        synchronized (map) {
                            for (String tag : tag_cache) {
                                if (OpenTorrentOptionsWindow.this.listDiscoveredTags.containsKey(tag)) continue;
                                OpenTorrentOptionsWindow.this.listDiscoveredTags.put(tag, new DiscoveredTag(tag, nets));
                            }
                        }
                        rcm.lookupAttributes(this.hash.getBytes(), nets, new RelatedAttributeLookupListener(){

                            @Override
                            public void lookupStart() {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void tagFound(String tag, String network) {
                                if (OpenTorrentOptionsWindow.this.checkAlreadyHaveTag(OpenTorrentInstance.this.torrentOptions.getInitialTags(), tag)) {
                                    return;
                                }
                                Map<String, DiscoveredTag> map = OpenTorrentOptionsWindow.this.listDiscoveredTags;
                                synchronized (map) {
                                    if (OpenTorrentOptionsWindow.this.listDiscoveredTags.containsKey(tag)) {
                                        return;
                                    }
                                    OpenTorrentOptionsWindow.this.listDiscoveredTags.put(tag, new DiscoveredTag(tag, nets));
                                }
                                Utils.execSWTThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (OpenTorrentInstance.this.tagButtonsArea == null || OpenTorrentInstance.this.tagButtonsArea.isDisposed()) {
                                            return;
                                        }
                                        OpenTorrentInstance.this.buildTagButtonPanel(OpenTorrentInstance.this.tagButtonsArea, true);
                                    }
                                });
                            }

                            @Override
                            public void lookupComplete() {
                            }

                            @Override
                            public void lookupFailed(ContentException error) {
                            }
                        });
                    }
                    catch (ContentException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        private OpenTorrentInstance(Composite _parent, List<TorrentOpenOptions> _torrentOptionsMulti, OpenTorrentInstanceListener _changeListener) {
            this.bSkipDataDirModify = false;
            this.network_buttons = new ArrayList<Button>();
            this.diskFreeInfoRefreshPending = false;
            this.diskFreeInfoRefreshRunning = false;
            this.fileStatCache = new WeakHashMap(20);
            this.parentToRootCache = new WeakHashMap(20);
            this.settingToDownload = new AtomicInteger(0);
            this.treePendingExpansions = new HashSet<TreeNode>();
            this.hash = null;
            this.parent = _parent;
            this.torrentOptions = null;
            this.torrentOptionsMulti = new ArrayList<TorrentOpenOptions>(_torrentOptionsMulti);
            this.changeListener = _changeListener;
            this.shell = this.parent.getShell();
        }

        private HashWrapper getHash() {
            return this.hash;
        }

        protected TorrentOpenOptions getOptions() {
            return this.torrentOptions;
        }

        protected int getIndex() {
            return OpenTorrentOptionsWindow.this.open_instances.indexOf(this);
        }

        protected Composite getComposite() {
            return this.parent;
        }

        private void initialize() {
            SWTSkinObject so;
            this.skin = SWTSkinFactory.getNonPersistentInstance(this.getClass().getClassLoader(), "com/aelitis/azureus/ui/skin", "skin3_dlg_opentorrent_options_instance.properties");
            this.skin.initialize(this.parent, "expandview");
            if (this.torrentOptions != null) {
                so = this.skin.getSkinObject("filearea-table");
                if (so instanceof SWTSkinObjectContainer) {
                    this.setupTVFiles((SWTSkinObjectContainer)so, (SWTSkinObjectTextbox)this.skin.getSkinObject("filearea-filter"));
                }
                if ((so = this.skin.getSkinObject("filearea-buttons")) instanceof SWTSkinObjectContainer) {
                    this.setupFileAreaButtons((SWTSkinObjectContainer)so);
                }
            }
            if ((so = this.skin.getSkinObject("disk-space")) instanceof SWTSkinObjectContainer) {
                this.diskspaceComp = (Composite)so.getControl();
                GridLayout gl = new GridLayout(2, false);
                gl.marginWidth = 0;
                gl.marginHeight = 0;
                this.diskspaceComp.setLayout(gl);
                Label l = new Label(this.diskspaceComp, 0);
                l.setText("");
            }
            if (this.torrentOptions != null) {
                so = this.skin.getSkinObject("filearea-info");
                if (so instanceof SWTSkinObjectText) {
                    this.setupFileAreaInfo((SWTSkinObjectText)so);
                }
                if ((so = this.skin.getSkinObject("start-options")) instanceof SWTSkinObjectExpandItem) {
                    this.setupStartOptions((SWTSkinObjectExpandItem)so);
                }
                if ((so = this.skin.getSkinObject("peer-sources")) instanceof SWTSkinObjectContainer) {
                    this.setupPeerSourcesAndNetworkOptions((SWTSkinObjectContainer)so);
                }
                if ((so = this.skin.getSkinObject("trackers")) instanceof SWTSkinObjectContainer) {
                    this.setupTrackers((SWTSkinObjectContainer)so);
                }
                if ((so = this.skin.getSkinObject("updownlimit")) instanceof SWTSkinObjectContainer) {
                    this.setupUpDownLimitOption((SWTSkinObjectContainer)so);
                }
                if ((so = this.skin.getSkinObject("ipfilter")) instanceof SWTSkinObjectContainer) {
                    this.setupIPFilterOption((SWTSkinObjectContainer)so);
                }
            }
            SWTSkinObject so1 = this.skin.getSkinObject("saveto-textarea");
            SWTSkinObject so2 = this.skin.getSkinObject("saveto-browse");
            if (so1 instanceof SWTSkinObjectContainer && so2 instanceof SWTSkinObjectButton) {
                this.setupSaveLocation((SWTSkinObjectContainer)so1, (SWTSkinObjectButton)so2);
            }
            if ((so = this.skin.getSkinObject("expanditem-saveto")) instanceof SWTSkinObjectExpandItem) {
                this.soExpandItemSaveTo = (SWTSkinObjectExpandItem)so;
            }
            if (this.torrentOptions != null) {
                so = this.skin.getSkinObject("expanditem-files");
                if (so instanceof SWTSkinObjectExpandItem) {
                    this.soExpandItemFiles = (SWTSkinObjectExpandItem)so;
                }
                if ((so = this.skin.getSkinObject("expanditem-torrentinfo")) instanceof SWTSkinObjectExpandItem) {
                    this.soExpandItemTorrentInfo = (SWTSkinObjectExpandItem)so;
                    this.soExpandItemTorrentInfo.setText(MessageText.getString("OpenTorrentOptions.header.torrentinfo") + ": " + this.torrentOptions.getTorrentName());
                }
                this.setupInfoFields(this.skin);
                this.updateStartOptionsHeader();
                this.cmbDataDirChanged();
                this.updateSize();
            } else {
                this.cmbDataDirChanged();
            }
            this.skin.layout();
        }

        private void layout() {
            SWTSkinObjectExpandItem so = (SWTSkinObjectExpandItem)this.skin.getSkinObject("expanditem-files");
            SWTSkinObjectExpandBar bar = (SWTSkinObjectExpandBar)so.getParent();
            bar.relayout();
            for (SWTSkinObjectExpandItem item : bar.getChildren()) {
                item.relayout();
            }
        }

        private void refresh() {
            if (this.tagButtonsArea == null || this.tagButtonsArea.isDisposed()) {
                return;
            }
            this.buildTagButtonPanel(this.tagButtonsArea, true);
        }

        private void showTreeView() {
            String str;
            final Shell tree_shell = ShellFactory.createShell(this.shell, 2160);
            Utils.setShellIcon(tree_shell);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            tree_shell.setLayout(layout);
            Utils.verifyShellRect(tree_shell, true);
            TOTorrent t = this.torrentOptions.getTorrent();
            Composite comp2 = new Composite(tree_shell, 0);
            GridData gridData = new GridData(1808);
            Utils.setLayoutData((Control)comp2, gridData);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            comp2.setLayout(layout);
            TOTorrentFile[] torrent_files = t.getFiles();
            TorrentOpenFileOptions[] files = this.torrentOptions.getFiles();
            char file_separator = File.separatorChar;
            final TreeNode root = new TreeNode(null, "");
            final HashMap<TorrentOpenFileOptions, TreeNode> file_map = new HashMap<TorrentOpenFileOptions, TreeNode>();
            for (TorrentOpenFileOptions file : files) {
                int p;
                TreeNode node = root;
                TOTorrentFile t_file = torrent_files[file.getIndex()];
                String path = t_file.getRelativePath();
                int pos = 0;
                int len = path.length();
                do {
                    String bit;
                    if ((p = path.indexOf(file_separator, pos)) == -1) {
                        bit = path.substring(pos);
                    } else {
                        bit = path.substring(pos, p);
                        pos = p + 1;
                    }
                    TreeNode n = node.getChild(bit);
                    if (n == null) {
                        n = new TreeNode(node, bit);
                        node.addChild(n);
                    }
                    node = n;
                } while (p != -1 && pos != len);
                node.setFile(file);
                file_map.put(file, node);
            }
            this.treePendingExpansions.clear();
            final Tree tree = new Tree(comp2, 268438306);
            gridData = new GridData(1808);
            Utils.setLayoutData((Control)tree, gridData);
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
            int[] COL_WIDTHS = new int[]{600, 80, 80};
            TreeColumn column1 = new TreeColumn(tree, 16384);
            column1.setText(MessageText.getString("TableColumn.header.name"));
            TreeColumn column2 = new TreeColumn(tree, 131072);
            column2.setText(MessageText.getString("TableColumn.header.size"));
            TreeColumn column3 = new TreeColumn(tree, 131072);
            column3.setText(MessageText.getString("SpeedView.stats.total"));
            TreeColumn[] columns = new TreeColumn[]{column1, column2, column3};
            SelectionAdapter column_listener = new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    TreeColumn column = (TreeColumn)e.widget;
                    int index = (Integer)column.getData("index");
                    boolean asc = (Boolean)column.getData("asc");
                    asc = !asc;
                    column.setData("asc", asc);
                    OpenTorrentInstance.this.sortTree(tree, root, index, asc);
                }
            };
            for (int i = 0; i < columns.length; ++i) {
                final TreeColumn column = columns[i];
                column.setData("asc", true);
                column.setData("index", i);
                column.addSelectionListener(column_listener);
                final String key = "open.torrent.window.tree.col." + i;
                int width = COConfigurationManager.getIntParameter(key, COL_WIDTHS[i]);
                column.setWidth(Math.max(20, width));
                column.addListener(11, new Listener(){

                    @Override
                    public void handleEvent(Event event2) {
                        COConfigurationManager.setParameter(key, column.getWidth());
                    }
                });
            }
            tree.setData(root);
            tree.addListener(36, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    TreeItem item = (TreeItem)event2.item;
                    TreeItem parentItem = item.getParentItem();
                    TreeNode parent_node = parentItem == null ? root : (TreeNode)parentItem.getData();
                    TreeNode[] kids = parent_node.getChildren();
                    TreeNode node = kids[event2.index];
                    item.setData(node);
                    OpenTorrentInstance.this.updateTreeItem(item, node);
                    TreeNode[] node_kids = node.getChildren();
                    if (node_kids.length > 0) {
                        item.setItemCount(node_kids.length);
                    }
                }
            });
            tree.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    if (event2.detail == 32) {
                        TreeItem item = (TreeItem)event2.item;
                        boolean checked = item.getChecked();
                        TreeNode node = (TreeNode)item.getData();
                        OpenTorrentInstance.this.updateNodeFromTree(tree, item, node, checked);
                    }
                }
            });
            final Menu menu = new Menu(tree);
            tree.setMenu(menu);
            menu.addMenuListener(new MenuAdapter(){

                @Override
                public void menuShown(MenuEvent e) {
                    TreeItem[] items;
                    MenuItem[] menu_items = menu.getItems();
                    for (int i = 0; i < menu_items.length; ++i) {
                        menu_items[i].dispose();
                    }
                    boolean has_selected = false;
                    boolean has_deselected = false;
                    for (TreeItem item : items = tree.getSelection()) {
                        if (item.getChecked()) {
                            has_selected = true;
                            continue;
                        }
                        has_deselected = true;
                    }
                    MenuItem select_item = new MenuItem(menu, 0);
                    select_item.setText(MessageText.getString("label.select"));
                    select_item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            for (TreeItem item : items) {
                                item.setChecked(true);
                                TreeNode node = (TreeNode)item.getData();
                                OpenTorrentInstance.this.updateNodeFromTree(tree, item, node, true);
                            }
                        }
                    });
                    select_item.setEnabled(has_deselected);
                    MenuItem deselect_item = new MenuItem(menu, 0);
                    deselect_item.setText(MessageText.getString("label.deselect"));
                    deselect_item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            for (TreeItem item : items) {
                                item.setChecked(false);
                                TreeNode node = (TreeNode)item.getData();
                                OpenTorrentInstance.this.updateNodeFromTree(tree, item, node, false);
                            }
                        }
                    });
                    deselect_item.setEnabled(has_selected);
                    final TreeItem[] ex_items = items.length == 0 ? tree.getItems() : items;
                    final Set unexpanded_nodes = OpenTorrentInstance.this.getUnExpandedNodes(ex_items);
                    MenuItem expand_item = new MenuItem(menu, 0);
                    expand_item.setText(MessageText.getString("label.expand.all"));
                    expand_item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            OpenTorrentInstance.this.treePendingExpansions.addAll(unexpanded_nodes);
                            OpenTorrentInstance.this.expandItems(ex_items);
                        }
                    });
                    expand_item.setEnabled(unexpanded_nodes.size() > 0);
                }
            });
            tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (e.stateMask == SWT.MOD1 && key == 97) {
                        tree.selectAll();
                    }
                }
            });
            tree.setItemCount(root.getChildren().length);
            Label labelSeparator = new Label(comp2, 258);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)labelSeparator, gridData);
            Composite buttonComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)buttonComp, gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            buttonComp.setLayout(layout);
            new Label(buttonComp, 0);
            Composite buttonArea = new Composite(buttonComp, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            Utils.setLayoutData((Control)buttonArea, gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 1;
            buttonArea.setLayout(layoutButtons);
            ArrayList<Button> buttons = new ArrayList<Button>();
            Button bOK = new Button(buttonArea, 8);
            buttons.add(bOK);
            bOK.setText(MessageText.getString("Button.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bOK, gridData);
            bOK.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    tree_shell.dispose();
                }
            });
            Utils.makeButtonsEqualWidth(buttons);
            tree_shell.setDefaultButton(bOK);
            this.btnTreeView.setEnabled(false);
            final TorrentOpenOptions.FileListener file_listener = new TorrentOpenOptions.FileListener(){

                @Override
                public void toDownloadChanged(TorrentOpenFileOptions file, boolean checked) {
                    OpenTorrentInstance.this.updateNodeFromTable(tree, (TreeNode)file_map.get(file), checked);
                }

                @Override
                public void priorityChanged(TorrentOpenFileOptions torrentOpenFileOptions, int priority) {
                }

                @Override
                public void parentDirChanged() {
                }
            };
            this.torrentOptions.addListener(file_listener);
            tree_shell.addDisposeListener(new DisposeListener(){

                @Override
                public void widgetDisposed(DisposeEvent e) {
                    if (!OpenTorrentInstance.this.btnTreeView.isDisposed()) {
                        OpenTorrentInstance.this.btnTreeView.setEnabled(true);
                        OpenTorrentInstance.this.torrentOptions.removeListener(file_listener);
                    }
                }
            });
            tree_shell.addListener(11, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    Rectangle bounds = tree_shell.getBounds();
                    COConfigurationManager.setParameter("open.torrent.window.tree.size", bounds.width + "," + bounds.height);
                }
            });
            int shell_width = 800;
            int shell_height = 400;
            try {
                String str2 = COConfigurationManager.getStringParameter("open.torrent.window.tree.size", "");
                String[] bits = str2.split(",");
                if (bits.length == 2) {
                    shell_width = Math.max(300, Integer.parseInt(bits[0]));
                    shell_height = Math.max(200, Integer.parseInt(bits[1]));
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            tree_shell.setSize(shell_width, shell_height);
            tree_shell.layout(true, true);
            Utils.centerWindowRelativeTo(tree_shell, this.shell);
            String title = this.torrentOptions.getTorrentName();
            if (t != null && (str = PlatformTorrentUtils.getContentTitle(t)) != null && str.length() > 0) {
                title = str;
            }
            Messages.setLanguageText((Widget)tree_shell, "torrent.files.title", new String[]{title});
            tree_shell.open();
        }

        private void sortTree(Tree tree, TreeNode root, final int col_index, final boolean asc) {
            Comparator<TreeNode> comparator = new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode n1, TreeNode n2) {
                    if (!asc) {
                        TreeNode temp = n1;
                        n1 = n2;
                        n2 = temp;
                    }
                    if (col_index == 0) {
                        String name1 = n1.getName();
                        String name2 = n2.getName();
                        return tree_comp.compare(name1, name2);
                    }
                    if (col_index == 1 || col_index == 2) {
                        long result;
                        long size1 = n1.getSize();
                        long size2 = n2.getSize();
                        if (size1 < 0L) {
                            size1 = -size1;
                        }
                        if (size2 < 0L) {
                            size2 = -size2;
                        }
                        if ((result = size1 - size2) == 0L) {
                            return 0;
                        }
                        if (result < 0L) {
                            return -1;
                        }
                        return 1;
                    }
                    return 0;
                }
            };
            this.getExpandedNodes(tree.getItems(), this.treePendingExpansions);
            tree.removeAll();
            root.sort(comparator);
            tree.setItemCount(root.getChildren().length);
        }

        private void getExpandedNodes(TreeItem[] items, Set<TreeNode> nodes) {
            for (TreeItem item : items) {
                if (item.getExpanded()) {
                    nodes.add((TreeNode)item.getData());
                }
                this.getExpandedNodes(item.getItems(), nodes);
            }
        }

        private Set<TreeNode> getUnExpandedNodes(TreeItem[] items) {
            HashSet<TreeNode> all_nodes = new HashSet<TreeNode>();
            for (TreeItem item : items) {
                this.getNodes((TreeNode)item.getData(), all_nodes, true);
            }
            HashSet<TreeNode> expanded_nodes = new HashSet<TreeNode>();
            this.getExpandedNodes(items, expanded_nodes);
            all_nodes.removeAll(expanded_nodes);
            return all_nodes;
        }

        private void expandItems(TreeItem[] items) {
            for (TreeItem item : items) {
                item.setExpanded(true);
                this.expandItems(item.getItems());
            }
        }

        private void getNodes(TreeNode node, Set<TreeNode> nodes, boolean parents_only) {
            TreeNode[] kids = node.getChildren();
            if (parents_only && kids.length == 0) {
                return;
            }
            nodes.add(node);
            for (TreeNode kid : kids) {
                this.getNodes(kid, nodes, parents_only);
            }
        }

        private void updateTreeItem(final TreeItem item, final TreeNode node) {
            String total_str;
            String size_str;
            long size = node.getSize();
            String abs_size_str = DisplayFormatters.formatByteCountToKiBEtc(Math.abs(size));
            if (size >= 0L) {
                size_str = abs_size_str;
                total_str = "";
            } else {
                size_str = "";
                total_str = abs_size_str;
            }
            item.setText(new String[]{node.getName(), size_str, total_str});
            item.setChecked(node.isChecked());
            item.setGrayed(node.isGrayed());
            item.setForeground(2, Colors.dark_grey);
            if (this.treePendingExpansions.contains(node)) {
                Utils.execSWTThreadLater(1, new Runnable(){

                    @Override
                    public void run() {
                        if (!item.isDisposed()) {
                            item.setExpanded(true);
                            OpenTorrentInstance.this.treePendingExpansions.remove(node);
                        }
                    }
                });
            }
        }

        private TreeItem getItemForNode(Tree tree, TreeNode node) {
            TreeNode parent;
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            nodes.add(node);
            while ((parent = node.getParent()) != null) {
                nodes.add(parent);
                node = parent;
            }
            TreeItem target_item = null;
            for (int i = nodes.size() - 2; i >= 0; --i) {
                TreeItem[] items;
                TreeNode n = (TreeNode)nodes.get(i);
                if (target_item == null) {
                    items = tree.getItems();
                } else {
                    if (target_item.getItemCount() == 0) continue;
                    items = target_item.getItems();
                }
                boolean found = false;
                for (TreeItem item : items) {
                    if (item.getData() != n) continue;
                    target_item = item;
                    found = true;
                    break;
                }
                if (found) continue;
                return null;
            }
            return target_item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateNodeFromTree(Tree tree, TreeItem item, TreeNode node, boolean selected) {
            block10: {
                try {
                    this.treeViewDisableUpdates = true;
                    boolean refresh_path = false;
                    TorrentOpenFileOptions file = node.getFile();
                    if (file != null) {
                        if (file.isToDownload() != selected) {
                            file.setToDownload(selected);
                            refresh_path = true;
                        }
                    } else {
                        item.setGrayed(false);
                        List files = node.getFiles();
                        for (TorrentOpenFileOptions f : files) {
                            if (f.isToDownload() == selected) continue;
                            f.setToDownload(selected);
                            refresh_path = true;
                        }
                        if (refresh_path) {
                            this.updateSubTree(item.getItems());
                        }
                    }
                    if (!refresh_path) break block10;
                    while ((item = item.getParentItem()) != null) {
                        node = node.getParent();
                        item.setChecked(node.isChecked());
                        item.setGrayed(node.isGrayed());
                    }
                }
                finally {
                    this.treeViewDisableUpdates = false;
                }
            }
        }

        private void updateSubTree(TreeItem[] items) {
            for (TreeItem item : items) {
                TreeItem[] sub_items;
                TreeNode node = (TreeNode)item.getData();
                if (node == null) continue;
                boolean checked = node.isChecked();
                if (item.getChecked() != checked) {
                    item.setChecked(checked);
                }
                boolean grayed = node.isGrayed();
                if (item.getGrayed() != grayed) {
                    item.setGrayed(grayed);
                }
                if ((sub_items = item.getItems()).length <= 0) continue;
                this.updateSubTree(sub_items);
            }
        }

        private void updateNodeFromTable(Tree tree, TreeNode node, boolean selected) {
            block5: {
                TreeItem item;
                block6: {
                    if (this.treeViewDisableUpdates) {
                        return;
                    }
                    item = this.getItemForNode(tree, node);
                    if (item == null) break block6;
                    if (item.getChecked() == selected) break block5;
                    item.setChecked(selected);
                    while ((item = item.getParentItem()) != null) {
                        node = node.getParent();
                        item.setChecked(node.isChecked());
                        item.setGrayed(node.isGrayed());
                    }
                    break block5;
                }
                while ((node = node.getParent()) != null) {
                    item = this.getItemForNode(tree, node);
                    if (item == null) continue;
                    while (true) {
                        item.setChecked(node.isChecked());
                        item.setGrayed(node.isGrayed());
                        item = item.getParentItem();
                        if (item != null) {
                            node = node.getParent();
                            continue;
                        }
                        break block5;
                        break;
                    }
                }
            }
        }

        private void showAvailability() {
            String str;
            final Shell avail_shell = ShellFactory.createShell(this.shell, 2160);
            Utils.setShellIcon(avail_shell);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            avail_shell.setLayout(layout);
            Utils.verifyShellRect(avail_shell, true);
            TOTorrent t = this.torrentOptions.getTorrent();
            final TrackerAvailView view = new TrackerAvailView();
            String[] enabled_peer_sources = PEPeerSource.PS_SOURCES;
            if (this.torrentOptions.peerSource != null) {
                ArrayList<String> temp = new ArrayList<String>(Arrays.asList(enabled_peer_sources));
                for (String peerSource : this.torrentOptions.peerSource.keySet()) {
                    boolean enable = this.torrentOptions.peerSource.get(peerSource);
                    if (enable) continue;
                    temp.remove(peerSource);
                }
                enabled_peer_sources = temp.toArray(new String[temp.size()]);
            }
            String[] enabled_networks = AENetworkClassifier.AT_NETWORKS;
            Map<String, Boolean> enabledNetworks = this.torrentOptions.getEnabledNetworks();
            if (enabledNetworks != null) {
                ArrayList<String> temp = new ArrayList<String>(Arrays.asList(enabled_networks));
                for (String net : enabledNetworks.keySet()) {
                    boolean enable = enabledNetworks.get(net);
                    if (enable) continue;
                    temp.remove(net);
                }
                enabled_networks = temp.toArray(new String[temp.size()]);
            }
            final DownloadManagerAvailability availability = DownloadManagerFactory.getAvailability(t, this.torrentOptions.getTrackers(true), enabled_peer_sources, enabled_networks);
            view.dataSourceChanged(availability);
            Composite comp2 = new Composite(avail_shell, 0);
            GridData gridData = new GridData(1808);
            Utils.setLayoutData((Control)comp2, gridData);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            comp2.setLayout(layout);
            view.initialize(comp2);
            view.viewActivated();
            view.refresh();
            final UIUpdatable viewUpdater = new UIUpdatable(){

                @Override
                public void updateUI() {
                    view.refresh();
                }

                @Override
                public String getUpdateUIName() {
                    return view.getFullTitle();
                }
            };
            UIUpdaterSWT.getInstance().addUpdater(viewUpdater);
            Composite progressComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)progressComp, gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            progressComp.setLayout(layout);
            Label progLabel = new Label(progressComp, 0);
            progLabel.setText(MessageText.getString("label.checking.sources"));
            final Composite progBarComp = new Composite(progressComp, 0);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)progBarComp, gridData);
            final StackLayout progStackLayout = new StackLayout();
            progBarComp.setLayout(progStackLayout);
            final ProgressBar progBarIndeterminate = new ProgressBar(progBarComp, 258);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)progBarIndeterminate, gridData);
            final ProgressBar progBarComplete = new ProgressBar(progBarComp, 256);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)progBarComplete, gridData);
            progBarComplete.setMaximum(1);
            progBarComplete.setSelection(1);
            progStackLayout.topControl = progBarIndeterminate;
            new AEThread2("ProgChecker"){

                @Override
                public void run() {
                    boolean currently_updating = true;
                    while (!avail_shell.isDisposed()) {
                        final boolean updating = view.isUpdating();
                        if (updating != currently_updating) {
                            currently_updating = updating;
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (!avail_shell.isDisposed()) {
                                        progStackLayout.topControl = updating ? progBarIndeterminate : progBarComplete;
                                        progBarComp.layout();
                                    }
                                }
                            });
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    return;
                }
            }.start();
            Label labelSeparator = new Label(comp2, 258);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)labelSeparator, gridData);
            Composite buttonComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)buttonComp, gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            buttonComp.setLayout(layout);
            new Label(buttonComp, 0);
            Composite buttonArea = new Composite(buttonComp, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            Utils.setLayoutData((Control)buttonArea, gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 1;
            buttonArea.setLayout(layoutButtons);
            ArrayList<Button> buttons = new ArrayList<Button>();
            Button bOK = new Button(buttonArea, 8);
            buttons.add(bOK);
            bOK.setText(MessageText.getString("Button.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bOK, gridData);
            bOK.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    avail_shell.dispose();
                }
            });
            Utils.makeButtonsEqualWidth(buttons);
            avail_shell.setDefaultButton(bOK);
            avail_shell.addDisposeListener(new DisposeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void widgetDisposed(DisposeEvent e) {
                    try {
                        UIUpdaterSWT.getInstance().removeUpdater(viewUpdater);
                        if (!OpenTorrentInstance.this.btnCheckAvailability.isDisposed()) {
                            OpenTorrentInstance.this.btnCheckAvailability.setEnabled(true);
                        }
                    }
                    finally {
                        availability.destroy();
                    }
                }
            });
            this.btnCheckAvailability.setEnabled(false);
            avail_shell.setSize(800, 400);
            avail_shell.layout(true, true);
            Utils.centerWindowRelativeTo(avail_shell, this.shell);
            String title = this.torrentOptions.getTorrentName();
            if (t != null && (str = PlatformTorrentUtils.getContentTitle(t)) != null && str.length() > 0) {
                title = str;
            }
            Messages.setLanguageText((Widget)avail_shell, "torrent.avail.title", new String[]{title});
            avail_shell.open();
        }

        private void showComments() {
            String str;
            final Shell comments_shell = ShellFactory.createShell(this.shell, 2160);
            Utils.setShellIcon(comments_shell);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            comments_shell.setLayout(layout);
            Utils.verifyShellRect(comments_shell, true);
            TOTorrent torrent = this.torrentOptions.getTorrent();
            String title_temp = this.torrentOptions.getTorrentName();
            if (torrent != null && (str = PlatformTorrentUtils.getContentTitle(torrent)) != null && str.length() > 0) {
                title_temp = str;
            }
            final String title = title_temp;
            String[] enabled_networks = AENetworkClassifier.AT_NETWORKS;
            Map<String, Boolean> enabledNetworks = this.torrentOptions.getEnabledNetworks();
            if (enabledNetworks != null) {
                ArrayList<String> temp = new ArrayList<String>(Arrays.asList(enabled_networks));
                for (String net : enabledNetworks.keySet()) {
                    boolean enable = enabledNetworks.get(net);
                    if (enable) continue;
                    temp.remove(net);
                }
                enabled_networks = temp.toArray(new String[temp.size()]);
            }
            final String[] f_enabled_networks = enabled_networks;
            Composite comp2 = new Composite(comments_shell, 0);
            GridData gridData = new GridData(1808);
            Utils.setLayoutData((Control)comp2, gridData);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            comp2.setLayout(layout);
            Composite topComp = new Composite(comp2, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            topComp.setLayout(layout);
            gridData = new GridData(1808);
            Utils.setLayoutData((Control)topComp, gridData);
            String active_networks_str = "";
            for (String net : enabled_networks) {
                active_networks_str = active_networks_str + (active_networks_str.length() == 0 ? "" : ", ") + MessageText.getString("ConfigView.section.connection.networks." + net);
            }
            if (active_networks_str.length() == 0) {
                active_networks_str = MessageText.getString("PeersView.uniquepiece.none");
            }
            Label info_label = new Label(topComp, 64);
            info_label.setText(MessageText.getString("torrent.comments.info", new String[]{active_networks_str}));
            gridData = new GridData(768);
            gridData.horizontalIndent = 8;
            gridData.verticalIndent = 8;
            Utils.setLayoutData((Control)info_label, gridData);
            Group ratingComp = new Group(topComp, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            ratingComp.setLayout(layout);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)ratingComp, gridData);
            ratingComp.setText("Rating Plugin");
            Composite ratingComp2 = new Composite(ratingComp, 2048);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 4;
            layout.marginHeight = 4;
            ratingComp2.setLayout(layout);
            gridData = new GridData(1808);
            Utils.setLayoutData((Control)ratingComp2, gridData);
            ratingComp2.setBackground(Colors.white);
            final Label ratingText = new Label(ratingComp2, 64);
            gridData = new GridData(768);
            gridData.heightHint = ratingText.getFont().getFontData()[0].getHeight() * 2 + 16;
            Utils.setLayoutData((Control)ratingText, gridData);
            ratingText.setBackground(Colors.white);
            final boolean[] az_rating_in_progress = new boolean[]{false};
            try {
                PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
                PluginInterface rating_pi = pm.getPluginInterfaceByID("azrating");
                if (rating_pi != null) {
                    final IPCInterface ipc = rating_pi.getIPC();
                    if (ipc.canInvoke("lookupRatingByHash", new Object[]{new String[0], new byte[0]})) {
                        az_rating_in_progress[0] = true;
                        ratingText.setText(MessageText.getString("label.searching"));
                        new AEThread2("oto:rat"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Override
                            public void run() {
                                Map result = null;
                                try {
                                    result = (Map)ipc.invoke("lookupRatingByHash", new Object[]{f_enabled_networks, OpenTorrentInstance.this.hash.getBytes()});
                                    boolean[] blArray = az_rating_in_progress;
                                }
                                catch (Throwable e2) {
                                    try {
                                        e2.printStackTrace();
                                        boolean[] e2 = az_rating_in_progress;
                                    }
                                    catch (Throwable throwable) {
                                        boolean[] blArray = az_rating_in_progress;
                                        synchronized (az_rating_in_progress) {
                                            az_rating_in_progress[0] = false;
                                            // ** MonitorExit[var6_8] (shouldn't be in output)
                                            if (ratingText.isDisposed()) throw throwable;
                                            Map f_result = result;
                                            Utils.execSWTThread(new Runnable(f_result){
                                                final /* synthetic */ Map val$f_result;
                                                {
                                                    this.val$f_result = map;
                                                }

                                                @Override
                                                public void run() {
                                                    if (!ratingText.isDisposed()) {
                                                        List ratings;
                                                        String text = "";
                                                        String tooltip = "";
                                                        if (this.val$f_result != null && (ratings = (List)this.val$f_result.get("ratings")) != null) {
                                                            String scores_str = "";
                                                            ArrayList<String> comments = new ArrayList<String>();
                                                            double total_score = 0.0;
                                                            int score_num = 0;
                                                            for (Map map : ratings) {
                                                                try {
                                                                    int score = ((Number)map.get("score")).intValue();
                                                                    total_score += (double)score;
                                                                    ++score_num;
                                                                    scores_str = scores_str + (scores_str.length() == 0 ? "" : ", ") + score;
                                                                    String comment = ImportExportUtils.importString(map, "comment");
                                                                    if (comment == null || (comment = comment.trim()).length() <= 0) continue;
                                                                    comments.add(comment);
                                                                }
                                                                catch (Throwable e) {}
                                                            }
                                                            if (score_num > 0) {
                                                                double average = total_score / (double)score_num;
                                                                text = MessageText.getString("torrent.comment.rat1", new String[]{DisplayFormatters.formatDecimal(average, 1), scores_str});
                                                                int num_comments = comments.size();
                                                                if (num_comments > 0) {
                                                                    text = text + "\n    " + MessageText.getString("torrent.comment.rat2", new String[]{(String)comments.get(0) + (num_comments == 1 ? "" : "...")});
                                                                    for (String comment : comments) {
                                                                        tooltip = tooltip + (tooltip.length() == 0 ? "" : "\n") + comment;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        if (text.length() == 0) {
                                                            text = MessageText.getString("PeersView.uniquepiece.none");
                                                        }
                                                        ratingText.setText(text);
                                                        ratingText.setToolTipText(tooltip);
                                                    }
                                                }
                                            });
                                            throw throwable;
                                        }
                                    }
                                    synchronized (az_rating_in_progress) {
                                        az_rating_in_progress[0] = false;
                                        // ** MonitorExit[e] (shouldn't be in output)
                                        if (ratingText.isDisposed()) return;
                                        Map f_result = result;
                                        Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                                        return;
                                    }
                                }
                                synchronized (az_rating_in_progress) {
                                    az_rating_in_progress[0] = false;
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    if (ratingText.isDisposed()) return;
                                    Map f_result = result;
                                    Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                            }
                        }.start();
                    } else {
                        ratingText.setText("Rating Plugin needs updating");
                    }
                } else {
                    ratingText.setText(MessageText.getString("torrent.comment.azrating.install"));
                }
            }
            catch (Throwable e) {
                ratingText.setText("Rating Plugin failed: " + Debug.getNestedExceptionMessage(e));
            }
            Group chatComp = new Group(topComp, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            chatComp.setLayout(layout);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)chatComp, gridData);
            chatComp.setText("Chat Plugin");
            HashMap<String, Object> chat_properties = new HashMap<String, Object>();
            chat_properties.put("swt_comp", chatComp);
            final String chat_key = BuddyPluginUtils.getChatKey(torrent);
            BuddyPluginViewInterface.DownloadAdapter adapter = new BuddyPluginViewInterface.DownloadAdapter(){

                @Override
                public String[] getNetworks() {
                    return f_enabled_networks;
                }

                @Override
                public DownloadManager getCoreDownload() {
                    return null;
                }

                @Override
                public String getChatKey() {
                    return chat_key;
                }
            };
            chat_properties.put("download", adapter);
            final HashSet activated_chats = new HashSet();
            final BuddyPluginViewInterface.View chat_view = BuddyPluginUtils.buildChatView(chat_properties, new BuddyPluginViewInterface.ViewListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void chatActivated(BuddyPluginBeta.ChatInstance chat) {
                    boolean[] blArray = az_rating_in_progress;
                    synchronized (az_rating_in_progress) {
                        activated_chats.add(chat);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            if (chat_view == null) {
                Composite chatComp2 = new Composite(chatComp, 2048);
                layout = new GridLayout();
                layout.numColumns = 1;
                layout.marginWidth = 4;
                layout.marginHeight = 4;
                chatComp2.setLayout(layout);
                gridData = new GridData(1808);
                Utils.setLayoutData((Control)chatComp2, gridData);
                chatComp2.setBackground(Colors.white);
                Label chatText = new Label(chatComp2, 64);
                gridData = new GridData(768);
                gridData.heightHint = ratingText.getFont().getFontData()[0].getHeight() * 2 + 16;
                Utils.setLayoutData((Control)chatText, gridData);
                chatText.setBackground(Colors.white);
                chatText.setText(MessageText.getString("torrent.comment.azmsgsync.install"));
            }
            Composite progressComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)progressComp, gridData);
            layout = new GridLayout();
            layout.numColumns = 3;
            progressComp.setLayout(layout);
            Label progLabel = new Label(progressComp, 0);
            progLabel.setText(MessageText.getString("label.checking.comments"));
            final Composite progBarComp = new Composite(progressComp, 0);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)progBarComp, gridData);
            final StackLayout progStackLayout = new StackLayout();
            progBarComp.setLayout(progStackLayout);
            final ProgressBar progBarIndeterminate = new ProgressBar(progBarComp, 258);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)progBarIndeterminate, gridData);
            final ProgressBar progBarComplete = new ProgressBar(progBarComp, 256);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)progBarComplete, gridData);
            progBarComplete.setMaximum(1);
            progBarComplete.setSelection(1);
            progStackLayout.topControl = progBarIndeterminate;
            new AEThread2("ProgChecker"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    boolean currently_updating = true;
                    while (!comments_shell.isDisposed()) {
                        boolean in_progress = false;
                        boolean[] blArray = az_rating_in_progress;
                        // MONITORENTER : az_rating_in_progress
                        if (az_rating_in_progress[0]) {
                            in_progress = true;
                        }
                        for (BuddyPluginBeta.ChatInstance inst : activated_chats) {
                            if (inst.getIncomingSyncState() == 0) continue;
                            in_progress = true;
                        }
                        // MONITOREXIT : blArray
                        final boolean updating = in_progress;
                        if (updating != currently_updating) {
                            currently_updating = updating;
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (!comments_shell.isDisposed()) {
                                        progStackLayout.topControl = updating ? progBarIndeterminate : progBarComplete;
                                        progBarComp.layout();
                                    }
                                }
                            });
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Throwable e) {
                        }
                    }
                    return;
                }
            }.start();
            Button subscriptionLookup = new Button(progressComp, 8);
            subscriptionLookup.setText(MessageText.getString("ConfigView.section.Subscriptions"));
            subscriptionLookup.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    new SubscriptionListWindow(comments_shell, title, OpenTorrentInstance.this.hash.getBytes(), f_enabled_networks, false);
                }
            });
            Label labelSeparator = new Label(comp2, 258);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)labelSeparator, gridData);
            Composite buttonComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)buttonComp, gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            buttonComp.setLayout(layout);
            new Label(buttonComp, 0);
            Composite buttonArea = new Composite(buttonComp, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            Utils.setLayoutData((Control)buttonArea, gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 1;
            buttonArea.setLayout(layoutButtons);
            ArrayList<Button> buttons = new ArrayList<Button>();
            Button bOK = new Button(buttonArea, 8);
            buttons.add(bOK);
            bOK.setText(MessageText.getString("Button.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bOK, gridData);
            bOK.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    comments_shell.dispose();
                }
            });
            Utils.makeButtonsEqualWidth(buttons);
            comments_shell.setDefaultButton(bOK);
            comments_shell.addDisposeListener(new DisposeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void widgetDisposed(DisposeEvent e) {
                    if (!OpenTorrentInstance.this.btnCheckComments.isDisposed()) {
                        OpenTorrentInstance.this.btnCheckComments.setEnabled(true);
                    }
                    if (chat_view != null) {
                        chat_view.destroy();
                    }
                }
            });
            this.btnCheckComments.setEnabled(false);
            comments_shell.setSize(600, 600);
            comments_shell.layout(true, true);
            Utils.centerWindowRelativeTo(comments_shell, this.shell);
            Messages.setLanguageText((Widget)comments_shell, "torrent.comments.title", new String[]{title});
            comments_shell.open();
        }

        private void checkSeedingMode() {
            if (this.torrentOptions == null) {
                return;
            }
            boolean bTorrentValid = true;
            if (this.torrentOptions.getStartMode() == 3) {
                TorrentOpenFileOptions[] files = this.torrentOptions.getFiles();
                for (int j = 0; j < files.length; ++j) {
                    TorrentOpenFileOptions fileInfo2 = files[j];
                    if (!fileInfo2.isToDownload()) continue;
                    File file = fileInfo2.getInitialLink();
                    if (file == null) {
                        file = fileInfo2.getDestFileFullName();
                    }
                    if (!file.exists()) {
                        fileInfo2.isValid = false;
                        bTorrentValid = false;
                        continue;
                    }
                    if (fileInfo2.isValid) continue;
                    fileInfo2.isValid = true;
                }
            }
            this.torrentOptions.isValid = bTorrentValid;
        }

        protected void cmbDataDirChanged() {
            if (this.bSkipDataDirModify || this.cmbDataDir == null) {
                return;
            }
            String dirText = this.cmbDataDir.getText();
            for (TorrentOpenOptions too : this.torrentOptionsMulti) {
                too.setParentDir(dirText);
            }
            this.checkSeedingMode();
            if (!Utils.isCocoa || SWT.getVersion() > 3600) {
                File file = new File(dirText);
                if (!file.isDirectory()) {
                    this.cmbDataDir.setBackground(Colors.colorErrorBG);
                    this.soExpandItemSaveTo.setExpanded(true);
                } else {
                    this.cmbDataDir.setBackground(null);
                }
                this.cmbDataDir.redraw();
                this.cmbDataDir.update();
            }
            if (this.soExpandItemSaveTo != null) {
                String s = MessageText.getString("OpenTorrentOptions.header.saveto", new String[]{dirText});
                this.soExpandItemSaveTo.setText(s);
            }
            this.diskFreeInfoRefreshPending = true;
        }

        private long getCachedDirFreeSpace(File directory) {
            FileStatsCacheItem item = (FileStatsCacheItem)this.fileStatCache.get(directory);
            if (item == null) {
                item = new FileStatsCacheItem(directory);
                this.fileStatCache.put(directory, item);
            }
            return item.freeSpace;
        }

        private boolean getCachedExistsStat(File directory) {
            FileStatsCacheItem item = (FileStatsCacheItem)this.fileStatCache.get(directory);
            if (item == null) {
                item = new FileStatsCacheItem(directory);
                this.fileStatCache.put(directory, item);
            }
            return item.exists;
        }

        protected void setSelectedQueueLocation(int iLocation) {
            this.torrentOptions.iQueueLocation = iLocation;
            this.updateStartOptionsHeader();
        }

        private void updateStartOptionsHeader() {
            String[] tagsToCreate;
            if (this.soStartOptionsExpandItem == null) {
                return;
            }
            String optionText = MessageText.getString("OpenTorrentWindow.startMode." + startModes[this.torrentOptions.getStartMode()]) + ", " + MessageText.getString("OpenTorrentWindow.addPosition." + queueLocations[this.torrentOptions.iQueueLocation]);
            String s = MessageText.getString("OpenTorrentOptions.header.startoptions", new String[]{optionText});
            List<Tag> initialtags = this.torrentOptions.getInitialTags();
            String tag_str = null;
            int numTags = 0;
            if (initialtags.size() > 0) {
                tag_str = "";
                for (Tag t : initialtags) {
                    ++numTags;
                    tag_str = tag_str + (tag_str == "" ? "" : ", ") + t.getTagName(true);
                }
            }
            for (String tagName : tagsToCreate = OpenTorrentOptionsWindow.this.listTagsToCreate.toArray(new String[0])) {
                ++numTags;
                tag_str = tag_str == null ? tagName : tag_str + (tag_str == "" ? "" : ", ") + tagName;
            }
            if (numTags == 0) {
                tag_str = MessageText.getString("label.none");
            }
            s = s + "        " + MessageText.getString("OpenTorrentOptions.header.tags", new String[]{tag_str});
            this.soStartOptionsExpandItem.setText(s);
        }

        protected void setSelectedStartMode(int iStartID) {
            this.torrentOptions.setStartMode(iStartID);
            this.checkSeedingMode();
            this.updateStartOptionsHeader();
        }

        private void setupFileAreaButtons(SWTSkinObjectContainer so) {
            PluginInterface swarm_pi = null;
            try {
                PluginInterface pi;
                if (COConfigurationManager.getBooleanParameter("rcm.overall.enabled", true) && AzureusCoreFactory.isCoreRunning() && (pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aercm")) != null && pi.getPluginState().isOperational() && pi.getIPC().canInvoke("lookupBySize", new Object[]{new Long(0L)})) {
                    swarm_pi = pi;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            Composite cButtonsArea = so.getComposite();
            GridLayout layout = new GridLayout(1, false);
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cButtonsArea.setLayout(layout);
            Composite cButtonsTop = new Composite(cButtonsArea, 0);
            layout = new GridLayout(swarm_pi == null ? 6 : 7, false);
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cButtonsTop.setLayout(layout);
            GridData gridData = new GridData(768);
            Utils.setLayoutData((Control)cButtonsTop, gridData);
            Canvas line = new Canvas(cButtonsArea, 262144);
            line.addListener(9, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    Rectangle clientArea = ((Canvas)e.widget).getClientArea();
                    e.gc.setForeground(e.display.getSystemColor(18));
                    e.gc.drawRectangle(clientArea);
                    ++clientArea.y;
                    e.gc.setForeground(e.display.getSystemColor(20));
                    e.gc.drawRectangle(clientArea);
                }
            });
            gridData = new GridData(768);
            gridData.heightHint = 2;
            Utils.setLayoutData((Control)line, gridData);
            Composite cButtonsBottom = new Composite(cButtonsArea, 0);
            layout = new GridLayout(5, false);
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cButtonsBottom.setLayout(layout);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)cButtonsBottom, gridData);
            ArrayList<Button> buttons = new ArrayList<Button>();
            this.btnSelectAll = new Button(cButtonsTop, 8);
            buttons.add(this.btnSelectAll);
            Messages.setLanguageText(this.btnSelectAll, "Button.selectAll");
            this.btnSelectAll.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.tvFiles.selectAll();
                }
            });
            this.btnMarkSelected = new Button(cButtonsTop, 8);
            buttons.add(this.btnMarkSelected);
            Messages.setLanguageText(this.btnMarkSelected, "Button.mark");
            this.btnMarkSelected.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    OpenTorrentInstance.this.setToDownload(infos, true);
                }
            });
            this.btnUnmarkSelected = new Button(cButtonsTop, 8);
            buttons.add(this.btnUnmarkSelected);
            Messages.setLanguageText(this.btnUnmarkSelected, "Button.unmark");
            this.btnUnmarkSelected.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    OpenTorrentInstance.this.setToDownload(infos, false);
                }
            });
            this.btnRename = new Button(cButtonsTop, 8);
            buttons.add(this.btnRename);
            Messages.setLanguageText(this.btnRename, "Button.rename");
            this.btnRename.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    OpenTorrentInstance.this.renameFilenames(infos);
                }
            });
            this.btnRetarget = new Button(cButtonsTop, 8);
            buttons.add(this.btnRetarget);
            Messages.setLanguageText(this.btnRetarget, "Button.retarget");
            this.btnRetarget.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    OpenTorrentInstance.this.changeFileDestination(infos, false);
                }
            });
            Label pad1 = new Label(cButtonsTop, 0);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)pad1, gridData);
            if (swarm_pi != null) {
                final PluginInterface f_pi = swarm_pi;
                this.btnSwarmIt = new Button(cButtonsTop, 8);
                buttons.add(this.btnSwarmIt);
                Messages.setLanguageText(this.btnSwarmIt, "Button.swarmit");
                this.btnSwarmIt.addListener(13, new Listener(){

                    @Override
                    public void handleEvent(Event event2) {
                        block2: {
                            List<Object> selectedDataSources = OpenTorrentInstance.this.tvFiles.getSelectedDataSources();
                            Iterator<Object> i$ = selectedDataSources.iterator();
                            if (!i$.hasNext()) break block2;
                            Object ds = i$.next();
                            TorrentOpenFileOptions file = (TorrentOpenFileOptions)ds;
                            try {
                                f_pi.getIPC().invoke("lookupBySize", new Object[]{new Long(file.lSize)});
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                });
                this.btnSwarmIt.setEnabled(false);
            }
            this.btnTreeView = new Button(cButtonsBottom, 8);
            buttons.add(this.btnTreeView);
            Messages.setLanguageText(this.btnTreeView, "OpenTorrentWindow.tree.view");
            this.btnTreeView.setToolTipText(MessageText.getString("OpenTorrentWindow.tree.view.info"));
            this.btnTreeView.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.showTreeView();
                }
            });
            Label pad2 = new Label(cButtonsBottom, 0);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)pad2, gridData);
            this.btnPrivacy = new Button(cButtonsBottom, 2);
            buttons.add(this.btnPrivacy);
            Messages.setLanguageText(this.btnPrivacy, "label.privacy");
            this.btnPrivacy.setToolTipText(MessageText.getString("OpenTorrentWindow.privacy.info"));
            this.btnPrivacy.addListener(13, new Listener(){
                private int saved_start_mode;
                private Map<String, Boolean> saved_nets;

                @Override
                public void handleEvent(Event event2) {
                    if (OpenTorrentInstance.this.btnPrivacy.getSelection()) {
                        this.saved_nets = OpenTorrentInstance.this.torrentOptions.getEnabledNetworks();
                        this.saved_start_mode = OpenTorrentInstance.this.torrentOptions.getStartMode();
                        OpenTorrentInstance.this.setSelectedStartMode(1);
                        for (String net : AENetworkClassifier.AT_NETWORKS) {
                            OpenTorrentInstance.this.torrentOptions.setNetworkEnabled(net, false);
                        }
                        OpenTorrentInstance.this.updateNetworkOptions();
                    } else {
                        if (this.saved_nets != null) {
                            OpenTorrentInstance.this.setSelectedStartMode(this.saved_start_mode);
                            for (Map.Entry<String, Boolean> entry : this.saved_nets.entrySet()) {
                                OpenTorrentInstance.this.torrentOptions.setNetworkEnabled(entry.getKey(), entry.getValue());
                            }
                            this.saved_nets = null;
                        }
                        OpenTorrentInstance.this.updateNetworkOptions();
                    }
                }
            });
            this.btnCheckComments = new Button(cButtonsBottom, 8);
            buttons.add(this.btnCheckComments);
            Messages.setLanguageText(this.btnCheckComments, "label.comments");
            this.btnCheckComments.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.showComments();
                }
            });
            this.btnCheckAvailability = new Button(cButtonsBottom, 8);
            buttons.add(this.btnCheckAvailability);
            Messages.setLanguageText(this.btnCheckAvailability, "label.check.avail");
            this.btnCheckAvailability.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.showAvailability();
                }
            });
            Utils.makeButtonsEqualWidth(buttons);
            this.updateFileButtons();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setToDownload(TorrentOpenFileOptions[] infos, boolean download) {
            boolean changed = false;
            try {
                this.settingToDownload.incrementAndGet();
                for (TorrentOpenFileOptions info : infos) {
                    if (info.isToDownload() == download) continue;
                    info.setToDownload(download);
                    changed = true;
                }
            }
            finally {
                this.settingToDownload.decrementAndGet();
            }
            if (changed) {
                this.updateFileButtons();
                this.updateSize();
            }
        }

        private void setupFileAreaInfo(SWTSkinObjectText so) {
            this.soFileAreaInfo = so;
        }

        private void setupSaveLocation(SWTSkinObjectContainer soInputArea, SWTSkinObjectButton soBrowseButton) {
            this.cmbDataDir = new Combo(soInputArea.getComposite(), 0);
            Utils.setLayoutData((Control)this.cmbDataDir, Utils.getFilledFormData());
            this.cmbDataDir.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 32 && (e.stateMask & SWT.MODIFIER_MASK) != 0) {
                        e.doit = false;
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 32 && (e.stateMask & SWT.MODIFIER_MASK) != 0) {
                        e.doit = false;
                        Menu menu = OpenTorrentInstance.this.cmbDataDir.getMenu();
                        if (menu != null && !menu.isDisposed()) {
                            menu.dispose();
                        }
                        menu = new Menu(OpenTorrentInstance.this.cmbDataDir);
                        String current_text = OpenTorrentInstance.this.cmbDataDir.getText();
                        String def = COConfigurationManager.getStringParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH);
                        ArrayList<String> items = new ArrayList<String>(Arrays.asList(OpenTorrentInstance.this.cmbDataDir.getItems()));
                        if (!items.contains(def)) {
                            items.add(def);
                        }
                        ArrayList<String> suggestions = new ArrayList<String>();
                        for (String item : items) {
                            if (!item.toLowerCase(Locale.US).contains(current_text.toLowerCase(Locale.US))) continue;
                            suggestions.add(item);
                        }
                        if (suggestions.size() == 0) {
                            MenuItem mi = new MenuItem(menu, 8);
                            mi.setText(MessageText.getString("label.no.suggestions"));
                            mi.setEnabled(false);
                        } else {
                            for (final String str : suggestions) {
                                MenuItem mi = new MenuItem(menu, 8);
                                mi.setText(str);
                                mi.addSelectionListener(new SelectionAdapter(){

                                    @Override
                                    public void widgetSelected(SelectionEvent e) {
                                        OpenTorrentInstance.this.cmbDataDir.setText(str);
                                    }
                                });
                            }
                        }
                        OpenTorrentInstance.this.cmbDataDir.setMenu(menu);
                        final Point cursorLocation = Display.getCurrent().getCursorLocation();
                        menu.setLocation(cursorLocation.x - 10, cursorLocation.y - 10);
                        menu.setVisible(true);
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                Display.getCurrent().setCursorLocation(cursorLocation.x + 1, cursorLocation.y);
                            }
                        }, true);
                    }
                }
            });
            this.cmbDataDir.setToolTipText(MessageText.getString("label.ctrl.space.for.suggestion"));
            this.cmbDataDir.addModifyListener(new ModifyListener(){

                @Override
                public void modifyText(ModifyEvent e) {
                    OpenTorrentInstance.this.cmbDataDirChanged();
                }
            });
            this.cmbDataDir.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.cmbDataDirChanged();
                }
            });
            this.updateDataDirCombo();
            this.dirList = COConfigurationManager.getStringListParameter("saveTo_list");
            StringIterator iter = this.dirList.iterator();
            while (iter.hasNext()) {
                String s = iter.next();
                if (this.torrentOptions != null && s.equals(this.torrentOptions.getParentDir())) continue;
                this.cmbDataDir.add(s);
            }
            soBrowseButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String sDefPath = OpenTorrentInstance.this.cmbDataDir.getText();
                    File f = new File(sDefPath);
                    if (sDefPath.length() > 0) {
                        while (!f.exists()) {
                            if ((f = f.getParentFile()) != null) continue;
                            f = new File(sDefPath);
                            break;
                        }
                    }
                    DirectoryDialog dDialog = new DirectoryDialog(OpenTorrentInstance.this.cmbDataDir.getShell(), 131072);
                    dDialog.setFilterPath(f.getAbsolutePath());
                    dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath_forallfiles"));
                    String sSavePath = dDialog.open();
                    if (sSavePath != null) {
                        OpenTorrentInstance.this.cmbDataDir.setText(sSavePath);
                    }
                }
            });
        }

        private void setupStartOptions(SWTSkinObjectExpandItem so) {
            this.soStartOptionsExpandItem = so;
            Composite cTorrentOptions = so.getComposite();
            Composite cTorrentModes = new Composite(cTorrentOptions, 0);
            GridData gridData = new GridData(768);
            Utils.setLayoutData((Control)cTorrentModes, Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            cTorrentModes.setLayout(layout);
            Label label = new Label(cTorrentModes, 0);
            gridData = new GridData(4);
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "OpenTorrentWindow.startMode");
            this.cmbStartMode = new Combo(cTorrentModes, 2056);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)this.cmbStartMode, gridData);
            this.updateStartModeCombo();
            this.cmbStartMode.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    OpenTorrentInstance.this.setSelectedStartMode(OpenTorrentInstance.this.cmbStartMode.getSelectionIndex());
                }
            });
            label = new Label(cTorrentModes, 0);
            gridData = new GridData(4);
            Utils.setLayoutData((Control)label, gridData);
            Messages.setLanguageText(label, "OpenTorrentWindow.addPosition");
            this.cmbQueueLocation = new Combo(cTorrentModes, 2056);
            gridData = new GridData(768);
            Utils.setLayoutData((Control)this.cmbQueueLocation, gridData);
            this.updateQueueLocationCombo();
            this.cmbQueueLocation.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    OpenTorrentInstance.this.setSelectedQueueLocation(OpenTorrentInstance.this.cmbQueueLocation.getSelectionIndex());
                }
            });
            if (TagManagerFactory.getTagManager().isEnabled()) {
                Composite tagLeft = new Composite(cTorrentModes, 0);
                Utils.setLayoutData((Control)tagLeft, new GridData(4));
                Composite tagRight = new Composite(cTorrentModes, 0);
                gridData = new GridData(768);
                gridData.horizontalSpan = 3;
                Utils.setLayoutData((Control)tagRight, gridData);
                layout = new GridLayout();
                layout.numColumns = 1;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                tagLeft.setLayout(layout);
                layout = new GridLayout();
                layout.numColumns = 1;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                tagRight.setLayout(layout);
                label = new Label(tagLeft, 0);
                gridData = new GridData(4);
                Messages.setLanguageText(label, "label.initial_tags");
                this.tagButtonsArea = new Composite(tagRight, 0x20000000);
                gridData = new GridData(4, 4, true, true);
                this.tagButtonsArea.setLayoutData(gridData);
                RowLayout tagLayout = new RowLayout();
                tagLayout.pack = false;
                tagLayout.spacing = 5;
                Utils.setLayout(this.tagButtonsArea, tagLayout);
                this.buildTagButtonPanel(this.tagButtonsArea);
                Button addTag = new Button(tagLeft, 0);
                Utils.setLayoutData((Control)addTag, new GridData(4));
                addTag.setText("+");
                addTag.addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        TagUIUtilsV3.showCreateTagDialog(new UIFunctions.TagReturner(){

                            @Override
                            public void returnedTags(Tag[] tags) {
                                List<Tag> initialTags = OpenTorrentInstance.this.torrentOptions.getInitialTags();
                                boolean changed = false;
                                for (Tag tag : tags) {
                                    if (initialTags.contains(tag)) continue;
                                    initialTags.add(tag);
                                    changed = true;
                                }
                                if (changed) {
                                    OpenTorrentInstance.this.torrentOptions.setInitialTags(initialTags);
                                    OpenTorrentInstance.this.updateStartOptionsHeader();
                                    OpenTorrentInstance.this.buildTagButtonPanel(OpenTorrentInstance.this.tagButtonsArea, true);
                                }
                            }
                        });
                    }
                });
            }
        }

        private void buildTagButtonPanel(Composite parent) {
            this.buildTagButtonPanel(parent, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildTagButtonPanel(final Composite parent, boolean is_rebuild) {
            try {
                if (parent.isDisposed()) {
                    return;
                }
                String SP_KEY = "oto:tag:initsp";
                if (is_rebuild) {
                    Utils.disposeComposite(parent, false);
                } else {
                    parent.setData("oto:tag:initsp", this.getSavePath());
                }
                final TagType tt = TagManagerFactory.getTagManager().getTagType(3);
                List<Tag> initialTags = this.torrentOptions.getInitialTags();
                Listener menuDetectListener = new Listener(){

                    @Override
                    public void handleEvent(Event event2) {
                        final Button button = (Button)event2.widget;
                        Menu menu = new Menu(button);
                        button.setMenu(menu);
                        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

                            @Override
                            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                                Tag tag = (Tag)button.getData("Tag");
                                TagUIUtils.createSideBarMenuItems(menu, tag);
                            }
                        });
                    }
                };
                PaintListener paintListener = new PaintListener(){

                    @Override
                    public void paintControl(PaintEvent e) {
                        Button button;
                        Composite c = null;
                        if (e.widget instanceof Composite) {
                            c = (Composite)e.widget;
                            button = (Button)c.getChildren()[0];
                        } else {
                            button = (Button)e.widget;
                        }
                        Tag tag = (Tag)button.getData("Tag");
                        if (tag == null) {
                            return;
                        }
                        if (c != null) {
                            boolean checked = button.getSelection();
                            Point size = c.getSize();
                            Point sizeButton = button.getSize();
                            e.gc.setAntialias(1);
                            e.gc.setForeground(ColorCache.getColor((Device)e.display, tag.getColor()));
                            int lineWidth = button.getSelection() ? 2 : 1;
                            e.gc.setLineWidth(lineWidth);
                            int curve = 20;
                            int width = sizeButton.x + lineWidth + 1;
                            width += Constants.isOSX ? 5 : curve / 2;
                            if (checked) {
                                e.gc.setAlpha(32);
                                e.gc.setBackground(ColorCache.getColor((Device)e.display, tag.getColor()));
                                e.gc.fillRoundRectangle(-curve, lineWidth - 1, width + curve, size.y - lineWidth, curve, curve);
                                e.gc.setAlpha(255);
                            }
                            if (!checked) {
                                e.gc.setAlpha(128);
                            }
                            e.gc.drawRoundRectangle(-curve, lineWidth - 1, width + curve, size.y - lineWidth, curve, curve);
                            e.gc.drawLine(lineWidth - 1, lineWidth, lineWidth - 1, size.y - lineWidth);
                        } else if (!Constants.isOSX && button.getSelection()) {
                            Point size = button.getSize();
                            e.gc.setBackground(ColorCache.getColor((Device)e.display, tag.getColor()));
                            e.gc.setAlpha(20);
                            e.gc.fillRectangle(0, 0, size.x, size.y);
                        }
                    }
                };
                for (final Tag tag : TagUIUtils.sortTags(tt.getTags())) {
                    if (!tag.canBePublic() || tag.isTagAuto()[0]) continue;
                    Composite p = new Composite(parent, 0x20000000);
                    GridLayout layout = new GridLayout(1, false);
                    layout.marginHeight = 3;
                    if (Constants.isWindows) {
                        layout.marginWidth = 6;
                        layout.marginLeft = 2;
                        layout.marginTop = 1;
                    } else {
                        layout.marginWidth = 0;
                        layout.marginLeft = 3;
                        layout.marginRight = 11;
                    }
                    p.setLayout(layout);
                    p.addPaintListener(paintListener);
                    final Button button = new Button(p, 32);
                    if (Constants.isWindows) {
                        button.setBackground(Colors.white);
                    }
                    button.setData("Tag", tag);
                    button.addListener(35, menuDetectListener);
                    button.addPaintListener(paintListener);
                    button.setText(tag.getTagName(true));
                    button.setToolTipText(TagUIUtils.getTagTooltip(tag));
                    if (initialTags.contains(tag)) {
                        button.setSelection(true);
                    }
                    button.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            List<Tag> tags = OpenTorrentInstance.this.torrentOptions.getInitialTags();
                            if (button.getSelection()) {
                                File save_loc;
                                tags.add(tag);
                                TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag);
                                if (fl.supportsTagInitialSaveFolder() && (save_loc = fl.getTagInitialSaveFolder()) != null) {
                                    OpenTorrentInstance.this.setSavePath(save_loc.getAbsolutePath());
                                }
                            } else {
                                String old;
                                File save_loc;
                                tags.remove(tag);
                                TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag);
                                if (fl.supportsTagInitialSaveFolder() && (save_loc = fl.getTagInitialSaveFolder()) != null && OpenTorrentInstance.this.getSavePath().equals(save_loc.getAbsolutePath()) && (old = (String)parent.getData("oto:tag:initsp")) != null) {
                                    OpenTorrentInstance.this.setSavePath(old);
                                }
                            }
                            button.getParent().redraw();
                            OpenTorrentInstance.this.torrentOptions.setInitialTags(tags);
                            OpenTorrentInstance.this.updateStartOptionsHeader();
                        }
                    });
                }
                Map<String, DiscoveredTag> map = OpenTorrentOptionsWindow.this.listDiscoveredTags;
                synchronized (map) {
                    DiscoveredTag tag;
                    String tagName;
                    boolean alreadyHave;
                    Iterator<DiscoveredTag> i$ = OpenTorrentOptionsWindow.this.listDiscoveredTags.values().iterator();
                    while (i$.hasNext() && !(alreadyHave = OpenTorrentOptionsWindow.this.checkAlreadyHaveTag(initialTags, tagName = (tag = i$.next()).name))) {
                        final Button but = new Button(parent, 32);
                        if (Constants.isWindows) {
                            but.setBackground(Colors.white);
                        }
                        but.setImage(ImageLoader.getInstance().getImage("image.sidebar.rcm"));
                        if (OpenTorrentOptionsWindow.this.listTagsToCreate.contains(tagName)) {
                            but.setSelection(true);
                        }
                        String tagDisplayName = tagName;
                        String[] nets = tag.networks;
                        if (nets.length > 0) {
                            boolean boring = false;
                            String nets_str = "";
                            for (String net : nets) {
                                if (net == "Public") {
                                    boring = true;
                                    break;
                                }
                                nets_str = nets_str + (nets_str.length() == 0 ? "" : "/") + net;
                            }
                            if (!boring && nets_str.length() > 0) {
                                tagDisplayName = tagDisplayName + " [" + nets_str + "]";
                            }
                        }
                        but.setText(tagDisplayName);
                        but.setToolTipText(MessageText.getString("tagtype.discovered"));
                        but.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent e) {
                                if (but.getSelection()) {
                                    OpenTorrentOptionsWindow.this.listTagsToCreate.add(tagName);
                                } else {
                                    OpenTorrentOptionsWindow.this.listTagsToCreate.remove(tagName);
                                }
                                OpenTorrentInstance.this.updateStartOptionsHeader();
                            }
                        });
                    }
                }
                if (is_rebuild) {
                    parent.getParent().layout(true, true);
                    return;
                }
                tt.addTagTypeListener(new TagTypeListener(){

                    @Override
                    public void tagTypeChanged(TagType tag_type) {
                    }

                    @Override
                    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
                        int type = event2.getEventType();
                        Tag tag = event2.getTag();
                        if (type == 0) {
                            this.tagAdded(tag);
                        } else if (type == 2) {
                            this.tagRemoved(tag);
                        }
                    }

                    public void tagRemoved(Tag tag) {
                        List<Tag> initialTags = OpenTorrentInstance.this.torrentOptions.getInitialTags();
                        if (initialTags.contains(tag)) {
                            initialTags.remove(tag);
                            OpenTorrentInstance.this.torrentOptions.setInitialTags(initialTags);
                            OpenTorrentInstance.this.updateStartOptionsHeader();
                        }
                        this.rebuild();
                    }

                    public void tagAdded(Tag tag) {
                        this.rebuild();
                    }

                    private void rebuild() {
                        if (parent.isDisposed()) {
                            tt.removeTagTypeListener(this);
                        } else {
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    OpenTorrentInstance.this.buildTagButtonPanel(parent, true);
                                }
                            });
                        }
                    }
                }, false);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        private void setupTVFiles(SWTSkinObjectContainer soFilesTable, SWTSkinObjectTextbox soFilesFilter) {
            TableColumnManager tcm = TableColumnManager.getInstance();
            if (tcm.getDefaultColumnNames(OpenTorrentOptionsWindow.TABLEID_FILES) == null) {
                tcm.registerColumn(TorrentOpenFileOptions.class, "#", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        new TableColumnOTOF_Position(column);
                    }
                });
                tcm.registerColumn(TorrentOpenFileOptions.class, "download", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        new TableColumnOTOF_Download(column);
                    }
                });
                tcm.registerColumn(TorrentOpenFileOptions.class, "name", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        new TableColumnOTOF_Name(column);
                    }
                });
                tcm.registerColumn(TorrentOpenFileOptions.class, "size", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        new TableColumnOTOF_Size(column);
                    }
                });
                tcm.registerColumn(TorrentOpenFileOptions.class, "path", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        new TableColumnOTOF_Path(column);
                    }
                });
                tcm.registerColumn(TorrentOpenFileOptions.class, "fileext", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        new TableColumnOTOF_Ext(column);
                    }
                });
                tcm.registerColumn(TorrentOpenFileOptions.class, "priority", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        new TableColumnOTOF_Priority(column);
                    }
                });
                tcm.setDefaultColumnNames(OpenTorrentOptionsWindow.TABLEID_FILES, new String[]{"#", "download", "name", "size", "path", "priority"});
                tcm.setDefaultSortColumnName(OpenTorrentOptionsWindow.TABLEID_FILES, "#");
            }
            this.tvFiles = TableViewFactory.createTableViewSWT(TorrentOpenFileOptions.class, OpenTorrentOptionsWindow.TABLEID_FILES, OpenTorrentOptionsWindow.TABLEID_FILES, null, "#", 67586);
            this.tvFiles.initialize(soFilesTable.getComposite());
            this.tvFiles.setRowDefaultHeightEM(1.4f);
            if (this.torrentOptions.getFiles().length > 1 && soFilesFilter != null) {
                soFilesFilter.setVisible(true);
                Text text = soFilesFilter.getTextControl();
                this.tvFiles.enableFilterCheck(text, this);
            } else if (soFilesFilter != null) {
                soFilesFilter.setVisible(false);
            }
            this.tvFiles.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    TableRowCore focusedRow;
                    if (e.keyCode == 32 && (focusedRow = OpenTorrentInstance.this.tvFiles.getFocusedRow()) != null) {
                        TorrentOpenFileOptions tfi_focus = (TorrentOpenFileOptions)focusedRow.getDataSource();
                        boolean download = !tfi_focus.isToDownload();
                        TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                        OpenTorrentInstance.this.setToDownload(infos, download);
                    }
                    if (e.keyCode == 0x100000B && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
                        TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                        OpenTorrentInstance.this.renameFilenames(infos);
                        e.doit = false;
                        return;
                    }
                }
            });
            this.tvFiles.addMenuFillListener(new TableViewSWTMenuFillListener(){

                @Override
                public void fillMenu(String sColumnName, Menu menu) {
                    Shell shell = menu.getShell();
                    TableRowCore focusedRow = OpenTorrentInstance.this.tvFiles.getFocusedRow();
                    final TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    TorrentOpenFileOptions tfi_focus = (TorrentOpenFileOptions)focusedRow.getDataSource();
                    boolean download = tfi_focus.isToDownload();
                    MenuItem item = new MenuItem(menu, 32);
                    Messages.setLanguageText(item, "label.download.file");
                    item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            TableRowCore focusedRow = OpenTorrentInstance.this.tvFiles.getFocusedRow();
                            TorrentOpenFileOptions tfi_focus = (TorrentOpenFileOptions)focusedRow.getDataSource();
                            boolean download = !tfi_focus.isToDownload();
                            OpenTorrentInstance.this.setToDownload(infos, download);
                        }
                    });
                    item.setSelection(download);
                    MenuItem itemPriority = new MenuItem(menu, 64);
                    Messages.setLanguageText(itemPriority, "FilesView.menu.setpriority");
                    Menu menuPriority = new Menu(shell, 4);
                    itemPriority.setMenu(menuPriority);
                    final MenuItem itemHigh = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText(itemHigh, "FilesView.menu.setpriority.high");
                    final MenuItem itemNormal = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText(itemNormal, "FilesView.menu.setpriority.normal");
                    final MenuItem itemLow = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText(itemLow, "FileItem.low");
                    final MenuItem itemNumeric = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText(itemNumeric, "FilesView.menu.setpriority.numeric");
                    final MenuItem itemNumericAuto = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText(itemNumericAuto, "FilesView.menu.setpriority.numeric.auto");
                    Listener priorityListener = new Listener(){

                        @Override
                        public void handleEvent(Event event2) {
                            int priority;
                            Widget widget = event2.widget;
                            if (widget == itemHigh) {
                                priority = 1;
                            } else if (widget == itemNormal) {
                                priority = 0;
                            } else if (widget == itemLow) {
                                priority = -1;
                            } else {
                                if (widget == itemNumeric) {
                                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("FilesView.dialog.priority.title", "FilesView.dialog.priority.text");
                                    entryWindow.prompt(new UIInputReceiverListener(){

                                        @Override
                                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                                            if (!entryWindow.hasSubmittedInput()) {
                                                return;
                                            }
                                            String sReturn = entryWindow.getSubmittedInput();
                                            if (sReturn == null) {
                                                return;
                                            }
                                            int priority = 0;
                                            try {
                                                priority = Integer.valueOf(sReturn);
                                            }
                                            catch (NumberFormatException er) {
                                                Debug.out("Invalid priority: " + sReturn);
                                                new MessageBoxShell(33, MessageText.getString("FilePriority.invalid.title"), MessageText.getString("FilePriority.invalid.text", new String[]{sReturn})).open(null);
                                                return;
                                            }
                                            for (TorrentOpenFileOptions torrentFileInfo : infos) {
                                                torrentFileInfo.setPriority(priority);
                                            }
                                        }
                                    });
                                    return;
                                }
                                if (widget == itemNumericAuto) {
                                    int next_priority = 0;
                                    TorrentOpenFileOptions[] all_files = OpenTorrentInstance.this.torrentOptions.getFiles();
                                    if (all_files.length != infos.length) {
                                        HashSet<Integer> affected_indexes = new HashSet<Integer>();
                                        for (TorrentOpenFileOptions file : infos) {
                                            affected_indexes.add(file.getIndex());
                                        }
                                        for (TorrentOpenFileOptions file : all_files) {
                                            if (affected_indexes.contains(file.getIndex()) || !file.isToDownload()) continue;
                                            next_priority = Math.max(next_priority, file.getPriority() + 1);
                                        }
                                    }
                                    next_priority += infos.length;
                                    for (TorrentOpenFileOptions file : infos) {
                                        file.setPriority(--next_priority);
                                    }
                                    return;
                                }
                                return;
                            }
                            for (TorrentOpenFileOptions torrentFileInfo : infos) {
                                torrentFileInfo.setPriority(priority);
                            }
                        }
                    };
                    itemNumeric.addListener(13, priorityListener);
                    itemNumericAuto.addListener(13, priorityListener);
                    itemHigh.addListener(13, priorityListener);
                    itemNormal.addListener(13, priorityListener);
                    itemLow.addListener(13, priorityListener);
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText(item, "FilesView.menu.rename_only");
                    item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            OpenTorrentInstance.this.renameFilenames(infos);
                        }
                    });
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText(item, "OpenTorrentWindow.fileList.changeDestination");
                    item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            OpenTorrentInstance.this.changeFileDestination(infos, false);
                        }
                    });
                    if (infos.length > 1 && OpenTorrentInstance.this.torrentOptions.getStartMode() != 3) {
                        item = new MenuItem(menu, 8);
                        Messages.setLanguageText((Widget)item, "OpenTorrentWindow.fileList.changeDestination.all", new String[]{String.valueOf(infos.length)});
                        item.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent e) {
                                OpenTorrentInstance.this.changeFileDestination(infos, true);
                            }
                        });
                    }
                    new MenuItem(menu, 2);
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText(item, "Button.selectAll");
                    item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            OpenTorrentInstance.this.tvFiles.selectAll();
                        }
                    });
                    String dest_path = tfi_focus.getDestPathName();
                    String parentDir = tfi_focus.parent.getParentDir();
                    ArrayList<String> folder_list = new ArrayList<String>();
                    folder_list.add(dest_path);
                    if (dest_path.startsWith(parentDir) && dest_path.length() > parentDir.length()) {
                        String relativePath = dest_path.substring(parentDir.length() + 1);
                        while (relativePath.contains(File.separator)) {
                            int pos = relativePath.lastIndexOf(File.separator);
                            relativePath = relativePath.substring(0, pos);
                            folder_list.add(parentDir + File.separator + relativePath);
                        }
                    }
                    for (int i = folder_list.size() - 1; i >= 0; --i) {
                        final String this_dest_path = (String)folder_list.get(i);
                        item = new MenuItem(menu, 8);
                        Messages.setLanguageText((Widget)item, "menu.selectfilesinfolder", new String[]{this_dest_path});
                        item.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent e) {
                                TableRowCore[] rows;
                                for (TableRowCore row : rows = OpenTorrentInstance.this.tvFiles.getRows()) {
                                    TorrentOpenFileOptions fileOptions;
                                    Object dataSource = row.getDataSource();
                                    if (!(dataSource instanceof TorrentOpenFileOptions) || !(fileOptions = (TorrentOpenFileOptions)dataSource).getDestPathName().startsWith(this_dest_path)) continue;
                                    row.setSelected(true);
                                }
                            }
                        });
                    }
                    if (!OpenTorrentInstance.this.torrentOptions.isSimpleTorrent()) {
                        new MenuItem(menu, 2);
                        item = new MenuItem(menu, 8);
                        Messages.setLanguageText(item, "OpenTorrentWindow.set.savepath");
                        item.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent e) {
                                OpenTorrentInstance.this.setSavePath();
                            }
                        });
                        item = new MenuItem(menu, 8);
                        Messages.setLanguageText(item, "OpenTorrentWindow.tlf.remove");
                        item.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent e) {
                                OpenTorrentInstance.this.removeTopLevelFolder();
                            }
                        });
                        item.setEnabled(OpenTorrentInstance.this.canRemoveTopLevelFolder());
                        item = new MenuItem(menu, 32);
                        item.setSelection(COConfigurationManager.getBooleanParameter("open.torrent.window.rename.on.tlf.change"));
                        Messages.setLanguageText(item, "OpenTorrentWindow.tlf.rename");
                        item.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent e) {
                                COConfigurationManager.setParameter("open.torrent.window.rename.on.tlf.change", ((MenuItem)e.widget).getSelection());
                            }
                        });
                        new MenuItem(menu, 2);
                    }
                }

                @Override
                public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
                }
            });
            this.tvFiles.addSelectionListener(new TableSelectionListener(){

                @Override
                public void selected(TableRowCore[] row) {
                    OpenTorrentInstance.this.updateFileButtons();
                }

                @Override
                public void mouseExit(TableRowCore row) {
                }

                @Override
                public void mouseEnter(TableRowCore row) {
                }

                @Override
                public void focusChanged(TableRowCore focus) {
                }

                @Override
                public void deselected(TableRowCore[] rows) {
                    OpenTorrentInstance.this.updateFileButtons();
                }

                @Override
                public void defaultSelected(TableRowCore[] rows, int stateMask) {
                }
            }, false);
            this.tvFiles.addDataSources((TorrentOpenFileOptions[])this.torrentOptions.getFiles());
        }

        @Override
        public boolean filterCheck(TorrentOpenFileOptions ds, String filter2, boolean regex) {
            if (filter2 == null || filter2.length() == 0) {
                return true;
            }
            try {
                Pattern pattern;
                File file = ds.getDestFileFullName();
                String name = filter2.contains(File.separator) ? file.getAbsolutePath() : file.getName();
                String s = regex ? filter2 : "\\Q" + filter2.replaceAll("\\s*[|;]\\s*", "\\\\E|\\\\Q") + "\\E";
                boolean match_result = true;
                if (regex && s.startsWith("!")) {
                    s = s.substring(1);
                    match_result = false;
                }
                return (pattern = RegExUtil.getCachedPattern("fv:search", s, 2)).matcher(name).find() == match_result;
            }
            catch (Exception e) {
                return true;
            }
        }

        @Override
        public void filterSet(String filter2) {
        }

        protected void updateFileButtons() {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    boolean hasRowsSelected;
                    TableRowCore[] rows = OpenTorrentInstance.this.tvFiles.getSelectedRows();
                    boolean bl = hasRowsSelected = rows.length > 0;
                    if (OpenTorrentInstance.this.btnRename != null && !OpenTorrentInstance.this.btnRename.isDisposed()) {
                        OpenTorrentInstance.this.btnRename.setEnabled(hasRowsSelected);
                    }
                    if (OpenTorrentInstance.this.btnRetarget != null && !OpenTorrentInstance.this.btnRetarget.isDisposed()) {
                        OpenTorrentInstance.this.btnRetarget.setEnabled(hasRowsSelected);
                    }
                    boolean all_marked = true;
                    boolean all_unmarked = true;
                    for (TableRowCore row : rows) {
                        TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)row.getDataSource();
                        if (tfi.isToDownload()) {
                            all_unmarked = false;
                            continue;
                        }
                        all_marked = false;
                    }
                    if (OpenTorrentInstance.this.btnSelectAll != null && !OpenTorrentInstance.this.btnSelectAll.isDisposed()) {
                        OpenTorrentInstance.this.btnSelectAll.setEnabled(rows.length < OpenTorrentInstance.this.torrentOptions.getFiles().length);
                    }
                    if (OpenTorrentInstance.this.btnMarkSelected != null && !OpenTorrentInstance.this.btnMarkSelected.isDisposed()) {
                        OpenTorrentInstance.this.btnMarkSelected.setEnabled(hasRowsSelected && !all_marked);
                    }
                    if (OpenTorrentInstance.this.btnUnmarkSelected != null && !OpenTorrentInstance.this.btnUnmarkSelected.isDisposed()) {
                        OpenTorrentInstance.this.btnUnmarkSelected.setEnabled(hasRowsSelected && !all_unmarked);
                    }
                    if (OpenTorrentInstance.this.btnSwarmIt != null && !OpenTorrentInstance.this.btnSwarmIt.isDisposed()) {
                        boolean enable = false;
                        if (rows.length == 1) {
                            TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)rows[0].getDataSource();
                            enable = tfi.lSize >= 0x3200000L;
                        }
                        OpenTorrentInstance.this.btnSwarmIt.setEnabled(enable);
                    }
                }
            });
        }

        protected void renameFilenames(TorrentOpenFileOptions[] infos) {
            TorrentOpenFileOptions torrentFileInfo;
            String renameFilename;
            TorrentOpenFileOptions[] arr$ = infos;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (renameFilename = this.askForRenameFilename(torrentFileInfo = arr$[i$])) != null; ++i$) {
                torrentFileInfo.setDestFileName(renameFilename, true);
                TableRowCore row = this.tvFiles.getRow(torrentFileInfo);
                if (row == null) continue;
                row.invalidate(true);
                row.refresh(true);
            }
        }

        private String askForRenameFilename(TorrentOpenFileOptions fileInfo2) {
            SimpleTextEntryWindow dialog = new SimpleTextEntryWindow("FilesView.rename.filename.title", "FilesView.rename.filename.text");
            dialog.setPreenteredText(fileInfo2.orgFileName, false);
            dialog.allowEmptyInput(false);
            dialog.prompt();
            if (!dialog.hasSubmittedInput()) {
                return null;
            }
            return dialog.getSubmittedInput();
        }

        private void setSavePath() {
            if (this.torrentOptions.isSimpleTorrent()) {
                this.changeFileDestination(this.torrentOptions.getFiles(), false);
            } else {
                File new_parent;
                DirectoryDialog dDialog = new DirectoryDialog(this.shell, 131072);
                File filterPath = new File(this.torrentOptions.getDataDir());
                if (!filterPath.exists()) {
                    filterPath = filterPath.getParentFile();
                }
                dDialog.setFilterPath(filterPath.getAbsolutePath());
                dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath") + " (" + this.torrentOptions.getTorrentName() + ")");
                String sNewDir = dDialog.open();
                if (sNewDir == null) {
                    return;
                }
                File newDir = new File(sNewDir).getAbsoluteFile();
                if (!newDir.isDirectory()) {
                    if (newDir.exists()) {
                        Debug.out("new dir isn't a dir!");
                        return;
                    }
                    if (!newDir.mkdirs()) {
                        Debug.out("Failed to create '" + newDir + "'");
                        return;
                    }
                }
                if ((new_parent = newDir.getParentFile()) == null) {
                    Debug.out("Invalid save path, parent folder is null");
                    return;
                }
                this.torrentOptions.setExplicitDataDir(new_parent.getAbsolutePath(), newDir.getName());
                if (COConfigurationManager.getBooleanParameter("open.torrent.window.rename.on.tlf.change")) {
                    this.torrentOptions.setManualRename(newDir.getName());
                } else {
                    this.torrentOptions.setManualRename(null);
                }
                this.updateDataDirCombo();
                this.cmbDataDirChanged();
            }
        }

        private boolean canRemoveTopLevelFolder() {
            if (this.torrentOptions.isSimpleTorrent()) {
                return false;
            }
            File oldDir = new File(this.torrentOptions.getDataDir());
            File newDir = oldDir.getParentFile();
            File newParent = newDir.getParentFile();
            return newParent != null;
        }

        private void removeTopLevelFolder() {
            if (!this.torrentOptions.isSimpleTorrent()) {
                File oldDir = new File(this.torrentOptions.getDataDir());
                File newDir = oldDir.getParentFile();
                File newParent = newDir.getParentFile();
                if (newParent == null) {
                    Debug.out("Invalid save path, parent folder is null");
                    return;
                }
                this.torrentOptions.setExplicitDataDir(newParent.getAbsolutePath(), newDir.getName());
                if (COConfigurationManager.getBooleanParameter("open.torrent.window.rename.on.tlf.change")) {
                    this.torrentOptions.setManualRename(newParent.getName());
                } else {
                    this.torrentOptions.setManualRename(null);
                }
                this.updateDataDirCombo();
                this.cmbDataDirChanged();
            }
        }

        private void changeFileDestination(TorrentOpenFileOptions[] infos, boolean allAtOnce) {
            if (allAtOnce && infos.length > 1) {
                String current_parent = null;
                for (TorrentOpenFileOptions fileInfo2 : infos) {
                    int pos;
                    String dest = fileInfo2.getDestPathName();
                    if (current_parent == null) {
                        current_parent = dest;
                        continue;
                    }
                    if (current_parent.equals(dest)) continue;
                    char[] cp_chars = current_parent.toCharArray();
                    char[] p_chars = dest.toCharArray();
                    int cp_len = cp_chars.length;
                    int p_len = p_chars.length;
                    int min = Math.min(cp_len, p_len);
                    for (pos = 0; pos < min && cp_chars[pos] == p_chars[pos]; ++pos) {
                    }
                    if (pos >= cp_len) continue;
                    File f = new File(new String(cp_chars, 0, pos) + "x");
                    File pf = f.getParentFile();
                    current_parent = pf == null ? "" : pf.toString();
                }
                DirectoryDialog dDialog = new DirectoryDialog(this.shell, 131072);
                if (current_parent.length() > 0) {
                    dDialog.setFilterPath(current_parent);
                }
                dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath_forallfiles"));
                String sSavePath = dDialog.open();
                if (sSavePath != null) {
                    if (sSavePath.endsWith(File.separator)) {
                        sSavePath = sSavePath.substring(0, sSavePath.length() - 1);
                    }
                    int prefix_len = current_parent.length();
                    for (TorrentOpenFileOptions fileInfo3 : infos) {
                        String dest = fileInfo3.getDestPathName();
                        if (prefix_len == 0) {
                            File f = new File(dest);
                            while (f.getParentFile() != null) {
                                f = f.getParentFile();
                            }
                            dest = dest.substring(f.toString().length());
                        } else {
                            dest = dest.substring(prefix_len);
                        }
                        if (dest.startsWith(File.separator)) {
                            dest = dest.substring(1);
                        }
                        if (dest.length() > 0) {
                            fileInfo3.setDestPathName(sSavePath + File.separator + dest);
                            continue;
                        }
                        fileInfo3.setDestPathName(sSavePath);
                    }
                }
            } else {
                for (TorrentOpenFileOptions fileInfo4 : infos) {
                    int style = fileInfo4.parent.getStartMode() == 3 ? 4096 : 8192;
                    FileDialog fDialog = new FileDialog(this.shell, 0x20000 | style);
                    String sFilterPath = fileInfo4.getDestPathName();
                    String sFileName = fileInfo4.orgFileName;
                    File f = new File(sFilterPath);
                    if (!f.isDirectory()) {
                        String parentPath;
                        while (sFilterPath != null && (parentPath = f.getParent()) != null && !(f = new File(sFilterPath = parentPath)).isDirectory()) {
                        }
                    }
                    if (sFilterPath != null) {
                        fDialog.setFilterPath(sFilterPath);
                    }
                    fDialog.setFileName(sFileName);
                    fDialog.setText(MessageText.getString("MainWindow.dialog.choose.savepath") + " (" + fileInfo4.orgFullName + ")");
                    String sNewName = fDialog.open();
                    if (sNewName == null) {
                        return;
                    }
                    if (fileInfo4.parent.getStartMode() == 3) {
                        File file = new File(sNewName);
                        if (file.length() == fileInfo4.lSize) {
                            fileInfo4.setFullDestName(sNewName);
                            continue;
                        }
                        MessageBoxShell mb = new MessageBoxShell(32, "OpenTorrentWindow.mb.badSize", new String[]{file.getName(), fileInfo4.orgFullName});
                        mb.setParent(this.shell);
                        mb.open(null);
                        continue;
                    }
                    fileInfo4.setFullDestName(sNewName);
                }
            }
            this.checkSeedingMode();
            this.updateDataDirCombo();
            this.diskFreeInfoRefreshPending = true;
        }

        private void setupInfoFields(SWTSkin skin) {
            SWTSkinObject so = skin.getSkinObject("torrentinfo-name");
            TOTorrent torrent = this.torrentOptions.getTorrent();
            if (so instanceof SWTSkinObjectText) {
                String hash_str = null;
                try {
                    hash_str = ByteFormatter.encodeString(this.torrentOptions.getTorrent().getHash());
                }
                catch (Throwable e) {
                    // empty catch block
                }
                SWTSkinObjectText text = (SWTSkinObjectText)so;
                text.setText(this.torrentOptions.getTorrentName() + (hash_str == null ? "" : "\u00a0\u00a0\u00a0\u00a0[" + hash_str + "]"));
                if (hash_str != null) {
                    final String f_hash_str = hash_str;
                    ClipboardCopy.addCopyToClipMenu(text.getControl(), new ClipboardCopy.copyToClipProvider2(){

                        @Override
                        public String getMenuResource() {
                            return "menu.copy.hash.to.clipboard";
                        }

                        @Override
                        public String getText() {
                            return f_hash_str;
                        }
                    });
                }
            }
            so = skin.getSkinObject("torrentinfo-trackername");
            if (torrent != null) {
                if (so instanceof SWTSkinObjectText) {
                    ((SWTSkinObjectText)so).setText(TrackerNameItem.getTrackerName(torrent) + (torrent == null || !torrent.getPrivate() ? "" : " (private)"));
                }
                if ((so = skin.getSkinObject("torrentinfo-comment")) instanceof SWTSkinObjectText) {
                    try {
                        LocaleUtilDecoder decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
                        String s = decoder.decodeString(torrent.getComment());
                        ((SWTSkinObjectText)so).setText(s);
                    }
                    catch (UnsupportedEncodingException e) {
                    }
                    catch (TOTorrentException e) {
                        // empty catch block
                    }
                }
                if ((so = skin.getSkinObject("torrentinfo-createdon")) instanceof SWTSkinObjectText) {
                    String creation_date = DisplayFormatters.formatDate(torrent.getCreationDate() * 1000L);
                    ((SWTSkinObjectText)so).setText(creation_date);
                }
            }
        }

        private void setupTrackers(SWTSkinObjectContainer so) {
            Composite parent = so.getComposite();
            Button button = new Button(parent, 8);
            Messages.setLanguageText(button, "label.edit.trackers");
            TOTorrent torrent = this.torrentOptions.getTorrent();
            button.setEnabled(torrent != null && !TorrentUtils.isReallyPrivate(torrent));
            button.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    List<List<String>> trackers = OpenTorrentInstance.this.torrentOptions.getTrackers(false);
                    new MultiTrackerEditor(OpenTorrentInstance.this.shell, null, trackers, new TrackerEditorListener(){

                        @Override
                        public void trackersChanged(String str, String str2, List<List<String>> updatedTrackers) {
                            OpenTorrentInstance.this.torrentOptions.setTrackers(updatedTrackers);
                        }
                    }, true, true);
                }
            });
        }

        private void setupUpDownLimitOption(SWTSkinObjectContainer so) {
            Composite parent = so.getComposite();
            parent.setBackgroundMode(2);
            parent.setLayout(new GridLayout(4, false));
            GridData gridData = new GridData();
            Label label = new Label(parent, 0);
            label.setText(MessageText.getString("TableColumn.header.maxupspeed") + "[" + DisplayFormatters.getRateUnit(1) + "]");
            gridData = new GridData();
            GenericIntParameter paramMaxUploadSpeed = new GenericIntParameter(new IntAdapter(){

                @Override
                public void setIntValue(String key, int value) {
                    OpenTorrentInstance.this.torrentOptions.setMaxUploadSpeed(value);
                }
            }, parent, "torrentoptions.config.uploadspeed", 0, Integer.MAX_VALUE);
            paramMaxUploadSpeed.setLayoutData(gridData);
            label = new Label(parent, 0);
            label.setText(MessageText.getString("TableColumn.header.maxdownspeed") + "[" + DisplayFormatters.getRateUnit(1) + "]");
            gridData = new GridData();
            GenericIntParameter paramMaxDownloadSpeed = new GenericIntParameter(new IntAdapter(){

                @Override
                public void setIntValue(String key, int value) {
                    OpenTorrentInstance.this.torrentOptions.setMaxDownloadSpeed(value);
                }
            }, parent, "torrentoptions.config.downloadspeed", 0, Integer.MAX_VALUE);
            paramMaxDownloadSpeed.setLayoutData(gridData);
        }

        private void setupIPFilterOption(SWTSkinObjectContainer so) {
            Composite parent = so.getComposite();
            parent.setBackgroundMode(2);
            parent.setLayout(new GridLayout());
            Button button = new Button(parent, 96);
            Messages.setLanguageText(button, "MyTorrentsView.menu.ipf_enable");
            GridData gd = new GridData();
            gd.verticalAlignment = 0x1000000;
            Utils.setLayoutData((Control)button, gd);
            button.setSelection(!this.torrentOptions.disableIPFilter);
            button.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ((OpenTorrentInstance)OpenTorrentInstance.this).torrentOptions.disableIPFilter = !((Button)e.widget).getSelection();
                }
            });
        }

        private void setupPeerSourcesAndNetworkOptions(SWTSkinObjectContainer so) {
            Button button;
            String msg_text;
            Composite parent = so.getComposite();
            parent.setBackgroundMode(2);
            Composite peer_sources_composite = new Composite(parent, 0);
            peer_sources_composite.setLayout(new RowLayout(256));
            Group peer_sources_group = new Group(peer_sources_composite, 0);
            Messages.setLanguageText(peer_sources_group, "ConfigView.section.connection.group.peersources");
            RowLayout peer_sources_layout = new RowLayout();
            peer_sources_layout.pack = true;
            peer_sources_layout.spacing = 10;
            peer_sources_group.setLayout(peer_sources_layout);
            FormData form_data = Utils.getFilledFormData();
            form_data.bottom = null;
            Utils.setLayoutData((Control)peer_sources_composite, form_data);
            for (int i = 0; i < PEPeerSource.PS_SOURCES.length; ++i) {
                final String p = PEPeerSource.PS_SOURCES[i];
                String config_name = "Peer Source Selection Default." + p;
                msg_text = "ConfigView.section.connection.peersource." + p;
                button = new Button(peer_sources_group, 32);
                Messages.setLanguageText(button, msg_text);
                button.setSelection(COConfigurationManager.getBooleanParameter(config_name));
                button.addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        ((OpenTorrentInstance)OpenTorrentInstance.this).torrentOptions.peerSource.put(p, ((Button)e.widget).getSelection());
                    }
                });
            }
            Composite network_group_parent = new Composite(parent, 0);
            network_group_parent.setLayout(new RowLayout(256));
            Group network_group = new Group(network_group_parent, 0);
            Messages.setLanguageText(network_group, "ConfigView.section.connection.group.networks");
            RowLayout network_layout = new RowLayout();
            network_layout.pack = true;
            network_layout.spacing = 10;
            network_group.setLayout(network_layout);
            FormData form_data2 = Utils.getFilledFormData();
            form_data2.top = new FormAttachment(peer_sources_composite);
            Utils.setLayoutData((Control)network_group_parent, form_data2);
            for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                final String nn = AENetworkClassifier.AT_NETWORKS[i];
                msg_text = "ConfigView.section.connection.networks." + nn;
                button = new Button(network_group, 32);
                Messages.setLanguageText(button, msg_text);
                this.network_buttons.add(button);
                Map<String, Boolean> enabledNetworks = this.torrentOptions.getEnabledNetworks();
                button.setSelection(enabledNetworks.get(nn));
                button.addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        OpenTorrentInstance.this.torrentOptions.setNetworkEnabled(nn, ((Button)e.widget).getSelection());
                    }
                });
            }
        }

        private void updateNetworkOptions() {
            if (this.network_buttons.size() != AENetworkClassifier.AT_NETWORKS.length) {
                return;
            }
            Map<String, Boolean> enabledNetworks = this.torrentOptions.getEnabledNetworks();
            for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                this.network_buttons.get(i).setSelection(enabledNetworks.get(AENetworkClassifier.AT_NETWORKS[i]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDataDirCombo() {
            if (this.cmbDataDir == null) {
                return;
            }
            try {
                this.bSkipDataDirModify = true;
                if (this.torrentOptions == null) {
                    String prev_parent = null;
                    boolean not_same = false;
                    for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                        String parent = to.getParentDir();
                        if (prev_parent != null && !prev_parent.equals(parent)) {
                            not_same = true;
                            break;
                        }
                        prev_parent = parent;
                    }
                    if (not_same) {
                        this.cmbDataDir.setText(COConfigurationManager.getStringParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH));
                    } else {
                        this.cmbDataDir.setText(prev_parent == null ? "" : prev_parent);
                    }
                } else {
                    this.cmbDataDir.setText(this.torrentOptions.getParentDir());
                }
            }
            finally {
                this.bSkipDataDirModify = false;
            }
        }

        private void setSavePath(String path) {
            this.cmbDataDir.setText(path);
        }

        private String getSavePath() {
            return this.torrentOptions.getParentDir();
        }

        private void updateQueueLocationCombo() {
            if (this.cmbQueueLocation == null) {
                return;
            }
            String[] sItemsText = new String[queueLocations.length];
            for (int i = 0; i < queueLocations.length; ++i) {
                String sText;
                sItemsText[i] = sText = MessageText.getString("OpenTorrentWindow.addPosition." + queueLocations[i]);
            }
            this.cmbQueueLocation.setItems(sItemsText);
            this.cmbQueueLocation.select(this.torrentOptions.iQueueLocation);
        }

        private void updateSize() {
            TorrentOpenFileOptions[] dataFiles;
            if (this.soFileAreaInfo == null && this.soExpandItemFiles == null) {
                return;
            }
            long totalSize = 0L;
            long checkedSize = 0L;
            long numToDownload = 0L;
            for (TorrentOpenFileOptions file : dataFiles = this.torrentOptions.getFiles()) {
                totalSize += file.lSize;
                if (!file.isToDownload()) continue;
                checkedSize += file.lSize;
                ++numToDownload;
            }
            boolean changed = checkedSize != this.currentSelectedDataSize;
            this.currentSelectedDataSize = checkedSize;
            String text = totalSize == 0L ? "" : (checkedSize == totalSize ? DisplayFormatters.formatByteCountToKiBEtc(totalSize) : MessageText.getString("OpenTorrentWindow.filesInfo", new String[]{DisplayFormatters.formatByteCountToKiBEtc(checkedSize), DisplayFormatters.formatByteCountToKiBEtc(totalSize)}));
            if (this.soFileAreaInfo != null) {
                this.soFileAreaInfo.setText(text);
            }
            if (this.soExpandItemFiles != null) {
                String id = "OpenTorrentOptions.header.filesInfo." + (numToDownload == (long)dataFiles.length ? "all" : "some");
                this.soExpandItemFiles.setText(MessageText.getString(id, new String[]{String.valueOf(numToDownload), String.valueOf(dataFiles.length), text}));
            }
            this.diskFreeInfoRefreshPending = true;
            if (changed) {
                this.changeListener.instanceChanged(this);
            }
        }

        protected long getSelectedDataSize() {
            return this.currentSelectedDataSize;
        }

        private void updateStartModeCombo() {
            if (this.cmbStartMode == null) {
                return;
            }
            String[] sItemsText = new String[startModes.length];
            for (int i = 0; i < startModes.length; ++i) {
                String sText;
                sItemsText[i] = sText = MessageText.getString("OpenTorrentWindow.startMode." + startModes[i]);
            }
            this.cmbStartMode.setItems(sItemsText);
            this.cmbStartMode.select(this.torrentOptions.getStartMode());
            this.cmbStartMode.layout(true);
        }

        public void updateUI() {
            if (this.tvFiles != null) {
                this.tvFiles.refreshTable(false);
            }
            if (this.diskFreeInfoRefreshPending && !this.diskFreeInfoRefreshRunning && FileUtil.getUsableSpaceSupported()) {
                this.diskFreeInfoRefreshRunning = true;
                this.diskFreeInfoRefreshPending = false;
                HashSet<File> FSroots = new HashSet<File>(Arrays.asList(File.listRoots()));
                HashMap<File, Partition> partitions = new HashMap<File, Partition>();
                for (TorrentOpenOptions too : this.torrentOptionsMulti) {
                    TorrentOpenFileOptions[] files = too.getFiles();
                    for (int j = 0; j < files.length; ++j) {
                        TorrentOpenFileOptions file = files[j];
                        if (!file.isToDownload()) continue;
                        File root = file.getDestFileFullName().getAbsoluteFile();
                        Partition part = (Partition)partitions.get(this.parentToRootCache.get(root.getParentFile()));
                        if (part == null) {
                            File next;
                            while (!((next = (root = root.getParentFile()).getParentFile()) == null || this.getCachedExistsStat(root) && root.isDirectory() && (FSroots.contains(root) || root.equals(next) || this.getCachedDirFreeSpace(next) != this.getCachedDirFreeSpace(root)))) {
                            }
                            this.parentToRootCache.put(file.getDestFileFullName().getAbsoluteFile().getParentFile(), root);
                            part = (Partition)partitions.get(root);
                            if (part == null) {
                                part = new Partition(root);
                                part.freeSpace = this.getCachedDirFreeSpace(root);
                                partitions.put(root, part);
                            }
                        }
                        part.bytesToConsume += file.lSize;
                    }
                }
                if (this.diskspaceComp != null && !this.diskspaceComp.isDisposed()) {
                    Control[] labels = this.diskspaceComp.getChildren();
                    for (int i = 0; i < labels.length; ++i) {
                        labels[i].dispose();
                    }
                    for (Partition part : partitions.values()) {
                        boolean filesTooBig = part.bytesToConsume > part.freeSpace;
                        String s = MessageText.getString("OpenTorrentWindow.diskUsage", new String[]{DisplayFormatters.formatByteCountToKiBEtc(part.bytesToConsume), DisplayFormatters.formatByteCountToKiBEtc(part.freeSpace)});
                        Label l = new Label(this.diskspaceComp, 0);
                        l.setForeground(filesTooBig ? Colors.colorError : null);
                        l.setText(part.root.getPath());
                        Utils.setLayoutData((Control)l, new GridData(0x1000008, 128, false, false));
                        l = new Label(this.diskspaceComp, 0);
                        l.setForeground(filesTooBig ? Colors.colorError : null);
                        Utils.setLayoutData((Control)l, new GridData(0x1000008, 128, false, false));
                        l.setText(s);
                    }
                    this.diskspaceComp.layout(true);
                    this.soExpandItemSaveTo.relayout();
                }
                this.diskFreeInfoRefreshRunning = false;
            }
        }

        private boolean okPressed(String dataDirPassed) {
            int limit;
            MessageBoxShell mb;
            boolean isPathInvalid;
            File filePassed = new File(dataDirPassed);
            File fileDefSavePath = new File(COConfigurationManager.getStringParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH));
            if (filePassed.equals(fileDefSavePath) && !fileDefSavePath.isDirectory()) {
                FileUtil.mkdirs(fileDefSavePath);
            }
            boolean bl = isPathInvalid = dataDirPassed.length() == 0 || filePassed.isFile();
            if (!isPathInvalid && !filePassed.isDirectory()) {
                mb = new MessageBoxShell(196, "OpenTorrentWindow.mb.askCreateDir", new String[]{filePassed.toString()});
                mb.setParent(this.shell);
                mb.open(null);
                int doCreate = mb.waitUntilClosed();
                if (doCreate == 64) {
                    isPathInvalid = !FileUtil.mkdirs(filePassed);
                } else {
                    this.cmbDataDir.setFocus();
                    return false;
                }
            }
            if (isPathInvalid) {
                mb = new MessageBoxShell(33, "OpenTorrentWindow.mb.noGlobalDestDir", new String[]{filePassed.toString()});
                mb.setParent(this.shell);
                mb.open(null);
                this.cmbDataDir.setFocus();
                return false;
            }
            String sExistingFiles = "";
            int iNumExistingFiles = 0;
            File torrentOptionsDataDir = new File(this.torrentOptions.getDataDir());
            if (!this.torrentOptions.isSimpleTorrent()) {
                torrentOptionsDataDir = torrentOptionsDataDir.getParentFile();
            }
            if (!torrentOptionsDataDir.isDirectory() && !FileUtil.mkdirs(torrentOptionsDataDir)) {
                MessageBoxShell mb2 = new MessageBoxShell(33, "OpenTorrentWindow.mb.noDestDir", new String[]{torrentOptionsDataDir.toString(), this.torrentOptions.getTorrentName()});
                mb2.setParent(this.shell);
                mb2.open(null);
                return false;
            }
            if (!this.torrentOptions.isValid) {
                MessageBoxShell mb3 = new MessageBoxShell(33, "OpenTorrentWindow.mb.notValid", new String[]{this.torrentOptions.getTorrentName()});
                mb3.setParent(this.shell);
                mb3.open(null);
                return false;
            }
            TorrentOpenFileOptions[] files = this.torrentOptions.getFiles();
            for (int j = 0; j < files.length; ++j) {
                TorrentOpenFileOptions fileInfo2 = files[j];
                if (!fileInfo2.getDestFileFullName().exists()) continue;
                sExistingFiles = sExistingFiles + fileInfo2.orgFullName + " - " + this.torrentOptions.getTorrentName() + "\n";
                if (++iNumExistingFiles > 5) break;
            }
            if (sExistingFiles.length() > 0) {
                if (iNumExistingFiles > 5) {
                    sExistingFiles = sExistingFiles + MessageText.getString("OpenTorrentWindow.mb.existingFiles.partialList", new String[]{"" + iNumExistingFiles}) + "\n";
                }
                MessageBoxShell mb4 = new MessageBoxShell(296, "OpenTorrentWindow.mb.existingFiles", new String[]{sExistingFiles});
                mb4.setParent(this.shell);
                mb4.open(null);
                if (mb4.waitUntilClosed() != 32) {
                    return false;
                }
            }
            String sDefaultPath = COConfigurationManager.getStringParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH);
            String dataDir = this.torrentOptions.isExplicitDataDir() ? this.torrentOptions.getDataDir() : this.torrentOptions.getParentDir();
            if (!dataDir.equals(sDefaultPath) && (limit = COConfigurationManager.getIntParameter("saveTo_list.max_entries")) >= 0) {
                File fDestDir = new File(dataDir);
                int iDirPos = -1;
                for (int i = 0; i < this.dirList.size(); ++i) {
                    String sDirName = this.dirList.get(i);
                    File dir = new File(sDirName);
                    if (!dir.equals(fDestDir)) continue;
                    iDirPos = i;
                    break;
                }
                if (iDirPos > 0 && iDirPos < this.dirList.size()) {
                    this.dirList.remove(iDirPos);
                }
                this.dirList.add(0, dataDir);
                if (limit > 0 && this.dirList.size() > limit) {
                    this.dirList.remove(this.dirList.size() - 1);
                }
                try {
                    for (int j = 0; j < this.dirList.size(); ++j) {
                        File dirJ = new File(this.dirList.get(j));
                        for (int i = 0; i < this.dirList.size(); ++i) {
                            try {
                                File dirI;
                                if (i == j || !(dirI = new File(this.dirList.get(i))).equals(dirJ)) continue;
                                this.dirList.remove(i);
                                if (j > i) {
                                    --j;
                                }
                                --i;
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                COConfigurationManager.setParameter("saveTo_list", this.dirList);
                COConfigurationManager.save();
            }
            if (COConfigurationManager.getBooleanParameter("DefaultDir.AutoUpdate")) {
                COConfigurationManager.setParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH, dataDir);
            }
            if (OpenTorrentOptionsWindow.this.listTagsToCreate.size() > 0) {
                TagManager tagManager = TagManagerFactory.getTagManager();
                TagType tagType = tagManager.getTagType(3);
                String[] tagsToCreate = OpenTorrentOptionsWindow.this.listTagsToCreate.toArray(new String[0]);
                List<Tag> initialTags = this.torrentOptions.getInitialTags();
                for (String tagName : tagsToCreate) {
                    try {
                        Tag tag = tagType.createTag(tagName, true);
                        tag.setPublic(true);
                        OpenTorrentOptionsWindow.this.listTagsToCreate.remove(tagName);
                        initialTags.add(tag);
                    }
                    catch (TagException e) {
                        // empty catch block
                    }
                }
                this.torrentOptions.setInitialTags(initialTags);
            }
            return true;
        }

        private void dispose() {
            this.tvFiles.delete();
        }
    }

    public static interface OpenTorrentInstanceListener {
        public void instanceChanged(OpenTorrentInstance var1);
    }

    private static final class Partition {
        long bytesToConsume = 0L;
        long freeSpace = 0L;
        final File root;

        public Partition(File root) {
            this.root = root;
        }
    }

    private static class TreeNode {
        private static TreeNode[] NO_KIDS = new TreeNode[0];
        private final TreeNode parent;
        private String name;
        private Object data = new TreeMap(OpenTorrentOptionsWindow.access$5200());
        private long size = Long.MAX_VALUE;

        private TreeNode(TreeNode _parent, String _name) {
            this.parent = _parent;
            this.name = _name;
        }

        private String getName() {
            if (this.data instanceof TorrentOpenFileOptions) {
                return ((TorrentOpenFileOptions)this.data).getDestFileName();
            }
            return this.name;
        }

        private TreeNode getParent() {
            return this.parent;
        }

        private TreeNode getChild(String name) {
            return (TreeNode)((TreeMap)this.data).get(name);
        }

        private void addChild(TreeNode child) {
            ((TreeMap)this.data).put(child.getName(), child);
        }

        private void setFile(TorrentOpenFileOptions file) {
            this.data = file;
        }

        private boolean isChecked() {
            TreeNode[] kids;
            if (this.data instanceof TorrentOpenFileOptions) {
                return ((TorrentOpenFileOptions)this.data).isToDownload();
            }
            for (TreeNode kid : kids = this.getChildren()) {
                if (!kid.isChecked()) continue;
                return true;
            }
            return false;
        }

        private boolean isGrayed() {
            if (this.data instanceof TorrentOpenFileOptions) {
                return false;
            }
            TreeNode[] kids = this.getChildren();
            int state = 0;
            for (TreeNode kid : kids) {
                int kid_state;
                if (kid.isGrayed()) {
                    return true;
                }
                int n = kid_state = kid.isChecked() ? 1 : 2;
                if (state == 0) {
                    state = kid_state;
                    continue;
                }
                if (state == kid_state) continue;
                return true;
            }
            return false;
        }

        private TreeNode[] getChildren() {
            if (this.data instanceof Map) {
                TreeMap map = (TreeMap)this.data;
                this.data = map.values().toArray(new TreeNode[map.size()]);
            }
            if (this.data instanceof TreeNode[]) {
                return (TreeNode[])this.data;
            }
            return NO_KIDS;
        }

        private void sort(Comparator<TreeNode> comparator) {
            TreeNode[] kids = this.getChildren();
            int num_kids = kids.length;
            if (num_kids >= 2) {
                Arrays.sort(kids, comparator);
            }
            for (int i = 0; i < num_kids; ++i) {
                kids[i].sort(comparator);
            }
        }

        private TorrentOpenFileOptions getFile() {
            if (this.data instanceof TorrentOpenFileOptions) {
                return (TorrentOpenFileOptions)this.data;
            }
            return null;
        }

        private List<TorrentOpenFileOptions> getFiles() {
            ArrayList<TorrentOpenFileOptions> files = new ArrayList<TorrentOpenFileOptions>(1024);
            this.getFiles(files);
            return files;
        }

        private void getFiles(List<TorrentOpenFileOptions> files) {
            if (this.data instanceof TorrentOpenFileOptions) {
                files.add((TorrentOpenFileOptions)this.data);
            } else {
                TreeNode[] kids;
                for (TreeNode kid : kids = this.getChildren()) {
                    kid.getFiles(files);
                }
            }
        }

        private long getSize() {
            if (this.size != Long.MAX_VALUE) {
                return this.size;
            }
            if (this.data instanceof TorrentOpenFileOptions) {
                this.size = ((TorrentOpenFileOptions)this.data).lSize;
            } else {
                TreeNode[] kids;
                this.size = 0L;
                for (TreeNode kid : kids = this.getChildren()) {
                    this.size += Math.abs(kid.getSize());
                }
                this.size = -this.size;
            }
            return this.size;
        }
    }
}

