/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryOpenListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.mdi.TabbedMDI;
import com.aelitis.azureus.ui.swt.mdi.TabbedMdiInterface;
import com.aelitis.azureus.ui.swt.plugininstall.SimplePluginInstaller;
import com.aelitis.azureus.ui.swt.search.SearchHandler;
import com.aelitis.azureus.ui.swt.shells.BrowserWindow;
import com.aelitis.azureus.ui.swt.shells.RemotePairingWindow;
import com.aelitis.azureus.ui.swt.shells.main.MainMenu;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.shells.opentorrent.OpenTorrentOptionsWindow;
import com.aelitis.azureus.ui.swt.shells.opentorrent.OpenTorrentWindow;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.TagUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.history.DownloadHistoryManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarManagerImpl;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.shells.MessageSlideShell;
import org.gudy.azureus2.ui.swt.update.FullUpdateWindow;

public class UIFunctionsImpl
implements UIFunctionsSWT {
    private static final String MSG_ALREADY_EXISTS = "OpenTorrentWindow.mb.alreadyExists";
    private static final String MSG_ALREADY_EXISTS_NAME = "OpenTorrentWindow.mb.alreadyExists.default.name";
    private static final LogIDs LOGID = LogIDs.GUI;
    private final MainWindow mainWindow;
    private SWTSkin skin = null;
    protected boolean isTorrentMenuVisible;

    public UIFunctionsImpl(MainWindow window) {
        this.mainWindow = window;
        COConfigurationManager.addAndFireParameterListener("show_torrents_menu", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                UIFunctionsImpl.this.isTorrentMenuVisible = COConfigurationManager.getBooleanParameter("show_torrents_menu");
            }
        });
    }

    @Override
    public int getUIType() {
        return 1;
    }

    @Override
    public void addPluginView(final String viewID, final UISWTViewEventListener l) {
        try {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    PluginsMenuHelper.getInstance().addPluginView(viewID, l);
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    @Override
    public void bringToFront() {
        this.bringToFront(true);
    }

    @Override
    public void bringToFront(final boolean tryTricks) {
        String debug = COConfigurationManager.getStringParameter("adv.setting.ui.debug.window.show", "");
        if (debug.equals("1")) {
            Debug.out("UIF::bringToFront");
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    UIFunctionsImpl.this.mainWindow.setVisible(true, tryTricks);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "bringToFront", e));
                }
            }
        });
    }

    @Override
    public int getVisibilityState() {
        final Shell shell = this.getMainShell();
        if (shell == null) {
            return 2;
        }
        final int[] result = new int[]{2};
        final AESemaphore sem = new AESemaphore("getVisibilityState");
        if (Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                try {
                    result[0] = !shell.isVisible() ? 2 : (shell.getMinimized() ? 3 : 4);
                }
                finally {
                    sem.release();
                }
            }
        })) {
            sem.reserve(30000L);
        }
        return result[0];
    }

    @Override
    public void closeDownloadBars() {
        try {
            Utils.execSWTThreadLater(0, new AERunnable(){

                @Override
                public void runSupport() {
                    MiniBarManager.getManager().closeAll();
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closeDownloadBars", e));
        }
    }

    @Override
    public void closePluginView(UISWTViewCore view) {
        try {
            String id;
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi == null) {
                return;
            }
            if (view instanceof UISWTViewImpl) {
                id = ((UISWTViewImpl)view).getViewID();
            } else {
                id = view.getClass().getName();
                int i = id.lastIndexOf(46);
                if (i > 0) {
                    id = id.substring(i + 1);
                }
            }
            mdi.closeEntry(id);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginView", e));
        }
    }

    @Override
    public void closePluginViews(String sViewID) {
        try {
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi == null) {
                return;
            }
            mdi.closeEntry(sViewID);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginViews", e));
        }
    }

    @Override
    public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
        try {
            return this.mainWindow.dispose(for_restart, close_already_in_progress);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Disposing MainWindow", e));
            return false;
        }
    }

    @Override
    public Shell getMainShell() {
        return this.mainWindow == null ? null : this.mainWindow.getShell();
    }

    @Override
    public UISWTView[] getPluginViews() {
        try {
            return new UISWTView[0];
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getPluginViews", e));
            return new UISWTView[0];
        }
    }

    public UISWTInstanceImpl getSWTPluginInstanceImpl() {
        try {
            return this.mainWindow.getUISWTInstanceImpl();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getSWTPluginInstanceImpl", e));
            return null;
        }
    }

    @Override
    public void openPluginView(String sParentID, String sViewID, UISWTViewEventListener l, Object dataSource, boolean bSetFocus) {
        try {
            MultipleDocumentInterfaceSWT mdi = this.getMDISWT();
            if (mdi != null) {
                String sidebarParentID = null;
                if ("MyTorrents".equals(sParentID)) {
                    sidebarParentID = "header.transfers";
                } else if ("Main".equals(sParentID)) {
                    sidebarParentID = "header.plugins";
                } else {
                    System.err.println("Can't find parent " + sParentID + " for " + sViewID);
                }
                MdiEntry entry = mdi.createEntryFromEventListener(sidebarParentID, l, sViewID, true, dataSource, null);
                if (bSetFocus) {
                    mdi.showEntryByID(sViewID);
                } else if (entry instanceof BaseMdiEntry) {
                    ((BaseMdiEntry)entry).build();
                }
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    @Override
    public void refreshIconBar() {
        try {
            SkinView[] tbSkinViews = SkinViewManager.getMultiByClass(ToolBarView.class);
            if (tbSkinViews != null) {
                for (SkinView skinview : tbSkinViews) {
                    ToolBarView tb;
                    if (!(skinview instanceof ToolBarView) || !(tb = (ToolBarView)skinview).isVisible()) continue;
                    tb.refreshCoreToolBarItems();
                }
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshIconBar", e));
        }
    }

    @Override
    public void refreshLanguage() {
        try {
            this.mainWindow.setSelectedLanguageItem();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshLanguage", e));
        }
    }

    @Override
    public void removePluginView(String viewID) {
        try {
            PluginsMenuHelper.getInstance().removePluginViews(viewID);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removePluginView", e));
        }
    }

    @Override
    public void setStatusText(final String string) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                IMainStatusBar sb = UIFunctionsImpl.this.getMainStatusBar();
                if (sb != null) {
                    sb.setStatusText(string);
                }
            }
        });
    }

    @Override
    public void setStatusText(final int statustype, final String string, final UIStatusTextClickListener l) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                IMainStatusBar sb = UIFunctionsImpl.this.getMainStatusBar();
                if (sb != null) {
                    sb.setStatusText(statustype, string, l);
                }
            }
        });
    }

    @Override
    public IMainStatusBar getMainStatusBar() {
        if (this.mainWindow == null) {
            return null;
        }
        return this.mainWindow.getMainStatusBar();
    }

    @Override
    @Deprecated
    public void openView(int viewID, Object data) {
        MultipleDocumentInterface mdi = this.getMDI();
        if (viewID == 4) {
            mdi.showEntryByID("ConfigView", data);
        } else if (viewID == 5) {
            mdi.showEntryByID("DMDetails", data);
        } else if (viewID == 8) {
            mdi.showEntryByID("Library", data);
        } else {
            System.err.println("DEPRECATED -- Use getMDI().showEntryByID(" + viewID + "..)");
        }
    }

    @Override
    public UISWTInstance getUISWTInstance() {
        UISWTInstanceImpl impl = this.mainWindow.getUISWTInstanceImpl();
        if (impl == null) {
            Debug.out("No uiswtinstanceimpl");
        }
        return impl;
    }

    @Override
    public void viewURL(String url, String target, String sourceRef) {
        this.viewURL(url, target, 0, 0, true, false);
    }

    @Override
    public boolean viewURL(final String url, final String target, final int w, final int h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.getShell().getDisplay().syncExec(new AERunnable(){

            @Override
            public void runSupport() {
                String realURL = url;
                ContentNetwork cn = ContentNetworkUtils.getContentNetworkFromTarget(target);
                if (!realURL.startsWith("http") && !realURL.startsWith("#")) {
                    realURL = "_blank".equals(target) ? cn.getExternalSiteRelativeURL(realURL, false) : cn.getSiteRelativeURL(realURL, false);
                }
                if (target == null) {
                    if (UrlFilter.getInstance().urlCanRPC(realURL)) {
                        realURL = cn.appendURLSuffix(realURL, false, true);
                    }
                    BrowserWindow window = new BrowserWindow(UIFunctionsImpl.this.mainWindow.getShell(), realURL, w, h, allowResize, isModal);
                    window.waitUntilClosed();
                } else {
                    UIFunctionsImpl.this.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    @Override
    public boolean viewURL(final String url, final String target, final double w, final double h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.getShell().getDisplay().syncExec(new AERunnable(){

            @Override
            public void runSupport() {
                String realURL = url;
                ContentNetwork cn = ContentNetworkUtils.getContentNetworkFromTarget(target);
                if (!realURL.startsWith("http")) {
                    realURL = "_blank".equals(target) ? cn.getExternalSiteRelativeURL(realURL, false) : cn.getSiteRelativeURL(realURL, false);
                }
                if (target == null) {
                    if (UrlFilter.getInstance().urlCanRPC(realURL)) {
                        realURL = cn.appendURLSuffix(realURL, false, true);
                    }
                    BrowserWindow window = new BrowserWindow(UIFunctionsImpl.this.mainWindow.getShell(), realURL, w, h, allowResize, isModal);
                    window.waitUntilClosed();
                } else {
                    UIFunctionsImpl.this.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    private void showURL(final String url, String target) {
        if ("_blank".equalsIgnoreCase(target)) {
            Utils.launch(url);
            return;
        }
        if (target.startsWith("tab-")) {
            target = target.substring(4);
        }
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if ("Plus".equals(target)) {
            SBC_PlusFTUX.setSourceRef(url.substring(1));
            mdi.showEntryByID(target);
            return;
        }
        if (mdi == null || !mdi.showEntryByID(target)) {
            Utils.launch(url);
            return;
        }
        MdiEntry entry = mdi.getEntry(target);
        entry.addListener(new MdiEntryOpenListener(){

            @Override
            public void mdiEntryOpen(MdiEntry entry) {
                entry.removeListener(this);
                UIFunctionsImpl.this.mainWindow.setVisible(true, true);
                if (!(entry instanceof SideBarEntrySWT)) {
                    return;
                }
                SideBarEntrySWT entrySWT = (SideBarEntrySWT)entry;
                SWTSkinObjectBrowser soBrowser = SWTSkinUtils.findBrowserSO(entrySWT.getSkinObject());
                if (soBrowser != null) {
                    if (url == null || url.length() == 0) {
                        soBrowser.restart();
                    } else {
                        String fullURL = url;
                        if (UrlFilter.getInstance().urlCanRPC(url)) {
                            fullURL = ConstantsVuze.getDefaultContentNetwork().appendURLSuffix(url, false, true);
                        }
                        soBrowser.setURL(fullURL);
                    }
                }
            }
        });
    }

    @Override
    public void promptUser(String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean rememberByDefault, int autoCloseInMS, UserPrompterResultListener l) {
        MessageBoxShell.open(this.getMainShell(), title, text, buttons, defaultOption, rememberID, rememberText, rememberByDefault, autoCloseInMS, l);
    }

    @Override
    public UIFunctionsUserPrompter getUserPrompter(String title, String text, String[] buttons, int defaultOption) {
        MessageBoxShell mb = new MessageBoxShell(title, text, buttons, defaultOption);
        return mb;
    }

    @Override
    public boolean isGlobalTransferBarShown() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        return AllTransfersBar.getManager().isOpen(AzureusCoreFactory.getSingleton().getGlobalManager());
    }

    @Override
    public void showGlobalTransferBar() {
        AllTransfersBar.open(this.getMainShell());
    }

    @Override
    public void closeGlobalTransferBar() {
        AllTransfersBar.closeAllTransfersBar();
    }

    @Override
    public void refreshTorrentMenu() {
        if (!this.isTorrentMenuVisible) {
            return;
        }
        try {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    MenuItem torrentItem = MenuFactory.findMenuItem(UIFunctionsImpl.this.mainWindow.getMainMenu().getMenu("menu.bar"), "MainWindow.menu.torrent", false);
                    if (null != torrentItem) {
                        DownloadManager[] dms;
                        DownloadManager[] dm_final = dms = SelectedContentManager.getDMSFromSelectedContent();
                        boolean detailed_view_final = false;
                        if (null == dm_final) {
                            torrentItem.setEnabled(false);
                        } else {
                            TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                            torrentItem.getMenu().setData("TableView", tv);
                            torrentItem.getMenu().setData("downloads", dm_final);
                            torrentItem.getMenu().setData("is_detailed_view", false);
                            torrentItem.setEnabled(true);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshTorrentMenu", e));
        }
    }

    @Override
    public IMainMenu createMainMenu(Shell shell) {
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        IMainMenu menu = uiClassic ? new org.gudy.azureus2.ui.swt.mainwindow.MainMenu(shell) : new MainMenu(this.skin, shell);
        return menu;
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public void setSkin(SWTSkin skin) {
        this.skin = skin;
    }

    @Override
    public IMainWindow getMainWindow() {
        return this.mainWindow;
    }

    @Override
    public UIUpdater getUIUpdater() {
        return UIUpdaterSWT.getInstance();
    }

    @Override
    public void closeAllDetails() {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry[] sideBarEntries = mdi.getEntries();
        for (int i = 0; i < sideBarEntries.length; ++i) {
            MdiEntry entry = sideBarEntries[i];
            String id = entry.getId();
            if (id == null || !id.startsWith("DMDetails_")) continue;
            mdi.closeEntry(id);
        }
    }

    @Override
    public boolean hasDetailViews() {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return false;
        }
        MdiEntry[] sideBarEntries = mdi.getEntries();
        for (int i = 0; i < sideBarEntries.length; ++i) {
            MdiEntry entry = sideBarEntries[i];
            String id = entry.getId();
            if (id == null || !id.startsWith("DMDetails_")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void performAction(int action_id, Object args, final UIFunctions.actionListener listener) {
        if (action_id == 1) {
            FullUpdateWindow.handleUpdate((String)args, listener);
        } else if (action_id == 2) {
            String MSG_PREFIX = "UpdateMonitor.messagebox.";
            String title = MessageText.getString(MSG_PREFIX + "restart.title");
            String text = MessageText.getString(MSG_PREFIX + "restart.text");
            this.bringToFront();
            boolean no_timeout = args instanceof Boolean && (Boolean)args != false;
            int timeout = 180000;
            if (no_timeout || !PluginInitializer.getDefaultInterface().getPluginManager().isSilentRestartEnabled()) {
                timeout = -1;
            }
            MessageBoxShell messageBoxShell = new MessageBoxShell(title, text, new String[]{MessageText.getString("UpdateWindow.restart"), MessageText.getString("UpdateWindow.restartLater")}, 0);
            messageBoxShell.setAutoCloseInMS(timeout);
            messageBoxShell.setParent(this.getMainShell());
            messageBoxShell.setOneInstanceOf(MSG_PREFIX);
            messageBoxShell.open(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    listener.actionComplete(result == 0);
                }
            });
        } else {
            Debug.out("Unknown action " + action_id);
        }
    }

    @Override
    public Shell showCoreWaitDlg() {
        Initializer initializer;
        final SkinnedDialog closeDialog = new SkinnedDialog("skin3_dlg_coreloading", "coreloading.body", 67616);
        closeDialog.setTitle(MessageText.getString("dlg.corewait.title"));
        SWTSkin skin = closeDialog.getSkin();
        SWTSkinObjectButton soButton = (SWTSkinObjectButton)skin.getSkinObject("close");
        final SWTSkinObjectText soWaitTask = (SWTSkinObjectText)skin.getSkinObject("task");
        final SWTSkinObject soWaitProgress = skin.getSkinObject("progress");
        if (soWaitProgress != null) {
            soWaitProgress.getControl().addPaintListener(new PaintListener(){

                @Override
                public void paintControl(PaintEvent e) {
                    Control c = (Control)e.widget;
                    Point size = c.getSize();
                    e.gc.setBackground(ColorCache.getColor((Device)e.display, "#23a7df"));
                    Object data = soWaitProgress.getData("progress");
                    if (data instanceof Long) {
                        int waitProgress = ((Long)data).intValue();
                        int breakX = size.x * waitProgress / 100;
                        e.gc.fillRectangle(0, 0, breakX, size.y);
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#cccccc"));
                        e.gc.fillRectangle(breakX, 0, size.x - breakX, size.y);
                    }
                }
            });
        }
        if (!AzureusCoreFactory.isCoreRunning() && (initializer = Initializer.getLastInitializer()) != null) {
            initializer.addListener(new InitializerListener(){

                @Override
                public void reportPercent(final int percent) {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (soWaitProgress != null && !soWaitProgress.isDisposed()) {
                                soWaitProgress.setData("progress", new Long(percent));
                                soWaitProgress.getControl().redraw();
                                soWaitProgress.getControl().update();
                            }
                        }
                    });
                    if (percent > 100) {
                        initializer.removeListener(this);
                    }
                }

                @Override
                public void reportCurrentTask(String currentTask) {
                    if (soWaitTask != null && !soWaitTask.isDisposed()) {
                        soWaitTask.setText(currentTask);
                    }
                }
            });
        }
        if (soButton != null) {
            soButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    closeDialog.close();
                }
            });
        }
        closeDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            @Override
            public void skinDialogClosed(SkinnedDialog dialog) {
            }
        });
        closeDialog.open();
        return closeDialog.getShell();
    }

    @Override
    public void doSearch(final String sSearchText) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                UIFunctionsImpl.this.doSearch(sSearchText, false);
            }
        });
    }

    @Override
    public void doSearch(String sSearchText, boolean toSubscribe) {
        if (sSearchText.length() == 0) {
            return;
        }
        if (UIFunctionsImpl.checkForSpecialSearchTerm(sSearchText)) {
            return;
        }
        SearchHandler.handleSearch(sSearchText, toSubscribe);
    }

    private static boolean checkForSpecialSearchTerm(String str) {
        String hit = UrlUtils.parseTextForURL(str = str.trim(), true, true);
        if (hit == null) {
            try {
                UIFunctionsSWT uif;
                String name;
                File f = new File(str);
                if (f.isFile() && ((name = f.getName().toLowerCase()).endsWith(".torrent") || name.endsWith(".vuze")) && (uif = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null) {
                    uif.openTorrentOpenOptions(null, null, new String[]{f.getAbsolutePath()}, false, false);
                    return true;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            return false;
        }
        try {
            URL hit_url = new URL(hit);
            URL url = hit_url.getProtocol().equals("tor") ? new URL(hit.substring(4)) : hit_url;
            String path = url.getPath();
            if ((path.length() == 0 || path.equals("/")) && url.getQuery() == null) {
                Utils.launch(hit_url.toExternalForm());
                return true;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        new FileDownloadWindow(uiFunctions.getMainShell(), hit, null, null, true);
        return true;
    }

    @Override
    public void promptForSearch() {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("Button.search", "search.dialog.text");
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver receiver) {
                if (receiver.hasSubmittedInput()) {
                    UIFunctionsImpl.this.doSearch(receiver.getSubmittedInput());
                }
            }
        });
    }

    @Override
    public MultipleDocumentInterface getMDI() {
        return (MultipleDocumentInterface)((Object)SkinViewManager.getByViewID("mdi"));
    }

    @Override
    public MultipleDocumentInterfaceSWT getMDISWT() {
        return (MultipleDocumentInterfaceSWT)((Object)SkinViewManager.getByViewID("mdi"));
    }

    @Override
    public void showErrorMessage(final String keyPrefix, final String details, final String[] textParams) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Shell mainShell = UIFunctionsImpl.this.getMainShell();
                if (mainShell.getDisplay().getActiveShell() != null || mainShell.isFocusControl()) {
                    new MessageSlideShell(Display.getCurrent(), 1, keyPrefix, details, textParams, -1);
                } else {
                    MessageBoxShell mb = new MessageBoxShell(32, keyPrefix, textParams);
                    mb.open(null);
                }
            }
        });
    }

    @Override
    public void forceNotify(final int iconID, final String title, final String text, final String details, final Object[] relatedObjects, final int timeoutSecs) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                int swtIconID = 2;
                switch (iconID) {
                    case 1: {
                        swtIconID = 8;
                        break;
                    }
                    case 2: {
                        swtIconID = 1;
                    }
                }
                new MessageSlideShell(SWTThread.getInstance().getDisplay(), swtIconID, title, text, details, relatedObjects, timeoutSecs);
            }
        });
    }

    @Override
    public void installPlugin(String plugin_id, String resource_prefix, UIFunctions.actionListener listener) {
        new SimplePluginInstaller(plugin_id, resource_prefix, listener);
    }

    @Override
    public UIToolBarManager getToolBarManager() {
        return UIToolBarManagerImpl.getInstance();
    }

    @Override
    public void runOnUIThread(int ui_type, Runnable runnable) {
        if (ui_type == 1) {
            Utils.execSWTThread(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public boolean isProgramInstalled(String extension, String name) {
        Program program;
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        return (program = Program.findProgram(extension)) == null ? false : program.getName().toLowerCase(Locale.US).contains(name.toLowerCase(Locale.US));
    }

    @Override
    public void openRemotePairingWindow() {
        RemotePairingWindow.open();
    }

    @Override
    public void playOrStreamDataSource(Object ds, String referal, boolean launch_already_checked, boolean complete_only) {
        TorrentListViewsUtils.playOrStreamDataSource(ds, referal, launch_already_checked, complete_only);
    }

    @Override
    public void setHideAll(boolean hidden) {
        this.mainWindow.setHideAll(hidden);
    }

    @Override
    public boolean addTorrentWithOptions(boolean force, TorrentOpenOptions torrentOptions) {
        HashMap<String, Object> add_options = new HashMap<String, Object>();
        add_options.put("forceOpen", force);
        return this.addTorrentWithOptions(torrentOptions, add_options);
    }

    @Override
    public boolean addTorrentWithOptions(final TorrentOpenOptions torrentOptions, Map<String, Object> addOptions) {
        Boolean force;
        Boolean is_silent = (Boolean)addOptions.get("silent");
        if (is_silent == null) {
            is_silent = false;
        }
        if (AzureusCoreFactory.isCoreRunning()) {
            TOTorrent torrent;
            AzureusCore core = AzureusCoreFactory.getSingleton();
            GlobalManager gm = core.getGlobalManager();
            DownloadManager existingDownload = gm.getDownloadManager(torrent = torrentOptions.getTorrent());
            if (existingDownload != null) {
                if (!is_silent.booleanValue()) {
                    final String fExistingName = existingDownload.getDisplayName();
                    final DownloadManager fExistingDownload = existingDownload;
                    fExistingDownload.fireGlobalManagerEvent(1);
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            boolean can_merge = TorrentUtils.canMergeAnnounceURLs(torrentOptions.getTorrent(), fExistingDownload.getTorrent());
                            long existed_for = SystemTime.getCurrentTime() - fExistingDownload.getCreationTime();
                            Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
                            if (!(Display.getDefault().getActiveShell() != null && mainShell.isVisible() && !mainShell.getMinimized() || can_merge)) {
                                if (existed_for > 15000L) {
                                    new MessageSlideShell(Display.getCurrent(), 2, UIFunctionsImpl.MSG_ALREADY_EXISTS, null, new String[]{":" + torrentOptions.sOriginatingLocation, fExistingName, MessageText.getString(UIFunctionsImpl.MSG_ALREADY_EXISTS_NAME)}, new Object[]{fExistingDownload}, -1);
                                }
                            } else if (can_merge) {
                                String text = MessageText.getString("OpenTorrentWindow.mb.alreadyExists.text", new String[]{":" + torrentOptions.sOriginatingLocation, fExistingName, MessageText.getString(UIFunctionsImpl.MSG_ALREADY_EXISTS_NAME)});
                                text = text + "\n\n" + MessageText.getString("openTorrentWindow.mb.alreadyExists.merge");
                                MessageBoxShell mb = new MessageBoxShell(192, MessageText.getString("OpenTorrentWindow.mb.alreadyExists.title"), text);
                                mb.open(new UserPrompterResultListener(){

                                    @Override
                                    public void prompterClosed(int result) {
                                        if (result == 64) {
                                            TorrentUtils.mergeAnnounceURLs(torrentOptions.getTorrent(), fExistingDownload.getTorrent());
                                        }
                                    }
                                });
                            } else if (existed_for > 15000L) {
                                MessageBoxShell mb = new MessageBoxShell(32, UIFunctionsImpl.MSG_ALREADY_EXISTS, new String[]{":" + torrentOptions.sOriginatingLocation, fExistingName, MessageText.getString(UIFunctionsImpl.MSG_ALREADY_EXISTS_NAME)});
                                mb.open(null);
                            }
                        }
                    });
                }
                if (torrentOptions.bDeleteFileOnCancel) {
                    File torrentFile = new File(torrentOptions.sFileName);
                    torrentFile.delete();
                }
                return true;
            }
            try {
                final DownloadStub archived = core.getPluginManager().getDefaultPluginInterface().getDownloadManager().lookupDownloadStub(torrent.getHash());
                if (archived != null) {
                    if (is_silent.booleanValue()) {
                        archived.destubbify();
                        if (torrentOptions.bDeleteFileOnCancel) {
                            File torrentFile = new File(torrentOptions.sFileName);
                            torrentFile.delete();
                        }
                        return true;
                    }
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
                            String existingName = archived.getName();
                            if (Display.getDefault().getActiveShell() == null || !mainShell.isVisible() || mainShell.getMinimized()) {
                                new MessageSlideShell(Display.getCurrent(), 2, "OpenTorrentWindow.mb.inArchive", null, new String[]{existingName}, new Object[0], -1);
                            } else {
                                MessageBoxShell mb = new MessageBoxShell(32, "OpenTorrentWindow.mb.inArchive", new String[]{existingName});
                                mb.open(null);
                            }
                        }
                    });
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            if (!is_silent.booleanValue()) {
                try {
                    DownloadHistoryManager dlm = (DownloadHistoryManager)core.getGlobalManager().getDownloadHistoryManager();
                    final long[] existing = dlm.getDates(torrentOptions.getTorrent().getHash());
                    if (existing != null) {
                        long redownloaded = existing[3];
                        if (SystemTime.getCurrentTime() - redownloaded > 600000L) {
                            Utils.execSWTThread(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
                                    if (mainShell != null && !mainShell.isDisposed()) {
                                        new MessageSlideShell(mainShell.getDisplay(), 2, "OpenTorrentWindow.mb.inHistory", null, new String[]{torrentOptions.getTorrentName(), new SimpleDateFormat().format(new Date(existing[0]))}, new Object[0], -1);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        if ((force = (Boolean)addOptions.get("forceOpen")) == null) {
            force = false;
        }
        if (!force.booleanValue()) {
            TOTorrent torrent = torrentOptions.getTorrent();
            boolean is_featured = torrent != null && PlatformTorrentUtils.isFeaturedContent(torrent);
            String showAgainMode = COConfigurationManager.getStringParameter("ui.addtorrent.openoptions");
            if (is_featured || is_silent.booleanValue() || showAgainMode != null && (showAgainMode.equals("never") || showAgainMode.equals("many") && torrentOptions.getFiles() != null && torrentOptions.getFiles().length == 1)) {
                boolean looks_good = false;
                String save_loc = torrentOptions.getParentDir().trim();
                if (save_loc.length() != 0 && !save_loc.startsWith(".")) {
                    File f = new File(save_loc);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    if (f.isDirectory() && FileUtil.canWriteToDirectory(f) && !f.equals(AETemporaryFileHandler.getTempDirectory())) {
                        looks_good = true;
                    }
                }
                if (looks_good) {
                    TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
                    t_man.optionsAdded(torrentOptions);
                    t_man.optionsAccepted(torrentOptions);
                    boolean ok = TorrentOpener.addTorrent(torrentOptions);
                    t_man.optionsRemoved(torrentOptions);
                    return ok;
                }
                torrentOptions.setParentDir("");
                if (is_silent.booleanValue()) {
                    return false;
                }
                MessageBoxShell mb = new MessageBoxShell(33, "OpenTorrentWindow.mb.invaliddefsave", new String[]{save_loc});
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        OpenTorrentOptionsWindow.addTorrent(torrentOptions);
                    }
                });
                return true;
            }
        }
        if (is_silent.booleanValue()) {
            return false;
        }
        OpenTorrentOptionsWindow.addTorrent(torrentOptions);
        return true;
    }

    @Override
    public void openTorrentOpenOptions(Shell shell, String sPathOfFilesToOpen, String[] sFilesToOpen, boolean defaultToStopped, boolean forceOpen) {
        TorrentOpenOptions torrentOptions = new TorrentOpenOptions();
        if (defaultToStopped) {
            torrentOptions.setStartMode(1);
        }
        if (sFilesToOpen == null) {
            new OpenTorrentWindow(shell);
        } else {
            TorrentOpener.openTorrentsFromStrings(torrentOptions, shell, sPathOfFilesToOpen, sFilesToOpen, null, null, forceOpen);
        }
    }

    @Override
    public void openTorrentOpenOptions(Shell shell, String sPathOfFilesToOpen, String[] sFilesToOpen, Map<String, Object> options) {
        Boolean _defaultToStopped = (Boolean)options.get("defaultStopped");
        boolean defaultToStopped = _defaultToStopped != null ? _defaultToStopped : false;
        Boolean _hideErrors = (Boolean)options.get("hideErrors");
        boolean hideErrors = _hideErrors != null ? _hideErrors : false;
        TorrentOpenOptions torrentOptions = new TorrentOpenOptions();
        if (defaultToStopped) {
            torrentOptions.setStartMode(1);
        }
        torrentOptions.setHideErrors(hideErrors);
        if (sFilesToOpen == null) {
            new OpenTorrentWindow(shell);
        } else {
            Boolean _forceOpen = (Boolean)options.get("forceOpen");
            boolean forceOpen = _forceOpen != null ? _forceOpen : false;
            TorrentOpener.openTorrentsFromStrings(torrentOptions, shell, sPathOfFilesToOpen, sFilesToOpen, null, null, forceOpen);
        }
    }

    @Override
    public void openTorrentWindow() {
        new OpenTorrentWindow(Utils.findAnyShell());
    }

    @Override
    public void showCreateTagDialog(UIFunctions.TagReturner tagReturner) {
        TagUIUtilsV3.showCreateTagDialog(tagReturner);
    }

    @Override
    public TabbedMdiInterface createTabbedMDI(Composite parent, String id) {
        return new TabbedMDI(parent, id);
    }

    @Override
    public int adjustPXForDPI(int px) {
        return Utils.adjustPXForDPI(px);
    }
}

