/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.search;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCheckbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCombo;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.StandardButtonsArea;
import com.aelitis.azureus.util.JSONUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.PropertiesWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class SearchUtils {
    private static void exportAll() {
        final Shell shell = Utils.findAnyShell();
        shell.getDisplay().asyncExec(new AERunnable(){

            @Override
            public void runSupport() {
                FileDialog dialog = new FileDialog(shell, 139264);
                dialog.setFilterPath(TorrentOpener.getFilterPathData());
                dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                String path = TorrentOpener.setFilterPathData(dialog.open());
                if (path != null) {
                    String lc = path.toLowerCase();
                    if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                        path = path + ".vuze";
                    }
                    try {
                        MetaSearchManagerFactory.getSingleton().getMetaSearch().exportEngines(new File(path));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    public static void addMenus(Menu menu) {
        final Menu template_menu = new Menu(menu.getShell(), 4);
        MenuItem template_menu_item = new MenuItem(menu, 64);
        template_menu_item.setMenu(template_menu);
        Messages.setLanguageText(template_menu_item, "Search.menu.engines");
        template_menu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent e) {
                for (MenuItem mi : template_menu.getItems()) {
                    mi.dispose();
                }
                Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(true, false);
                Arrays.sort(engines, new Comparator<Engine>(){

                    @Override
                    public int compare(Engine o1, Engine o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                for (int i = 0; i < engines.length; ++i) {
                    final Engine engine = engines[i];
                    Menu engine_menu = new Menu(template_menu.getShell(), 4);
                    MenuItem engine_menu_item = new MenuItem(template_menu, 64);
                    engine_menu_item.setMenu(engine_menu);
                    engine_menu_item.setText(engine.getName());
                    MenuItem remove_item = new MenuItem(engine_menu, 8);
                    Messages.setLanguageText(remove_item, "Button.remove");
                    remove_item.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            engine.setSelectionState(3);
                        }
                    });
                }
            }
        });
        MenuBuildUtils.addChatMenu(menu, "label.chat", "Search Templates");
        MenuItem itemExport = new MenuItem(menu, 8);
        Messages.setLanguageText(itemExport, "search.export.all");
        itemExport.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SearchUtils.exportAll();
            }
        });
    }

    public static void addMenus(Menu menu, final Engine engine, boolean separator_required) {
        if (engine instanceof PluginEngine) {
            return;
        }
        if (separator_required) {
            new MenuItem(menu, 2);
        }
        MenuItem remove_item = new MenuItem(menu, 8);
        Messages.setLanguageText(remove_item, "Button.remove");
        Utils.setMenuItemImage(remove_item, "delete");
        remove_item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                engine.setSelectionState(3);
            }
        });
    }

    public static void addMenus(final MenuManager menuManager) {
        final org.gudy.azureus2.plugins.ui.menus.MenuItem template_menu = menuManager.addMenuItem("sidebar.Search", "Search.menu.engines");
        template_menu.setStyle(5);
        template_menu.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                template_menu.removeAllChildItems();
                Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(true, false);
                Arrays.sort(engines, new Comparator<Engine>(){

                    @Override
                    public int compare(Engine o1, Engine o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                for (int i = 0; i < engines.length; ++i) {
                    String cookies;
                    WebEngine we;
                    final Engine engine = engines[i];
                    org.gudy.azureus2.plugins.ui.menus.MenuItem engine_menu = menuManager.addMenuItem(template_menu, "!" + engine.getName() + "!");
                    engine_menu.setStyle(5);
                    org.gudy.azureus2.plugins.ui.menus.MenuItem mi = menuManager.addMenuItem(engine_menu, "MyTorrentsView.menu.exportmenu");
                    mi.addListener(new MenuItemListener(){

                        @Override
                        public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                            final Shell shell = Utils.findAnyShell();
                            shell.getDisplay().asyncExec(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    FileDialog dialog = new FileDialog(shell, 139264);
                                    dialog.setFilterPath(TorrentOpener.getFilterPathData());
                                    dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                                    dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                    dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                    String path = TorrentOpener.setFilterPathData(dialog.open());
                                    if (path != null) {
                                        String lc = path.toLowerCase();
                                        if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                                            path = path + ".vuze";
                                        }
                                        try {
                                            engine.exportToVuzeFile(new File(path));
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                            });
                        }
                    });
                    if (Constants.IS_CVS_VERSION) {
                        org.gudy.azureus2.plugins.ui.menus.MenuItem copy_mi = menuManager.addMenuItem(engine_menu, "ConfigView.copy.to.clipboard.tooltip");
                        copy_mi.addListener(new MenuItemListener(){

                            @Override
                            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                Shell shell = Utils.findAnyShell();
                                shell.getDisplay().asyncExec(new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        try {
                                            ClipboardCopy.copyToClipBoard(engine.exportToVuzeFile().exportToJSON());
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                });
                            }
                        });
                    }
                    if (engine instanceof WebEngine && (we = (WebEngine)engine).isNeedsAuth() && (cookies = we.getCookies()) != null && cookies.length() > 0) {
                        org.gudy.azureus2.plugins.ui.menus.MenuItem mi2 = menuManager.addMenuItem(engine_menu, "Subscription.menu.resetauth");
                        mi2.addListener(new MenuItemListener(){

                            @Override
                            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                we.setCookies(null);
                            }
                        });
                    }
                    if (engine_menu.getItems().length > 0) {
                        mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.sep");
                        mi.setStyle(4);
                    }
                    mi = menuManager.addMenuItem(engine_menu, "Button.remove");
                    mi.addListener(new MenuItemListener(){

                        @Override
                        public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                            engine.setSelectionState(3);
                        }
                    });
                    mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.sep2");
                    mi.setStyle(4);
                    mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.properties");
                    mi.addListener(new MenuItemListener(){

                        @Override
                        public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                            WebEngine web_engine;
                            String auth_str = String.valueOf(false);
                            String engine_str = engine.getNameEx();
                            if (engine instanceof WebEngine && (web_engine = (WebEngine)engine).isNeedsAuth()) {
                                auth_str = String.valueOf(true) + ": cookies=" + this.toString(web_engine.getRequiredCookies());
                            }
                            String[] keys = new String[]{"subs.prop.template", "subs.prop.auth"};
                            String[] values = new String[]{engine_str, auth_str};
                            new PropertiesWindow(engine.getName(), keys, values);
                        }

                        private String toString(String[] strs) {
                            String res = "";
                            for (int i = 0; i < strs.length; ++i) {
                                res = res + (i == 0 ? "" : ",") + strs[i];
                            }
                            return res;
                        }
                    });
                    if (engine_menu.getItems().length != 0) continue;
                    engine_menu.setEnabled(false);
                }
            }
        });
        org.gudy.azureus2.plugins.ui.menus.MenuItem chat_menu = menuManager.addMenuItem("sidebar.Search", "label.chat");
        MenuBuildUtils.addChatMenu(menuManager, chat_menu, new MenuBuildUtils.ChatKeyResolver(){

            @Override
            public String getChatKey(Object object) {
                return "Search Templates";
            }
        });
        org.gudy.azureus2.plugins.ui.menus.MenuItem export_menu = menuManager.addMenuItem("sidebar.Search", "search.export.all");
        export_menu.setStyle(1);
        export_menu.addListener(new MenuItemListener(){

            @Override
            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                SearchUtils.exportAll();
            }
        });
    }

    public static void showCreateSubscriptionDialog(final long engineID, final String searchTerm, final Map optionalFilters) {
        final SkinnedDialog dialog = new SkinnedDialog("skin3_dlg_create_search_subscription", "shell", 2144);
        SWTSkin skin = dialog.getSkin();
        final SWTSkinObjectTextbox tb = (SWTSkinObjectTextbox)skin.getSkinObject("sub-name");
        final SWTSkinObjectCheckbox cbShare = (SWTSkinObjectCheckbox)skin.getSkinObject("sub-share");
        final SWTSkinObjectCheckbox cbAutoDL = (SWTSkinObjectCheckbox)skin.getSkinObject("sub-autodl");
        SWTSkinObject soEngineArea = skin.getSkinObject("sub-engine-area");
        final SWTSkinObjectCombo soEngines = (SWTSkinObjectCombo)skin.getSkinObject("sub-engine");
        if (tb == null || cbShare == null || cbAutoDL == null) {
            return;
        }
        boolean hasEngineID = engineID >= 0L;
        soEngineArea.setVisible(!hasEngineID);
        final HashMap<Integer, Engine> mapEngines = new HashMap<Integer, Engine>();
        if (!hasEngineID) {
            Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(true, false);
            ArrayList<String> list = new ArrayList<String>();
            int pos = 0;
            for (Engine engine : engines) {
                mapEngines.put(pos++, engine);
                list.add(engine.getName());
            }
            soEngines.setList(list.toArray(new String[list.size()]));
        }
        cbShare.setChecked(COConfigurationManager.getBooleanParameter("sub.sharing.default.checked"));
        cbAutoDL.setChecked(COConfigurationManager.getBooleanParameter("sub.autodl.default.checked"));
        SWTSkinObject soButtonArea = skin.getSkinObject("bottom-area");
        if (soButtonArea instanceof SWTSkinObjectContainer) {
            StandardButtonsArea buttonsArea = new StandardButtonsArea(){

                @Override
                protected void clicked(int buttonValue) {
                    if (buttonValue == 32) {
                        String name = tb.getText().trim();
                        boolean isShared = cbShare.isChecked();
                        boolean autoDL = cbAutoDL.isChecked();
                        long realEngineID = engineID;
                        if (engineID <= 0L) {
                            int engineIndex = soEngines.getComboControl().getSelectionIndex();
                            if (engineIndex < 0) {
                                return;
                            }
                            realEngineID = ((Engine)mapEngines.get(engineIndex)).getId();
                        }
                        HashMap<String, Object> payload = new HashMap<String, Object>();
                        payload.put("engine_id", realEngineID);
                        payload.put("search_term", searchTerm);
                        HashMap<String, Object> mapSchedule = new HashMap<String, Object>();
                        mapSchedule.put("days", Collections.EMPTY_LIST);
                        mapSchedule.put("interval", 120);
                        payload.put("schedule", mapSchedule);
                        HashMap<String, Boolean> mapOptions = new HashMap<String, Boolean>();
                        mapOptions.put("auto_dl", autoDL);
                        payload.put("options", mapOptions);
                        HashMap mapFilters = new HashMap();
                        if (optionalFilters != null) {
                            mapFilters.putAll(optionalFilters);
                        }
                        payload.put("filters", mapFilters);
                        try {
                            Subscription subs = SubscriptionManagerFactory.getSingleton().create(name, isShared, JSONUtils.encodeToJSON(payload));
                            subs.getHistory().setDetails(true, autoDL);
                            subs.requestAttention();
                        }
                        catch (SubscriptionException e) {
                            // empty catch block
                        }
                    }
                    dialog.close();
                }
            };
            buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.add"), MessageText.getString("Button.cancel")});
            buttonsArea.setButtonVals(new Integer[]{32, 256});
            buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
        }
        dialog.open();
    }
}

