/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.search;

import com.aelitis.azureus.core.metasearch.MetaSearchManager;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class SearchUI {
    private static final String CONFIG_SECTION_ID = "Search";
    private UIManager ui_manager;

    public SearchUI() {
        final PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        this.ui_manager = default_pi.getUIManager();
        this.ui_manager.addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                if (!(instance instanceof UISWTInstance)) {
                    return;
                }
                Utilities utilities = default_pi.getUtilities();
                DelayedTask dt = utilities.createDelayedTask(new Runnable(){

                    @Override
                    public void run() {
                        Utils.execSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                SearchUI.this.delayedInit();
                            }
                        });
                    }
                });
                dt.queue();
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
    }

    private void delayedInit() {
        final MetaSearchManager manager = MetaSearchManagerFactory.getSingleton();
        if (manager == null) {
            return;
        }
        BasicPluginConfigModel configModel = this.ui_manager.createBasicPluginConfigModel("root", CONFIG_SECTION_ID);
        final BooleanParameter proxy_enable = configModel.addBooleanParameter2("search.proxy.enable", "search.proxy.enable", manager.getProxyRequestsEnabled());
        proxy_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                manager.setProxyRequestsEnabled(proxy_enable.getValue());
            }
        });
    }
}

