/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.search;

import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.search.SearchResultsTabArea;
import com.aelitis.azureus.ui.swt.search.SearchResultsTabAreaBase;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.util.UrlFilter;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.BrowserWrapper;
import org.gudy.azureus2.ui.swt.Utils;

public class SearchResultsTabAreaBrowser
implements SearchResultsTabAreaBase {
    private static boolean search_proxy_init_done;
    private static AEProxyFactory.PluginHTTPProxy search_proxy;
    private static boolean search_proxy_set;
    private static AESemaphore search_proxy_sem;
    private static List<SearchResultsTabAreaBrowser> pending;
    private final SearchResultsTabArea parent;
    private SWTSkinObjectBrowser browserSkinObject;
    private SearchResultsTabArea.SearchQuery sq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initProxy() {
        Class<SearchResultsTabArea> clazz = SearchResultsTabArea.class;
        synchronized (SearchResultsTabArea.class) {
            if (search_proxy_init_done) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            search_proxy_init_done = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            new AEThread2("ST_test"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList to_redo;
                    try {
                        String test_url = PlatformConfigMessenger.getWebSearchUrl().replaceAll("%s", "derp");
                        try {
                            boolean use_proxy;
                            URL url = new URL(test_url);
                            url = UrlUtils.setProtocol(url, "https");
                            url = UrlUtils.setPort(url, 443);
                            boolean bl = use_proxy = !COConfigurationManager.getStringParameter("browser.internal.proxy.id", "none").equals("none");
                            if (!use_proxy) {
                                Boolean looks_ok = AEProxyFactory.testPluginHTTPProxy(url, true);
                                boolean bl2 = use_proxy = looks_ok != null && looks_ok == false;
                            }
                            if (use_proxy) {
                                search_proxy = AEProxyFactory.getPluginHTTPProxy("search", url, true);
                                if (search_proxy != null) {
                                    UrlFilter.getInstance().addUrlWhitelist("https?://" + ((InetSocketAddress)search_proxy.getProxy().address()).getAddress().getHostAddress() + ":?[0-9]*/.*");
                                }
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        to_redo = null;
                        Class<SearchResultsTabArea> e = SearchResultsTabArea.class;
                    }
                    catch (Throwable throwable) {
                        ArrayList to_redo2 = null;
                        Class<SearchResultsTabArea> clazz = SearchResultsTabArea.class;
                        synchronized (SearchResultsTabArea.class) {
                            search_proxy_set = true;
                            to_redo2 = new ArrayList(pending);
                            pending.clear();
                            // ** MonitorExit[var8_12] (shouldn't be in output)
                            search_proxy_sem.releaseForever();
                            for (SearchResultsTabAreaBrowser area : to_redo2) {
                                try {
                                    SearchResultsTabArea.SearchQuery sq;
                                    try {
                                        area.browserSkinObject.setAutoReloadPending(false, search_proxy == null);
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                    if (search_proxy == null || (sq = area.sq) == null) continue;
                                    area.anotherSearch(sq);
                                }
                                catch (Throwable e) {}
                            }
                            throw throwable;
                        }
                    }
                    synchronized (SearchResultsTabArea.class) {
                        search_proxy_set = true;
                        to_redo = new ArrayList(pending);
                        pending.clear();
                        // ** MonitorExit[e] (shouldn't be in output)
                        search_proxy_sem.releaseForever();
                        for (SearchResultsTabAreaBrowser area : to_redo) {
                            try {
                                SearchResultsTabArea.SearchQuery sq;
                                try {
                                    area.browserSkinObject.setAutoReloadPending(false, search_proxy == null);
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                if (search_proxy == null || (sq = area.sq) == null) continue;
                                area.anotherSearch(sq);
                            }
                            catch (Throwable e) {}
                        }
                    }
                    {
                        return;
                    }
                }
            }.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AEProxyFactory.PluginHTTPProxy getSearchProxy(SearchResultsTabAreaBrowser area) {
        SearchResultsTabAreaBrowser.initProxy();
        boolean force_proxy = !COConfigurationManager.getStringParameter("browser.internal.proxy.id", "none").equals("none");
        search_proxy_sem.reserve(force_proxy ? 60000L : 2500L);
        Class<SearchResultsTabArea> clazz = SearchResultsTabArea.class;
        synchronized (SearchResultsTabArea.class) {
            if (search_proxy_set) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return search_proxy;
            }
            pending.add(area);
            try {
                area.browserSkinObject.setAutoReloadPending(true, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    protected SearchResultsTabAreaBrowser(SearchResultsTabArea _parent) {
        this.parent = _parent;
    }

    protected void init(SWTSkinObjectBrowser _browserSkinObject) {
        this.browserSkinObject = _browserSkinObject;
        this.browserSkinObject.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    SearchResultsTabAreaBrowser.this.browserSkinObject.removeListener(this);
                    SearchResultsTabAreaBrowser.this.createBrowseArea(SearchResultsTabAreaBrowser.this.browserSkinObject);
                }
                return null;
            }
        });
    }

    private void createBrowseArea(SWTSkinObjectBrowser browserSkinObject) {
        this.browserSkinObject = browserSkinObject;
        browserSkinObject.addListener(new BrowserContext.loadingListener(){

            @Override
            public void browserLoadingChanged(boolean loading, String url) {
                SearchResultsTabAreaBrowser.this.parent.setBusy(loading);
            }
        });
    }

    @Override
    public void anotherSearch(SearchResultsTabArea.SearchQuery sq) {
        this.sq = sq;
        String url = PlatformConfigMessenger.getWebSearchUrl().replaceAll("%s", UrlUtils.encode(sq.term));
        AEProxyFactory.PluginHTTPProxy proxy = SearchResultsTabAreaBrowser.getSearchProxy(this);
        if (proxy != null) {
            url = proxy.proxifyURL(url);
        }
        if (Utils.isThisThreadSWT()) {
            try {
                this.browserSkinObject.getBrowser().setText("");
                final BrowserWrapper browser = this.browserSkinObject.getBrowser();
                final boolean[] done = new boolean[]{false};
                browser.addLocationListener(new LocationListener(){

                    @Override
                    public void changing(LocationEvent event2) {
                    }

                    @Override
                    public void changed(LocationEvent event2) {
                        done[0] = true;
                        browser.removeLocationListener(this);
                    }
                });
                this.browserSkinObject.getBrowser().setUrl("about:blank");
                this.browserSkinObject.getBrowser().refresh();
                this.browserSkinObject.getBrowser().update();
                Display display = Utils.getDisplay();
                if (display != null) {
                    long until = SystemTime.getCurrentTime() + 300L;
                    while (!done[0] && until > SystemTime.getCurrentTime()) {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.browserSkinObject.setURL(url);
    }

    @Override
    public int getResultCount() {
        return 0;
    }

    @Override
    public void showView() {
    }

    @Override
    public void refreshView() {
    }

    @Override
    public void hideView() {
    }

    static {
        search_proxy_sem = new AESemaphore("sps");
        pending = new ArrayList<SearchResultsTabAreaBrowser>();
        COConfigurationManager.addParameterListener("browser.internal.proxy.id", new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String parameterName) {
                Class<SearchResultsTabArea> clazz = SearchResultsTabArea.class;
                synchronized (SearchResultsTabArea.class) {
                    if (!search_proxy_init_done) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    search_proxy_init_done = false;
                    search_proxy_set = false;
                    if (search_proxy != null) {
                        search_proxy.destroy();
                        search_proxy = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

