/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.search;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.search.SBC_SearchResultsView;
import com.aelitis.azureus.ui.swt.search.SearchResultsTabAreaBase;
import com.aelitis.azureus.ui.swt.search.SearchResultsTabAreaBrowser;
import com.aelitis.azureus.ui.swt.search.SearchUtils;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;

public class SearchResultsTabArea
extends SkinView
implements ViewTitleInfo {
    private boolean isBrowserView = COConfigurationManager.getBooleanParameter("Search View Is Web View", true);
    private boolean isViewSwitchHidden = COConfigurationManager.getBooleanParameter("Search View Switch Hidden", false);
    private SWTSkinObjectBrowser browserSkinObject;
    private SWTSkinObjectContainer nativeSkinObject;
    private SWTSkin skin;
    private MdiEntry mdi_entry;
    private MdiEntryVitalityImage vitalityImage;
    private boolean menu_added;
    private SearchQuery current_sq;
    private SearchQuery last_actual_sq;
    private SearchResultsTabAreaBase last_actual_sq_impl;
    private SearchResultsTabAreaBase activeImpl;
    private SearchResultsTabAreaBrowser browserImpl = new SearchResultsTabAreaBrowser(this);
    private SBC_SearchResultsView nativeImpl = new SBC_SearchResultsView(this);
    private SWTSkinObject soButtonWeb;
    private SWTSkinObject soButtonMeta;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        MultipleDocumentInterfaceSWT mdi;
        this.skin = skinObject.getSkin();
        SWTSkinObjectContainer controlArea = (SWTSkinObjectContainer)this.skin.getSkinObject("searchresultstop", skinObject);
        if (controlArea != null) {
            if (this.isViewSwitchHidden) {
                controlArea.setVisible(false);
            } else {
                Composite control_area = controlArea.getComposite();
                this.soButtonWeb = this.skin.getSkinObject("searchresults-button-web", controlArea);
                this.soButtonMeta = this.skin.getSkinObject("searchresults-button-meta", controlArea);
                SWTSkinButtonUtility btnWeb = new SWTSkinButtonUtility(this.soButtonWeb);
                btnWeb.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    @Override
                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        SearchResultsTabArea.this.isBrowserView = true;
                        COConfigurationManager.setParameter("Search View Is Web View", SearchResultsTabArea.this.isBrowserView);
                        SearchResultsTabArea.this.selectView(skinObject);
                    }
                });
                SWTSkinButtonUtility btnMeta = new SWTSkinButtonUtility(this.soButtonMeta);
                btnMeta.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    @Override
                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        SearchResultsTabArea.this.isBrowserView = false;
                        COConfigurationManager.setParameter("Search View Is Web View", SearchResultsTabArea.this.isBrowserView);
                        SearchResultsTabArea.this.selectView(skinObject);
                    }
                });
            }
        }
        if ((mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT()) != null) {
            this.mdi_entry = mdi.getEntryBySkinView(this);
            if (this.mdi_entry != null) {
                this.mdi_entry.setViewTitleInfo(this);
                this.vitalityImage = this.mdi_entry.addVitalityImage("image.sidebar.vitality.dots");
                if (this.vitalityImage != null) {
                    this.vitalityImage.setVisible(false);
                }
            }
        }
        this.browserSkinObject = (SWTSkinObjectBrowser)this.skin.getSkinObject("web-search-results", skinObject);
        this.browserImpl.init(this.browserSkinObject);
        this.nativeSkinObject = (SWTSkinObjectContainer)this.skin.getSkinObject("meta-search-results", skinObject);
        this.nativeImpl.skinObjectInitialShow(skinObject, params);
        this.selectView(skinObject);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(final AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        SearchResultsTabArea.this.initCoreStuff(core);
                    }
                });
            }
        });
        if (this.current_sq != null) {
            this.anotherSearch(this.current_sq);
        }
        return null;
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        if (this.activeImpl != null) {
            this.activeImpl.refreshView();
        }
        return super.skinObjectShown(skinObject, params);
    }

    private void selectView(SWTSkinObject parent) {
        SearchResultsTabAreaBase newImpl;
        SearchResultsTabAreaBase searchResultsTabAreaBase = newImpl = this.isBrowserView ? this.browserImpl : this.nativeImpl;
        if (newImpl == this.activeImpl) {
            return;
        }
        Control[] kids = this.nativeSkinObject.getControl().getParent().getChildren();
        Control visible_parent = this.isBrowserView ? this.browserSkinObject.getControl() : this.nativeSkinObject.getControl();
        for (Control kid : kids) {
            kid.setVisible(kid == visible_parent);
        }
        this.browserSkinObject.setVisible(this.isBrowserView);
        this.nativeSkinObject.setVisible(!this.isBrowserView);
        if (this.soButtonWeb != null) {
            this.soButtonWeb.switchSuffix(this.isBrowserView ? "-selected" : "");
        }
        if (this.soButtonMeta != null) {
            this.soButtonMeta.switchSuffix(this.isBrowserView ? "" : "-selected");
        }
        parent.relayout();
        if (this.activeImpl != null) {
            this.activeImpl.hideView();
        }
        this.activeImpl = newImpl;
        this.activeImpl.showView();
        if (this.current_sq != null) {
            this.anotherSearch(this.current_sq);
        }
    }

    private void initCoreStuff(AzureusCore core) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        if (!this.menu_added) {
            this.menu_added = true;
            SearchUtils.addMenus(menuManager);
        }
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        if (params instanceof SearchQuery) {
            this.anotherSearch((SearchQuery)params);
        }
        return null;
    }

    public void anotherSearch(String searchText, boolean toSubscribe) {
        this.anotherSearch(new SearchQuery(searchText, toSubscribe));
    }

    public void anotherSearch(SearchQuery another_sq) {
        this.current_sq = another_sq;
        if (this.activeImpl != null) {
            if (this.last_actual_sq != null && this.last_actual_sq.term.equals(this.current_sq.term) && this.last_actual_sq.toSubscribe == this.current_sq.toSubscribe && this.last_actual_sq_impl == this.activeImpl) {
                return;
            }
            this.last_actual_sq = this.current_sq;
            this.last_actual_sq_impl = this.activeImpl;
            this.activeImpl.anotherSearch(this.current_sq);
            ViewTitleInfoManager.refreshTitleInfo(this);
        }
    }

    public SearchQuery getCurrentSearch() {
        return this.current_sq;
    }

    @Override
    public Object getTitleInfoProperty(int pid) {
        int results;
        SearchQuery sq = this.current_sq;
        SearchResultsTabAreaBase impl = this.activeImpl;
        if (pid == 5) {
            if (sq != null) {
                return sq.term;
            }
        } else if (pid == 0 && impl != null && (results = impl.getResultCount()) >= 0) {
            return String.valueOf(results);
        }
        return null;
    }

    protected void setBusy(boolean busy) {
        if (this.vitalityImage != null) {
            this.vitalityImage.setVisible(busy);
        }
    }

    protected void resultsFound() {
        ViewTitleInfoManager.refreshTitleInfo(this);
    }

    public static class SearchQuery {
        public String term;
        public boolean toSubscribe;

        public SearchQuery(String term, boolean toSubscribe) {
            this.term = term;
            this.toSubscribe = toSubscribe;
        }
    }
}

