/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.player;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.player.PlayerInstallerListener;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;

public class PlayerInstaller {
    private PlayerInstallerListener listener;
    private PluginInstaller installer;
    private volatile UpdateCheckInstance instance;
    private boolean cancelled;

    public void setListener(PlayerInstallerListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        UpdateCheckInstance to_cancel = null;
        PlayerInstaller playerInstaller = this;
        synchronized (playerInstaller) {
            this.cancelled = true;
            to_cancel = this.instance;
        }
        if (to_cancel != null) {
            to_cancel.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install() {
        try {
            boolean kill_it;
            this.installer = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInstaller();
            StandardPlugin sp = this.installer.getStandardPlugin("azemp");
            HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
            properties.put(1, 3);
            properties.put(3, true);
            final AESemaphore sem = new AESemaphore("emp install");
            final boolean[] result = new boolean[1];
            this.instance = this.installer.install(new InstallablePlugin[]{sp}, false, properties, new PluginInstallationListener(){

                @Override
                public void completed() {
                    result[0] = true;
                    if (PlayerInstaller.this.listener != null) {
                        PlayerInstaller.this.listener.finished();
                    }
                    sem.release();
                }

                @Override
                public void cancelled() {
                    result[0] = false;
                    if (PlayerInstaller.this.listener != null) {
                        PlayerInstaller.this.listener.finished();
                    }
                    sem.release();
                }

                @Override
                public void failed(PluginException e) {
                    result[0] = false;
                    if (PlayerInstaller.this.listener != null) {
                        PlayerInstaller.this.listener.finished();
                    }
                    sem.release();
                }
            });
            PlayerInstaller playerInstaller = this;
            synchronized (playerInstaller) {
                kill_it = this.cancelled;
            }
            if (kill_it) {
                this.instance.cancel();
                return false;
            }
            this.instance.addListener(new UpdateCheckInstanceListener(){

                @Override
                public void cancelled(UpdateCheckInstance instance) {
                }

                @Override
                public void complete(UpdateCheckInstance instance) {
                    Update[] updates;
                    for (Update update : updates = instance.getUpdates()) {
                        ResourceDownloader[] rds;
                        for (ResourceDownloader rd : rds = update.getDownloaders()) {
                            rd.addListener(new ResourceDownloaderAdapter(){

                                @Override
                                public void reportActivity(ResourceDownloader downloader, String activity) {
                                }

                                @Override
                                public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
                                    if (PlayerInstaller.this.listener != null) {
                                        PlayerInstaller.this.listener.progress(percentage);
                                    }
                                }
                            });
                        }
                    }
                }
            });
            sem.reserve();
            return result[0];
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

