/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiSWTMenuHackListener;
import com.aelitis.azureus.ui.swt.mdi.TabbedMDI;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.util.MapUtils;
import java.util.HashMap;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.ObfusticateTab;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListenerEx;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventCancelledException;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;

public class TabbedEntry
extends BaseMdiEntry
implements DisposeListener {
    private static final String SO_ID_ENTRY_WRAPPER = "mdi.content.item";
    private CTabItem swtItem;
    private SWTSkin skin;
    private boolean showonSWTItemSet;
    private boolean buildonSWTItemSet;
    private static long uniqueNumber = 0L;

    public TabbedEntry(TabbedMDI mdi, SWTSkin skin, String id, String parentViewID) {
        super(mdi, id, parentViewID);
        this.skin = skin;
    }

    public boolean canBuildStandAlone() {
        String skinRef = this.getSkinRef();
        if (skinRef != null) {
            return true;
        }
        UISWTViewEventListener event_listener = this.getEventListener();
        return event_listener instanceof UISWTViewCoreEventListenerEx && ((UISWTViewCoreEventListenerEx)event_listener).isCloneable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWTSkinObjectContainer buildStandAlone(SWTSkinObjectContainer soParent) {
        Control control = null;
        Composite parent = soParent.getComposite();
        String skinRef = this.getSkinRef();
        if (skinRef != null) {
            Shell shell = parent.getShell();
            Cursor cursor = shell.getCursor();
            try {
                shell.setCursor(shell.getDisplay().getSystemCursor(1));
                SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiContents." + uniqueNumber++, SO_ID_ENTRY_WRAPPER, soParent, null);
                SWTSkinObject skinObject = this.skin.createSkinObject(this.id, skinRef, soContents, this.getDatasourceCore());
                control = skinObject.getControl();
                control.setLayoutData(Utils.getFilledFormData());
                control.getParent().layout(true, true);
                soContents.setVisible(true);
                SWTSkinObjectContainer sWTSkinObjectContainer = soContents;
                return sWTSkinObjectContainer;
            }
            finally {
                shell.setCursor(cursor);
            }
        }
        UISWTViewEventListener event_listener = this.getEventListener();
        if (event_listener instanceof UISWTViewCoreEventListenerEx && ((UISWTViewCoreEventListenerEx)event_listener).isCloneable()) {
            final UISWTViewImpl view = new UISWTViewImpl(this.getParentID(), this.id, true);
            try {
                view.setEventListener(((UISWTViewCoreEventListenerEx)event_listener).getClone(), false);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            view.setDatasource(this.datasource);
            try {
                SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiIView." + uniqueNumber++, SO_ID_ENTRY_WRAPPER, soParent);
                parent.setBackgroundMode(0);
                final Composite viewComposite = soContents.getComposite();
                boolean doGridLayout = true;
                if (this.getControlType() == 257) {
                    doGridLayout = false;
                }
                if (doGridLayout) {
                    GridLayout gridLayout = new GridLayout();
                    gridLayout.marginWidth = 0;
                    gridLayout.marginHeight = 0;
                    gridLayout.verticalSpacing = 0;
                    gridLayout.horizontalSpacing = 0;
                    viewComposite.setLayout(gridLayout);
                    viewComposite.setLayoutData(Utils.getFilledFormData());
                }
                view.setPluginSkinObject(soContents);
                view.initialize(viewComposite);
                Composite iviewComposite = view.getComposite();
                control = iviewComposite;
                if (doGridLayout) {
                    Object existingLayoutData = iviewComposite.getLayoutData();
                    Object existingParentLayoutData = iviewComposite.getParent().getLayoutData();
                    if (existingLayoutData == null || !(existingLayoutData instanceof GridData) && existingParentLayoutData instanceof GridLayout) {
                        GridData gridData = new GridData(1808);
                        iviewComposite.setLayoutData(gridData);
                    }
                }
                parent.layout(true, true);
                final UIUpdater updater = UIFunctionsManager.getUIFunctions().getUIUpdater();
                updater.addUpdater(new UIUpdatable(){

                    @Override
                    public void updateUI() {
                        if (viewComposite.isDisposed()) {
                            updater.removeUpdater(this);
                        } else {
                            view.triggerEvent(5, null);
                        }
                    }

                    @Override
                    public String getUpdateUIName() {
                        return "popout";
                    }
                });
                soContents.setVisible(true);
                view.triggerEvent(3, null);
                return soContents;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return null;
    }

    @Override
    public void build() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                TabbedEntry.this.swt_build();
                TabbedEntry.super.build();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swt_build() {
        if (this.swtItem == null) {
            this.buildonSWTItemSet = true;
            return true;
        }
        this.buildonSWTItemSet = false;
        Control control = this.swtItem.getControl();
        if (control == null || control.isDisposed()) {
            CTabFolder parent = this.swtItem.getParent();
            SWTSkinObject soParent = (SWTSkinObject)parent.getData("SkinObject");
            String skinRef = this.getSkinRef();
            if (skinRef != null) {
                Shell shell = parent.getShell();
                Cursor cursor = shell.getCursor();
                try {
                    shell.setCursor(shell.getDisplay().getSystemCursor(1));
                    SWTSkinObject skinObject = this.skin.createSkinObject(this.id, skinRef, soParent, this.getDatasourceCore());
                    control = skinObject.getControl();
                    control.setLayoutData(Utils.getFilledFormData());
                    control.getParent().layout(true);
                    CTabItem oldSelection = this.swtItem.getParent().getSelection();
                    this.swtItem.getParent().setSelection(this.swtItem);
                    this.swtItem.setControl(control);
                    if (oldSelection != null) {
                        this.swtItem.getParent().setSelection(oldSelection);
                    }
                    this.setPluginSkinObject(skinObject);
                    this.setSkinObjectMaster(skinObject);
                    this.initialize((Composite)control);
                }
                finally {
                    shell.setCursor(cursor);
                }
            }
            try {
                SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiIView." + uniqueNumber++, SO_ID_ENTRY_WRAPPER, soParent);
                parent.setBackgroundMode(0);
                Composite viewComposite = soContents.getComposite();
                boolean doGridLayout = true;
                if (this.getControlType() == 257) {
                    doGridLayout = false;
                }
                if (doGridLayout) {
                    GridLayout gridLayout = new GridLayout();
                    gridLayout.marginWidth = 0;
                    gridLayout.marginHeight = 0;
                    gridLayout.verticalSpacing = 0;
                    gridLayout.horizontalSpacing = 0;
                    viewComposite.setLayout(gridLayout);
                    viewComposite.setLayoutData(Utils.getFilledFormData());
                }
                this.setPluginSkinObject(soContents);
                this.initialize(viewComposite);
                Composite iviewComposite = this.getComposite();
                control = iviewComposite;
                if (doGridLayout) {
                    Object existingLayoutData = iviewComposite.getLayoutData();
                    Object existingParentLayoutData = iviewComposite.getParent().getLayoutData();
                    if (existingLayoutData == null || !(existingLayoutData instanceof GridData) && existingParentLayoutData instanceof GridLayout) {
                        GridData gridData = new GridData(1808);
                        iviewComposite.setLayoutData(gridData);
                    }
                }
                CTabItem oldSelection = this.swtItem.getParent().getSelection();
                this.swtItem.getParent().setSelection(this.swtItem);
                this.swtItem.setControl(viewComposite);
                if (oldSelection != null) {
                    this.swtItem.getParent().setSelection(oldSelection);
                }
                this.setSkinObjectMaster(soContents);
            }
            catch (Exception e) {
                Debug.out("Error creating sidebar content area for " + this.id, e);
                try {
                    this.setEventListener(null, false);
                }
                catch (UISWTViewEventCancelledException e1) {
                    // empty catch block
                }
                this.close(true);
            }
            if (control != null && !control.isDisposed()) {
                control.setData("BaseMDIEntry", this);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void show() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                TabbedEntry.this.swt_show();
            }
        });
    }

    private void swt_show() {
        if (this.swtItem == null) {
            this.showonSWTItemSet = true;
            return;
        }
        this.showonSWTItemSet = false;
        if (!this.swt_build()) {
            return;
        }
        this.triggerOpenListeners();
        if (this.swtItem.getParent().getSelection() != this.swtItem) {
            this.swtItem.getParent().setSelection(this.swtItem);
        }
        super.show();
    }

    @Override
    public MdiEntryVitalityImage addVitalityImage(String imageID) {
        return null;
    }

    @Override
    public boolean isCloseable() {
        return ((TabbedMDI)this.getMDI()).isMainMDI ? true : super.isCloseable();
    }

    @Override
    public void setCloseable(boolean closeable) {
        if (((TabbedMDI)this.getMDI()).isMainMDI) {
            closeable = true;
        }
        super.setCloseable(closeable);
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TabbedEntry.this.swtItem == null || TabbedEntry.this.swtItem.isDisposed()) {
                    return;
                }
                TabbedEntry.this.swtItem.setShowClose(TabbedEntry.this.isCloseable());
            }
        });
    }

    public void setSwtItem(CTabItem swtItem) {
        this.swtItem = swtItem;
        if (swtItem == null) {
            this.setDisposed(true);
            return;
        }
        this.setDisposed(false);
        swtItem.addDisposeListener(this);
        String title = this.getTitle();
        if (title != null) {
            swtItem.setText(this.escapeAccelerators(title));
        }
        this.updateLeftImage();
        swtItem.setShowClose(this.isCloseable());
        if (this.buildonSWTItemSet) {
            this.build();
        }
        if (this.showonSWTItemSet) {
            this.show();
        }
    }

    public Item getSwtItem() {
        return this.swtItem;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.swtItem != null) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (TabbedEntry.this.swtItem == null || TabbedEntry.this.swtItem.isDisposed()) {
                        return;
                    }
                    TabbedEntry.this.swtItem.setText(TabbedEntry.this.escapeAccelerators(TabbedEntry.this.getTitle()));
                }
            });
        }
    }

    @Override
    public MdiEntryVitalityImage[] getVitalityImages() {
        return new MdiEntryVitalityImage[0];
    }

    @Override
    public boolean close(boolean forceClose) {
        if (!super.close(forceClose)) {
            return false;
        }
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                if (TabbedEntry.this.swtItem != null && !TabbedEntry.this.swtItem.isDisposed()) {
                    TabbedEntry.this.swtItem.dispose();
                    TabbedEntry.this.swtItem = null;
                }
            }
        });
        return true;
    }

    @Override
    public void redraw() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TabbedEntry.this.swtItem == null || TabbedEntry.this.swtItem.isDisposed()) {
                    return;
                }
                TabbedEntry.this.swtItem.getParent().notifyListeners(11, new Event());
                TabbedEntry.this.swtItem.getParent().redraw();
            }
        });
    }

    @Override
    public void setImageLeftID(String id) {
        super.setImageLeftID(id);
        this.updateLeftImage();
    }

    @Override
    public void setImageLeft(Image imageLeft) {
        super.setImageLeft(imageLeft);
        this.updateLeftImage();
    }

    private void updateLeftImage() {
        if (this.swtItem == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TabbedEntry.this.swtItem == null || TabbedEntry.this.swtItem.isDisposed()) {
                    return;
                }
                Image image = TabbedEntry.this.getImageLeft(null);
                TabbedEntry.this.swtItem.setImage(image);
            }
        });
    }

    @Override
    public void widgetDisposed(DisposeEvent e) {
        this.setSwtItem(null);
        this.triggerCloseListeners(!SWTThread.getInstance().isTerminated());
        try {
            this.setEventListener(null, false);
        }
        catch (UISWTViewEventCancelledException e1) {
            // empty catch block
        }
        SWTSkinObject so = this.getSkinObject();
        if (so != null) {
            this.setSkinObjectMaster(null);
            so.getSkin().removeSkinObject(so);
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTThread.getInstance().isTerminated()) {
                    return;
                }
                TabbedEntry.this.mdi.removeItem(TabbedEntry.this);
                TabbedEntry.this.mdi.removeEntryAutoOpen(TabbedEntry.this.id);
            }
        });
    }

    private String escapeAccelerators(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("&", "&&");
    }

    @Override
    public void expandTo() {
    }

    @Override
    public void viewTitleInfoRefresh(ViewTitleInfo titleInfoToRefresh) {
        super.viewTitleInfoRefresh(titleInfoToRefresh);
        if (titleInfoToRefresh == null || this.viewTitleInfo != titleInfoToRefresh) {
            return;
        }
        if (this.isDisposed()) {
            return;
        }
        String newText = (String)this.viewTitleInfo.getTitleInfoProperty(5);
        if (newText != null) {
            this.setTitle(newText);
        } else {
            String titleID = this.getTitleID();
            if (titleID != null) {
                this.setTitleID(titleID);
            }
        }
        this.redraw();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void setSelectable(boolean selectable) {
    }

    @Override
    public void addListener(MdiSWTMenuHackListener l) {
    }

    @Override
    public void removeListener(MdiSWTMenuHackListener l) {
    }

    @Override
    public void setParentID(String id) {
    }

    @Override
    public String getParentID() {
        return null;
    }

    @Override
    public Image obfusticatedImage(Image image) {
        Rectangle bounds;
        Rectangle rectangle = bounds = this.swtItem == null ? null : this.swtItem.getBounds();
        if (bounds != null) {
            boolean isActive = this.swtItem.getParent().getSelection() == this.swtItem;
            boolean isHeaderVisible = this.swtItem.isShowing();
            Point location = Utils.getLocationRelativeToShell(this.swtItem.getParent());
            bounds.x += location.x;
            bounds.y += location.y;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("image", image);
            map.put("obfuscateTitle", false);
            if (isActive) {
                this.triggerEvent(9, map);
                if (this.viewTitleInfo instanceof ObfusticateImage) {
                    ((ObfusticateImage)((Object)this.viewTitleInfo)).obfusticatedImage(image);
                }
            }
            if (isHeaderVisible) {
                String header;
                if (this.viewTitleInfo instanceof ObfusticateTab && (header = ((ObfusticateTab)((Object)this.viewTitleInfo)).getObfusticatedHeader()) != null) {
                    UIDebugGenerator.obfusticateArea(image, bounds, header);
                }
                if (MapUtils.getMapBoolean(map, "obfuscateTitle", false)) {
                    UIDebugGenerator.obfusticateArea(image, bounds);
                }
            }
        }
        return image;
    }
}

