/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener2;
import com.aelitis.azureus.ui.mdi.MdiEntryLoadedListener;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MdiSWTMenuHackListener;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.MapUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionHolder;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;

public abstract class BaseMDI
extends SkinView
implements MultipleDocumentInterfaceSWT,
UIUpdatable {
    protected MdiEntrySWT currentEntry;
    private Map<String, MdiEntryCreationListener> mapIdToCreationListener = new LightHashMap<String, MdiEntryCreationListener>();
    private Map<String, MdiEntryCreationListener2> mapIdToCreationListener2 = new LightHashMap<String, MdiEntryCreationListener2>();
    private Map<String, MdiEntry> mapIdToEntry = new LinkedHashMap<String, MdiEntry>(8);
    private List<MdiListener> listeners = new ArrayList<MdiListener>();
    private List<MdiEntryLoadedListener> listLoadListeners = new ArrayList<MdiEntryLoadedListener>();
    private List<MdiSWTMenuHackListener> listMenuHackListners;
    private LinkedHashMap<String, Object> mapAutoOpen = new LinkedHashMap();
    private String[] preferredOrder;
    private boolean mapAutoOpenLoaded = false;
    private String closeableConfigFile = "sidebarauto.config";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiListener l) {
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(l)) {
                return;
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiListener l) {
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryLoadedListener l) {
        MdiEntry[] entries;
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            if (this.listLoadListeners.contains(l)) {
                return;
            }
            this.listLoadListeners.add(l);
        }
        for (MdiEntry entry : entries = this.getEntries()) {
            if (!entry.isAdded()) continue;
            l.mdiEntryLoaded(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryLoadedListener l) {
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            this.listLoadListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerSelectionListener(MdiEntry newEntry, MdiEntry oldEntry) {
        MdiListener[] array;
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            array = this.listeners.toArray(new MdiListener[0]);
        }
        for (MdiListener l : array) {
            try {
                l.mdiEntrySelected(newEntry, oldEntry);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        this.itemSelected(newEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerEntryLoadedListeners(MdiEntry entry) {
        MdiEntryLoadedListener[] array;
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            array = this.listLoadListeners.toArray(new MdiEntryLoadedListener[0]);
        }
        for (MdiEntryLoadedListener l : array) {
            try {
                l.mdiEntryLoaded(entry);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void closeEntry(String id) {
        MdiEntry entry = this.getEntry(id);
        if (entry != null) {
            entry.close(false);
        } else {
            this.removeEntryAutoOpen(id);
        }
    }

    @Override
    public final MdiEntry createEntryFromEventListener(String parentID, UISWTViewEventListener l, String id, boolean closeable, Object datasource, String preferedAfterID) {
        return this.createEntryFromEventListener(parentID, null, l, id, closeable, datasource, preferedAfterID);
    }

    @Override
    public abstract MdiEntry createEntryFromEventListener(String var1, String var2, UISWTViewEventListener var3, String var4, boolean var5, Object var6, String var7);

    @Override
    public abstract MdiEntry createEntryFromSkinRef(String var1, String var2, String var3, String var4, ViewTitleInfo var5, Object var6, boolean var7, String var8);

    @Override
    public MdiEntry createEntryFromEventListener(String parentID, Class<? extends UISWTViewEventListener> cla, String id, boolean closeable, Object data, String preferedAfterID) {
        MdiEntry entry;
        int i;
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return null;
        }
        if (id == null && (i = (id = cla.getName()).lastIndexOf(46)) > 0) {
            id = id.substring(i + 1);
        }
        if ((entry = mdi.getEntry(id)) != null) {
            if (data != null) {
                entry.setDatasource(data);
            }
            return entry;
        }
        UISWTViewEventListener l = null;
        if (data != null) {
            try {
                Constructor<? extends UISWTViewEventListener> constructor = cla.getConstructor(data.getClass());
                l = constructor.newInstance(data);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (l == null) {
                l = cla.newInstance();
            }
            return mdi.createEntryFromEventListener(parentID, l, id, closeable, data, preferedAfterID);
        }
        catch (Exception e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public MdiEntry getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public MdiEntrySWT getCurrentEntrySWT() {
        return this.currentEntry;
    }

    @Override
    public MdiEntry[] getEntries() {
        return this.getEntries(new MdiEntry[0]);
    }

    public MdiEntrySWT[] getEntriesSWT() {
        return (MdiEntrySWT[])this.getEntries(new MdiEntrySWT[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends MdiEntry> T[] getEntries(T[] array) {
        Map<String, MdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            return (MdiEntry[])this.mapIdToEntry.values().toArray(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MdiEntry getEntry(String id) {
        if ("browse".equalsIgnoreCase(id)) {
            id = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        }
        Map<String, MdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntry entry = this.mapIdToEntry.get(id);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MdiEntrySWT getEntrySWT(String id) {
        if ("browse".equalsIgnoreCase(id)) {
            id = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        }
        Map<String, MdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntrySWT entry = (MdiEntrySWT)this.mapIdToEntry.get(id);
            return entry;
        }
    }

    @Override
    public MdiEntry getEntryBySkinView(Object skinView) {
        SWTSkinObject so = ((SkinView)skinView).getMainSkinObject();
        BaseMdiEntry[] sideBarEntries = (BaseMdiEntry[])this.getEntries(new BaseMdiEntry[0]);
        for (int i = 0; i < sideBarEntries.length; ++i) {
            SWTSkinObject entrySOParent;
            BaseMdiEntry entry = sideBarEntries[i];
            SWTSkinObject entrySO = entry.getSkinObject();
            SWTSkinObject sWTSkinObject = entrySOParent = entrySO == null ? entrySO : entrySO.getParent();
            if (entrySO != so && entrySO != so.getParent() && entrySOParent != so) continue;
            return entry;
        }
        return null;
    }

    @Override
    public UISWTViewCore getCoreViewFromID(String id) {
        if (id == null) {
            return null;
        }
        MdiEntrySWT entry = this.getEntrySWT(id);
        if (entry instanceof UISWTViewCore) {
            return entry;
        }
        return null;
    }

    @Override
    public String getUpdateUIName() {
        if (this.currentEntry == null) {
            return "MDI";
        }
        return this.currentEntry.getId();
    }

    @Override
    public void registerEntry(String id, MdiEntryCreationListener2 l) {
        if (this.mapIdToCreationListener.containsKey(id)) {
            System.err.println("Warning: MDIEntry " + id + " Creation Listener being registered twice. " + Debug.getCompressedStackTrace());
        }
        this.mapIdToCreationListener2.put(id, l);
        this.createIfAutoOpen(id);
    }

    @Override
    public void deregisterEntry(String id, MdiEntryCreationListener2 l) {
        MdiEntryCreationListener2 l2 = this.mapIdToCreationListener2.get(id);
        if (l == l2) {
            this.mapIdToCreationListener2.remove(id);
        }
    }

    private boolean createIfAutoOpen(String id) {
        String[] autoOpenIDs;
        Object o = this.mapAutoOpen.get(id);
        if (o instanceof Map) {
            Map autoOpenMap = (Map)o;
            return this.createEntryByCreationListener(id, autoOpenMap.get("datasource"), autoOpenMap) != null;
        }
        boolean created = false;
        for (String autoOpenID : autoOpenIDs = this.mapAutoOpen.keySet().toArray(new String[0])) {
            if (!Pattern.matches(id, autoOpenID)) continue;
            Map autoOpenMap = (Map)this.mapAutoOpen.get(autoOpenID);
            created |= this.createEntryByCreationListener(autoOpenID, autoOpenMap.get("datasource"), autoOpenMap) != null;
        }
        return created;
    }

    protected MdiEntry createEntryByCreationListener(String id, Object ds, Map<?, ?> autoOpenMap) {
        MdiEntryCreationListener mdiEntryCreationListener = null;
        for (String key : this.mapIdToCreationListener.keySet()) {
            if (!Pattern.matches(key, id)) continue;
            mdiEntryCreationListener = this.mapIdToCreationListener.get(key);
            break;
        }
        if (mdiEntryCreationListener != null) {
            try {
                MdiEntry mdiEntry = mdiEntryCreationListener.createMDiEntry(id);
                if (mdiEntry != null && ds != null) {
                    mdiEntry.setDatasource(ds);
                }
                return mdiEntry;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        MdiEntryCreationListener2 mdiEntryCreationListener2 = null;
        for (String key : this.mapIdToCreationListener2.keySet()) {
            if (!Pattern.matches(key, id)) continue;
            mdiEntryCreationListener2 = this.mapIdToCreationListener2.get(key);
            break;
        }
        if (mdiEntryCreationListener2 != null) {
            try {
                MdiEntry mdiEntry = mdiEntryCreationListener2.createMDiEntry(this, id, ds, autoOpenMap);
                if (mdiEntry == null) {
                    this.removeEntryAutoOpen(id);
                }
                return mdiEntry;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        this.setEntryAutoOpen(id, ds);
        return null;
    }

    @Override
    public void registerEntry(String id, MdiEntryCreationListener l) {
        if (this.mapIdToCreationListener.containsKey(id) || this.mapIdToCreationListener2.containsKey(id)) {
            System.err.println("Warning: MDIEntry " + id + " Creation Listener being registered twice. " + Debug.getCompressedStackTrace());
        }
        this.mapIdToCreationListener.put(id, l);
        this.createIfAutoOpen(id);
    }

    @Override
    public void deregisterEntry(String id, MdiEntryCreationListener l) {
        MdiEntryCreationListener l2 = this.mapIdToCreationListener.get(id);
        if (l == l2) {
            this.mapIdToCreationListener.remove(id);
        }
    }

    @Override
    public boolean showEntryByID(String id) {
        return this.loadEntryByID(id, true);
    }

    @Override
    public boolean showEntryByID(String id, Object datasource) {
        return this.loadEntryByID(id, true, false, datasource);
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        UIManager ui_manager = PluginInitializer.getDefaultInterface().getUIManager();
        ui_manager.addUIListener(new UIManagerListener(){

            @Override
            public void UIDetached(UIInstance instance) {
            }

            @Override
            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    final AESemaphore wait_sem = new AESemaphore("SideBar:wait");
                    Utils.execSWTThread(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void runSupport() {
                            try {
                                try {
                                    BaseMDI.this.loadCloseables();
                                }
                                catch (Throwable t) {
                                    Debug.out(t);
                                }
                                BaseMDI.this.setupPluginViews();
                            }
                            finally {
                                wait_sem.release();
                            }
                        }
                    });
                    if (!wait_sem.reserve(10000L)) {
                        Debug.out("eh?");
                    }
                }
            }
        });
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        MdiEntry entry = this.getCurrentEntry();
        if (entry != null) {
            COConfigurationManager.setParameter("v3.StartTab", entry.getId());
            String ds = entry.getExportableDatasource();
            COConfigurationManager.setParameter("v3.StartTab.ds", ds == null ? null : ds.toString());
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public void updateUI() {
        MdiEntry currentEntry = this.getCurrentEntry();
        if (currentEntry != null) {
            currentEntry.updateUI();
        }
    }

    @Override
    public boolean loadEntryByID(String id, boolean activate) {
        return this.loadEntryByID(id, activate, false, null);
    }

    @Override
    public boolean loadEntryByID(String id, boolean activate, boolean onlyLoadOnce, Object datasource) {
        if (id == null) {
            return false;
        }
        boolean loadedOnce = this.wasEntryLoadedOnce(id);
        if (loadedOnce && onlyLoadOnce) {
            return false;
        }
        MdiEntry entry = this.getEntry(id);
        if (entry != null) {
            if (datasource != null) {
                entry.setDatasource(datasource);
            }
            if (activate) {
                this.showEntry(entry);
            }
            return true;
        }
        MdiEntry mdiEntry = this.createEntryByCreationListener(id, datasource, null);
        if (mdiEntry != null) {
            if (onlyLoadOnce) {
                this.setEntryLoadedOnce(id);
            }
            if (activate) {
                this.showEntry(mdiEntry);
            }
            return true;
        }
        return false;
    }

    protected abstract void setEntryLoadedOnce(String var1);

    protected abstract boolean wasEntryLoadedOnce(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean entryExists(String id) {
        if ("browse".equalsIgnoreCase(id)) {
            id = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        }
        Map<String, MdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntry entry = this.mapIdToEntry.get(id);
            if (entry == null) {
                return false;
            }
            return entry.isAdded();
        }
    }

    @Override
    public void setEntryAutoOpen(String id, Object datasource) {
        LightHashMap map = (LightHashMap)this.mapAutoOpen.get(id);
        if (map == null) {
            map = new LightHashMap(1);
        }
        map.put("datasource", datasource);
        this.mapAutoOpen.put(id, map);
    }

    @Override
    public void removeEntryAutoOpen(String id) {
        this.mapAutoOpen.remove(id);
    }

    protected void setupPluginViews() {
        PluginsMenuHelper.getInstance().addPluginAddedViewListener(new PluginsMenuHelper.PluginAddedViewListener(){

            @Override
            public void pluginViewAdded(PluginsMenuHelper.IViewInfo viewInfo) {
                Object o = BaseMDI.this.mapAutoOpen.get(viewInfo.viewID);
                if (o instanceof Map) {
                    BaseMDI.this.processAutoOpenMap(viewInfo.viewID, (Map)o, viewInfo);
                }
            }
        });
    }

    @Override
    public void informAutoOpenSet(MdiEntry entry, Map<String, Object> autoOpenInfo) {
        this.mapAutoOpen.put(entry.getId(), autoOpenInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCloseables() {
        if (this.closeableConfigFile == null) {
            return;
        }
        try {
            Map loadedMap = FileUtil.readResilientConfigFile(this.closeableConfigFile, true);
            if (loadedMap.isEmpty()) {
                return;
            }
            BDecoder.decodeStrings(loadedMap);
            List orderedEntries = (List)loadedMap.get("_entries_");
            if (orderedEntries == null) {
                for (String id : loadedMap.keySet()) {
                    Object o = loadedMap.get(id);
                    if (!(o instanceof Map) || this.processAutoOpenMap(id, (Map)o, null)) continue;
                    this.mapAutoOpen.put(id, o);
                }
            } else {
                for (Map map : orderedEntries) {
                    String id = (String)map.get("id");
                    Object o = map.get("value");
                    if (!(o instanceof Map) || this.processAutoOpenMap(id, (Map)o, null)) continue;
                    this.mapAutoOpen.put(id, o);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        finally {
            this.mapAutoOpenLoaded = true;
        }
    }

    public void saveCloseables() {
        if (!this.mapAutoOpenLoaded) {
            return;
        }
        if (this.closeableConfigFile == null) {
            return;
        }
        try {
            for (String id : new ArrayList<String>(this.mapAutoOpen.keySet())) {
                MdiEntry entry = this.getEntry(id);
                if (entry != null && entry.isAdded()) {
                    this.mapAutoOpen.put(id, entry.getAutoOpenInfo());
                    continue;
                }
                this.mapAutoOpen.remove(id);
            }
            HashMap map = new HashMap();
            ArrayList list = new ArrayList(this.mapAutoOpen.size());
            map.put("_entries_", list);
            for (Map.Entry<String, Object> entry : this.mapAutoOpen.entrySet()) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                list.add(m);
                String id = entry.getKey();
                m.put("id", id);
                m.put("value", entry.getValue());
            }
            FileUtil.writeResilientConfigFile(this.closeableConfigFile, map);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private boolean processAutoOpenMap(String id, Map<?, ?> autoOpenInfo, PluginsMenuHelper.IViewInfo viewInfo) {
        try {
            MdiEntry entry = this.getEntry(id);
            if (entry != null) {
                return true;
            }
            Object datasource = autoOpenInfo.get("datasource");
            String title = MapUtils.getMapString(autoOpenInfo, "title", id);
            MdiEntry mdiEntry = this.createEntryByCreationListener(id, datasource, autoOpenInfo);
            if (mdiEntry != null) {
                if (mdiEntry.getTitle().equals("")) {
                    mdiEntry.setTitle(title);
                }
                return true;
            }
            String parentID = MapUtils.getMapString(autoOpenInfo, "parentID", "header.plugins");
            if (viewInfo != null && viewInfo.event_listener != null && (entry = this.createEntryFromEventListener(parentID, viewInfo.event_listener, id, true, datasource, null)) != null) {
                entry.setTitle(title);
            }
            if (entry != null && datasource == null) {
                final MdiEntry fEntry = entry;
                final String dmHash = MapUtils.getMapString(autoOpenInfo, "dm", null);
                if (dmHash != null) {
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        @Override
                        public void azureusCoreRunning(AzureusCore core) {
                            HashWrapper hw;
                            GlobalManager gm = core.getGlobalManager();
                            DownloadManager dm = gm.getDownloadManager(hw = new HashWrapper(Base32.decode(dmHash)));
                            if (dm != null) {
                                fEntry.setDatasource(dm);
                            }
                        }
                    });
                } else {
                    final List listHashes = MapUtils.getMapList(autoOpenInfo, "dms", null);
                    if (listHashes != null) {
                        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                            @Override
                            public void azureusCoreRunning(AzureusCore core) {
                                ArrayList<DownloadManager> listDMS = new ArrayList<DownloadManager>(1);
                                GlobalManager gm = core.getGlobalManager();
                                for (Object oDM : listHashes) {
                                    String hash;
                                    DownloadManager dm;
                                    if (oDM instanceof String && (dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash = (String)oDM)))) != null) {
                                        listDMS.add(dm);
                                    }
                                    fEntry.setDatasource(listDMS.toArray(new DownloadManager[0]));
                                }
                            }
                        });
                    }
                }
            }
            return entry != null;
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(MdiEntry entry) {
        String id = entry.getId();
        Map<String, MdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            this.mapIdToEntry.put(id, entry);
        }
    }

    protected void itemSelected(MdiEntry entry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItem(MdiEntry entry) {
        String id = entry.getId();
        Map<String, MdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            this.mapIdToEntry.remove(id);
            this.removeChildrenOf(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildrenOf(String id) {
        if (id == null) {
            return;
        }
        Map<String, MdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntrySWT[] entriesSWT;
            for (MdiEntrySWT entry : entriesSWT = this.getEntriesSWT()) {
                if (!id.equals(entry.getParentID())) continue;
                String kid_id = entry.getId();
                this.mapIdToEntry.remove(kid_id);
                this.removeChildrenOf(kid_id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MdiEntry> getChildrenOf(String id) {
        if (id == null) {
            return Collections.emptyList();
        }
        ArrayList<MdiEntry> list = new ArrayList<MdiEntry>(1);
        Map<String, MdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntrySWT[] entriesSWT;
            for (MdiEntrySWT entry : entriesSWT = this.getEntriesSWT()) {
                if (!id.equals(entry.getParentID())) continue;
                list.add(entry);
            }
        }
        return list;
    }

    @Override
    public Object updateLanguage(SWTSkinObject skinObject, Object params) {
        MdiEntry[] entries;
        for (MdiEntry entry : entries = this.getEntries()) {
            if (!(entry instanceof BaseMdiEntry)) continue;
            BaseMdiEntry baseEntry = (BaseMdiEntry)entry;
            baseEntry.updateLanguage();
        }
        return null;
    }

    @Override
    public void setPreferredOrder(String[] preferredOrder) {
        this.preferredOrder = preferredOrder;
    }

    @Override
    public String[] getPreferredOrder() {
        return this.preferredOrder == null ? new String[]{} : this.preferredOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEntriesCount() {
        Map<String, MdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            return this.mapIdToEntry.size();
        }
    }

    @Override
    public void setCloseableConfigFile(String closeableConfigFile) {
        this.closeableConfigFile = closeableConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MdiSWTMenuHackListener l) {
        BaseMDI baseMDI = this;
        synchronized (baseMDI) {
            if (this.listMenuHackListners == null) {
                this.listMenuHackListners = new ArrayList<MdiSWTMenuHackListener>(1);
            }
            if (!this.listMenuHackListners.contains(l)) {
                this.listMenuHackListners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MdiSWTMenuHackListener l) {
        BaseMDI baseMDI = this;
        synchronized (baseMDI) {
            if (this.listMenuHackListners == null) {
                this.listMenuHackListners = new ArrayList<MdiSWTMenuHackListener>(1);
            }
            this.listMenuHackListners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdiSWTMenuHackListener[] getMenuHackListeners() {
        BaseMDI baseMDI = this;
        synchronized (baseMDI) {
            if (this.listMenuHackListners == null) {
                return new MdiSWTMenuHackListener[0];
            }
            return this.listMenuHackListners.toArray(new MdiSWTMenuHackListener[0]);
        }
    }

    public void fillMenu(Menu menu, MdiEntry entry, String menuID) {
        MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray(menuID);
        MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{entry}));
        if (entry != null) {
            MdiSWTMenuHackListener[] menuHackListeners;
            PluginInterface pi;
            menu_items = MenuItemManager.getInstance().getAllAsArray("sidebar." + entry.getId());
            if (menu_items.length == 0 && entry instanceof UISWTView && (pi = ((UISWTView)((Object)entry)).getPluginInterface()) != null) {
                final ArrayList<String> relevant_sections = new ArrayList<String>();
                ArrayList<ConfigSectionHolder> sections = ConfigSectionRepository.getInstance().getHolderList();
                for (ConfigSectionHolder cs : sections) {
                    if (pi != cs.getPluginInterface()) continue;
                    relevant_sections.add(cs.configSectionGetName());
                }
                if (relevant_sections.size() > 0) {
                    MenuItem mi = pi.getUIManager().getMenuManager().addMenuItem("sidebar." + entry.getId(), "MainWindow.menu.view.configuration");
                    mi.addListener(new MenuItemListener(){

                        @Override
                        public void selected(MenuItem menu, Object target) {
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif != null) {
                                for (String s : relevant_sections) {
                                    uif.getMDI().showEntryByID("ConfigView", s);
                                }
                            }
                        }
                    });
                    menu_items = MenuItemManager.getInstance().getAllAsArray("sidebar." + entry.getId());
                }
            }
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{entry}));
            for (MdiSWTMenuHackListener l : menuHackListeners = this.getMenuHackListeners()) {
                try {
                    l.menuWillBeShown(entry, menu);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            if (this.currentEntry instanceof SideBarEntrySWT) {
                for (MdiSWTMenuHackListener l : menuHackListeners = ((SideBarEntrySWT)entry).getMenuHackListeners()) {
                    try {
                        l.menuWillBeShown(entry, menu);
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
            }
        }
        if ((menu_items = MenuItemManager.getInstance().getAllAsArray(menuID + "._end_")).length > 0) {
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{entry}));
        }
    }
}

