/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.feature;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesLoadedListener;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerInstallWindow;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SBC_BurnFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.util.FeatureUtils;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class FeatureManagerUIListener
implements FeatureManager.FeatureManagerListener {
    private static final boolean DEBUG = Constants.IS_CVS_VERSION;
    private static final String ID_ACTIVITY_EXPIRING = "ExpiringEntry";
    private static final String ID_ACTIVITY_OFFLINE = "OfflineExpiredEntry";
    private static final String ID_ACTIVITY_EXPIRED = "ExpiredEntry";
    private final FeatureManager featman;
    private String pendingAuthForKey;
    private Map<String, Object[]> licence_map = new HashMap<String, Object[]>();

    public FeatureManagerUIListener(FeatureManager featman) {
        if (DEBUG) {
            System.out.println("FEAT:");
        }
        this.featman = featman;
    }

    @Override
    public void licenceAdded(FeatureManager.Licence licence) {
        this.updateUI();
        this.mapLicence(licence);
        if (DEBUG) {
            System.out.println("FEAT: Licence " + licence.getKey() + " Added with state " + licence.getState());
        }
        if (licence.getState() == 1) {
            this.pendingAuthForKey = licence.getKey();
            FeatureManagerUI.openLicenceValidatingWindow();
        }
        if (licence.isFullyInstalled()) {
            return;
        }
        licence.retryInstallation();
    }

    @Override
    public void licenceChanged(FeatureManager.Licence licence) {
        int state = licence.getState();
        boolean stateChanged = true;
        FeatureManager.Licence lastLicence = this.mapLicence(licence);
        if (lastLicence != null) {
            boolean bl = stateChanged = lastLicence.getState() != licence.getState();
            if (!stateChanged && licence.getState() == 2 && lastLicence.isFullyInstalled() != licence.isFullyInstalled()) {
                stateChanged = true;
            }
        } else if (state == 4 || state == 5 || state == 6) {
            stateChanged = false;
        }
        this.updateUI();
        if (DEBUG) {
            System.out.println("FEAT: License " + licence.getKey() + " State Changed: " + state + "; changed? " + stateChanged);
        }
        if (!stateChanged) {
            return;
        }
        if (state == 1) {
            this.pendingAuthForKey = licence.getKey();
            FeatureManagerUI.openLicenceValidatingWindow();
        } else {
            FeatureManagerUI.closeLicenceValidatingWindow();
            if (state == 2) {
                if (licence.getKey().equals(this.pendingAuthForKey) && licence.isFullyInstalled()) {
                    this.pendingAuthForKey = null;
                    FeatureManagerUI.openLicenceSuccessWindow();
                }
            } else if (state == 3) {
                FeatureManagerUI.openLicenceFailedWindow(state, licence.getKey());
                if (licence.getKey().equals(this.pendingAuthForKey)) {
                    this.pendingAuthForKey = null;
                }
            } else if (state == 5) {
                FeatureManagerUI.openLicenceRevokedWindow(licence);
            } else if (state == 6) {
                FeatureManagerUI.openLicenceActivationDeniedWindow(licence);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureManager.Licence mapLicence(FeatureManager.Licence licence) {
        FeatureManager.Licence existing_licence;
        FeatureManager.Licence.LicenceInstallationListener new_listener = null;
        Map<String, Object[]> map = this.licence_map;
        synchronized (map) {
            String key = licence.getKey();
            Object[] entry = this.licence_map.get(key);
            if (entry == null) {
                existing_licence = null;
                new_listener = new FeatureManager.Licence.LicenceInstallationListener(){
                    FeatureManagerInstallWindow install_window = null;
                    public boolean alreadyFailing = false;

                    @Override
                    public void start(String licence_key) {
                        if (DEBUG) {
                            System.out.println("FEATINST: START! " + licence_key);
                        }
                        try {
                            FeatureManager.Licence licence = FeatureManagerUIListener.this.featman.addLicence(licence_key);
                            this.install_window = new FeatureManagerInstallWindow(licence);
                            this.install_window.open();
                        }
                        catch (PluginException e) {
                            Debug.out(e);
                        }
                    }

                    @Override
                    public void reportProgress(String licenceKey, String install, int percent) {
                        if (DEBUG) {
                            System.out.println("FEATINST: " + install + ": " + percent);
                        }
                    }

                    @Override
                    public void reportActivity(String licenceKey, String install, String activity) {
                        if (DEBUG) {
                            System.out.println("FEAT: ACTIVITY: " + install + ": " + activity);
                        }
                    }

                    @Override
                    public void failed(String licenceKey, PluginException error) {
                        if (DEBUG) {
                            System.out.println("FEAT: FAIL: " + licenceKey + ": " + error.toString());
                        }
                        if (this.install_window != null) {
                            this.install_window.close();
                        }
                        if (licenceKey.equals(FeatureManagerUIListener.this.pendingAuthForKey)) {
                            FeatureManagerUIListener.this.pendingAuthForKey = null;
                        }
                        if (this.alreadyFailing) {
                            return;
                        }
                        this.alreadyFailing = true;
                        String s = Debug.getNestedExceptionMessage(error);
                        MessageBoxShell mb = new MessageBoxShell(33, "License Addition Error for " + licenceKey, s);
                        mb.open(new UserPrompterResultListener(){

                            @Override
                            public void prompterClosed(int result) {
                                alreadyFailing = false;
                            }
                        });
                    }

                    @Override
                    public void complete(String licenceKey) {
                        if (licenceKey.equals(FeatureManagerUIListener.this.pendingAuthForKey)) {
                            FeatureManagerUIListener.this.pendingAuthForKey = null;
                            FeatureManagerUI.openLicenceSuccessWindow();
                        }
                    }
                };
                this.licence_map.put(key, new Object[]{licence, new_listener});
            } else {
                existing_licence = (FeatureManager.Licence)entry[0];
                entry[0] = licence;
            }
        }
        if (new_listener != null) {
            licence.addInstallationListener(new_listener);
        }
        return existing_licence;
    }

    private void updateUI() {
        PluginInterface plugin_interface = PluginInitializer.getDefaultInterface();
        UIManager ui_manager = plugin_interface.getUIManager();
        ui_manager.addUIListener(new UIManagerListener(){

            @Override
            public void UIDetached(UIInstance instance) {
            }

            @Override
            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    FeatureManagerUIListener.this._updateUI();
                }
            }
        });
    }

    private void _updateUI() {
        MdiEntry entry;
        UIFunctions uif;
        MultipleDocumentInterface mdi;
        final boolean hasFullLicence = FeatureUtils.hasPlusLicence();
        try {
            FeatureManagerUIListener.buildNotifications();
        }
        catch (Exception e) {
            Debug.out(e);
        }
        SWTSkin skin = SWTSkinFactory.getInstance();
        if (skin != null) {
            SWTSkinObject soHeader = skin.getSkinObject("plus-header");
            if (soHeader != null) {
                soHeader.setVisible(hasFullLicence);
            }
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    uif.getMainShell().setText(hasFullLicence ? UIFunctions.MAIN_WINDOW_NAME_PLUS : UIFunctions.MAIN_WINDOW_NAME);
                }
            });
        }
        if ((mdi = (uif = UIFunctionsManager.getUIFunctions()).getMDI()) != null && (entry = mdi.getEntry("Plus")) != null) {
            SkinView[] views;
            entry.setTitleID(hasFullLicence ? "mdi.entry.plus.full" : "mdi.entry.plus.free");
            SBC_PlusFTUX view = (SBC_PlusFTUX)SkinViewManager.getByClass(SBC_PlusFTUX.class);
            if (view != null) {
                view.updateLicenceInfo();
            }
            if ((views = SkinViewManager.getMultiByClass(SBC_BurnFTUX.class)) != null) {
                for (SkinView bview : views) {
                    ((SBC_BurnFTUX)bview).updateLicenceInfo();
                }
            }
        }
    }

    public static void buildNotifications() {
        VuzeActivitiesManager.addListener(new VuzeActivitiesLoadedListener(){

            @Override
            public void vuzeActivitiesLoaded() {
                FeatureManagerUIListener._buildNotifications();
            }
        });
    }

    private static void _buildNotifications() {
        String id;
        String s;
        FeatureUtils.licenceDetails details = FeatureUtils.getPlusOrNoAdFeatureDetails();
        if (details == null) {
            return;
        }
        long displayExpiryTimeStamp = details.getExpiryDisplayTimeStamp();
        long expiryTimeStamp = details.getExpiryTimeStamp();
        if (expiryTimeStamp <= 0L) {
            return;
        }
        long msDisplayLeft = displayExpiryTimeStamp - SystemTime.getCurrentTime();
        long daysDisplayLeft = (long)Math.ceil((double)msDisplayLeft / 8.64E7);
        long msLeft = expiryTimeStamp - SystemTime.getCurrentTime();
        long daysLeft = (long)Math.ceil((double)msLeft / 8.64E7);
        if (daysLeft > 30L || daysDisplayLeft > 30L) {
            VuzeActivitiesEntry entry1 = VuzeActivitiesManager.getEntryByID(ID_ACTIVITY_EXPIRED);
            VuzeActivitiesEntry entry2 = VuzeActivitiesManager.getEntryByID(ID_ACTIVITY_EXPIRING);
            VuzeActivitiesEntry entry3 = VuzeActivitiesManager.getEntryByID(ID_ACTIVITY_OFFLINE);
            if (entry1 != null || entry2 != null || entry3 != null) {
                VuzeActivitiesManager.removeEntries(new VuzeActivitiesEntry[]{entry1, entry2, entry3}, true);
            }
            return;
        }
        String ref = "plus_note_" + (daysDisplayLeft >= 0L ? "expiring_" : "expired_") + Math.abs(daysDisplayLeft);
        String strA = "TARGET=\"Plus\" HREF=\"#" + ref + "\"";
        if (daysLeft < 0L && daysDisplayLeft > 0L) {
            VuzeActivitiesEntry entry1 = VuzeActivitiesManager.getEntryByID(ID_ACTIVITY_EXPIRED);
            VuzeActivitiesEntry entry2 = VuzeActivitiesManager.getEntryByID(ID_ACTIVITY_EXPIRING);
            if (entry1 != null || entry2 != null) {
                VuzeActivitiesManager.removeEntries(new VuzeActivitiesEntry[]{entry1, entry2}, true);
            }
            String msgID = "plus.notificaiton.OfflineExpiredEntry";
            s = MessageText.getString(msgID, new String[]{"" + daysDisplayLeft});
            id = ID_ACTIVITY_OFFLINE;
        } else {
            String msgID;
            VuzeActivitiesEntry entry3 = VuzeActivitiesManager.getEntryByID(ID_ACTIVITY_OFFLINE);
            if (entry3 != null) {
                VuzeActivitiesManager.removeEntries(new VuzeActivitiesEntry[]{entry3}, true);
            }
            if (daysDisplayLeft > 0L) {
                msgID = "plus.notificaiton.ExpiringEntry" + (daysDisplayLeft == 1L ? ".s" : ".p");
                s = MessageText.getString(msgID, new String[]{"" + daysDisplayLeft, strA});
                id = ID_ACTIVITY_EXPIRING;
            } else {
                msgID = "plus.notificaiton.ExpiredEntry" + (daysDisplayLeft == -1L ? ".s" : ".p");
                s = MessageText.getString(msgID, new String[]{"" + -daysDisplayLeft, strA});
                id = ID_ACTIVITY_EXPIRED;
            }
        }
        VuzeActivitiesEntry entry = VuzeActivitiesManager.getEntryByID(id);
        if (entry == null) {
            boolean existed = VuzeActivitiesManager.isEntryIdRemoved(id);
            if (existed) {
                return;
            }
            entry = new VuzeActivitiesEntry(SystemTime.getCurrentTime(), s, "VUZE_NEWS_ITEM");
            entry.setID(id);
            entry.setIconID("image.sidebar.plus");
            if (daysLeft < 0L && daysDisplayLeft < 0L) {
                UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("Plus");
            }
        } else {
            entry.setText(s);
            entry.setTimestamp(SystemTime.getCurrentTime());
        }
        VuzeActivitiesManager.addEntries(new VuzeActivitiesEntry[]{entry});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void licenceRemoved(FeatureManager.Licence licence) {
        Object[] entry;
        Map<String, Object[]> map = this.licence_map;
        synchronized (map) {
            entry = this.licence_map.remove(licence.getKey());
        }
        if (entry != null) {
            licence.removeInstallationListener((FeatureManager.Licence.LicenceInstallationListener)entry[1]);
        }
        this.updateUI();
    }
}

