/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices.columns;

import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.util.DataSourceUtils;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;

public class ColumnTJ_Name
implements TableCellRefreshListener,
ObfusticateCellText,
TableCellDisposeListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "transcode_name";

    public ColumnTJ_Name(TableColumn column) {
        column.initialize(1, -2, 215);
        column.addListeners(this);
        column.setObfustication(true);
        column.setRefreshInterval(-1);
        column.setType(3);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        TranscodeFile tf = (TranscodeFile)cell.getDataSource();
        if (tf == null) {
            return;
        }
        String text = tf.getName();
        if (text == null || text.length() == 0) {
            return;
        }
        cell.setText(text);
    }

    @Override
    public String getObfusticatedText(TableCell cell) {
        int i;
        String name = null;
        DownloadManager dm = DataSourceUtils.getDM(cell.getDataSource());
        if (dm != null && (i = (name = dm.toString()).indexOf(35)) > 0) {
            name = name.substring(i + 1);
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    @Override
    public void dispose(TableCell cell) {
    }
}

